/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.hosts.GitHosts;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.fetch.GitServer;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GitServersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List<HostSpec> hosts = new ArrayList<HostSpec>();
    private TableViewer table;

    public GitServersPreferencePage() {
        this.setDescription(UIText.GitServersPreferencePage_Description);
        this.noDefaultButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)main);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(main);
        Composite tableContainer = new Composite(main, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        TableColumnLayout layout = new TableColumnLayout();
        tableContainer.setLayout((Layout)layout);
        this.table = new TableViewer(tableContainer, 67586);
        Composite buttonContainer = new Composite(main, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 1).grab(false, true).applyTo((Control)buttonContainer);
        GridLayoutFactory.fillDefaults().applyTo(buttonContainer);
        Button add = new Button(buttonContainer, 8);
        add.setText(UIText.GitServersPreferencePage_AddLabel);
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitServersPreferencePage.this.addNew();
            }
        });
        this.setButtonLayoutData(add);
        final Button remove = new Button(buttonContainer, 8);
        remove.setText(UIText.GitServersPreferencePage_RemoveLabel);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GitServersPreferencePage.this.removeSelected();
            }
        });
        this.setButtonLayoutData(remove);
        this.table.addSelectionChangedListener(event -> remove.setEnabled(!this.table.getSelection().isEmpty()));
        this.table.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 127 && remove.isEnabled()) {
                    GitServersPreferencePage.this.removeSelected();
                }
            }
        });
        this.table.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn serverColumn = new TableViewerColumn(this.table, 0);
        serverColumn.getColumn().setMoveable(false);
        serverColumn.getColumn().setResizable(false);
        serverColumn.getColumn().setText(UIText.GitServersPreferencePage_ServerTitle);
        serverColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HostSpec) {
                    GitServer server = ((HostSpec)element).serverType;
                    return server == null ? UIText.GitServersPreferencePage_ServerUndefined : server.getName();
                }
                return null;
            }
        });
        serverColumn.setEditingSupport((EditingSupport)new ServerEditingSupport(this.table));
        TableViewerColumn patternColumn = new TableViewerColumn(this.table, 0);
        patternColumn.getColumn().setMoveable(false);
        patternColumn.getColumn().setResizable(false);
        patternColumn.getColumn().setText(UIText.GitServersPreferencePage_PatternTitle);
        patternColumn.getColumn().setToolTipText(UIText.GitServersPreferencePage_PatternTooltip);
        patternColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof HostSpec) {
                    return ((HostSpec)element).hostPattern;
                }
                return null;
            }
        });
        patternColumn.setEditingSupport((EditingSupport)new PatternEditingSupport(this.table, msg -> {
            this.setErrorMessage((String)msg);
            this.setValid(msg == null);
        }));
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.loadHosts();
        this.table.setInput(this.hosts);
        serverColumn.getColumn().pack();
        patternColumn.getColumn().pack();
        layout.setColumnData((Widget)patternColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, patternColumn.getColumn().getWidth(), false));
        layout.setColumnData((Widget)serverColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, serverColumn.getColumn().getWidth() + 20, false));
        return main;
    }

    private void removeSelected() {
        this.table.applyEditorValue();
        this.hosts.removeAll(this.table.getStructuredSelection().toList());
        this.table.refresh();
    }

    private void addNew() {
        this.table.applyEditorValue();
        this.hosts.add(new HostSpec());
        this.table.refresh();
    }

    private void loadHosts() {
        String rawData = this.getPreferenceStore().getString("core_git_servers");
        GitHosts.loadFromPreferences((String)rawData, (s, p) -> this.hosts.add(new HostSpec(GitServer.valueOf(s), (String)p)));
    }

    private void saveHosts() {
        StringBuilder builder = new StringBuilder();
        for (HostSpec host : this.hosts) {
            if (host.serverType == null || StringUtils.isEmptyOrNull((String)host.hostPattern)) continue;
            builder.append(host.serverType.name()).append('\t').append(host.hostPattern).append('\n');
        }
        this.getPreferenceStore().putValue("core_git_servers", builder.toString());
    }

    public IPreferenceStore doGetPreferenceStore() {
        return new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.egit.core");
    }

    public boolean performOk() {
        this.table.applyEditorValue();
        this.saveHosts();
        return super.performOk();
    }

    private static class HostSpec {
        GitServer serverType;
        String hostPattern;

        HostSpec() {
            this(null, "");
        }

        HostSpec(GitServer server, String pattern) {
            this.serverType = server;
            this.hostPattern = pattern;
        }

        public String toString() {
            return "<" + (Object)((Object)this.serverType) + ' ' + this.hostPattern + '>';
        }
    }

    private static class PatternEditingSupport
    extends EditingSupport {
        private final TextCellEditor editor;

        public PatternEditingSupport(TableViewer viewer, final Consumer<String> reportError) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable()){
                private boolean assisting;
                {
                    super($anonymous0);
                    this.assisting = false;
                }

                protected Control createControl(Composite parent) {
                    Control control = super.createControl(parent);
                    this.text.addVerifyListener(event -> {
                        String string = event.text = Utils.firstLine((String)event.text);
                    });
                    this.addListener(new ICellEditorListener(){

                        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                            reportError.accept(newValidState ? null : this.getErrorMessage());
                        }

                        public void cancelEditor() {
                            reportError.accept(null);
                        }

                        public void applyEditorValue() {
                            reportError.accept(null);
                        }
                    });
                    TextContentAdapter contentAdapter = new TextContentAdapter();
                    FindReplaceDocumentAdapterContentProposalProvider proposalProvider = new FindReplaceDocumentAdapterContentProposalProvider(true);
                    ContentAssistCommandAdapter proposer = new ContentAssistCommandAdapter((Control)this.text, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
                    proposer.addContentProposalListener(new IContentProposalListener2(){

                        public void proposalPopupClosed(ContentProposalAdapter adapter) {
                            assisting = false;
                        }

                        public void proposalPopupOpened(ContentProposalAdapter adapter) {
                            assisting = true;
                        }
                    });
                    proposer.setEnabled(true);
                    return control;
                }

                protected void focusLost() {
                    if (!this.assisting) {
                        super.focusLost();
                    }
                }

                public void deactivate() {
                    super.deactivate();
                    reportError.accept(null);
                }

                protected boolean dependsOnExternalFocusListener() {
                    return false;
                }
            };
            this.editor.setValidator(object -> {
                try {
                    Pattern.compile(object.toString());
                }
                catch (PatternSyntaxException e) {
                    return Utils.firstLine((String)e.getLocalizedMessage());
                }
                return "";
            });
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            return ((HostSpec)element).hostPattern;
        }

        protected void setValue(Object element, Object value) {
            ((HostSpec)element).hostPattern = value.toString();
            this.getViewer().update(element, null);
        }
    }

    private static class ServerEditingSupport
    extends EditingSupport {
        private final Map<String, GitServer> servers = new HashMap<String, GitServer>();
        private final String[] items;
        private final ComboBoxCellEditor editor;

        ServerEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            GitServer[] gitServerArray = GitServer.values();
            int n = gitServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                GitServer s = gitServerArray[n2];
                this.servers.put(s.getName(), s);
                ++n2;
            }
            this.items = this.servers.keySet().stream().sorted().collect(Collectors.toList()).toArray(new String[0]);
            this.editor = new ComboBoxCellEditor((Composite)viewer.getTable(), this.items, 8);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected Object getValue(Object element) {
            if (((HostSpec)element).serverType == null) {
                return 0;
            }
            String name = ((HostSpec)element).serverType.getName();
            int i = 0;
            while (i < this.items.length) {
                if (name.equals(this.items[i])) {
                    return i;
                }
                ++i;
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            int index;
            if (value instanceof Integer && (index = ((Integer)value).intValue()) >= 0) {
                ((HostSpec)element).serverType = this.servers.get(this.items[index]);
                this.getViewer().update(element, null);
            }
        }
    }
}

