/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.fb.interpreter.OpSem.EventManager;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class ServiceSequenceSaveAndLoadHelper {
    private static final String FILE_EXTENSION = ".EvntMngr.opsem";
    private static final String FOLDER_NAME = "traces";

    public static void saveServiceSequence(FBType fbtype, ServiceSequence seq) {
        ServiceSequenceSaveAndLoadHelper.saveServiceSequences(fbtype, new ArrayList<ServiceSequence>(Arrays.asList(seq)));
    }

    public static void saveServiceSequences(FBType fbtype, List<ServiceSequence> seqs) {
        IFile file;
        IProject project = fbtype.getTypeEntry().getFile().getProject();
        IFolder folder = project.getFolder(FOLDER_NAME);
        if (!folder.exists()) {
            try {
                folder.create(false, false, null);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage());
            }
        }
        if ((file = folder.getFile(fbtype.getName() + FILE_EXTENSION)).exists()) {
            List<ServiceSequence> seqsFromFile = ServiceSequenceSaveAndLoadHelper.loadServiceSequencesFromFile(fbtype);
            seqs.forEach(seq -> {
                if (!seqsFromFile.contains(seq)) {
                    seqsFromFile.add((ServiceSequence)seq);
                }
            });
        }
        ServiceSequenceSaveAndLoadHelper.saveServiceSequenceToFile(fbtype, seqs);
    }

    private static void saveServiceSequenceToFile(FBType fbtype, List<ServiceSequence> seqs) {
        ResourceSetImpl reset = new ResourceSetImpl();
        IProject project = fbtype.getTypeEntry().getFile().getProject();
        IFolder folder = project.getFolder(FOLDER_NAME);
        if (!folder.exists()) {
            try {
                folder.create(false, false, null);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage());
            }
        }
        IFile file = folder.getFile(fbtype.getName() + FILE_EXTENSION);
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource res = reset.createResource(uri);
        res.getContents().addAll(seqs);
        reset.getResources().add((Object)fbtype.eResource());
        try {
            res.save(Collections.emptyMap());
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)e.getMessage());
        }
    }

    public static List<ServiceSequence> loadServiceSequencesFromFile(FBType fbtype) {
        IFile file;
        ResourceSetImpl reset = new ResourceSetImpl();
        IProject project = fbtype.getTypeEntry().getFile().getProject();
        IFolder folder = project.getFolder(FOLDER_NAME);
        ArrayList<ServiceSequence> serviceSequences = new ArrayList<ServiceSequence>();
        if (folder.exists() && (file = folder.getFile(fbtype.getName() + FILE_EXTENSION)).exists()) {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource res = reset.getResource(uri, true);
            res.getContents().forEach(con -> {
                if (con instanceof ServiceSequence) {
                    ServiceSequence seqs = (ServiceSequence)con;
                    serviceSequences.add(seqs);
                }
            });
        }
        return serviceSequences;
    }

    public static EventManager loadEventManagerFromServiceSequenceFile(FBType fbtype, ServiceSequence seqToFind) {
        List<ServiceSequence> seqs = ServiceSequenceSaveAndLoadHelper.loadServiceSequencesFromFile(fbtype);
        for (ServiceSequence seq : seqs) {
            EObject eObject;
            if (!seq.getName().equals(seqToFind.getName()) || seq.getEventManager() == null || !((eObject = seq.getEventManager()) instanceof EventManager)) continue;
            EventManager evntMngr = (EventManager)eObject;
            return evntMngr;
        }
        return null;
    }

    public static void removeServiceSequenceFromFile(FBType fbtype, ServiceSequence seq) {
        List<ServiceSequence> serviceSequences = ServiceSequenceSaveAndLoadHelper.loadServiceSequencesFromFile(fbtype);
        serviceSequences.removeIf(s -> s.getName().equals(seq.getName()));
        ServiceSequenceSaveAndLoadHelper.saveServiceSequenceToFile(fbtype, serviceSequences);
    }
}

