/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.iec61499.handlers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.fordiac.ide.deployment.IDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.iec61499.Messages;
import org.eclipse.fordiac.ide.deployment.iec61499.preferences.IEC61499PreferenceConstants;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class EthernetDeviceManagementCommunicationHandler
implements IDeviceManagementCommunicationHandler {
    private static final int ASN1_TAG_IECSTRING = 80;
    private MgrInformation mgrInfo;
    private Socket socket;
    private DataOutputStream outputStream;
    private DataInputStream inputStream;
    private static final int LOWER_INVALID_PORT = 1023;
    private static final int UPPER_INVALID_PORT = 65536;
    private static final long MS_SLEEP_IN_DISCONNECT = 50L;

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isClosed();
    }

    public void connect(String address) throws DeploymentException {
        this.mgrInfo = EthernetDeviceManagementCommunicationHandler.getValidMgrInformation(address);
        this.socket = new Socket();
        int timeout = IEC61499PreferenceConstants.getConnectionTimeout();
        InetSocketAddress sockaddr = new InetSocketAddress(this.mgrInfo.iP, this.mgrInfo.port);
        try {
            this.socket.connect(sockaddr, timeout);
            this.socket.setSoTimeout(timeout);
            this.outputStream = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.inputStream = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            throw new DeploymentException(Messages.EthernetDeviceManagementCommunicationHandler_CouldNotConnectToDevice, (Throwable)e);
        }
    }

    public void disconnect() throws DeploymentException {
        try {
            this.outputStream.close();
            this.inputStream.close();
            this.socket.close();
            Thread.sleep(50L);
        }
        catch (IOException e) {
            throw new DeploymentException(Messages.DeploymentExecutor_DisconnectFailed, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private String handleResponse() throws IOException {
        this.inputStream.readByte();
        int size = this.inputStream.readUnsignedShort();
        StringBuilder response = new StringBuilder(size);
        int i = 0;
        while (i < size) {
            response.append((char)this.inputStream.readByte());
            ++i;
        }
        return response.toString();
    }

    public String getInfo(String destination) {
        Object info = this.mgrInfo.toString();
        if (!"".equals(destination)) {
            info = (String)info + ": " + destination;
        }
        return info;
    }

    public String sendREQ(String destination, String request) throws IOException {
        String response = "";
        if (this.outputStream != null && this.inputStream != null) {
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(destination.length());
            this.outputStream.writeBytes(destination);
            this.outputStream.writeByte(80);
            this.outputStream.writeShort(request.length());
            this.outputStream.writeBytes(request);
            this.outputStream.flush();
            response = this.handleResponse();
        }
        return response;
    }

    private static MgrInformation getValidMgrInformation(String mgrID) throws DeploymentException {
        if (mgrID != null) {
            String id = EthernetDeviceManagementCommunicationHandler.trimQuoutes(mgrID);
            String[] splitID = id.split(":");
            MgrInformation mgrInfo = new MgrInformation();
            if (splitID.length == 2) {
                int port;
                try {
                    InetAddress adress = InetAddress.getByName(splitID[0]);
                    mgrInfo.iP = adress.getHostAddress();
                    port = Integer.parseInt(splitID[1]);
                }
                catch (NumberFormatException | UnknownHostException e) {
                    throw new DeploymentException(MessageFormat.format(Messages.EthernetComHandler_InvalidMgmtID, mgrID), (Throwable)e);
                }
                if (1023 < port && port < 65536) {
                    mgrInfo.port = port;
                    return mgrInfo;
                }
            }
        }
        throw new DeploymentException(MessageFormat.format(Messages.EthernetComHandler_InvalidMgmtID, mgrID));
    }

    private static String trimQuoutes(String toTrim) {
        String id = toTrim;
        if (id.startsWith("\"")) {
            id = id.substring(1, id.length());
        }
        if (id.endsWith("\"")) {
            id = id.substring(0, id.length() - 1);
        }
        return id;
    }

    private static class MgrInformation {
        private String iP;
        private int port;

        private MgrInformation() {
        }

        public String toString() {
            return this.iP + ":" + this.port;
        }
    }
}

