/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.wizards;

import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.ui.editors.DataTypeTreeSelectionDialog;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeNode;
import org.eclipse.fordiac.ide.typemanagement.refactoring.connection.ConnectionsToStructRefactoring;
import org.eclipse.fordiac.ide.typemanagement.wizards.Messages;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ConnectionsToStructWizardPage
extends UserInputWizardPage {
    private Text structNameText;
    private Text sourceNameText;
    private Text destinationNameText;
    private Button existingStructButton;
    private Button conflictButton;
    StructuredType structType;

    public ConnectionsToStructWizardPage() {
        super(Messages.ConnectionsToStructWizardPage_Title);
        this.setDescription(Messages.ConnectionsToStructWizardPage_Description);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        this.setErrorMessage(null);
        this.setMessage(null);
        GridData containerData = new GridData();
        containerData.horizontalAlignment = 4;
        containerData.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)containerData);
        GridLayout gridl = new GridLayout();
        gridl.numColumns = 3;
        container.setLayout((Layout)gridl);
        Button newStructButton = new Button(container, 16);
        newStructButton.setText(Messages.ConnectionsToStructWizardPage_NewType);
        Label structNameLabel = new Label(container, 0);
        structNameLabel.setText(Messages.ConnectionsToStructWizardPage_Name + ":");
        this.structNameText = new Text(container, 2052);
        this.existingStructButton = new Button(container, 16);
        this.existingStructButton.setText(Messages.ConnectionsToStructWizardPage_ExistingStruct);
        Button structButton = new Button(container, 0);
        structButton.setText("&...");
        Text existingStructText = new Text(container, 2052);
        existingStructText.setText(Messages.ConnectionsToStructWizardPage_AnyStruct);
        Label sourceNameLabel = new Label(container, 0);
        sourceNameLabel.setText(Messages.ConnectionsToStructWizardPage_OutName + ":");
        this.sourceNameText = new Text(container, 2052);
        Label destinationNameLabel = new Label(container, 0);
        destinationNameLabel.setText(Messages.ConnectionsToStructWizardPage_InName + ":");
        this.destinationNameText = new Text(container, 2048);
        GridData textGridData = new GridData();
        textGridData.horizontalAlignment = 4;
        textGridData.grabExcessHorizontalSpace = true;
        this.structNameText.setLayoutData((Object)textGridData);
        existingStructText.setLayoutData((Object)textGridData);
        GridData textGridDataSpan = new GridData();
        textGridDataSpan.horizontalAlignment = 4;
        textGridDataSpan.grabExcessHorizontalSpace = true;
        textGridDataSpan.horizontalSpan = 2;
        this.sourceNameText.setLayoutData((Object)textGridDataSpan);
        this.destinationNameText.setLayoutData((Object)textGridDataSpan);
        this.conflictButton = new Button(container, 32);
        this.conflictButton.setText(Messages.ConnectionsToStructWizardPage_SolveConflicts);
        this.conflictButton.setSelection(true);
        GridData checkboxGridData = new GridData();
        checkboxGridData.horizontalSpan = 2;
        this.conflictButton.setLayoutData((Object)checkboxGridData);
        this.structNameText.addModifyListener(e -> this.handleInputChanged());
        this.sourceNameText.addModifyListener(e -> this.handleInputChanged());
        this.destinationNameText.addModifyListener(e -> this.handleInputChanged());
        this.conflictButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleInputChanged()));
        this.existingStructButton.addListener(13, event -> {
            if (this.existingStructButton.getSelection()) {
                this.structNameText.setEnabled(false);
                structButton.setEnabled(true);
            } else {
                this.structNameText.setEnabled(true);
                structButton.setEnabled(false);
            }
            this.handleInputChanged();
        });
        structButton.addListener(13, event -> {
            LibraryElement libraryElement;
            TypeNode node;
            Object object;
            DataTypeSelectionTreeContentProvider instance = DataTypeSelectionTreeContentProvider.INSTANCE;
            DataTypeTreeSelectionDialog dialog = new DataTypeTreeSelectionDialog(this.getShell(), (ITreeContentProvider)instance);
            dialog.setInput((Object)this.getConnectionsToStructRefactoring().getTypeLibrary());
            if (dialog.open() == 0 && (object = dialog.getFirstResult()) instanceof TypeNode && !(node = (TypeNode)object).isDirectory() && (libraryElement = node.getType()) instanceof StructuredType) {
                StructuredType selType;
                this.structType = selType = (StructuredType)libraryElement;
                existingStructText.setText(selType.getName());
                this.handleInputChanged();
            }
        });
        this.structNameText.setFocus();
        newStructButton.setSelection(true);
        structButton.setEnabled(false);
        existingStructText.setEnabled(false);
    }

    private void handleInputChanged() {
        URI structURI;
        RefactoringStatus status = new RefactoringStatus();
        ConnectionsToStructRefactoring refactoring = this.getConnectionsToStructRefactoring();
        if (this.existingStructButton.getSelection()) {
            structURI = this.structType != null ? EcoreUtil.getURI((EObject)this.structType) : null;
        } else {
            if (IdentifierVerifier.verifyIdentifier((String)this.structNameText.getText()).isPresent()) {
                status.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.ConnectionsToStructWizardPage_InvalidStructName));
            }
            structURI = URI.createPlatformResourceURI((String)(String.valueOf(this.getConnectionsToStructRefactoring().getTypeLibrary().getProject().getFullPath()) + File.separator + "Type Library" + File.separator + this.structNameText.getText() + ".dtp"), (boolean)true);
        }
        status.merge(refactoring.setUserConfig(structURI, this.sourceNameText.getText(), this.destinationNameText.getText(), this.conflictButton.getSelection()));
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }

    private ConnectionsToStructRefactoring getConnectionsToStructRefactoring() {
        return (ConnectionsToStructRefactoring)this.getRefactoring();
    }
}

