/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateTypeEntryChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameUpdateFBTypeInterfaceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameUpdateStructDataTypeMemberVariableChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class RenameTypeRefactoringParticipant
extends RenameParticipant {
    private IFile file;
    private TypeEntry typeEntry;
    private String oldName;
    private String newName;

    protected boolean initialize(Object element) {
        IFile targetFile;
        if (element instanceof IFile && TypeLibraryManager.INSTANCE.getTypeEntryForFile(targetFile = (IFile)element) != null) {
            this.file = targetFile;
            this.typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(targetFile);
            this.oldName = this.typeEntry.getTypeName();
            this.newName = TypeEntry.getTypeNameFromFileName((String)this.getArguments().getNewName());
            return true;
        }
        return false;
    }

    public String getName() {
        return Messages.RenameType_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            monitor.beginTask("Checking preconditions...", 1);
            this.checkFileEnding(status);
            this.checkFileName(status);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    protected void checkFileEnding(RefactoringStatus result) {
        if (!this.getArguments().getNewName().endsWith(this.file.getFileExtension())) {
            result.addFatalError("The file-ending is different to the old one!");
        }
    }

    protected void checkFileName(RefactoringStatus result) {
        if (!this.oldName.equalsIgnoreCase(this.newName)) {
            try {
                String name = this.getArguments().getNewName();
                IResource[] iResourceArray = this.file.getParent().members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (name.equalsIgnoreCase(resource.getName())) {
                        result.addFatalError("File already exists!");
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("Creating change...", 1);
            LibraryElement type = this.typeEntry.getType();
            if (type instanceof StructuredType) {
                CompositeChange compositeChange = this.createStructDataChange((DataTypeEntry)this.typeEntry);
                return compositeChange;
            }
            if (type instanceof FBType) {
                CompositeChange compositeChange = this.createFBDataChange();
                return compositeChange;
            }
            UpdateTypeEntryChange updateTypeEntryChange = new UpdateTypeEntryChange(this.file, this.typeEntry, this.newName, this.oldName);
            return updateTypeEntryChange;
        }
        finally {
            monitor.done();
        }
    }

    private CompositeChange createStructDataChange(DataTypeEntry dataTypeEntry) {
        CompositeChange parentChange = new CompositeChange(MessageFormat.format(Messages.Refactoring_RenameFromTo, this.typeEntry.getTypeName(), this.newName));
        parentChange.add((Change)new UpdateTypeEntryChange(this.file, this.typeEntry, this.newName, this.oldName));
        CompositeChange structUsageChanges = new CompositeChange("Refactoring struct users:");
        parentChange.add((Change)structUsageChanges);
        RenameTypeRefactoringParticipant.createStructChanges(dataTypeEntry, structUsageChanges);
        return parentChange;
    }

    private static void createStructChanges(DataTypeEntry dataTypeEntry, CompositeChange structUsageChanges) {
        DataTypeInstanceSearch dataTypeInstanceSearch = new DataTypeInstanceSearch(dataTypeEntry);
        HashSet rootElements = new HashSet();
        dataTypeInstanceSearch.performSearch().forEach(obj -> {
            if (obj instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)obj;
                structUsageChanges.add(RenameTypeRefactoringParticipant.createSubChange(varDecl, dataTypeEntry, rootElements));
            } else if (obj instanceof StructManipulator) {
                StructManipulator structMan = (StructManipulator)obj;
                structUsageChanges.add((Change)new UpdateFBInstanceChange((FBNetworkElement)structMan, (TypeEntry)dataTypeEntry));
            }
        });
    }

    private CompositeChange createFBDataChange() {
        CompositeChange parentChange = new CompositeChange(MessageFormat.format(Messages.Refactoring_RenameFromTo, this.typeEntry.getTypeName(), this.newName));
        parentChange.add((Change)new UpdateTypeEntryChange(this.file, this.typeEntry, this.newName, this.oldName));
        CompositeChange change = new CompositeChange(Messages.Refactoring_AffectedInstancesOfFB);
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(this.typeEntry);
        List searchResults = search.performSearch();
        searchResults.stream().filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).map(fbn -> new UpdateFBInstanceChange((FBNetworkElement)fbn, this.typeEntry)).forEach(arg_0 -> ((CompositeChange)change).add(arg_0));
        if (!searchResults.isEmpty()) {
            parentChange.add((Change)change);
        }
        return parentChange;
    }

    private static Change createSubChange(VarDeclaration varDecl, DataTypeEntry dataTypeEntry, Set<EObject> rootElements) {
        if (varDecl.getFBNetworkElement() != null) {
            if (rootElements.add((EObject)varDecl.getFBNetworkElement())) {
                return new UpdateFBInstanceChange(varDecl.getFBNetworkElement(), (TypeEntry)dataTypeEntry);
            }
        } else {
            EObject rootContainer = EcoreUtil.getRootContainer((EObject)varDecl);
            if (rootElements.add(rootContainer)) {
                if (rootContainer instanceof StructuredType) {
                    StructuredType stElement = (StructuredType)rootContainer;
                    CompositeChange change = new CompositeChange(MessageFormat.format(Messages.Refactoring_AffectedStruct, stElement.getName(), dataTypeEntry.getTypeName()));
                    change.add((Change)new RenameUpdateStructDataTypeMemberVariableChange(varDecl));
                    RenameTypeRefactoringParticipant.createStructChanges((DataTypeEntry)stElement.getTypeEntry(), change);
                    return change;
                }
                if (rootContainer instanceof AttributeDeclaration) {
                    return new RenameUpdateStructDataTypeMemberVariableChange(varDecl);
                }
                if (rootContainer instanceof FBType) {
                    FBType fbType = (FBType)rootContainer;
                    AnyDerivedType anyDerivedType = dataTypeEntry.getType();
                    if (anyDerivedType instanceof StructuredType) {
                        StructuredType type = (StructuredType)anyDerivedType;
                        return new RenameUpdateFBTypeInterfaceChange(fbType, type);
                    }
                }
            }
        }
        return null;
    }
}

