/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.delete;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.SafeFBTypeDeletionChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.delete.SafeStructDeletionChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;

public class DeleteTypeRefactoringParticipant
extends DeleteParticipant {
    private TypeEntry typeEntry;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            this.typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            return this.typeEntry != null;
        }
        return false;
    }

    public String getName() {
        return Messages.DeleteFBTypeParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask("Creating change...", 1);
            LibraryElement libraryElement = this.typeEntry.getType();
            if (libraryElement instanceof StructuredType) {
                StructuredType struct = (StructuredType)libraryElement;
                SafeStructDeletionChange safeStructDeletionChange = new SafeStructDeletionChange(struct);
                return safeStructDeletionChange;
            }
            LibraryElement libraryElement2 = this.typeEntry.getType();
            if (libraryElement2 instanceof FBType) {
                FBType type = (FBType)libraryElement2;
                SafeFBTypeDeletionChange safeFBTypeDeletionChange = new SafeFBTypeDeletionChange(type);
                return safeFBTypeDeletionChange;
            }
            return null;
        }
        finally {
            pm.done();
        }
    }
}

