/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.properties;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.buildpath.Attribute;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathFactory;
import org.eclipse.fordiac.ide.model.buildpath.Pattern;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.model.buildpath.provider.BuildpathContentProvider;
import org.eclipse.fordiac.ide.model.buildpath.provider.BuildpathLabelProvider;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;

public class BuildPathPropertyPage
extends PropertyPage {
    private Buildpath buildpath;
    private TreeViewer treeViewer;
    private Button addIncludeButton;
    private Button addExcludeButton;
    private Button editButton;
    private Button removeButton;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.treeViewer = new TreeViewer(composite);
        this.treeViewer.setContentProvider((IContentProvider)new BuildpathContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BuildpathLabelProvider());
        this.treeViewer.setInput((Object)this.getBuildpath());
        this.treeViewer.addSelectionChangedListener(event -> this.updateButtons());
        this.createButtons(composite);
        GridLayoutFactory.swtDefaults().numColumns(2).generateLayout(composite);
        return composite;
    }

    protected Composite createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Button addFolderButton = new Button(composite, 8);
        addFolderButton.setText(Messages.BuildPathPropertyPage_AddFolder);
        addFolderButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::performAddFolder));
        this.addIncludeButton = new Button(composite, 8);
        this.addIncludeButton.setText(Messages.BuildPathPropertyPage_AddInclude);
        this.addIncludeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::performAddInclude));
        this.addExcludeButton = new Button(composite, 8);
        this.addExcludeButton.setText(Messages.BuildPathPropertyPage_AddExclude);
        this.addExcludeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::performAddExclude));
        this.editButton = new Button(composite, 8);
        this.editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::performEdit));
        this.removeButton = new Button(composite, 8);
        this.removeButton.setText(Messages.BuildPathPropertyPage_Remove);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::performRemove));
        this.updateButtons();
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    /*
     * Unable to fully structure code
     */
    protected void updateButtons() {
        selection = this.treeViewer.getStructuredSelection();
        this.addIncludeButton.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof SourceFolder != false);
        this.addExcludeButton.setEnabled(selection.size() == 1 && selection.getFirstElement() instanceof SourceFolder != false);
        this.editButton.setEnabled(selection.size() == 1);
        this.editButton.setText(selection.size() == 1 && (var3_2 = selection.getFirstElement()) instanceof Attribute != false && BuildPathPropertyPage.isBooleanAttribute(attribute = (Attribute)var3_2) != false ? Messages.BuildPathPropertyPage_Toggle : Messages.BuildPathPropertyPage_Edit);
        if (selection.isEmpty()) ** GOTO lbl-1000
        if (StreamSupport.stream(selection.spliterator(), false).allMatch((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(SourceFolder.class).or((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Ljava/lang/Object;)Z)(Pattern.class)))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.removeButton.setEnabled(v0);
    }

    protected void performAddFolder(SelectionEvent event) {
        Object object;
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.getProject(), false, Messages.BuildPathPropertyPage_AddSourceFolder);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && (object = result[0]) instanceof IPath) {
            IPath path = (IPath)object;
            SourceFolder sourceFolder = BuildpathFactory.eINSTANCE.createSourceFolder();
            sourceFolder.setName(path.makeRelativeTo(this.getProject().getFullPath()).toString());
            this.addDefaultAttributes(sourceFolder);
            this.getBuildpath().getSourceFolders().add((Object)sourceFolder);
        }
    }

    protected void performAddInclude(SelectionEvent event) {
        Object element = this.treeViewer.getStructuredSelection().getFirstElement();
        if (element instanceof SourceFolder) {
            SourceFolder sourceFolder = (SourceFolder)element;
            this.performAddPattern((List<Pattern>)sourceFolder.getIncludes(), Messages.BuildPathPropertyPage_AddIncludePattern);
        }
    }

    protected void performAddExclude(SelectionEvent event) {
        Object element = this.treeViewer.getStructuredSelection().getFirstElement();
        if (element instanceof SourceFolder) {
            SourceFolder sourceFolder = (SourceFolder)element;
            this.performAddPattern((List<Pattern>)sourceFolder.getExcludes(), Messages.BuildPathPropertyPage_AddExcludePattern);
        }
    }

    protected void performAddPattern(List<Pattern> patterns, String message) {
        InputDialog dialog = new InputDialog(this.getShell(), message, Messages.BuildPathPropertyPage_EnterNewPattern, "", this::validatePatternValue);
        if (dialog.open() == 0) {
            Pattern pattern = BuildpathFactory.eINSTANCE.createPattern();
            pattern.setValue(dialog.getValue());
            patterns.add(pattern);
        }
    }

    protected void performRemove(SelectionEvent event) {
        EcoreUtil.removeAll(StreamSupport.stream(this.treeViewer.getStructuredSelection().spliterator(), false).filter(EObject.class::isInstance).map(EObject.class::cast).toList());
    }

    protected void performEdit(SelectionEvent event) {
        Object element = this.treeViewer.getStructuredSelection().getFirstElement();
        if (element instanceof Attribute) {
            Attribute attribute = (Attribute)element;
            this.performEdit(attribute);
        } else if (element instanceof SourceFolder) {
            SourceFolder sourceFolder = (SourceFolder)element;
            this.performEdit(sourceFolder);
        } else if (element instanceof Pattern) {
            Pattern pattern = (Pattern)element;
            this.performEdit(pattern);
        }
    }

    protected void performEdit(Attribute attribute) {
        if (BuildPathPropertyPage.isBooleanAttribute(attribute)) {
            attribute.setValue(Boolean.toString(!Boolean.parseBoolean(attribute.getValue())));
        } else {
            InputDialog dialog = new InputDialog(this.getShell(), Messages.BuildPathPropertyPage_EditAttribute, Messages.BuildPathPropertyPage_EnterNewValue, attribute.getValue(), null);
            if (dialog.open() == 0) {
                attribute.setValue(dialog.getValue());
            }
        }
    }

    protected void performEdit(SourceFolder sourceFolder) {
        Object object;
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)this.getProject(), false, Messages.BuildPathPropertyPage_EditSourceFolder);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && (object = result[0]) instanceof IPath) {
            IPath path = (IPath)object;
            sourceFolder.setName(path.makeRelativeTo(this.getProject().getFullPath()).toString());
        }
    }

    protected void performEdit(Pattern pattern) {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.BuildPathPropertyPage_EditPattern, Messages.BuildPathPropertyPage_EnterNewPattern, pattern.getValue(), this::validatePatternValue);
        if (dialog.open() == 0) {
            pattern.setValue(dialog.getValue());
        }
    }

    protected String validatePatternValue(String value) {
        if (value.isEmpty()) {
            return Messages.BuildPathPropertyPage_EmptyPatternError;
        }
        return null;
    }

    protected static boolean isBooleanAttribute(Attribute attribute) {
        return BuildpathAttributes.getAttributeType((String)attribute.getName()) == Boolean.class;
    }

    protected void performDefaults() {
        this.buildpath = BuildpathUtil.createDefaultBuildpath((IProject)this.getProject());
        this.addDefaultAttributes(this.buildpath);
        this.treeViewer.setInput((Object)this.buildpath);
        this.updateButtons();
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            this.removeDefaultAttributes(this.buildpath);
            BuildpathUtil.saveBuildpath((Buildpath)this.buildpath);
            this.addDefaultAttributes(this.buildpath);
            TypeLibraryManager.INSTANCE.refreshTypeLib((IResource)this.getProject());
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.BuildPathPropertyPage_SaveError, (String)e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    protected void addDefaultAttributes(Buildpath buildpath) {
        buildpath.getSourceFolders().forEach(this::addDefaultAttributes);
    }

    protected void addDefaultAttributes(SourceFolder sourceFolder) {
        BuildpathAttributes.addDefaultAttributes((List)sourceFolder.getAttributes());
    }

    protected void removeDefaultAttributes(Buildpath buildpath) {
        buildpath.getSourceFolders().forEach(this::removeDefaultAttributes);
    }

    protected void removeDefaultAttributes(SourceFolder sourceFolder) {
        BuildpathAttributes.removeDefaultAttributes((List)sourceFolder.getAttributes());
    }

    protected Buildpath getBuildpath() {
        if (this.buildpath == null) {
            this.buildpath = BuildpathUtil.loadBuildpath((IProject)this.getProject());
            this.addDefaultAttributes(this.buildpath);
        }
        return this.buildpath;
    }

    protected IProject getProject() {
        return (IProject)Adapters.adapt((Object)this.getElement(), IProject.class);
    }
}

