/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.Messages;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteErrorMarkerCommand;
import org.eclipse.fordiac.ide.model.helpers.ConnectionsHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class DeleteConnectionCommand
extends Command
implements ScopedCommand {
    private IInterfaceElement source;
    private IInterfaceElement destination;
    private final Connection connection;
    private final FBNetwork connectionParent;
    private boolean performMappingCheck;
    private DeleteConnectionCommand deleteMapped = null;
    private final CompoundCommand deleteInterfaceErrorMarkers = new CompoundCommand();
    private FBNetworkElement errorFb;
    private int elementIndex;
    private boolean keepMarker;

    public DeleteConnectionCommand(Connection connection) {
        this(connection, null);
        this.errorFb = null;
        this.keepMarker = false;
    }

    public DeleteConnectionCommand(Connection connection, boolean keepMarker) {
        this(connection, null);
        this.errorFb = null;
        this.keepMarker = keepMarker;
    }

    public DeleteConnectionCommand(Connection connection, FBNetworkElement errorFb) {
        super(Messages.DeleteConnectionCommand_DeleteConnection);
        FBNetwork fbNetwork;
        this.connection = Objects.requireNonNull(connection);
        EObject eObject = this.connection.eContainer();
        this.connectionParent = eObject instanceof FBNetwork ? (fbNetwork = (FBNetwork)eObject) : null;
        this.performMappingCheck = true;
        this.errorFb = errorFb;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void execute() {
        this.source = this.connection.getSource();
        this.destination = this.connection.getDestination();
        if (this.performMappingCheck) {
            this.deleteMapped = this.checkAndDeleteMirroredConnection();
            if (this.deleteMapped != null) {
                this.deleteMapped.execute();
            }
        }
        this.checkErrorMarker();
        this.deleteConnection();
        this.deleteInterfaceErrorMarkers.execute();
    }

    public void redo() {
        this.deleteConnection();
        this.deleteInterfaceErrorMarkers.redo();
    }

    private void deleteConnection() {
        this.connection.setSource(null);
        this.connection.setDestination(null);
        if (this.deleteMapped != null) {
            this.deleteMapped.redo();
        }
        if (this.connectionParent != null) {
            this.elementIndex = this.connectionParent.getConnectionIndex(this.connection);
            this.connectionParent.removeConnection(this.connection);
        }
    }

    public void undo() {
        this.deleteInterfaceErrorMarkers.undo();
        this.connection.setSource(this.source);
        this.connection.setDestination(this.destination);
        if (this.connectionParent != null) {
            this.connectionParent.addConnectionWithIndex(this.connection, this.elementIndex);
        }
        if (this.deleteMapped != null) {
            this.deleteMapped.undo();
        }
    }

    private DeleteConnectionCommand checkAndDeleteMirroredConnection() {
        Connection opposite = ConnectionsHelper.getOppositeConnection((Connection)this.connection);
        if (opposite != null) {
            DeleteConnectionCommand cmd = new DeleteConnectionCommand(opposite);
            cmd.setPerformMappingCheck(false);
            return cmd.canExecute() ? cmd : null;
        }
        return null;
    }

    private void setPerformMappingCheck(boolean performMappingCheck) {
        this.performMappingCheck = performMappingCheck;
    }

    private void checkErrorMarker() {
        if (DeleteConnectionCommand.isErrorMarkerToDelete(this.source) && !this.keepMarker) {
            this.deleteInterfaceErrorMarkers.add((Command)new DeleteErrorMarkerCommand((ErrorMarkerInterface)this.source, this.errorFb));
        }
        if (DeleteConnectionCommand.isErrorMarkerToDelete(this.destination) && !this.keepMarker) {
            this.deleteInterfaceErrorMarkers.add((Command)new DeleteErrorMarkerCommand((ErrorMarkerInterface)this.destination, this.errorFb));
        }
    }

    private static boolean isErrorMarkerToDelete(IInterfaceElement ie) {
        return ie instanceof ErrorMarkerInterface && ie.eContainer() != null && DeleteConnectionCommand.hasNoOtherConnections(ie);
    }

    private static boolean hasNoOtherConnections(IInterfaceElement ie) {
        return ie.isIsInput() ? ie.getInputConnections().size() <= 1 : ie.getOutputConnections().size() <= 1;
    }

    public IInterfaceElement getSource() {
        return this.source;
    }

    public IInterfaceElement getDestination() {
        return this.destination;
    }

    public FBNetwork getConnectionParent() {
        return this.connectionParent;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Stream.of(this.connectionParent, this.connection, this.source, this.destination).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }

    public int getElementIndex() {
        return this.elementIndex;
    }
}

