# Copyright (C) 2012 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

"""QBzr compatibility layer."""

import bzrlib.plugins.qbzr.lib

def get_qbzr_feature(feature_name):
    """Return (has_feature[True|False], feature_value)"""
    qbzr_features = getattr(bzrlib.plugins.qbzr.lib, "FEATURES", {})
    if feature_name in qbzr_features:
        return True, qbzr_features[feature_name]
    else:
        return False, None

def get_qbzr_ignore_mapping():
    qbzr_has_qignore = get_qbzr_feature('qignore')[0]
    if qbzr_has_qignore:
        return 'bzr qignore --ui-mode'
    else:
        return 'bzr qrun --ui-mode ignore'
