use crate::vk::aliases::*;
use crate::vk::bitflags::*;
use crate::vk::constants::*;
use crate::vk::enums::*;
use crate::vk::native::*;
use crate::vk::platform_types::*;
use crate::vk::prelude::*;
use crate::vk::{ptr_chain_iter, Handle};
use std::fmt;
use std::os::raw::*;
#[deprecated = "This define is deprecated. VK_MAKE_API_VERSION should be used instead."]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_MAKE_VERSION.html>"]
pub const fn make_version(major: u32, minor: u32, patch: u32) -> u32 {
    ((major) << 22) | ((minor) << 12) | (patch)
}
#[deprecated = "This define is deprecated. VK_API_VERSION_MAJOR should be used instead."]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_VERSION_MAJOR.html>"]
pub const fn version_major(version: u32) -> u32 {
    (version) >> 22
}
#[deprecated = "This define is deprecated. VK_API_VERSION_MINOR should be used instead."]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_VERSION_MINOR.html>"]
pub const fn version_minor(version: u32) -> u32 {
    ((version) >> 12) & 0x3ffu32
}
#[deprecated = "This define is deprecated. VK_API_VERSION_PATCH should be used instead."]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_VERSION_PATCH.html>"]
pub const fn version_patch(version: u32) -> u32 {
    (version) & 0xfffu32
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_MAKE_API_VERSION.html>"]
pub const fn make_api_version(variant: u32, major: u32, minor: u32, patch: u32) -> u32 {
    ((variant) << 29) | ((major) << 22) | ((minor) << 12) | (patch)
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_VARIANT.html>"]
pub const fn api_version_variant(version: u32) -> u32 {
    (version) >> 29
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_MAJOR.html>"]
pub const fn api_version_major(version: u32) -> u32 {
    ((version) >> 22) & 0x7fu32
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_MINOR.html>"]
pub const fn api_version_minor(version: u32) -> u32 {
    ((version) >> 12) & 0x3ffu32
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_PATCH.html>"]
pub const fn api_version_patch(version: u32) -> u32 {
    (version) & 0xfffu32
}
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_0.html>"]
pub const API_VERSION_1_0: u32 = make_api_version(0, 1, 0, 0);
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_1.html>"]
pub const API_VERSION_1_1: u32 = make_api_version(0, 1, 1, 0);
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_2.html>"]
pub const API_VERSION_1_2: u32 = make_api_version(0, 1, 2, 0);
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_API_VERSION_1_3.html>"]
pub const API_VERSION_1_3: u32 = make_api_version(0, 1, 3, 0);
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_HEADER_VERSION.html>"]
pub const HEADER_VERSION: u32 = 251;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VK_HEADER_VERSION_COMPLETE.html>"]
pub const HEADER_VERSION_COMPLETE: u32 = make_api_version(0, 1, 3, HEADER_VERSION);
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSampleMask.html>"]
pub type SampleMask = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBool32.html>"]
pub type Bool32 = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFlags.html>"]
pub type Flags = u32;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFlags64.html>"]
pub type Flags64 = u64;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceSize.html>"]
pub type DeviceSize = u64;
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceAddress.html>"]
pub type DeviceAddress = u64;
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueryPoolCreateFlags.html>"]
pub struct QueryPoolCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(QueryPoolCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineDynamicStateCreateFlags.html>"]
pub struct PipelineDynamicStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineDynamicStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateFlags.html>"]
pub struct PipelineMultisampleStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineMultisampleStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateCreateFlags.html>"]
pub struct PipelineRasterizationStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportStateCreateFlags.html>"]
pub struct PipelineViewportStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineViewportStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationStateCreateFlags.html>"]
pub struct PipelineTessellationStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineTessellationStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineInputAssemblyStateCreateFlags.html>"]
pub struct PipelineInputAssemblyStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineInputAssemblyStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineVertexInputStateCreateFlags.html>"]
pub struct PipelineVertexInputStateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineVertexInputStateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferViewCreateFlags.html>"]
pub struct BufferViewCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(BufferViewCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceCreateFlags.html>"]
pub struct DeviceCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DeviceCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryMapFlags.html>"]
pub struct MemoryMapFlags(pub(crate) Flags);
vk_bitflags_wrapped!(MemoryMapFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolResetFlags.html>"]
pub struct DescriptorPoolResetFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DescriptorPoolResetFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateCreateFlags.html>"]
pub struct DescriptorUpdateTemplateCreateFlags(pub(crate) Flags);
vk_bitflags_wrapped!(DescriptorUpdateTemplateCreateFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureMotionInfoFlagsNV.html>"]
pub struct AccelerationStructureMotionInfoFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(AccelerationStructureMotionInfoFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureMotionInstanceFlagsNV.html>"]
pub struct AccelerationStructureMotionInstanceFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(AccelerationStructureMotionInstanceFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDirectDriverLoadingFlagsLUNARG.html>"]
pub struct DirectDriverLoadingFlagsLUNARG(pub(crate) Flags);
vk_bitflags_wrapped!(DirectDriverLoadingFlagsLUNARG, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModeCreateFlagsKHR.html>"]
pub struct DisplayModeCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(DisplayModeCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplaySurfaceCreateFlagsKHR.html>"]
pub struct DisplaySurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(DisplaySurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAndroidSurfaceCreateFlagsKHR.html>"]
pub struct AndroidSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(AndroidSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkViSurfaceCreateFlagsNN.html>"]
pub struct ViSurfaceCreateFlagsNN(pub(crate) Flags);
vk_bitflags_wrapped!(ViSurfaceCreateFlagsNN, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWaylandSurfaceCreateFlagsKHR.html>"]
pub struct WaylandSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(WaylandSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWin32SurfaceCreateFlagsKHR.html>"]
pub struct Win32SurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(Win32SurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkXlibSurfaceCreateFlagsKHR.html>"]
pub struct XlibSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(XlibSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkXcbSurfaceCreateFlagsKHR.html>"]
pub struct XcbSurfaceCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(XcbSurfaceCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDirectFBSurfaceCreateFlagsEXT.html>"]
pub struct DirectFBSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DirectFBSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIOSSurfaceCreateFlagsMVK.html>"]
pub struct IOSSurfaceCreateFlagsMVK(pub(crate) Flags);
vk_bitflags_wrapped!(IOSSurfaceCreateFlagsMVK, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMacOSSurfaceCreateFlagsMVK.html>"]
pub struct MacOSSurfaceCreateFlagsMVK(pub(crate) Flags);
vk_bitflags_wrapped!(MacOSSurfaceCreateFlagsMVK, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMetalSurfaceCreateFlagsEXT.html>"]
pub struct MetalSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(MetalSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImagePipeSurfaceCreateFlagsFUCHSIA.html>"]
pub struct ImagePipeSurfaceCreateFlagsFUCHSIA(pub(crate) Flags);
vk_bitflags_wrapped!(ImagePipeSurfaceCreateFlagsFUCHSIA, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkStreamDescriptorSurfaceCreateFlagsGGP.html>"]
pub struct StreamDescriptorSurfaceCreateFlagsGGP(pub(crate) Flags);
vk_bitflags_wrapped!(StreamDescriptorSurfaceCreateFlagsGGP, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkHeadlessSurfaceCreateFlagsEXT.html>"]
pub struct HeadlessSurfaceCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(HeadlessSurfaceCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkScreenSurfaceCreateFlagsQNX.html>"]
pub struct ScreenSurfaceCreateFlagsQNX(pub(crate) Flags);
vk_bitflags_wrapped!(ScreenSurfaceCreateFlagsQNX, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandPoolTrimFlags.html>"]
pub struct CommandPoolTrimFlags(pub(crate) Flags);
vk_bitflags_wrapped!(CommandPoolTrimFlags, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportSwizzleStateCreateFlagsNV.html>"]
pub struct PipelineViewportSwizzleStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineViewportSwizzleStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineDiscardRectangleStateCreateFlagsEXT.html>"]
pub struct PipelineDiscardRectangleStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineDiscardRectangleStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageToColorStateCreateFlagsNV.html>"]
pub struct PipelineCoverageToColorStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageToColorStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageModulationStateCreateFlagsNV.html>"]
pub struct PipelineCoverageModulationStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageModulationStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageReductionStateCreateFlagsNV.html>"]
pub struct PipelineCoverageReductionStateCreateFlagsNV(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineCoverageReductionStateCreateFlagsNV, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkValidationCacheCreateFlagsEXT.html>"]
pub struct ValidationCacheCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(ValidationCacheCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCreateFlagsEXT.html>"]
pub struct DebugUtilsMessengerCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerCallbackDataFlagsEXT.html>"]
pub struct DebugUtilsMessengerCallbackDataFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DebugUtilsMessengerCallbackDataFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceMemoryReportFlagsEXT.html>"]
pub struct DeviceMemoryReportFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(DeviceMemoryReportFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationConservativeStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationConservativeStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationConservativeStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateStreamCreateFlagsEXT.html>"]
pub struct PipelineRasterizationStateStreamCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationStateStreamCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationDepthClipStateCreateFlagsEXT.html>"]
pub struct PipelineRasterizationDepthClipStateCreateFlagsEXT(pub(crate) Flags);
vk_bitflags_wrapped!(PipelineRasterizationDepthClipStateCreateFlagsEXT, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoSessionParametersCreateFlagsKHR.html>"]
pub struct VideoSessionParametersCreateFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoSessionParametersCreateFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoBeginCodingFlagsKHR.html>"]
pub struct VideoBeginCodingFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoBeginCodingFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoEndCodingFlagsKHR.html>"]
pub struct VideoEndCodingFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoEndCodingFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoDecodeFlagsKHR.html>"]
pub struct VideoDecodeFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoDecodeFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoEncodeFlagsKHR.html>"]
pub struct VideoEncodeFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoEncodeFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoEncodeRateControlFlagsKHR.html>"]
pub struct VideoEncodeRateControlFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(VideoEncodeRateControlFlagsKHR, Flags);
#[repr(transparent)]
#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryUnmapFlagsKHR.html>"]
pub struct MemoryUnmapFlagsKHR(pub(crate) Flags);
vk_bitflags_wrapped!(MemoryUnmapFlagsKHR, Flags);
define_handle!(
    Instance,
    INSTANCE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkInstance.html>"
);
define_handle ! (PhysicalDevice , PHYSICAL_DEVICE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevice.html>") ;
define_handle!(
    Device,
    DEVICE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDevice.html>"
);
define_handle!(
    Queue,
    QUEUE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueue.html>"
);
define_handle ! (CommandBuffer , COMMAND_BUFFER , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandBuffer.html>") ;
handle_nondispatchable ! (DeviceMemory , DEVICE_MEMORY , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceMemory.html>") ;
handle_nondispatchable ! (CommandPool , COMMAND_POOL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandPool.html>") ;
handle_nondispatchable!(
    Buffer,
    BUFFER,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBuffer.html>"
);
handle_nondispatchable!(
    BufferView,
    BUFFER_VIEW,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferView.html>"
);
handle_nondispatchable!(
    Image,
    IMAGE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImage.html>"
);
handle_nondispatchable!(
    ImageView,
    IMAGE_VIEW,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageView.html>"
);
handle_nondispatchable ! (ShaderModule , SHADER_MODULE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkShaderModule.html>") ;
handle_nondispatchable!(
    Pipeline,
    PIPELINE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipeline.html>"
);
handle_nondispatchable ! (PipelineLayout , PIPELINE_LAYOUT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineLayout.html>") ;
handle_nondispatchable!(
    Sampler,
    SAMPLER,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSampler.html>"
);
handle_nondispatchable ! (DescriptorSet , DESCRIPTOR_SET , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSet.html>") ;
handle_nondispatchable ! (DescriptorSetLayout , DESCRIPTOR_SET_LAYOUT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayout.html>") ;
handle_nondispatchable ! (DescriptorPool , DESCRIPTOR_POOL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorPool.html>") ;
handle_nondispatchable!(
    Fence,
    FENCE,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFence.html>"
);
handle_nondispatchable!(
    Semaphore,
    SEMAPHORE,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSemaphore.html>"
);
handle_nondispatchable!(
    Event,
    EVENT,
    doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkEvent.html>"
);
handle_nondispatchable!(
    QueryPool,
    QUERY_POOL,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueryPool.html>"
);
handle_nondispatchable ! (Framebuffer , FRAMEBUFFER , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFramebuffer.html>") ;
handle_nondispatchable!(
    RenderPass,
    RENDER_PASS,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPass.html>"
);
handle_nondispatchable ! (PipelineCache , PIPELINE_CACHE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCache.html>") ;
handle_nondispatchable ! (IndirectCommandsLayoutNV , INDIRECT_COMMANDS_LAYOUT_NV , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutNV.html>") ;
handle_nondispatchable ! (DescriptorUpdateTemplate , DESCRIPTOR_UPDATE_TEMPLATE , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplate.html>") ;
handle_nondispatchable ! (SamplerYcbcrConversion , SAMPLER_YCBCR_CONVERSION , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversion.html>") ;
handle_nondispatchable ! (ValidationCacheEXT , VALIDATION_CACHE_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkValidationCacheEXT.html>") ;
handle_nondispatchable ! (AccelerationStructureKHR , ACCELERATION_STRUCTURE_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureKHR.html>") ;
handle_nondispatchable ! (AccelerationStructureNV , ACCELERATION_STRUCTURE_NV , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAccelerationStructureNV.html>") ;
handle_nondispatchable ! (PerformanceConfigurationINTEL , PERFORMANCE_CONFIGURATION_INTEL , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPerformanceConfigurationINTEL.html>") ;
handle_nondispatchable ! (BufferCollectionFUCHSIA , BUFFER_COLLECTION_FUCHSIA , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferCollectionFUCHSIA.html>") ;
handle_nondispatchable ! (DeferredOperationKHR , DEFERRED_OPERATION_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeferredOperationKHR.html>") ;
handle_nondispatchable ! (PrivateDataSlot , PRIVATE_DATA_SLOT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPrivateDataSlot.html>") ;
handle_nondispatchable ! (CuModuleNVX , CU_MODULE_NVX , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCuModuleNVX.html>") ;
handle_nondispatchable ! (CuFunctionNVX , CU_FUNCTION_NVX , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCuFunctionNVX.html>") ;
handle_nondispatchable ! (OpticalFlowSessionNV , OPTICAL_FLOW_SESSION_NV , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkOpticalFlowSessionNV.html>") ;
handle_nondispatchable ! (MicromapEXT , MICROMAP_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMicromapEXT.html>") ;
handle_nondispatchable!(
    ShaderEXT,
    SHADER_EXT,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkShaderEXT.html>"
);
handle_nondispatchable!(
    DisplayKHR,
    DISPLAY_KHR,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayKHR.html>"
);
handle_nondispatchable ! (DisplayModeKHR , DISPLAY_MODE_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModeKHR.html>") ;
handle_nondispatchable!(
    SurfaceKHR,
    SURFACE_KHR,
    doc =
        "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceKHR.html>"
);
handle_nondispatchable ! (SwapchainKHR , SWAPCHAIN_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSwapchainKHR.html>") ;
handle_nondispatchable ! (DebugReportCallbackEXT , DEBUG_REPORT_CALLBACK_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugReportCallbackEXT.html>") ;
handle_nondispatchable ! (DebugUtilsMessengerEXT , DEBUG_UTILS_MESSENGER_EXT , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugUtilsMessengerEXT.html>") ;
handle_nondispatchable ! (VideoSessionKHR , VIDEO_SESSION_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoSessionKHR.html>") ;
handle_nondispatchable ! (VideoSessionParametersKHR , VIDEO_SESSION_PARAMETERS_KHR , doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVideoSessionParametersKHR.html>") ;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkInternalAllocationNotification.html>"]
pub type PFN_vkInternalAllocationNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkInternalFreeNotification.html>"]
pub type PFN_vkInternalFreeNotification = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        allocation_type: InternalAllocationType,
        allocation_scope: SystemAllocationScope,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkReallocationFunction.html>"]
pub type PFN_vkReallocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        p_original: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkAllocationFunction.html>"]
pub type PFN_vkAllocationFunction = Option<
    unsafe extern "system" fn(
        p_user_data: *mut c_void,
        size: usize,
        alignment: usize,
        allocation_scope: SystemAllocationScope,
    ) -> *mut c_void,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkFreeFunction.html>"]
pub type PFN_vkFreeFunction =
    Option<unsafe extern "system" fn(p_user_data: *mut c_void, p_memory: *mut c_void)>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkVoidFunction.html>"]
pub type PFN_vkVoidFunction = Option<unsafe extern "system" fn()>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkDebugReportCallbackEXT.html>"]
pub type PFN_vkDebugReportCallbackEXT = Option<
    unsafe extern "system" fn(
        flags: DebugReportFlagsEXT,
        object_type: DebugReportObjectTypeEXT,
        object: u64,
        location: usize,
        message_code: i32,
        p_layer_prefix: *const c_char,
        p_message: *const c_char,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkDebugUtilsMessengerCallbackEXT.html>"]
pub type PFN_vkDebugUtilsMessengerCallbackEXT = Option<
    unsafe extern "system" fn(
        message_severity: DebugUtilsMessageSeverityFlagsEXT,
        message_types: DebugUtilsMessageTypeFlagsEXT,
        p_callback_data: *const DebugUtilsMessengerCallbackDataEXT,
        p_user_data: *mut c_void,
    ) -> Bool32,
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkDeviceMemoryReportCallbackEXT.html>"]
pub type PFN_vkDeviceMemoryReportCallbackEXT = Option<
    unsafe extern "system" fn(
        p_callback_data: *const DeviceMemoryReportCallbackDataEXT,
        p_user_data: *mut c_void,
    ),
>;
#[allow(non_camel_case_types)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/PFN_vkGetInstanceProcAddrLUNARG.html>"]
pub type PFN_vkGetInstanceProcAddrLUNARG = Option<
    unsafe extern "system" fn(instance: Instance, p_name: *const c_char) -> PFN_vkVoidFunction,
>;
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBaseOutStructure.html>"]
pub struct BaseOutStructure {
    pub s_type: StructureType,
    pub p_next: *mut Self,
}
impl ::std::default::Default for BaseOutStructure {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: unsafe { ::std::mem::zeroed() },
            p_next: ::std::ptr::null_mut(),
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBaseInStructure.html>"]
pub struct BaseInStructure {
    pub s_type: StructureType,
    pub p_next: *const Self,
}
impl ::std::default::Default for BaseInStructure {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: unsafe { ::std::mem::zeroed() },
            p_next: ::std::ptr::null(),
        }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkOffset2D.html>"]
pub struct Offset2D {
    pub x: i32,
    pub y: i32,
}
impl Offset2D {
    pub fn builder<'a>() -> Offset2DBuilder<'a> {
        Offset2DBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Offset2DBuilder<'a> {
    inner: Offset2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Offset2DBuilder<'a> {
    type Target = Offset2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Offset2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Offset2DBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.inner.y = y;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Offset2D {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkOffset3D.html>"]
pub struct Offset3D {
    pub x: i32,
    pub y: i32,
    pub z: i32,
}
impl Offset3D {
    pub fn builder<'a>() -> Offset3DBuilder<'a> {
        Offset3DBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Offset3DBuilder<'a> {
    inner: Offset3D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Offset3DBuilder<'a> {
    type Target = Offset3D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Offset3DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Offset3DBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: i32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: i32) -> Self {
        self.inner.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: i32) -> Self {
        self.inner.z = z;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Offset3D {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExtent2D.html>"]
pub struct Extent2D {
    pub width: u32,
    pub height: u32,
}
impl Extent2D {
    pub fn builder<'a>() -> Extent2DBuilder<'a> {
        Extent2DBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Extent2DBuilder<'a> {
    inner: Extent2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Extent2DBuilder<'a> {
    type Target = Extent2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Extent2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Extent2DBuilder<'a> {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.inner.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.inner.height = height;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Extent2D {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExtent3D.html>"]
pub struct Extent3D {
    pub width: u32,
    pub height: u32,
    pub depth: u32,
}
impl Extent3D {
    pub fn builder<'a>() -> Extent3DBuilder<'a> {
        Extent3DBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Extent3DBuilder<'a> {
    inner: Extent3D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Extent3DBuilder<'a> {
    type Target = Extent3D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Extent3DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Extent3DBuilder<'a> {
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.inner.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.inner.height = height;
        self
    }
    #[inline]
    pub fn depth(mut self, depth: u32) -> Self {
        self.inner.depth = depth;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Extent3D {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkViewport.html>"]
pub struct Viewport {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
    pub min_depth: f32,
    pub max_depth: f32,
}
impl Viewport {
    pub fn builder<'a>() -> ViewportBuilder<'a> {
        ViewportBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViewportBuilder<'a> {
    inner: Viewport,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ViewportBuilder<'a> {
    type Target = Viewport;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViewportBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViewportBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.inner.y = y;
        self
    }
    #[inline]
    pub fn width(mut self, width: f32) -> Self {
        self.inner.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: f32) -> Self {
        self.inner.height = height;
        self
    }
    #[inline]
    pub fn min_depth(mut self, min_depth: f32) -> Self {
        self.inner.min_depth = min_depth;
        self
    }
    #[inline]
    pub fn max_depth(mut self, max_depth: f32) -> Self {
        self.inner.max_depth = max_depth;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Viewport {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRect2D.html>"]
pub struct Rect2D {
    pub offset: Offset2D,
    pub extent: Extent2D,
}
impl Rect2D {
    pub fn builder<'a>() -> Rect2DBuilder<'a> {
        Rect2DBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Rect2DBuilder<'a> {
    inner: Rect2D,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Rect2DBuilder<'a> {
    type Target = Rect2D;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Rect2DBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Rect2DBuilder<'a> {
    #[inline]
    pub fn offset(mut self, offset: Offset2D) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent2D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Rect2D {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkClearRect.html>"]
pub struct ClearRect {
    pub rect: Rect2D,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ClearRect {
    pub fn builder<'a>() -> ClearRectBuilder<'a> {
        ClearRectBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearRectBuilder<'a> {
    inner: ClearRect,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearRectBuilder<'a> {
    type Target = ClearRect;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearRectBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearRectBuilder<'a> {
    #[inline]
    pub fn rect(mut self, rect: Rect2D) -> Self {
        self.inner.rect = rect;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearRect {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkComponentMapping.html>"]
pub struct ComponentMapping {
    pub r: ComponentSwizzle,
    pub g: ComponentSwizzle,
    pub b: ComponentSwizzle,
    pub a: ComponentSwizzle,
}
impl ComponentMapping {
    pub fn builder<'a>() -> ComponentMappingBuilder<'a> {
        ComponentMappingBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ComponentMappingBuilder<'a> {
    inner: ComponentMapping,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ComponentMappingBuilder<'a> {
    type Target = ComponentMapping;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ComponentMappingBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ComponentMappingBuilder<'a> {
    #[inline]
    pub fn r(mut self, r: ComponentSwizzle) -> Self {
        self.inner.r = r;
        self
    }
    #[inline]
    pub fn g(mut self, g: ComponentSwizzle) -> Self {
        self.inner.g = g;
        self
    }
    #[inline]
    pub fn b(mut self, b: ComponentSwizzle) -> Self {
        self.inner.b = b;
        self
    }
    #[inline]
    pub fn a(mut self, a: ComponentSwizzle) -> Self {
        self.inner.a = a;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ComponentMapping {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProperties.html>"]
pub struct PhysicalDeviceProperties {
    pub api_version: u32,
    pub driver_version: u32,
    pub vendor_id: u32,
    pub device_id: u32,
    pub device_type: PhysicalDeviceType,
    pub device_name: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE],
    pub pipeline_cache_uuid: [u8; UUID_SIZE],
    pub limits: PhysicalDeviceLimits,
    pub sparse_properties: PhysicalDeviceSparseProperties,
}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceProperties")
            .field("api_version", &self.api_version)
            .field("driver_version", &self.driver_version)
            .field("vendor_id", &self.vendor_id)
            .field("device_id", &self.device_id)
            .field("device_type", &self.device_type)
            .field("device_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.device_name.as_ptr())
            })
            .field("pipeline_cache_uuid", &self.pipeline_cache_uuid)
            .field("limits", &self.limits)
            .field("sparse_properties", &self.sparse_properties)
            .finish()
    }
}
impl ::std::default::Default for PhysicalDeviceProperties {
    #[inline]
    fn default() -> Self {
        Self {
            api_version: u32::default(),
            driver_version: u32::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            device_type: PhysicalDeviceType::default(),
            device_name: unsafe { ::std::mem::zeroed() },
            pipeline_cache_uuid: unsafe { ::std::mem::zeroed() },
            limits: PhysicalDeviceLimits::default(),
            sparse_properties: PhysicalDeviceSparseProperties::default(),
        }
    }
}
impl PhysicalDeviceProperties {
    pub fn builder<'a>() -> PhysicalDevicePropertiesBuilder<'a> {
        PhysicalDevicePropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePropertiesBuilder<'a> {
    inner: PhysicalDeviceProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDevicePropertiesBuilder<'a> {
    type Target = PhysicalDeviceProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePropertiesBuilder<'a> {
    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.inner.api_version = api_version;
        self
    }
    #[inline]
    pub fn driver_version(mut self, driver_version: u32) -> Self {
        self.inner.driver_version = driver_version;
        self
    }
    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.inner.vendor_id = vendor_id;
        self
    }
    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.inner.device_id = device_id;
        self
    }
    #[inline]
    pub fn device_type(mut self, device_type: PhysicalDeviceType) -> Self {
        self.inner.device_type = device_type;
        self
    }
    #[inline]
    pub fn device_name(mut self, device_name: [c_char; MAX_PHYSICAL_DEVICE_NAME_SIZE]) -> Self {
        self.inner.device_name = device_name;
        self
    }
    #[inline]
    pub fn pipeline_cache_uuid(mut self, pipeline_cache_uuid: [u8; UUID_SIZE]) -> Self {
        self.inner.pipeline_cache_uuid = pipeline_cache_uuid;
        self
    }
    #[inline]
    pub fn limits(mut self, limits: PhysicalDeviceLimits) -> Self {
        self.inner.limits = limits;
        self
    }
    #[inline]
    pub fn sparse_properties(mut self, sparse_properties: PhysicalDeviceSparseProperties) -> Self {
        self.inner.sparse_properties = sparse_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExtensionProperties.html>"]
pub struct ExtensionProperties {
    pub extension_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
}
#[cfg(feature = "debug")]
impl fmt::Debug for ExtensionProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("ExtensionProperties")
            .field("extension_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.extension_name.as_ptr())
            })
            .field("spec_version", &self.spec_version)
            .finish()
    }
}
impl ::std::default::Default for ExtensionProperties {
    #[inline]
    fn default() -> Self {
        Self {
            extension_name: unsafe { ::std::mem::zeroed() },
            spec_version: u32::default(),
        }
    }
}
impl ExtensionProperties {
    pub fn builder<'a>() -> ExtensionPropertiesBuilder<'a> {
        ExtensionPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExtensionPropertiesBuilder<'a> {
    inner: ExtensionProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExtensionPropertiesBuilder<'a> {
    type Target = ExtensionProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExtensionPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExtensionPropertiesBuilder<'a> {
    #[inline]
    pub fn extension_name(mut self, extension_name: [c_char; MAX_EXTENSION_NAME_SIZE]) -> Self {
        self.inner.extension_name = extension_name;
        self
    }
    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.inner.spec_version = spec_version;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExtensionProperties {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkLayerProperties.html>"]
pub struct LayerProperties {
    pub layer_name: [c_char; MAX_EXTENSION_NAME_SIZE],
    pub spec_version: u32,
    pub implementation_version: u32,
    pub description: [c_char; MAX_DESCRIPTION_SIZE],
}
#[cfg(feature = "debug")]
impl fmt::Debug for LayerProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("LayerProperties")
            .field("layer_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.layer_name.as_ptr())
            })
            .field("spec_version", &self.spec_version)
            .field("implementation_version", &self.implementation_version)
            .field("description", &unsafe {
                ::std::ffi::CStr::from_ptr(self.description.as_ptr())
            })
            .finish()
    }
}
impl ::std::default::Default for LayerProperties {
    #[inline]
    fn default() -> Self {
        Self {
            layer_name: unsafe { ::std::mem::zeroed() },
            spec_version: u32::default(),
            implementation_version: u32::default(),
            description: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl LayerProperties {
    pub fn builder<'a>() -> LayerPropertiesBuilder<'a> {
        LayerPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct LayerPropertiesBuilder<'a> {
    inner: LayerProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for LayerPropertiesBuilder<'a> {
    type Target = LayerProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for LayerPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> LayerPropertiesBuilder<'a> {
    #[inline]
    pub fn layer_name(mut self, layer_name: [c_char; MAX_EXTENSION_NAME_SIZE]) -> Self {
        self.inner.layer_name = layer_name;
        self
    }
    #[inline]
    pub fn spec_version(mut self, spec_version: u32) -> Self {
        self.inner.spec_version = spec_version;
        self
    }
    #[inline]
    pub fn implementation_version(mut self, implementation_version: u32) -> Self {
        self.inner.implementation_version = implementation_version;
        self
    }
    #[inline]
    pub fn description(mut self, description: [c_char; MAX_DESCRIPTION_SIZE]) -> Self {
        self.inner.description = description;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> LayerProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkApplicationInfo.html>"]
pub struct ApplicationInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_application_name: *const c_char,
    pub application_version: u32,
    pub p_engine_name: *const c_char,
    pub engine_version: u32,
    pub api_version: u32,
}
impl ::std::default::Default for ApplicationInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_application_name: ::std::ptr::null(),
            application_version: u32::default(),
            p_engine_name: ::std::ptr::null(),
            engine_version: u32::default(),
            api_version: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for ApplicationInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::APPLICATION_INFO;
}
impl ApplicationInfo {
    pub fn builder<'a>() -> ApplicationInfoBuilder<'a> {
        ApplicationInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ApplicationInfoBuilder<'a> {
    inner: ApplicationInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ApplicationInfoBuilder<'a> {
    type Target = ApplicationInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ApplicationInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ApplicationInfoBuilder<'a> {
    #[inline]
    pub fn application_name(mut self, application_name: &'a ::std::ffi::CStr) -> Self {
        self.inner.p_application_name = application_name.as_ptr();
        self
    }
    #[inline]
    pub fn application_version(mut self, application_version: u32) -> Self {
        self.inner.application_version = application_version;
        self
    }
    #[inline]
    pub fn engine_name(mut self, engine_name: &'a ::std::ffi::CStr) -> Self {
        self.inner.p_engine_name = engine_name.as_ptr();
        self
    }
    #[inline]
    pub fn engine_version(mut self, engine_version: u32) -> Self {
        self.inner.engine_version = engine_version;
        self
    }
    #[inline]
    pub fn api_version(mut self, api_version: u32) -> Self {
        self.inner.api_version = api_version;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ApplicationInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAllocationCallbacks.html>"]
pub struct AllocationCallbacks {
    pub p_user_data: *mut c_void,
    pub pfn_allocation: PFN_vkAllocationFunction,
    pub pfn_reallocation: PFN_vkReallocationFunction,
    pub pfn_free: PFN_vkFreeFunction,
    pub pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    pub pfn_internal_free: PFN_vkInternalFreeNotification,
}
#[cfg(feature = "debug")]
impl fmt::Debug for AllocationCallbacks {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("AllocationCallbacks")
            .field("p_user_data", &self.p_user_data)
            .field(
                "pfn_allocation",
                &(self.pfn_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_reallocation",
                &(self.pfn_reallocation.map(|x| x as *const ())),
            )
            .field("pfn_free", &(self.pfn_free.map(|x| x as *const ())))
            .field(
                "pfn_internal_allocation",
                &(self.pfn_internal_allocation.map(|x| x as *const ())),
            )
            .field(
                "pfn_internal_free",
                &(self.pfn_internal_free.map(|x| x as *const ())),
            )
            .finish()
    }
}
impl ::std::default::Default for AllocationCallbacks {
    #[inline]
    fn default() -> Self {
        Self {
            p_user_data: ::std::ptr::null_mut(),
            pfn_allocation: PFN_vkAllocationFunction::default(),
            pfn_reallocation: PFN_vkReallocationFunction::default(),
            pfn_free: PFN_vkFreeFunction::default(),
            pfn_internal_allocation: PFN_vkInternalAllocationNotification::default(),
            pfn_internal_free: PFN_vkInternalFreeNotification::default(),
        }
    }
}
impl AllocationCallbacks {
    pub fn builder<'a>() -> AllocationCallbacksBuilder<'a> {
        AllocationCallbacksBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AllocationCallbacksBuilder<'a> {
    inner: AllocationCallbacks,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AllocationCallbacksBuilder<'a> {
    type Target = AllocationCallbacks;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AllocationCallbacksBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AllocationCallbacksBuilder<'a> {
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.inner.p_user_data = user_data;
        self
    }
    #[inline]
    pub fn pfn_allocation(mut self, pfn_allocation: PFN_vkAllocationFunction) -> Self {
        self.inner.pfn_allocation = pfn_allocation;
        self
    }
    #[inline]
    pub fn pfn_reallocation(mut self, pfn_reallocation: PFN_vkReallocationFunction) -> Self {
        self.inner.pfn_reallocation = pfn_reallocation;
        self
    }
    #[inline]
    pub fn pfn_free(mut self, pfn_free: PFN_vkFreeFunction) -> Self {
        self.inner.pfn_free = pfn_free;
        self
    }
    #[inline]
    pub fn pfn_internal_allocation(
        mut self,
        pfn_internal_allocation: PFN_vkInternalAllocationNotification,
    ) -> Self {
        self.inner.pfn_internal_allocation = pfn_internal_allocation;
        self
    }
    #[inline]
    pub fn pfn_internal_free(mut self, pfn_internal_free: PFN_vkInternalFreeNotification) -> Self {
        self.inner.pfn_internal_free = pfn_internal_free;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AllocationCallbacks {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceQueueCreateInfo.html>"]
pub struct DeviceQueueCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_count: u32,
    pub p_queue_priorities: *const f32,
}
impl ::std::default::Default for DeviceQueueCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_count: u32::default(),
            p_queue_priorities: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceQueueCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_QUEUE_CREATE_INFO;
}
impl DeviceQueueCreateInfo {
    pub fn builder<'a>() -> DeviceQueueCreateInfoBuilder<'a> {
        DeviceQueueCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceQueueCreateInfoBuilder<'a> {
    inner: DeviceQueueCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDeviceQueueCreateInfo {}
impl<'a> ::std::ops::Deref for DeviceQueueCreateInfoBuilder<'a> {
    type Target = DeviceQueueCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceQueueCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceQueueCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.inner.queue_family_index = queue_family_index;
        self
    }
    #[inline]
    pub fn queue_priorities(mut self, queue_priorities: &'a [f32]) -> Self {
        self.inner.queue_count = queue_priorities.len() as _;
        self.inner.p_queue_priorities = queue_priorities.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceQueueCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceQueueCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceCreateInfo.html>"]
pub struct DeviceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceCreateFlags,
    pub queue_create_info_count: u32,
    pub p_queue_create_infos: *const DeviceQueueCreateInfo,
    #[deprecated = "functionality described by this member no longer operates"]
    pub enabled_layer_count: u32,
    #[deprecated = "functionality described by this member no longer operates"]
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
    pub p_enabled_features: *const PhysicalDeviceFeatures,
}
impl ::std::default::Default for DeviceCreateInfo {
    #[inline]
    fn default() -> Self {
        #[allow(deprecated)]
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DeviceCreateFlags::default(),
            queue_create_info_count: u32::default(),
            p_queue_create_infos: ::std::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::std::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::std::ptr::null(),
            p_enabled_features: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_CREATE_INFO;
}
impl DeviceCreateInfo {
    pub fn builder<'a>() -> DeviceCreateInfoBuilder<'a> {
        DeviceCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceCreateInfoBuilder<'a> {
    inner: DeviceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDeviceCreateInfo {}
impl<'a> ::std::ops::Deref for DeviceCreateInfoBuilder<'a> {
    type Target = DeviceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn queue_create_infos(mut self, queue_create_infos: &'a [DeviceQueueCreateInfo]) -> Self {
        self.inner.queue_create_info_count = queue_create_infos.len() as _;
        self.inner.p_queue_create_infos = queue_create_infos.as_ptr();
        self
    }
    #[inline]
    #[deprecated = "functionality described by this member no longer operates"]
    #[allow(deprecated)]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'a [*const c_char]) -> Self {
        self.inner.enabled_layer_count = enabled_layer_names.len() as _;
        self.inner.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'a [*const c_char]) -> Self {
        self.inner.enabled_extension_count = enabled_extension_names.len() as _;
        self.inner.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_features(mut self, enabled_features: &'a PhysicalDeviceFeatures) -> Self {
        self.inner.p_enabled_features = enabled_features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDeviceCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkInstanceCreateInfo.html>"]
pub struct InstanceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: InstanceCreateFlags,
    pub p_application_info: *const ApplicationInfo,
    pub enabled_layer_count: u32,
    pub pp_enabled_layer_names: *const *const c_char,
    pub enabled_extension_count: u32,
    pub pp_enabled_extension_names: *const *const c_char,
}
impl ::std::default::Default for InstanceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: InstanceCreateFlags::default(),
            p_application_info: ::std::ptr::null(),
            enabled_layer_count: u32::default(),
            pp_enabled_layer_names: ::std::ptr::null(),
            enabled_extension_count: u32::default(),
            pp_enabled_extension_names: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for InstanceCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::INSTANCE_CREATE_INFO;
}
impl InstanceCreateInfo {
    pub fn builder<'a>() -> InstanceCreateInfoBuilder<'a> {
        InstanceCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct InstanceCreateInfoBuilder<'a> {
    inner: InstanceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsInstanceCreateInfo {}
impl<'a> ::std::ops::Deref for InstanceCreateInfoBuilder<'a> {
    type Target = InstanceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for InstanceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> InstanceCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: InstanceCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn application_info(mut self, application_info: &'a ApplicationInfo) -> Self {
        self.inner.p_application_info = application_info;
        self
    }
    #[inline]
    pub fn enabled_layer_names(mut self, enabled_layer_names: &'a [*const c_char]) -> Self {
        self.inner.enabled_layer_count = enabled_layer_names.len() as _;
        self.inner.pp_enabled_layer_names = enabled_layer_names.as_ptr();
        self
    }
    #[inline]
    pub fn enabled_extension_names(mut self, enabled_extension_names: &'a [*const c_char]) -> Self {
        self.inner.enabled_extension_count = enabled_extension_names.len() as _;
        self.inner.pp_enabled_extension_names = enabled_extension_names.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsInstanceCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> InstanceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyProperties.html>"]
pub struct QueueFamilyProperties {
    pub queue_flags: QueueFlags,
    pub queue_count: u32,
    pub timestamp_valid_bits: u32,
    pub min_image_transfer_granularity: Extent3D,
}
impl QueueFamilyProperties {
    pub fn builder<'a>() -> QueueFamilyPropertiesBuilder<'a> {
        QueueFamilyPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueueFamilyPropertiesBuilder<'a> {
    inner: QueueFamilyProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for QueueFamilyPropertiesBuilder<'a> {
    type Target = QueueFamilyProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueueFamilyPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueueFamilyPropertiesBuilder<'a> {
    #[inline]
    pub fn queue_flags(mut self, queue_flags: QueueFlags) -> Self {
        self.inner.queue_flags = queue_flags;
        self
    }
    #[inline]
    pub fn queue_count(mut self, queue_count: u32) -> Self {
        self.inner.queue_count = queue_count;
        self
    }
    #[inline]
    pub fn timestamp_valid_bits(mut self, timestamp_valid_bits: u32) -> Self {
        self.inner.timestamp_valid_bits = timestamp_valid_bits;
        self
    }
    #[inline]
    pub fn min_image_transfer_granularity(
        mut self,
        min_image_transfer_granularity: Extent3D,
    ) -> Self {
        self.inner.min_image_transfer_granularity = min_image_transfer_granularity;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueueFamilyProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryProperties.html>"]
pub struct PhysicalDeviceMemoryProperties {
    pub memory_type_count: u32,
    pub memory_types: [MemoryType; MAX_MEMORY_TYPES],
    pub memory_heap_count: u32,
    pub memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS],
}
impl ::std::default::Default for PhysicalDeviceMemoryProperties {
    #[inline]
    fn default() -> Self {
        Self {
            memory_type_count: u32::default(),
            memory_types: unsafe { ::std::mem::zeroed() },
            memory_heap_count: u32::default(),
            memory_heaps: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl PhysicalDeviceMemoryProperties {
    pub fn builder<'a>() -> PhysicalDeviceMemoryPropertiesBuilder<'a> {
        PhysicalDeviceMemoryPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMemoryPropertiesBuilder<'a> {
    inner: PhysicalDeviceMemoryProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceMemoryPropertiesBuilder<'a> {
    type Target = PhysicalDeviceMemoryProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMemoryPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMemoryPropertiesBuilder<'a> {
    #[inline]
    pub fn memory_type_count(mut self, memory_type_count: u32) -> Self {
        self.inner.memory_type_count = memory_type_count;
        self
    }
    #[inline]
    pub fn memory_types(mut self, memory_types: [MemoryType; MAX_MEMORY_TYPES]) -> Self {
        self.inner.memory_types = memory_types;
        self
    }
    #[inline]
    pub fn memory_heap_count(mut self, memory_heap_count: u32) -> Self {
        self.inner.memory_heap_count = memory_heap_count;
        self
    }
    #[inline]
    pub fn memory_heaps(mut self, memory_heaps: [MemoryHeap; MAX_MEMORY_HEAPS]) -> Self {
        self.inner.memory_heaps = memory_heaps;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMemoryProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryAllocateInfo.html>"]
pub struct MemoryAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub allocation_size: DeviceSize,
    pub memory_type_index: u32,
}
impl ::std::default::Default for MemoryAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            allocation_size: DeviceSize::default(),
            memory_type_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryAllocateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ALLOCATE_INFO;
}
impl MemoryAllocateInfo {
    pub fn builder<'a>() -> MemoryAllocateInfoBuilder<'a> {
        MemoryAllocateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryAllocateInfoBuilder<'a> {
    inner: MemoryAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryAllocateInfo {}
impl<'a> ::std::ops::Deref for MemoryAllocateInfoBuilder<'a> {
    type Target = MemoryAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryAllocateInfoBuilder<'a> {
    #[inline]
    pub fn allocation_size(mut self, allocation_size: DeviceSize) -> Self {
        self.inner.allocation_size = allocation_size;
        self
    }
    #[inline]
    pub fn memory_type_index(mut self, memory_type_index: u32) -> Self {
        self.inner.memory_type_index = memory_type_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryAllocateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryRequirements.html>"]
pub struct MemoryRequirements {
    pub size: DeviceSize,
    pub alignment: DeviceSize,
    pub memory_type_bits: u32,
}
impl MemoryRequirements {
    pub fn builder<'a>() -> MemoryRequirementsBuilder<'a> {
        MemoryRequirementsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryRequirementsBuilder<'a> {
    inner: MemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryRequirementsBuilder<'a> {
    type Target = MemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryRequirementsBuilder<'a> {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn alignment(mut self, alignment: DeviceSize) -> Self {
        self.inner.alignment = alignment;
        self
    }
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageFormatProperties.html>"]
pub struct SparseImageFormatProperties {
    pub aspect_mask: ImageAspectFlags,
    pub image_granularity: Extent3D,
    pub flags: SparseImageFormatFlags,
}
impl SparseImageFormatProperties {
    pub fn builder<'a>() -> SparseImageFormatPropertiesBuilder<'a> {
        SparseImageFormatPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageFormatPropertiesBuilder<'a> {
    inner: SparseImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageFormatPropertiesBuilder<'a> {
    type Target = SparseImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageFormatPropertiesBuilder<'a> {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn image_granularity(mut self, image_granularity: Extent3D) -> Self {
        self.inner.image_granularity = image_granularity;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseImageFormatFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryRequirements.html>"]
pub struct SparseImageMemoryRequirements {
    pub format_properties: SparseImageFormatProperties,
    pub image_mip_tail_first_lod: u32,
    pub image_mip_tail_size: DeviceSize,
    pub image_mip_tail_offset: DeviceSize,
    pub image_mip_tail_stride: DeviceSize,
}
impl SparseImageMemoryRequirements {
    pub fn builder<'a>() -> SparseImageMemoryRequirementsBuilder<'a> {
        SparseImageMemoryRequirementsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryRequirementsBuilder<'a> {
    inner: SparseImageMemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryRequirementsBuilder<'a> {
    type Target = SparseImageMemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryRequirementsBuilder<'a> {
    #[inline]
    pub fn format_properties(mut self, format_properties: SparseImageFormatProperties) -> Self {
        self.inner.format_properties = format_properties;
        self
    }
    #[inline]
    pub fn image_mip_tail_first_lod(mut self, image_mip_tail_first_lod: u32) -> Self {
        self.inner.image_mip_tail_first_lod = image_mip_tail_first_lod;
        self
    }
    #[inline]
    pub fn image_mip_tail_size(mut self, image_mip_tail_size: DeviceSize) -> Self {
        self.inner.image_mip_tail_size = image_mip_tail_size;
        self
    }
    #[inline]
    pub fn image_mip_tail_offset(mut self, image_mip_tail_offset: DeviceSize) -> Self {
        self.inner.image_mip_tail_offset = image_mip_tail_offset;
        self
    }
    #[inline]
    pub fn image_mip_tail_stride(mut self, image_mip_tail_stride: DeviceSize) -> Self {
        self.inner.image_mip_tail_stride = image_mip_tail_stride;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryType.html>"]
pub struct MemoryType {
    pub property_flags: MemoryPropertyFlags,
    pub heap_index: u32,
}
impl MemoryType {
    pub fn builder<'a>() -> MemoryTypeBuilder<'a> {
        MemoryTypeBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryTypeBuilder<'a> {
    inner: MemoryType,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryTypeBuilder<'a> {
    type Target = MemoryType;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryTypeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryTypeBuilder<'a> {
    #[inline]
    pub fn property_flags(mut self, property_flags: MemoryPropertyFlags) -> Self {
        self.inner.property_flags = property_flags;
        self
    }
    #[inline]
    pub fn heap_index(mut self, heap_index: u32) -> Self {
        self.inner.heap_index = heap_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryType {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryHeap.html>"]
pub struct MemoryHeap {
    pub size: DeviceSize,
    pub flags: MemoryHeapFlags,
}
impl MemoryHeap {
    pub fn builder<'a>() -> MemoryHeapBuilder<'a> {
        MemoryHeapBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryHeapBuilder<'a> {
    inner: MemoryHeap,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryHeapBuilder<'a> {
    type Target = MemoryHeap;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryHeapBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryHeapBuilder<'a> {
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: MemoryHeapFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryHeap {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMappedMemoryRange.html>"]
pub struct MappedMemoryRange {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}
impl ::std::default::Default for MappedMemoryRange {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for MappedMemoryRange {
    const STRUCTURE_TYPE: StructureType = StructureType::MAPPED_MEMORY_RANGE;
}
impl MappedMemoryRange {
    pub fn builder<'a>() -> MappedMemoryRangeBuilder<'a> {
        MappedMemoryRangeBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MappedMemoryRangeBuilder<'a> {
    inner: MappedMemoryRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MappedMemoryRangeBuilder<'a> {
    type Target = MappedMemoryRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MappedMemoryRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MappedMemoryRangeBuilder<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MappedMemoryRange {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFormatProperties.html>"]
pub struct FormatProperties {
    pub linear_tiling_features: FormatFeatureFlags,
    pub optimal_tiling_features: FormatFeatureFlags,
    pub buffer_features: FormatFeatureFlags,
}
impl FormatProperties {
    pub fn builder<'a>() -> FormatPropertiesBuilder<'a> {
        FormatPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FormatPropertiesBuilder<'a> {
    inner: FormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for FormatPropertiesBuilder<'a> {
    type Target = FormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FormatPropertiesBuilder<'a> {
    #[inline]
    pub fn linear_tiling_features(mut self, linear_tiling_features: FormatFeatureFlags) -> Self {
        self.inner.linear_tiling_features = linear_tiling_features;
        self
    }
    #[inline]
    pub fn optimal_tiling_features(mut self, optimal_tiling_features: FormatFeatureFlags) -> Self {
        self.inner.optimal_tiling_features = optimal_tiling_features;
        self
    }
    #[inline]
    pub fn buffer_features(mut self, buffer_features: FormatFeatureFlags) -> Self {
        self.inner.buffer_features = buffer_features;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FormatProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageFormatProperties.html>"]
pub struct ImageFormatProperties {
    pub max_extent: Extent3D,
    pub max_mip_levels: u32,
    pub max_array_layers: u32,
    pub sample_counts: SampleCountFlags,
    pub max_resource_size: DeviceSize,
}
impl ImageFormatProperties {
    pub fn builder<'a>() -> ImageFormatPropertiesBuilder<'a> {
        ImageFormatPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageFormatPropertiesBuilder<'a> {
    inner: ImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageFormatPropertiesBuilder<'a> {
    type Target = ImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageFormatPropertiesBuilder<'a> {
    #[inline]
    pub fn max_extent(mut self, max_extent: Extent3D) -> Self {
        self.inner.max_extent = max_extent;
        self
    }
    #[inline]
    pub fn max_mip_levels(mut self, max_mip_levels: u32) -> Self {
        self.inner.max_mip_levels = max_mip_levels;
        self
    }
    #[inline]
    pub fn max_array_layers(mut self, max_array_layers: u32) -> Self {
        self.inner.max_array_layers = max_array_layers;
        self
    }
    #[inline]
    pub fn sample_counts(mut self, sample_counts: SampleCountFlags) -> Self {
        self.inner.sample_counts = sample_counts;
        self
    }
    #[inline]
    pub fn max_resource_size(mut self, max_resource_size: DeviceSize) -> Self {
        self.inner.max_resource_size = max_resource_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorBufferInfo.html>"]
pub struct DescriptorBufferInfo {
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}
impl DescriptorBufferInfo {
    pub fn builder<'a>() -> DescriptorBufferInfoBuilder<'a> {
        DescriptorBufferInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorBufferInfoBuilder<'a> {
    inner: DescriptorBufferInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorBufferInfoBuilder<'a> {
    type Target = DescriptorBufferInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorBufferInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorBufferInfoBuilder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.inner.range = range;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorBufferInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorImageInfo.html>"]
pub struct DescriptorImageInfo {
    pub sampler: Sampler,
    pub image_view: ImageView,
    pub image_layout: ImageLayout,
}
impl DescriptorImageInfo {
    pub fn builder<'a>() -> DescriptorImageInfoBuilder<'a> {
        DescriptorImageInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorImageInfoBuilder<'a> {
    inner: DescriptorImageInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorImageInfoBuilder<'a> {
    type Target = DescriptorImageInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorImageInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorImageInfoBuilder<'a> {
    #[inline]
    pub fn sampler(mut self, sampler: Sampler) -> Self {
        self.inner.sampler = sampler;
        self
    }
    #[inline]
    pub fn image_view(mut self, image_view: ImageView) -> Self {
        self.inner.image_view = image_view;
        self
    }
    #[inline]
    pub fn image_layout(mut self, image_layout: ImageLayout) -> Self {
        self.inner.image_layout = image_layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorImageInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSet.html>"]
pub struct WriteDescriptorSet {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub p_image_info: *const DescriptorImageInfo,
    pub p_buffer_info: *const DescriptorBufferInfo,
    pub p_texel_buffer_view: *const BufferView,
}
impl ::std::default::Default for WriteDescriptorSet {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
            descriptor_type: DescriptorType::default(),
            p_image_info: ::std::ptr::null(),
            p_buffer_info: ::std::ptr::null(),
            p_texel_buffer_view: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for WriteDescriptorSet {
    const STRUCTURE_TYPE: StructureType = StructureType::WRITE_DESCRIPTOR_SET;
}
impl WriteDescriptorSet {
    pub fn builder<'a>() -> WriteDescriptorSetBuilder<'a> {
        WriteDescriptorSetBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct WriteDescriptorSetBuilder<'a> {
    inner: WriteDescriptorSet,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsWriteDescriptorSet {}
impl<'a> ::std::ops::Deref for WriteDescriptorSetBuilder<'a> {
    type Target = WriteDescriptorSet;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for WriteDescriptorSetBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> WriteDescriptorSetBuilder<'a> {
    #[inline]
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> Self {
        self.inner.dst_set = dst_set;
        self
    }
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.inner.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.inner.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.inner.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn image_info(mut self, image_info: &'a [DescriptorImageInfo]) -> Self {
        self.inner.descriptor_count = image_info.len() as _;
        self.inner.p_image_info = image_info.as_ptr();
        self
    }
    #[inline]
    pub fn buffer_info(mut self, buffer_info: &'a [DescriptorBufferInfo]) -> Self {
        self.inner.descriptor_count = buffer_info.len() as _;
        self.inner.p_buffer_info = buffer_info.as_ptr();
        self
    }
    #[inline]
    pub fn texel_buffer_view(mut self, texel_buffer_view: &'a [BufferView]) -> Self {
        self.inner.descriptor_count = texel_buffer_view.len() as _;
        self.inner.p_texel_buffer_view = texel_buffer_view.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsWriteDescriptorSet>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> WriteDescriptorSet {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCopyDescriptorSet.html>"]
pub struct CopyDescriptorSet {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_set: DescriptorSet,
    pub src_binding: u32,
    pub src_array_element: u32,
    pub dst_set: DescriptorSet,
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
}
impl ::std::default::Default for CopyDescriptorSet {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_set: DescriptorSet::default(),
            src_binding: u32::default(),
            src_array_element: u32::default(),
            dst_set: DescriptorSet::default(),
            dst_binding: u32::default(),
            dst_array_element: u32::default(),
            descriptor_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for CopyDescriptorSet {
    const STRUCTURE_TYPE: StructureType = StructureType::COPY_DESCRIPTOR_SET;
}
impl CopyDescriptorSet {
    pub fn builder<'a>() -> CopyDescriptorSetBuilder<'a> {
        CopyDescriptorSetBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CopyDescriptorSetBuilder<'a> {
    inner: CopyDescriptorSet,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for CopyDescriptorSetBuilder<'a> {
    type Target = CopyDescriptorSet;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CopyDescriptorSetBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CopyDescriptorSetBuilder<'a> {
    #[inline]
    pub fn src_set(mut self, src_set: DescriptorSet) -> Self {
        self.inner.src_set = src_set;
        self
    }
    #[inline]
    pub fn src_binding(mut self, src_binding: u32) -> Self {
        self.inner.src_binding = src_binding;
        self
    }
    #[inline]
    pub fn src_array_element(mut self, src_array_element: u32) -> Self {
        self.inner.src_array_element = src_array_element;
        self
    }
    #[inline]
    pub fn dst_set(mut self, dst_set: DescriptorSet) -> Self {
        self.inner.dst_set = dst_set;
        self
    }
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.inner.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.inner.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CopyDescriptorSet {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferCreateInfo.html>"]
pub struct BufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub size: DeviceSize,
    pub usage: BufferUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
}
impl ::std::default::Default for BufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: BufferCreateFlags::default(),
            size: DeviceSize::default(),
            usage: BufferUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for BufferCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_CREATE_INFO;
}
impl BufferCreateInfo {
    pub fn builder<'a>() -> BufferCreateInfoBuilder<'a> {
        BufferCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferCreateInfoBuilder<'a> {
    inner: BufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBufferCreateInfo {}
impl<'a> ::std::ops::Deref for BufferCreateInfoBuilder<'a> {
    type Target = BufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.inner.sharing_mode = sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferViewCreateInfo.html>"]
pub struct BufferViewCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferViewCreateFlags,
    pub buffer: Buffer,
    pub format: Format,
    pub offset: DeviceSize,
    pub range: DeviceSize,
}
impl ::std::default::Default for BufferViewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: BufferViewCreateFlags::default(),
            buffer: Buffer::default(),
            format: Format::default(),
            offset: DeviceSize::default(),
            range: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for BufferViewCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_VIEW_CREATE_INFO;
}
impl BufferViewCreateInfo {
    pub fn builder<'a>() -> BufferViewCreateInfoBuilder<'a> {
        BufferViewCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferViewCreateInfoBuilder<'a> {
    inner: BufferViewCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBufferViewCreateInfo {}
impl<'a> ::std::ops::Deref for BufferViewCreateInfoBuilder<'a> {
    type Target = BufferViewCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferViewCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferViewCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferViewCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn range(mut self, range: DeviceSize) -> Self {
        self.inner.range = range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBufferViewCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferViewCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageSubresource.html>"]
pub struct ImageSubresource {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub array_layer: u32,
}
impl ImageSubresource {
    pub fn builder<'a>() -> ImageSubresourceBuilder<'a> {
        ImageSubresourceBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceBuilder<'a> {
    inner: ImageSubresource,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceBuilder<'a> {
    type Target = ImageSubresource;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceBuilder<'a> {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.inner.mip_level = mip_level;
        self
    }
    #[inline]
    pub fn array_layer(mut self, array_layer: u32) -> Self {
        self.inner.array_layer = array_layer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresource {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageSubresourceLayers.html>"]
pub struct ImageSubresourceLayers {
    pub aspect_mask: ImageAspectFlags,
    pub mip_level: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceLayers {
    pub fn builder<'a>() -> ImageSubresourceLayersBuilder<'a> {
        ImageSubresourceLayersBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceLayersBuilder<'a> {
    inner: ImageSubresourceLayers,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceLayersBuilder<'a> {
    type Target = ImageSubresourceLayers;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceLayersBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceLayersBuilder<'a> {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn mip_level(mut self, mip_level: u32) -> Self {
        self.inner.mip_level = mip_level;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresourceLayers {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageSubresourceRange.html>"]
pub struct ImageSubresourceRange {
    pub aspect_mask: ImageAspectFlags,
    pub base_mip_level: u32,
    pub level_count: u32,
    pub base_array_layer: u32,
    pub layer_count: u32,
}
impl ImageSubresourceRange {
    pub fn builder<'a>() -> ImageSubresourceRangeBuilder<'a> {
        ImageSubresourceRangeBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSubresourceRangeBuilder<'a> {
    inner: ImageSubresourceRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSubresourceRangeBuilder<'a> {
    type Target = ImageSubresourceRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSubresourceRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSubresourceRangeBuilder<'a> {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn base_mip_level(mut self, base_mip_level: u32) -> Self {
        self.inner.base_mip_level = base_mip_level;
        self
    }
    #[inline]
    pub fn level_count(mut self, level_count: u32) -> Self {
        self.inner.level_count = level_count;
        self
    }
    #[inline]
    pub fn base_array_layer(mut self, base_array_layer: u32) -> Self {
        self.inner.base_array_layer = base_array_layer;
        self
    }
    #[inline]
    pub fn layer_count(mut self, layer_count: u32) -> Self {
        self.inner.layer_count = layer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSubresourceRange {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryBarrier.html>"]
pub struct MemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
}
impl ::std::default::Default for MemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryBarrier {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_BARRIER;
}
impl MemoryBarrier {
    pub fn builder<'a>() -> MemoryBarrierBuilder<'a> {
        MemoryBarrierBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryBarrierBuilder<'a> {
    inner: MemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryBarrierBuilder<'a> {
    type Target = MemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryBarrierBuilder<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferMemoryBarrier.html>"]
pub struct BufferMemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub size: DeviceSize,
}
impl ::std::default::Default for BufferMemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            size: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for BufferMemoryBarrier {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_MEMORY_BARRIER;
}
impl BufferMemoryBarrier {
    pub fn builder<'a>() -> BufferMemoryBarrierBuilder<'a> {
        BufferMemoryBarrierBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferMemoryBarrierBuilder<'a> {
    inner: BufferMemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferMemoryBarrierBuilder<'a> {
    type Target = BufferMemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferMemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferMemoryBarrierBuilder<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.inner.src_queue_family_index = src_queue_family_index;
        self
    }
    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.inner.dst_queue_family_index = dst_queue_family_index;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferMemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageMemoryBarrier.html>"]
pub struct ImageMemoryBarrier {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub old_layout: ImageLayout,
    pub new_layout: ImageLayout,
    pub src_queue_family_index: u32,
    pub dst_queue_family_index: u32,
    pub image: Image,
    pub subresource_range: ImageSubresourceRange,
}
impl ::std::default::Default for ImageMemoryBarrier {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_access_mask: AccessFlags::default(),
            dst_access_mask: AccessFlags::default(),
            old_layout: ImageLayout::default(),
            new_layout: ImageLayout::default(),
            src_queue_family_index: u32::default(),
            dst_queue_family_index: u32::default(),
            image: Image::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageMemoryBarrier {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_MEMORY_BARRIER;
}
impl ImageMemoryBarrier {
    pub fn builder<'a>() -> ImageMemoryBarrierBuilder<'a> {
        ImageMemoryBarrierBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageMemoryBarrierBuilder<'a> {
    inner: ImageMemoryBarrier,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageMemoryBarrier {}
impl<'a> ::std::ops::Deref for ImageMemoryBarrierBuilder<'a> {
    type Target = ImageMemoryBarrier;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageMemoryBarrierBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageMemoryBarrierBuilder<'a> {
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn old_layout(mut self, old_layout: ImageLayout) -> Self {
        self.inner.old_layout = old_layout;
        self
    }
    #[inline]
    pub fn new_layout(mut self, new_layout: ImageLayout) -> Self {
        self.inner.new_layout = new_layout;
        self
    }
    #[inline]
    pub fn src_queue_family_index(mut self, src_queue_family_index: u32) -> Self {
        self.inner.src_queue_family_index = src_queue_family_index;
        self
    }
    #[inline]
    pub fn dst_queue_family_index(mut self, dst_queue_family_index: u32) -> Self {
        self.inner.dst_queue_family_index = dst_queue_family_index;
        self
    }
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn subresource_range(mut self, subresource_range: ImageSubresourceRange) -> Self {
        self.inner.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageMemoryBarrier>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageMemoryBarrier {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageCreateInfo.html>"]
pub struct ImageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageCreateFlags,
    pub image_type: ImageType,
    pub format: Format,
    pub extent: Extent3D,
    pub mip_levels: u32,
    pub array_layers: u32,
    pub samples: SampleCountFlags,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub initial_layout: ImageLayout,
}
impl ::std::default::Default for ImageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ImageCreateFlags::default(),
            image_type: ImageType::default(),
            format: Format::default(),
            extent: Extent3D::default(),
            mip_levels: u32::default(),
            array_layers: u32::default(),
            samples: SampleCountFlags::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
            initial_layout: ImageLayout::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_CREATE_INFO;
}
impl ImageCreateInfo {
    pub fn builder<'a>() -> ImageCreateInfoBuilder<'a> {
        ImageCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageCreateInfoBuilder<'a> {
    inner: ImageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageCreateInfo {}
impl<'a> ::std::ops::Deref for ImageCreateInfoBuilder<'a> {
    type Target = ImageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn image_type(mut self, image_type: ImageType) -> Self {
        self.inner.image_type = image_type;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[inline]
    pub fn mip_levels(mut self, mip_levels: u32) -> Self {
        self.inner.mip_levels = mip_levels;
        self
    }
    #[inline]
    pub fn array_layers(mut self, array_layers: u32) -> Self {
        self.inner.array_layers = array_layers;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.inner.samples = samples;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.inner.tiling = tiling;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[inline]
    pub fn sharing_mode(mut self, sharing_mode: SharingMode) -> Self {
        self.inner.sharing_mode = sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.inner.initial_layout = initial_layout;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSubresourceLayout.html>"]
pub struct SubresourceLayout {
    pub offset: DeviceSize,
    pub size: DeviceSize,
    pub row_pitch: DeviceSize,
    pub array_pitch: DeviceSize,
    pub depth_pitch: DeviceSize,
}
impl SubresourceLayout {
    pub fn builder<'a>() -> SubresourceLayoutBuilder<'a> {
        SubresourceLayoutBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubresourceLayoutBuilder<'a> {
    inner: SubresourceLayout,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubresourceLayoutBuilder<'a> {
    type Target = SubresourceLayout;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubresourceLayoutBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubresourceLayoutBuilder<'a> {
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn row_pitch(mut self, row_pitch: DeviceSize) -> Self {
        self.inner.row_pitch = row_pitch;
        self
    }
    #[inline]
    pub fn array_pitch(mut self, array_pitch: DeviceSize) -> Self {
        self.inner.array_pitch = array_pitch;
        self
    }
    #[inline]
    pub fn depth_pitch(mut self, depth_pitch: DeviceSize) -> Self {
        self.inner.depth_pitch = depth_pitch;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubresourceLayout {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageViewCreateInfo.html>"]
pub struct ImageViewCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImageViewCreateFlags,
    pub image: Image,
    pub view_type: ImageViewType,
    pub format: Format,
    pub components: ComponentMapping,
    pub subresource_range: ImageSubresourceRange,
}
impl ::std::default::Default for ImageViewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ImageViewCreateFlags::default(),
            image: Image::default(),
            view_type: ImageViewType::default(),
            format: Format::default(),
            components: ComponentMapping::default(),
            subresource_range: ImageSubresourceRange::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageViewCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_CREATE_INFO;
}
impl ImageViewCreateInfo {
    pub fn builder<'a>() -> ImageViewCreateInfoBuilder<'a> {
        ImageViewCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageViewCreateInfoBuilder<'a> {
    inner: ImageViewCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageViewCreateInfo {}
impl<'a> ::std::ops::Deref for ImageViewCreateInfoBuilder<'a> {
    type Target = ImageViewCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageViewCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageViewCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImageViewCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn view_type(mut self, view_type: ImageViewType) -> Self {
        self.inner.view_type = view_type;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn components(mut self, components: ComponentMapping) -> Self {
        self.inner.components = components;
        self
    }
    #[inline]
    pub fn subresource_range(mut self, subresource_range: ImageSubresourceRange) -> Self {
        self.inner.subresource_range = subresource_range;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageViewCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageViewCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferCopy.html>"]
pub struct BufferCopy {
    pub src_offset: DeviceSize,
    pub dst_offset: DeviceSize,
    pub size: DeviceSize,
}
impl BufferCopy {
    pub fn builder<'a>() -> BufferCopyBuilder<'a> {
        BufferCopyBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferCopyBuilder<'a> {
    inner: BufferCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferCopyBuilder<'a> {
    type Target = BufferCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferCopyBuilder<'a> {
    #[inline]
    pub fn src_offset(mut self, src_offset: DeviceSize) -> Self {
        self.inner.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: DeviceSize) -> Self {
        self.inner.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferCopy {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseMemoryBind.html>"]
pub struct SparseMemoryBind {
    pub resource_offset: DeviceSize,
    pub size: DeviceSize,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseMemoryBind {
    pub fn builder<'a>() -> SparseMemoryBindBuilder<'a> {
        SparseMemoryBindBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseMemoryBindBuilder<'a> {
    inner: SparseMemoryBind,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseMemoryBindBuilder<'a> {
    type Target = SparseMemoryBind;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseMemoryBindBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseMemoryBindBuilder<'a> {
    #[inline]
    pub fn resource_offset(mut self, resource_offset: DeviceSize) -> Self {
        self.inner.resource_offset = resource_offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.inner.memory_offset = memory_offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseMemoryBind {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryBind.html>"]
pub struct SparseImageMemoryBind {
    pub subresource: ImageSubresource,
    pub offset: Offset3D,
    pub extent: Extent3D,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
    pub flags: SparseMemoryBindFlags,
}
impl SparseImageMemoryBind {
    pub fn builder<'a>() -> SparseImageMemoryBindBuilder<'a> {
        SparseImageMemoryBindBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryBindBuilder<'a> {
    inner: SparseImageMemoryBind,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryBindBuilder<'a> {
    type Target = SparseImageMemoryBind;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryBindBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryBindBuilder<'a> {
    #[inline]
    pub fn subresource(mut self, subresource: ImageSubresource) -> Self {
        self.inner.subresource = subresource;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: Offset3D) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.inner.memory_offset = memory_offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SparseMemoryBindFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryBind {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseBufferMemoryBindInfo.html>"]
pub struct SparseBufferMemoryBindInfo {
    pub buffer: Buffer,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
}
impl ::std::default::Default for SparseBufferMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            buffer: Buffer::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseBufferMemoryBindInfo {
    pub fn builder<'a>() -> SparseBufferMemoryBindInfoBuilder<'a> {
        SparseBufferMemoryBindInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseBufferMemoryBindInfoBuilder<'a> {
    inner: SparseBufferMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseBufferMemoryBindInfoBuilder<'a> {
    type Target = SparseBufferMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseBufferMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseBufferMemoryBindInfoBuilder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseMemoryBind]) -> Self {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseBufferMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageOpaqueMemoryBindInfo.html>"]
pub struct SparseImageOpaqueMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseMemoryBind,
}
impl ::std::default::Default for SparseImageOpaqueMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseImageOpaqueMemoryBindInfo {
    pub fn builder<'a>() -> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
        SparseImageOpaqueMemoryBindInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    inner: SparseImageOpaqueMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    type Target = SparseImageOpaqueMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageOpaqueMemoryBindInfoBuilder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseMemoryBind]) -> Self {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageOpaqueMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryBindInfo.html>"]
pub struct SparseImageMemoryBindInfo {
    pub image: Image,
    pub bind_count: u32,
    pub p_binds: *const SparseImageMemoryBind,
}
impl ::std::default::Default for SparseImageMemoryBindInfo {
    #[inline]
    fn default() -> Self {
        Self {
            image: Image::default(),
            bind_count: u32::default(),
            p_binds: ::std::ptr::null(),
        }
    }
}
impl SparseImageMemoryBindInfo {
    pub fn builder<'a>() -> SparseImageMemoryBindInfoBuilder<'a> {
        SparseImageMemoryBindInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryBindInfoBuilder<'a> {
    inner: SparseImageMemoryBindInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryBindInfoBuilder<'a> {
    type Target = SparseImageMemoryBindInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryBindInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryBindInfoBuilder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn binds(mut self, binds: &'a [SparseImageMemoryBind]) -> Self {
        self.inner.bind_count = binds.len() as _;
        self.inner.p_binds = binds.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryBindInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindSparseInfo.html>"]
pub struct BindSparseInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub buffer_bind_count: u32,
    pub p_buffer_binds: *const SparseBufferMemoryBindInfo,
    pub image_opaque_bind_count: u32,
    pub p_image_opaque_binds: *const SparseImageOpaqueMemoryBindInfo,
    pub image_bind_count: u32,
    pub p_image_binds: *const SparseImageMemoryBindInfo,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
}
impl ::std::default::Default for BindSparseInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            buffer_bind_count: u32::default(),
            p_buffer_binds: ::std::ptr::null(),
            image_opaque_bind_count: u32::default(),
            p_image_opaque_binds: ::std::ptr::null(),
            image_bind_count: u32::default(),
            p_image_binds: ::std::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for BindSparseInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_SPARSE_INFO;
}
impl BindSparseInfo {
    pub fn builder<'a>() -> BindSparseInfoBuilder<'a> {
        BindSparseInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindSparseInfoBuilder<'a> {
    inner: BindSparseInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBindSparseInfo {}
impl<'a> ::std::ops::Deref for BindSparseInfoBuilder<'a> {
    type Target = BindSparseInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindSparseInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindSparseInfoBuilder<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn buffer_binds(mut self, buffer_binds: &'a [SparseBufferMemoryBindInfo]) -> Self {
        self.inner.buffer_bind_count = buffer_binds.len() as _;
        self.inner.p_buffer_binds = buffer_binds.as_ptr();
        self
    }
    #[inline]
    pub fn image_opaque_binds(
        mut self,
        image_opaque_binds: &'a [SparseImageOpaqueMemoryBindInfo],
    ) -> Self {
        self.inner.image_opaque_bind_count = image_opaque_binds.len() as _;
        self.inner.p_image_opaque_binds = image_opaque_binds.as_ptr();
        self
    }
    #[inline]
    pub fn image_binds(mut self, image_binds: &'a [SparseImageMemoryBindInfo]) -> Self {
        self.inner.image_bind_count = image_binds.len() as _;
        self.inner.p_image_binds = image_binds.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphores(mut self, signal_semaphores: &'a [Semaphore]) -> Self {
        self.inner.signal_semaphore_count = signal_semaphores.len() as _;
        self.inner.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindSparseInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindSparseInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageCopy.html>"]
pub struct ImageCopy {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageCopy {
    pub fn builder<'a>() -> ImageCopyBuilder<'a> {
        ImageCopyBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageCopyBuilder<'a> {
    inner: ImageCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageCopyBuilder<'a> {
    type Target = ImageCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageCopyBuilder<'a> {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.inner.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offset(mut self, src_offset: Offset3D) -> Self {
        self.inner.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> Self {
        self.inner.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageCopy {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageBlit.html>"]
pub struct ImageBlit {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offsets: [Offset3D; 2],
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offsets: [Offset3D; 2],
}
impl ::std::default::Default for ImageBlit {
    #[inline]
    fn default() -> Self {
        Self {
            src_subresource: ImageSubresourceLayers::default(),
            src_offsets: unsafe { ::std::mem::zeroed() },
            dst_subresource: ImageSubresourceLayers::default(),
            dst_offsets: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl ImageBlit {
    pub fn builder<'a>() -> ImageBlitBuilder<'a> {
        ImageBlitBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageBlitBuilder<'a> {
    inner: ImageBlit,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageBlitBuilder<'a> {
    type Target = ImageBlit;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageBlitBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageBlitBuilder<'a> {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.inner.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offsets(mut self, src_offsets: [Offset3D; 2]) -> Self {
        self.inner.src_offsets = src_offsets;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offsets(mut self, dst_offsets: [Offset3D; 2]) -> Self {
        self.inner.dst_offsets = dst_offsets;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageBlit {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferImageCopy.html>"]
pub struct BufferImageCopy {
    pub buffer_offset: DeviceSize,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}
impl BufferImageCopy {
    pub fn builder<'a>() -> BufferImageCopyBuilder<'a> {
        BufferImageCopyBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferImageCopyBuilder<'a> {
    inner: BufferImageCopy,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferImageCopyBuilder<'a> {
    type Target = BufferImageCopy;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferImageCopyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferImageCopyBuilder<'a> {
    #[inline]
    pub fn buffer_offset(mut self, buffer_offset: DeviceSize) -> Self {
        self.inner.buffer_offset = buffer_offset;
        self
    }
    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.inner.buffer_row_length = buffer_row_length;
        self
    }
    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.inner.buffer_image_height = buffer_image_height;
        self
    }
    #[inline]
    pub fn image_subresource(mut self, image_subresource: ImageSubresourceLayers) -> Self {
        self.inner.image_subresource = image_subresource;
        self
    }
    #[inline]
    pub fn image_offset(mut self, image_offset: Offset3D) -> Self {
        self.inner.image_offset = image_offset;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent3D) -> Self {
        self.inner.image_extent = image_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferImageCopy {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCopyMemoryIndirectCommandNV.html>"]
pub struct CopyMemoryIndirectCommandNV {
    pub src_address: DeviceAddress,
    pub dst_address: DeviceAddress,
    pub size: DeviceSize,
}
impl CopyMemoryIndirectCommandNV {
    pub fn builder<'a>() -> CopyMemoryIndirectCommandNVBuilder<'a> {
        CopyMemoryIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CopyMemoryIndirectCommandNVBuilder<'a> {
    inner: CopyMemoryIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for CopyMemoryIndirectCommandNVBuilder<'a> {
    type Target = CopyMemoryIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CopyMemoryIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CopyMemoryIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn src_address(mut self, src_address: DeviceAddress) -> Self {
        self.inner.src_address = src_address;
        self
    }
    #[inline]
    pub fn dst_address(mut self, dst_address: DeviceAddress) -> Self {
        self.inner.dst_address = dst_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: DeviceSize) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CopyMemoryIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCopyMemoryToImageIndirectCommandNV.html>"]
pub struct CopyMemoryToImageIndirectCommandNV {
    pub src_address: DeviceAddress,
    pub buffer_row_length: u32,
    pub buffer_image_height: u32,
    pub image_subresource: ImageSubresourceLayers,
    pub image_offset: Offset3D,
    pub image_extent: Extent3D,
}
impl CopyMemoryToImageIndirectCommandNV {
    pub fn builder<'a>() -> CopyMemoryToImageIndirectCommandNVBuilder<'a> {
        CopyMemoryToImageIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CopyMemoryToImageIndirectCommandNVBuilder<'a> {
    inner: CopyMemoryToImageIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for CopyMemoryToImageIndirectCommandNVBuilder<'a> {
    type Target = CopyMemoryToImageIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CopyMemoryToImageIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CopyMemoryToImageIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn src_address(mut self, src_address: DeviceAddress) -> Self {
        self.inner.src_address = src_address;
        self
    }
    #[inline]
    pub fn buffer_row_length(mut self, buffer_row_length: u32) -> Self {
        self.inner.buffer_row_length = buffer_row_length;
        self
    }
    #[inline]
    pub fn buffer_image_height(mut self, buffer_image_height: u32) -> Self {
        self.inner.buffer_image_height = buffer_image_height;
        self
    }
    #[inline]
    pub fn image_subresource(mut self, image_subresource: ImageSubresourceLayers) -> Self {
        self.inner.image_subresource = image_subresource;
        self
    }
    #[inline]
    pub fn image_offset(mut self, image_offset: Offset3D) -> Self {
        self.inner.image_offset = image_offset;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent3D) -> Self {
        self.inner.image_extent = image_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CopyMemoryToImageIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageResolve.html>"]
pub struct ImageResolve {
    pub src_subresource: ImageSubresourceLayers,
    pub src_offset: Offset3D,
    pub dst_subresource: ImageSubresourceLayers,
    pub dst_offset: Offset3D,
    pub extent: Extent3D,
}
impl ImageResolve {
    pub fn builder<'a>() -> ImageResolveBuilder<'a> {
        ImageResolveBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageResolveBuilder<'a> {
    inner: ImageResolve,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageResolveBuilder<'a> {
    type Target = ImageResolve;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageResolveBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageResolveBuilder<'a> {
    #[inline]
    pub fn src_subresource(mut self, src_subresource: ImageSubresourceLayers) -> Self {
        self.inner.src_subresource = src_subresource;
        self
    }
    #[inline]
    pub fn src_offset(mut self, src_offset: Offset3D) -> Self {
        self.inner.src_offset = src_offset;
        self
    }
    #[inline]
    pub fn dst_subresource(mut self, dst_subresource: ImageSubresourceLayers) -> Self {
        self.inner.dst_subresource = dst_subresource;
        self
    }
    #[inline]
    pub fn dst_offset(mut self, dst_offset: Offset3D) -> Self {
        self.inner.dst_offset = dst_offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent3D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageResolve {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkShaderModuleCreateInfo.html>"]
pub struct ShaderModuleCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ShaderModuleCreateFlags,
    pub code_size: usize,
    pub p_code: *const u32,
}
impl ::std::default::Default for ShaderModuleCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ShaderModuleCreateFlags::default(),
            code_size: usize::default(),
            p_code: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for ShaderModuleCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SHADER_MODULE_CREATE_INFO;
}
impl ShaderModuleCreateInfo {
    pub fn builder<'a>() -> ShaderModuleCreateInfoBuilder<'a> {
        ShaderModuleCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ShaderModuleCreateInfoBuilder<'a> {
    inner: ShaderModuleCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineShaderStageCreateInfo for ShaderModuleCreateInfoBuilder<'_> {}
unsafe impl ExtendsPipelineShaderStageCreateInfo for ShaderModuleCreateInfo {}
pub unsafe trait ExtendsShaderModuleCreateInfo {}
impl<'a> ::std::ops::Deref for ShaderModuleCreateInfoBuilder<'a> {
    type Target = ShaderModuleCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ShaderModuleCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ShaderModuleCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ShaderModuleCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn code(mut self, code: &'a [u32]) -> Self {
        self.inner.code_size = code.len() * 4;
        self.inner.p_code = code.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsShaderModuleCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ShaderModuleCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutBinding.html>"]
pub struct DescriptorSetLayoutBinding {
    pub binding: u32,
    pub descriptor_type: DescriptorType,
    pub descriptor_count: u32,
    pub stage_flags: ShaderStageFlags,
    pub p_immutable_samplers: *const Sampler,
}
impl ::std::default::Default for DescriptorSetLayoutBinding {
    #[inline]
    fn default() -> Self {
        Self {
            binding: u32::default(),
            descriptor_type: DescriptorType::default(),
            descriptor_count: u32::default(),
            stage_flags: ShaderStageFlags::default(),
            p_immutable_samplers: ::std::ptr::null(),
        }
    }
}
impl DescriptorSetLayoutBinding {
    pub fn builder<'a>() -> DescriptorSetLayoutBindingBuilder<'a> {
        DescriptorSetLayoutBindingBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetLayoutBindingBuilder<'a> {
    inner: DescriptorSetLayoutBinding,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorSetLayoutBindingBuilder<'a> {
    type Target = DescriptorSetLayoutBinding;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetLayoutBindingBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetLayoutBindingBuilder<'a> {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.inner.binding = binding;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.inner.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[inline]
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> Self {
        self.inner.stage_flags = stage_flags;
        self
    }
    #[inline]
    pub fn immutable_samplers(mut self, immutable_samplers: &'a [Sampler]) -> Self {
        self.inner.descriptor_count = immutable_samplers.len() as _;
        self.inner.p_immutable_samplers = immutable_samplers.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetLayoutBinding {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutCreateInfo.html>"]
pub struct DescriptorSetLayoutCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorSetLayoutCreateFlags,
    pub binding_count: u32,
    pub p_bindings: *const DescriptorSetLayoutBinding,
}
impl ::std::default::Default for DescriptorSetLayoutCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DescriptorSetLayoutCreateFlags::default(),
            binding_count: u32::default(),
            p_bindings: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorSetLayoutCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_LAYOUT_CREATE_INFO;
}
impl DescriptorSetLayoutCreateInfo {
    pub fn builder<'a>() -> DescriptorSetLayoutCreateInfoBuilder<'a> {
        DescriptorSetLayoutCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetLayoutCreateInfoBuilder<'a> {
    inner: DescriptorSetLayoutCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorSetLayoutCreateInfo {}
impl<'a> ::std::ops::Deref for DescriptorSetLayoutCreateInfoBuilder<'a> {
    type Target = DescriptorSetLayoutCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetLayoutCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetLayoutCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorSetLayoutCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn bindings(mut self, bindings: &'a [DescriptorSetLayoutBinding]) -> Self {
        self.inner.binding_count = bindings.len() as _;
        self.inner.p_bindings = bindings.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetLayoutCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetLayoutCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolSize.html>"]
pub struct DescriptorPoolSize {
    pub ty: DescriptorType,
    pub descriptor_count: u32,
}
impl DescriptorPoolSize {
    pub fn builder<'a>() -> DescriptorPoolSizeBuilder<'a> {
        DescriptorPoolSizeBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorPoolSizeBuilder<'a> {
    inner: DescriptorPoolSize,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorPoolSizeBuilder<'a> {
    type Target = DescriptorPoolSize;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorPoolSizeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorPoolSizeBuilder<'a> {
    #[inline]
    pub fn ty(mut self, ty: DescriptorType) -> Self {
        self.inner.ty = ty;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorPoolSize {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolCreateInfo.html>"]
pub struct DescriptorPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorPoolCreateFlags,
    pub max_sets: u32,
    pub pool_size_count: u32,
    pub p_pool_sizes: *const DescriptorPoolSize,
}
impl ::std::default::Default for DescriptorPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DescriptorPoolCreateFlags::default(),
            max_sets: u32::default(),
            pool_size_count: u32::default(),
            p_pool_sizes: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorPoolCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_POOL_CREATE_INFO;
}
impl DescriptorPoolCreateInfo {
    pub fn builder<'a>() -> DescriptorPoolCreateInfoBuilder<'a> {
        DescriptorPoolCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorPoolCreateInfoBuilder<'a> {
    inner: DescriptorPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorPoolCreateInfo {}
impl<'a> ::std::ops::Deref for DescriptorPoolCreateInfoBuilder<'a> {
    type Target = DescriptorPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorPoolCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorPoolCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn max_sets(mut self, max_sets: u32) -> Self {
        self.inner.max_sets = max_sets;
        self
    }
    #[inline]
    pub fn pool_sizes(mut self, pool_sizes: &'a [DescriptorPoolSize]) -> Self {
        self.inner.pool_size_count = pool_sizes.len() as _;
        self.inner.p_pool_sizes = pool_sizes.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorPoolCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetAllocateInfo.html>"]
pub struct DescriptorSetAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub descriptor_pool: DescriptorPool,
    pub descriptor_set_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
}
impl ::std::default::Default for DescriptorSetAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            descriptor_pool: DescriptorPool::default(),
            descriptor_set_count: u32::default(),
            p_set_layouts: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorSetAllocateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_ALLOCATE_INFO;
}
impl DescriptorSetAllocateInfo {
    pub fn builder<'a>() -> DescriptorSetAllocateInfoBuilder<'a> {
        DescriptorSetAllocateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetAllocateInfoBuilder<'a> {
    inner: DescriptorSetAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorSetAllocateInfo {}
impl<'a> ::std::ops::Deref for DescriptorSetAllocateInfoBuilder<'a> {
    type Target = DescriptorSetAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetAllocateInfoBuilder<'a> {
    #[inline]
    pub fn descriptor_pool(mut self, descriptor_pool: DescriptorPool) -> Self {
        self.inner.descriptor_pool = descriptor_pool;
        self
    }
    #[inline]
    pub fn set_layouts(mut self, set_layouts: &'a [DescriptorSetLayout]) -> Self {
        self.inner.descriptor_set_count = set_layouts.len() as _;
        self.inner.p_set_layouts = set_layouts.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetAllocateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSpecializationMapEntry.html>"]
pub struct SpecializationMapEntry {
    pub constant_id: u32,
    pub offset: u32,
    pub size: usize,
}
impl SpecializationMapEntry {
    pub fn builder<'a>() -> SpecializationMapEntryBuilder<'a> {
        SpecializationMapEntryBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SpecializationMapEntryBuilder<'a> {
    inner: SpecializationMapEntry,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SpecializationMapEntryBuilder<'a> {
    type Target = SpecializationMapEntry;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SpecializationMapEntryBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SpecializationMapEntryBuilder<'a> {
    #[inline]
    pub fn constant_id(mut self, constant_id: u32) -> Self {
        self.inner.constant_id = constant_id;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: usize) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SpecializationMapEntry {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSpecializationInfo.html>"]
pub struct SpecializationInfo {
    pub map_entry_count: u32,
    pub p_map_entries: *const SpecializationMapEntry,
    pub data_size: usize,
    pub p_data: *const c_void,
}
impl ::std::default::Default for SpecializationInfo {
    #[inline]
    fn default() -> Self {
        Self {
            map_entry_count: u32::default(),
            p_map_entries: ::std::ptr::null(),
            data_size: usize::default(),
            p_data: ::std::ptr::null(),
        }
    }
}
impl SpecializationInfo {
    pub fn builder<'a>() -> SpecializationInfoBuilder<'a> {
        SpecializationInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SpecializationInfoBuilder<'a> {
    inner: SpecializationInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SpecializationInfoBuilder<'a> {
    type Target = SpecializationInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SpecializationInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SpecializationInfoBuilder<'a> {
    #[inline]
    pub fn map_entries(mut self, map_entries: &'a [SpecializationMapEntry]) -> Self {
        self.inner.map_entry_count = map_entries.len() as _;
        self.inner.p_map_entries = map_entries.as_ptr();
        self
    }
    #[inline]
    pub fn data(mut self, data: &'a [u8]) -> Self {
        self.inner.data_size = data.len();
        self.inner.p_data = data.as_ptr().cast();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SpecializationInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineShaderStageCreateInfo.html>"]
pub struct PipelineShaderStageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineShaderStageCreateFlags,
    pub stage: ShaderStageFlags,
    pub module: ShaderModule,
    pub p_name: *const c_char,
    pub p_specialization_info: *const SpecializationInfo,
}
impl ::std::default::Default for PipelineShaderStageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineShaderStageCreateFlags::default(),
            stage: ShaderStageFlags::default(),
            module: ShaderModule::default(),
            p_name: ::std::ptr::null(),
            p_specialization_info: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineShaderStageCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_SHADER_STAGE_CREATE_INFO;
}
impl PipelineShaderStageCreateInfo {
    pub fn builder<'a>() -> PipelineShaderStageCreateInfoBuilder<'a> {
        PipelineShaderStageCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineShaderStageCreateInfoBuilder<'a> {
    inner: PipelineShaderStageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineShaderStageCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineShaderStageCreateInfoBuilder<'a> {
    type Target = PipelineShaderStageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineShaderStageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineShaderStageCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineShaderStageCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn stage(mut self, stage: ShaderStageFlags) -> Self {
        self.inner.stage = stage;
        self
    }
    #[inline]
    pub fn module(mut self, module: ShaderModule) -> Self {
        self.inner.module = module;
        self
    }
    #[inline]
    pub fn name(mut self, name: &'a ::std::ffi::CStr) -> Self {
        self.inner.p_name = name.as_ptr();
        self
    }
    #[inline]
    pub fn specialization_info(mut self, specialization_info: &'a SpecializationInfo) -> Self {
        self.inner.p_specialization_info = specialization_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineShaderStageCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineShaderStageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkComputePipelineCreateInfo.html>"]
pub struct ComputePipelineCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage: PipelineShaderStageCreateInfo,
    pub layout: PipelineLayout,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}
impl ::std::default::Default for ComputePipelineCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage: PipelineShaderStageCreateInfo::default(),
            layout: PipelineLayout::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}
unsafe impl TaggedStructure for ComputePipelineCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::COMPUTE_PIPELINE_CREATE_INFO;
}
impl ComputePipelineCreateInfo {
    pub fn builder<'a>() -> ComputePipelineCreateInfoBuilder<'a> {
        ComputePipelineCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ComputePipelineCreateInfoBuilder<'a> {
    inner: ComputePipelineCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsComputePipelineCreateInfo {}
impl<'a> ::std::ops::Deref for ComputePipelineCreateInfoBuilder<'a> {
    type Target = ComputePipelineCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ComputePipelineCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ComputePipelineCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn stage(mut self, stage: PipelineShaderStageCreateInfo) -> Self {
        self.inner.stage = stage;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.inner.layout = layout;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.inner.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.inner.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsComputePipelineCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ComputePipelineCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVertexInputBindingDescription.html>"]
pub struct VertexInputBindingDescription {
    pub binding: u32,
    pub stride: u32,
    pub input_rate: VertexInputRate,
}
impl VertexInputBindingDescription {
    pub fn builder<'a>() -> VertexInputBindingDescriptionBuilder<'a> {
        VertexInputBindingDescriptionBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct VertexInputBindingDescriptionBuilder<'a> {
    inner: VertexInputBindingDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for VertexInputBindingDescriptionBuilder<'a> {
    type Target = VertexInputBindingDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for VertexInputBindingDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> VertexInputBindingDescriptionBuilder<'a> {
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.inner.binding = binding;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.inner.stride = stride;
        self
    }
    #[inline]
    pub fn input_rate(mut self, input_rate: VertexInputRate) -> Self {
        self.inner.input_rate = input_rate;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> VertexInputBindingDescription {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkVertexInputAttributeDescription.html>"]
pub struct VertexInputAttributeDescription {
    pub location: u32,
    pub binding: u32,
    pub format: Format,
    pub offset: u32,
}
impl VertexInputAttributeDescription {
    pub fn builder<'a>() -> VertexInputAttributeDescriptionBuilder<'a> {
        VertexInputAttributeDescriptionBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct VertexInputAttributeDescriptionBuilder<'a> {
    inner: VertexInputAttributeDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for VertexInputAttributeDescriptionBuilder<'a> {
    type Target = VertexInputAttributeDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for VertexInputAttributeDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> VertexInputAttributeDescriptionBuilder<'a> {
    #[inline]
    pub fn location(mut self, location: u32) -> Self {
        self.inner.location = location;
        self
    }
    #[inline]
    pub fn binding(mut self, binding: u32) -> Self {
        self.inner.binding = binding;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.inner.offset = offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> VertexInputAttributeDescription {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineVertexInputStateCreateInfo.html>"]
pub struct PipelineVertexInputStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineVertexInputStateCreateFlags,
    pub vertex_binding_description_count: u32,
    pub p_vertex_binding_descriptions: *const VertexInputBindingDescription,
    pub vertex_attribute_description_count: u32,
    pub p_vertex_attribute_descriptions: *const VertexInputAttributeDescription,
}
impl ::std::default::Default for PipelineVertexInputStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineVertexInputStateCreateFlags::default(),
            vertex_binding_description_count: u32::default(),
            p_vertex_binding_descriptions: ::std::ptr::null(),
            vertex_attribute_description_count: u32::default(),
            p_vertex_attribute_descriptions: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineVertexInputStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO;
}
impl PipelineVertexInputStateCreateInfo {
    pub fn builder<'a>() -> PipelineVertexInputStateCreateInfoBuilder<'a> {
        PipelineVertexInputStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineVertexInputStateCreateInfoBuilder<'a> {
    inner: PipelineVertexInputStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineVertexInputStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineVertexInputStateCreateInfoBuilder<'a> {
    type Target = PipelineVertexInputStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineVertexInputStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineVertexInputStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineVertexInputStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn vertex_binding_descriptions(
        mut self,
        vertex_binding_descriptions: &'a [VertexInputBindingDescription],
    ) -> Self {
        self.inner.vertex_binding_description_count = vertex_binding_descriptions.len() as _;
        self.inner.p_vertex_binding_descriptions = vertex_binding_descriptions.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_attribute_descriptions(
        mut self,
        vertex_attribute_descriptions: &'a [VertexInputAttributeDescription],
    ) -> Self {
        self.inner.vertex_attribute_description_count = vertex_attribute_descriptions.len() as _;
        self.inner.p_vertex_attribute_descriptions = vertex_attribute_descriptions.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineVertexInputStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineVertexInputStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineInputAssemblyStateCreateInfo.html>"]
pub struct PipelineInputAssemblyStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineInputAssemblyStateCreateFlags,
    pub topology: PrimitiveTopology,
    pub primitive_restart_enable: Bool32,
}
impl ::std::default::Default for PipelineInputAssemblyStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineInputAssemblyStateCreateFlags::default(),
            topology: PrimitiveTopology::default(),
            primitive_restart_enable: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineInputAssemblyStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO;
}
impl PipelineInputAssemblyStateCreateInfo {
    pub fn builder<'a>() -> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
        PipelineInputAssemblyStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    inner: PipelineInputAssemblyStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    type Target = PipelineInputAssemblyStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineInputAssemblyStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineInputAssemblyStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn topology(mut self, topology: PrimitiveTopology) -> Self {
        self.inner.topology = topology;
        self
    }
    #[inline]
    pub fn primitive_restart_enable(mut self, primitive_restart_enable: bool) -> Self {
        self.inner.primitive_restart_enable = primitive_restart_enable.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineInputAssemblyStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationStateCreateInfo.html>"]
pub struct PipelineTessellationStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineTessellationStateCreateFlags,
    pub patch_control_points: u32,
}
impl ::std::default::Default for PipelineTessellationStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineTessellationStateCreateFlags::default(),
            patch_control_points: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineTessellationStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_TESSELLATION_STATE_CREATE_INFO;
}
impl PipelineTessellationStateCreateInfo {
    pub fn builder<'a>() -> PipelineTessellationStateCreateInfoBuilder<'a> {
        PipelineTessellationStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineTessellationStateCreateInfoBuilder<'a> {
    inner: PipelineTessellationStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineTessellationStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineTessellationStateCreateInfoBuilder<'a> {
    type Target = PipelineTessellationStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineTessellationStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineTessellationStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineTessellationStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn patch_control_points(mut self, patch_control_points: u32) -> Self {
        self.inner.patch_control_points = patch_control_points;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineTessellationStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineTessellationStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportStateCreateInfo.html>"]
pub struct PipelineViewportStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineViewportStateCreateFlags,
    pub viewport_count: u32,
    pub p_viewports: *const Viewport,
    pub scissor_count: u32,
    pub p_scissors: *const Rect2D,
}
impl ::std::default::Default for PipelineViewportStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineViewportStateCreateFlags::default(),
            viewport_count: u32::default(),
            p_viewports: ::std::ptr::null(),
            scissor_count: u32::default(),
            p_scissors: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineViewportStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_VIEWPORT_STATE_CREATE_INFO;
}
impl PipelineViewportStateCreateInfo {
    pub fn builder<'a>() -> PipelineViewportStateCreateInfoBuilder<'a> {
        PipelineViewportStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineViewportStateCreateInfoBuilder<'a> {
    inner: PipelineViewportStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineViewportStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineViewportStateCreateInfoBuilder<'a> {
    type Target = PipelineViewportStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineViewportStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineViewportStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineViewportStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn viewport_count(mut self, viewport_count: u32) -> Self {
        self.inner.viewport_count = viewport_count;
        self
    }
    #[inline]
    pub fn viewports(mut self, viewports: &'a [Viewport]) -> Self {
        self.inner.viewport_count = viewports.len() as _;
        self.inner.p_viewports = viewports.as_ptr();
        self
    }
    #[inline]
    pub fn scissor_count(mut self, scissor_count: u32) -> Self {
        self.inner.scissor_count = scissor_count;
        self
    }
    #[inline]
    pub fn scissors(mut self, scissors: &'a [Rect2D]) -> Self {
        self.inner.scissor_count = scissors.len() as _;
        self.inner.p_scissors = scissors.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineViewportStateCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineViewportStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateCreateInfo.html>"]
pub struct PipelineRasterizationStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineRasterizationStateCreateFlags,
    pub depth_clamp_enable: Bool32,
    pub rasterizer_discard_enable: Bool32,
    pub polygon_mode: PolygonMode,
    pub cull_mode: CullModeFlags,
    pub front_face: FrontFace,
    pub depth_bias_enable: Bool32,
    pub depth_bias_constant_factor: f32,
    pub depth_bias_clamp: f32,
    pub depth_bias_slope_factor: f32,
    pub line_width: f32,
}
impl ::std::default::Default for PipelineRasterizationStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineRasterizationStateCreateFlags::default(),
            depth_clamp_enable: Bool32::default(),
            rasterizer_discard_enable: Bool32::default(),
            polygon_mode: PolygonMode::default(),
            cull_mode: CullModeFlags::default(),
            front_face: FrontFace::default(),
            depth_bias_enable: Bool32::default(),
            depth_bias_constant_factor: f32::default(),
            depth_bias_clamp: f32::default(),
            depth_bias_slope_factor: f32::default(),
            line_width: f32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineRasterizationStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_RASTERIZATION_STATE_CREATE_INFO;
}
impl PipelineRasterizationStateCreateInfo {
    pub fn builder<'a>() -> PipelineRasterizationStateCreateInfoBuilder<'a> {
        PipelineRasterizationStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineRasterizationStateCreateInfoBuilder<'a> {
    inner: PipelineRasterizationStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineRasterizationStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineRasterizationStateCreateInfoBuilder<'a> {
    type Target = PipelineRasterizationStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineRasterizationStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineRasterizationStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineRasterizationStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn depth_clamp_enable(mut self, depth_clamp_enable: bool) -> Self {
        self.inner.depth_clamp_enable = depth_clamp_enable.into();
        self
    }
    #[inline]
    pub fn rasterizer_discard_enable(mut self, rasterizer_discard_enable: bool) -> Self {
        self.inner.rasterizer_discard_enable = rasterizer_discard_enable.into();
        self
    }
    #[inline]
    pub fn polygon_mode(mut self, polygon_mode: PolygonMode) -> Self {
        self.inner.polygon_mode = polygon_mode;
        self
    }
    #[inline]
    pub fn cull_mode(mut self, cull_mode: CullModeFlags) -> Self {
        self.inner.cull_mode = cull_mode;
        self
    }
    #[inline]
    pub fn front_face(mut self, front_face: FrontFace) -> Self {
        self.inner.front_face = front_face;
        self
    }
    #[inline]
    pub fn depth_bias_enable(mut self, depth_bias_enable: bool) -> Self {
        self.inner.depth_bias_enable = depth_bias_enable.into();
        self
    }
    #[inline]
    pub fn depth_bias_constant_factor(mut self, depth_bias_constant_factor: f32) -> Self {
        self.inner.depth_bias_constant_factor = depth_bias_constant_factor;
        self
    }
    #[inline]
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: f32) -> Self {
        self.inner.depth_bias_clamp = depth_bias_clamp;
        self
    }
    #[inline]
    pub fn depth_bias_slope_factor(mut self, depth_bias_slope_factor: f32) -> Self {
        self.inner.depth_bias_slope_factor = depth_bias_slope_factor;
        self
    }
    #[inline]
    pub fn line_width(mut self, line_width: f32) -> Self {
        self.inner.line_width = line_width;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineRasterizationStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineRasterizationStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html>"]
pub struct PipelineMultisampleStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineMultisampleStateCreateFlags,
    pub rasterization_samples: SampleCountFlags,
    pub sample_shading_enable: Bool32,
    pub min_sample_shading: f32,
    pub p_sample_mask: *const SampleMask,
    pub alpha_to_coverage_enable: Bool32,
    pub alpha_to_one_enable: Bool32,
}
impl ::std::default::Default for PipelineMultisampleStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineMultisampleStateCreateFlags::default(),
            rasterization_samples: SampleCountFlags::default(),
            sample_shading_enable: Bool32::default(),
            min_sample_shading: f32::default(),
            p_sample_mask: ::std::ptr::null(),
            alpha_to_coverage_enable: Bool32::default(),
            alpha_to_one_enable: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineMultisampleStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_MULTISAMPLE_STATE_CREATE_INFO;
}
impl PipelineMultisampleStateCreateInfo {
    pub fn builder<'a>() -> PipelineMultisampleStateCreateInfoBuilder<'a> {
        PipelineMultisampleStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineMultisampleStateCreateInfoBuilder<'a> {
    inner: PipelineMultisampleStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineMultisampleStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineMultisampleStateCreateInfoBuilder<'a> {
    type Target = PipelineMultisampleStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineMultisampleStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineMultisampleStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineMultisampleStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn rasterization_samples(mut self, rasterization_samples: SampleCountFlags) -> Self {
        self.inner.rasterization_samples = rasterization_samples;
        self
    }
    #[inline]
    pub fn sample_shading_enable(mut self, sample_shading_enable: bool) -> Self {
        self.inner.sample_shading_enable = sample_shading_enable.into();
        self
    }
    #[inline]
    pub fn min_sample_shading(mut self, min_sample_shading: f32) -> Self {
        self.inner.min_sample_shading = min_sample_shading;
        self
    }
    #[doc = r" Sets `p_sample_mask` to `null` if the slice is empty. The mask will"]
    #[doc = r" be treated as if it has all bits set to `1`."]
    #[doc = r""]
    #[doc = r" See <https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineMultisampleStateCreateInfo.html#_description>"]
    #[doc = r" for more details."]
    #[inline]
    pub fn sample_mask(mut self, sample_mask: &'a [SampleMask]) -> Self {
        self.inner.p_sample_mask = if sample_mask.is_empty() {
            std::ptr::null()
        } else {
            sample_mask.as_ptr()
        };
        self
    }
    #[inline]
    pub fn alpha_to_coverage_enable(mut self, alpha_to_coverage_enable: bool) -> Self {
        self.inner.alpha_to_coverage_enable = alpha_to_coverage_enable.into();
        self
    }
    #[inline]
    pub fn alpha_to_one_enable(mut self, alpha_to_one_enable: bool) -> Self {
        self.inner.alpha_to_one_enable = alpha_to_one_enable.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineMultisampleStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineMultisampleStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendAttachmentState.html>"]
pub struct PipelineColorBlendAttachmentState {
    pub blend_enable: Bool32,
    pub src_color_blend_factor: BlendFactor,
    pub dst_color_blend_factor: BlendFactor,
    pub color_blend_op: BlendOp,
    pub src_alpha_blend_factor: BlendFactor,
    pub dst_alpha_blend_factor: BlendFactor,
    pub alpha_blend_op: BlendOp,
    pub color_write_mask: ColorComponentFlags,
}
impl PipelineColorBlendAttachmentState {
    pub fn builder<'a>() -> PipelineColorBlendAttachmentStateBuilder<'a> {
        PipelineColorBlendAttachmentStateBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineColorBlendAttachmentStateBuilder<'a> {
    inner: PipelineColorBlendAttachmentState,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineColorBlendAttachmentStateBuilder<'a> {
    type Target = PipelineColorBlendAttachmentState;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineColorBlendAttachmentStateBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineColorBlendAttachmentStateBuilder<'a> {
    #[inline]
    pub fn blend_enable(mut self, blend_enable: bool) -> Self {
        self.inner.blend_enable = blend_enable.into();
        self
    }
    #[inline]
    pub fn src_color_blend_factor(mut self, src_color_blend_factor: BlendFactor) -> Self {
        self.inner.src_color_blend_factor = src_color_blend_factor;
        self
    }
    #[inline]
    pub fn dst_color_blend_factor(mut self, dst_color_blend_factor: BlendFactor) -> Self {
        self.inner.dst_color_blend_factor = dst_color_blend_factor;
        self
    }
    #[inline]
    pub fn color_blend_op(mut self, color_blend_op: BlendOp) -> Self {
        self.inner.color_blend_op = color_blend_op;
        self
    }
    #[inline]
    pub fn src_alpha_blend_factor(mut self, src_alpha_blend_factor: BlendFactor) -> Self {
        self.inner.src_alpha_blend_factor = src_alpha_blend_factor;
        self
    }
    #[inline]
    pub fn dst_alpha_blend_factor(mut self, dst_alpha_blend_factor: BlendFactor) -> Self {
        self.inner.dst_alpha_blend_factor = dst_alpha_blend_factor;
        self
    }
    #[inline]
    pub fn alpha_blend_op(mut self, alpha_blend_op: BlendOp) -> Self {
        self.inner.alpha_blend_op = alpha_blend_op;
        self
    }
    #[inline]
    pub fn color_write_mask(mut self, color_write_mask: ColorComponentFlags) -> Self {
        self.inner.color_write_mask = color_write_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineColorBlendAttachmentState {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendStateCreateInfo.html>"]
pub struct PipelineColorBlendStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineColorBlendStateCreateFlags,
    pub logic_op_enable: Bool32,
    pub logic_op: LogicOp,
    pub attachment_count: u32,
    pub p_attachments: *const PipelineColorBlendAttachmentState,
    pub blend_constants: [f32; 4],
}
impl ::std::default::Default for PipelineColorBlendStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineColorBlendStateCreateFlags::default(),
            logic_op_enable: Bool32::default(),
            logic_op: LogicOp::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            blend_constants: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for PipelineColorBlendStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_COLOR_BLEND_STATE_CREATE_INFO;
}
impl PipelineColorBlendStateCreateInfo {
    pub fn builder<'a>() -> PipelineColorBlendStateCreateInfoBuilder<'a> {
        PipelineColorBlendStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineColorBlendStateCreateInfoBuilder<'a> {
    inner: PipelineColorBlendStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPipelineColorBlendStateCreateInfo {}
impl<'a> ::std::ops::Deref for PipelineColorBlendStateCreateInfoBuilder<'a> {
    type Target = PipelineColorBlendStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineColorBlendStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineColorBlendStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineColorBlendStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn logic_op_enable(mut self, logic_op_enable: bool) -> Self {
        self.inner.logic_op_enable = logic_op_enable.into();
        self
    }
    #[inline]
    pub fn logic_op(mut self, logic_op: LogicOp) -> Self {
        self.inner.logic_op = logic_op;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [PipelineColorBlendAttachmentState]) -> Self {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn blend_constants(mut self, blend_constants: [f32; 4]) -> Self {
        self.inner.blend_constants = blend_constants;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPipelineColorBlendStateCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineColorBlendStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineDynamicStateCreateInfo.html>"]
pub struct PipelineDynamicStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDynamicStateCreateFlags,
    pub dynamic_state_count: u32,
    pub p_dynamic_states: *const DynamicState,
}
impl ::std::default::Default for PipelineDynamicStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineDynamicStateCreateFlags::default(),
            dynamic_state_count: u32::default(),
            p_dynamic_states: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineDynamicStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_DYNAMIC_STATE_CREATE_INFO;
}
impl PipelineDynamicStateCreateInfo {
    pub fn builder<'a>() -> PipelineDynamicStateCreateInfoBuilder<'a> {
        PipelineDynamicStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineDynamicStateCreateInfoBuilder<'a> {
    inner: PipelineDynamicStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineDynamicStateCreateInfoBuilder<'a> {
    type Target = PipelineDynamicStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineDynamicStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineDynamicStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDynamicStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn dynamic_states(mut self, dynamic_states: &'a [DynamicState]) -> Self {
        self.inner.dynamic_state_count = dynamic_states.len() as _;
        self.inner.p_dynamic_states = dynamic_states.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineDynamicStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkStencilOpState.html>"]
pub struct StencilOpState {
    pub fail_op: StencilOp,
    pub pass_op: StencilOp,
    pub depth_fail_op: StencilOp,
    pub compare_op: CompareOp,
    pub compare_mask: u32,
    pub write_mask: u32,
    pub reference: u32,
}
impl StencilOpState {
    pub fn builder<'a>() -> StencilOpStateBuilder<'a> {
        StencilOpStateBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct StencilOpStateBuilder<'a> {
    inner: StencilOpState,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for StencilOpStateBuilder<'a> {
    type Target = StencilOpState;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for StencilOpStateBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> StencilOpStateBuilder<'a> {
    #[inline]
    pub fn fail_op(mut self, fail_op: StencilOp) -> Self {
        self.inner.fail_op = fail_op;
        self
    }
    #[inline]
    pub fn pass_op(mut self, pass_op: StencilOp) -> Self {
        self.inner.pass_op = pass_op;
        self
    }
    #[inline]
    pub fn depth_fail_op(mut self, depth_fail_op: StencilOp) -> Self {
        self.inner.depth_fail_op = depth_fail_op;
        self
    }
    #[inline]
    pub fn compare_op(mut self, compare_op: CompareOp) -> Self {
        self.inner.compare_op = compare_op;
        self
    }
    #[inline]
    pub fn compare_mask(mut self, compare_mask: u32) -> Self {
        self.inner.compare_mask = compare_mask;
        self
    }
    #[inline]
    pub fn write_mask(mut self, write_mask: u32) -> Self {
        self.inner.write_mask = write_mask;
        self
    }
    #[inline]
    pub fn reference(mut self, reference: u32) -> Self {
        self.inner.reference = reference;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> StencilOpState {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineDepthStencilStateCreateInfo.html>"]
pub struct PipelineDepthStencilStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDepthStencilStateCreateFlags,
    pub depth_test_enable: Bool32,
    pub depth_write_enable: Bool32,
    pub depth_compare_op: CompareOp,
    pub depth_bounds_test_enable: Bool32,
    pub stencil_test_enable: Bool32,
    pub front: StencilOpState,
    pub back: StencilOpState,
    pub min_depth_bounds: f32,
    pub max_depth_bounds: f32,
}
impl ::std::default::Default for PipelineDepthStencilStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineDepthStencilStateCreateFlags::default(),
            depth_test_enable: Bool32::default(),
            depth_write_enable: Bool32::default(),
            depth_compare_op: CompareOp::default(),
            depth_bounds_test_enable: Bool32::default(),
            stencil_test_enable: Bool32::default(),
            front: StencilOpState::default(),
            back: StencilOpState::default(),
            min_depth_bounds: f32::default(),
            max_depth_bounds: f32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineDepthStencilStateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO;
}
impl PipelineDepthStencilStateCreateInfo {
    pub fn builder<'a>() -> PipelineDepthStencilStateCreateInfoBuilder<'a> {
        PipelineDepthStencilStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineDepthStencilStateCreateInfoBuilder<'a> {
    inner: PipelineDepthStencilStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineDepthStencilStateCreateInfoBuilder<'a> {
    type Target = PipelineDepthStencilStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineDepthStencilStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineDepthStencilStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDepthStencilStateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn depth_test_enable(mut self, depth_test_enable: bool) -> Self {
        self.inner.depth_test_enable = depth_test_enable.into();
        self
    }
    #[inline]
    pub fn depth_write_enable(mut self, depth_write_enable: bool) -> Self {
        self.inner.depth_write_enable = depth_write_enable.into();
        self
    }
    #[inline]
    pub fn depth_compare_op(mut self, depth_compare_op: CompareOp) -> Self {
        self.inner.depth_compare_op = depth_compare_op;
        self
    }
    #[inline]
    pub fn depth_bounds_test_enable(mut self, depth_bounds_test_enable: bool) -> Self {
        self.inner.depth_bounds_test_enable = depth_bounds_test_enable.into();
        self
    }
    #[inline]
    pub fn stencil_test_enable(mut self, stencil_test_enable: bool) -> Self {
        self.inner.stencil_test_enable = stencil_test_enable.into();
        self
    }
    #[inline]
    pub fn front(mut self, front: StencilOpState) -> Self {
        self.inner.front = front;
        self
    }
    #[inline]
    pub fn back(mut self, back: StencilOpState) -> Self {
        self.inner.back = back;
        self
    }
    #[inline]
    pub fn min_depth_bounds(mut self, min_depth_bounds: f32) -> Self {
        self.inner.min_depth_bounds = min_depth_bounds;
        self
    }
    #[inline]
    pub fn max_depth_bounds(mut self, max_depth_bounds: f32) -> Self {
        self.inner.max_depth_bounds = max_depth_bounds;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineDepthStencilStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkGraphicsPipelineCreateInfo.html>"]
pub struct GraphicsPipelineCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCreateFlags,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub p_input_assembly_state: *const PipelineInputAssemblyStateCreateInfo,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo,
    pub p_viewport_state: *const PipelineViewportStateCreateInfo,
    pub p_rasterization_state: *const PipelineRasterizationStateCreateInfo,
    pub p_multisample_state: *const PipelineMultisampleStateCreateInfo,
    pub p_depth_stencil_state: *const PipelineDepthStencilStateCreateInfo,
    pub p_color_blend_state: *const PipelineColorBlendStateCreateInfo,
    pub p_dynamic_state: *const PipelineDynamicStateCreateInfo,
    pub layout: PipelineLayout,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub base_pipeline_handle: Pipeline,
    pub base_pipeline_index: i32,
}
impl ::std::default::Default for GraphicsPipelineCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineCreateFlags::default(),
            stage_count: u32::default(),
            p_stages: ::std::ptr::null(),
            p_vertex_input_state: ::std::ptr::null(),
            p_input_assembly_state: ::std::ptr::null(),
            p_tessellation_state: ::std::ptr::null(),
            p_viewport_state: ::std::ptr::null(),
            p_rasterization_state: ::std::ptr::null(),
            p_multisample_state: ::std::ptr::null(),
            p_depth_stencil_state: ::std::ptr::null(),
            p_color_blend_state: ::std::ptr::null(),
            p_dynamic_state: ::std::ptr::null(),
            layout: PipelineLayout::default(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            base_pipeline_handle: Pipeline::default(),
            base_pipeline_index: i32::default(),
        }
    }
}
unsafe impl TaggedStructure for GraphicsPipelineCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::GRAPHICS_PIPELINE_CREATE_INFO;
}
impl GraphicsPipelineCreateInfo {
    pub fn builder<'a>() -> GraphicsPipelineCreateInfoBuilder<'a> {
        GraphicsPipelineCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsPipelineCreateInfoBuilder<'a> {
    inner: GraphicsPipelineCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsGraphicsPipelineCreateInfo {}
impl<'a> ::std::ops::Deref for GraphicsPipelineCreateInfoBuilder<'a> {
    type Target = GraphicsPipelineCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsPipelineCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsPipelineCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo]) -> Self {
        self.inner.stage_count = stages.len() as _;
        self.inner.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo,
    ) -> Self {
        self.inner.p_vertex_input_state = vertex_input_state;
        self
    }
    #[inline]
    pub fn input_assembly_state(
        mut self,
        input_assembly_state: &'a PipelineInputAssemblyStateCreateInfo,
    ) -> Self {
        self.inner.p_input_assembly_state = input_assembly_state;
        self
    }
    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo,
    ) -> Self {
        self.inner.p_tessellation_state = tessellation_state;
        self
    }
    #[inline]
    pub fn viewport_state(mut self, viewport_state: &'a PipelineViewportStateCreateInfo) -> Self {
        self.inner.p_viewport_state = viewport_state;
        self
    }
    #[inline]
    pub fn rasterization_state(
        mut self,
        rasterization_state: &'a PipelineRasterizationStateCreateInfo,
    ) -> Self {
        self.inner.p_rasterization_state = rasterization_state;
        self
    }
    #[inline]
    pub fn multisample_state(
        mut self,
        multisample_state: &'a PipelineMultisampleStateCreateInfo,
    ) -> Self {
        self.inner.p_multisample_state = multisample_state;
        self
    }
    #[inline]
    pub fn depth_stencil_state(
        mut self,
        depth_stencil_state: &'a PipelineDepthStencilStateCreateInfo,
    ) -> Self {
        self.inner.p_depth_stencil_state = depth_stencil_state;
        self
    }
    #[inline]
    pub fn color_blend_state(
        mut self,
        color_blend_state: &'a PipelineColorBlendStateCreateInfo,
    ) -> Self {
        self.inner.p_color_blend_state = color_blend_state;
        self
    }
    #[inline]
    pub fn dynamic_state(mut self, dynamic_state: &'a PipelineDynamicStateCreateInfo) -> Self {
        self.inner.p_dynamic_state = dynamic_state;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: PipelineLayout) -> Self {
        self.inner.layout = layout;
        self
    }
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.inner.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.inner.subpass = subpass;
        self
    }
    #[inline]
    pub fn base_pipeline_handle(mut self, base_pipeline_handle: Pipeline) -> Self {
        self.inner.base_pipeline_handle = base_pipeline_handle;
        self
    }
    #[inline]
    pub fn base_pipeline_index(mut self, base_pipeline_index: i32) -> Self {
        self.inner.base_pipeline_index = base_pipeline_index;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsGraphicsPipelineCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsPipelineCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCacheCreateInfo.html>"]
pub struct PipelineCacheCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCacheCreateFlags,
    pub initial_data_size: usize,
    pub p_initial_data: *const c_void,
}
impl ::std::default::Default for PipelineCacheCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineCacheCreateFlags::default(),
            initial_data_size: usize::default(),
            p_initial_data: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineCacheCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_CACHE_CREATE_INFO;
}
impl PipelineCacheCreateInfo {
    pub fn builder<'a>() -> PipelineCacheCreateInfoBuilder<'a> {
        PipelineCacheCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineCacheCreateInfoBuilder<'a> {
    inner: PipelineCacheCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineCacheCreateInfoBuilder<'a> {
    type Target = PipelineCacheCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineCacheCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineCacheCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCacheCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn initial_data(mut self, initial_data: &'a [u8]) -> Self {
        self.inner.initial_data_size = initial_data.len();
        self.inner.p_initial_data = initial_data.as_ptr().cast();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineCacheCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCacheHeaderVersionOne.html>"]
pub struct PipelineCacheHeaderVersionOne {
    pub header_size: u32,
    pub header_version: PipelineCacheHeaderVersion,
    pub vendor_id: u32,
    pub device_id: u32,
    pub pipeline_cache_uuid: [u8; UUID_SIZE],
}
impl ::std::default::Default for PipelineCacheHeaderVersionOne {
    #[inline]
    fn default() -> Self {
        Self {
            header_size: u32::default(),
            header_version: PipelineCacheHeaderVersion::default(),
            vendor_id: u32::default(),
            device_id: u32::default(),
            pipeline_cache_uuid: unsafe { ::std::mem::zeroed() },
        }
    }
}
impl PipelineCacheHeaderVersionOne {
    pub fn builder<'a>() -> PipelineCacheHeaderVersionOneBuilder<'a> {
        PipelineCacheHeaderVersionOneBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineCacheHeaderVersionOneBuilder<'a> {
    inner: PipelineCacheHeaderVersionOne,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineCacheHeaderVersionOneBuilder<'a> {
    type Target = PipelineCacheHeaderVersionOne;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineCacheHeaderVersionOneBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineCacheHeaderVersionOneBuilder<'a> {
    #[inline]
    pub fn header_size(mut self, header_size: u32) -> Self {
        self.inner.header_size = header_size;
        self
    }
    #[inline]
    pub fn header_version(mut self, header_version: PipelineCacheHeaderVersion) -> Self {
        self.inner.header_version = header_version;
        self
    }
    #[inline]
    pub fn vendor_id(mut self, vendor_id: u32) -> Self {
        self.inner.vendor_id = vendor_id;
        self
    }
    #[inline]
    pub fn device_id(mut self, device_id: u32) -> Self {
        self.inner.device_id = device_id;
        self
    }
    #[inline]
    pub fn pipeline_cache_uuid(mut self, pipeline_cache_uuid: [u8; UUID_SIZE]) -> Self {
        self.inner.pipeline_cache_uuid = pipeline_cache_uuid;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineCacheHeaderVersionOne {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPushConstantRange.html>"]
pub struct PushConstantRange {
    pub stage_flags: ShaderStageFlags,
    pub offset: u32,
    pub size: u32,
}
impl PushConstantRange {
    pub fn builder<'a>() -> PushConstantRangeBuilder<'a> {
        PushConstantRangeBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PushConstantRangeBuilder<'a> {
    inner: PushConstantRange,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PushConstantRangeBuilder<'a> {
    type Target = PushConstantRange;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PushConstantRangeBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PushConstantRangeBuilder<'a> {
    #[inline]
    pub fn stage_flags(mut self, stage_flags: ShaderStageFlags) -> Self {
        self.inner.stage_flags = stage_flags;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.inner.size = size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PushConstantRange {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineLayoutCreateInfo.html>"]
pub struct PipelineLayoutCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineLayoutCreateFlags,
    pub set_layout_count: u32,
    pub p_set_layouts: *const DescriptorSetLayout,
    pub push_constant_range_count: u32,
    pub p_push_constant_ranges: *const PushConstantRange,
}
impl ::std::default::Default for PipelineLayoutCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineLayoutCreateFlags::default(),
            set_layout_count: u32::default(),
            p_set_layouts: ::std::ptr::null(),
            push_constant_range_count: u32::default(),
            p_push_constant_ranges: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineLayoutCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PIPELINE_LAYOUT_CREATE_INFO;
}
impl PipelineLayoutCreateInfo {
    pub fn builder<'a>() -> PipelineLayoutCreateInfoBuilder<'a> {
        PipelineLayoutCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineLayoutCreateInfoBuilder<'a> {
    inner: PipelineLayoutCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PipelineLayoutCreateInfoBuilder<'a> {
    type Target = PipelineLayoutCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineLayoutCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineLayoutCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineLayoutCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn set_layouts(mut self, set_layouts: &'a [DescriptorSetLayout]) -> Self {
        self.inner.set_layout_count = set_layouts.len() as _;
        self.inner.p_set_layouts = set_layouts.as_ptr();
        self
    }
    #[inline]
    pub fn push_constant_ranges(mut self, push_constant_ranges: &'a [PushConstantRange]) -> Self {
        self.inner.push_constant_range_count = push_constant_ranges.len() as _;
        self.inner.p_push_constant_ranges = push_constant_ranges.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineLayoutCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerCreateInfo.html>"]
pub struct SamplerCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SamplerCreateFlags,
    pub mag_filter: Filter,
    pub min_filter: Filter,
    pub mipmap_mode: SamplerMipmapMode,
    pub address_mode_u: SamplerAddressMode,
    pub address_mode_v: SamplerAddressMode,
    pub address_mode_w: SamplerAddressMode,
    pub mip_lod_bias: f32,
    pub anisotropy_enable: Bool32,
    pub max_anisotropy: f32,
    pub compare_enable: Bool32,
    pub compare_op: CompareOp,
    pub min_lod: f32,
    pub max_lod: f32,
    pub border_color: BorderColor,
    pub unnormalized_coordinates: Bool32,
}
impl ::std::default::Default for SamplerCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: SamplerCreateFlags::default(),
            mag_filter: Filter::default(),
            min_filter: Filter::default(),
            mipmap_mode: SamplerMipmapMode::default(),
            address_mode_u: SamplerAddressMode::default(),
            address_mode_v: SamplerAddressMode::default(),
            address_mode_w: SamplerAddressMode::default(),
            mip_lod_bias: f32::default(),
            anisotropy_enable: Bool32::default(),
            max_anisotropy: f32::default(),
            compare_enable: Bool32::default(),
            compare_op: CompareOp::default(),
            min_lod: f32::default(),
            max_lod: f32::default(),
            border_color: BorderColor::default(),
            unnormalized_coordinates: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for SamplerCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_CREATE_INFO;
}
impl SamplerCreateInfo {
    pub fn builder<'a>() -> SamplerCreateInfoBuilder<'a> {
        SamplerCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerCreateInfoBuilder<'a> {
    inner: SamplerCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSamplerCreateInfo {}
impl<'a> ::std::ops::Deref for SamplerCreateInfoBuilder<'a> {
    type Target = SamplerCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: SamplerCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn mag_filter(mut self, mag_filter: Filter) -> Self {
        self.inner.mag_filter = mag_filter;
        self
    }
    #[inline]
    pub fn min_filter(mut self, min_filter: Filter) -> Self {
        self.inner.min_filter = min_filter;
        self
    }
    #[inline]
    pub fn mipmap_mode(mut self, mipmap_mode: SamplerMipmapMode) -> Self {
        self.inner.mipmap_mode = mipmap_mode;
        self
    }
    #[inline]
    pub fn address_mode_u(mut self, address_mode_u: SamplerAddressMode) -> Self {
        self.inner.address_mode_u = address_mode_u;
        self
    }
    #[inline]
    pub fn address_mode_v(mut self, address_mode_v: SamplerAddressMode) -> Self {
        self.inner.address_mode_v = address_mode_v;
        self
    }
    #[inline]
    pub fn address_mode_w(mut self, address_mode_w: SamplerAddressMode) -> Self {
        self.inner.address_mode_w = address_mode_w;
        self
    }
    #[inline]
    pub fn mip_lod_bias(mut self, mip_lod_bias: f32) -> Self {
        self.inner.mip_lod_bias = mip_lod_bias;
        self
    }
    #[inline]
    pub fn anisotropy_enable(mut self, anisotropy_enable: bool) -> Self {
        self.inner.anisotropy_enable = anisotropy_enable.into();
        self
    }
    #[inline]
    pub fn max_anisotropy(mut self, max_anisotropy: f32) -> Self {
        self.inner.max_anisotropy = max_anisotropy;
        self
    }
    #[inline]
    pub fn compare_enable(mut self, compare_enable: bool) -> Self {
        self.inner.compare_enable = compare_enable.into();
        self
    }
    #[inline]
    pub fn compare_op(mut self, compare_op: CompareOp) -> Self {
        self.inner.compare_op = compare_op;
        self
    }
    #[inline]
    pub fn min_lod(mut self, min_lod: f32) -> Self {
        self.inner.min_lod = min_lod;
        self
    }
    #[inline]
    pub fn max_lod(mut self, max_lod: f32) -> Self {
        self.inner.max_lod = max_lod;
        self
    }
    #[inline]
    pub fn border_color(mut self, border_color: BorderColor) -> Self {
        self.inner.border_color = border_color;
        self
    }
    #[inline]
    pub fn unnormalized_coordinates(mut self, unnormalized_coordinates: bool) -> Self {
        self.inner.unnormalized_coordinates = unnormalized_coordinates.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSamplerCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandPoolCreateInfo.html>"]
pub struct CommandPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandPoolCreateFlags,
    pub queue_family_index: u32,
}
impl ::std::default::Default for CommandPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: CommandPoolCreateFlags::default(),
            queue_family_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for CommandPoolCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_POOL_CREATE_INFO;
}
impl CommandPoolCreateInfo {
    pub fn builder<'a>() -> CommandPoolCreateInfoBuilder<'a> {
        CommandPoolCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandPoolCreateInfoBuilder<'a> {
    inner: CommandPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for CommandPoolCreateInfoBuilder<'a> {
    type Target = CommandPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandPoolCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: CommandPoolCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.inner.queue_family_index = queue_family_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandBufferAllocateInfo.html>"]
pub struct CommandBufferAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub command_pool: CommandPool,
    pub level: CommandBufferLevel,
    pub command_buffer_count: u32,
}
impl ::std::default::Default for CommandBufferAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            command_pool: CommandPool::default(),
            level: CommandBufferLevel::default(),
            command_buffer_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for CommandBufferAllocateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_ALLOCATE_INFO;
}
impl CommandBufferAllocateInfo {
    pub fn builder<'a>() -> CommandBufferAllocateInfoBuilder<'a> {
        CommandBufferAllocateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferAllocateInfoBuilder<'a> {
    inner: CommandBufferAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for CommandBufferAllocateInfoBuilder<'a> {
    type Target = CommandBufferAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferAllocateInfoBuilder<'a> {
    #[inline]
    pub fn command_pool(mut self, command_pool: CommandPool) -> Self {
        self.inner.command_pool = command_pool;
        self
    }
    #[inline]
    pub fn level(mut self, level: CommandBufferLevel) -> Self {
        self.inner.level = level;
        self
    }
    #[inline]
    pub fn command_buffer_count(mut self, command_buffer_count: u32) -> Self {
        self.inner.command_buffer_count = command_buffer_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandBufferInheritanceInfo.html>"]
pub struct CommandBufferInheritanceInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub subpass: u32,
    pub framebuffer: Framebuffer,
    pub occlusion_query_enable: Bool32,
    pub query_flags: QueryControlFlags,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}
impl ::std::default::Default for CommandBufferInheritanceInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            render_pass: RenderPass::default(),
            subpass: u32::default(),
            framebuffer: Framebuffer::default(),
            occlusion_query_enable: Bool32::default(),
            query_flags: QueryControlFlags::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for CommandBufferInheritanceInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_INHERITANCE_INFO;
}
impl CommandBufferInheritanceInfo {
    pub fn builder<'a>() -> CommandBufferInheritanceInfoBuilder<'a> {
        CommandBufferInheritanceInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferInheritanceInfoBuilder<'a> {
    inner: CommandBufferInheritanceInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandBufferInheritanceInfo {}
impl<'a> ::std::ops::Deref for CommandBufferInheritanceInfoBuilder<'a> {
    type Target = CommandBufferInheritanceInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferInheritanceInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferInheritanceInfoBuilder<'a> {
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.inner.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.inner.subpass = subpass;
        self
    }
    #[inline]
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> Self {
        self.inner.framebuffer = framebuffer;
        self
    }
    #[inline]
    pub fn occlusion_query_enable(mut self, occlusion_query_enable: bool) -> Self {
        self.inner.occlusion_query_enable = occlusion_query_enable.into();
        self
    }
    #[inline]
    pub fn query_flags(mut self, query_flags: QueryControlFlags) -> Self {
        self.inner.query_flags = query_flags;
        self
    }
    #[inline]
    pub fn pipeline_statistics(mut self, pipeline_statistics: QueryPipelineStatisticFlags) -> Self {
        self.inner.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferInheritanceInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferInheritanceInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkCommandBufferBeginInfo.html>"]
pub struct CommandBufferBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: CommandBufferUsageFlags,
    pub p_inheritance_info: *const CommandBufferInheritanceInfo,
}
impl ::std::default::Default for CommandBufferBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: CommandBufferUsageFlags::default(),
            p_inheritance_info: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for CommandBufferBeginInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::COMMAND_BUFFER_BEGIN_INFO;
}
impl CommandBufferBeginInfo {
    pub fn builder<'a>() -> CommandBufferBeginInfoBuilder<'a> {
        CommandBufferBeginInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct CommandBufferBeginInfoBuilder<'a> {
    inner: CommandBufferBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsCommandBufferBeginInfo {}
impl<'a> ::std::ops::Deref for CommandBufferBeginInfoBuilder<'a> {
    type Target = CommandBufferBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for CommandBufferBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> CommandBufferBeginInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: CommandBufferUsageFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn inheritance_info(mut self, inheritance_info: &'a CommandBufferInheritanceInfo) -> Self {
        self.inner.p_inheritance_info = inheritance_info;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsCommandBufferBeginInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> CommandBufferBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPassBeginInfo.html>"]
pub struct RenderPassBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub render_pass: RenderPass,
    pub framebuffer: Framebuffer,
    pub render_area: Rect2D,
    pub clear_value_count: u32,
    pub p_clear_values: *const ClearValue,
}
#[cfg(feature = "debug")]
impl fmt::Debug for RenderPassBeginInfo {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("RenderPassBeginInfo")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("render_pass", &self.render_pass)
            .field("framebuffer", &self.framebuffer)
            .field("render_area", &self.render_area)
            .field("clear_value_count", &self.clear_value_count)
            .field("p_clear_values", &"union")
            .finish()
    }
}
impl ::std::default::Default for RenderPassBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            render_pass: RenderPass::default(),
            framebuffer: Framebuffer::default(),
            render_area: Rect2D::default(),
            clear_value_count: u32::default(),
            p_clear_values: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for RenderPassBeginInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_BEGIN_INFO;
}
impl RenderPassBeginInfo {
    pub fn builder<'a>() -> RenderPassBeginInfoBuilder<'a> {
        RenderPassBeginInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassBeginInfoBuilder<'a> {
    inner: RenderPassBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsRenderPassBeginInfo {}
impl<'a> ::std::ops::Deref for RenderPassBeginInfoBuilder<'a> {
    type Target = RenderPassBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassBeginInfoBuilder<'a> {
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.inner.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn framebuffer(mut self, framebuffer: Framebuffer) -> Self {
        self.inner.framebuffer = framebuffer;
        self
    }
    #[inline]
    pub fn render_area(mut self, render_area: Rect2D) -> Self {
        self.inner.render_area = render_area;
        self
    }
    #[inline]
    pub fn clear_values(mut self, clear_values: &'a [ClearValue]) -> Self {
        self.inner.clear_value_count = clear_values.len() as _;
        self.inner.p_clear_values = clear_values.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassBeginInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkClearColorValue.html>"]
pub union ClearColorValue {
    pub float32: [f32; 4],
    pub int32: [i32; 4],
    pub uint32: [u32; 4],
}
impl ::std::default::Default for ClearColorValue {
    #[inline]
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkClearDepthStencilValue.html>"]
pub struct ClearDepthStencilValue {
    pub depth: f32,
    pub stencil: u32,
}
impl ClearDepthStencilValue {
    pub fn builder<'a>() -> ClearDepthStencilValueBuilder<'a> {
        ClearDepthStencilValueBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearDepthStencilValueBuilder<'a> {
    inner: ClearDepthStencilValue,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearDepthStencilValueBuilder<'a> {
    type Target = ClearDepthStencilValue;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearDepthStencilValueBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearDepthStencilValueBuilder<'a> {
    #[inline]
    pub fn depth(mut self, depth: f32) -> Self {
        self.inner.depth = depth;
        self
    }
    #[inline]
    pub fn stencil(mut self, stencil: u32) -> Self {
        self.inner.stencil = stencil;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearDepthStencilValue {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkClearValue.html>"]
pub union ClearValue {
    pub color: ClearColorValue,
    pub depth_stencil: ClearDepthStencilValue,
}
impl ::std::default::Default for ClearValue {
    #[inline]
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[repr(C)]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkClearAttachment.html>"]
pub struct ClearAttachment {
    pub aspect_mask: ImageAspectFlags,
    pub color_attachment: u32,
    pub clear_value: ClearValue,
}
#[cfg(feature = "debug")]
impl fmt::Debug for ClearAttachment {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("ClearAttachment")
            .field("aspect_mask", &self.aspect_mask)
            .field("color_attachment", &self.color_attachment)
            .field("clear_value", &"union")
            .finish()
    }
}
impl ClearAttachment {
    pub fn builder<'a>() -> ClearAttachmentBuilder<'a> {
        ClearAttachmentBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ClearAttachmentBuilder<'a> {
    inner: ClearAttachment,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ClearAttachmentBuilder<'a> {
    type Target = ClearAttachment;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ClearAttachmentBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ClearAttachmentBuilder<'a> {
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[inline]
    pub fn color_attachment(mut self, color_attachment: u32) -> Self {
        self.inner.color_attachment = color_attachment;
        self
    }
    #[inline]
    pub fn clear_value(mut self, clear_value: ClearValue) -> Self {
        self.inner.clear_value = clear_value;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ClearAttachment {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAttachmentDescription.html>"]
pub struct AttachmentDescription {
    pub flags: AttachmentDescriptionFlags,
    pub format: Format,
    pub samples: SampleCountFlags,
    pub load_op: AttachmentLoadOp,
    pub store_op: AttachmentStoreOp,
    pub stencil_load_op: AttachmentLoadOp,
    pub stencil_store_op: AttachmentStoreOp,
    pub initial_layout: ImageLayout,
    pub final_layout: ImageLayout,
}
impl AttachmentDescription {
    pub fn builder<'a>() -> AttachmentDescriptionBuilder<'a> {
        AttachmentDescriptionBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AttachmentDescriptionBuilder<'a> {
    inner: AttachmentDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AttachmentDescriptionBuilder<'a> {
    type Target = AttachmentDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AttachmentDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AttachmentDescriptionBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: AttachmentDescriptionFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.inner.samples = samples;
        self
    }
    #[inline]
    pub fn load_op(mut self, load_op: AttachmentLoadOp) -> Self {
        self.inner.load_op = load_op;
        self
    }
    #[inline]
    pub fn store_op(mut self, store_op: AttachmentStoreOp) -> Self {
        self.inner.store_op = store_op;
        self
    }
    #[inline]
    pub fn stencil_load_op(mut self, stencil_load_op: AttachmentLoadOp) -> Self {
        self.inner.stencil_load_op = stencil_load_op;
        self
    }
    #[inline]
    pub fn stencil_store_op(mut self, stencil_store_op: AttachmentStoreOp) -> Self {
        self.inner.stencil_store_op = stencil_store_op;
        self
    }
    #[inline]
    pub fn initial_layout(mut self, initial_layout: ImageLayout) -> Self {
        self.inner.initial_layout = initial_layout;
        self
    }
    #[inline]
    pub fn final_layout(mut self, final_layout: ImageLayout) -> Self {
        self.inner.final_layout = final_layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AttachmentDescription {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAttachmentReference.html>"]
pub struct AttachmentReference {
    pub attachment: u32,
    pub layout: ImageLayout,
}
impl AttachmentReference {
    pub fn builder<'a>() -> AttachmentReferenceBuilder<'a> {
        AttachmentReferenceBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AttachmentReferenceBuilder<'a> {
    inner: AttachmentReference,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AttachmentReferenceBuilder<'a> {
    type Target = AttachmentReference;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AttachmentReferenceBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AttachmentReferenceBuilder<'a> {
    #[inline]
    pub fn attachment(mut self, attachment: u32) -> Self {
        self.inner.attachment = attachment;
        self
    }
    #[inline]
    pub fn layout(mut self, layout: ImageLayout) -> Self {
        self.inner.layout = layout;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AttachmentReference {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSubpassDescription.html>"]
pub struct SubpassDescription {
    pub flags: SubpassDescriptionFlags,
    pub pipeline_bind_point: PipelineBindPoint,
    pub input_attachment_count: u32,
    pub p_input_attachments: *const AttachmentReference,
    pub color_attachment_count: u32,
    pub p_color_attachments: *const AttachmentReference,
    pub p_resolve_attachments: *const AttachmentReference,
    pub p_depth_stencil_attachment: *const AttachmentReference,
    pub preserve_attachment_count: u32,
    pub p_preserve_attachments: *const u32,
}
impl ::std::default::Default for SubpassDescription {
    #[inline]
    fn default() -> Self {
        Self {
            flags: SubpassDescriptionFlags::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            input_attachment_count: u32::default(),
            p_input_attachments: ::std::ptr::null(),
            color_attachment_count: u32::default(),
            p_color_attachments: ::std::ptr::null(),
            p_resolve_attachments: ::std::ptr::null(),
            p_depth_stencil_attachment: ::std::ptr::null(),
            preserve_attachment_count: u32::default(),
            p_preserve_attachments: ::std::ptr::null(),
        }
    }
}
impl SubpassDescription {
    pub fn builder<'a>() -> SubpassDescriptionBuilder<'a> {
        SubpassDescriptionBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubpassDescriptionBuilder<'a> {
    inner: SubpassDescription,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubpassDescriptionBuilder<'a> {
    type Target = SubpassDescription;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubpassDescriptionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubpassDescriptionBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: SubpassDescriptionFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn input_attachments(mut self, input_attachments: &'a [AttachmentReference]) -> Self {
        self.inner.input_attachment_count = input_attachments.len() as _;
        self.inner.p_input_attachments = input_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn color_attachments(mut self, color_attachments: &'a [AttachmentReference]) -> Self {
        self.inner.color_attachment_count = color_attachments.len() as _;
        self.inner.p_color_attachments = color_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn resolve_attachments(mut self, resolve_attachments: &'a [AttachmentReference]) -> Self {
        self.inner.color_attachment_count = resolve_attachments.len() as _;
        self.inner.p_resolve_attachments = resolve_attachments.as_ptr();
        self
    }
    #[inline]
    pub fn depth_stencil_attachment(
        mut self,
        depth_stencil_attachment: &'a AttachmentReference,
    ) -> Self {
        self.inner.p_depth_stencil_attachment = depth_stencil_attachment;
        self
    }
    #[inline]
    pub fn preserve_attachments(mut self, preserve_attachments: &'a [u32]) -> Self {
        self.inner.preserve_attachment_count = preserve_attachments.len() as _;
        self.inner.p_preserve_attachments = preserve_attachments.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubpassDescription {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSubpassDependency.html>"]
pub struct SubpassDependency {
    pub src_subpass: u32,
    pub dst_subpass: u32,
    pub src_stage_mask: PipelineStageFlags,
    pub dst_stage_mask: PipelineStageFlags,
    pub src_access_mask: AccessFlags,
    pub dst_access_mask: AccessFlags,
    pub dependency_flags: DependencyFlags,
}
impl SubpassDependency {
    pub fn builder<'a>() -> SubpassDependencyBuilder<'a> {
        SubpassDependencyBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubpassDependencyBuilder<'a> {
    inner: SubpassDependency,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubpassDependencyBuilder<'a> {
    type Target = SubpassDependency;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubpassDependencyBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubpassDependencyBuilder<'a> {
    #[inline]
    pub fn src_subpass(mut self, src_subpass: u32) -> Self {
        self.inner.src_subpass = src_subpass;
        self
    }
    #[inline]
    pub fn dst_subpass(mut self, dst_subpass: u32) -> Self {
        self.inner.dst_subpass = dst_subpass;
        self
    }
    #[inline]
    pub fn src_stage_mask(mut self, src_stage_mask: PipelineStageFlags) -> Self {
        self.inner.src_stage_mask = src_stage_mask;
        self
    }
    #[inline]
    pub fn dst_stage_mask(mut self, dst_stage_mask: PipelineStageFlags) -> Self {
        self.inner.dst_stage_mask = dst_stage_mask;
        self
    }
    #[inline]
    pub fn src_access_mask(mut self, src_access_mask: AccessFlags) -> Self {
        self.inner.src_access_mask = src_access_mask;
        self
    }
    #[inline]
    pub fn dst_access_mask(mut self, dst_access_mask: AccessFlags) -> Self {
        self.inner.dst_access_mask = dst_access_mask;
        self
    }
    #[inline]
    pub fn dependency_flags(mut self, dependency_flags: DependencyFlags) -> Self {
        self.inner.dependency_flags = dependency_flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubpassDependency {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPassCreateInfo.html>"]
pub struct RenderPassCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: RenderPassCreateFlags,
    pub attachment_count: u32,
    pub p_attachments: *const AttachmentDescription,
    pub subpass_count: u32,
    pub p_subpasses: *const SubpassDescription,
    pub dependency_count: u32,
    pub p_dependencies: *const SubpassDependency,
}
impl ::std::default::Default for RenderPassCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: RenderPassCreateFlags::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            subpass_count: u32::default(),
            p_subpasses: ::std::ptr::null(),
            dependency_count: u32::default(),
            p_dependencies: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for RenderPassCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_CREATE_INFO;
}
impl RenderPassCreateInfo {
    pub fn builder<'a>() -> RenderPassCreateInfoBuilder<'a> {
        RenderPassCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassCreateInfoBuilder<'a> {
    inner: RenderPassCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsRenderPassCreateInfo {}
impl<'a> ::std::ops::Deref for RenderPassCreateInfoBuilder<'a> {
    type Target = RenderPassCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: RenderPassCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [AttachmentDescription]) -> Self {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn subpasses(mut self, subpasses: &'a [SubpassDescription]) -> Self {
        self.inner.subpass_count = subpasses.len() as _;
        self.inner.p_subpasses = subpasses.as_ptr();
        self
    }
    #[inline]
    pub fn dependencies(mut self, dependencies: &'a [SubpassDependency]) -> Self {
        self.inner.dependency_count = dependencies.len() as _;
        self.inner.p_dependencies = dependencies.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsRenderPassCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkEventCreateInfo.html>"]
pub struct EventCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: EventCreateFlags,
}
impl ::std::default::Default for EventCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: EventCreateFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for EventCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EVENT_CREATE_INFO;
}
impl EventCreateInfo {
    pub fn builder<'a>() -> EventCreateInfoBuilder<'a> {
        EventCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct EventCreateInfoBuilder<'a> {
    inner: EventCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsEventCreateInfo {}
impl<'a> ::std::ops::Deref for EventCreateInfoBuilder<'a> {
    type Target = EventCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for EventCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> EventCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: EventCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsEventCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> EventCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFenceCreateInfo.html>"]
pub struct FenceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FenceCreateFlags,
}
impl ::std::default::Default for FenceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: FenceCreateFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for FenceCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_CREATE_INFO;
}
impl FenceCreateInfo {
    pub fn builder<'a>() -> FenceCreateInfoBuilder<'a> {
        FenceCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FenceCreateInfoBuilder<'a> {
    inner: FenceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFenceCreateInfo {}
impl<'a> ::std::ops::Deref for FenceCreateInfoBuilder<'a> {
    type Target = FenceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FenceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FenceCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: FenceCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFenceCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FenceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFeatures.html>"]
pub struct PhysicalDeviceFeatures {
    pub robust_buffer_access: Bool32,
    pub full_draw_index_uint32: Bool32,
    pub image_cube_array: Bool32,
    pub independent_blend: Bool32,
    pub geometry_shader: Bool32,
    pub tessellation_shader: Bool32,
    pub sample_rate_shading: Bool32,
    pub dual_src_blend: Bool32,
    pub logic_op: Bool32,
    pub multi_draw_indirect: Bool32,
    pub draw_indirect_first_instance: Bool32,
    pub depth_clamp: Bool32,
    pub depth_bias_clamp: Bool32,
    pub fill_mode_non_solid: Bool32,
    pub depth_bounds: Bool32,
    pub wide_lines: Bool32,
    pub large_points: Bool32,
    pub alpha_to_one: Bool32,
    pub multi_viewport: Bool32,
    pub sampler_anisotropy: Bool32,
    pub texture_compression_etc2: Bool32,
    pub texture_compression_astc_ldr: Bool32,
    pub texture_compression_bc: Bool32,
    pub occlusion_query_precise: Bool32,
    pub pipeline_statistics_query: Bool32,
    pub vertex_pipeline_stores_and_atomics: Bool32,
    pub fragment_stores_and_atomics: Bool32,
    pub shader_tessellation_and_geometry_point_size: Bool32,
    pub shader_image_gather_extended: Bool32,
    pub shader_storage_image_extended_formats: Bool32,
    pub shader_storage_image_multisample: Bool32,
    pub shader_storage_image_read_without_format: Bool32,
    pub shader_storage_image_write_without_format: Bool32,
    pub shader_uniform_buffer_array_dynamic_indexing: Bool32,
    pub shader_sampled_image_array_dynamic_indexing: Bool32,
    pub shader_storage_buffer_array_dynamic_indexing: Bool32,
    pub shader_storage_image_array_dynamic_indexing: Bool32,
    pub shader_clip_distance: Bool32,
    pub shader_cull_distance: Bool32,
    pub shader_float64: Bool32,
    pub shader_int64: Bool32,
    pub shader_int16: Bool32,
    pub shader_resource_residency: Bool32,
    pub shader_resource_min_lod: Bool32,
    pub sparse_binding: Bool32,
    pub sparse_residency_buffer: Bool32,
    pub sparse_residency_image2_d: Bool32,
    pub sparse_residency_image3_d: Bool32,
    pub sparse_residency2_samples: Bool32,
    pub sparse_residency4_samples: Bool32,
    pub sparse_residency8_samples: Bool32,
    pub sparse_residency16_samples: Bool32,
    pub sparse_residency_aliased: Bool32,
    pub variable_multisample_rate: Bool32,
    pub inherited_queries: Bool32,
}
impl PhysicalDeviceFeatures {
    pub fn builder<'a>() -> PhysicalDeviceFeaturesBuilder<'a> {
        PhysicalDeviceFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceFeaturesBuilder<'a> {
    inner: PhysicalDeviceFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceFeaturesBuilder<'a> {
    type Target = PhysicalDeviceFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceFeaturesBuilder<'a> {
    #[inline]
    pub fn robust_buffer_access(mut self, robust_buffer_access: bool) -> Self {
        self.inner.robust_buffer_access = robust_buffer_access.into();
        self
    }
    #[inline]
    pub fn full_draw_index_uint32(mut self, full_draw_index_uint32: bool) -> Self {
        self.inner.full_draw_index_uint32 = full_draw_index_uint32.into();
        self
    }
    #[inline]
    pub fn image_cube_array(mut self, image_cube_array: bool) -> Self {
        self.inner.image_cube_array = image_cube_array.into();
        self
    }
    #[inline]
    pub fn independent_blend(mut self, independent_blend: bool) -> Self {
        self.inner.independent_blend = independent_blend.into();
        self
    }
    #[inline]
    pub fn geometry_shader(mut self, geometry_shader: bool) -> Self {
        self.inner.geometry_shader = geometry_shader.into();
        self
    }
    #[inline]
    pub fn tessellation_shader(mut self, tessellation_shader: bool) -> Self {
        self.inner.tessellation_shader = tessellation_shader.into();
        self
    }
    #[inline]
    pub fn sample_rate_shading(mut self, sample_rate_shading: bool) -> Self {
        self.inner.sample_rate_shading = sample_rate_shading.into();
        self
    }
    #[inline]
    pub fn dual_src_blend(mut self, dual_src_blend: bool) -> Self {
        self.inner.dual_src_blend = dual_src_blend.into();
        self
    }
    #[inline]
    pub fn logic_op(mut self, logic_op: bool) -> Self {
        self.inner.logic_op = logic_op.into();
        self
    }
    #[inline]
    pub fn multi_draw_indirect(mut self, multi_draw_indirect: bool) -> Self {
        self.inner.multi_draw_indirect = multi_draw_indirect.into();
        self
    }
    #[inline]
    pub fn draw_indirect_first_instance(mut self, draw_indirect_first_instance: bool) -> Self {
        self.inner.draw_indirect_first_instance = draw_indirect_first_instance.into();
        self
    }
    #[inline]
    pub fn depth_clamp(mut self, depth_clamp: bool) -> Self {
        self.inner.depth_clamp = depth_clamp.into();
        self
    }
    #[inline]
    pub fn depth_bias_clamp(mut self, depth_bias_clamp: bool) -> Self {
        self.inner.depth_bias_clamp = depth_bias_clamp.into();
        self
    }
    #[inline]
    pub fn fill_mode_non_solid(mut self, fill_mode_non_solid: bool) -> Self {
        self.inner.fill_mode_non_solid = fill_mode_non_solid.into();
        self
    }
    #[inline]
    pub fn depth_bounds(mut self, depth_bounds: bool) -> Self {
        self.inner.depth_bounds = depth_bounds.into();
        self
    }
    #[inline]
    pub fn wide_lines(mut self, wide_lines: bool) -> Self {
        self.inner.wide_lines = wide_lines.into();
        self
    }
    #[inline]
    pub fn large_points(mut self, large_points: bool) -> Self {
        self.inner.large_points = large_points.into();
        self
    }
    #[inline]
    pub fn alpha_to_one(mut self, alpha_to_one: bool) -> Self {
        self.inner.alpha_to_one = alpha_to_one.into();
        self
    }
    #[inline]
    pub fn multi_viewport(mut self, multi_viewport: bool) -> Self {
        self.inner.multi_viewport = multi_viewport.into();
        self
    }
    #[inline]
    pub fn sampler_anisotropy(mut self, sampler_anisotropy: bool) -> Self {
        self.inner.sampler_anisotropy = sampler_anisotropy.into();
        self
    }
    #[inline]
    pub fn texture_compression_etc2(mut self, texture_compression_etc2: bool) -> Self {
        self.inner.texture_compression_etc2 = texture_compression_etc2.into();
        self
    }
    #[inline]
    pub fn texture_compression_astc_ldr(mut self, texture_compression_astc_ldr: bool) -> Self {
        self.inner.texture_compression_astc_ldr = texture_compression_astc_ldr.into();
        self
    }
    #[inline]
    pub fn texture_compression_bc(mut self, texture_compression_bc: bool) -> Self {
        self.inner.texture_compression_bc = texture_compression_bc.into();
        self
    }
    #[inline]
    pub fn occlusion_query_precise(mut self, occlusion_query_precise: bool) -> Self {
        self.inner.occlusion_query_precise = occlusion_query_precise.into();
        self
    }
    #[inline]
    pub fn pipeline_statistics_query(mut self, pipeline_statistics_query: bool) -> Self {
        self.inner.pipeline_statistics_query = pipeline_statistics_query.into();
        self
    }
    #[inline]
    pub fn vertex_pipeline_stores_and_atomics(
        mut self,
        vertex_pipeline_stores_and_atomics: bool,
    ) -> Self {
        self.inner.vertex_pipeline_stores_and_atomics = vertex_pipeline_stores_and_atomics.into();
        self
    }
    #[inline]
    pub fn fragment_stores_and_atomics(mut self, fragment_stores_and_atomics: bool) -> Self {
        self.inner.fragment_stores_and_atomics = fragment_stores_and_atomics.into();
        self
    }
    #[inline]
    pub fn shader_tessellation_and_geometry_point_size(
        mut self,
        shader_tessellation_and_geometry_point_size: bool,
    ) -> Self {
        self.inner.shader_tessellation_and_geometry_point_size =
            shader_tessellation_and_geometry_point_size.into();
        self
    }
    #[inline]
    pub fn shader_image_gather_extended(mut self, shader_image_gather_extended: bool) -> Self {
        self.inner.shader_image_gather_extended = shader_image_gather_extended.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_extended_formats(
        mut self,
        shader_storage_image_extended_formats: bool,
    ) -> Self {
        self.inner.shader_storage_image_extended_formats =
            shader_storage_image_extended_formats.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_multisample(
        mut self,
        shader_storage_image_multisample: bool,
    ) -> Self {
        self.inner.shader_storage_image_multisample = shader_storage_image_multisample.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_read_without_format(
        mut self,
        shader_storage_image_read_without_format: bool,
    ) -> Self {
        self.inner.shader_storage_image_read_without_format =
            shader_storage_image_read_without_format.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_write_without_format(
        mut self,
        shader_storage_image_write_without_format: bool,
    ) -> Self {
        self.inner.shader_storage_image_write_without_format =
            shader_storage_image_write_without_format.into();
        self
    }
    #[inline]
    pub fn shader_uniform_buffer_array_dynamic_indexing(
        mut self,
        shader_uniform_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.inner.shader_uniform_buffer_array_dynamic_indexing =
            shader_uniform_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_sampled_image_array_dynamic_indexing(
        mut self,
        shader_sampled_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.inner.shader_sampled_image_array_dynamic_indexing =
            shader_sampled_image_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_buffer_array_dynamic_indexing(
        mut self,
        shader_storage_buffer_array_dynamic_indexing: bool,
    ) -> Self {
        self.inner.shader_storage_buffer_array_dynamic_indexing =
            shader_storage_buffer_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_storage_image_array_dynamic_indexing(
        mut self,
        shader_storage_image_array_dynamic_indexing: bool,
    ) -> Self {
        self.inner.shader_storage_image_array_dynamic_indexing =
            shader_storage_image_array_dynamic_indexing.into();
        self
    }
    #[inline]
    pub fn shader_clip_distance(mut self, shader_clip_distance: bool) -> Self {
        self.inner.shader_clip_distance = shader_clip_distance.into();
        self
    }
    #[inline]
    pub fn shader_cull_distance(mut self, shader_cull_distance: bool) -> Self {
        self.inner.shader_cull_distance = shader_cull_distance.into();
        self
    }
    #[inline]
    pub fn shader_float64(mut self, shader_float64: bool) -> Self {
        self.inner.shader_float64 = shader_float64.into();
        self
    }
    #[inline]
    pub fn shader_int64(mut self, shader_int64: bool) -> Self {
        self.inner.shader_int64 = shader_int64.into();
        self
    }
    #[inline]
    pub fn shader_int16(mut self, shader_int16: bool) -> Self {
        self.inner.shader_int16 = shader_int16.into();
        self
    }
    #[inline]
    pub fn shader_resource_residency(mut self, shader_resource_residency: bool) -> Self {
        self.inner.shader_resource_residency = shader_resource_residency.into();
        self
    }
    #[inline]
    pub fn shader_resource_min_lod(mut self, shader_resource_min_lod: bool) -> Self {
        self.inner.shader_resource_min_lod = shader_resource_min_lod.into();
        self
    }
    #[inline]
    pub fn sparse_binding(mut self, sparse_binding: bool) -> Self {
        self.inner.sparse_binding = sparse_binding.into();
        self
    }
    #[inline]
    pub fn sparse_residency_buffer(mut self, sparse_residency_buffer: bool) -> Self {
        self.inner.sparse_residency_buffer = sparse_residency_buffer.into();
        self
    }
    #[inline]
    pub fn sparse_residency_image2_d(mut self, sparse_residency_image2_d: bool) -> Self {
        self.inner.sparse_residency_image2_d = sparse_residency_image2_d.into();
        self
    }
    #[inline]
    pub fn sparse_residency_image3_d(mut self, sparse_residency_image3_d: bool) -> Self {
        self.inner.sparse_residency_image3_d = sparse_residency_image3_d.into();
        self
    }
    #[inline]
    pub fn sparse_residency2_samples(mut self, sparse_residency2_samples: bool) -> Self {
        self.inner.sparse_residency2_samples = sparse_residency2_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency4_samples(mut self, sparse_residency4_samples: bool) -> Self {
        self.inner.sparse_residency4_samples = sparse_residency4_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency8_samples(mut self, sparse_residency8_samples: bool) -> Self {
        self.inner.sparse_residency8_samples = sparse_residency8_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency16_samples(mut self, sparse_residency16_samples: bool) -> Self {
        self.inner.sparse_residency16_samples = sparse_residency16_samples.into();
        self
    }
    #[inline]
    pub fn sparse_residency_aliased(mut self, sparse_residency_aliased: bool) -> Self {
        self.inner.sparse_residency_aliased = sparse_residency_aliased.into();
        self
    }
    #[inline]
    pub fn variable_multisample_rate(mut self, variable_multisample_rate: bool) -> Self {
        self.inner.variable_multisample_rate = variable_multisample_rate.into();
        self
    }
    #[inline]
    pub fn inherited_queries(mut self, inherited_queries: bool) -> Self {
        self.inner.inherited_queries = inherited_queries.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSparseProperties.html>"]
pub struct PhysicalDeviceSparseProperties {
    pub residency_standard2_d_block_shape: Bool32,
    pub residency_standard2_d_multisample_block_shape: Bool32,
    pub residency_standard3_d_block_shape: Bool32,
    pub residency_aligned_mip_size: Bool32,
    pub residency_non_resident_strict: Bool32,
}
impl PhysicalDeviceSparseProperties {
    pub fn builder<'a>() -> PhysicalDeviceSparsePropertiesBuilder<'a> {
        PhysicalDeviceSparsePropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSparsePropertiesBuilder<'a> {
    inner: PhysicalDeviceSparseProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceSparsePropertiesBuilder<'a> {
    type Target = PhysicalDeviceSparseProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSparsePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSparsePropertiesBuilder<'a> {
    #[inline]
    pub fn residency_standard2_d_block_shape(
        mut self,
        residency_standard2_d_block_shape: bool,
    ) -> Self {
        self.inner.residency_standard2_d_block_shape = residency_standard2_d_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_standard2_d_multisample_block_shape(
        mut self,
        residency_standard2_d_multisample_block_shape: bool,
    ) -> Self {
        self.inner.residency_standard2_d_multisample_block_shape =
            residency_standard2_d_multisample_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_standard3_d_block_shape(
        mut self,
        residency_standard3_d_block_shape: bool,
    ) -> Self {
        self.inner.residency_standard3_d_block_shape = residency_standard3_d_block_shape.into();
        self
    }
    #[inline]
    pub fn residency_aligned_mip_size(mut self, residency_aligned_mip_size: bool) -> Self {
        self.inner.residency_aligned_mip_size = residency_aligned_mip_size.into();
        self
    }
    #[inline]
    pub fn residency_non_resident_strict(mut self, residency_non_resident_strict: bool) -> Self {
        self.inner.residency_non_resident_strict = residency_non_resident_strict.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSparseProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceLimits.html>"]
pub struct PhysicalDeviceLimits {
    pub max_image_dimension1_d: u32,
    pub max_image_dimension2_d: u32,
    pub max_image_dimension3_d: u32,
    pub max_image_dimension_cube: u32,
    pub max_image_array_layers: u32,
    pub max_texel_buffer_elements: u32,
    pub max_uniform_buffer_range: u32,
    pub max_storage_buffer_range: u32,
    pub max_push_constants_size: u32,
    pub max_memory_allocation_count: u32,
    pub max_sampler_allocation_count: u32,
    pub buffer_image_granularity: DeviceSize,
    pub sparse_address_space_size: DeviceSize,
    pub max_bound_descriptor_sets: u32,
    pub max_per_stage_descriptor_samplers: u32,
    pub max_per_stage_descriptor_uniform_buffers: u32,
    pub max_per_stage_descriptor_storage_buffers: u32,
    pub max_per_stage_descriptor_sampled_images: u32,
    pub max_per_stage_descriptor_storage_images: u32,
    pub max_per_stage_descriptor_input_attachments: u32,
    pub max_per_stage_resources: u32,
    pub max_descriptor_set_samplers: u32,
    pub max_descriptor_set_uniform_buffers: u32,
    pub max_descriptor_set_uniform_buffers_dynamic: u32,
    pub max_descriptor_set_storage_buffers: u32,
    pub max_descriptor_set_storage_buffers_dynamic: u32,
    pub max_descriptor_set_sampled_images: u32,
    pub max_descriptor_set_storage_images: u32,
    pub max_descriptor_set_input_attachments: u32,
    pub max_vertex_input_attributes: u32,
    pub max_vertex_input_bindings: u32,
    pub max_vertex_input_attribute_offset: u32,
    pub max_vertex_input_binding_stride: u32,
    pub max_vertex_output_components: u32,
    pub max_tessellation_generation_level: u32,
    pub max_tessellation_patch_size: u32,
    pub max_tessellation_control_per_vertex_input_components: u32,
    pub max_tessellation_control_per_vertex_output_components: u32,
    pub max_tessellation_control_per_patch_output_components: u32,
    pub max_tessellation_control_total_output_components: u32,
    pub max_tessellation_evaluation_input_components: u32,
    pub max_tessellation_evaluation_output_components: u32,
    pub max_geometry_shader_invocations: u32,
    pub max_geometry_input_components: u32,
    pub max_geometry_output_components: u32,
    pub max_geometry_output_vertices: u32,
    pub max_geometry_total_output_components: u32,
    pub max_fragment_input_components: u32,
    pub max_fragment_output_attachments: u32,
    pub max_fragment_dual_src_attachments: u32,
    pub max_fragment_combined_output_resources: u32,
    pub max_compute_shared_memory_size: u32,
    pub max_compute_work_group_count: [u32; 3],
    pub max_compute_work_group_invocations: u32,
    pub max_compute_work_group_size: [u32; 3],
    pub sub_pixel_precision_bits: u32,
    pub sub_texel_precision_bits: u32,
    pub mipmap_precision_bits: u32,
    pub max_draw_indexed_index_value: u32,
    pub max_draw_indirect_count: u32,
    pub max_sampler_lod_bias: f32,
    pub max_sampler_anisotropy: f32,
    pub max_viewports: u32,
    pub max_viewport_dimensions: [u32; 2],
    pub viewport_bounds_range: [f32; 2],
    pub viewport_sub_pixel_bits: u32,
    pub min_memory_map_alignment: usize,
    pub min_texel_buffer_offset_alignment: DeviceSize,
    pub min_uniform_buffer_offset_alignment: DeviceSize,
    pub min_storage_buffer_offset_alignment: DeviceSize,
    pub min_texel_offset: i32,
    pub max_texel_offset: u32,
    pub min_texel_gather_offset: i32,
    pub max_texel_gather_offset: u32,
    pub min_interpolation_offset: f32,
    pub max_interpolation_offset: f32,
    pub sub_pixel_interpolation_offset_bits: u32,
    pub max_framebuffer_width: u32,
    pub max_framebuffer_height: u32,
    pub max_framebuffer_layers: u32,
    pub framebuffer_color_sample_counts: SampleCountFlags,
    pub framebuffer_depth_sample_counts: SampleCountFlags,
    pub framebuffer_stencil_sample_counts: SampleCountFlags,
    pub framebuffer_no_attachments_sample_counts: SampleCountFlags,
    pub max_color_attachments: u32,
    pub sampled_image_color_sample_counts: SampleCountFlags,
    pub sampled_image_integer_sample_counts: SampleCountFlags,
    pub sampled_image_depth_sample_counts: SampleCountFlags,
    pub sampled_image_stencil_sample_counts: SampleCountFlags,
    pub storage_image_sample_counts: SampleCountFlags,
    pub max_sample_mask_words: u32,
    pub timestamp_compute_and_graphics: Bool32,
    pub timestamp_period: f32,
    pub max_clip_distances: u32,
    pub max_cull_distances: u32,
    pub max_combined_clip_and_cull_distances: u32,
    pub discrete_queue_priorities: u32,
    pub point_size_range: [f32; 2],
    pub line_width_range: [f32; 2],
    pub point_size_granularity: f32,
    pub line_width_granularity: f32,
    pub strict_lines: Bool32,
    pub standard_sample_locations: Bool32,
    pub optimal_buffer_copy_offset_alignment: DeviceSize,
    pub optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    pub non_coherent_atom_size: DeviceSize,
}
impl ::std::default::Default for PhysicalDeviceLimits {
    #[inline]
    fn default() -> Self {
        Self {
            max_image_dimension1_d: u32::default(),
            max_image_dimension2_d: u32::default(),
            max_image_dimension3_d: u32::default(),
            max_image_dimension_cube: u32::default(),
            max_image_array_layers: u32::default(),
            max_texel_buffer_elements: u32::default(),
            max_uniform_buffer_range: u32::default(),
            max_storage_buffer_range: u32::default(),
            max_push_constants_size: u32::default(),
            max_memory_allocation_count: u32::default(),
            max_sampler_allocation_count: u32::default(),
            buffer_image_granularity: DeviceSize::default(),
            sparse_address_space_size: DeviceSize::default(),
            max_bound_descriptor_sets: u32::default(),
            max_per_stage_descriptor_samplers: u32::default(),
            max_per_stage_descriptor_uniform_buffers: u32::default(),
            max_per_stage_descriptor_storage_buffers: u32::default(),
            max_per_stage_descriptor_sampled_images: u32::default(),
            max_per_stage_descriptor_storage_images: u32::default(),
            max_per_stage_descriptor_input_attachments: u32::default(),
            max_per_stage_resources: u32::default(),
            max_descriptor_set_samplers: u32::default(),
            max_descriptor_set_uniform_buffers: u32::default(),
            max_descriptor_set_uniform_buffers_dynamic: u32::default(),
            max_descriptor_set_storage_buffers: u32::default(),
            max_descriptor_set_storage_buffers_dynamic: u32::default(),
            max_descriptor_set_sampled_images: u32::default(),
            max_descriptor_set_storage_images: u32::default(),
            max_descriptor_set_input_attachments: u32::default(),
            max_vertex_input_attributes: u32::default(),
            max_vertex_input_bindings: u32::default(),
            max_vertex_input_attribute_offset: u32::default(),
            max_vertex_input_binding_stride: u32::default(),
            max_vertex_output_components: u32::default(),
            max_tessellation_generation_level: u32::default(),
            max_tessellation_patch_size: u32::default(),
            max_tessellation_control_per_vertex_input_components: u32::default(),
            max_tessellation_control_per_vertex_output_components: u32::default(),
            max_tessellation_control_per_patch_output_components: u32::default(),
            max_tessellation_control_total_output_components: u32::default(),
            max_tessellation_evaluation_input_components: u32::default(),
            max_tessellation_evaluation_output_components: u32::default(),
            max_geometry_shader_invocations: u32::default(),
            max_geometry_input_components: u32::default(),
            max_geometry_output_components: u32::default(),
            max_geometry_output_vertices: u32::default(),
            max_geometry_total_output_components: u32::default(),
            max_fragment_input_components: u32::default(),
            max_fragment_output_attachments: u32::default(),
            max_fragment_dual_src_attachments: u32::default(),
            max_fragment_combined_output_resources: u32::default(),
            max_compute_shared_memory_size: u32::default(),
            max_compute_work_group_count: unsafe { ::std::mem::zeroed() },
            max_compute_work_group_invocations: u32::default(),
            max_compute_work_group_size: unsafe { ::std::mem::zeroed() },
            sub_pixel_precision_bits: u32::default(),
            sub_texel_precision_bits: u32::default(),
            mipmap_precision_bits: u32::default(),
            max_draw_indexed_index_value: u32::default(),
            max_draw_indirect_count: u32::default(),
            max_sampler_lod_bias: f32::default(),
            max_sampler_anisotropy: f32::default(),
            max_viewports: u32::default(),
            max_viewport_dimensions: unsafe { ::std::mem::zeroed() },
            viewport_bounds_range: unsafe { ::std::mem::zeroed() },
            viewport_sub_pixel_bits: u32::default(),
            min_memory_map_alignment: usize::default(),
            min_texel_buffer_offset_alignment: DeviceSize::default(),
            min_uniform_buffer_offset_alignment: DeviceSize::default(),
            min_storage_buffer_offset_alignment: DeviceSize::default(),
            min_texel_offset: i32::default(),
            max_texel_offset: u32::default(),
            min_texel_gather_offset: i32::default(),
            max_texel_gather_offset: u32::default(),
            min_interpolation_offset: f32::default(),
            max_interpolation_offset: f32::default(),
            sub_pixel_interpolation_offset_bits: u32::default(),
            max_framebuffer_width: u32::default(),
            max_framebuffer_height: u32::default(),
            max_framebuffer_layers: u32::default(),
            framebuffer_color_sample_counts: SampleCountFlags::default(),
            framebuffer_depth_sample_counts: SampleCountFlags::default(),
            framebuffer_stencil_sample_counts: SampleCountFlags::default(),
            framebuffer_no_attachments_sample_counts: SampleCountFlags::default(),
            max_color_attachments: u32::default(),
            sampled_image_color_sample_counts: SampleCountFlags::default(),
            sampled_image_integer_sample_counts: SampleCountFlags::default(),
            sampled_image_depth_sample_counts: SampleCountFlags::default(),
            sampled_image_stencil_sample_counts: SampleCountFlags::default(),
            storage_image_sample_counts: SampleCountFlags::default(),
            max_sample_mask_words: u32::default(),
            timestamp_compute_and_graphics: Bool32::default(),
            timestamp_period: f32::default(),
            max_clip_distances: u32::default(),
            max_cull_distances: u32::default(),
            max_combined_clip_and_cull_distances: u32::default(),
            discrete_queue_priorities: u32::default(),
            point_size_range: unsafe { ::std::mem::zeroed() },
            line_width_range: unsafe { ::std::mem::zeroed() },
            point_size_granularity: f32::default(),
            line_width_granularity: f32::default(),
            strict_lines: Bool32::default(),
            standard_sample_locations: Bool32::default(),
            optimal_buffer_copy_offset_alignment: DeviceSize::default(),
            optimal_buffer_copy_row_pitch_alignment: DeviceSize::default(),
            non_coherent_atom_size: DeviceSize::default(),
        }
    }
}
impl PhysicalDeviceLimits {
    pub fn builder<'a>() -> PhysicalDeviceLimitsBuilder<'a> {
        PhysicalDeviceLimitsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceLimitsBuilder<'a> {
    inner: PhysicalDeviceLimits,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceLimitsBuilder<'a> {
    type Target = PhysicalDeviceLimits;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceLimitsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceLimitsBuilder<'a> {
    #[inline]
    pub fn max_image_dimension1_d(mut self, max_image_dimension1_d: u32) -> Self {
        self.inner.max_image_dimension1_d = max_image_dimension1_d;
        self
    }
    #[inline]
    pub fn max_image_dimension2_d(mut self, max_image_dimension2_d: u32) -> Self {
        self.inner.max_image_dimension2_d = max_image_dimension2_d;
        self
    }
    #[inline]
    pub fn max_image_dimension3_d(mut self, max_image_dimension3_d: u32) -> Self {
        self.inner.max_image_dimension3_d = max_image_dimension3_d;
        self
    }
    #[inline]
    pub fn max_image_dimension_cube(mut self, max_image_dimension_cube: u32) -> Self {
        self.inner.max_image_dimension_cube = max_image_dimension_cube;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.inner.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn max_texel_buffer_elements(mut self, max_texel_buffer_elements: u32) -> Self {
        self.inner.max_texel_buffer_elements = max_texel_buffer_elements;
        self
    }
    #[inline]
    pub fn max_uniform_buffer_range(mut self, max_uniform_buffer_range: u32) -> Self {
        self.inner.max_uniform_buffer_range = max_uniform_buffer_range;
        self
    }
    #[inline]
    pub fn max_storage_buffer_range(mut self, max_storage_buffer_range: u32) -> Self {
        self.inner.max_storage_buffer_range = max_storage_buffer_range;
        self
    }
    #[inline]
    pub fn max_push_constants_size(mut self, max_push_constants_size: u32) -> Self {
        self.inner.max_push_constants_size = max_push_constants_size;
        self
    }
    #[inline]
    pub fn max_memory_allocation_count(mut self, max_memory_allocation_count: u32) -> Self {
        self.inner.max_memory_allocation_count = max_memory_allocation_count;
        self
    }
    #[inline]
    pub fn max_sampler_allocation_count(mut self, max_sampler_allocation_count: u32) -> Self {
        self.inner.max_sampler_allocation_count = max_sampler_allocation_count;
        self
    }
    #[inline]
    pub fn buffer_image_granularity(mut self, buffer_image_granularity: DeviceSize) -> Self {
        self.inner.buffer_image_granularity = buffer_image_granularity;
        self
    }
    #[inline]
    pub fn sparse_address_space_size(mut self, sparse_address_space_size: DeviceSize) -> Self {
        self.inner.sparse_address_space_size = sparse_address_space_size;
        self
    }
    #[inline]
    pub fn max_bound_descriptor_sets(mut self, max_bound_descriptor_sets: u32) -> Self {
        self.inner.max_bound_descriptor_sets = max_bound_descriptor_sets;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_samplers(
        mut self,
        max_per_stage_descriptor_samplers: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_samplers = max_per_stage_descriptor_samplers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_uniform_buffers(
        mut self,
        max_per_stage_descriptor_uniform_buffers: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_uniform_buffers =
            max_per_stage_descriptor_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_storage_buffers(
        mut self,
        max_per_stage_descriptor_storage_buffers: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_storage_buffers =
            max_per_stage_descriptor_storage_buffers;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_sampled_images(
        mut self,
        max_per_stage_descriptor_sampled_images: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_sampled_images =
            max_per_stage_descriptor_sampled_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_storage_images(
        mut self,
        max_per_stage_descriptor_storage_images: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_storage_images =
            max_per_stage_descriptor_storage_images;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_input_attachments(
        mut self,
        max_per_stage_descriptor_input_attachments: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_input_attachments =
            max_per_stage_descriptor_input_attachments;
        self
    }
    #[inline]
    pub fn max_per_stage_resources(mut self, max_per_stage_resources: u32) -> Self {
        self.inner.max_per_stage_resources = max_per_stage_resources;
        self
    }
    #[inline]
    pub fn max_descriptor_set_samplers(mut self, max_descriptor_set_samplers: u32) -> Self {
        self.inner.max_descriptor_set_samplers = max_descriptor_set_samplers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_uniform_buffers(
        mut self,
        max_descriptor_set_uniform_buffers: u32,
    ) -> Self {
        self.inner.max_descriptor_set_uniform_buffers = max_descriptor_set_uniform_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_uniform_buffers_dynamic(
        mut self,
        max_descriptor_set_uniform_buffers_dynamic: u32,
    ) -> Self {
        self.inner.max_descriptor_set_uniform_buffers_dynamic =
            max_descriptor_set_uniform_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_buffers(
        mut self,
        max_descriptor_set_storage_buffers: u32,
    ) -> Self {
        self.inner.max_descriptor_set_storage_buffers = max_descriptor_set_storage_buffers;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_buffers_dynamic(
        mut self,
        max_descriptor_set_storage_buffers_dynamic: u32,
    ) -> Self {
        self.inner.max_descriptor_set_storage_buffers_dynamic =
            max_descriptor_set_storage_buffers_dynamic;
        self
    }
    #[inline]
    pub fn max_descriptor_set_sampled_images(
        mut self,
        max_descriptor_set_sampled_images: u32,
    ) -> Self {
        self.inner.max_descriptor_set_sampled_images = max_descriptor_set_sampled_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_storage_images(
        mut self,
        max_descriptor_set_storage_images: u32,
    ) -> Self {
        self.inner.max_descriptor_set_storage_images = max_descriptor_set_storage_images;
        self
    }
    #[inline]
    pub fn max_descriptor_set_input_attachments(
        mut self,
        max_descriptor_set_input_attachments: u32,
    ) -> Self {
        self.inner.max_descriptor_set_input_attachments = max_descriptor_set_input_attachments;
        self
    }
    #[inline]
    pub fn max_vertex_input_attributes(mut self, max_vertex_input_attributes: u32) -> Self {
        self.inner.max_vertex_input_attributes = max_vertex_input_attributes;
        self
    }
    #[inline]
    pub fn max_vertex_input_bindings(mut self, max_vertex_input_bindings: u32) -> Self {
        self.inner.max_vertex_input_bindings = max_vertex_input_bindings;
        self
    }
    #[inline]
    pub fn max_vertex_input_attribute_offset(
        mut self,
        max_vertex_input_attribute_offset: u32,
    ) -> Self {
        self.inner.max_vertex_input_attribute_offset = max_vertex_input_attribute_offset;
        self
    }
    #[inline]
    pub fn max_vertex_input_binding_stride(mut self, max_vertex_input_binding_stride: u32) -> Self {
        self.inner.max_vertex_input_binding_stride = max_vertex_input_binding_stride;
        self
    }
    #[inline]
    pub fn max_vertex_output_components(mut self, max_vertex_output_components: u32) -> Self {
        self.inner.max_vertex_output_components = max_vertex_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_generation_level(
        mut self,
        max_tessellation_generation_level: u32,
    ) -> Self {
        self.inner.max_tessellation_generation_level = max_tessellation_generation_level;
        self
    }
    #[inline]
    pub fn max_tessellation_patch_size(mut self, max_tessellation_patch_size: u32) -> Self {
        self.inner.max_tessellation_patch_size = max_tessellation_patch_size;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_vertex_input_components(
        mut self,
        max_tessellation_control_per_vertex_input_components: u32,
    ) -> Self {
        self.inner
            .max_tessellation_control_per_vertex_input_components =
            max_tessellation_control_per_vertex_input_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_vertex_output_components(
        mut self,
        max_tessellation_control_per_vertex_output_components: u32,
    ) -> Self {
        self.inner
            .max_tessellation_control_per_vertex_output_components =
            max_tessellation_control_per_vertex_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_per_patch_output_components(
        mut self,
        max_tessellation_control_per_patch_output_components: u32,
    ) -> Self {
        self.inner
            .max_tessellation_control_per_patch_output_components =
            max_tessellation_control_per_patch_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_control_total_output_components(
        mut self,
        max_tessellation_control_total_output_components: u32,
    ) -> Self {
        self.inner.max_tessellation_control_total_output_components =
            max_tessellation_control_total_output_components;
        self
    }
    #[inline]
    pub fn max_tessellation_evaluation_input_components(
        mut self,
        max_tessellation_evaluation_input_components: u32,
    ) -> Self {
        self.inner.max_tessellation_evaluation_input_components =
            max_tessellation_evaluation_input_components;
        self
    }
    #[inline]
    pub fn max_tessellation_evaluation_output_components(
        mut self,
        max_tessellation_evaluation_output_components: u32,
    ) -> Self {
        self.inner.max_tessellation_evaluation_output_components =
            max_tessellation_evaluation_output_components;
        self
    }
    #[inline]
    pub fn max_geometry_shader_invocations(mut self, max_geometry_shader_invocations: u32) -> Self {
        self.inner.max_geometry_shader_invocations = max_geometry_shader_invocations;
        self
    }
    #[inline]
    pub fn max_geometry_input_components(mut self, max_geometry_input_components: u32) -> Self {
        self.inner.max_geometry_input_components = max_geometry_input_components;
        self
    }
    #[inline]
    pub fn max_geometry_output_components(mut self, max_geometry_output_components: u32) -> Self {
        self.inner.max_geometry_output_components = max_geometry_output_components;
        self
    }
    #[inline]
    pub fn max_geometry_output_vertices(mut self, max_geometry_output_vertices: u32) -> Self {
        self.inner.max_geometry_output_vertices = max_geometry_output_vertices;
        self
    }
    #[inline]
    pub fn max_geometry_total_output_components(
        mut self,
        max_geometry_total_output_components: u32,
    ) -> Self {
        self.inner.max_geometry_total_output_components = max_geometry_total_output_components;
        self
    }
    #[inline]
    pub fn max_fragment_input_components(mut self, max_fragment_input_components: u32) -> Self {
        self.inner.max_fragment_input_components = max_fragment_input_components;
        self
    }
    #[inline]
    pub fn max_fragment_output_attachments(mut self, max_fragment_output_attachments: u32) -> Self {
        self.inner.max_fragment_output_attachments = max_fragment_output_attachments;
        self
    }
    #[inline]
    pub fn max_fragment_dual_src_attachments(
        mut self,
        max_fragment_dual_src_attachments: u32,
    ) -> Self {
        self.inner.max_fragment_dual_src_attachments = max_fragment_dual_src_attachments;
        self
    }
    #[inline]
    pub fn max_fragment_combined_output_resources(
        mut self,
        max_fragment_combined_output_resources: u32,
    ) -> Self {
        self.inner.max_fragment_combined_output_resources = max_fragment_combined_output_resources;
        self
    }
    #[inline]
    pub fn max_compute_shared_memory_size(mut self, max_compute_shared_memory_size: u32) -> Self {
        self.inner.max_compute_shared_memory_size = max_compute_shared_memory_size;
        self
    }
    #[inline]
    pub fn max_compute_work_group_count(mut self, max_compute_work_group_count: [u32; 3]) -> Self {
        self.inner.max_compute_work_group_count = max_compute_work_group_count;
        self
    }
    #[inline]
    pub fn max_compute_work_group_invocations(
        mut self,
        max_compute_work_group_invocations: u32,
    ) -> Self {
        self.inner.max_compute_work_group_invocations = max_compute_work_group_invocations;
        self
    }
    #[inline]
    pub fn max_compute_work_group_size(mut self, max_compute_work_group_size: [u32; 3]) -> Self {
        self.inner.max_compute_work_group_size = max_compute_work_group_size;
        self
    }
    #[inline]
    pub fn sub_pixel_precision_bits(mut self, sub_pixel_precision_bits: u32) -> Self {
        self.inner.sub_pixel_precision_bits = sub_pixel_precision_bits;
        self
    }
    #[inline]
    pub fn sub_texel_precision_bits(mut self, sub_texel_precision_bits: u32) -> Self {
        self.inner.sub_texel_precision_bits = sub_texel_precision_bits;
        self
    }
    #[inline]
    pub fn mipmap_precision_bits(mut self, mipmap_precision_bits: u32) -> Self {
        self.inner.mipmap_precision_bits = mipmap_precision_bits;
        self
    }
    #[inline]
    pub fn max_draw_indexed_index_value(mut self, max_draw_indexed_index_value: u32) -> Self {
        self.inner.max_draw_indexed_index_value = max_draw_indexed_index_value;
        self
    }
    #[inline]
    pub fn max_draw_indirect_count(mut self, max_draw_indirect_count: u32) -> Self {
        self.inner.max_draw_indirect_count = max_draw_indirect_count;
        self
    }
    #[inline]
    pub fn max_sampler_lod_bias(mut self, max_sampler_lod_bias: f32) -> Self {
        self.inner.max_sampler_lod_bias = max_sampler_lod_bias;
        self
    }
    #[inline]
    pub fn max_sampler_anisotropy(mut self, max_sampler_anisotropy: f32) -> Self {
        self.inner.max_sampler_anisotropy = max_sampler_anisotropy;
        self
    }
    #[inline]
    pub fn max_viewports(mut self, max_viewports: u32) -> Self {
        self.inner.max_viewports = max_viewports;
        self
    }
    #[inline]
    pub fn max_viewport_dimensions(mut self, max_viewport_dimensions: [u32; 2]) -> Self {
        self.inner.max_viewport_dimensions = max_viewport_dimensions;
        self
    }
    #[inline]
    pub fn viewport_bounds_range(mut self, viewport_bounds_range: [f32; 2]) -> Self {
        self.inner.viewport_bounds_range = viewport_bounds_range;
        self
    }
    #[inline]
    pub fn viewport_sub_pixel_bits(mut self, viewport_sub_pixel_bits: u32) -> Self {
        self.inner.viewport_sub_pixel_bits = viewport_sub_pixel_bits;
        self
    }
    #[inline]
    pub fn min_memory_map_alignment(mut self, min_memory_map_alignment: usize) -> Self {
        self.inner.min_memory_map_alignment = min_memory_map_alignment;
        self
    }
    #[inline]
    pub fn min_texel_buffer_offset_alignment(
        mut self,
        min_texel_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.inner.min_texel_buffer_offset_alignment = min_texel_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_uniform_buffer_offset_alignment(
        mut self,
        min_uniform_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.inner.min_uniform_buffer_offset_alignment = min_uniform_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_storage_buffer_offset_alignment(
        mut self,
        min_storage_buffer_offset_alignment: DeviceSize,
    ) -> Self {
        self.inner.min_storage_buffer_offset_alignment = min_storage_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_texel_offset(mut self, min_texel_offset: i32) -> Self {
        self.inner.min_texel_offset = min_texel_offset;
        self
    }
    #[inline]
    pub fn max_texel_offset(mut self, max_texel_offset: u32) -> Self {
        self.inner.max_texel_offset = max_texel_offset;
        self
    }
    #[inline]
    pub fn min_texel_gather_offset(mut self, min_texel_gather_offset: i32) -> Self {
        self.inner.min_texel_gather_offset = min_texel_gather_offset;
        self
    }
    #[inline]
    pub fn max_texel_gather_offset(mut self, max_texel_gather_offset: u32) -> Self {
        self.inner.max_texel_gather_offset = max_texel_gather_offset;
        self
    }
    #[inline]
    pub fn min_interpolation_offset(mut self, min_interpolation_offset: f32) -> Self {
        self.inner.min_interpolation_offset = min_interpolation_offset;
        self
    }
    #[inline]
    pub fn max_interpolation_offset(mut self, max_interpolation_offset: f32) -> Self {
        self.inner.max_interpolation_offset = max_interpolation_offset;
        self
    }
    #[inline]
    pub fn sub_pixel_interpolation_offset_bits(
        mut self,
        sub_pixel_interpolation_offset_bits: u32,
    ) -> Self {
        self.inner.sub_pixel_interpolation_offset_bits = sub_pixel_interpolation_offset_bits;
        self
    }
    #[inline]
    pub fn max_framebuffer_width(mut self, max_framebuffer_width: u32) -> Self {
        self.inner.max_framebuffer_width = max_framebuffer_width;
        self
    }
    #[inline]
    pub fn max_framebuffer_height(mut self, max_framebuffer_height: u32) -> Self {
        self.inner.max_framebuffer_height = max_framebuffer_height;
        self
    }
    #[inline]
    pub fn max_framebuffer_layers(mut self, max_framebuffer_layers: u32) -> Self {
        self.inner.max_framebuffer_layers = max_framebuffer_layers;
        self
    }
    #[inline]
    pub fn framebuffer_color_sample_counts(
        mut self,
        framebuffer_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.framebuffer_color_sample_counts = framebuffer_color_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_depth_sample_counts(
        mut self,
        framebuffer_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.framebuffer_depth_sample_counts = framebuffer_depth_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_stencil_sample_counts(
        mut self,
        framebuffer_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.framebuffer_stencil_sample_counts = framebuffer_stencil_sample_counts;
        self
    }
    #[inline]
    pub fn framebuffer_no_attachments_sample_counts(
        mut self,
        framebuffer_no_attachments_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.framebuffer_no_attachments_sample_counts =
            framebuffer_no_attachments_sample_counts;
        self
    }
    #[inline]
    pub fn max_color_attachments(mut self, max_color_attachments: u32) -> Self {
        self.inner.max_color_attachments = max_color_attachments;
        self
    }
    #[inline]
    pub fn sampled_image_color_sample_counts(
        mut self,
        sampled_image_color_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.sampled_image_color_sample_counts = sampled_image_color_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_integer_sample_counts(
        mut self,
        sampled_image_integer_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.sampled_image_integer_sample_counts = sampled_image_integer_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_depth_sample_counts(
        mut self,
        sampled_image_depth_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.sampled_image_depth_sample_counts = sampled_image_depth_sample_counts;
        self
    }
    #[inline]
    pub fn sampled_image_stencil_sample_counts(
        mut self,
        sampled_image_stencil_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.sampled_image_stencil_sample_counts = sampled_image_stencil_sample_counts;
        self
    }
    #[inline]
    pub fn storage_image_sample_counts(
        mut self,
        storage_image_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.storage_image_sample_counts = storage_image_sample_counts;
        self
    }
    #[inline]
    pub fn max_sample_mask_words(mut self, max_sample_mask_words: u32) -> Self {
        self.inner.max_sample_mask_words = max_sample_mask_words;
        self
    }
    #[inline]
    pub fn timestamp_compute_and_graphics(mut self, timestamp_compute_and_graphics: bool) -> Self {
        self.inner.timestamp_compute_and_graphics = timestamp_compute_and_graphics.into();
        self
    }
    #[inline]
    pub fn timestamp_period(mut self, timestamp_period: f32) -> Self {
        self.inner.timestamp_period = timestamp_period;
        self
    }
    #[inline]
    pub fn max_clip_distances(mut self, max_clip_distances: u32) -> Self {
        self.inner.max_clip_distances = max_clip_distances;
        self
    }
    #[inline]
    pub fn max_cull_distances(mut self, max_cull_distances: u32) -> Self {
        self.inner.max_cull_distances = max_cull_distances;
        self
    }
    #[inline]
    pub fn max_combined_clip_and_cull_distances(
        mut self,
        max_combined_clip_and_cull_distances: u32,
    ) -> Self {
        self.inner.max_combined_clip_and_cull_distances = max_combined_clip_and_cull_distances;
        self
    }
    #[inline]
    pub fn discrete_queue_priorities(mut self, discrete_queue_priorities: u32) -> Self {
        self.inner.discrete_queue_priorities = discrete_queue_priorities;
        self
    }
    #[inline]
    pub fn point_size_range(mut self, point_size_range: [f32; 2]) -> Self {
        self.inner.point_size_range = point_size_range;
        self
    }
    #[inline]
    pub fn line_width_range(mut self, line_width_range: [f32; 2]) -> Self {
        self.inner.line_width_range = line_width_range;
        self
    }
    #[inline]
    pub fn point_size_granularity(mut self, point_size_granularity: f32) -> Self {
        self.inner.point_size_granularity = point_size_granularity;
        self
    }
    #[inline]
    pub fn line_width_granularity(mut self, line_width_granularity: f32) -> Self {
        self.inner.line_width_granularity = line_width_granularity;
        self
    }
    #[inline]
    pub fn strict_lines(mut self, strict_lines: bool) -> Self {
        self.inner.strict_lines = strict_lines.into();
        self
    }
    #[inline]
    pub fn standard_sample_locations(mut self, standard_sample_locations: bool) -> Self {
        self.inner.standard_sample_locations = standard_sample_locations.into();
        self
    }
    #[inline]
    pub fn optimal_buffer_copy_offset_alignment(
        mut self,
        optimal_buffer_copy_offset_alignment: DeviceSize,
    ) -> Self {
        self.inner.optimal_buffer_copy_offset_alignment = optimal_buffer_copy_offset_alignment;
        self
    }
    #[inline]
    pub fn optimal_buffer_copy_row_pitch_alignment(
        mut self,
        optimal_buffer_copy_row_pitch_alignment: DeviceSize,
    ) -> Self {
        self.inner.optimal_buffer_copy_row_pitch_alignment =
            optimal_buffer_copy_row_pitch_alignment;
        self
    }
    #[inline]
    pub fn non_coherent_atom_size(mut self, non_coherent_atom_size: DeviceSize) -> Self {
        self.inner.non_coherent_atom_size = non_coherent_atom_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceLimits {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSemaphoreCreateInfo.html>"]
pub struct SemaphoreCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SemaphoreCreateFlags,
}
impl ::std::default::Default for SemaphoreCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: SemaphoreCreateFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for SemaphoreCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_CREATE_INFO;
}
impl SemaphoreCreateInfo {
    pub fn builder<'a>() -> SemaphoreCreateInfoBuilder<'a> {
        SemaphoreCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreCreateInfoBuilder<'a> {
    inner: SemaphoreCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSemaphoreCreateInfo {}
impl<'a> ::std::ops::Deref for SemaphoreCreateInfoBuilder<'a> {
    type Target = SemaphoreCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: SemaphoreCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSemaphoreCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueryPoolCreateInfo.html>"]
pub struct QueryPoolCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: QueryPoolCreateFlags,
    pub query_type: QueryType,
    pub query_count: u32,
    pub pipeline_statistics: QueryPipelineStatisticFlags,
}
impl ::std::default::Default for QueryPoolCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: QueryPoolCreateFlags::default(),
            query_type: QueryType::default(),
            query_count: u32::default(),
            pipeline_statistics: QueryPipelineStatisticFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for QueryPoolCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::QUERY_POOL_CREATE_INFO;
}
impl QueryPoolCreateInfo {
    pub fn builder<'a>() -> QueryPoolCreateInfoBuilder<'a> {
        QueryPoolCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueryPoolCreateInfoBuilder<'a> {
    inner: QueryPoolCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsQueryPoolCreateInfo {}
impl<'a> ::std::ops::Deref for QueryPoolCreateInfoBuilder<'a> {
    type Target = QueryPoolCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueryPoolCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueryPoolCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: QueryPoolCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn query_type(mut self, query_type: QueryType) -> Self {
        self.inner.query_type = query_type;
        self
    }
    #[inline]
    pub fn query_count(mut self, query_count: u32) -> Self {
        self.inner.query_count = query_count;
        self
    }
    #[inline]
    pub fn pipeline_statistics(mut self, pipeline_statistics: QueryPipelineStatisticFlags) -> Self {
        self.inner.pipeline_statistics = pipeline_statistics;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueryPoolCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueryPoolCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFramebufferCreateInfo.html>"]
pub struct FramebufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: FramebufferCreateFlags,
    pub render_pass: RenderPass,
    pub attachment_count: u32,
    pub p_attachments: *const ImageView,
    pub width: u32,
    pub height: u32,
    pub layers: u32,
}
impl ::std::default::Default for FramebufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: FramebufferCreateFlags::default(),
            render_pass: RenderPass::default(),
            attachment_count: u32::default(),
            p_attachments: ::std::ptr::null(),
            width: u32::default(),
            height: u32::default(),
            layers: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for FramebufferCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::FRAMEBUFFER_CREATE_INFO;
}
impl FramebufferCreateInfo {
    pub fn builder<'a>() -> FramebufferCreateInfoBuilder<'a> {
        FramebufferCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FramebufferCreateInfoBuilder<'a> {
    inner: FramebufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFramebufferCreateInfo {}
impl<'a> ::std::ops::Deref for FramebufferCreateInfoBuilder<'a> {
    type Target = FramebufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FramebufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FramebufferCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: FramebufferCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn render_pass(mut self, render_pass: RenderPass) -> Self {
        self.inner.render_pass = render_pass;
        self
    }
    #[inline]
    pub fn attachment_count(mut self, attachment_count: u32) -> Self {
        self.inner.attachment_count = attachment_count;
        self
    }
    #[inline]
    pub fn attachments(mut self, attachments: &'a [ImageView]) -> Self {
        self.inner.attachment_count = attachments.len() as _;
        self.inner.p_attachments = attachments.as_ptr();
        self
    }
    #[inline]
    pub fn width(mut self, width: u32) -> Self {
        self.inner.width = width;
        self
    }
    #[inline]
    pub fn height(mut self, height: u32) -> Self {
        self.inner.height = height;
        self
    }
    #[inline]
    pub fn layers(mut self, layers: u32) -> Self {
        self.inner.layers = layers;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFramebufferCreateInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FramebufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDrawIndirectCommand.html>"]
pub struct DrawIndirectCommand {
    pub vertex_count: u32,
    pub instance_count: u32,
    pub first_vertex: u32,
    pub first_instance: u32,
}
impl DrawIndirectCommand {
    pub fn builder<'a>() -> DrawIndirectCommandBuilder<'a> {
        DrawIndirectCommandBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DrawIndirectCommandBuilder<'a> {
    inner: DrawIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DrawIndirectCommandBuilder<'a> {
    type Target = DrawIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DrawIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DrawIndirectCommandBuilder<'a> {
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.inner.vertex_count = vertex_count;
        self
    }
    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.inner.instance_count = instance_count;
        self
    }
    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.inner.first_vertex = first_vertex;
        self
    }
    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.inner.first_instance = first_instance;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DrawIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDrawIndexedIndirectCommand.html>"]
pub struct DrawIndexedIndirectCommand {
    pub index_count: u32,
    pub instance_count: u32,
    pub first_index: u32,
    pub vertex_offset: i32,
    pub first_instance: u32,
}
impl DrawIndexedIndirectCommand {
    pub fn builder<'a>() -> DrawIndexedIndirectCommandBuilder<'a> {
        DrawIndexedIndirectCommandBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DrawIndexedIndirectCommandBuilder<'a> {
    inner: DrawIndexedIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DrawIndexedIndirectCommandBuilder<'a> {
    type Target = DrawIndexedIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DrawIndexedIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DrawIndexedIndirectCommandBuilder<'a> {
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.inner.index_count = index_count;
        self
    }
    #[inline]
    pub fn instance_count(mut self, instance_count: u32) -> Self {
        self.inner.instance_count = instance_count;
        self
    }
    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.inner.first_index = first_index;
        self
    }
    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.inner.vertex_offset = vertex_offset;
        self
    }
    #[inline]
    pub fn first_instance(mut self, first_instance: u32) -> Self {
        self.inner.first_instance = first_instance;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DrawIndexedIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDispatchIndirectCommand.html>"]
pub struct DispatchIndirectCommand {
    pub x: u32,
    pub y: u32,
    pub z: u32,
}
impl DispatchIndirectCommand {
    pub fn builder<'a>() -> DispatchIndirectCommandBuilder<'a> {
        DispatchIndirectCommandBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DispatchIndirectCommandBuilder<'a> {
    inner: DispatchIndirectCommand,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DispatchIndirectCommandBuilder<'a> {
    type Target = DispatchIndirectCommand;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DispatchIndirectCommandBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DispatchIndirectCommandBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: u32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: u32) -> Self {
        self.inner.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: u32) -> Self {
        self.inner.z = z;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DispatchIndirectCommand {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMultiDrawInfoEXT.html>"]
pub struct MultiDrawInfoEXT {
    pub first_vertex: u32,
    pub vertex_count: u32,
}
impl MultiDrawInfoEXT {
    pub fn builder<'a>() -> MultiDrawInfoEXTBuilder<'a> {
        MultiDrawInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MultiDrawInfoEXTBuilder<'a> {
    inner: MultiDrawInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MultiDrawInfoEXTBuilder<'a> {
    type Target = MultiDrawInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MultiDrawInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MultiDrawInfoEXTBuilder<'a> {
    #[inline]
    pub fn first_vertex(mut self, first_vertex: u32) -> Self {
        self.inner.first_vertex = first_vertex;
        self
    }
    #[inline]
    pub fn vertex_count(mut self, vertex_count: u32) -> Self {
        self.inner.vertex_count = vertex_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MultiDrawInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMultiDrawIndexedInfoEXT.html>"]
pub struct MultiDrawIndexedInfoEXT {
    pub first_index: u32,
    pub index_count: u32,
    pub vertex_offset: i32,
}
impl MultiDrawIndexedInfoEXT {
    pub fn builder<'a>() -> MultiDrawIndexedInfoEXTBuilder<'a> {
        MultiDrawIndexedInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MultiDrawIndexedInfoEXTBuilder<'a> {
    inner: MultiDrawIndexedInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MultiDrawIndexedInfoEXTBuilder<'a> {
    type Target = MultiDrawIndexedInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MultiDrawIndexedInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MultiDrawIndexedInfoEXTBuilder<'a> {
    #[inline]
    pub fn first_index(mut self, first_index: u32) -> Self {
        self.inner.first_index = first_index;
        self
    }
    #[inline]
    pub fn index_count(mut self, index_count: u32) -> Self {
        self.inner.index_count = index_count;
        self
    }
    #[inline]
    pub fn vertex_offset(mut self, vertex_offset: i32) -> Self {
        self.inner.vertex_offset = vertex_offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MultiDrawIndexedInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSubmitInfo.html>"]
pub struct SubmitInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub p_wait_dst_stage_mask: *const PipelineStageFlags,
    pub command_buffer_count: u32,
    pub p_command_buffers: *const CommandBuffer,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphores: *const Semaphore,
}
impl ::std::default::Default for SubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            p_wait_dst_stage_mask: ::std::ptr::null(),
            command_buffer_count: u32::default(),
            p_command_buffers: ::std::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphores: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for SubmitInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SUBMIT_INFO;
}
impl SubmitInfo {
    pub fn builder<'a>() -> SubmitInfoBuilder<'a> {
        SubmitInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubmitInfoBuilder<'a> {
    inner: SubmitInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSubmitInfo {}
impl<'a> ::std::ops::Deref for SubmitInfoBuilder<'a> {
    type Target = SubmitInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubmitInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubmitInfoBuilder<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn wait_dst_stage_mask(mut self, wait_dst_stage_mask: &'a [PipelineStageFlags]) -> Self {
        self.inner.wait_semaphore_count = wait_dst_stage_mask.len() as _;
        self.inner.p_wait_dst_stage_mask = wait_dst_stage_mask.as_ptr();
        self
    }
    #[inline]
    pub fn command_buffers(mut self, command_buffers: &'a [CommandBuffer]) -> Self {
        self.inner.command_buffer_count = command_buffers.len() as _;
        self.inner.p_command_buffers = command_buffers.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphores(mut self, signal_semaphores: &'a [Semaphore]) -> Self {
        self.inner.signal_semaphore_count = signal_semaphores.len() as _;
        self.inner.p_signal_semaphores = signal_semaphores.as_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSubmitInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubmitInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPropertiesKHR.html>"]
pub struct DisplayPropertiesKHR {
    pub display: DisplayKHR,
    pub display_name: *const c_char,
    pub physical_dimensions: Extent2D,
    pub physical_resolution: Extent2D,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub plane_reorder_possible: Bool32,
    pub persistent_content: Bool32,
}
impl ::std::default::Default for DisplayPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            display: DisplayKHR::default(),
            display_name: ::std::ptr::null(),
            physical_dimensions: Extent2D::default(),
            physical_resolution: Extent2D::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            plane_reorder_possible: Bool32::default(),
            persistent_content: Bool32::default(),
        }
    }
}
impl DisplayPropertiesKHR {
    pub fn builder<'a>() -> DisplayPropertiesKHRBuilder<'a> {
        DisplayPropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPropertiesKHRBuilder<'a> {
    inner: DisplayPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPropertiesKHRBuilder<'a> {
    type Target = DisplayPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPropertiesKHRBuilder<'a> {
    #[inline]
    pub fn display(mut self, display: DisplayKHR) -> Self {
        self.inner.display = display;
        self
    }
    #[inline]
    pub fn display_name(mut self, display_name: &'a ::std::ffi::CStr) -> Self {
        self.inner.display_name = display_name.as_ptr();
        self
    }
    #[inline]
    pub fn physical_dimensions(mut self, physical_dimensions: Extent2D) -> Self {
        self.inner.physical_dimensions = physical_dimensions;
        self
    }
    #[inline]
    pub fn physical_resolution(mut self, physical_resolution: Extent2D) -> Self {
        self.inner.physical_resolution = physical_resolution;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.inner.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn plane_reorder_possible(mut self, plane_reorder_possible: bool) -> Self {
        self.inner.plane_reorder_possible = plane_reorder_possible.into();
        self
    }
    #[inline]
    pub fn persistent_content(mut self, persistent_content: bool) -> Self {
        self.inner.persistent_content = persistent_content.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPlanePropertiesKHR.html>"]
pub struct DisplayPlanePropertiesKHR {
    pub current_display: DisplayKHR,
    pub current_stack_index: u32,
}
impl DisplayPlanePropertiesKHR {
    pub fn builder<'a>() -> DisplayPlanePropertiesKHRBuilder<'a> {
        DisplayPlanePropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlanePropertiesKHRBuilder<'a> {
    inner: DisplayPlanePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlanePropertiesKHRBuilder<'a> {
    type Target = DisplayPlanePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlanePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlanePropertiesKHRBuilder<'a> {
    #[inline]
    pub fn current_display(mut self, current_display: DisplayKHR) -> Self {
        self.inner.current_display = current_display;
        self
    }
    #[inline]
    pub fn current_stack_index(mut self, current_stack_index: u32) -> Self {
        self.inner.current_stack_index = current_stack_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlanePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModeParametersKHR.html>"]
pub struct DisplayModeParametersKHR {
    pub visible_region: Extent2D,
    pub refresh_rate: u32,
}
impl DisplayModeParametersKHR {
    pub fn builder<'a>() -> DisplayModeParametersKHRBuilder<'a> {
        DisplayModeParametersKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModeParametersKHRBuilder<'a> {
    inner: DisplayModeParametersKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModeParametersKHRBuilder<'a> {
    type Target = DisplayModeParametersKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModeParametersKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModeParametersKHRBuilder<'a> {
    #[inline]
    pub fn visible_region(mut self, visible_region: Extent2D) -> Self {
        self.inner.visible_region = visible_region;
        self
    }
    #[inline]
    pub fn refresh_rate(mut self, refresh_rate: u32) -> Self {
        self.inner.refresh_rate = refresh_rate;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModeParametersKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModePropertiesKHR.html>"]
pub struct DisplayModePropertiesKHR {
    pub display_mode: DisplayModeKHR,
    pub parameters: DisplayModeParametersKHR,
}
impl DisplayModePropertiesKHR {
    pub fn builder<'a>() -> DisplayModePropertiesKHRBuilder<'a> {
        DisplayModePropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModePropertiesKHRBuilder<'a> {
    inner: DisplayModePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModePropertiesKHRBuilder<'a> {
    type Target = DisplayModePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModePropertiesKHRBuilder<'a> {
    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.inner.display_mode = display_mode;
        self
    }
    #[inline]
    pub fn parameters(mut self, parameters: DisplayModeParametersKHR) -> Self {
        self.inner.parameters = parameters;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModeCreateInfoKHR.html>"]
pub struct DisplayModeCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplayModeCreateFlagsKHR,
    pub parameters: DisplayModeParametersKHR,
}
impl ::std::default::Default for DisplayModeCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DisplayModeCreateFlagsKHR::default(),
            parameters: DisplayModeParametersKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayModeCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_MODE_CREATE_INFO_KHR;
}
impl DisplayModeCreateInfoKHR {
    pub fn builder<'a>() -> DisplayModeCreateInfoKHRBuilder<'a> {
        DisplayModeCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModeCreateInfoKHRBuilder<'a> {
    inner: DisplayModeCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModeCreateInfoKHRBuilder<'a> {
    type Target = DisplayModeCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModeCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModeCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DisplayModeCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn parameters(mut self, parameters: DisplayModeParametersKHR) -> Self {
        self.inner.parameters = parameters;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModeCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneCapabilitiesKHR.html>"]
pub struct DisplayPlaneCapabilitiesKHR {
    pub supported_alpha: DisplayPlaneAlphaFlagsKHR,
    pub min_src_position: Offset2D,
    pub max_src_position: Offset2D,
    pub min_src_extent: Extent2D,
    pub max_src_extent: Extent2D,
    pub min_dst_position: Offset2D,
    pub max_dst_position: Offset2D,
    pub min_dst_extent: Extent2D,
    pub max_dst_extent: Extent2D,
}
impl DisplayPlaneCapabilitiesKHR {
    pub fn builder<'a>() -> DisplayPlaneCapabilitiesKHRBuilder<'a> {
        DisplayPlaneCapabilitiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlaneCapabilitiesKHRBuilder<'a> {
    inner: DisplayPlaneCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlaneCapabilitiesKHRBuilder<'a> {
    type Target = DisplayPlaneCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlaneCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlaneCapabilitiesKHRBuilder<'a> {
    #[inline]
    pub fn supported_alpha(mut self, supported_alpha: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.inner.supported_alpha = supported_alpha;
        self
    }
    #[inline]
    pub fn min_src_position(mut self, min_src_position: Offset2D) -> Self {
        self.inner.min_src_position = min_src_position;
        self
    }
    #[inline]
    pub fn max_src_position(mut self, max_src_position: Offset2D) -> Self {
        self.inner.max_src_position = max_src_position;
        self
    }
    #[inline]
    pub fn min_src_extent(mut self, min_src_extent: Extent2D) -> Self {
        self.inner.min_src_extent = min_src_extent;
        self
    }
    #[inline]
    pub fn max_src_extent(mut self, max_src_extent: Extent2D) -> Self {
        self.inner.max_src_extent = max_src_extent;
        self
    }
    #[inline]
    pub fn min_dst_position(mut self, min_dst_position: Offset2D) -> Self {
        self.inner.min_dst_position = min_dst_position;
        self
    }
    #[inline]
    pub fn max_dst_position(mut self, max_dst_position: Offset2D) -> Self {
        self.inner.max_dst_position = max_dst_position;
        self
    }
    #[inline]
    pub fn min_dst_extent(mut self, min_dst_extent: Extent2D) -> Self {
        self.inner.min_dst_extent = min_dst_extent;
        self
    }
    #[inline]
    pub fn max_dst_extent(mut self, max_dst_extent: Extent2D) -> Self {
        self.inner.max_dst_extent = max_dst_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlaneCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplaySurfaceCreateInfoKHR.html>"]
pub struct DisplaySurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DisplaySurfaceCreateFlagsKHR,
    pub display_mode: DisplayModeKHR,
    pub plane_index: u32,
    pub plane_stack_index: u32,
    pub transform: SurfaceTransformFlagsKHR,
    pub global_alpha: f32,
    pub alpha_mode: DisplayPlaneAlphaFlagsKHR,
    pub image_extent: Extent2D,
}
impl ::std::default::Default for DisplaySurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DisplaySurfaceCreateFlagsKHR::default(),
            display_mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
            plane_stack_index: u32::default(),
            transform: SurfaceTransformFlagsKHR::default(),
            global_alpha: f32::default(),
            alpha_mode: DisplayPlaneAlphaFlagsKHR::default(),
            image_extent: Extent2D::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplaySurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_SURFACE_CREATE_INFO_KHR;
}
impl DisplaySurfaceCreateInfoKHR {
    pub fn builder<'a>() -> DisplaySurfaceCreateInfoKHRBuilder<'a> {
        DisplaySurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplaySurfaceCreateInfoKHRBuilder<'a> {
    inner: DisplaySurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplaySurfaceCreateInfoKHRBuilder<'a> {
    type Target = DisplaySurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplaySurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplaySurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DisplaySurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn display_mode(mut self, display_mode: DisplayModeKHR) -> Self {
        self.inner.display_mode = display_mode;
        self
    }
    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.inner.plane_index = plane_index;
        self
    }
    #[inline]
    pub fn plane_stack_index(mut self, plane_stack_index: u32) -> Self {
        self.inner.plane_stack_index = plane_stack_index;
        self
    }
    #[inline]
    pub fn transform(mut self, transform: SurfaceTransformFlagsKHR) -> Self {
        self.inner.transform = transform;
        self
    }
    #[inline]
    pub fn global_alpha(mut self, global_alpha: f32) -> Self {
        self.inner.global_alpha = global_alpha;
        self
    }
    #[inline]
    pub fn alpha_mode(mut self, alpha_mode: DisplayPlaneAlphaFlagsKHR) -> Self {
        self.inner.alpha_mode = alpha_mode;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent2D) -> Self {
        self.inner.image_extent = image_extent;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplaySurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPresentInfoKHR.html>"]
pub struct DisplayPresentInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_rect: Rect2D,
    pub dst_rect: Rect2D,
    pub persistent: Bool32,
}
impl ::std::default::Default for DisplayPresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_rect: Rect2D::default(),
            dst_rect: Rect2D::default(),
            persistent: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayPresentInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PRESENT_INFO_KHR;
}
impl DisplayPresentInfoKHR {
    pub fn builder<'a>() -> DisplayPresentInfoKHRBuilder<'a> {
        DisplayPresentInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPresentInfoKHRBuilder<'a> {
    inner: DisplayPresentInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for DisplayPresentInfoKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for DisplayPresentInfoKHR {}
impl<'a> ::std::ops::Deref for DisplayPresentInfoKHRBuilder<'a> {
    type Target = DisplayPresentInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPresentInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPresentInfoKHRBuilder<'a> {
    #[inline]
    pub fn src_rect(mut self, src_rect: Rect2D) -> Self {
        self.inner.src_rect = src_rect;
        self
    }
    #[inline]
    pub fn dst_rect(mut self, dst_rect: Rect2D) -> Self {
        self.inner.dst_rect = dst_rect;
        self
    }
    #[inline]
    pub fn persistent(mut self, persistent: bool) -> Self {
        self.inner.persistent = persistent.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPresentInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilitiesKHR.html>"]
pub struct SurfaceCapabilitiesKHR {
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
}
impl SurfaceCapabilitiesKHR {
    pub fn builder<'a>() -> SurfaceCapabilitiesKHRBuilder<'a> {
        SurfaceCapabilitiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceCapabilitiesKHRBuilder<'a> {
    inner: SurfaceCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SurfaceCapabilitiesKHRBuilder<'a> {
    type Target = SurfaceCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceCapabilitiesKHRBuilder<'a> {
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.inner.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn max_image_count(mut self, max_image_count: u32) -> Self {
        self.inner.max_image_count = max_image_count;
        self
    }
    #[inline]
    pub fn current_extent(mut self, current_extent: Extent2D) -> Self {
        self.inner.current_extent = current_extent;
        self
    }
    #[inline]
    pub fn min_image_extent(mut self, min_image_extent: Extent2D) -> Self {
        self.inner.min_image_extent = min_image_extent;
        self
    }
    #[inline]
    pub fn max_image_extent(mut self, max_image_extent: Extent2D) -> Self {
        self.inner.max_image_extent = max_image_extent;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.inner.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.inner.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn current_transform(mut self, current_transform: SurfaceTransformFlagsKHR) -> Self {
        self.inner.current_transform = current_transform;
        self
    }
    #[inline]
    pub fn supported_composite_alpha(
        mut self,
        supported_composite_alpha: CompositeAlphaFlagsKHR,
    ) -> Self {
        self.inner.supported_composite_alpha = supported_composite_alpha;
        self
    }
    #[inline]
    pub fn supported_usage_flags(mut self, supported_usage_flags: ImageUsageFlags) -> Self {
        self.inner.supported_usage_flags = supported_usage_flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAndroidSurfaceCreateInfoKHR.html>"]
pub struct AndroidSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: AndroidSurfaceCreateFlagsKHR,
    pub window: *mut ANativeWindow,
}
impl ::std::default::Default for AndroidSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: AndroidSurfaceCreateFlagsKHR::default(),
            window: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for AndroidSurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::ANDROID_SURFACE_CREATE_INFO_KHR;
}
impl AndroidSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> AndroidSurfaceCreateInfoKHRBuilder<'a> {
        AndroidSurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AndroidSurfaceCreateInfoKHRBuilder<'a> {
    inner: AndroidSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AndroidSurfaceCreateInfoKHRBuilder<'a> {
    type Target = AndroidSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AndroidSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AndroidSurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: AndroidSurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn window(mut self, window: *mut ANativeWindow) -> Self {
        self.inner.window = window;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AndroidSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkViSurfaceCreateInfoNN.html>"]
pub struct ViSurfaceCreateInfoNN {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ViSurfaceCreateFlagsNN,
    pub window: *mut c_void,
}
impl ::std::default::Default for ViSurfaceCreateInfoNN {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ViSurfaceCreateFlagsNN::default(),
            window: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for ViSurfaceCreateInfoNN {
    const STRUCTURE_TYPE: StructureType = StructureType::VI_SURFACE_CREATE_INFO_NN;
}
impl ViSurfaceCreateInfoNN {
    pub fn builder<'a>() -> ViSurfaceCreateInfoNNBuilder<'a> {
        ViSurfaceCreateInfoNNBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViSurfaceCreateInfoNNBuilder<'a> {
    inner: ViSurfaceCreateInfoNN,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ViSurfaceCreateInfoNNBuilder<'a> {
    type Target = ViSurfaceCreateInfoNN;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViSurfaceCreateInfoNNBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViSurfaceCreateInfoNNBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ViSurfaceCreateFlagsNN) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn window(mut self, window: *mut c_void) -> Self {
        self.inner.window = window;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ViSurfaceCreateInfoNN {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWaylandSurfaceCreateInfoKHR.html>"]
pub struct WaylandSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: WaylandSurfaceCreateFlagsKHR,
    pub display: *mut wl_display,
    pub surface: *mut wl_surface,
}
impl ::std::default::Default for WaylandSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: WaylandSurfaceCreateFlagsKHR::default(),
            display: ::std::ptr::null_mut(),
            surface: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for WaylandSurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::WAYLAND_SURFACE_CREATE_INFO_KHR;
}
impl WaylandSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> WaylandSurfaceCreateInfoKHRBuilder<'a> {
        WaylandSurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct WaylandSurfaceCreateInfoKHRBuilder<'a> {
    inner: WaylandSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for WaylandSurfaceCreateInfoKHRBuilder<'a> {
    type Target = WaylandSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for WaylandSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> WaylandSurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: WaylandSurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn display(mut self, display: *mut wl_display) -> Self {
        self.inner.display = display;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: *mut wl_surface) -> Self {
        self.inner.surface = surface;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> WaylandSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWin32SurfaceCreateInfoKHR.html>"]
pub struct Win32SurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: Win32SurfaceCreateFlagsKHR,
    pub hinstance: HINSTANCE,
    pub hwnd: HWND,
}
impl ::std::default::Default for Win32SurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: Win32SurfaceCreateFlagsKHR::default(),
            hinstance: unsafe { ::std::mem::zeroed() },
            hwnd: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for Win32SurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_SURFACE_CREATE_INFO_KHR;
}
impl Win32SurfaceCreateInfoKHR {
    pub fn builder<'a>() -> Win32SurfaceCreateInfoKHRBuilder<'a> {
        Win32SurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32SurfaceCreateInfoKHRBuilder<'a> {
    inner: Win32SurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for Win32SurfaceCreateInfoKHRBuilder<'a> {
    type Target = Win32SurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32SurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32SurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: Win32SurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn hinstance(mut self, hinstance: HINSTANCE) -> Self {
        self.inner.hinstance = hinstance;
        self
    }
    #[inline]
    pub fn hwnd(mut self, hwnd: HWND) -> Self {
        self.inner.hwnd = hwnd;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32SurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkXlibSurfaceCreateInfoKHR.html>"]
pub struct XlibSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XlibSurfaceCreateFlagsKHR,
    pub dpy: *mut Display,
    pub window: Window,
}
impl ::std::default::Default for XlibSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: XlibSurfaceCreateFlagsKHR::default(),
            dpy: ::std::ptr::null_mut(),
            window: Window::default(),
        }
    }
}
unsafe impl TaggedStructure for XlibSurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::XLIB_SURFACE_CREATE_INFO_KHR;
}
impl XlibSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> XlibSurfaceCreateInfoKHRBuilder<'a> {
        XlibSurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct XlibSurfaceCreateInfoKHRBuilder<'a> {
    inner: XlibSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for XlibSurfaceCreateInfoKHRBuilder<'a> {
    type Target = XlibSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for XlibSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> XlibSurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: XlibSurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn dpy(mut self, dpy: *mut Display) -> Self {
        self.inner.dpy = dpy;
        self
    }
    #[inline]
    pub fn window(mut self, window: Window) -> Self {
        self.inner.window = window;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> XlibSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkXcbSurfaceCreateInfoKHR.html>"]
pub struct XcbSurfaceCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: XcbSurfaceCreateFlagsKHR,
    pub connection: *mut xcb_connection_t,
    pub window: xcb_window_t,
}
impl ::std::default::Default for XcbSurfaceCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: XcbSurfaceCreateFlagsKHR::default(),
            connection: ::std::ptr::null_mut(),
            window: xcb_window_t::default(),
        }
    }
}
unsafe impl TaggedStructure for XcbSurfaceCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::XCB_SURFACE_CREATE_INFO_KHR;
}
impl XcbSurfaceCreateInfoKHR {
    pub fn builder<'a>() -> XcbSurfaceCreateInfoKHRBuilder<'a> {
        XcbSurfaceCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct XcbSurfaceCreateInfoKHRBuilder<'a> {
    inner: XcbSurfaceCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for XcbSurfaceCreateInfoKHRBuilder<'a> {
    type Target = XcbSurfaceCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for XcbSurfaceCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> XcbSurfaceCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: XcbSurfaceCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn connection(mut self, connection: *mut xcb_connection_t) -> Self {
        self.inner.connection = connection;
        self
    }
    #[inline]
    pub fn window(mut self, window: xcb_window_t) -> Self {
        self.inner.window = window;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> XcbSurfaceCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDirectFBSurfaceCreateInfoEXT.html>"]
pub struct DirectFBSurfaceCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DirectFBSurfaceCreateFlagsEXT,
    pub dfb: *mut IDirectFB,
    pub surface: *mut IDirectFBSurface,
}
impl ::std::default::Default for DirectFBSurfaceCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DirectFBSurfaceCreateFlagsEXT::default(),
            dfb: ::std::ptr::null_mut(),
            surface: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for DirectFBSurfaceCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DIRECTFB_SURFACE_CREATE_INFO_EXT;
}
impl DirectFBSurfaceCreateInfoEXT {
    pub fn builder<'a>() -> DirectFBSurfaceCreateInfoEXTBuilder<'a> {
        DirectFBSurfaceCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DirectFBSurfaceCreateInfoEXTBuilder<'a> {
    inner: DirectFBSurfaceCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DirectFBSurfaceCreateInfoEXTBuilder<'a> {
    type Target = DirectFBSurfaceCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DirectFBSurfaceCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DirectFBSurfaceCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DirectFBSurfaceCreateFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn dfb(mut self, dfb: *mut IDirectFB) -> Self {
        self.inner.dfb = dfb;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: *mut IDirectFBSurface) -> Self {
        self.inner.surface = surface;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DirectFBSurfaceCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImagePipeSurfaceCreateInfoFUCHSIA.html>"]
pub struct ImagePipeSurfaceCreateInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ImagePipeSurfaceCreateFlagsFUCHSIA,
    pub image_pipe_handle: zx_handle_t,
}
impl ::std::default::Default for ImagePipeSurfaceCreateInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ImagePipeSurfaceCreateFlagsFUCHSIA::default(),
            image_pipe_handle: zx_handle_t::default(),
        }
    }
}
unsafe impl TaggedStructure for ImagePipeSurfaceCreateInfoFUCHSIA {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGEPIPE_SURFACE_CREATE_INFO_FUCHSIA;
}
impl ImagePipeSurfaceCreateInfoFUCHSIA {
    pub fn builder<'a>() -> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
        ImagePipeSurfaceCreateInfoFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    inner: ImagePipeSurfaceCreateInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    type Target = ImagePipeSurfaceCreateInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImagePipeSurfaceCreateInfoFUCHSIABuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ImagePipeSurfaceCreateFlagsFUCHSIA) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn image_pipe_handle(mut self, image_pipe_handle: zx_handle_t) -> Self {
        self.inner.image_pipe_handle = image_pipe_handle;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImagePipeSurfaceCreateInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkStreamDescriptorSurfaceCreateInfoGGP.html>"]
pub struct StreamDescriptorSurfaceCreateInfoGGP {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: StreamDescriptorSurfaceCreateFlagsGGP,
    pub stream_descriptor: GgpStreamDescriptor,
}
impl ::std::default::Default for StreamDescriptorSurfaceCreateInfoGGP {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: StreamDescriptorSurfaceCreateFlagsGGP::default(),
            stream_descriptor: GgpStreamDescriptor::default(),
        }
    }
}
unsafe impl TaggedStructure for StreamDescriptorSurfaceCreateInfoGGP {
    const STRUCTURE_TYPE: StructureType = StructureType::STREAM_DESCRIPTOR_SURFACE_CREATE_INFO_GGP;
}
impl StreamDescriptorSurfaceCreateInfoGGP {
    pub fn builder<'a>() -> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
        StreamDescriptorSurfaceCreateInfoGGPBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    inner: StreamDescriptorSurfaceCreateInfoGGP,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    type Target = StreamDescriptorSurfaceCreateInfoGGP;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> StreamDescriptorSurfaceCreateInfoGGPBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: StreamDescriptorSurfaceCreateFlagsGGP) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn stream_descriptor(mut self, stream_descriptor: GgpStreamDescriptor) -> Self {
        self.inner.stream_descriptor = stream_descriptor;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> StreamDescriptorSurfaceCreateInfoGGP {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkScreenSurfaceCreateInfoQNX.html>"]
pub struct ScreenSurfaceCreateInfoQNX {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ScreenSurfaceCreateFlagsQNX,
    pub context: *mut _screen_context,
    pub window: *mut _screen_window,
}
impl ::std::default::Default for ScreenSurfaceCreateInfoQNX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ScreenSurfaceCreateFlagsQNX::default(),
            context: ::std::ptr::null_mut(),
            window: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for ScreenSurfaceCreateInfoQNX {
    const STRUCTURE_TYPE: StructureType = StructureType::SCREEN_SURFACE_CREATE_INFO_QNX;
}
impl ScreenSurfaceCreateInfoQNX {
    pub fn builder<'a>() -> ScreenSurfaceCreateInfoQNXBuilder<'a> {
        ScreenSurfaceCreateInfoQNXBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ScreenSurfaceCreateInfoQNXBuilder<'a> {
    inner: ScreenSurfaceCreateInfoQNX,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ScreenSurfaceCreateInfoQNXBuilder<'a> {
    type Target = ScreenSurfaceCreateInfoQNX;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ScreenSurfaceCreateInfoQNXBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ScreenSurfaceCreateInfoQNXBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ScreenSurfaceCreateFlagsQNX) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn context(mut self, context: &'a mut _screen_context) -> Self {
        self.inner.context = context;
        self
    }
    #[inline]
    pub fn window(mut self, window: &'a mut _screen_window) -> Self {
        self.inner.window = window;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ScreenSurfaceCreateInfoQNX {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default, PartialEq, Eq, Hash)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceFormatKHR.html>"]
pub struct SurfaceFormatKHR {
    pub format: Format,
    pub color_space: ColorSpaceKHR,
}
impl SurfaceFormatKHR {
    pub fn builder<'a>() -> SurfaceFormatKHRBuilder<'a> {
        SurfaceFormatKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceFormatKHRBuilder<'a> {
    inner: SurfaceFormatKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SurfaceFormatKHRBuilder<'a> {
    type Target = SurfaceFormatKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceFormatKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceFormatKHRBuilder<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn color_space(mut self, color_space: ColorSpaceKHR) -> Self {
        self.inner.color_space = color_space;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceFormatKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSwapchainCreateInfoKHR.html>"]
pub struct SwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: SwapchainCreateFlagsKHR,
    pub surface: SurfaceKHR,
    pub min_image_count: u32,
    pub image_format: Format,
    pub image_color_space: ColorSpaceKHR,
    pub image_extent: Extent2D,
    pub image_array_layers: u32,
    pub image_usage: ImageUsageFlags,
    pub image_sharing_mode: SharingMode,
    pub queue_family_index_count: u32,
    pub p_queue_family_indices: *const u32,
    pub pre_transform: SurfaceTransformFlagsKHR,
    pub composite_alpha: CompositeAlphaFlagsKHR,
    pub present_mode: PresentModeKHR,
    pub clipped: Bool32,
    pub old_swapchain: SwapchainKHR,
}
impl ::std::default::Default for SwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: SwapchainCreateFlagsKHR::default(),
            surface: SurfaceKHR::default(),
            min_image_count: u32::default(),
            image_format: Format::default(),
            image_color_space: ColorSpaceKHR::default(),
            image_extent: Extent2D::default(),
            image_array_layers: u32::default(),
            image_usage: ImageUsageFlags::default(),
            image_sharing_mode: SharingMode::default(),
            queue_family_index_count: u32::default(),
            p_queue_family_indices: ::std::ptr::null(),
            pre_transform: SurfaceTransformFlagsKHR::default(),
            composite_alpha: CompositeAlphaFlagsKHR::default(),
            present_mode: PresentModeKHR::default(),
            clipped: Bool32::default(),
            old_swapchain: SwapchainKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for SwapchainCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SWAPCHAIN_CREATE_INFO_KHR;
}
impl SwapchainCreateInfoKHR {
    pub fn builder<'a>() -> SwapchainCreateInfoKHRBuilder<'a> {
        SwapchainCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SwapchainCreateInfoKHRBuilder<'a> {
    inner: SwapchainCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSwapchainCreateInfoKHR {}
impl<'a> ::std::ops::Deref for SwapchainCreateInfoKHRBuilder<'a> {
    type Target = SwapchainCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SwapchainCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SwapchainCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: SwapchainCreateFlagsKHR) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn surface(mut self, surface: SurfaceKHR) -> Self {
        self.inner.surface = surface;
        self
    }
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.inner.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn image_format(mut self, image_format: Format) -> Self {
        self.inner.image_format = image_format;
        self
    }
    #[inline]
    pub fn image_color_space(mut self, image_color_space: ColorSpaceKHR) -> Self {
        self.inner.image_color_space = image_color_space;
        self
    }
    #[inline]
    pub fn image_extent(mut self, image_extent: Extent2D) -> Self {
        self.inner.image_extent = image_extent;
        self
    }
    #[inline]
    pub fn image_array_layers(mut self, image_array_layers: u32) -> Self {
        self.inner.image_array_layers = image_array_layers;
        self
    }
    #[inline]
    pub fn image_usage(mut self, image_usage: ImageUsageFlags) -> Self {
        self.inner.image_usage = image_usage;
        self
    }
    #[inline]
    pub fn image_sharing_mode(mut self, image_sharing_mode: SharingMode) -> Self {
        self.inner.image_sharing_mode = image_sharing_mode;
        self
    }
    #[inline]
    pub fn queue_family_indices(mut self, queue_family_indices: &'a [u32]) -> Self {
        self.inner.queue_family_index_count = queue_family_indices.len() as _;
        self.inner.p_queue_family_indices = queue_family_indices.as_ptr();
        self
    }
    #[inline]
    pub fn pre_transform(mut self, pre_transform: SurfaceTransformFlagsKHR) -> Self {
        self.inner.pre_transform = pre_transform;
        self
    }
    #[inline]
    pub fn composite_alpha(mut self, composite_alpha: CompositeAlphaFlagsKHR) -> Self {
        self.inner.composite_alpha = composite_alpha;
        self
    }
    #[inline]
    pub fn present_mode(mut self, present_mode: PresentModeKHR) -> Self {
        self.inner.present_mode = present_mode;
        self
    }
    #[inline]
    pub fn clipped(mut self, clipped: bool) -> Self {
        self.inner.clipped = clipped.into();
        self
    }
    #[inline]
    pub fn old_swapchain(mut self, old_swapchain: SwapchainKHR) -> Self {
        self.inner.old_swapchain = old_swapchain;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSwapchainCreateInfoKHR>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SwapchainCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentInfoKHR.html>"]
pub struct PresentInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphores: *const Semaphore,
    pub swapchain_count: u32,
    pub p_swapchains: *const SwapchainKHR,
    pub p_image_indices: *const u32,
    pub p_results: *mut Result,
}
impl ::std::default::Default for PresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphores: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_swapchains: ::std::ptr::null(),
            p_image_indices: ::std::ptr::null(),
            p_results: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for PresentInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_INFO_KHR;
}
impl PresentInfoKHR {
    pub fn builder<'a>() -> PresentInfoKHRBuilder<'a> {
        PresentInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentInfoKHRBuilder<'a> {
    inner: PresentInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPresentInfoKHR {}
impl<'a> ::std::ops::Deref for PresentInfoKHRBuilder<'a> {
    type Target = PresentInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentInfoKHRBuilder<'a> {
    #[inline]
    pub fn wait_semaphores(mut self, wait_semaphores: &'a [Semaphore]) -> Self {
        self.inner.wait_semaphore_count = wait_semaphores.len() as _;
        self.inner.p_wait_semaphores = wait_semaphores.as_ptr();
        self
    }
    #[inline]
    pub fn swapchains(mut self, swapchains: &'a [SwapchainKHR]) -> Self {
        self.inner.swapchain_count = swapchains.len() as _;
        self.inner.p_swapchains = swapchains.as_ptr();
        self
    }
    #[inline]
    pub fn image_indices(mut self, image_indices: &'a [u32]) -> Self {
        self.inner.swapchain_count = image_indices.len() as _;
        self.inner.p_image_indices = image_indices.as_ptr();
        self
    }
    #[inline]
    pub fn results(mut self, results: &'a mut [Result]) -> Self {
        self.inner.swapchain_count = results.len() as _;
        self.inner.p_results = results.as_mut_ptr();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPresentInfoKHR>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugReportCallbackCreateInfoEXT.html>"]
pub struct DebugReportCallbackCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DebugReportFlagsEXT,
    pub pfn_callback: PFN_vkDebugReportCallbackEXT,
    pub p_user_data: *mut c_void,
}
#[cfg(feature = "debug")]
impl fmt::Debug for DebugReportCallbackCreateInfoEXT {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("DebugReportCallbackCreateInfoEXT")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("flags", &self.flags)
            .field("pfn_callback", &(self.pfn_callback.map(|x| x as *const ())))
            .field("p_user_data", &self.p_user_data)
            .finish()
    }
}
impl ::std::default::Default for DebugReportCallbackCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DebugReportFlagsEXT::default(),
            pfn_callback: PFN_vkDebugReportCallbackEXT::default(),
            p_user_data: ::std::ptr::null_mut(),
        }
    }
}
unsafe impl TaggedStructure for DebugReportCallbackCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT;
}
impl DebugReportCallbackCreateInfoEXT {
    pub fn builder<'a>() -> DebugReportCallbackCreateInfoEXTBuilder<'a> {
        DebugReportCallbackCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugReportCallbackCreateInfoEXTBuilder<'a> {
    inner: DebugReportCallbackCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for DebugReportCallbackCreateInfoEXT {}
impl<'a> ::std::ops::Deref for DebugReportCallbackCreateInfoEXTBuilder<'a> {
    type Target = DebugReportCallbackCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugReportCallbackCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugReportCallbackCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DebugReportFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn pfn_callback(mut self, pfn_callback: PFN_vkDebugReportCallbackEXT) -> Self {
        self.inner.pfn_callback = pfn_callback;
        self
    }
    #[inline]
    pub fn user_data(mut self, user_data: *mut c_void) -> Self {
        self.inner.p_user_data = user_data;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugReportCallbackCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkValidationFlagsEXT.html>"]
pub struct ValidationFlagsEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub disabled_validation_check_count: u32,
    pub p_disabled_validation_checks: *const ValidationCheckEXT,
}
impl ::std::default::Default for ValidationFlagsEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            disabled_validation_check_count: u32::default(),
            p_disabled_validation_checks: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for ValidationFlagsEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_FLAGS_EXT;
}
impl ValidationFlagsEXT {
    pub fn builder<'a>() -> ValidationFlagsEXTBuilder<'a> {
        ValidationFlagsEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ValidationFlagsEXTBuilder<'a> {
    inner: ValidationFlagsEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFlagsEXT {}
impl<'a> ::std::ops::Deref for ValidationFlagsEXTBuilder<'a> {
    type Target = ValidationFlagsEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ValidationFlagsEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ValidationFlagsEXTBuilder<'a> {
    #[inline]
    pub fn disabled_validation_checks(
        mut self,
        disabled_validation_checks: &'a [ValidationCheckEXT],
    ) -> Self {
        self.inner.disabled_validation_check_count = disabled_validation_checks.len() as _;
        self.inner.p_disabled_validation_checks = disabled_validation_checks.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ValidationFlagsEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkValidationFeaturesEXT.html>"]
pub struct ValidationFeaturesEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub enabled_validation_feature_count: u32,
    pub p_enabled_validation_features: *const ValidationFeatureEnableEXT,
    pub disabled_validation_feature_count: u32,
    pub p_disabled_validation_features: *const ValidationFeatureDisableEXT,
}
impl ::std::default::Default for ValidationFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            enabled_validation_feature_count: u32::default(),
            p_enabled_validation_features: ::std::ptr::null(),
            disabled_validation_feature_count: u32::default(),
            p_disabled_validation_features: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for ValidationFeaturesEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_FEATURES_EXT;
}
impl ValidationFeaturesEXT {
    pub fn builder<'a>() -> ValidationFeaturesEXTBuilder<'a> {
        ValidationFeaturesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ValidationFeaturesEXTBuilder<'a> {
    inner: ValidationFeaturesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXTBuilder<'_> {}
unsafe impl ExtendsInstanceCreateInfo for ValidationFeaturesEXT {}
impl<'a> ::std::ops::Deref for ValidationFeaturesEXTBuilder<'a> {
    type Target = ValidationFeaturesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ValidationFeaturesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ValidationFeaturesEXTBuilder<'a> {
    #[inline]
    pub fn enabled_validation_features(
        mut self,
        enabled_validation_features: &'a [ValidationFeatureEnableEXT],
    ) -> Self {
        self.inner.enabled_validation_feature_count = enabled_validation_features.len() as _;
        self.inner.p_enabled_validation_features = enabled_validation_features.as_ptr();
        self
    }
    #[inline]
    pub fn disabled_validation_features(
        mut self,
        disabled_validation_features: &'a [ValidationFeatureDisableEXT],
    ) -> Self {
        self.inner.disabled_validation_feature_count = disabled_validation_features.len() as _;
        self.inner.p_disabled_validation_features = disabled_validation_features.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ValidationFeaturesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineRasterizationStateRasterizationOrderAMD.html>"]
pub struct PipelineRasterizationStateRasterizationOrderAMD {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub rasterization_order: RasterizationOrderAMD,
}
impl ::std::default::Default for PipelineRasterizationStateRasterizationOrderAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            rasterization_order: RasterizationOrderAMD::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineRasterizationStateRasterizationOrderAMD {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD;
}
impl PipelineRasterizationStateRasterizationOrderAMD {
    pub fn builder<'a>() -> PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
        PipelineRasterizationStateRasterizationOrderAMDBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    inner: PipelineRasterizationStateRasterizationOrderAMD,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateRasterizationOrderAMDBuilder<'_>
{
}
unsafe impl ExtendsPipelineRasterizationStateCreateInfo
    for PipelineRasterizationStateRasterizationOrderAMD
{
}
impl<'a> ::std::ops::Deref for PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    type Target = PipelineRasterizationStateRasterizationOrderAMD;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineRasterizationStateRasterizationOrderAMDBuilder<'a> {
    #[inline]
    pub fn rasterization_order(mut self, rasterization_order: RasterizationOrderAMD) -> Self {
        self.inner.rasterization_order = rasterization_order;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineRasterizationStateRasterizationOrderAMD {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerObjectNameInfoEXT.html>"]
pub struct DebugMarkerObjectNameInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub p_object_name: *const c_char,
}
impl ::std::default::Default for DebugMarkerObjectNameInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            p_object_name: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DebugMarkerObjectNameInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_OBJECT_NAME_INFO_EXT;
}
impl DebugMarkerObjectNameInfoEXT {
    pub fn builder<'a>() -> DebugMarkerObjectNameInfoEXTBuilder<'a> {
        DebugMarkerObjectNameInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerObjectNameInfoEXTBuilder<'a> {
    inner: DebugMarkerObjectNameInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DebugMarkerObjectNameInfoEXTBuilder<'a> {
    type Target = DebugMarkerObjectNameInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerObjectNameInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerObjectNameInfoEXTBuilder<'a> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.inner.object_type = object_type;
        self
    }
    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.inner.object = object;
        self
    }
    #[inline]
    pub fn object_name(mut self, object_name: &'a ::std::ffi::CStr) -> Self {
        self.inner.p_object_name = object_name.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerObjectNameInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerObjectTagInfoEXT.html>"]
pub struct DebugMarkerObjectTagInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub object_type: DebugReportObjectTypeEXT,
    pub object: u64,
    pub tag_name: u64,
    pub tag_size: usize,
    pub p_tag: *const c_void,
}
impl ::std::default::Default for DebugMarkerObjectTagInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            object_type: DebugReportObjectTypeEXT::default(),
            object: u64::default(),
            tag_name: u64::default(),
            tag_size: usize::default(),
            p_tag: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DebugMarkerObjectTagInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_OBJECT_TAG_INFO_EXT;
}
impl DebugMarkerObjectTagInfoEXT {
    pub fn builder<'a>() -> DebugMarkerObjectTagInfoEXTBuilder<'a> {
        DebugMarkerObjectTagInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerObjectTagInfoEXTBuilder<'a> {
    inner: DebugMarkerObjectTagInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DebugMarkerObjectTagInfoEXTBuilder<'a> {
    type Target = DebugMarkerObjectTagInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerObjectTagInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerObjectTagInfoEXTBuilder<'a> {
    #[inline]
    pub fn object_type(mut self, object_type: DebugReportObjectTypeEXT) -> Self {
        self.inner.object_type = object_type;
        self
    }
    #[inline]
    pub fn object(mut self, object: u64) -> Self {
        self.inner.object = object;
        self
    }
    #[inline]
    pub fn tag_name(mut self, tag_name: u64) -> Self {
        self.inner.tag_name = tag_name;
        self
    }
    #[inline]
    pub fn tag(mut self, tag: &'a [u8]) -> Self {
        self.inner.tag_size = tag.len();
        self.inner.p_tag = tag.as_ptr().cast();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerObjectTagInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDebugMarkerMarkerInfoEXT.html>"]
pub struct DebugMarkerMarkerInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_marker_name: *const c_char,
    pub color: [f32; 4],
}
impl ::std::default::Default for DebugMarkerMarkerInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_marker_name: ::std::ptr::null(),
            color: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for DebugMarkerMarkerInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DEBUG_MARKER_MARKER_INFO_EXT;
}
impl DebugMarkerMarkerInfoEXT {
    pub fn builder<'a>() -> DebugMarkerMarkerInfoEXTBuilder<'a> {
        DebugMarkerMarkerInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DebugMarkerMarkerInfoEXTBuilder<'a> {
    inner: DebugMarkerMarkerInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DebugMarkerMarkerInfoEXTBuilder<'a> {
    type Target = DebugMarkerMarkerInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DebugMarkerMarkerInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DebugMarkerMarkerInfoEXTBuilder<'a> {
    #[inline]
    pub fn marker_name(mut self, marker_name: &'a ::std::ffi::CStr) -> Self {
        self.inner.p_marker_name = marker_name.as_ptr();
        self
    }
    #[inline]
    pub fn color(mut self, color: [f32; 4]) -> Self {
        self.inner.color = color;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DebugMarkerMarkerInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationImageCreateInfoNV.html>"]
pub struct DedicatedAllocationImageCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
}
impl ::std::default::Default for DedicatedAllocationImageCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for DedicatedAllocationImageCreateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV;
}
impl DedicatedAllocationImageCreateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationImageCreateInfoNVBuilder<'a> {
        DedicatedAllocationImageCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    inner: DedicatedAllocationImageCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for DedicatedAllocationImageCreateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationImageCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationImageCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.inner.dedicated_allocation = dedicated_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationImageCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationBufferCreateInfoNV.html>"]
pub struct DedicatedAllocationBufferCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub dedicated_allocation: Bool32,
}
impl ::std::default::Default for DedicatedAllocationBufferCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            dedicated_allocation: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for DedicatedAllocationBufferCreateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV;
}
impl DedicatedAllocationBufferCreateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
        DedicatedAllocationBufferCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    inner: DedicatedAllocationBufferCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsBufferCreateInfo for DedicatedAllocationBufferCreateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationBufferCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationBufferCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn dedicated_allocation(mut self, dedicated_allocation: bool) -> Self {
        self.inner.dedicated_allocation = dedicated_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationBufferCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDedicatedAllocationMemoryAllocateInfoNV.html>"]
pub struct DedicatedAllocationMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}
impl ::std::default::Default for DedicatedAllocationMemoryAllocateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
        }
    }
}
unsafe impl TaggedStructure for DedicatedAllocationMemoryAllocateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV;
}
impl DedicatedAllocationMemoryAllocateInfoNV {
    pub fn builder<'a>() -> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
        DedicatedAllocationMemoryAllocateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    inner: DedicatedAllocationMemoryAllocateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for DedicatedAllocationMemoryAllocateInfoNV {}
impl<'a> ::std::ops::Deref for DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    type Target = DedicatedAllocationMemoryAllocateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DedicatedAllocationMemoryAllocateInfoNVBuilder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DedicatedAllocationMemoryAllocateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalImageFormatPropertiesNV.html>"]
pub struct ExternalImageFormatPropertiesNV {
    pub image_format_properties: ImageFormatProperties,
    pub external_memory_features: ExternalMemoryFeatureFlagsNV,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ExternalImageFormatPropertiesNV {
    pub fn builder<'a>() -> ExternalImageFormatPropertiesNVBuilder<'a> {
        ExternalImageFormatPropertiesNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalImageFormatPropertiesNVBuilder<'a> {
    inner: ExternalImageFormatPropertiesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalImageFormatPropertiesNVBuilder<'a> {
    type Target = ExternalImageFormatPropertiesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalImageFormatPropertiesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalImageFormatPropertiesNVBuilder<'a> {
    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> Self {
        self.inner.image_format_properties = image_format_properties;
        self
    }
    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlagsNV,
    ) -> Self {
        self.inner.external_memory_features = external_memory_features;
        self
    }
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlagsNV,
    ) -> Self {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalImageFormatPropertiesNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryImageCreateInfoNV.html>"]
pub struct ExternalMemoryImageCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ::std::default::Default for ExternalMemoryImageCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalMemoryImageCreateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV;
}
impl ExternalMemoryImageCreateInfoNV {
    pub fn builder<'a>() -> ExternalMemoryImageCreateInfoNVBuilder<'a> {
        ExternalMemoryImageCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryImageCreateInfoNVBuilder<'a> {
    inner: ExternalMemoryImageCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNVBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoNV {}
impl<'a> ::std::ops::Deref for ExternalMemoryImageCreateInfoNVBuilder<'a> {
    type Target = ExternalMemoryImageCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryImageCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryImageCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryImageCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportMemoryAllocateInfoNV.html>"]
pub struct ExportMemoryAllocateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlagsNV,
}
impl ::std::default::Default for ExportMemoryAllocateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlagsNV::default(),
        }
    }
}
unsafe impl TaggedStructure for ExportMemoryAllocateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_ALLOCATE_INFO_NV;
}
impl ExportMemoryAllocateInfoNV {
    pub fn builder<'a>() -> ExportMemoryAllocateInfoNVBuilder<'a> {
        ExportMemoryAllocateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryAllocateInfoNVBuilder<'a> {
    inner: ExportMemoryAllocateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoNV {}
impl<'a> ::std::ops::Deref for ExportMemoryAllocateInfoNVBuilder<'a> {
    type Target = ExportMemoryAllocateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryAllocateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryAllocateInfoNVBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryAllocateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportMemoryWin32HandleInfoNV.html>"]
pub struct ImportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlagsNV,
    pub handle: HANDLE,
}
impl ::std::default::Default for ImportMemoryWin32HandleInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlagsNV::default(),
            handle: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ImportMemoryWin32HandleInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_NV;
}
impl ImportMemoryWin32HandleInfoNV {
    pub fn builder<'a>() -> ImportMemoryWin32HandleInfoNVBuilder<'a> {
        ImportMemoryWin32HandleInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryWin32HandleInfoNVBuilder<'a> {
    inner: ImportMemoryWin32HandleInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoNV {}
impl<'a> ::std::ops::Deref for ImportMemoryWin32HandleInfoNVBuilder<'a> {
    type Target = ImportMemoryWin32HandleInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryWin32HandleInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryWin32HandleInfoNVBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlagsNV) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.inner.handle = handle;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryWin32HandleInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportMemoryWin32HandleInfoNV.html>"]
pub struct ExportMemoryWin32HandleInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
}
impl ::std::default::Default for ExportMemoryWin32HandleInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
        }
    }
}
unsafe impl TaggedStructure for ExportMemoryWin32HandleInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_NV;
}
impl ExportMemoryWin32HandleInfoNV {
    pub fn builder<'a>() -> ExportMemoryWin32HandleInfoNVBuilder<'a> {
        ExportMemoryWin32HandleInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryWin32HandleInfoNVBuilder<'a> {
    inner: ExportMemoryWin32HandleInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNVBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoNV {}
impl<'a> ::std::ops::Deref for ExportMemoryWin32HandleInfoNVBuilder<'a> {
    type Target = ExportMemoryWin32HandleInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryWin32HandleInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryWin32HandleInfoNVBuilder<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.inner.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.inner.dw_access = dw_access;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryWin32HandleInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoNV.html>"]
pub struct Win32KeyedMutexAcquireReleaseInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeout_milliseconds: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
}
impl ::std::default::Default for Win32KeyedMutexAcquireReleaseInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::std::ptr::null(),
            p_acquire_keys: ::std::ptr::null(),
            p_acquire_timeout_milliseconds: ::std::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::std::ptr::null(),
            p_release_keys: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for Win32KeyedMutexAcquireReleaseInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_NV;
}
impl Win32KeyedMutexAcquireReleaseInfoNV {
    pub fn builder<'a>() -> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
        Win32KeyedMutexAcquireReleaseInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    inner: Win32KeyedMutexAcquireReleaseInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoNV {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'_> {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoNV {}
impl<'a> ::std::ops::Deref for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    type Target = Win32KeyedMutexAcquireReleaseInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32KeyedMutexAcquireReleaseInfoNVBuilder<'a> {
    #[inline]
    pub fn acquire_syncs(mut self, acquire_syncs: &'a [DeviceMemory]) -> Self {
        self.inner.acquire_count = acquire_syncs.len() as _;
        self.inner.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_keys(mut self, acquire_keys: &'a [u64]) -> Self {
        self.inner.acquire_count = acquire_keys.len() as _;
        self.inner.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_timeout_milliseconds(mut self, acquire_timeout_milliseconds: &'a [u32]) -> Self {
        self.inner.acquire_count = acquire_timeout_milliseconds.len() as _;
        self.inner.p_acquire_timeout_milliseconds = acquire_timeout_milliseconds.as_ptr();
        self
    }
    #[inline]
    pub fn release_syncs(mut self, release_syncs: &'a [DeviceMemory]) -> Self {
        self.inner.release_count = release_syncs.len() as _;
        self.inner.p_release_syncs = release_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn release_keys(mut self, release_keys: &'a [u64]) -> Self {
        self.inner.release_count = release_keys.len() as _;
        self.inner.p_release_keys = release_keys.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32KeyedMutexAcquireReleaseInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV.html>"]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_generated_commands: Bool32,
}
impl ::std::default::Default for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            device_generated_commands: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV;
}
impl PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
    pub fn builder<'a>() -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
        PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    inner: PhysicalDeviceDeviceGeneratedCommandsFeaturesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    type Target = PhysicalDeviceDeviceGeneratedCommandsFeaturesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsFeaturesNVBuilder<'a> {
    #[inline]
    pub fn device_generated_commands(mut self, device_generated_commands: bool) -> Self {
        self.inner.device_generated_commands = device_generated_commands.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsFeaturesNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDevicePrivateDataCreateInfo.html>"]
pub struct DevicePrivateDataCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub private_data_slot_request_count: u32,
}
impl ::std::default::Default for DevicePrivateDataCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            private_data_slot_request_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DevicePrivateDataCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_PRIVATE_DATA_CREATE_INFO;
}
impl DevicePrivateDataCreateInfo {
    pub fn builder<'a>() -> DevicePrivateDataCreateInfoBuilder<'a> {
        DevicePrivateDataCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DevicePrivateDataCreateInfoBuilder<'a> {
    inner: DevicePrivateDataCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for DevicePrivateDataCreateInfoBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for DevicePrivateDataCreateInfo {}
impl<'a> ::std::ops::Deref for DevicePrivateDataCreateInfoBuilder<'a> {
    type Target = DevicePrivateDataCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DevicePrivateDataCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DevicePrivateDataCreateInfoBuilder<'a> {
    #[inline]
    pub fn private_data_slot_request_count(mut self, private_data_slot_request_count: u32) -> Self {
        self.inner.private_data_slot_request_count = private_data_slot_request_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DevicePrivateDataCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPrivateDataSlotCreateInfo.html>"]
pub struct PrivateDataSlotCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PrivateDataSlotCreateFlags,
}
impl ::std::default::Default for PrivateDataSlotCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PrivateDataSlotCreateFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PrivateDataSlotCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PRIVATE_DATA_SLOT_CREATE_INFO;
}
impl PrivateDataSlotCreateInfo {
    pub fn builder<'a>() -> PrivateDataSlotCreateInfoBuilder<'a> {
        PrivateDataSlotCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PrivateDataSlotCreateInfoBuilder<'a> {
    inner: PrivateDataSlotCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PrivateDataSlotCreateInfoBuilder<'a> {
    type Target = PrivateDataSlotCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PrivateDataSlotCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PrivateDataSlotCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PrivateDataSlotCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PrivateDataSlotCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePrivateDataFeatures.html>"]
pub struct PhysicalDevicePrivateDataFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub private_data: Bool32,
}
impl ::std::default::Default for PhysicalDevicePrivateDataFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            private_data: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevicePrivateDataFeatures {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES;
}
impl PhysicalDevicePrivateDataFeatures {
    pub fn builder<'a>() -> PhysicalDevicePrivateDataFeaturesBuilder<'a> {
        PhysicalDevicePrivateDataFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePrivateDataFeaturesBuilder<'a> {
    inner: PhysicalDevicePrivateDataFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePrivateDataFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePrivateDataFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePrivateDataFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePrivateDataFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDevicePrivateDataFeaturesBuilder<'a> {
    type Target = PhysicalDevicePrivateDataFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePrivateDataFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePrivateDataFeaturesBuilder<'a> {
    #[inline]
    pub fn private_data(mut self, private_data: bool) -> Self {
        self.inner.private_data = private_data.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePrivateDataFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV.html>"]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_graphics_shader_group_count: u32,
    pub max_indirect_sequence_count: u32,
    pub max_indirect_commands_token_count: u32,
    pub max_indirect_commands_stream_count: u32,
    pub max_indirect_commands_token_offset: u32,
    pub max_indirect_commands_stream_stride: u32,
    pub min_sequences_count_buffer_offset_alignment: u32,
    pub min_sequences_index_buffer_offset_alignment: u32,
    pub min_indirect_commands_buffer_offset_alignment: u32,
}
impl ::std::default::Default for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_graphics_shader_group_count: u32::default(),
            max_indirect_sequence_count: u32::default(),
            max_indirect_commands_token_count: u32::default(),
            max_indirect_commands_stream_count: u32::default(),
            max_indirect_commands_token_offset: u32::default(),
            max_indirect_commands_stream_stride: u32::default(),
            min_sequences_count_buffer_offset_alignment: u32::default(),
            min_sequences_index_buffer_offset_alignment: u32::default(),
            min_indirect_commands_buffer_offset_alignment: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV;
}
impl PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
    pub fn builder<'a>() -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
        PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    inner: PhysicalDeviceDeviceGeneratedCommandsPropertiesNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    type Target = PhysicalDeviceDeviceGeneratedCommandsPropertiesNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDeviceGeneratedCommandsPropertiesNVBuilder<'a> {
    #[inline]
    pub fn max_graphics_shader_group_count(mut self, max_graphics_shader_group_count: u32) -> Self {
        self.inner.max_graphics_shader_group_count = max_graphics_shader_group_count;
        self
    }
    #[inline]
    pub fn max_indirect_sequence_count(mut self, max_indirect_sequence_count: u32) -> Self {
        self.inner.max_indirect_sequence_count = max_indirect_sequence_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_token_count(
        mut self,
        max_indirect_commands_token_count: u32,
    ) -> Self {
        self.inner.max_indirect_commands_token_count = max_indirect_commands_token_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_stream_count(
        mut self,
        max_indirect_commands_stream_count: u32,
    ) -> Self {
        self.inner.max_indirect_commands_stream_count = max_indirect_commands_stream_count;
        self
    }
    #[inline]
    pub fn max_indirect_commands_token_offset(
        mut self,
        max_indirect_commands_token_offset: u32,
    ) -> Self {
        self.inner.max_indirect_commands_token_offset = max_indirect_commands_token_offset;
        self
    }
    #[inline]
    pub fn max_indirect_commands_stream_stride(
        mut self,
        max_indirect_commands_stream_stride: u32,
    ) -> Self {
        self.inner.max_indirect_commands_stream_stride = max_indirect_commands_stream_stride;
        self
    }
    #[inline]
    pub fn min_sequences_count_buffer_offset_alignment(
        mut self,
        min_sequences_count_buffer_offset_alignment: u32,
    ) -> Self {
        self.inner.min_sequences_count_buffer_offset_alignment =
            min_sequences_count_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_sequences_index_buffer_offset_alignment(
        mut self,
        min_sequences_index_buffer_offset_alignment: u32,
    ) -> Self {
        self.inner.min_sequences_index_buffer_offset_alignment =
            min_sequences_index_buffer_offset_alignment;
        self
    }
    #[inline]
    pub fn min_indirect_commands_buffer_offset_alignment(
        mut self,
        min_indirect_commands_buffer_offset_alignment: u32,
    ) -> Self {
        self.inner.min_indirect_commands_buffer_offset_alignment =
            min_indirect_commands_buffer_offset_alignment;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDeviceGeneratedCommandsPropertiesNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiDrawPropertiesEXT.html>"]
pub struct PhysicalDeviceMultiDrawPropertiesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_multi_draw_count: u32,
}
impl ::std::default::Default for PhysicalDeviceMultiDrawPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_multi_draw_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMultiDrawPropertiesEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT;
}
impl PhysicalDeviceMultiDrawPropertiesEXT {
    pub fn builder<'a>() -> PhysicalDeviceMultiDrawPropertiesEXTBuilder<'a> {
        PhysicalDeviceMultiDrawPropertiesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMultiDrawPropertiesEXTBuilder<'a> {
    inner: PhysicalDeviceMultiDrawPropertiesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiDrawPropertiesEXTBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiDrawPropertiesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMultiDrawPropertiesEXTBuilder<'a> {
    type Target = PhysicalDeviceMultiDrawPropertiesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMultiDrawPropertiesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMultiDrawPropertiesEXTBuilder<'a> {
    #[inline]
    pub fn max_multi_draw_count(mut self, max_multi_draw_count: u32) -> Self {
        self.inner.max_multi_draw_count = max_multi_draw_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMultiDrawPropertiesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkGraphicsShaderGroupCreateInfoNV.html>"]
pub struct GraphicsShaderGroupCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub stage_count: u32,
    pub p_stages: *const PipelineShaderStageCreateInfo,
    pub p_vertex_input_state: *const PipelineVertexInputStateCreateInfo,
    pub p_tessellation_state: *const PipelineTessellationStateCreateInfo,
}
impl ::std::default::Default for GraphicsShaderGroupCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            stage_count: u32::default(),
            p_stages: ::std::ptr::null(),
            p_vertex_input_state: ::std::ptr::null(),
            p_tessellation_state: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for GraphicsShaderGroupCreateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::GRAPHICS_SHADER_GROUP_CREATE_INFO_NV;
}
impl GraphicsShaderGroupCreateInfoNV {
    pub fn builder<'a>() -> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
        GraphicsShaderGroupCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    inner: GraphicsShaderGroupCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    type Target = GraphicsShaderGroupCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsShaderGroupCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn stages(mut self, stages: &'a [PipelineShaderStageCreateInfo]) -> Self {
        self.inner.stage_count = stages.len() as _;
        self.inner.p_stages = stages.as_ptr();
        self
    }
    #[inline]
    pub fn vertex_input_state(
        mut self,
        vertex_input_state: &'a PipelineVertexInputStateCreateInfo,
    ) -> Self {
        self.inner.p_vertex_input_state = vertex_input_state;
        self
    }
    #[inline]
    pub fn tessellation_state(
        mut self,
        tessellation_state: &'a PipelineTessellationStateCreateInfo,
    ) -> Self {
        self.inner.p_tessellation_state = tessellation_state;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsShaderGroupCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkGraphicsPipelineShaderGroupsCreateInfoNV.html>"]
pub struct GraphicsPipelineShaderGroupsCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub group_count: u32,
    pub p_groups: *const GraphicsShaderGroupCreateInfoNV,
    pub pipeline_count: u32,
    pub p_pipelines: *const Pipeline,
}
impl ::std::default::Default for GraphicsPipelineShaderGroupsCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            group_count: u32::default(),
            p_groups: ::std::ptr::null(),
            pipeline_count: u32::default(),
            p_pipelines: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for GraphicsPipelineShaderGroupsCreateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV;
}
impl GraphicsPipelineShaderGroupsCreateInfoNV {
    pub fn builder<'a>() -> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
        GraphicsPipelineShaderGroupsCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    inner: GraphicsPipelineShaderGroupsCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsGraphicsPipelineCreateInfo
    for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsGraphicsPipelineCreateInfo for GraphicsPipelineShaderGroupsCreateInfoNV {}
impl<'a> ::std::ops::Deref for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    type Target = GraphicsPipelineShaderGroupsCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GraphicsPipelineShaderGroupsCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn groups(mut self, groups: &'a [GraphicsShaderGroupCreateInfoNV]) -> Self {
        self.inner.group_count = groups.len() as _;
        self.inner.p_groups = groups.as_ptr();
        self
    }
    #[inline]
    pub fn pipelines(mut self, pipelines: &'a [Pipeline]) -> Self {
        self.inner.pipeline_count = pipelines.len() as _;
        self.inner.p_pipelines = pipelines.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GraphicsPipelineShaderGroupsCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindShaderGroupIndirectCommandNV.html>"]
pub struct BindShaderGroupIndirectCommandNV {
    pub group_index: u32,
}
impl BindShaderGroupIndirectCommandNV {
    pub fn builder<'a>() -> BindShaderGroupIndirectCommandNVBuilder<'a> {
        BindShaderGroupIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindShaderGroupIndirectCommandNVBuilder<'a> {
    inner: BindShaderGroupIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindShaderGroupIndirectCommandNVBuilder<'a> {
    type Target = BindShaderGroupIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindShaderGroupIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindShaderGroupIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn group_index(mut self, group_index: u32) -> Self {
        self.inner.group_index = group_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindShaderGroupIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindIndexBufferIndirectCommandNV.html>"]
pub struct BindIndexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub index_type: IndexType,
}
impl BindIndexBufferIndirectCommandNV {
    pub fn builder<'a>() -> BindIndexBufferIndirectCommandNVBuilder<'a> {
        BindIndexBufferIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindIndexBufferIndirectCommandNVBuilder<'a> {
    inner: BindIndexBufferIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindIndexBufferIndirectCommandNVBuilder<'a> {
    type Target = BindIndexBufferIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindIndexBufferIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindIndexBufferIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.inner.buffer_address = buffer_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn index_type(mut self, index_type: IndexType) -> Self {
        self.inner.index_type = index_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindIndexBufferIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindVertexBufferIndirectCommandNV.html>"]
pub struct BindVertexBufferIndirectCommandNV {
    pub buffer_address: DeviceAddress,
    pub size: u32,
    pub stride: u32,
}
impl BindVertexBufferIndirectCommandNV {
    pub fn builder<'a>() -> BindVertexBufferIndirectCommandNVBuilder<'a> {
        BindVertexBufferIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindVertexBufferIndirectCommandNVBuilder<'a> {
    inner: BindVertexBufferIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BindVertexBufferIndirectCommandNVBuilder<'a> {
    type Target = BindVertexBufferIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindVertexBufferIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindVertexBufferIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn buffer_address(mut self, buffer_address: DeviceAddress) -> Self {
        self.inner.buffer_address = buffer_address;
        self
    }
    #[inline]
    pub fn size(mut self, size: u32) -> Self {
        self.inner.size = size;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: u32) -> Self {
        self.inner.stride = stride;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindVertexBufferIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSetStateFlagsIndirectCommandNV.html>"]
pub struct SetStateFlagsIndirectCommandNV {
    pub data: u32,
}
impl SetStateFlagsIndirectCommandNV {
    pub fn builder<'a>() -> SetStateFlagsIndirectCommandNVBuilder<'a> {
        SetStateFlagsIndirectCommandNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SetStateFlagsIndirectCommandNVBuilder<'a> {
    inner: SetStateFlagsIndirectCommandNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SetStateFlagsIndirectCommandNVBuilder<'a> {
    type Target = SetStateFlagsIndirectCommandNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SetStateFlagsIndirectCommandNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SetStateFlagsIndirectCommandNVBuilder<'a> {
    #[inline]
    pub fn data(mut self, data: u32) -> Self {
        self.inner.data = data;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SetStateFlagsIndirectCommandNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsStreamNV.html>"]
pub struct IndirectCommandsStreamNV {
    pub buffer: Buffer,
    pub offset: DeviceSize,
}
impl IndirectCommandsStreamNV {
    pub fn builder<'a>() -> IndirectCommandsStreamNVBuilder<'a> {
        IndirectCommandsStreamNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsStreamNVBuilder<'a> {
    inner: IndirectCommandsStreamNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for IndirectCommandsStreamNVBuilder<'a> {
    type Target = IndirectCommandsStreamNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsStreamNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsStreamNVBuilder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsStreamNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutTokenNV.html>"]
pub struct IndirectCommandsLayoutTokenNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub token_type: IndirectCommandsTokenTypeNV,
    pub stream: u32,
    pub offset: u32,
    pub vertex_binding_unit: u32,
    pub vertex_dynamic_stride: Bool32,
    pub pushconstant_pipeline_layout: PipelineLayout,
    pub pushconstant_shader_stage_flags: ShaderStageFlags,
    pub pushconstant_offset: u32,
    pub pushconstant_size: u32,
    pub indirect_state_flags: IndirectStateFlagsNV,
    pub index_type_count: u32,
    pub p_index_types: *const IndexType,
    pub p_index_type_values: *const u32,
}
impl ::std::default::Default for IndirectCommandsLayoutTokenNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            token_type: IndirectCommandsTokenTypeNV::default(),
            stream: u32::default(),
            offset: u32::default(),
            vertex_binding_unit: u32::default(),
            vertex_dynamic_stride: Bool32::default(),
            pushconstant_pipeline_layout: PipelineLayout::default(),
            pushconstant_shader_stage_flags: ShaderStageFlags::default(),
            pushconstant_offset: u32::default(),
            pushconstant_size: u32::default(),
            indirect_state_flags: IndirectStateFlagsNV::default(),
            index_type_count: u32::default(),
            p_index_types: ::std::ptr::null(),
            p_index_type_values: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for IndirectCommandsLayoutTokenNV {
    const STRUCTURE_TYPE: StructureType = StructureType::INDIRECT_COMMANDS_LAYOUT_TOKEN_NV;
}
impl IndirectCommandsLayoutTokenNV {
    pub fn builder<'a>() -> IndirectCommandsLayoutTokenNVBuilder<'a> {
        IndirectCommandsLayoutTokenNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsLayoutTokenNVBuilder<'a> {
    inner: IndirectCommandsLayoutTokenNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for IndirectCommandsLayoutTokenNVBuilder<'a> {
    type Target = IndirectCommandsLayoutTokenNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsLayoutTokenNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsLayoutTokenNVBuilder<'a> {
    #[inline]
    pub fn token_type(mut self, token_type: IndirectCommandsTokenTypeNV) -> Self {
        self.inner.token_type = token_type;
        self
    }
    #[inline]
    pub fn stream(mut self, stream: u32) -> Self {
        self.inner.stream = stream;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: u32) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn vertex_binding_unit(mut self, vertex_binding_unit: u32) -> Self {
        self.inner.vertex_binding_unit = vertex_binding_unit;
        self
    }
    #[inline]
    pub fn vertex_dynamic_stride(mut self, vertex_dynamic_stride: bool) -> Self {
        self.inner.vertex_dynamic_stride = vertex_dynamic_stride.into();
        self
    }
    #[inline]
    pub fn pushconstant_pipeline_layout(
        mut self,
        pushconstant_pipeline_layout: PipelineLayout,
    ) -> Self {
        self.inner.pushconstant_pipeline_layout = pushconstant_pipeline_layout;
        self
    }
    #[inline]
    pub fn pushconstant_shader_stage_flags(
        mut self,
        pushconstant_shader_stage_flags: ShaderStageFlags,
    ) -> Self {
        self.inner.pushconstant_shader_stage_flags = pushconstant_shader_stage_flags;
        self
    }
    #[inline]
    pub fn pushconstant_offset(mut self, pushconstant_offset: u32) -> Self {
        self.inner.pushconstant_offset = pushconstant_offset;
        self
    }
    #[inline]
    pub fn pushconstant_size(mut self, pushconstant_size: u32) -> Self {
        self.inner.pushconstant_size = pushconstant_size;
        self
    }
    #[inline]
    pub fn indirect_state_flags(mut self, indirect_state_flags: IndirectStateFlagsNV) -> Self {
        self.inner.indirect_state_flags = indirect_state_flags;
        self
    }
    #[inline]
    pub fn index_types(mut self, index_types: &'a [IndexType]) -> Self {
        self.inner.index_type_count = index_types.len() as _;
        self.inner.p_index_types = index_types.as_ptr();
        self
    }
    #[inline]
    pub fn index_type_values(mut self, index_type_values: &'a [u32]) -> Self {
        self.inner.index_type_count = index_type_values.len() as _;
        self.inner.p_index_type_values = index_type_values.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsLayoutTokenNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIndirectCommandsLayoutCreateInfoNV.html>"]
pub struct IndirectCommandsLayoutCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: IndirectCommandsLayoutUsageFlagsNV,
    pub pipeline_bind_point: PipelineBindPoint,
    pub token_count: u32,
    pub p_tokens: *const IndirectCommandsLayoutTokenNV,
    pub stream_count: u32,
    pub p_stream_strides: *const u32,
}
impl ::std::default::Default for IndirectCommandsLayoutCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: IndirectCommandsLayoutUsageFlagsNV::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            token_count: u32::default(),
            p_tokens: ::std::ptr::null(),
            stream_count: u32::default(),
            p_stream_strides: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for IndirectCommandsLayoutCreateInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV;
}
impl IndirectCommandsLayoutCreateInfoNV {
    pub fn builder<'a>() -> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
        IndirectCommandsLayoutCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    inner: IndirectCommandsLayoutCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    type Target = IndirectCommandsLayoutCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IndirectCommandsLayoutCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: IndirectCommandsLayoutUsageFlagsNV) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn tokens(mut self, tokens: &'a [IndirectCommandsLayoutTokenNV]) -> Self {
        self.inner.token_count = tokens.len() as _;
        self.inner.p_tokens = tokens.as_ptr();
        self
    }
    #[inline]
    pub fn stream_strides(mut self, stream_strides: &'a [u32]) -> Self {
        self.inner.stream_count = stream_strides.len() as _;
        self.inner.p_stream_strides = stream_strides.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IndirectCommandsLayoutCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkGeneratedCommandsInfoNV.html>"]
pub struct GeneratedCommandsInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub stream_count: u32,
    pub p_streams: *const IndirectCommandsStreamNV,
    pub sequences_count: u32,
    pub preprocess_buffer: Buffer,
    pub preprocess_offset: DeviceSize,
    pub preprocess_size: DeviceSize,
    pub sequences_count_buffer: Buffer,
    pub sequences_count_offset: DeviceSize,
    pub sequences_index_buffer: Buffer,
    pub sequences_index_offset: DeviceSize,
}
impl ::std::default::Default for GeneratedCommandsInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            stream_count: u32::default(),
            p_streams: ::std::ptr::null(),
            sequences_count: u32::default(),
            preprocess_buffer: Buffer::default(),
            preprocess_offset: DeviceSize::default(),
            preprocess_size: DeviceSize::default(),
            sequences_count_buffer: Buffer::default(),
            sequences_count_offset: DeviceSize::default(),
            sequences_index_buffer: Buffer::default(),
            sequences_index_offset: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for GeneratedCommandsInfoNV {
    const STRUCTURE_TYPE: StructureType = StructureType::GENERATED_COMMANDS_INFO_NV;
}
impl GeneratedCommandsInfoNV {
    pub fn builder<'a>() -> GeneratedCommandsInfoNVBuilder<'a> {
        GeneratedCommandsInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GeneratedCommandsInfoNVBuilder<'a> {
    inner: GeneratedCommandsInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for GeneratedCommandsInfoNVBuilder<'a> {
    type Target = GeneratedCommandsInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GeneratedCommandsInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GeneratedCommandsInfoNVBuilder<'a> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.inner.pipeline = pipeline;
        self
    }
    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.inner.indirect_commands_layout = indirect_commands_layout;
        self
    }
    #[inline]
    pub fn streams(mut self, streams: &'a [IndirectCommandsStreamNV]) -> Self {
        self.inner.stream_count = streams.len() as _;
        self.inner.p_streams = streams.as_ptr();
        self
    }
    #[inline]
    pub fn sequences_count(mut self, sequences_count: u32) -> Self {
        self.inner.sequences_count = sequences_count;
        self
    }
    #[inline]
    pub fn preprocess_buffer(mut self, preprocess_buffer: Buffer) -> Self {
        self.inner.preprocess_buffer = preprocess_buffer;
        self
    }
    #[inline]
    pub fn preprocess_offset(mut self, preprocess_offset: DeviceSize) -> Self {
        self.inner.preprocess_offset = preprocess_offset;
        self
    }
    #[inline]
    pub fn preprocess_size(mut self, preprocess_size: DeviceSize) -> Self {
        self.inner.preprocess_size = preprocess_size;
        self
    }
    #[inline]
    pub fn sequences_count_buffer(mut self, sequences_count_buffer: Buffer) -> Self {
        self.inner.sequences_count_buffer = sequences_count_buffer;
        self
    }
    #[inline]
    pub fn sequences_count_offset(mut self, sequences_count_offset: DeviceSize) -> Self {
        self.inner.sequences_count_offset = sequences_count_offset;
        self
    }
    #[inline]
    pub fn sequences_index_buffer(mut self, sequences_index_buffer: Buffer) -> Self {
        self.inner.sequences_index_buffer = sequences_index_buffer;
        self
    }
    #[inline]
    pub fn sequences_index_offset(mut self, sequences_index_offset: DeviceSize) -> Self {
        self.inner.sequences_index_offset = sequences_index_offset;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GeneratedCommandsInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkGeneratedCommandsMemoryRequirementsInfoNV.html>"]
pub struct GeneratedCommandsMemoryRequirementsInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline: Pipeline,
    pub indirect_commands_layout: IndirectCommandsLayoutNV,
    pub max_sequences_count: u32,
}
impl ::std::default::Default for GeneratedCommandsMemoryRequirementsInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline: Pipeline::default(),
            indirect_commands_layout: IndirectCommandsLayoutNV::default(),
            max_sequences_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for GeneratedCommandsMemoryRequirementsInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV;
}
impl GeneratedCommandsMemoryRequirementsInfoNV {
    pub fn builder<'a>() -> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
        GeneratedCommandsMemoryRequirementsInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    inner: GeneratedCommandsMemoryRequirementsInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    type Target = GeneratedCommandsMemoryRequirementsInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> GeneratedCommandsMemoryRequirementsInfoNVBuilder<'a> {
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline(mut self, pipeline: Pipeline) -> Self {
        self.inner.pipeline = pipeline;
        self
    }
    #[inline]
    pub fn indirect_commands_layout(
        mut self,
        indirect_commands_layout: IndirectCommandsLayoutNV,
    ) -> Self {
        self.inner.indirect_commands_layout = indirect_commands_layout;
        self
    }
    #[inline]
    pub fn max_sequences_count(mut self, max_sequences_count: u32) -> Self {
        self.inner.max_sequences_count = max_sequences_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> GeneratedCommandsMemoryRequirementsInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceFeatures2.html>"]
pub struct PhysicalDeviceFeatures2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub features: PhysicalDeviceFeatures,
}
impl ::std::default::Default for PhysicalDeviceFeatures2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            features: PhysicalDeviceFeatures::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceFeatures2 {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_FEATURES_2;
}
impl PhysicalDeviceFeatures2 {
    pub fn builder<'a>() -> PhysicalDeviceFeatures2Builder<'a> {
        PhysicalDeviceFeatures2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceFeatures2Builder<'a> {
    inner: PhysicalDeviceFeatures2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2Builder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceFeatures2 {}
pub unsafe trait ExtendsPhysicalDeviceFeatures2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceFeatures2Builder<'a> {
    type Target = PhysicalDeviceFeatures2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceFeatures2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceFeatures2Builder<'a> {
    #[inline]
    pub fn features(mut self, features: PhysicalDeviceFeatures) -> Self {
        self.inner.features = features;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceFeatures2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceFeatures2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProperties2.html>"]
pub struct PhysicalDeviceProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: PhysicalDeviceProperties,
}
impl ::std::default::Default for PhysicalDeviceProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            properties: PhysicalDeviceProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PROPERTIES_2;
}
impl PhysicalDeviceProperties2 {
    pub fn builder<'a>() -> PhysicalDeviceProperties2Builder<'a> {
        PhysicalDeviceProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceProperties2Builder<'a> {
    inner: PhysicalDeviceProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceProperties2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceProperties2Builder<'a> {
    type Target = PhysicalDeviceProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceProperties2Builder<'a> {
    #[inline]
    pub fn properties(mut self, properties: PhysicalDeviceProperties) -> Self {
        self.inner.properties = properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceProperties2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFormatProperties2.html>"]
pub struct FormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub format_properties: FormatProperties,
}
impl ::std::default::Default for FormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            format_properties: FormatProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for FormatProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::FORMAT_PROPERTIES_2;
}
impl FormatProperties2 {
    pub fn builder<'a>() -> FormatProperties2Builder<'a> {
        FormatProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FormatProperties2Builder<'a> {
    inner: FormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsFormatProperties2 {}
impl<'a> ::std::ops::Deref for FormatProperties2Builder<'a> {
    type Target = FormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FormatProperties2Builder<'a> {
    #[inline]
    pub fn format_properties(mut self, format_properties: FormatProperties) -> Self {
        self.inner.format_properties = format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsFormatProperties2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageFormatProperties2.html>"]
pub struct ImageFormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub image_format_properties: ImageFormatProperties,
}
impl ::std::default::Default for ImageFormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            image_format_properties: ImageFormatProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageFormatProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_FORMAT_PROPERTIES_2;
}
impl ImageFormatProperties2 {
    pub fn builder<'a>() -> ImageFormatProperties2Builder<'a> {
        ImageFormatProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageFormatProperties2Builder<'a> {
    inner: ImageFormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageFormatProperties2 {}
impl<'a> ::std::ops::Deref for ImageFormatProperties2Builder<'a> {
    type Target = ImageFormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageFormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageFormatProperties2Builder<'a> {
    #[inline]
    pub fn image_format_properties(
        mut self,
        image_format_properties: ImageFormatProperties,
    ) -> Self {
        self.inner.image_format_properties = image_format_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageFormatProperties2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageFormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceImageFormatInfo2.html>"]
pub struct PhysicalDeviceImageFormatInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub tiling: ImageTiling,
    pub usage: ImageUsageFlags,
    pub flags: ImageCreateFlags,
}
impl ::std::default::Default for PhysicalDeviceImageFormatInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            tiling: ImageTiling::default(),
            usage: ImageUsageFlags::default(),
            flags: ImageCreateFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceImageFormatInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2;
}
impl PhysicalDeviceImageFormatInfo2 {
    pub fn builder<'a>() -> PhysicalDeviceImageFormatInfo2Builder<'a> {
        PhysicalDeviceImageFormatInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceImageFormatInfo2Builder<'a> {
    inner: PhysicalDeviceImageFormatInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceImageFormatInfo2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceImageFormatInfo2Builder<'a> {
    type Target = PhysicalDeviceImageFormatInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceImageFormatInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceImageFormatInfo2Builder<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn ty(mut self, ty: ImageType) -> Self {
        self.inner.ty = ty;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.inner.tiling = tiling;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: ImageCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceImageFormatInfo2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceImageFormatInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkQueueFamilyProperties2.html>"]
pub struct QueueFamilyProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub queue_family_properties: QueueFamilyProperties,
}
impl ::std::default::Default for QueueFamilyProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            queue_family_properties: QueueFamilyProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for QueueFamilyProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::QUEUE_FAMILY_PROPERTIES_2;
}
impl QueueFamilyProperties2 {
    pub fn builder<'a>() -> QueueFamilyProperties2Builder<'a> {
        QueueFamilyProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct QueueFamilyProperties2Builder<'a> {
    inner: QueueFamilyProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsQueueFamilyProperties2 {}
impl<'a> ::std::ops::Deref for QueueFamilyProperties2Builder<'a> {
    type Target = QueueFamilyProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for QueueFamilyProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> QueueFamilyProperties2Builder<'a> {
    #[inline]
    pub fn queue_family_properties(
        mut self,
        queue_family_properties: QueueFamilyProperties,
    ) -> Self {
        self.inner.queue_family_properties = queue_family_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsQueueFamilyProperties2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> QueueFamilyProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMemoryProperties2.html>"]
pub struct PhysicalDeviceMemoryProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_properties: PhysicalDeviceMemoryProperties,
}
impl ::std::default::Default for PhysicalDeviceMemoryProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_properties: PhysicalDeviceMemoryProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMemoryProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MEMORY_PROPERTIES_2;
}
impl PhysicalDeviceMemoryProperties2 {
    pub fn builder<'a>() -> PhysicalDeviceMemoryProperties2Builder<'a> {
        PhysicalDeviceMemoryProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMemoryProperties2Builder<'a> {
    inner: PhysicalDeviceMemoryProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceMemoryProperties2 {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMemoryProperties2Builder<'a> {
    type Target = PhysicalDeviceMemoryProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMemoryProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMemoryProperties2Builder<'a> {
    #[inline]
    pub fn memory_properties(mut self, memory_properties: PhysicalDeviceMemoryProperties) -> Self {
        self.inner.memory_properties = memory_properties;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceMemoryProperties2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMemoryProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageFormatProperties2.html>"]
pub struct SparseImageFormatProperties2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub properties: SparseImageFormatProperties,
}
impl ::std::default::Default for SparseImageFormatProperties2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            properties: SparseImageFormatProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for SparseImageFormatProperties2 {
    const STRUCTURE_TYPE: StructureType = StructureType::SPARSE_IMAGE_FORMAT_PROPERTIES_2;
}
impl SparseImageFormatProperties2 {
    pub fn builder<'a>() -> SparseImageFormatProperties2Builder<'a> {
        SparseImageFormatProperties2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageFormatProperties2Builder<'a> {
    inner: SparseImageFormatProperties2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageFormatProperties2Builder<'a> {
    type Target = SparseImageFormatProperties2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageFormatProperties2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageFormatProperties2Builder<'a> {
    #[inline]
    pub fn properties(mut self, properties: SparseImageFormatProperties) -> Self {
        self.inner.properties = properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageFormatProperties2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSparseImageFormatInfo2.html>"]
pub struct PhysicalDeviceSparseImageFormatInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ty: ImageType,
    pub samples: SampleCountFlags,
    pub usage: ImageUsageFlags,
    pub tiling: ImageTiling,
}
impl ::std::default::Default for PhysicalDeviceSparseImageFormatInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            format: Format::default(),
            ty: ImageType::default(),
            samples: SampleCountFlags::default(),
            usage: ImageUsageFlags::default(),
            tiling: ImageTiling::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSparseImageFormatInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2;
}
impl PhysicalDeviceSparseImageFormatInfo2 {
    pub fn builder<'a>() -> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
        PhysicalDeviceSparseImageFormatInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    inner: PhysicalDeviceSparseImageFormatInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    type Target = PhysicalDeviceSparseImageFormatInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSparseImageFormatInfo2Builder<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn ty(mut self, ty: ImageType) -> Self {
        self.inner.ty = ty;
        self
    }
    #[inline]
    pub fn samples(mut self, samples: SampleCountFlags) -> Self {
        self.inner.samples = samples;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[inline]
    pub fn tiling(mut self, tiling: ImageTiling) -> Self {
        self.inner.tiling = tiling;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSparseImageFormatInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePushDescriptorPropertiesKHR.html>"]
pub struct PhysicalDevicePushDescriptorPropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_push_descriptors: u32,
}
impl ::std::default::Default for PhysicalDevicePushDescriptorPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_push_descriptors: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevicePushDescriptorPropertiesKHR {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR;
}
impl PhysicalDevicePushDescriptorPropertiesKHR {
    pub fn builder<'a>() -> PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
        PhysicalDevicePushDescriptorPropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    inner: PhysicalDevicePushDescriptorPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePushDescriptorPropertiesKHR {}
impl<'a> ::std::ops::Deref for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    type Target = PhysicalDevicePushDescriptorPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePushDescriptorPropertiesKHRBuilder<'a> {
    #[inline]
    pub fn max_push_descriptors(mut self, max_push_descriptors: u32) -> Self {
        self.inner.max_push_descriptors = max_push_descriptors;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePushDescriptorPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkConformanceVersion.html>"]
pub struct ConformanceVersion {
    pub major: u8,
    pub minor: u8,
    pub subminor: u8,
    pub patch: u8,
}
impl ConformanceVersion {
    pub fn builder<'a>() -> ConformanceVersionBuilder<'a> {
        ConformanceVersionBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ConformanceVersionBuilder<'a> {
    inner: ConformanceVersion,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ConformanceVersionBuilder<'a> {
    type Target = ConformanceVersion;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ConformanceVersionBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ConformanceVersionBuilder<'a> {
    #[inline]
    pub fn major(mut self, major: u8) -> Self {
        self.inner.major = major;
        self
    }
    #[inline]
    pub fn minor(mut self, minor: u8) -> Self {
        self.inner.minor = minor;
        self
    }
    #[inline]
    pub fn subminor(mut self, subminor: u8) -> Self {
        self.inner.subminor = subminor;
        self
    }
    #[inline]
    pub fn patch(mut self, patch: u8) -> Self {
        self.inner.patch = patch;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ConformanceVersion {
        self.inner
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDriverProperties.html>"]
pub struct PhysicalDeviceDriverProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub driver_id: DriverId,
    pub driver_name: [c_char; MAX_DRIVER_NAME_SIZE],
    pub driver_info: [c_char; MAX_DRIVER_INFO_SIZE],
    pub conformance_version: ConformanceVersion,
}
#[cfg(feature = "debug")]
impl fmt::Debug for PhysicalDeviceDriverProperties {
    fn fmt(&self, fmt: &mut fmt::Formatter) -> fmt::Result {
        fmt.debug_struct("PhysicalDeviceDriverProperties")
            .field("s_type", &self.s_type)
            .field("p_next", &self.p_next)
            .field("driver_id", &self.driver_id)
            .field("driver_name", &unsafe {
                ::std::ffi::CStr::from_ptr(self.driver_name.as_ptr())
            })
            .field("driver_info", &unsafe {
                ::std::ffi::CStr::from_ptr(self.driver_info.as_ptr())
            })
            .field("conformance_version", &self.conformance_version)
            .finish()
    }
}
impl ::std::default::Default for PhysicalDeviceDriverProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            driver_id: DriverId::default(),
            driver_name: unsafe { ::std::mem::zeroed() },
            driver_info: unsafe { ::std::mem::zeroed() },
            conformance_version: ConformanceVersion::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceDriverProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_DRIVER_PROPERTIES;
}
impl PhysicalDeviceDriverProperties {
    pub fn builder<'a>() -> PhysicalDeviceDriverPropertiesBuilder<'a> {
        PhysicalDeviceDriverPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDriverPropertiesBuilder<'a> {
    inner: PhysicalDeviceDriverProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDriverProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDriverPropertiesBuilder<'a> {
    type Target = PhysicalDeviceDriverProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDriverPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDriverPropertiesBuilder<'a> {
    #[inline]
    pub fn driver_id(mut self, driver_id: DriverId) -> Self {
        self.inner.driver_id = driver_id;
        self
    }
    #[inline]
    pub fn driver_name(mut self, driver_name: [c_char; MAX_DRIVER_NAME_SIZE]) -> Self {
        self.inner.driver_name = driver_name;
        self
    }
    #[inline]
    pub fn driver_info(mut self, driver_info: [c_char; MAX_DRIVER_INFO_SIZE]) -> Self {
        self.inner.driver_info = driver_info;
        self
    }
    #[inline]
    pub fn conformance_version(mut self, conformance_version: ConformanceVersion) -> Self {
        self.inner.conformance_version = conformance_version;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDriverProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentRegionsKHR.html>"]
pub struct PresentRegionsKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_regions: *const PresentRegionKHR,
}
impl ::std::default::Default for PresentRegionsKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_regions: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PresentRegionsKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_REGIONS_KHR;
}
impl PresentRegionsKHR {
    pub fn builder<'a>() -> PresentRegionsKHRBuilder<'a> {
        PresentRegionsKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentRegionsKHRBuilder<'a> {
    inner: PresentRegionsKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for PresentRegionsKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for PresentRegionsKHR {}
impl<'a> ::std::ops::Deref for PresentRegionsKHRBuilder<'a> {
    type Target = PresentRegionsKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentRegionsKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentRegionsKHRBuilder<'a> {
    #[inline]
    pub fn regions(mut self, regions: &'a [PresentRegionKHR]) -> Self {
        self.inner.swapchain_count = regions.len() as _;
        self.inner.p_regions = regions.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentRegionsKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentRegionKHR.html>"]
pub struct PresentRegionKHR {
    pub rectangle_count: u32,
    pub p_rectangles: *const RectLayerKHR,
}
impl ::std::default::Default for PresentRegionKHR {
    #[inline]
    fn default() -> Self {
        Self {
            rectangle_count: u32::default(),
            p_rectangles: ::std::ptr::null(),
        }
    }
}
impl PresentRegionKHR {
    pub fn builder<'a>() -> PresentRegionKHRBuilder<'a> {
        PresentRegionKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentRegionKHRBuilder<'a> {
    inner: PresentRegionKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PresentRegionKHRBuilder<'a> {
    type Target = PresentRegionKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentRegionKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentRegionKHRBuilder<'a> {
    #[inline]
    pub fn rectangles(mut self, rectangles: &'a [RectLayerKHR]) -> Self {
        self.inner.rectangle_count = rectangles.len() as _;
        self.inner.p_rectangles = rectangles.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentRegionKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRectLayerKHR.html>"]
pub struct RectLayerKHR {
    pub offset: Offset2D,
    pub extent: Extent2D,
    pub layer: u32,
}
impl RectLayerKHR {
    pub fn builder<'a>() -> RectLayerKHRBuilder<'a> {
        RectLayerKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RectLayerKHRBuilder<'a> {
    inner: RectLayerKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for RectLayerKHRBuilder<'a> {
    type Target = RectLayerKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RectLayerKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RectLayerKHRBuilder<'a> {
    #[inline]
    pub fn offset(mut self, offset: Offset2D) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn extent(mut self, extent: Extent2D) -> Self {
        self.inner.extent = extent;
        self
    }
    #[inline]
    pub fn layer(mut self, layer: u32) -> Self {
        self.inner.layer = layer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RectLayerKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceVariablePointersFeatures.html>"]
pub struct PhysicalDeviceVariablePointersFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub variable_pointers_storage_buffer: Bool32,
    pub variable_pointers: Bool32,
}
impl ::std::default::Default for PhysicalDeviceVariablePointersFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            variable_pointers_storage_buffer: Bool32::default(),
            variable_pointers: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceVariablePointersFeatures {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES;
}
impl PhysicalDeviceVariablePointersFeatures {
    pub fn builder<'a>() -> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
        PhysicalDeviceVariablePointersFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    inner: PhysicalDeviceVariablePointersFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVariablePointersFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceVariablePointersFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceVariablePointersFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    type Target = PhysicalDeviceVariablePointersFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceVariablePointersFeaturesBuilder<'a> {
    #[inline]
    pub fn variable_pointers_storage_buffer(
        mut self,
        variable_pointers_storage_buffer: bool,
    ) -> Self {
        self.inner.variable_pointers_storage_buffer = variable_pointers_storage_buffer.into();
        self
    }
    #[inline]
    pub fn variable_pointers(mut self, variable_pointers: bool) -> Self {
        self.inner.variable_pointers = variable_pointers.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceVariablePointersFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryProperties.html>"]
pub struct ExternalMemoryProperties {
    pub external_memory_features: ExternalMemoryFeatureFlags,
    pub export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    pub compatible_handle_types: ExternalMemoryHandleTypeFlags,
}
impl ExternalMemoryProperties {
    pub fn builder<'a>() -> ExternalMemoryPropertiesBuilder<'a> {
        ExternalMemoryPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryPropertiesBuilder<'a> {
    inner: ExternalMemoryProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalMemoryPropertiesBuilder<'a> {
    type Target = ExternalMemoryProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryPropertiesBuilder<'a> {
    #[inline]
    pub fn external_memory_features(
        mut self,
        external_memory_features: ExternalMemoryFeatureFlags,
    ) -> Self {
        self.inner.external_memory_features = external_memory_features;
        self
    }
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalMemoryHandleTypeFlags,
    ) -> Self {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalImageFormatInfo.html>"]
pub struct PhysicalDeviceExternalImageFormatInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalImageFormatInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceExternalImageFormatInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO;
}
impl PhysicalDeviceExternalImageFormatInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
        PhysicalDeviceExternalImageFormatInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    inner: PhysicalDeviceExternalImageFormatInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2
    for PhysicalDeviceExternalImageFormatInfoBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for PhysicalDeviceExternalImageFormatInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalImageFormatInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalImageFormatInfoBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalImageFormatInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalImageFormatProperties.html>"]
pub struct ExternalImageFormatProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}
impl ::std::default::Default for ExternalImageFormatProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalImageFormatProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_IMAGE_FORMAT_PROPERTIES;
}
impl ExternalImageFormatProperties {
    pub fn builder<'a>() -> ExternalImageFormatPropertiesBuilder<'a> {
        ExternalImageFormatPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalImageFormatPropertiesBuilder<'a> {
    inner: ExternalImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatPropertiesBuilder<'_> {}
unsafe impl ExtendsImageFormatProperties2 for ExternalImageFormatProperties {}
impl<'a> ::std::ops::Deref for ExternalImageFormatPropertiesBuilder<'a> {
    type Target = ExternalImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalImageFormatPropertiesBuilder<'a> {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> Self {
        self.inner.external_memory_properties = external_memory_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalBufferInfo.html>"]
pub struct PhysicalDeviceExternalBufferInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: BufferCreateFlags,
    pub usage: BufferUsageFlags,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalBufferInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: BufferCreateFlags::default(),
            usage: BufferUsageFlags::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceExternalBufferInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO;
}
impl PhysicalDeviceExternalBufferInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalBufferInfoBuilder<'a> {
        PhysicalDeviceExternalBufferInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalBufferInfoBuilder<'a> {
    inner: PhysicalDeviceExternalBufferInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalBufferInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalBufferInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalBufferInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalBufferInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: BufferCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn usage(mut self, usage: BufferUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalBufferInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalBufferProperties.html>"]
pub struct ExternalBufferProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub external_memory_properties: ExternalMemoryProperties,
}
impl ::std::default::Default for ExternalBufferProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            external_memory_properties: ExternalMemoryProperties::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalBufferProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_BUFFER_PROPERTIES;
}
impl ExternalBufferProperties {
    pub fn builder<'a>() -> ExternalBufferPropertiesBuilder<'a> {
        ExternalBufferPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalBufferPropertiesBuilder<'a> {
    inner: ExternalBufferProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalBufferPropertiesBuilder<'a> {
    type Target = ExternalBufferProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalBufferPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalBufferPropertiesBuilder<'a> {
    #[inline]
    pub fn external_memory_properties(
        mut self,
        external_memory_properties: ExternalMemoryProperties,
    ) -> Self {
        self.inner.external_memory_properties = external_memory_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalBufferProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceIDProperties.html>"]
pub struct PhysicalDeviceIDProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub device_uuid: [u8; UUID_SIZE],
    pub driver_uuid: [u8; UUID_SIZE],
    pub device_luid: [u8; LUID_SIZE],
    pub device_node_mask: u32,
    pub device_luid_valid: Bool32,
}
impl ::std::default::Default for PhysicalDeviceIDProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            device_uuid: unsafe { ::std::mem::zeroed() },
            driver_uuid: unsafe { ::std::mem::zeroed() },
            device_luid: unsafe { ::std::mem::zeroed() },
            device_node_mask: u32::default(),
            device_luid_valid: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceIDProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_ID_PROPERTIES;
}
impl PhysicalDeviceIDProperties {
    pub fn builder<'a>() -> PhysicalDeviceIDPropertiesBuilder<'a> {
        PhysicalDeviceIDPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceIDPropertiesBuilder<'a> {
    inner: PhysicalDeviceIDProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceIDProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceIDPropertiesBuilder<'a> {
    type Target = PhysicalDeviceIDProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceIDPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceIDPropertiesBuilder<'a> {
    #[inline]
    pub fn device_uuid(mut self, device_uuid: [u8; UUID_SIZE]) -> Self {
        self.inner.device_uuid = device_uuid;
        self
    }
    #[inline]
    pub fn driver_uuid(mut self, driver_uuid: [u8; UUID_SIZE]) -> Self {
        self.inner.driver_uuid = driver_uuid;
        self
    }
    #[inline]
    pub fn device_luid(mut self, device_luid: [u8; LUID_SIZE]) -> Self {
        self.inner.device_luid = device_luid;
        self
    }
    #[inline]
    pub fn device_node_mask(mut self, device_node_mask: u32) -> Self {
        self.inner.device_node_mask = device_node_mask;
        self
    }
    #[inline]
    pub fn device_luid_valid(mut self, device_luid_valid: bool) -> Self {
        self.inner.device_luid_valid = device_luid_valid.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceIDProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryImageCreateInfo.html>"]
pub struct ExternalMemoryImageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExternalMemoryImageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalMemoryImageCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_IMAGE_CREATE_INFO;
}
impl ExternalMemoryImageCreateInfo {
    pub fn builder<'a>() -> ExternalMemoryImageCreateInfoBuilder<'a> {
        ExternalMemoryImageCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryImageCreateInfoBuilder<'a> {
    inner: ExternalMemoryImageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfoBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ExternalMemoryImageCreateInfo {}
impl<'a> ::std::ops::Deref for ExternalMemoryImageCreateInfoBuilder<'a> {
    type Target = ExternalMemoryImageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryImageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryImageCreateInfoBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryImageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalMemoryBufferCreateInfo.html>"]
pub struct ExternalMemoryBufferCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExternalMemoryBufferCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalMemoryBufferCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_MEMORY_BUFFER_CREATE_INFO;
}
impl ExternalMemoryBufferCreateInfo {
    pub fn builder<'a>() -> ExternalMemoryBufferCreateInfoBuilder<'a> {
        ExternalMemoryBufferCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalMemoryBufferCreateInfoBuilder<'a> {
    inner: ExternalMemoryBufferCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfoBuilder<'_> {}
unsafe impl ExtendsBufferCreateInfo for ExternalMemoryBufferCreateInfo {}
impl<'a> ::std::ops::Deref for ExternalMemoryBufferCreateInfoBuilder<'a> {
    type Target = ExternalMemoryBufferCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalMemoryBufferCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalMemoryBufferCreateInfoBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalMemoryBufferCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportMemoryAllocateInfo.html>"]
pub struct ExportMemoryAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for ExportMemoryAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExportMemoryAllocateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_ALLOCATE_INFO;
}
impl ExportMemoryAllocateInfo {
    pub fn builder<'a>() -> ExportMemoryAllocateInfoBuilder<'a> {
        ExportMemoryAllocateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryAllocateInfoBuilder<'a> {
    inner: ExportMemoryAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfoBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryAllocateInfo {}
impl<'a> ::std::ops::Deref for ExportMemoryAllocateInfoBuilder<'a> {
    type Target = ExportMemoryAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryAllocateInfoBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportMemoryWin32HandleInfoKHR.html>"]
pub struct ImportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ImportMemoryWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: unsafe { ::std::mem::zeroed() },
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ImportMemoryWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR;
}
impl ImportMemoryWin32HandleInfoKHR {
    pub fn builder<'a>() -> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
        ImportMemoryWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    inner: ImportMemoryWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    type Target = ImportMemoryWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.inner.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportMemoryWin32HandleInfoKHR.html>"]
pub struct ExportMemoryWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ExportMemoryWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ExportMemoryWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR;
}
impl ExportMemoryWin32HandleInfoKHR {
    pub fn builder<'a>() -> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
        ExportMemoryWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    inner: ExportMemoryWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ExportMemoryWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    type Target = ExportMemoryWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportMemoryWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.inner.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.inner.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportMemoryWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportMemoryZirconHandleInfoFUCHSIA.html>"]
pub struct ImportMemoryZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub handle: zx_handle_t,
}
impl ::std::default::Default for ImportMemoryZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            handle: zx_handle_t::default(),
        }
    }
}
unsafe impl TaggedStructure for ImportMemoryZirconHandleInfoFUCHSIA {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl ImportMemoryZirconHandleInfoFUCHSIA {
    pub fn builder<'a>() -> ImportMemoryZirconHandleInfoFUCHSIABuilder<'a> {
        ImportMemoryZirconHandleInfoFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryZirconHandleInfoFUCHSIABuilder<'a> {
    inner: ImportMemoryZirconHandleInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryZirconHandleInfoFUCHSIABuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryZirconHandleInfoFUCHSIA {}
impl<'a> ::std::ops::Deref for ImportMemoryZirconHandleInfoFUCHSIABuilder<'a> {
    type Target = ImportMemoryZirconHandleInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryZirconHandleInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryZirconHandleInfoFUCHSIABuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: zx_handle_t) -> Self {
        self.inner.handle = handle;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryZirconHandleInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryZirconHandlePropertiesFUCHSIA.html>"]
pub struct MemoryZirconHandlePropertiesFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
}
impl ::std::default::Default for MemoryZirconHandlePropertiesFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryZirconHandlePropertiesFUCHSIA {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ZIRCON_HANDLE_PROPERTIES_FUCHSIA;
}
impl MemoryZirconHandlePropertiesFUCHSIA {
    pub fn builder<'a>() -> MemoryZirconHandlePropertiesFUCHSIABuilder<'a> {
        MemoryZirconHandlePropertiesFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryZirconHandlePropertiesFUCHSIABuilder<'a> {
    inner: MemoryZirconHandlePropertiesFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryZirconHandlePropertiesFUCHSIABuilder<'a> {
    type Target = MemoryZirconHandlePropertiesFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryZirconHandlePropertiesFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryZirconHandlePropertiesFUCHSIABuilder<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryZirconHandlePropertiesFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryGetZirconHandleInfoFUCHSIA.html>"]
pub struct MemoryGetZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for MemoryGetZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryGetZirconHandleInfoFUCHSIA {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl MemoryGetZirconHandleInfoFUCHSIA {
    pub fn builder<'a>() -> MemoryGetZirconHandleInfoFUCHSIABuilder<'a> {
        MemoryGetZirconHandleInfoFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryGetZirconHandleInfoFUCHSIABuilder<'a> {
    inner: MemoryGetZirconHandleInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryGetZirconHandleInfoFUCHSIABuilder<'a> {
    type Target = MemoryGetZirconHandleInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryGetZirconHandleInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryGetZirconHandleInfoFUCHSIABuilder<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryGetZirconHandleInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryWin32HandlePropertiesKHR.html>"]
pub struct MemoryWin32HandlePropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
}
impl ::std::default::Default for MemoryWin32HandlePropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryWin32HandlePropertiesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_WIN32_HANDLE_PROPERTIES_KHR;
}
impl MemoryWin32HandlePropertiesKHR {
    pub fn builder<'a>() -> MemoryWin32HandlePropertiesKHRBuilder<'a> {
        MemoryWin32HandlePropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryWin32HandlePropertiesKHRBuilder<'a> {
    inner: MemoryWin32HandlePropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryWin32HandlePropertiesKHRBuilder<'a> {
    type Target = MemoryWin32HandlePropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryWin32HandlePropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryWin32HandlePropertiesKHRBuilder<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryWin32HandlePropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryGetWin32HandleInfoKHR.html>"]
pub struct MemoryGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for MemoryGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryGetWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_WIN32_HANDLE_INFO_KHR;
}
impl MemoryGetWin32HandleInfoKHR {
    pub fn builder<'a>() -> MemoryGetWin32HandleInfoKHRBuilder<'a> {
        MemoryGetWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryGetWin32HandleInfoKHRBuilder<'a> {
    inner: MemoryGetWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryGetWin32HandleInfoKHRBuilder<'a> {
    type Target = MemoryGetWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryGetWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryGetWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryGetWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportMemoryFdInfoKHR.html>"]
pub struct ImportMemoryFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalMemoryHandleTypeFlags,
    pub fd: c_int,
}
impl ::std::default::Default for ImportMemoryFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}
unsafe impl TaggedStructure for ImportMemoryFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_MEMORY_FD_INFO_KHR;
}
impl ImportMemoryFdInfoKHR {
    pub fn builder<'a>() -> ImportMemoryFdInfoKHRBuilder<'a> {
        ImportMemoryFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportMemoryFdInfoKHRBuilder<'a> {
    inner: ImportMemoryFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHRBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for ImportMemoryFdInfoKHR {}
impl<'a> ::std::ops::Deref for ImportMemoryFdInfoKHRBuilder<'a> {
    type Target = ImportMemoryFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportMemoryFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportMemoryFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.inner.fd = fd;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportMemoryFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryFdPropertiesKHR.html>"]
pub struct MemoryFdPropertiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_type_bits: u32,
}
impl ::std::default::Default for MemoryFdPropertiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_type_bits: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryFdPropertiesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_FD_PROPERTIES_KHR;
}
impl MemoryFdPropertiesKHR {
    pub fn builder<'a>() -> MemoryFdPropertiesKHRBuilder<'a> {
        MemoryFdPropertiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryFdPropertiesKHRBuilder<'a> {
    inner: MemoryFdPropertiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryFdPropertiesKHRBuilder<'a> {
    type Target = MemoryFdPropertiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryFdPropertiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryFdPropertiesKHRBuilder<'a> {
    #[inline]
    pub fn memory_type_bits(mut self, memory_type_bits: u32) -> Self {
        self.inner.memory_type_bits = memory_type_bits;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryFdPropertiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryGetFdInfoKHR.html>"]
pub struct MemoryGetFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub memory: DeviceMemory,
    pub handle_type: ExternalMemoryHandleTypeFlags,
}
impl ::std::default::Default for MemoryGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            memory: DeviceMemory::default(),
            handle_type: ExternalMemoryHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryGetFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_GET_FD_INFO_KHR;
}
impl MemoryGetFdInfoKHR {
    pub fn builder<'a>() -> MemoryGetFdInfoKHRBuilder<'a> {
        MemoryGetFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryGetFdInfoKHRBuilder<'a> {
    inner: MemoryGetFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MemoryGetFdInfoKHRBuilder<'a> {
    type Target = MemoryGetFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryGetFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryGetFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalMemoryHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryGetFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWin32KeyedMutexAcquireReleaseInfoKHR.html>"]
pub struct Win32KeyedMutexAcquireReleaseInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub acquire_count: u32,
    pub p_acquire_syncs: *const DeviceMemory,
    pub p_acquire_keys: *const u64,
    pub p_acquire_timeouts: *const u32,
    pub release_count: u32,
    pub p_release_syncs: *const DeviceMemory,
    pub p_release_keys: *const u64,
}
impl ::std::default::Default for Win32KeyedMutexAcquireReleaseInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            acquire_count: u32::default(),
            p_acquire_syncs: ::std::ptr::null(),
            p_acquire_keys: ::std::ptr::null(),
            p_acquire_timeouts: ::std::ptr::null(),
            release_count: u32::default(),
            p_release_syncs: ::std::ptr::null(),
            p_release_keys: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for Win32KeyedMutexAcquireReleaseInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR;
}
impl Win32KeyedMutexAcquireReleaseInfoKHR {
    pub fn builder<'a>() -> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
        Win32KeyedMutexAcquireReleaseInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    inner: Win32KeyedMutexAcquireReleaseInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for Win32KeyedMutexAcquireReleaseInfoKHR {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'_> {}
unsafe impl ExtendsSubmitInfo2 for Win32KeyedMutexAcquireReleaseInfoKHR {}
impl<'a> ::std::ops::Deref for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    type Target = Win32KeyedMutexAcquireReleaseInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> Win32KeyedMutexAcquireReleaseInfoKHRBuilder<'a> {
    #[inline]
    pub fn acquire_syncs(mut self, acquire_syncs: &'a [DeviceMemory]) -> Self {
        self.inner.acquire_count = acquire_syncs.len() as _;
        self.inner.p_acquire_syncs = acquire_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_keys(mut self, acquire_keys: &'a [u64]) -> Self {
        self.inner.acquire_count = acquire_keys.len() as _;
        self.inner.p_acquire_keys = acquire_keys.as_ptr();
        self
    }
    #[inline]
    pub fn acquire_timeouts(mut self, acquire_timeouts: &'a [u32]) -> Self {
        self.inner.acquire_count = acquire_timeouts.len() as _;
        self.inner.p_acquire_timeouts = acquire_timeouts.as_ptr();
        self
    }
    #[inline]
    pub fn release_syncs(mut self, release_syncs: &'a [DeviceMemory]) -> Self {
        self.inner.release_count = release_syncs.len() as _;
        self.inner.p_release_syncs = release_syncs.as_ptr();
        self
    }
    #[inline]
    pub fn release_keys(mut self, release_keys: &'a [u64]) -> Self {
        self.inner.release_count = release_keys.len() as _;
        self.inner.p_release_keys = release_keys.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> Win32KeyedMutexAcquireReleaseInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalSemaphoreInfo.html>"]
pub struct PhysicalDeviceExternalSemaphoreInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalSemaphoreInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceExternalSemaphoreInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO;
}
impl PhysicalDeviceExternalSemaphoreInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
        PhysicalDeviceExternalSemaphoreInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    inner: PhysicalDeviceExternalSemaphoreInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceExternalSemaphoreInfo {}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalSemaphoreInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalSemaphoreInfoBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceExternalSemaphoreInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalSemaphoreInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalSemaphoreProperties.html>"]
pub struct ExternalSemaphoreProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    pub external_semaphore_features: ExternalSemaphoreFeatureFlags,
}
impl ::std::default::Default for ExternalSemaphoreProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            compatible_handle_types: ExternalSemaphoreHandleTypeFlags::default(),
            external_semaphore_features: ExternalSemaphoreFeatureFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalSemaphoreProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_SEMAPHORE_PROPERTIES;
}
impl ExternalSemaphoreProperties {
    pub fn builder<'a>() -> ExternalSemaphorePropertiesBuilder<'a> {
        ExternalSemaphorePropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalSemaphorePropertiesBuilder<'a> {
    inner: ExternalSemaphoreProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalSemaphorePropertiesBuilder<'a> {
    type Target = ExternalSemaphoreProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalSemaphorePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalSemaphorePropertiesBuilder<'a> {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalSemaphoreHandleTypeFlags,
    ) -> Self {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[inline]
    pub fn external_semaphore_features(
        mut self,
        external_semaphore_features: ExternalSemaphoreFeatureFlags,
    ) -> Self {
        self.inner.external_semaphore_features = external_semaphore_features;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalSemaphoreProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportSemaphoreCreateInfo.html>"]
pub struct ExportSemaphoreCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for ExportSemaphoreCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExportSemaphoreCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_SEMAPHORE_CREATE_INFO;
}
impl ExportSemaphoreCreateInfo {
    pub fn builder<'a>() -> ExportSemaphoreCreateInfoBuilder<'a> {
        ExportSemaphoreCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportSemaphoreCreateInfoBuilder<'a> {
    inner: ExportSemaphoreCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreCreateInfoBuilder<'_> {}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreCreateInfo {}
impl<'a> ::std::ops::Deref for ExportSemaphoreCreateInfoBuilder<'a> {
    type Target = ExportSemaphoreCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportSemaphoreCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportSemaphoreCreateInfoBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportSemaphoreCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreWin32HandleInfoKHR.html>"]
pub struct ImportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ImportSemaphoreWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            handle: unsafe { ::std::mem::zeroed() },
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ImportSemaphoreWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR;
}
impl ImportSemaphoreWin32HandleInfoKHR {
    pub fn builder<'a>() -> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        ImportSemaphoreWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    inner: ImportSemaphoreWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    type Target = ImportSemaphoreWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.inner.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportSemaphoreWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportSemaphoreWin32HandleInfoKHR.html>"]
pub struct ExportSemaphoreWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ExportSemaphoreWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ExportSemaphoreWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR;
}
impl ExportSemaphoreWin32HandleInfoKHR {
    pub fn builder<'a>() -> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
        ExportSemaphoreWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    inner: ExportSemaphoreWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsSemaphoreCreateInfo for ExportSemaphoreWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    type Target = ExportSemaphoreWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportSemaphoreWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.inner.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.inner.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportSemaphoreWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkD3D12FenceSubmitInfoKHR.html>"]
pub struct D3D12FenceSubmitInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_values_count: u32,
    pub p_wait_semaphore_values: *const u64,
    pub signal_semaphore_values_count: u32,
    pub p_signal_semaphore_values: *const u64,
}
impl ::std::default::Default for D3D12FenceSubmitInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            wait_semaphore_values_count: u32::default(),
            p_wait_semaphore_values: ::std::ptr::null(),
            signal_semaphore_values_count: u32::default(),
            p_signal_semaphore_values: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for D3D12FenceSubmitInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::D3D12_FENCE_SUBMIT_INFO_KHR;
}
impl D3D12FenceSubmitInfoKHR {
    pub fn builder<'a>() -> D3D12FenceSubmitInfoKHRBuilder<'a> {
        D3D12FenceSubmitInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct D3D12FenceSubmitInfoKHRBuilder<'a> {
    inner: D3D12FenceSubmitInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for D3D12FenceSubmitInfoKHRBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for D3D12FenceSubmitInfoKHR {}
impl<'a> ::std::ops::Deref for D3D12FenceSubmitInfoKHRBuilder<'a> {
    type Target = D3D12FenceSubmitInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for D3D12FenceSubmitInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> D3D12FenceSubmitInfoKHRBuilder<'a> {
    #[inline]
    pub fn wait_semaphore_values(mut self, wait_semaphore_values: &'a [u64]) -> Self {
        self.inner.wait_semaphore_values_count = wait_semaphore_values.len() as _;
        self.inner.p_wait_semaphore_values = wait_semaphore_values.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphore_values(mut self, signal_semaphore_values: &'a [u64]) -> Self {
        self.inner.signal_semaphore_values_count = signal_semaphore_values.len() as _;
        self.inner.p_signal_semaphore_values = signal_semaphore_values.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> D3D12FenceSubmitInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetWin32HandleInfoKHR.html>"]
pub struct SemaphoreGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for SemaphoreGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for SemaphoreGetWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR;
}
impl SemaphoreGetWin32HandleInfoKHR {
    pub fn builder<'a>() -> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
        SemaphoreGetWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    inner: SemaphoreGetWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    type Target = SemaphoreGetWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreGetWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreGetWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreFdInfoKHR.html>"]
pub struct ImportSemaphoreFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub fd: c_int,
}
impl ::std::default::Default for ImportSemaphoreFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}
unsafe impl TaggedStructure for ImportSemaphoreFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_SEMAPHORE_FD_INFO_KHR;
}
impl ImportSemaphoreFdInfoKHR {
    pub fn builder<'a>() -> ImportSemaphoreFdInfoKHRBuilder<'a> {
        ImportSemaphoreFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportSemaphoreFdInfoKHRBuilder<'a> {
    inner: ImportSemaphoreFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImportSemaphoreFdInfoKHRBuilder<'a> {
    type Target = ImportSemaphoreFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportSemaphoreFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportSemaphoreFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.inner.fd = fd;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportSemaphoreFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetFdInfoKHR.html>"]
pub struct SemaphoreGetFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for SemaphoreGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for SemaphoreGetFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_FD_INFO_KHR;
}
impl SemaphoreGetFdInfoKHR {
    pub fn builder<'a>() -> SemaphoreGetFdInfoKHRBuilder<'a> {
        SemaphoreGetFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreGetFdInfoKHRBuilder<'a> {
    inner: SemaphoreGetFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SemaphoreGetFdInfoKHRBuilder<'a> {
    type Target = SemaphoreGetFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreGetFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreGetFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreGetFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportSemaphoreZirconHandleInfoFUCHSIA.html>"]
pub struct ImportSemaphoreZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub flags: SemaphoreImportFlags,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
    pub zircon_handle: zx_handle_t,
}
impl ::std::default::Default for ImportSemaphoreZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            flags: SemaphoreImportFlags::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
            zircon_handle: zx_handle_t::default(),
        }
    }
}
unsafe impl TaggedStructure for ImportSemaphoreZirconHandleInfoFUCHSIA {
    const STRUCTURE_TYPE: StructureType =
        StructureType::IMPORT_SEMAPHORE_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl ImportSemaphoreZirconHandleInfoFUCHSIA {
    pub fn builder<'a>() -> ImportSemaphoreZirconHandleInfoFUCHSIABuilder<'a> {
        ImportSemaphoreZirconHandleInfoFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportSemaphoreZirconHandleInfoFUCHSIABuilder<'a> {
    inner: ImportSemaphoreZirconHandleInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImportSemaphoreZirconHandleInfoFUCHSIABuilder<'a> {
    type Target = ImportSemaphoreZirconHandleInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportSemaphoreZirconHandleInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportSemaphoreZirconHandleInfoFUCHSIABuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: SemaphoreImportFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn zircon_handle(mut self, zircon_handle: zx_handle_t) -> Self {
        self.inner.zircon_handle = zircon_handle;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportSemaphoreZirconHandleInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSemaphoreGetZirconHandleInfoFUCHSIA.html>"]
pub struct SemaphoreGetZirconHandleInfoFUCHSIA {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub semaphore: Semaphore,
    pub handle_type: ExternalSemaphoreHandleTypeFlags,
}
impl ::std::default::Default for SemaphoreGetZirconHandleInfoFUCHSIA {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            semaphore: Semaphore::default(),
            handle_type: ExternalSemaphoreHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for SemaphoreGetZirconHandleInfoFUCHSIA {
    const STRUCTURE_TYPE: StructureType = StructureType::SEMAPHORE_GET_ZIRCON_HANDLE_INFO_FUCHSIA;
}
impl SemaphoreGetZirconHandleInfoFUCHSIA {
    pub fn builder<'a>() -> SemaphoreGetZirconHandleInfoFUCHSIABuilder<'a> {
        SemaphoreGetZirconHandleInfoFUCHSIABuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SemaphoreGetZirconHandleInfoFUCHSIABuilder<'a> {
    inner: SemaphoreGetZirconHandleInfoFUCHSIA,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SemaphoreGetZirconHandleInfoFUCHSIABuilder<'a> {
    type Target = SemaphoreGetZirconHandleInfoFUCHSIA;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SemaphoreGetZirconHandleInfoFUCHSIABuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SemaphoreGetZirconHandleInfoFUCHSIABuilder<'a> {
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalSemaphoreHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SemaphoreGetZirconHandleInfoFUCHSIA {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceExternalFenceInfo.html>"]
pub struct PhysicalDeviceExternalFenceInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_type: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for PhysicalDeviceExternalFenceInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceExternalFenceInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO;
}
impl PhysicalDeviceExternalFenceInfo {
    pub fn builder<'a>() -> PhysicalDeviceExternalFenceInfoBuilder<'a> {
        PhysicalDeviceExternalFenceInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceExternalFenceInfoBuilder<'a> {
    inner: PhysicalDeviceExternalFenceInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceExternalFenceInfoBuilder<'a> {
    type Target = PhysicalDeviceExternalFenceInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceExternalFenceInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceExternalFenceInfoBuilder<'a> {
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceExternalFenceInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExternalFenceProperties.html>"]
pub struct ExternalFenceProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    pub compatible_handle_types: ExternalFenceHandleTypeFlags,
    pub external_fence_features: ExternalFenceFeatureFlags,
}
impl ::std::default::Default for ExternalFenceProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            export_from_imported_handle_types: ExternalFenceHandleTypeFlags::default(),
            compatible_handle_types: ExternalFenceHandleTypeFlags::default(),
            external_fence_features: ExternalFenceFeatureFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExternalFenceProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::EXTERNAL_FENCE_PROPERTIES;
}
impl ExternalFenceProperties {
    pub fn builder<'a>() -> ExternalFencePropertiesBuilder<'a> {
        ExternalFencePropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExternalFencePropertiesBuilder<'a> {
    inner: ExternalFenceProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ExternalFencePropertiesBuilder<'a> {
    type Target = ExternalFenceProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExternalFencePropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExternalFencePropertiesBuilder<'a> {
    #[inline]
    pub fn export_from_imported_handle_types(
        mut self,
        export_from_imported_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.inner.export_from_imported_handle_types = export_from_imported_handle_types;
        self
    }
    #[inline]
    pub fn compatible_handle_types(
        mut self,
        compatible_handle_types: ExternalFenceHandleTypeFlags,
    ) -> Self {
        self.inner.compatible_handle_types = compatible_handle_types;
        self
    }
    #[inline]
    pub fn external_fence_features(
        mut self,
        external_fence_features: ExternalFenceFeatureFlags,
    ) -> Self {
        self.inner.external_fence_features = external_fence_features;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExternalFenceProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportFenceCreateInfo.html>"]
pub struct ExportFenceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub handle_types: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for ExportFenceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            handle_types: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ExportFenceCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_FENCE_CREATE_INFO;
}
impl ExportFenceCreateInfo {
    pub fn builder<'a>() -> ExportFenceCreateInfoBuilder<'a> {
        ExportFenceCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportFenceCreateInfoBuilder<'a> {
    inner: ExportFenceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfoBuilder<'_> {}
unsafe impl ExtendsFenceCreateInfo for ExportFenceCreateInfo {}
impl<'a> ::std::ops::Deref for ExportFenceCreateInfoBuilder<'a> {
    type Target = ExportFenceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportFenceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportFenceCreateInfoBuilder<'a> {
    #[inline]
    pub fn handle_types(mut self, handle_types: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_types = handle_types;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportFenceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportFenceWin32HandleInfoKHR.html>"]
pub struct ImportFenceWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub handle: HANDLE,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ImportFenceWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            handle: unsafe { ::std::mem::zeroed() },
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ImportFenceWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_FENCE_WIN32_HANDLE_INFO_KHR;
}
impl ImportFenceWin32HandleInfoKHR {
    pub fn builder<'a>() -> ImportFenceWin32HandleInfoKHRBuilder<'a> {
        ImportFenceWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportFenceWin32HandleInfoKHRBuilder<'a> {
    inner: ImportFenceWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImportFenceWin32HandleInfoKHRBuilder<'a> {
    type Target = ImportFenceWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportFenceWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportFenceWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.inner.fence = fence;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn handle(mut self, handle: HANDLE) -> Self {
        self.inner.handle = handle;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportFenceWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkExportFenceWin32HandleInfoKHR.html>"]
pub struct ExportFenceWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_attributes: *const SECURITY_ATTRIBUTES,
    pub dw_access: DWORD,
    pub name: LPCWSTR,
}
impl ::std::default::Default for ExportFenceWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_attributes: ::std::ptr::null(),
            dw_access: DWORD::default(),
            name: unsafe { ::std::mem::zeroed() },
        }
    }
}
unsafe impl TaggedStructure for ExportFenceWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::EXPORT_FENCE_WIN32_HANDLE_INFO_KHR;
}
impl ExportFenceWin32HandleInfoKHR {
    pub fn builder<'a>() -> ExportFenceWin32HandleInfoKHRBuilder<'a> {
        ExportFenceWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ExportFenceWin32HandleInfoKHRBuilder<'a> {
    inner: ExportFenceWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsFenceCreateInfo for ExportFenceWin32HandleInfoKHRBuilder<'_> {}
unsafe impl ExtendsFenceCreateInfo for ExportFenceWin32HandleInfoKHR {}
impl<'a> ::std::ops::Deref for ExportFenceWin32HandleInfoKHRBuilder<'a> {
    type Target = ExportFenceWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ExportFenceWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ExportFenceWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn attributes(mut self, attributes: &'a SECURITY_ATTRIBUTES) -> Self {
        self.inner.p_attributes = attributes;
        self
    }
    #[inline]
    pub fn dw_access(mut self, dw_access: DWORD) -> Self {
        self.inner.dw_access = dw_access;
        self
    }
    #[inline]
    pub fn name(mut self, name: LPCWSTR) -> Self {
        self.inner.name = name;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ExportFenceWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFenceGetWin32HandleInfoKHR.html>"]
pub struct FenceGetWin32HandleInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for FenceGetWin32HandleInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for FenceGetWin32HandleInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_GET_WIN32_HANDLE_INFO_KHR;
}
impl FenceGetWin32HandleInfoKHR {
    pub fn builder<'a>() -> FenceGetWin32HandleInfoKHRBuilder<'a> {
        FenceGetWin32HandleInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FenceGetWin32HandleInfoKHRBuilder<'a> {
    inner: FenceGetWin32HandleInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for FenceGetWin32HandleInfoKHRBuilder<'a> {
    type Target = FenceGetWin32HandleInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FenceGetWin32HandleInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FenceGetWin32HandleInfoKHRBuilder<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.inner.fence = fence;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FenceGetWin32HandleInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImportFenceFdInfoKHR.html>"]
pub struct ImportFenceFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub flags: FenceImportFlags,
    pub handle_type: ExternalFenceHandleTypeFlags,
    pub fd: c_int,
}
impl ::std::default::Default for ImportFenceFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            fence: Fence::default(),
            flags: FenceImportFlags::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
            fd: c_int::default(),
        }
    }
}
unsafe impl TaggedStructure for ImportFenceFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMPORT_FENCE_FD_INFO_KHR;
}
impl ImportFenceFdInfoKHR {
    pub fn builder<'a>() -> ImportFenceFdInfoKHRBuilder<'a> {
        ImportFenceFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImportFenceFdInfoKHRBuilder<'a> {
    inner: ImportFenceFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImportFenceFdInfoKHRBuilder<'a> {
    type Target = ImportFenceFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImportFenceFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImportFenceFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.inner.fence = fence;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: FenceImportFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[inline]
    pub fn fd(mut self, fd: c_int) -> Self {
        self.inner.fd = fd;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImportFenceFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkFenceGetFdInfoKHR.html>"]
pub struct FenceGetFdInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub fence: Fence,
    pub handle_type: ExternalFenceHandleTypeFlags,
}
impl ::std::default::Default for FenceGetFdInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            fence: Fence::default(),
            handle_type: ExternalFenceHandleTypeFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for FenceGetFdInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::FENCE_GET_FD_INFO_KHR;
}
impl FenceGetFdInfoKHR {
    pub fn builder<'a>() -> FenceGetFdInfoKHRBuilder<'a> {
        FenceGetFdInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct FenceGetFdInfoKHRBuilder<'a> {
    inner: FenceGetFdInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for FenceGetFdInfoKHRBuilder<'a> {
    type Target = FenceGetFdInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for FenceGetFdInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> FenceGetFdInfoKHRBuilder<'a> {
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.inner.fence = fence;
        self
    }
    #[inline]
    pub fn handle_type(mut self, handle_type: ExternalFenceHandleTypeFlags) -> Self {
        self.inner.handle_type = handle_type;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> FenceGetFdInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewFeatures.html>"]
pub struct PhysicalDeviceMultiviewFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub multiview: Bool32,
    pub multiview_geometry_shader: Bool32,
    pub multiview_tessellation_shader: Bool32,
}
impl ::std::default::Default for PhysicalDeviceMultiviewFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            multiview: Bool32::default(),
            multiview_geometry_shader: Bool32::default(),
            multiview_tessellation_shader: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMultiviewFeatures {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTIVIEW_FEATURES;
}
impl PhysicalDeviceMultiviewFeatures {
    pub fn builder<'a>() -> PhysicalDeviceMultiviewFeaturesBuilder<'a> {
        PhysicalDeviceMultiviewFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMultiviewFeaturesBuilder<'a> {
    inner: PhysicalDeviceMultiviewFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiviewFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiviewFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiviewFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiviewFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMultiviewFeaturesBuilder<'a> {
    type Target = PhysicalDeviceMultiviewFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMultiviewFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMultiviewFeaturesBuilder<'a> {
    #[inline]
    pub fn multiview(mut self, multiview: bool) -> Self {
        self.inner.multiview = multiview.into();
        self
    }
    #[inline]
    pub fn multiview_geometry_shader(mut self, multiview_geometry_shader: bool) -> Self {
        self.inner.multiview_geometry_shader = multiview_geometry_shader.into();
        self
    }
    #[inline]
    pub fn multiview_tessellation_shader(mut self, multiview_tessellation_shader: bool) -> Self {
        self.inner.multiview_tessellation_shader = multiview_tessellation_shader.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMultiviewFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewProperties.html>"]
pub struct PhysicalDeviceMultiviewProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_multiview_view_count: u32,
    pub max_multiview_instance_index: u32,
}
impl ::std::default::Default for PhysicalDeviceMultiviewProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_multiview_view_count: u32::default(),
            max_multiview_instance_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMultiviewProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES;
}
impl PhysicalDeviceMultiviewProperties {
    pub fn builder<'a>() -> PhysicalDeviceMultiviewPropertiesBuilder<'a> {
        PhysicalDeviceMultiviewPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMultiviewPropertiesBuilder<'a> {
    inner: PhysicalDeviceMultiviewProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiviewPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMultiviewProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMultiviewPropertiesBuilder<'a> {
    type Target = PhysicalDeviceMultiviewProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMultiviewPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMultiviewPropertiesBuilder<'a> {
    #[inline]
    pub fn max_multiview_view_count(mut self, max_multiview_view_count: u32) -> Self {
        self.inner.max_multiview_view_count = max_multiview_view_count;
        self
    }
    #[inline]
    pub fn max_multiview_instance_index(mut self, max_multiview_instance_index: u32) -> Self {
        self.inner.max_multiview_instance_index = max_multiview_instance_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMultiviewProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPassMultiviewCreateInfo.html>"]
pub struct RenderPassMultiviewCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub subpass_count: u32,
    pub p_view_masks: *const u32,
    pub dependency_count: u32,
    pub p_view_offsets: *const i32,
    pub correlation_mask_count: u32,
    pub p_correlation_masks: *const u32,
}
impl ::std::default::Default for RenderPassMultiviewCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            subpass_count: u32::default(),
            p_view_masks: ::std::ptr::null(),
            dependency_count: u32::default(),
            p_view_offsets: ::std::ptr::null(),
            correlation_mask_count: u32::default(),
            p_correlation_masks: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for RenderPassMultiviewCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::RENDER_PASS_MULTIVIEW_CREATE_INFO;
}
impl RenderPassMultiviewCreateInfo {
    pub fn builder<'a>() -> RenderPassMultiviewCreateInfoBuilder<'a> {
        RenderPassMultiviewCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassMultiviewCreateInfoBuilder<'a> {
    inner: RenderPassMultiviewCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassMultiviewCreateInfoBuilder<'_> {}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassMultiviewCreateInfo {}
impl<'a> ::std::ops::Deref for RenderPassMultiviewCreateInfoBuilder<'a> {
    type Target = RenderPassMultiviewCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassMultiviewCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassMultiviewCreateInfoBuilder<'a> {
    #[inline]
    pub fn view_masks(mut self, view_masks: &'a [u32]) -> Self {
        self.inner.subpass_count = view_masks.len() as _;
        self.inner.p_view_masks = view_masks.as_ptr();
        self
    }
    #[inline]
    pub fn view_offsets(mut self, view_offsets: &'a [i32]) -> Self {
        self.inner.dependency_count = view_offsets.len() as _;
        self.inner.p_view_offsets = view_offsets.as_ptr();
        self
    }
    #[inline]
    pub fn correlation_masks(mut self, correlation_masks: &'a [u32]) -> Self {
        self.inner.correlation_mask_count = correlation_masks.len() as _;
        self.inner.p_correlation_masks = correlation_masks.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassMultiviewCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilities2EXT.html>"]
pub struct SurfaceCapabilities2EXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub min_image_count: u32,
    pub max_image_count: u32,
    pub current_extent: Extent2D,
    pub min_image_extent: Extent2D,
    pub max_image_extent: Extent2D,
    pub max_image_array_layers: u32,
    pub supported_transforms: SurfaceTransformFlagsKHR,
    pub current_transform: SurfaceTransformFlagsKHR,
    pub supported_composite_alpha: CompositeAlphaFlagsKHR,
    pub supported_usage_flags: ImageUsageFlags,
    pub supported_surface_counters: SurfaceCounterFlagsEXT,
}
impl ::std::default::Default for SurfaceCapabilities2EXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            min_image_count: u32::default(),
            max_image_count: u32::default(),
            current_extent: Extent2D::default(),
            min_image_extent: Extent2D::default(),
            max_image_extent: Extent2D::default(),
            max_image_array_layers: u32::default(),
            supported_transforms: SurfaceTransformFlagsKHR::default(),
            current_transform: SurfaceTransformFlagsKHR::default(),
            supported_composite_alpha: CompositeAlphaFlagsKHR::default(),
            supported_usage_flags: ImageUsageFlags::default(),
            supported_surface_counters: SurfaceCounterFlagsEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for SurfaceCapabilities2EXT {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_CAPABILITIES_2_EXT;
}
impl SurfaceCapabilities2EXT {
    pub fn builder<'a>() -> SurfaceCapabilities2EXTBuilder<'a> {
        SurfaceCapabilities2EXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceCapabilities2EXTBuilder<'a> {
    inner: SurfaceCapabilities2EXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SurfaceCapabilities2EXTBuilder<'a> {
    type Target = SurfaceCapabilities2EXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceCapabilities2EXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceCapabilities2EXTBuilder<'a> {
    #[inline]
    pub fn min_image_count(mut self, min_image_count: u32) -> Self {
        self.inner.min_image_count = min_image_count;
        self
    }
    #[inline]
    pub fn max_image_count(mut self, max_image_count: u32) -> Self {
        self.inner.max_image_count = max_image_count;
        self
    }
    #[inline]
    pub fn current_extent(mut self, current_extent: Extent2D) -> Self {
        self.inner.current_extent = current_extent;
        self
    }
    #[inline]
    pub fn min_image_extent(mut self, min_image_extent: Extent2D) -> Self {
        self.inner.min_image_extent = min_image_extent;
        self
    }
    #[inline]
    pub fn max_image_extent(mut self, max_image_extent: Extent2D) -> Self {
        self.inner.max_image_extent = max_image_extent;
        self
    }
    #[inline]
    pub fn max_image_array_layers(mut self, max_image_array_layers: u32) -> Self {
        self.inner.max_image_array_layers = max_image_array_layers;
        self
    }
    #[inline]
    pub fn supported_transforms(mut self, supported_transforms: SurfaceTransformFlagsKHR) -> Self {
        self.inner.supported_transforms = supported_transforms;
        self
    }
    #[inline]
    pub fn current_transform(mut self, current_transform: SurfaceTransformFlagsKHR) -> Self {
        self.inner.current_transform = current_transform;
        self
    }
    #[inline]
    pub fn supported_composite_alpha(
        mut self,
        supported_composite_alpha: CompositeAlphaFlagsKHR,
    ) -> Self {
        self.inner.supported_composite_alpha = supported_composite_alpha;
        self
    }
    #[inline]
    pub fn supported_usage_flags(mut self, supported_usage_flags: ImageUsageFlags) -> Self {
        self.inner.supported_usage_flags = supported_usage_flags;
        self
    }
    #[inline]
    pub fn supported_surface_counters(
        mut self,
        supported_surface_counters: SurfaceCounterFlagsEXT,
    ) -> Self {
        self.inner.supported_surface_counters = supported_surface_counters;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceCapabilities2EXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPowerInfoEXT.html>"]
pub struct DisplayPowerInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub power_state: DisplayPowerStateEXT,
}
impl ::std::default::Default for DisplayPowerInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            power_state: DisplayPowerStateEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayPowerInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_POWER_INFO_EXT;
}
impl DisplayPowerInfoEXT {
    pub fn builder<'a>() -> DisplayPowerInfoEXTBuilder<'a> {
        DisplayPowerInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPowerInfoEXTBuilder<'a> {
    inner: DisplayPowerInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPowerInfoEXTBuilder<'a> {
    type Target = DisplayPowerInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPowerInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPowerInfoEXTBuilder<'a> {
    #[inline]
    pub fn power_state(mut self, power_state: DisplayPowerStateEXT) -> Self {
        self.inner.power_state = power_state;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPowerInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceEventInfoEXT.html>"]
pub struct DeviceEventInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_event: DeviceEventTypeEXT,
}
impl ::std::default::Default for DeviceEventInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            device_event: DeviceEventTypeEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceEventInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_EVENT_INFO_EXT;
}
impl DeviceEventInfoEXT {
    pub fn builder<'a>() -> DeviceEventInfoEXTBuilder<'a> {
        DeviceEventInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceEventInfoEXTBuilder<'a> {
    inner: DeviceEventInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DeviceEventInfoEXTBuilder<'a> {
    type Target = DeviceEventInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceEventInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceEventInfoEXTBuilder<'a> {
    #[inline]
    pub fn device_event(mut self, device_event: DeviceEventTypeEXT) -> Self {
        self.inner.device_event = device_event;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceEventInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayEventInfoEXT.html>"]
pub struct DisplayEventInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub display_event: DisplayEventTypeEXT,
}
impl ::std::default::Default for DisplayEventInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            display_event: DisplayEventTypeEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayEventInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_EVENT_INFO_EXT;
}
impl DisplayEventInfoEXT {
    pub fn builder<'a>() -> DisplayEventInfoEXTBuilder<'a> {
        DisplayEventInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayEventInfoEXTBuilder<'a> {
    inner: DisplayEventInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayEventInfoEXTBuilder<'a> {
    type Target = DisplayEventInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayEventInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayEventInfoEXTBuilder<'a> {
    #[inline]
    pub fn display_event(mut self, display_event: DisplayEventTypeEXT) -> Self {
        self.inner.display_event = display_event;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayEventInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSwapchainCounterCreateInfoEXT.html>"]
pub struct SwapchainCounterCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub surface_counters: SurfaceCounterFlagsEXT,
}
impl ::std::default::Default for SwapchainCounterCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            surface_counters: SurfaceCounterFlagsEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for SwapchainCounterCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::SWAPCHAIN_COUNTER_CREATE_INFO_EXT;
}
impl SwapchainCounterCreateInfoEXT {
    pub fn builder<'a>() -> SwapchainCounterCreateInfoEXTBuilder<'a> {
        SwapchainCounterCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SwapchainCounterCreateInfoEXTBuilder<'a> {
    inner: SwapchainCounterCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainCounterCreateInfoEXTBuilder<'_> {}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainCounterCreateInfoEXT {}
impl<'a> ::std::ops::Deref for SwapchainCounterCreateInfoEXTBuilder<'a> {
    type Target = SwapchainCounterCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SwapchainCounterCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SwapchainCounterCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn surface_counters(mut self, surface_counters: SurfaceCounterFlagsEXT) -> Self {
        self.inner.surface_counters = surface_counters;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SwapchainCounterCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceGroupProperties.html>"]
pub struct PhysicalDeviceGroupProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub physical_device_count: u32,
    pub physical_devices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE],
    pub subset_allocation: Bool32,
}
impl ::std::default::Default for PhysicalDeviceGroupProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            physical_device_count: u32::default(),
            physical_devices: unsafe { ::std::mem::zeroed() },
            subset_allocation: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceGroupProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_GROUP_PROPERTIES;
}
impl PhysicalDeviceGroupProperties {
    pub fn builder<'a>() -> PhysicalDeviceGroupPropertiesBuilder<'a> {
        PhysicalDeviceGroupPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceGroupPropertiesBuilder<'a> {
    inner: PhysicalDeviceGroupProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PhysicalDeviceGroupPropertiesBuilder<'a> {
    type Target = PhysicalDeviceGroupProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceGroupPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceGroupPropertiesBuilder<'a> {
    #[inline]
    pub fn physical_device_count(mut self, physical_device_count: u32) -> Self {
        self.inner.physical_device_count = physical_device_count;
        self
    }
    #[inline]
    pub fn physical_devices(
        mut self,
        physical_devices: [PhysicalDevice; MAX_DEVICE_GROUP_SIZE],
    ) -> Self {
        self.inner.physical_devices = physical_devices;
        self
    }
    #[inline]
    pub fn subset_allocation(mut self, subset_allocation: bool) -> Self {
        self.inner.subset_allocation = subset_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceGroupProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryAllocateFlagsInfo.html>"]
pub struct MemoryAllocateFlagsInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MemoryAllocateFlags,
    pub device_mask: u32,
}
impl ::std::default::Default for MemoryAllocateFlagsInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: MemoryAllocateFlags::default(),
            device_mask: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryAllocateFlagsInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_ALLOCATE_FLAGS_INFO;
}
impl MemoryAllocateFlagsInfo {
    pub fn builder<'a>() -> MemoryAllocateFlagsInfoBuilder<'a> {
        MemoryAllocateFlagsInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryAllocateFlagsInfoBuilder<'a> {
    inner: MemoryAllocateFlagsInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for MemoryAllocateFlagsInfoBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryAllocateFlagsInfo {}
impl<'a> ::std::ops::Deref for MemoryAllocateFlagsInfoBuilder<'a> {
    type Target = MemoryAllocateFlagsInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryAllocateFlagsInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryAllocateFlagsInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: MemoryAllocateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.inner.device_mask = device_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryAllocateFlagsInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindBufferMemoryInfo.html>"]
pub struct BindBufferMemoryInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
}
impl ::std::default::Default for BindBufferMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            buffer: Buffer::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for BindBufferMemoryInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_BUFFER_MEMORY_INFO;
}
impl BindBufferMemoryInfo {
    pub fn builder<'a>() -> BindBufferMemoryInfoBuilder<'a> {
        BindBufferMemoryInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindBufferMemoryInfoBuilder<'a> {
    inner: BindBufferMemoryInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBindBufferMemoryInfo {}
impl<'a> ::std::ops::Deref for BindBufferMemoryInfoBuilder<'a> {
    type Target = BindBufferMemoryInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindBufferMemoryInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindBufferMemoryInfoBuilder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.inner.memory_offset = memory_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindBufferMemoryInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindBufferMemoryInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindBufferMemoryDeviceGroupInfo.html>"]
pub struct BindBufferMemoryDeviceGroupInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_index_count: u32,
    pub p_device_indices: *const u32,
}
impl ::std::default::Default for BindBufferMemoryDeviceGroupInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            device_index_count: u32::default(),
            p_device_indices: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for BindBufferMemoryDeviceGroupInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO;
}
impl BindBufferMemoryDeviceGroupInfo {
    pub fn builder<'a>() -> BindBufferMemoryDeviceGroupInfoBuilder<'a> {
        BindBufferMemoryDeviceGroupInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindBufferMemoryDeviceGroupInfoBuilder<'a> {
    inner: BindBufferMemoryDeviceGroupInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBindBufferMemoryInfo for BindBufferMemoryDeviceGroupInfoBuilder<'_> {}
unsafe impl ExtendsBindBufferMemoryInfo for BindBufferMemoryDeviceGroupInfo {}
impl<'a> ::std::ops::Deref for BindBufferMemoryDeviceGroupInfoBuilder<'a> {
    type Target = BindBufferMemoryDeviceGroupInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindBufferMemoryDeviceGroupInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindBufferMemoryDeviceGroupInfoBuilder<'a> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'a [u32]) -> Self {
        self.inner.device_index_count = device_indices.len() as _;
        self.inner.p_device_indices = device_indices.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindBufferMemoryDeviceGroupInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindImageMemoryInfo.html>"]
pub struct BindImageMemoryInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub memory: DeviceMemory,
    pub memory_offset: DeviceSize,
}
impl ::std::default::Default for BindImageMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            image: Image::default(),
            memory: DeviceMemory::default(),
            memory_offset: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for BindImageMemoryInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_INFO;
}
impl BindImageMemoryInfo {
    pub fn builder<'a>() -> BindImageMemoryInfoBuilder<'a> {
        BindImageMemoryInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindImageMemoryInfoBuilder<'a> {
    inner: BindImageMemoryInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsBindImageMemoryInfo {}
impl<'a> ::std::ops::Deref for BindImageMemoryInfoBuilder<'a> {
    type Target = BindImageMemoryInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindImageMemoryInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindImageMemoryInfoBuilder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn memory(mut self, memory: DeviceMemory) -> Self {
        self.inner.memory = memory;
        self
    }
    #[inline]
    pub fn memory_offset(mut self, memory_offset: DeviceSize) -> Self {
        self.inner.memory_offset = memory_offset;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsBindImageMemoryInfo>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindImageMemoryInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindImageMemoryDeviceGroupInfo.html>"]
pub struct BindImageMemoryDeviceGroupInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_index_count: u32,
    pub p_device_indices: *const u32,
    pub split_instance_bind_region_count: u32,
    pub p_split_instance_bind_regions: *const Rect2D,
}
impl ::std::default::Default for BindImageMemoryDeviceGroupInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            device_index_count: u32::default(),
            p_device_indices: ::std::ptr::null(),
            split_instance_bind_region_count: u32::default(),
            p_split_instance_bind_regions: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for BindImageMemoryDeviceGroupInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO;
}
impl BindImageMemoryDeviceGroupInfo {
    pub fn builder<'a>() -> BindImageMemoryDeviceGroupInfoBuilder<'a> {
        BindImageMemoryDeviceGroupInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindImageMemoryDeviceGroupInfoBuilder<'a> {
    inner: BindImageMemoryDeviceGroupInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemoryDeviceGroupInfoBuilder<'_> {}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemoryDeviceGroupInfo {}
impl<'a> ::std::ops::Deref for BindImageMemoryDeviceGroupInfoBuilder<'a> {
    type Target = BindImageMemoryDeviceGroupInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindImageMemoryDeviceGroupInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindImageMemoryDeviceGroupInfoBuilder<'a> {
    #[inline]
    pub fn device_indices(mut self, device_indices: &'a [u32]) -> Self {
        self.inner.device_index_count = device_indices.len() as _;
        self.inner.p_device_indices = device_indices.as_ptr();
        self
    }
    #[inline]
    pub fn split_instance_bind_regions(
        mut self,
        split_instance_bind_regions: &'a [Rect2D],
    ) -> Self {
        self.inner.split_instance_bind_region_count = split_instance_bind_regions.len() as _;
        self.inner.p_split_instance_bind_regions = split_instance_bind_regions.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindImageMemoryDeviceGroupInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupRenderPassBeginInfo.html>"]
pub struct DeviceGroupRenderPassBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_mask: u32,
    pub device_render_area_count: u32,
    pub p_device_render_areas: *const Rect2D,
}
impl ::std::default::Default for DeviceGroupRenderPassBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            device_mask: u32::default(),
            device_render_area_count: u32::default(),
            p_device_render_areas: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupRenderPassBeginInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_RENDER_PASS_BEGIN_INFO;
}
impl DeviceGroupRenderPassBeginInfo {
    pub fn builder<'a>() -> DeviceGroupRenderPassBeginInfoBuilder<'a> {
        DeviceGroupRenderPassBeginInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupRenderPassBeginInfoBuilder<'a> {
    inner: DeviceGroupRenderPassBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsRenderPassBeginInfo for DeviceGroupRenderPassBeginInfoBuilder<'_> {}
unsafe impl ExtendsRenderPassBeginInfo for DeviceGroupRenderPassBeginInfo {}
unsafe impl ExtendsRenderingInfo for DeviceGroupRenderPassBeginInfoBuilder<'_> {}
unsafe impl ExtendsRenderingInfo for DeviceGroupRenderPassBeginInfo {}
impl<'a> ::std::ops::Deref for DeviceGroupRenderPassBeginInfoBuilder<'a> {
    type Target = DeviceGroupRenderPassBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupRenderPassBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupRenderPassBeginInfoBuilder<'a> {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.inner.device_mask = device_mask;
        self
    }
    #[inline]
    pub fn device_render_areas(mut self, device_render_areas: &'a [Rect2D]) -> Self {
        self.inner.device_render_area_count = device_render_areas.len() as _;
        self.inner.p_device_render_areas = device_render_areas.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupRenderPassBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupCommandBufferBeginInfo.html>"]
pub struct DeviceGroupCommandBufferBeginInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub device_mask: u32,
}
impl ::std::default::Default for DeviceGroupCommandBufferBeginInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            device_mask: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupCommandBufferBeginInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO;
}
impl DeviceGroupCommandBufferBeginInfo {
    pub fn builder<'a>() -> DeviceGroupCommandBufferBeginInfoBuilder<'a> {
        DeviceGroupCommandBufferBeginInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupCommandBufferBeginInfoBuilder<'a> {
    inner: DeviceGroupCommandBufferBeginInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsCommandBufferBeginInfo for DeviceGroupCommandBufferBeginInfoBuilder<'_> {}
unsafe impl ExtendsCommandBufferBeginInfo for DeviceGroupCommandBufferBeginInfo {}
impl<'a> ::std::ops::Deref for DeviceGroupCommandBufferBeginInfoBuilder<'a> {
    type Target = DeviceGroupCommandBufferBeginInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupCommandBufferBeginInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupCommandBufferBeginInfoBuilder<'a> {
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.inner.device_mask = device_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupCommandBufferBeginInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupSubmitInfo.html>"]
pub struct DeviceGroupSubmitInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub wait_semaphore_count: u32,
    pub p_wait_semaphore_device_indices: *const u32,
    pub command_buffer_count: u32,
    pub p_command_buffer_device_masks: *const u32,
    pub signal_semaphore_count: u32,
    pub p_signal_semaphore_device_indices: *const u32,
}
impl ::std::default::Default for DeviceGroupSubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            wait_semaphore_count: u32::default(),
            p_wait_semaphore_device_indices: ::std::ptr::null(),
            command_buffer_count: u32::default(),
            p_command_buffer_device_masks: ::std::ptr::null(),
            signal_semaphore_count: u32::default(),
            p_signal_semaphore_device_indices: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupSubmitInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_SUBMIT_INFO;
}
impl DeviceGroupSubmitInfo {
    pub fn builder<'a>() -> DeviceGroupSubmitInfoBuilder<'a> {
        DeviceGroupSubmitInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupSubmitInfoBuilder<'a> {
    inner: DeviceGroupSubmitInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for DeviceGroupSubmitInfoBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for DeviceGroupSubmitInfo {}
impl<'a> ::std::ops::Deref for DeviceGroupSubmitInfoBuilder<'a> {
    type Target = DeviceGroupSubmitInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupSubmitInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupSubmitInfoBuilder<'a> {
    #[inline]
    pub fn wait_semaphore_device_indices(
        mut self,
        wait_semaphore_device_indices: &'a [u32],
    ) -> Self {
        self.inner.wait_semaphore_count = wait_semaphore_device_indices.len() as _;
        self.inner.p_wait_semaphore_device_indices = wait_semaphore_device_indices.as_ptr();
        self
    }
    #[inline]
    pub fn command_buffer_device_masks(mut self, command_buffer_device_masks: &'a [u32]) -> Self {
        self.inner.command_buffer_count = command_buffer_device_masks.len() as _;
        self.inner.p_command_buffer_device_masks = command_buffer_device_masks.as_ptr();
        self
    }
    #[inline]
    pub fn signal_semaphore_device_indices(
        mut self,
        signal_semaphore_device_indices: &'a [u32],
    ) -> Self {
        self.inner.signal_semaphore_count = signal_semaphore_device_indices.len() as _;
        self.inner.p_signal_semaphore_device_indices = signal_semaphore_device_indices.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupSubmitInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupBindSparseInfo.html>"]
pub struct DeviceGroupBindSparseInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub resource_device_index: u32,
    pub memory_device_index: u32,
}
impl ::std::default::Default for DeviceGroupBindSparseInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            resource_device_index: u32::default(),
            memory_device_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupBindSparseInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_BIND_SPARSE_INFO;
}
impl DeviceGroupBindSparseInfo {
    pub fn builder<'a>() -> DeviceGroupBindSparseInfoBuilder<'a> {
        DeviceGroupBindSparseInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupBindSparseInfoBuilder<'a> {
    inner: DeviceGroupBindSparseInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBindSparseInfo for DeviceGroupBindSparseInfoBuilder<'_> {}
unsafe impl ExtendsBindSparseInfo for DeviceGroupBindSparseInfo {}
impl<'a> ::std::ops::Deref for DeviceGroupBindSparseInfoBuilder<'a> {
    type Target = DeviceGroupBindSparseInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupBindSparseInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupBindSparseInfoBuilder<'a> {
    #[inline]
    pub fn resource_device_index(mut self, resource_device_index: u32) -> Self {
        self.inner.resource_device_index = resource_device_index;
        self
    }
    #[inline]
    pub fn memory_device_index(mut self, memory_device_index: u32) -> Self {
        self.inner.memory_device_index = memory_device_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupBindSparseInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupPresentCapabilitiesKHR.html>"]
pub struct DeviceGroupPresentCapabilitiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_mask: [u32; MAX_DEVICE_GROUP_SIZE],
    pub modes: DeviceGroupPresentModeFlagsKHR,
}
impl ::std::default::Default for DeviceGroupPresentCapabilitiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            present_mask: unsafe { ::std::mem::zeroed() },
            modes: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupPresentCapabilitiesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_PRESENT_CAPABILITIES_KHR;
}
impl DeviceGroupPresentCapabilitiesKHR {
    pub fn builder<'a>() -> DeviceGroupPresentCapabilitiesKHRBuilder<'a> {
        DeviceGroupPresentCapabilitiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupPresentCapabilitiesKHRBuilder<'a> {
    inner: DeviceGroupPresentCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DeviceGroupPresentCapabilitiesKHRBuilder<'a> {
    type Target = DeviceGroupPresentCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupPresentCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupPresentCapabilitiesKHRBuilder<'a> {
    #[inline]
    pub fn present_mask(mut self, present_mask: [u32; MAX_DEVICE_GROUP_SIZE]) -> Self {
        self.inner.present_mask = present_mask;
        self
    }
    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.inner.modes = modes;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupPresentCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageSwapchainCreateInfoKHR.html>"]
pub struct ImageSwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
}
impl ::std::default::Default for ImageSwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain: SwapchainKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageSwapchainCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_SWAPCHAIN_CREATE_INFO_KHR;
}
impl ImageSwapchainCreateInfoKHR {
    pub fn builder<'a>() -> ImageSwapchainCreateInfoKHRBuilder<'a> {
        ImageSwapchainCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSwapchainCreateInfoKHRBuilder<'a> {
    inner: ImageSwapchainCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ImageSwapchainCreateInfoKHRBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ImageSwapchainCreateInfoKHR {}
impl<'a> ::std::ops::Deref for ImageSwapchainCreateInfoKHRBuilder<'a> {
    type Target = ImageSwapchainCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSwapchainCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSwapchainCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.inner.swapchain = swapchain;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSwapchainCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindImageMemorySwapchainInfoKHR.html>"]
pub struct BindImageMemorySwapchainInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub image_index: u32,
}
impl ::std::default::Default for BindImageMemorySwapchainInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain: SwapchainKHR::default(),
            image_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for BindImageMemorySwapchainInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR;
}
impl BindImageMemorySwapchainInfoKHR {
    pub fn builder<'a>() -> BindImageMemorySwapchainInfoKHRBuilder<'a> {
        BindImageMemorySwapchainInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindImageMemorySwapchainInfoKHRBuilder<'a> {
    inner: BindImageMemorySwapchainInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemorySwapchainInfoKHRBuilder<'_> {}
unsafe impl ExtendsBindImageMemoryInfo for BindImageMemorySwapchainInfoKHR {}
impl<'a> ::std::ops::Deref for BindImageMemorySwapchainInfoKHRBuilder<'a> {
    type Target = BindImageMemorySwapchainInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindImageMemorySwapchainInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindImageMemorySwapchainInfoKHRBuilder<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.inner.swapchain = swapchain;
        self
    }
    #[inline]
    pub fn image_index(mut self, image_index: u32) -> Self {
        self.inner.image_index = image_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindImageMemorySwapchainInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAcquireNextImageInfoKHR.html>"]
pub struct AcquireNextImageInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain: SwapchainKHR,
    pub timeout: u64,
    pub semaphore: Semaphore,
    pub fence: Fence,
    pub device_mask: u32,
}
impl ::std::default::Default for AcquireNextImageInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain: SwapchainKHR::default(),
            timeout: u64::default(),
            semaphore: Semaphore::default(),
            fence: Fence::default(),
            device_mask: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for AcquireNextImageInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::ACQUIRE_NEXT_IMAGE_INFO_KHR;
}
impl AcquireNextImageInfoKHR {
    pub fn builder<'a>() -> AcquireNextImageInfoKHRBuilder<'a> {
        AcquireNextImageInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AcquireNextImageInfoKHRBuilder<'a> {
    inner: AcquireNextImageInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AcquireNextImageInfoKHRBuilder<'a> {
    type Target = AcquireNextImageInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AcquireNextImageInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AcquireNextImageInfoKHRBuilder<'a> {
    #[inline]
    pub fn swapchain(mut self, swapchain: SwapchainKHR) -> Self {
        self.inner.swapchain = swapchain;
        self
    }
    #[inline]
    pub fn timeout(mut self, timeout: u64) -> Self {
        self.inner.timeout = timeout;
        self
    }
    #[inline]
    pub fn semaphore(mut self, semaphore: Semaphore) -> Self {
        self.inner.semaphore = semaphore;
        self
    }
    #[inline]
    pub fn fence(mut self, fence: Fence) -> Self {
        self.inner.fence = fence;
        self
    }
    #[inline]
    pub fn device_mask(mut self, device_mask: u32) -> Self {
        self.inner.device_mask = device_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AcquireNextImageInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupPresentInfoKHR.html>"]
pub struct DeviceGroupPresentInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_device_masks: *const u32,
    pub mode: DeviceGroupPresentModeFlagsKHR,
}
impl ::std::default::Default for DeviceGroupPresentInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_device_masks: ::std::ptr::null(),
            mode: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupPresentInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_PRESENT_INFO_KHR;
}
impl DeviceGroupPresentInfoKHR {
    pub fn builder<'a>() -> DeviceGroupPresentInfoKHRBuilder<'a> {
        DeviceGroupPresentInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupPresentInfoKHRBuilder<'a> {
    inner: DeviceGroupPresentInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for DeviceGroupPresentInfoKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for DeviceGroupPresentInfoKHR {}
impl<'a> ::std::ops::Deref for DeviceGroupPresentInfoKHRBuilder<'a> {
    type Target = DeviceGroupPresentInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupPresentInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupPresentInfoKHRBuilder<'a> {
    #[inline]
    pub fn device_masks(mut self, device_masks: &'a [u32]) -> Self {
        self.inner.swapchain_count = device_masks.len() as _;
        self.inner.p_device_masks = device_masks.as_ptr();
        self
    }
    #[inline]
    pub fn mode(mut self, mode: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.inner.mode = mode;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupPresentInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupDeviceCreateInfo.html>"]
pub struct DeviceGroupDeviceCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub physical_device_count: u32,
    pub p_physical_devices: *const PhysicalDevice,
}
impl ::std::default::Default for DeviceGroupDeviceCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            physical_device_count: u32::default(),
            p_physical_devices: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupDeviceCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_DEVICE_CREATE_INFO;
}
impl DeviceGroupDeviceCreateInfo {
    pub fn builder<'a>() -> DeviceGroupDeviceCreateInfoBuilder<'a> {
        DeviceGroupDeviceCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupDeviceCreateInfoBuilder<'a> {
    inner: DeviceGroupDeviceCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDeviceCreateInfo for DeviceGroupDeviceCreateInfoBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for DeviceGroupDeviceCreateInfo {}
impl<'a> ::std::ops::Deref for DeviceGroupDeviceCreateInfoBuilder<'a> {
    type Target = DeviceGroupDeviceCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupDeviceCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupDeviceCreateInfoBuilder<'a> {
    #[inline]
    pub fn physical_devices(mut self, physical_devices: &'a [PhysicalDevice]) -> Self {
        self.inner.physical_device_count = physical_devices.len() as _;
        self.inner.p_physical_devices = physical_devices.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupDeviceCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceGroupSwapchainCreateInfoKHR.html>"]
pub struct DeviceGroupSwapchainCreateInfoKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub modes: DeviceGroupPresentModeFlagsKHR,
}
impl ::std::default::Default for DeviceGroupSwapchainCreateInfoKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            modes: DeviceGroupPresentModeFlagsKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceGroupSwapchainCreateInfoKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR;
}
impl DeviceGroupSwapchainCreateInfoKHR {
    pub fn builder<'a>() -> DeviceGroupSwapchainCreateInfoKHRBuilder<'a> {
        DeviceGroupSwapchainCreateInfoKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceGroupSwapchainCreateInfoKHRBuilder<'a> {
    inner: DeviceGroupSwapchainCreateInfoKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSwapchainCreateInfoKHR for DeviceGroupSwapchainCreateInfoKHRBuilder<'_> {}
unsafe impl ExtendsSwapchainCreateInfoKHR for DeviceGroupSwapchainCreateInfoKHR {}
impl<'a> ::std::ops::Deref for DeviceGroupSwapchainCreateInfoKHRBuilder<'a> {
    type Target = DeviceGroupSwapchainCreateInfoKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceGroupSwapchainCreateInfoKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceGroupSwapchainCreateInfoKHRBuilder<'a> {
    #[inline]
    pub fn modes(mut self, modes: DeviceGroupPresentModeFlagsKHR) -> Self {
        self.inner.modes = modes;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceGroupSwapchainCreateInfoKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateEntry.html>"]
pub struct DescriptorUpdateTemplateEntry {
    pub dst_binding: u32,
    pub dst_array_element: u32,
    pub descriptor_count: u32,
    pub descriptor_type: DescriptorType,
    pub offset: usize,
    pub stride: usize,
}
impl DescriptorUpdateTemplateEntry {
    pub fn builder<'a>() -> DescriptorUpdateTemplateEntryBuilder<'a> {
        DescriptorUpdateTemplateEntryBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorUpdateTemplateEntryBuilder<'a> {
    inner: DescriptorUpdateTemplateEntry,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorUpdateTemplateEntryBuilder<'a> {
    type Target = DescriptorUpdateTemplateEntry;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorUpdateTemplateEntryBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorUpdateTemplateEntryBuilder<'a> {
    #[inline]
    pub fn dst_binding(mut self, dst_binding: u32) -> Self {
        self.inner.dst_binding = dst_binding;
        self
    }
    #[inline]
    pub fn dst_array_element(mut self, dst_array_element: u32) -> Self {
        self.inner.dst_array_element = dst_array_element;
        self
    }
    #[inline]
    pub fn descriptor_count(mut self, descriptor_count: u32) -> Self {
        self.inner.descriptor_count = descriptor_count;
        self
    }
    #[inline]
    pub fn descriptor_type(mut self, descriptor_type: DescriptorType) -> Self {
        self.inner.descriptor_type = descriptor_type;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: usize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn stride(mut self, stride: usize) -> Self {
        self.inner.stride = stride;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorUpdateTemplateEntry {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorUpdateTemplateCreateInfo.html>"]
pub struct DescriptorUpdateTemplateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DescriptorUpdateTemplateCreateFlags,
    pub descriptor_update_entry_count: u32,
    pub p_descriptor_update_entries: *const DescriptorUpdateTemplateEntry,
    pub template_type: DescriptorUpdateTemplateType,
    pub descriptor_set_layout: DescriptorSetLayout,
    pub pipeline_bind_point: PipelineBindPoint,
    pub pipeline_layout: PipelineLayout,
    pub set: u32,
}
impl ::std::default::Default for DescriptorUpdateTemplateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DescriptorUpdateTemplateCreateFlags::default(),
            descriptor_update_entry_count: u32::default(),
            p_descriptor_update_entries: ::std::ptr::null(),
            template_type: DescriptorUpdateTemplateType::default(),
            descriptor_set_layout: DescriptorSetLayout::default(),
            pipeline_bind_point: PipelineBindPoint::default(),
            pipeline_layout: PipelineLayout::default(),
            set: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorUpdateTemplateCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO;
}
impl DescriptorUpdateTemplateCreateInfo {
    pub fn builder<'a>() -> DescriptorUpdateTemplateCreateInfoBuilder<'a> {
        DescriptorUpdateTemplateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorUpdateTemplateCreateInfoBuilder<'a> {
    inner: DescriptorUpdateTemplateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DescriptorUpdateTemplateCreateInfoBuilder<'a> {
    type Target = DescriptorUpdateTemplateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorUpdateTemplateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorUpdateTemplateCreateInfoBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DescriptorUpdateTemplateCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn descriptor_update_entries(
        mut self,
        descriptor_update_entries: &'a [DescriptorUpdateTemplateEntry],
    ) -> Self {
        self.inner.descriptor_update_entry_count = descriptor_update_entries.len() as _;
        self.inner.p_descriptor_update_entries = descriptor_update_entries.as_ptr();
        self
    }
    #[inline]
    pub fn template_type(mut self, template_type: DescriptorUpdateTemplateType) -> Self {
        self.inner.template_type = template_type;
        self
    }
    #[inline]
    pub fn descriptor_set_layout(mut self, descriptor_set_layout: DescriptorSetLayout) -> Self {
        self.inner.descriptor_set_layout = descriptor_set_layout;
        self
    }
    #[inline]
    pub fn pipeline_bind_point(mut self, pipeline_bind_point: PipelineBindPoint) -> Self {
        self.inner.pipeline_bind_point = pipeline_bind_point;
        self
    }
    #[inline]
    pub fn pipeline_layout(mut self, pipeline_layout: PipelineLayout) -> Self {
        self.inner.pipeline_layout = pipeline_layout;
        self
    }
    #[inline]
    pub fn set(mut self, set: u32) -> Self {
        self.inner.set = set;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorUpdateTemplateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkXYColorEXT.html>"]
pub struct XYColorEXT {
    pub x: f32,
    pub y: f32,
}
impl XYColorEXT {
    pub fn builder<'a>() -> XYColorEXTBuilder<'a> {
        XYColorEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct XYColorEXTBuilder<'a> {
    inner: XYColorEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for XYColorEXTBuilder<'a> {
    type Target = XYColorEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for XYColorEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> XYColorEXTBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.inner.y = y;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> XYColorEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePresentIdFeaturesKHR.html>"]
pub struct PhysicalDevicePresentIdFeaturesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_id: Bool32,
}
impl ::std::default::Default for PhysicalDevicePresentIdFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            present_id: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevicePresentIdFeaturesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR;
}
impl PhysicalDevicePresentIdFeaturesKHR {
    pub fn builder<'a>() -> PhysicalDevicePresentIdFeaturesKHRBuilder<'a> {
        PhysicalDevicePresentIdFeaturesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePresentIdFeaturesKHRBuilder<'a> {
    inner: PhysicalDevicePresentIdFeaturesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentIdFeaturesKHRBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentIdFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentIdFeaturesKHRBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentIdFeaturesKHR {}
impl<'a> ::std::ops::Deref for PhysicalDevicePresentIdFeaturesKHRBuilder<'a> {
    type Target = PhysicalDevicePresentIdFeaturesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePresentIdFeaturesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePresentIdFeaturesKHRBuilder<'a> {
    #[inline]
    pub fn present_id(mut self, present_id: bool) -> Self {
        self.inner.present_id = present_id.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePresentIdFeaturesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentIdKHR.html>"]
pub struct PresentIdKHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_present_ids: *const u64,
}
impl ::std::default::Default for PresentIdKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_present_ids: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PresentIdKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_ID_KHR;
}
impl PresentIdKHR {
    pub fn builder<'a>() -> PresentIdKHRBuilder<'a> {
        PresentIdKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentIdKHRBuilder<'a> {
    inner: PresentIdKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for PresentIdKHRBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for PresentIdKHR {}
impl<'a> ::std::ops::Deref for PresentIdKHRBuilder<'a> {
    type Target = PresentIdKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentIdKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentIdKHRBuilder<'a> {
    #[inline]
    pub fn present_ids(mut self, present_ids: &'a [u64]) -> Self {
        self.inner.swapchain_count = present_ids.len() as _;
        self.inner.p_present_ids = present_ids.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentIdKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePresentWaitFeaturesKHR.html>"]
pub struct PhysicalDevicePresentWaitFeaturesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub present_wait: Bool32,
}
impl ::std::default::Default for PhysicalDevicePresentWaitFeaturesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            present_wait: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevicePresentWaitFeaturesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR;
}
impl PhysicalDevicePresentWaitFeaturesKHR {
    pub fn builder<'a>() -> PhysicalDevicePresentWaitFeaturesKHRBuilder<'a> {
        PhysicalDevicePresentWaitFeaturesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePresentWaitFeaturesKHRBuilder<'a> {
    inner: PhysicalDevicePresentWaitFeaturesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentWaitFeaturesKHRBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevicePresentWaitFeaturesKHR {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentWaitFeaturesKHRBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevicePresentWaitFeaturesKHR {}
impl<'a> ::std::ops::Deref for PhysicalDevicePresentWaitFeaturesKHRBuilder<'a> {
    type Target = PhysicalDevicePresentWaitFeaturesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePresentWaitFeaturesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePresentWaitFeaturesKHRBuilder<'a> {
    #[inline]
    pub fn present_wait(mut self, present_wait: bool) -> Self {
        self.inner.present_wait = present_wait.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePresentWaitFeaturesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkHdrMetadataEXT.html>"]
pub struct HdrMetadataEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub display_primary_red: XYColorEXT,
    pub display_primary_green: XYColorEXT,
    pub display_primary_blue: XYColorEXT,
    pub white_point: XYColorEXT,
    pub max_luminance: f32,
    pub min_luminance: f32,
    pub max_content_light_level: f32,
    pub max_frame_average_light_level: f32,
}
impl ::std::default::Default for HdrMetadataEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            display_primary_red: XYColorEXT::default(),
            display_primary_green: XYColorEXT::default(),
            display_primary_blue: XYColorEXT::default(),
            white_point: XYColorEXT::default(),
            max_luminance: f32::default(),
            min_luminance: f32::default(),
            max_content_light_level: f32::default(),
            max_frame_average_light_level: f32::default(),
        }
    }
}
unsafe impl TaggedStructure for HdrMetadataEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::HDR_METADATA_EXT;
}
impl HdrMetadataEXT {
    pub fn builder<'a>() -> HdrMetadataEXTBuilder<'a> {
        HdrMetadataEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct HdrMetadataEXTBuilder<'a> {
    inner: HdrMetadataEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for HdrMetadataEXTBuilder<'a> {
    type Target = HdrMetadataEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for HdrMetadataEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> HdrMetadataEXTBuilder<'a> {
    #[inline]
    pub fn display_primary_red(mut self, display_primary_red: XYColorEXT) -> Self {
        self.inner.display_primary_red = display_primary_red;
        self
    }
    #[inline]
    pub fn display_primary_green(mut self, display_primary_green: XYColorEXT) -> Self {
        self.inner.display_primary_green = display_primary_green;
        self
    }
    #[inline]
    pub fn display_primary_blue(mut self, display_primary_blue: XYColorEXT) -> Self {
        self.inner.display_primary_blue = display_primary_blue;
        self
    }
    #[inline]
    pub fn white_point(mut self, white_point: XYColorEXT) -> Self {
        self.inner.white_point = white_point;
        self
    }
    #[inline]
    pub fn max_luminance(mut self, max_luminance: f32) -> Self {
        self.inner.max_luminance = max_luminance;
        self
    }
    #[inline]
    pub fn min_luminance(mut self, min_luminance: f32) -> Self {
        self.inner.min_luminance = min_luminance;
        self
    }
    #[inline]
    pub fn max_content_light_level(mut self, max_content_light_level: f32) -> Self {
        self.inner.max_content_light_level = max_content_light_level;
        self
    }
    #[inline]
    pub fn max_frame_average_light_level(mut self, max_frame_average_light_level: f32) -> Self {
        self.inner.max_frame_average_light_level = max_frame_average_light_level;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> HdrMetadataEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayNativeHdrSurfaceCapabilitiesAMD.html>"]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMD {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub local_dimming_support: Bool32,
}
impl ::std::default::Default for DisplayNativeHdrSurfaceCapabilitiesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            local_dimming_support: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayNativeHdrSurfaceCapabilitiesAMD {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD;
}
impl DisplayNativeHdrSurfaceCapabilitiesAMD {
    pub fn builder<'a>() -> DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'a> {
        DisplayNativeHdrSurfaceCapabilitiesAMDBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'a> {
    inner: DisplayNativeHdrSurfaceCapabilitiesAMD,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSurfaceCapabilities2KHR for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'_> {}
unsafe impl ExtendsSurfaceCapabilities2KHR for DisplayNativeHdrSurfaceCapabilitiesAMD {}
impl<'a> ::std::ops::Deref for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'a> {
    type Target = DisplayNativeHdrSurfaceCapabilitiesAMD;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayNativeHdrSurfaceCapabilitiesAMDBuilder<'a> {
    #[inline]
    pub fn local_dimming_support(mut self, local_dimming_support: bool) -> Self {
        self.inner.local_dimming_support = local_dimming_support.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayNativeHdrSurfaceCapabilitiesAMD {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSwapchainDisplayNativeHdrCreateInfoAMD.html>"]
pub struct SwapchainDisplayNativeHdrCreateInfoAMD {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub local_dimming_enable: Bool32,
}
impl ::std::default::Default for SwapchainDisplayNativeHdrCreateInfoAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            local_dimming_enable: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for SwapchainDisplayNativeHdrCreateInfoAMD {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD;
}
impl SwapchainDisplayNativeHdrCreateInfoAMD {
    pub fn builder<'a>() -> SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'a> {
        SwapchainDisplayNativeHdrCreateInfoAMDBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'a> {
    inner: SwapchainDisplayNativeHdrCreateInfoAMD,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'_> {}
unsafe impl ExtendsSwapchainCreateInfoKHR for SwapchainDisplayNativeHdrCreateInfoAMD {}
impl<'a> ::std::ops::Deref for SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'a> {
    type Target = SwapchainDisplayNativeHdrCreateInfoAMD;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SwapchainDisplayNativeHdrCreateInfoAMDBuilder<'a> {
    #[inline]
    pub fn local_dimming_enable(mut self, local_dimming_enable: bool) -> Self {
        self.inner.local_dimming_enable = local_dimming_enable.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SwapchainDisplayNativeHdrCreateInfoAMD {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRefreshCycleDurationGOOGLE.html>"]
pub struct RefreshCycleDurationGOOGLE {
    pub refresh_duration: u64,
}
impl RefreshCycleDurationGOOGLE {
    pub fn builder<'a>() -> RefreshCycleDurationGOOGLEBuilder<'a> {
        RefreshCycleDurationGOOGLEBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RefreshCycleDurationGOOGLEBuilder<'a> {
    inner: RefreshCycleDurationGOOGLE,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for RefreshCycleDurationGOOGLEBuilder<'a> {
    type Target = RefreshCycleDurationGOOGLE;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RefreshCycleDurationGOOGLEBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RefreshCycleDurationGOOGLEBuilder<'a> {
    #[inline]
    pub fn refresh_duration(mut self, refresh_duration: u64) -> Self {
        self.inner.refresh_duration = refresh_duration;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RefreshCycleDurationGOOGLE {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPastPresentationTimingGOOGLE.html>"]
pub struct PastPresentationTimingGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
    pub actual_present_time: u64,
    pub earliest_present_time: u64,
    pub present_margin: u64,
}
impl PastPresentationTimingGOOGLE {
    pub fn builder<'a>() -> PastPresentationTimingGOOGLEBuilder<'a> {
        PastPresentationTimingGOOGLEBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PastPresentationTimingGOOGLEBuilder<'a> {
    inner: PastPresentationTimingGOOGLE,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PastPresentationTimingGOOGLEBuilder<'a> {
    type Target = PastPresentationTimingGOOGLE;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PastPresentationTimingGOOGLEBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PastPresentationTimingGOOGLEBuilder<'a> {
    #[inline]
    pub fn present_id(mut self, present_id: u32) -> Self {
        self.inner.present_id = present_id;
        self
    }
    #[inline]
    pub fn desired_present_time(mut self, desired_present_time: u64) -> Self {
        self.inner.desired_present_time = desired_present_time;
        self
    }
    #[inline]
    pub fn actual_present_time(mut self, actual_present_time: u64) -> Self {
        self.inner.actual_present_time = actual_present_time;
        self
    }
    #[inline]
    pub fn earliest_present_time(mut self, earliest_present_time: u64) -> Self {
        self.inner.earliest_present_time = earliest_present_time;
        self
    }
    #[inline]
    pub fn present_margin(mut self, present_margin: u64) -> Self {
        self.inner.present_margin = present_margin;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PastPresentationTimingGOOGLE {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentTimesInfoGOOGLE.html>"]
pub struct PresentTimesInfoGOOGLE {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub swapchain_count: u32,
    pub p_times: *const PresentTimeGOOGLE,
}
impl ::std::default::Default for PresentTimesInfoGOOGLE {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            swapchain_count: u32::default(),
            p_times: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PresentTimesInfoGOOGLE {
    const STRUCTURE_TYPE: StructureType = StructureType::PRESENT_TIMES_INFO_GOOGLE;
}
impl PresentTimesInfoGOOGLE {
    pub fn builder<'a>() -> PresentTimesInfoGOOGLEBuilder<'a> {
        PresentTimesInfoGOOGLEBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentTimesInfoGOOGLEBuilder<'a> {
    inner: PresentTimesInfoGOOGLE,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPresentInfoKHR for PresentTimesInfoGOOGLEBuilder<'_> {}
unsafe impl ExtendsPresentInfoKHR for PresentTimesInfoGOOGLE {}
impl<'a> ::std::ops::Deref for PresentTimesInfoGOOGLEBuilder<'a> {
    type Target = PresentTimesInfoGOOGLE;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentTimesInfoGOOGLEBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentTimesInfoGOOGLEBuilder<'a> {
    #[inline]
    pub fn times(mut self, times: &'a [PresentTimeGOOGLE]) -> Self {
        self.inner.swapchain_count = times.len() as _;
        self.inner.p_times = times.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentTimesInfoGOOGLE {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPresentTimeGOOGLE.html>"]
pub struct PresentTimeGOOGLE {
    pub present_id: u32,
    pub desired_present_time: u64,
}
impl PresentTimeGOOGLE {
    pub fn builder<'a>() -> PresentTimeGOOGLEBuilder<'a> {
        PresentTimeGOOGLEBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PresentTimeGOOGLEBuilder<'a> {
    inner: PresentTimeGOOGLE,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for PresentTimeGOOGLEBuilder<'a> {
    type Target = PresentTimeGOOGLE;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PresentTimeGOOGLEBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PresentTimeGOOGLEBuilder<'a> {
    #[inline]
    pub fn present_id(mut self, present_id: u32) -> Self {
        self.inner.present_id = present_id;
        self
    }
    #[inline]
    pub fn desired_present_time(mut self, desired_present_time: u64) -> Self {
        self.inner.desired_present_time = desired_present_time;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PresentTimeGOOGLE {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkIOSSurfaceCreateInfoMVK.html>"]
pub struct IOSSurfaceCreateInfoMVK {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: IOSSurfaceCreateFlagsMVK,
    pub p_view: *const c_void,
}
impl ::std::default::Default for IOSSurfaceCreateInfoMVK {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: IOSSurfaceCreateFlagsMVK::default(),
            p_view: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for IOSSurfaceCreateInfoMVK {
    const STRUCTURE_TYPE: StructureType = StructureType::IOS_SURFACE_CREATE_INFO_MVK;
}
impl IOSSurfaceCreateInfoMVK {
    pub fn builder<'a>() -> IOSSurfaceCreateInfoMVKBuilder<'a> {
        IOSSurfaceCreateInfoMVKBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct IOSSurfaceCreateInfoMVKBuilder<'a> {
    inner: IOSSurfaceCreateInfoMVK,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for IOSSurfaceCreateInfoMVKBuilder<'a> {
    type Target = IOSSurfaceCreateInfoMVK;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for IOSSurfaceCreateInfoMVKBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> IOSSurfaceCreateInfoMVKBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: IOSSurfaceCreateFlagsMVK) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn view(mut self, view: *const c_void) -> Self {
        self.inner.p_view = view;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> IOSSurfaceCreateInfoMVK {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMacOSSurfaceCreateInfoMVK.html>"]
pub struct MacOSSurfaceCreateInfoMVK {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MacOSSurfaceCreateFlagsMVK,
    pub p_view: *const c_void,
}
impl ::std::default::Default for MacOSSurfaceCreateInfoMVK {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: MacOSSurfaceCreateFlagsMVK::default(),
            p_view: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for MacOSSurfaceCreateInfoMVK {
    const STRUCTURE_TYPE: StructureType = StructureType::MACOS_SURFACE_CREATE_INFO_MVK;
}
impl MacOSSurfaceCreateInfoMVK {
    pub fn builder<'a>() -> MacOSSurfaceCreateInfoMVKBuilder<'a> {
        MacOSSurfaceCreateInfoMVKBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MacOSSurfaceCreateInfoMVKBuilder<'a> {
    inner: MacOSSurfaceCreateInfoMVK,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MacOSSurfaceCreateInfoMVKBuilder<'a> {
    type Target = MacOSSurfaceCreateInfoMVK;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MacOSSurfaceCreateInfoMVKBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MacOSSurfaceCreateInfoMVKBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: MacOSSurfaceCreateFlagsMVK) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn view(mut self, view: *const c_void) -> Self {
        self.inner.p_view = view;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MacOSSurfaceCreateInfoMVK {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMetalSurfaceCreateInfoEXT.html>"]
pub struct MetalSurfaceCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: MetalSurfaceCreateFlagsEXT,
    pub p_layer: *const CAMetalLayer,
}
impl ::std::default::Default for MetalSurfaceCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: MetalSurfaceCreateFlagsEXT::default(),
            p_layer: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for MetalSurfaceCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::METAL_SURFACE_CREATE_INFO_EXT;
}
impl MetalSurfaceCreateInfoEXT {
    pub fn builder<'a>() -> MetalSurfaceCreateInfoEXTBuilder<'a> {
        MetalSurfaceCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MetalSurfaceCreateInfoEXTBuilder<'a> {
    inner: MetalSurfaceCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MetalSurfaceCreateInfoEXTBuilder<'a> {
    type Target = MetalSurfaceCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MetalSurfaceCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MetalSurfaceCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: MetalSurfaceCreateFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn layer(mut self, layer: *const CAMetalLayer) -> Self {
        self.inner.p_layer = layer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MetalSurfaceCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkViewportWScalingNV.html>"]
pub struct ViewportWScalingNV {
    pub xcoeff: f32,
    pub ycoeff: f32,
}
impl ViewportWScalingNV {
    pub fn builder<'a>() -> ViewportWScalingNVBuilder<'a> {
        ViewportWScalingNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViewportWScalingNVBuilder<'a> {
    inner: ViewportWScalingNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ViewportWScalingNVBuilder<'a> {
    type Target = ViewportWScalingNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViewportWScalingNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViewportWScalingNVBuilder<'a> {
    #[inline]
    pub fn xcoeff(mut self, xcoeff: f32) -> Self {
        self.inner.xcoeff = xcoeff;
        self
    }
    #[inline]
    pub fn ycoeff(mut self, ycoeff: f32) -> Self {
        self.inner.ycoeff = ycoeff;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ViewportWScalingNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportWScalingStateCreateInfoNV.html>"]
pub struct PipelineViewportWScalingStateCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub viewport_w_scaling_enable: Bool32,
    pub viewport_count: u32,
    pub p_viewport_w_scalings: *const ViewportWScalingNV,
}
impl ::std::default::Default for PipelineViewportWScalingStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            viewport_w_scaling_enable: Bool32::default(),
            viewport_count: u32::default(),
            p_viewport_w_scalings: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineViewportWScalingStateCreateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV;
}
impl PipelineViewportWScalingStateCreateInfoNV {
    pub fn builder<'a>() -> PipelineViewportWScalingStateCreateInfoNVBuilder<'a> {
        PipelineViewportWScalingStateCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineViewportWScalingStateCreateInfoNVBuilder<'a> {
    inner: PipelineViewportWScalingStateCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportWScalingStateCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsPipelineViewportStateCreateInfo for PipelineViewportWScalingStateCreateInfoNV {}
impl<'a> ::std::ops::Deref for PipelineViewportWScalingStateCreateInfoNVBuilder<'a> {
    type Target = PipelineViewportWScalingStateCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineViewportWScalingStateCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineViewportWScalingStateCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn viewport_w_scaling_enable(mut self, viewport_w_scaling_enable: bool) -> Self {
        self.inner.viewport_w_scaling_enable = viewport_w_scaling_enable.into();
        self
    }
    #[inline]
    pub fn viewport_w_scalings(mut self, viewport_w_scalings: &'a [ViewportWScalingNV]) -> Self {
        self.inner.viewport_count = viewport_w_scalings.len() as _;
        self.inner.p_viewport_w_scalings = viewport_w_scalings.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineViewportWScalingStateCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkViewportSwizzleNV.html>"]
pub struct ViewportSwizzleNV {
    pub x: ViewportCoordinateSwizzleNV,
    pub y: ViewportCoordinateSwizzleNV,
    pub z: ViewportCoordinateSwizzleNV,
    pub w: ViewportCoordinateSwizzleNV,
}
impl ViewportSwizzleNV {
    pub fn builder<'a>() -> ViewportSwizzleNVBuilder<'a> {
        ViewportSwizzleNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ViewportSwizzleNVBuilder<'a> {
    inner: ViewportSwizzleNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ViewportSwizzleNVBuilder<'a> {
    type Target = ViewportSwizzleNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ViewportSwizzleNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ViewportSwizzleNVBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: ViewportCoordinateSwizzleNV) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: ViewportCoordinateSwizzleNV) -> Self {
        self.inner.y = y;
        self
    }
    #[inline]
    pub fn z(mut self, z: ViewportCoordinateSwizzleNV) -> Self {
        self.inner.z = z;
        self
    }
    #[inline]
    pub fn w(mut self, w: ViewportCoordinateSwizzleNV) -> Self {
        self.inner.w = w;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ViewportSwizzleNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineViewportSwizzleStateCreateInfoNV.html>"]
pub struct PipelineViewportSwizzleStateCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineViewportSwizzleStateCreateFlagsNV,
    pub viewport_count: u32,
    pub p_viewport_swizzles: *const ViewportSwizzleNV,
}
impl ::std::default::Default for PipelineViewportSwizzleStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineViewportSwizzleStateCreateFlagsNV::default(),
            viewport_count: u32::default(),
            p_viewport_swizzles: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineViewportSwizzleStateCreateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV;
}
impl PipelineViewportSwizzleStateCreateInfoNV {
    pub fn builder<'a>() -> PipelineViewportSwizzleStateCreateInfoNVBuilder<'a> {
        PipelineViewportSwizzleStateCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineViewportSwizzleStateCreateInfoNVBuilder<'a> {
    inner: PipelineViewportSwizzleStateCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineViewportStateCreateInfo
    for PipelineViewportSwizzleStateCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsPipelineViewportStateCreateInfo for PipelineViewportSwizzleStateCreateInfoNV {}
impl<'a> ::std::ops::Deref for PipelineViewportSwizzleStateCreateInfoNVBuilder<'a> {
    type Target = PipelineViewportSwizzleStateCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineViewportSwizzleStateCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineViewportSwizzleStateCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineViewportSwizzleStateCreateFlagsNV) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn viewport_swizzles(mut self, viewport_swizzles: &'a [ViewportSwizzleNV]) -> Self {
        self.inner.viewport_count = viewport_swizzles.len() as _;
        self.inner.p_viewport_swizzles = viewport_swizzles.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineViewportSwizzleStateCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceDiscardRectanglePropertiesEXT.html>"]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_discard_rectangles: u32,
}
impl ::std::default::Default for PhysicalDeviceDiscardRectanglePropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_discard_rectangles: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceDiscardRectanglePropertiesEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT;
}
impl PhysicalDeviceDiscardRectanglePropertiesEXT {
    pub fn builder<'a>() -> PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'a> {
        PhysicalDeviceDiscardRectanglePropertiesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'a> {
    inner: PhysicalDeviceDiscardRectanglePropertiesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceDiscardRectanglePropertiesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'a> {
    type Target = PhysicalDeviceDiscardRectanglePropertiesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceDiscardRectanglePropertiesEXTBuilder<'a> {
    #[inline]
    pub fn max_discard_rectangles(mut self, max_discard_rectangles: u32) -> Self {
        self.inner.max_discard_rectangles = max_discard_rectangles;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceDiscardRectanglePropertiesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineDiscardRectangleStateCreateInfoEXT.html>"]
pub struct PipelineDiscardRectangleStateCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineDiscardRectangleStateCreateFlagsEXT,
    pub discard_rectangle_mode: DiscardRectangleModeEXT,
    pub discard_rectangle_count: u32,
    pub p_discard_rectangles: *const Rect2D,
}
impl ::std::default::Default for PipelineDiscardRectangleStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineDiscardRectangleStateCreateFlagsEXT::default(),
            discard_rectangle_mode: DiscardRectangleModeEXT::default(),
            discard_rectangle_count: u32::default(),
            p_discard_rectangles: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineDiscardRectangleStateCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT;
}
impl PipelineDiscardRectangleStateCreateInfoEXT {
    pub fn builder<'a>() -> PipelineDiscardRectangleStateCreateInfoEXTBuilder<'a> {
        PipelineDiscardRectangleStateCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineDiscardRectangleStateCreateInfoEXTBuilder<'a> {
    inner: PipelineDiscardRectangleStateCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsGraphicsPipelineCreateInfo
    for PipelineDiscardRectangleStateCreateInfoEXTBuilder<'_>
{
}
unsafe impl ExtendsGraphicsPipelineCreateInfo for PipelineDiscardRectangleStateCreateInfoEXT {}
impl<'a> ::std::ops::Deref for PipelineDiscardRectangleStateCreateInfoEXTBuilder<'a> {
    type Target = PipelineDiscardRectangleStateCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineDiscardRectangleStateCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineDiscardRectangleStateCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineDiscardRectangleStateCreateFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn discard_rectangle_mode(
        mut self,
        discard_rectangle_mode: DiscardRectangleModeEXT,
    ) -> Self {
        self.inner.discard_rectangle_mode = discard_rectangle_mode;
        self
    }
    #[inline]
    pub fn discard_rectangles(mut self, discard_rectangles: &'a [Rect2D]) -> Self {
        self.inner.discard_rectangle_count = discard_rectangles.len() as _;
        self.inner.p_discard_rectangles = discard_rectangles.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineDiscardRectangleStateCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX.html>"]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub per_view_position_all_components: Bool32,
}
impl ::std::default::Default for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            per_view_position_all_components: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX;
}
impl PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
    pub fn builder<'a>() -> PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'a> {
        PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'a> {
    inner: PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX
{
}
impl<'a> ::std::ops::Deref for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'a> {
    type Target = PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMultiviewPerViewAttributesPropertiesNVXBuilder<'a> {
    #[inline]
    pub fn per_view_position_all_components(
        mut self,
        per_view_position_all_components: bool,
    ) -> Self {
        self.inner.per_view_position_all_components = per_view_position_all_components.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMultiviewPerViewAttributesPropertiesNVX {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkInputAttachmentAspectReference.html>"]
pub struct InputAttachmentAspectReference {
    pub subpass: u32,
    pub input_attachment_index: u32,
    pub aspect_mask: ImageAspectFlags,
}
impl InputAttachmentAspectReference {
    pub fn builder<'a>() -> InputAttachmentAspectReferenceBuilder<'a> {
        InputAttachmentAspectReferenceBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct InputAttachmentAspectReferenceBuilder<'a> {
    inner: InputAttachmentAspectReference,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for InputAttachmentAspectReferenceBuilder<'a> {
    type Target = InputAttachmentAspectReference;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for InputAttachmentAspectReferenceBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> InputAttachmentAspectReferenceBuilder<'a> {
    #[inline]
    pub fn subpass(mut self, subpass: u32) -> Self {
        self.inner.subpass = subpass;
        self
    }
    #[inline]
    pub fn input_attachment_index(mut self, input_attachment_index: u32) -> Self {
        self.inner.input_attachment_index = input_attachment_index;
        self
    }
    #[inline]
    pub fn aspect_mask(mut self, aspect_mask: ImageAspectFlags) -> Self {
        self.inner.aspect_mask = aspect_mask;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> InputAttachmentAspectReference {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPassInputAttachmentAspectCreateInfo.html>"]
pub struct RenderPassInputAttachmentAspectCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub aspect_reference_count: u32,
    pub p_aspect_references: *const InputAttachmentAspectReference,
}
impl ::std::default::Default for RenderPassInputAttachmentAspectCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            aspect_reference_count: u32::default(),
            p_aspect_references: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for RenderPassInputAttachmentAspectCreateInfo {
    const STRUCTURE_TYPE: StructureType =
        StructureType::RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO;
}
impl RenderPassInputAttachmentAspectCreateInfo {
    pub fn builder<'a>() -> RenderPassInputAttachmentAspectCreateInfoBuilder<'a> {
        RenderPassInputAttachmentAspectCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassInputAttachmentAspectCreateInfoBuilder<'a> {
    inner: RenderPassInputAttachmentAspectCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassInputAttachmentAspectCreateInfoBuilder<'_> {}
unsafe impl ExtendsRenderPassCreateInfo for RenderPassInputAttachmentAspectCreateInfo {}
impl<'a> ::std::ops::Deref for RenderPassInputAttachmentAspectCreateInfoBuilder<'a> {
    type Target = RenderPassInputAttachmentAspectCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassInputAttachmentAspectCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassInputAttachmentAspectCreateInfoBuilder<'a> {
    #[inline]
    pub fn aspect_references(
        mut self,
        aspect_references: &'a [InputAttachmentAspectReference],
    ) -> Self {
        self.inner.aspect_reference_count = aspect_references.len() as _;
        self.inner.p_aspect_references = aspect_references.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassInputAttachmentAspectCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSurfaceInfo2KHR.html>"]
pub struct PhysicalDeviceSurfaceInfo2KHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub surface: SurfaceKHR,
}
impl ::std::default::Default for PhysicalDeviceSurfaceInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            surface: SurfaceKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSurfaceInfo2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SURFACE_INFO_2_KHR;
}
impl PhysicalDeviceSurfaceInfo2KHR {
    pub fn builder<'a>() -> PhysicalDeviceSurfaceInfo2KHRBuilder<'a> {
        PhysicalDeviceSurfaceInfo2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSurfaceInfo2KHRBuilder<'a> {
    inner: PhysicalDeviceSurfaceInfo2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsPhysicalDeviceSurfaceInfo2KHR {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSurfaceInfo2KHRBuilder<'a> {
    type Target = PhysicalDeviceSurfaceInfo2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSurfaceInfo2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSurfaceInfo2KHRBuilder<'a> {
    #[inline]
    pub fn surface(mut self, surface: SurfaceKHR) -> Self {
        self.inner.surface = surface;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsPhysicalDeviceSurfaceInfo2KHR>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSurfaceInfo2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceCapabilities2KHR.html>"]
pub struct SurfaceCapabilities2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub surface_capabilities: SurfaceCapabilitiesKHR,
}
impl ::std::default::Default for SurfaceCapabilities2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            surface_capabilities: SurfaceCapabilitiesKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for SurfaceCapabilities2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_CAPABILITIES_2_KHR;
}
impl SurfaceCapabilities2KHR {
    pub fn builder<'a>() -> SurfaceCapabilities2KHRBuilder<'a> {
        SurfaceCapabilities2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceCapabilities2KHRBuilder<'a> {
    inner: SurfaceCapabilities2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSurfaceCapabilities2KHR {}
impl<'a> ::std::ops::Deref for SurfaceCapabilities2KHRBuilder<'a> {
    type Target = SurfaceCapabilities2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceCapabilities2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceCapabilities2KHRBuilder<'a> {
    #[inline]
    pub fn surface_capabilities(mut self, surface_capabilities: SurfaceCapabilitiesKHR) -> Self {
        self.inner.surface_capabilities = surface_capabilities;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSurfaceCapabilities2KHR>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceCapabilities2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSurfaceFormat2KHR.html>"]
pub struct SurfaceFormat2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub surface_format: SurfaceFormatKHR,
}
impl ::std::default::Default for SurfaceFormat2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            surface_format: SurfaceFormatKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for SurfaceFormat2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SURFACE_FORMAT_2_KHR;
}
impl SurfaceFormat2KHR {
    pub fn builder<'a>() -> SurfaceFormat2KHRBuilder<'a> {
        SurfaceFormat2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SurfaceFormat2KHRBuilder<'a> {
    inner: SurfaceFormat2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSurfaceFormat2KHR {}
impl<'a> ::std::ops::Deref for SurfaceFormat2KHRBuilder<'a> {
    type Target = SurfaceFormat2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SurfaceFormat2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SurfaceFormat2KHRBuilder<'a> {
    #[inline]
    pub fn surface_format(mut self, surface_format: SurfaceFormatKHR) -> Self {
        self.inner.surface_format = surface_format;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSurfaceFormat2KHR>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SurfaceFormat2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayProperties2KHR.html>"]
pub struct DisplayProperties2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_properties: DisplayPropertiesKHR,
}
impl ::std::default::Default for DisplayProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            display_properties: DisplayPropertiesKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayProperties2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PROPERTIES_2_KHR;
}
impl DisplayProperties2KHR {
    pub fn builder<'a>() -> DisplayProperties2KHRBuilder<'a> {
        DisplayProperties2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayProperties2KHRBuilder<'a> {
    inner: DisplayProperties2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayProperties2KHRBuilder<'a> {
    type Target = DisplayProperties2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayProperties2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayProperties2KHRBuilder<'a> {
    #[inline]
    pub fn display_properties(mut self, display_properties: DisplayPropertiesKHR) -> Self {
        self.inner.display_properties = display_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayProperties2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneProperties2KHR.html>"]
pub struct DisplayPlaneProperties2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_plane_properties: DisplayPlanePropertiesKHR,
}
impl ::std::default::Default for DisplayPlaneProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            display_plane_properties: DisplayPlanePropertiesKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayPlaneProperties2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_PROPERTIES_2_KHR;
}
impl DisplayPlaneProperties2KHR {
    pub fn builder<'a>() -> DisplayPlaneProperties2KHRBuilder<'a> {
        DisplayPlaneProperties2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlaneProperties2KHRBuilder<'a> {
    inner: DisplayPlaneProperties2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlaneProperties2KHRBuilder<'a> {
    type Target = DisplayPlaneProperties2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlaneProperties2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlaneProperties2KHRBuilder<'a> {
    #[inline]
    pub fn display_plane_properties(
        mut self,
        display_plane_properties: DisplayPlanePropertiesKHR,
    ) -> Self {
        self.inner.display_plane_properties = display_plane_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlaneProperties2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayModeProperties2KHR.html>"]
pub struct DisplayModeProperties2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub display_mode_properties: DisplayModePropertiesKHR,
}
impl ::std::default::Default for DisplayModeProperties2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            display_mode_properties: DisplayModePropertiesKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayModeProperties2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_MODE_PROPERTIES_2_KHR;
}
impl DisplayModeProperties2KHR {
    pub fn builder<'a>() -> DisplayModeProperties2KHRBuilder<'a> {
        DisplayModeProperties2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayModeProperties2KHRBuilder<'a> {
    inner: DisplayModeProperties2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayModeProperties2KHRBuilder<'a> {
    type Target = DisplayModeProperties2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayModeProperties2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayModeProperties2KHRBuilder<'a> {
    #[inline]
    pub fn display_mode_properties(
        mut self,
        display_mode_properties: DisplayModePropertiesKHR,
    ) -> Self {
        self.inner.display_mode_properties = display_mode_properties;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayModeProperties2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneInfo2KHR.html>"]
pub struct DisplayPlaneInfo2KHR {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub mode: DisplayModeKHR,
    pub plane_index: u32,
}
impl ::std::default::Default for DisplayPlaneInfo2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            mode: DisplayModeKHR::default(),
            plane_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayPlaneInfo2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_INFO_2_KHR;
}
impl DisplayPlaneInfo2KHR {
    pub fn builder<'a>() -> DisplayPlaneInfo2KHRBuilder<'a> {
        DisplayPlaneInfo2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlaneInfo2KHRBuilder<'a> {
    inner: DisplayPlaneInfo2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlaneInfo2KHRBuilder<'a> {
    type Target = DisplayPlaneInfo2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlaneInfo2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlaneInfo2KHRBuilder<'a> {
    #[inline]
    pub fn mode(mut self, mode: DisplayModeKHR) -> Self {
        self.inner.mode = mode;
        self
    }
    #[inline]
    pub fn plane_index(mut self, plane_index: u32) -> Self {
        self.inner.plane_index = plane_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlaneInfo2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDisplayPlaneCapabilities2KHR.html>"]
pub struct DisplayPlaneCapabilities2KHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub capabilities: DisplayPlaneCapabilitiesKHR,
}
impl ::std::default::Default for DisplayPlaneCapabilities2KHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            capabilities: DisplayPlaneCapabilitiesKHR::default(),
        }
    }
}
unsafe impl TaggedStructure for DisplayPlaneCapabilities2KHR {
    const STRUCTURE_TYPE: StructureType = StructureType::DISPLAY_PLANE_CAPABILITIES_2_KHR;
}
impl DisplayPlaneCapabilities2KHR {
    pub fn builder<'a>() -> DisplayPlaneCapabilities2KHRBuilder<'a> {
        DisplayPlaneCapabilities2KHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DisplayPlaneCapabilities2KHRBuilder<'a> {
    inner: DisplayPlaneCapabilities2KHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DisplayPlaneCapabilities2KHRBuilder<'a> {
    type Target = DisplayPlaneCapabilities2KHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DisplayPlaneCapabilities2KHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DisplayPlaneCapabilities2KHRBuilder<'a> {
    #[inline]
    pub fn capabilities(mut self, capabilities: DisplayPlaneCapabilitiesKHR) -> Self {
        self.inner.capabilities = capabilities;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DisplayPlaneCapabilities2KHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSharedPresentSurfaceCapabilitiesKHR.html>"]
pub struct SharedPresentSurfaceCapabilitiesKHR {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shared_present_supported_usage_flags: ImageUsageFlags,
}
impl ::std::default::Default for SharedPresentSurfaceCapabilitiesKHR {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            shared_present_supported_usage_flags: ImageUsageFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for SharedPresentSurfaceCapabilitiesKHR {
    const STRUCTURE_TYPE: StructureType = StructureType::SHARED_PRESENT_SURFACE_CAPABILITIES_KHR;
}
impl SharedPresentSurfaceCapabilitiesKHR {
    pub fn builder<'a>() -> SharedPresentSurfaceCapabilitiesKHRBuilder<'a> {
        SharedPresentSurfaceCapabilitiesKHRBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SharedPresentSurfaceCapabilitiesKHRBuilder<'a> {
    inner: SharedPresentSurfaceCapabilitiesKHR,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSurfaceCapabilities2KHR for SharedPresentSurfaceCapabilitiesKHRBuilder<'_> {}
unsafe impl ExtendsSurfaceCapabilities2KHR for SharedPresentSurfaceCapabilitiesKHR {}
impl<'a> ::std::ops::Deref for SharedPresentSurfaceCapabilitiesKHRBuilder<'a> {
    type Target = SharedPresentSurfaceCapabilitiesKHR;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SharedPresentSurfaceCapabilitiesKHRBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SharedPresentSurfaceCapabilitiesKHRBuilder<'a> {
    #[inline]
    pub fn shared_present_supported_usage_flags(
        mut self,
        shared_present_supported_usage_flags: ImageUsageFlags,
    ) -> Self {
        self.inner.shared_present_supported_usage_flags = shared_present_supported_usage_flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SharedPresentSurfaceCapabilitiesKHR {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevice16BitStorageFeatures.html>"]
pub struct PhysicalDevice16BitStorageFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub storage_buffer16_bit_access: Bool32,
    pub uniform_and_storage_buffer16_bit_access: Bool32,
    pub storage_push_constant16: Bool32,
    pub storage_input_output16: Bool32,
}
impl ::std::default::Default for PhysicalDevice16BitStorageFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            storage_buffer16_bit_access: Bool32::default(),
            uniform_and_storage_buffer16_bit_access: Bool32::default(),
            storage_push_constant16: Bool32::default(),
            storage_input_output16: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevice16BitStorageFeatures {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES;
}
impl PhysicalDevice16BitStorageFeatures {
    pub fn builder<'a>() -> PhysicalDevice16BitStorageFeaturesBuilder<'a> {
        PhysicalDevice16BitStorageFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevice16BitStorageFeaturesBuilder<'a> {
    inner: PhysicalDevice16BitStorageFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice16BitStorageFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDevice16BitStorageFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice16BitStorageFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDevice16BitStorageFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDevice16BitStorageFeaturesBuilder<'a> {
    type Target = PhysicalDevice16BitStorageFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevice16BitStorageFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevice16BitStorageFeaturesBuilder<'a> {
    #[inline]
    pub fn storage_buffer16_bit_access(mut self, storage_buffer16_bit_access: bool) -> Self {
        self.inner.storage_buffer16_bit_access = storage_buffer16_bit_access.into();
        self
    }
    #[inline]
    pub fn uniform_and_storage_buffer16_bit_access(
        mut self,
        uniform_and_storage_buffer16_bit_access: bool,
    ) -> Self {
        self.inner.uniform_and_storage_buffer16_bit_access =
            uniform_and_storage_buffer16_bit_access.into();
        self
    }
    #[inline]
    pub fn storage_push_constant16(mut self, storage_push_constant16: bool) -> Self {
        self.inner.storage_push_constant16 = storage_push_constant16.into();
        self
    }
    #[inline]
    pub fn storage_input_output16(mut self, storage_input_output16: bool) -> Self {
        self.inner.storage_input_output16 = storage_input_output16.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevice16BitStorageFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSubgroupProperties.html>"]
pub struct PhysicalDeviceSubgroupProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub subgroup_size: u32,
    pub supported_stages: ShaderStageFlags,
    pub supported_operations: SubgroupFeatureFlags,
    pub quad_operations_in_all_stages: Bool32,
}
impl ::std::default::Default for PhysicalDeviceSubgroupProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            subgroup_size: u32::default(),
            supported_stages: ShaderStageFlags::default(),
            supported_operations: SubgroupFeatureFlags::default(),
            quad_operations_in_all_stages: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSubgroupProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_SUBGROUP_PROPERTIES;
}
impl PhysicalDeviceSubgroupProperties {
    pub fn builder<'a>() -> PhysicalDeviceSubgroupPropertiesBuilder<'a> {
        PhysicalDeviceSubgroupPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSubgroupPropertiesBuilder<'a> {
    inner: PhysicalDeviceSubgroupProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubgroupPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSubgroupProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSubgroupPropertiesBuilder<'a> {
    type Target = PhysicalDeviceSubgroupProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSubgroupPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSubgroupPropertiesBuilder<'a> {
    #[inline]
    pub fn subgroup_size(mut self, subgroup_size: u32) -> Self {
        self.inner.subgroup_size = subgroup_size;
        self
    }
    #[inline]
    pub fn supported_stages(mut self, supported_stages: ShaderStageFlags) -> Self {
        self.inner.supported_stages = supported_stages;
        self
    }
    #[inline]
    pub fn supported_operations(mut self, supported_operations: SubgroupFeatureFlags) -> Self {
        self.inner.supported_operations = supported_operations;
        self
    }
    #[inline]
    pub fn quad_operations_in_all_stages(mut self, quad_operations_in_all_stages: bool) -> Self {
        self.inner.quad_operations_in_all_stages = quad_operations_in_all_stages.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSubgroupProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures.html>"]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_subgroup_extended_types: Bool32,
}
impl ::std::default::Default for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            shader_subgroup_extended_types: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES;
}
impl PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    pub fn builder<'a>() -> PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'a> {
        PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'a> {
    inner: PhysicalDeviceShaderSubgroupExtendedTypesFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {}
unsafe impl ExtendsDeviceCreateInfo
    for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'_>
{
}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceShaderSubgroupExtendedTypesFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'a> {
    type Target = PhysicalDeviceShaderSubgroupExtendedTypesFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceShaderSubgroupExtendedTypesFeaturesBuilder<'a> {
    #[inline]
    pub fn shader_subgroup_extended_types(mut self, shader_subgroup_extended_types: bool) -> Self {
        self.inner.shader_subgroup_extended_types = shader_subgroup_extended_types.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceShaderSubgroupExtendedTypesFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBufferMemoryRequirementsInfo2.html>"]
pub struct BufferMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
}
impl ::std::default::Default for BufferMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            buffer: Buffer::default(),
        }
    }
}
unsafe impl TaggedStructure for BufferMemoryRequirementsInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::BUFFER_MEMORY_REQUIREMENTS_INFO_2;
}
impl BufferMemoryRequirementsInfo2 {
    pub fn builder<'a>() -> BufferMemoryRequirementsInfo2Builder<'a> {
        BufferMemoryRequirementsInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BufferMemoryRequirementsInfo2Builder<'a> {
    inner: BufferMemoryRequirementsInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for BufferMemoryRequirementsInfo2Builder<'a> {
    type Target = BufferMemoryRequirementsInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BufferMemoryRequirementsInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BufferMemoryRequirementsInfo2Builder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BufferMemoryRequirementsInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceBufferMemoryRequirements.html>"]
pub struct DeviceBufferMemoryRequirements {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_create_info: *const BufferCreateInfo,
}
impl ::std::default::Default for DeviceBufferMemoryRequirements {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_create_info: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for DeviceBufferMemoryRequirements {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_BUFFER_MEMORY_REQUIREMENTS;
}
impl DeviceBufferMemoryRequirements {
    pub fn builder<'a>() -> DeviceBufferMemoryRequirementsBuilder<'a> {
        DeviceBufferMemoryRequirementsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceBufferMemoryRequirementsBuilder<'a> {
    inner: DeviceBufferMemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DeviceBufferMemoryRequirementsBuilder<'a> {
    type Target = DeviceBufferMemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceBufferMemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceBufferMemoryRequirementsBuilder<'a> {
    #[inline]
    pub fn create_info(mut self, create_info: &'a BufferCreateInfo) -> Self {
        self.inner.p_create_info = create_info;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceBufferMemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageMemoryRequirementsInfo2.html>"]
pub struct ImageMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
}
impl ::std::default::Default for ImageMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            image: Image::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageMemoryRequirementsInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_MEMORY_REQUIREMENTS_INFO_2;
}
impl ImageMemoryRequirementsInfo2 {
    pub fn builder<'a>() -> ImageMemoryRequirementsInfo2Builder<'a> {
        ImageMemoryRequirementsInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageMemoryRequirementsInfo2Builder<'a> {
    inner: ImageMemoryRequirementsInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsImageMemoryRequirementsInfo2 {}
impl<'a> ::std::ops::Deref for ImageMemoryRequirementsInfo2Builder<'a> {
    type Target = ImageMemoryRequirementsInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageMemoryRequirementsInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageMemoryRequirementsInfo2Builder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsImageMemoryRequirementsInfo2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageMemoryRequirementsInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageSparseMemoryRequirementsInfo2.html>"]
pub struct ImageSparseMemoryRequirementsInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
}
impl ::std::default::Default for ImageSparseMemoryRequirementsInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            image: Image::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageSparseMemoryRequirementsInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2;
}
impl ImageSparseMemoryRequirementsInfo2 {
    pub fn builder<'a>() -> ImageSparseMemoryRequirementsInfo2Builder<'a> {
        ImageSparseMemoryRequirementsInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageSparseMemoryRequirementsInfo2Builder<'a> {
    inner: ImageSparseMemoryRequirementsInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ImageSparseMemoryRequirementsInfo2Builder<'a> {
    type Target = ImageSparseMemoryRequirementsInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageSparseMemoryRequirementsInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageSparseMemoryRequirementsInfo2Builder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageSparseMemoryRequirementsInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceImageMemoryRequirements.html>"]
pub struct DeviceImageMemoryRequirements {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub p_create_info: *const ImageCreateInfo,
    pub plane_aspect: ImageAspectFlags,
}
impl ::std::default::Default for DeviceImageMemoryRequirements {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            p_create_info: ::std::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceImageMemoryRequirements {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_IMAGE_MEMORY_REQUIREMENTS;
}
impl DeviceImageMemoryRequirements {
    pub fn builder<'a>() -> DeviceImageMemoryRequirementsBuilder<'a> {
        DeviceImageMemoryRequirementsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceImageMemoryRequirementsBuilder<'a> {
    inner: DeviceImageMemoryRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DeviceImageMemoryRequirementsBuilder<'a> {
    type Target = DeviceImageMemoryRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceImageMemoryRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceImageMemoryRequirementsBuilder<'a> {
    #[inline]
    pub fn create_info(mut self, create_info: &'a ImageCreateInfo) -> Self {
        self.inner.p_create_info = create_info;
        self
    }
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.inner.plane_aspect = plane_aspect;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceImageMemoryRequirements {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryRequirements2.html>"]
pub struct MemoryRequirements2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_requirements: MemoryRequirements,
}
impl ::std::default::Default for MemoryRequirements2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_requirements: MemoryRequirements::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryRequirements2 {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_REQUIREMENTS_2;
}
impl MemoryRequirements2 {
    pub fn builder<'a>() -> MemoryRequirements2Builder<'a> {
        MemoryRequirements2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryRequirements2Builder<'a> {
    inner: MemoryRequirements2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsMemoryRequirements2 {}
impl<'a> ::std::ops::Deref for MemoryRequirements2Builder<'a> {
    type Target = MemoryRequirements2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryRequirements2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryRequirements2Builder<'a> {
    #[inline]
    pub fn memory_requirements(mut self, memory_requirements: MemoryRequirements) -> Self {
        self.inner.memory_requirements = memory_requirements;
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsMemoryRequirements2>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryRequirements2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSparseImageMemoryRequirements2.html>"]
pub struct SparseImageMemoryRequirements2 {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub memory_requirements: SparseImageMemoryRequirements,
}
impl ::std::default::Default for SparseImageMemoryRequirements2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            memory_requirements: SparseImageMemoryRequirements::default(),
        }
    }
}
unsafe impl TaggedStructure for SparseImageMemoryRequirements2 {
    const STRUCTURE_TYPE: StructureType = StructureType::SPARSE_IMAGE_MEMORY_REQUIREMENTS_2;
}
impl SparseImageMemoryRequirements2 {
    pub fn builder<'a>() -> SparseImageMemoryRequirements2Builder<'a> {
        SparseImageMemoryRequirements2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SparseImageMemoryRequirements2Builder<'a> {
    inner: SparseImageMemoryRequirements2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SparseImageMemoryRequirements2Builder<'a> {
    type Target = SparseImageMemoryRequirements2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SparseImageMemoryRequirements2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SparseImageMemoryRequirements2Builder<'a> {
    #[inline]
    pub fn memory_requirements(
        mut self,
        memory_requirements: SparseImageMemoryRequirements,
    ) -> Self {
        self.inner.memory_requirements = memory_requirements;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SparseImageMemoryRequirements2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDevicePointClippingProperties.html>"]
pub struct PhysicalDevicePointClippingProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub point_clipping_behavior: PointClippingBehavior,
}
impl ::std::default::Default for PhysicalDevicePointClippingProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            point_clipping_behavior: PointClippingBehavior::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDevicePointClippingProperties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES;
}
impl PhysicalDevicePointClippingProperties {
    pub fn builder<'a>() -> PhysicalDevicePointClippingPropertiesBuilder<'a> {
        PhysicalDevicePointClippingPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDevicePointClippingPropertiesBuilder<'a> {
    inner: PhysicalDevicePointClippingProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePointClippingPropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDevicePointClippingProperties {}
impl<'a> ::std::ops::Deref for PhysicalDevicePointClippingPropertiesBuilder<'a> {
    type Target = PhysicalDevicePointClippingProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDevicePointClippingPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDevicePointClippingPropertiesBuilder<'a> {
    #[inline]
    pub fn point_clipping_behavior(
        mut self,
        point_clipping_behavior: PointClippingBehavior,
    ) -> Self {
        self.inner.point_clipping_behavior = point_clipping_behavior;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDevicePointClippingProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryDedicatedRequirements.html>"]
pub struct MemoryDedicatedRequirements {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub prefers_dedicated_allocation: Bool32,
    pub requires_dedicated_allocation: Bool32,
}
impl ::std::default::Default for MemoryDedicatedRequirements {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            prefers_dedicated_allocation: Bool32::default(),
            requires_dedicated_allocation: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryDedicatedRequirements {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_DEDICATED_REQUIREMENTS;
}
impl MemoryDedicatedRequirements {
    pub fn builder<'a>() -> MemoryDedicatedRequirementsBuilder<'a> {
        MemoryDedicatedRequirementsBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryDedicatedRequirementsBuilder<'a> {
    inner: MemoryDedicatedRequirements,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryRequirements2 for MemoryDedicatedRequirementsBuilder<'_> {}
unsafe impl ExtendsMemoryRequirements2 for MemoryDedicatedRequirements {}
impl<'a> ::std::ops::Deref for MemoryDedicatedRequirementsBuilder<'a> {
    type Target = MemoryDedicatedRequirements;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryDedicatedRequirementsBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryDedicatedRequirementsBuilder<'a> {
    #[inline]
    pub fn prefers_dedicated_allocation(mut self, prefers_dedicated_allocation: bool) -> Self {
        self.inner.prefers_dedicated_allocation = prefers_dedicated_allocation.into();
        self
    }
    #[inline]
    pub fn requires_dedicated_allocation(mut self, requires_dedicated_allocation: bool) -> Self {
        self.inner.requires_dedicated_allocation = requires_dedicated_allocation.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryDedicatedRequirements {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMemoryDedicatedAllocateInfo.html>"]
pub struct MemoryDedicatedAllocateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub image: Image,
    pub buffer: Buffer,
}
impl ::std::default::Default for MemoryDedicatedAllocateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            image: Image::default(),
            buffer: Buffer::default(),
        }
    }
}
unsafe impl TaggedStructure for MemoryDedicatedAllocateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::MEMORY_DEDICATED_ALLOCATE_INFO;
}
impl MemoryDedicatedAllocateInfo {
    pub fn builder<'a>() -> MemoryDedicatedAllocateInfoBuilder<'a> {
        MemoryDedicatedAllocateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MemoryDedicatedAllocateInfoBuilder<'a> {
    inner: MemoryDedicatedAllocateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsMemoryAllocateInfo for MemoryDedicatedAllocateInfoBuilder<'_> {}
unsafe impl ExtendsMemoryAllocateInfo for MemoryDedicatedAllocateInfo {}
impl<'a> ::std::ops::Deref for MemoryDedicatedAllocateInfoBuilder<'a> {
    type Target = MemoryDedicatedAllocateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MemoryDedicatedAllocateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MemoryDedicatedAllocateInfoBuilder<'a> {
    #[inline]
    pub fn image(mut self, image: Image) -> Self {
        self.inner.image = image;
        self
    }
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MemoryDedicatedAllocateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageViewUsageCreateInfo.html>"]
pub struct ImageViewUsageCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub usage: ImageUsageFlags,
}
impl ::std::default::Default for ImageViewUsageCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            usage: ImageUsageFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageViewUsageCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_USAGE_CREATE_INFO;
}
impl ImageViewUsageCreateInfo {
    pub fn builder<'a>() -> ImageViewUsageCreateInfoBuilder<'a> {
        ImageViewUsageCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageViewUsageCreateInfoBuilder<'a> {
    inner: ImageViewUsageCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageViewCreateInfo for ImageViewUsageCreateInfoBuilder<'_> {}
unsafe impl ExtendsImageViewCreateInfo for ImageViewUsageCreateInfo {}
impl<'a> ::std::ops::Deref for ImageViewUsageCreateInfoBuilder<'a> {
    type Target = ImageViewUsageCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageViewUsageCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageViewUsageCreateInfoBuilder<'a> {
    #[inline]
    pub fn usage(mut self, usage: ImageUsageFlags) -> Self {
        self.inner.usage = usage;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageViewUsageCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageViewSlicedCreateInfoEXT.html>"]
pub struct ImageViewSlicedCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub slice_offset: u32,
    pub slice_count: u32,
}
impl ::std::default::Default for ImageViewSlicedCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            slice_offset: u32::default(),
            slice_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for ImageViewSlicedCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_VIEW_SLICED_CREATE_INFO_EXT;
}
impl ImageViewSlicedCreateInfoEXT {
    pub fn builder<'a>() -> ImageViewSlicedCreateInfoEXTBuilder<'a> {
        ImageViewSlicedCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageViewSlicedCreateInfoEXTBuilder<'a> {
    inner: ImageViewSlicedCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageViewCreateInfo for ImageViewSlicedCreateInfoEXTBuilder<'_> {}
unsafe impl ExtendsImageViewCreateInfo for ImageViewSlicedCreateInfoEXT {}
impl<'a> ::std::ops::Deref for ImageViewSlicedCreateInfoEXTBuilder<'a> {
    type Target = ImageViewSlicedCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageViewSlicedCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageViewSlicedCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn slice_offset(mut self, slice_offset: u32) -> Self {
        self.inner.slice_offset = slice_offset;
        self
    }
    #[inline]
    pub fn slice_count(mut self, slice_count: u32) -> Self {
        self.inner.slice_count = slice_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageViewSlicedCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineTessellationDomainOriginStateCreateInfo.html>"]
pub struct PipelineTessellationDomainOriginStateCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub domain_origin: TessellationDomainOrigin,
}
impl ::std::default::Default for PipelineTessellationDomainOriginStateCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            domain_origin: TessellationDomainOrigin::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineTessellationDomainOriginStateCreateInfo {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO;
}
impl PipelineTessellationDomainOriginStateCreateInfo {
    pub fn builder<'a>() -> PipelineTessellationDomainOriginStateCreateInfoBuilder<'a> {
        PipelineTessellationDomainOriginStateCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineTessellationDomainOriginStateCreateInfoBuilder<'a> {
    inner: PipelineTessellationDomainOriginStateCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineTessellationStateCreateInfo
    for PipelineTessellationDomainOriginStateCreateInfoBuilder<'_>
{
}
unsafe impl ExtendsPipelineTessellationStateCreateInfo
    for PipelineTessellationDomainOriginStateCreateInfo
{
}
impl<'a> ::std::ops::Deref for PipelineTessellationDomainOriginStateCreateInfoBuilder<'a> {
    type Target = PipelineTessellationDomainOriginStateCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineTessellationDomainOriginStateCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineTessellationDomainOriginStateCreateInfoBuilder<'a> {
    #[inline]
    pub fn domain_origin(mut self, domain_origin: TessellationDomainOrigin) -> Self {
        self.inner.domain_origin = domain_origin;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineTessellationDomainOriginStateCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionInfo.html>"]
pub struct SamplerYcbcrConversionInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub conversion: SamplerYcbcrConversion,
}
impl ::std::default::Default for SamplerYcbcrConversionInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            conversion: SamplerYcbcrConversion::default(),
        }
    }
}
unsafe impl TaggedStructure for SamplerYcbcrConversionInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_YCBCR_CONVERSION_INFO;
}
impl SamplerYcbcrConversionInfo {
    pub fn builder<'a>() -> SamplerYcbcrConversionInfoBuilder<'a> {
        SamplerYcbcrConversionInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerYcbcrConversionInfoBuilder<'a> {
    inner: SamplerYcbcrConversionInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSamplerCreateInfo for SamplerYcbcrConversionInfoBuilder<'_> {}
unsafe impl ExtendsSamplerCreateInfo for SamplerYcbcrConversionInfo {}
unsafe impl ExtendsImageViewCreateInfo for SamplerYcbcrConversionInfoBuilder<'_> {}
unsafe impl ExtendsImageViewCreateInfo for SamplerYcbcrConversionInfo {}
impl<'a> ::std::ops::Deref for SamplerYcbcrConversionInfoBuilder<'a> {
    type Target = SamplerYcbcrConversionInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerYcbcrConversionInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerYcbcrConversionInfoBuilder<'a> {
    #[inline]
    pub fn conversion(mut self, conversion: SamplerYcbcrConversion) -> Self {
        self.inner.conversion = conversion;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerYcbcrConversionInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionCreateInfo.html>"]
pub struct SamplerYcbcrConversionCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub format: Format,
    pub ycbcr_model: SamplerYcbcrModelConversion,
    pub ycbcr_range: SamplerYcbcrRange,
    pub components: ComponentMapping,
    pub x_chroma_offset: ChromaLocation,
    pub y_chroma_offset: ChromaLocation,
    pub chroma_filter: Filter,
    pub force_explicit_reconstruction: Bool32,
}
impl ::std::default::Default for SamplerYcbcrConversionCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            format: Format::default(),
            ycbcr_model: SamplerYcbcrModelConversion::default(),
            ycbcr_range: SamplerYcbcrRange::default(),
            components: ComponentMapping::default(),
            x_chroma_offset: ChromaLocation::default(),
            y_chroma_offset: ChromaLocation::default(),
            chroma_filter: Filter::default(),
            force_explicit_reconstruction: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for SamplerYcbcrConversionCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_YCBCR_CONVERSION_CREATE_INFO;
}
impl SamplerYcbcrConversionCreateInfo {
    pub fn builder<'a>() -> SamplerYcbcrConversionCreateInfoBuilder<'a> {
        SamplerYcbcrConversionCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerYcbcrConversionCreateInfoBuilder<'a> {
    inner: SamplerYcbcrConversionCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsSamplerYcbcrConversionCreateInfo {}
impl<'a> ::std::ops::Deref for SamplerYcbcrConversionCreateInfoBuilder<'a> {
    type Target = SamplerYcbcrConversionCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerYcbcrConversionCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerYcbcrConversionCreateInfoBuilder<'a> {
    #[inline]
    pub fn format(mut self, format: Format) -> Self {
        self.inner.format = format;
        self
    }
    #[inline]
    pub fn ycbcr_model(mut self, ycbcr_model: SamplerYcbcrModelConversion) -> Self {
        self.inner.ycbcr_model = ycbcr_model;
        self
    }
    #[inline]
    pub fn ycbcr_range(mut self, ycbcr_range: SamplerYcbcrRange) -> Self {
        self.inner.ycbcr_range = ycbcr_range;
        self
    }
    #[inline]
    pub fn components(mut self, components: ComponentMapping) -> Self {
        self.inner.components = components;
        self
    }
    #[inline]
    pub fn x_chroma_offset(mut self, x_chroma_offset: ChromaLocation) -> Self {
        self.inner.x_chroma_offset = x_chroma_offset;
        self
    }
    #[inline]
    pub fn y_chroma_offset(mut self, y_chroma_offset: ChromaLocation) -> Self {
        self.inner.y_chroma_offset = y_chroma_offset;
        self
    }
    #[inline]
    pub fn chroma_filter(mut self, chroma_filter: Filter) -> Self {
        self.inner.chroma_filter = chroma_filter;
        self
    }
    #[inline]
    pub fn force_explicit_reconstruction(mut self, force_explicit_reconstruction: bool) -> Self {
        self.inner.force_explicit_reconstruction = force_explicit_reconstruction.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsSamplerYcbcrConversionCreateInfo>(
        mut self,
        next: &'a mut T,
    ) -> Self {
        unsafe {
            let next_ptr = <*const T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerYcbcrConversionCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkBindImagePlaneMemoryInfo.html>"]
pub struct BindImagePlaneMemoryInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
}
impl ::std::default::Default for BindImagePlaneMemoryInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for BindImagePlaneMemoryInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::BIND_IMAGE_PLANE_MEMORY_INFO;
}
impl BindImagePlaneMemoryInfo {
    pub fn builder<'a>() -> BindImagePlaneMemoryInfoBuilder<'a> {
        BindImagePlaneMemoryInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct BindImagePlaneMemoryInfoBuilder<'a> {
    inner: BindImagePlaneMemoryInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsBindImageMemoryInfo for BindImagePlaneMemoryInfoBuilder<'_> {}
unsafe impl ExtendsBindImageMemoryInfo for BindImagePlaneMemoryInfo {}
impl<'a> ::std::ops::Deref for BindImagePlaneMemoryInfoBuilder<'a> {
    type Target = BindImagePlaneMemoryInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for BindImagePlaneMemoryInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> BindImagePlaneMemoryInfoBuilder<'a> {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.inner.plane_aspect = plane_aspect;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> BindImagePlaneMemoryInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImagePlaneMemoryRequirementsInfo.html>"]
pub struct ImagePlaneMemoryRequirementsInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub plane_aspect: ImageAspectFlags,
}
impl ::std::default::Default for ImagePlaneMemoryRequirementsInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            plane_aspect: ImageAspectFlags::default(),
        }
    }
}
unsafe impl TaggedStructure for ImagePlaneMemoryRequirementsInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO;
}
impl ImagePlaneMemoryRequirementsInfo {
    pub fn builder<'a>() -> ImagePlaneMemoryRequirementsInfoBuilder<'a> {
        ImagePlaneMemoryRequirementsInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImagePlaneMemoryRequirementsInfoBuilder<'a> {
    inner: ImagePlaneMemoryRequirementsInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageMemoryRequirementsInfo2 for ImagePlaneMemoryRequirementsInfoBuilder<'_> {}
unsafe impl ExtendsImageMemoryRequirementsInfo2 for ImagePlaneMemoryRequirementsInfo {}
impl<'a> ::std::ops::Deref for ImagePlaneMemoryRequirementsInfoBuilder<'a> {
    type Target = ImagePlaneMemoryRequirementsInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImagePlaneMemoryRequirementsInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImagePlaneMemoryRequirementsInfoBuilder<'a> {
    #[inline]
    pub fn plane_aspect(mut self, plane_aspect: ImageAspectFlags) -> Self {
        self.inner.plane_aspect = plane_aspect;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImagePlaneMemoryRequirementsInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSamplerYcbcrConversionFeatures.html>"]
pub struct PhysicalDeviceSamplerYcbcrConversionFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub sampler_ycbcr_conversion: Bool32,
}
impl ::std::default::Default for PhysicalDeviceSamplerYcbcrConversionFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            sampler_ycbcr_conversion: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSamplerYcbcrConversionFeatures {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES;
}
impl PhysicalDeviceSamplerYcbcrConversionFeatures {
    pub fn builder<'a>() -> PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'a> {
        PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'a> {
    inner: PhysicalDeviceSamplerYcbcrConversionFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceSamplerYcbcrConversionFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceSamplerYcbcrConversionFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'a> {
    type Target = PhysicalDeviceSamplerYcbcrConversionFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSamplerYcbcrConversionFeaturesBuilder<'a> {
    #[inline]
    pub fn sampler_ycbcr_conversion(mut self, sampler_ycbcr_conversion: bool) -> Self {
        self.inner.sampler_ycbcr_conversion = sampler_ycbcr_conversion.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSamplerYcbcrConversionFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerYcbcrConversionImageFormatProperties.html>"]
pub struct SamplerYcbcrConversionImageFormatProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub combined_image_sampler_descriptor_count: u32,
}
impl ::std::default::Default for SamplerYcbcrConversionImageFormatProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            combined_image_sampler_descriptor_count: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for SamplerYcbcrConversionImageFormatProperties {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES;
}
impl SamplerYcbcrConversionImageFormatProperties {
    pub fn builder<'a>() -> SamplerYcbcrConversionImageFormatPropertiesBuilder<'a> {
        SamplerYcbcrConversionImageFormatPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerYcbcrConversionImageFormatPropertiesBuilder<'a> {
    inner: SamplerYcbcrConversionImageFormatProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageFormatProperties2
    for SamplerYcbcrConversionImageFormatPropertiesBuilder<'_>
{
}
unsafe impl ExtendsImageFormatProperties2 for SamplerYcbcrConversionImageFormatProperties {}
impl<'a> ::std::ops::Deref for SamplerYcbcrConversionImageFormatPropertiesBuilder<'a> {
    type Target = SamplerYcbcrConversionImageFormatProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerYcbcrConversionImageFormatPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerYcbcrConversionImageFormatPropertiesBuilder<'a> {
    #[inline]
    pub fn combined_image_sampler_descriptor_count(
        mut self,
        combined_image_sampler_descriptor_count: u32,
    ) -> Self {
        self.inner.combined_image_sampler_descriptor_count =
            combined_image_sampler_descriptor_count;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerYcbcrConversionImageFormatProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkTextureLODGatherFormatPropertiesAMD.html>"]
pub struct TextureLODGatherFormatPropertiesAMD {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supports_texture_gather_lod_bias_amd: Bool32,
}
impl ::std::default::Default for TextureLODGatherFormatPropertiesAMD {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            supports_texture_gather_lod_bias_amd: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for TextureLODGatherFormatPropertiesAMD {
    const STRUCTURE_TYPE: StructureType = StructureType::TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD;
}
impl TextureLODGatherFormatPropertiesAMD {
    pub fn builder<'a>() -> TextureLODGatherFormatPropertiesAMDBuilder<'a> {
        TextureLODGatherFormatPropertiesAMDBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct TextureLODGatherFormatPropertiesAMDBuilder<'a> {
    inner: TextureLODGatherFormatPropertiesAMD,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageFormatProperties2 for TextureLODGatherFormatPropertiesAMDBuilder<'_> {}
unsafe impl ExtendsImageFormatProperties2 for TextureLODGatherFormatPropertiesAMD {}
impl<'a> ::std::ops::Deref for TextureLODGatherFormatPropertiesAMDBuilder<'a> {
    type Target = TextureLODGatherFormatPropertiesAMD;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for TextureLODGatherFormatPropertiesAMDBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> TextureLODGatherFormatPropertiesAMDBuilder<'a> {
    #[inline]
    pub fn supports_texture_gather_lod_bias_amd(
        mut self,
        supports_texture_gather_lod_bias_amd: bool,
    ) -> Self {
        self.inner.supports_texture_gather_lod_bias_amd =
            supports_texture_gather_lod_bias_amd.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> TextureLODGatherFormatPropertiesAMD {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkConditionalRenderingBeginInfoEXT.html>"]
pub struct ConditionalRenderingBeginInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub buffer: Buffer,
    pub offset: DeviceSize,
    pub flags: ConditionalRenderingFlagsEXT,
}
impl ::std::default::Default for ConditionalRenderingBeginInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            buffer: Buffer::default(),
            offset: DeviceSize::default(),
            flags: ConditionalRenderingFlagsEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for ConditionalRenderingBeginInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::CONDITIONAL_RENDERING_BEGIN_INFO_EXT;
}
impl ConditionalRenderingBeginInfoEXT {
    pub fn builder<'a>() -> ConditionalRenderingBeginInfoEXTBuilder<'a> {
        ConditionalRenderingBeginInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ConditionalRenderingBeginInfoEXTBuilder<'a> {
    inner: ConditionalRenderingBeginInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ConditionalRenderingBeginInfoEXTBuilder<'a> {
    type Target = ConditionalRenderingBeginInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ConditionalRenderingBeginInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ConditionalRenderingBeginInfoEXTBuilder<'a> {
    #[inline]
    pub fn buffer(mut self, buffer: Buffer) -> Self {
        self.inner.buffer = buffer;
        self
    }
    #[inline]
    pub fn offset(mut self, offset: DeviceSize) -> Self {
        self.inner.offset = offset;
        self
    }
    #[inline]
    pub fn flags(mut self, flags: ConditionalRenderingFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ConditionalRenderingBeginInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkProtectedSubmitInfo.html>"]
pub struct ProtectedSubmitInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub protected_submit: Bool32,
}
impl ::std::default::Default for ProtectedSubmitInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            protected_submit: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for ProtectedSubmitInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::PROTECTED_SUBMIT_INFO;
}
impl ProtectedSubmitInfo {
    pub fn builder<'a>() -> ProtectedSubmitInfoBuilder<'a> {
        ProtectedSubmitInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ProtectedSubmitInfoBuilder<'a> {
    inner: ProtectedSubmitInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSubmitInfo for ProtectedSubmitInfoBuilder<'_> {}
unsafe impl ExtendsSubmitInfo for ProtectedSubmitInfo {}
impl<'a> ::std::ops::Deref for ProtectedSubmitInfoBuilder<'a> {
    type Target = ProtectedSubmitInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ProtectedSubmitInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ProtectedSubmitInfoBuilder<'a> {
    #[inline]
    pub fn protected_submit(mut self, protected_submit: bool) -> Self {
        self.inner.protected_submit = protected_submit.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ProtectedSubmitInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProtectedMemoryFeatures.html>"]
pub struct PhysicalDeviceProtectedMemoryFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub protected_memory: Bool32,
}
impl ::std::default::Default for PhysicalDeviceProtectedMemoryFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            protected_memory: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceProtectedMemoryFeatures {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES;
}
impl PhysicalDeviceProtectedMemoryFeatures {
    pub fn builder<'a>() -> PhysicalDeviceProtectedMemoryFeaturesBuilder<'a> {
        PhysicalDeviceProtectedMemoryFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceProtectedMemoryFeaturesBuilder<'a> {
    inner: PhysicalDeviceProtectedMemoryFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceProtectedMemoryFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceProtectedMemoryFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceProtectedMemoryFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceProtectedMemoryFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceProtectedMemoryFeaturesBuilder<'a> {
    type Target = PhysicalDeviceProtectedMemoryFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceProtectedMemoryFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceProtectedMemoryFeaturesBuilder<'a> {
    #[inline]
    pub fn protected_memory(mut self, protected_memory: bool) -> Self {
        self.inner.protected_memory = protected_memory.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProtectedMemoryFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceProtectedMemoryProperties.html>"]
pub struct PhysicalDeviceProtectedMemoryProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub protected_no_fault: Bool32,
}
impl ::std::default::Default for PhysicalDeviceProtectedMemoryProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            protected_no_fault: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceProtectedMemoryProperties {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES;
}
impl PhysicalDeviceProtectedMemoryProperties {
    pub fn builder<'a>() -> PhysicalDeviceProtectedMemoryPropertiesBuilder<'a> {
        PhysicalDeviceProtectedMemoryPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceProtectedMemoryPropertiesBuilder<'a> {
    inner: PhysicalDeviceProtectedMemoryProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceProtectedMemoryPropertiesBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceProtectedMemoryProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceProtectedMemoryPropertiesBuilder<'a> {
    type Target = PhysicalDeviceProtectedMemoryProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceProtectedMemoryPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceProtectedMemoryPropertiesBuilder<'a> {
    #[inline]
    pub fn protected_no_fault(mut self, protected_no_fault: bool) -> Self {
        self.inner.protected_no_fault = protected_no_fault.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceProtectedMemoryProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDeviceQueueInfo2.html>"]
pub struct DeviceQueueInfo2 {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: DeviceQueueCreateFlags,
    pub queue_family_index: u32,
    pub queue_index: u32,
}
impl ::std::default::Default for DeviceQueueInfo2 {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: DeviceQueueCreateFlags::default(),
            queue_family_index: u32::default(),
            queue_index: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DeviceQueueInfo2 {
    const STRUCTURE_TYPE: StructureType = StructureType::DEVICE_QUEUE_INFO_2;
}
impl DeviceQueueInfo2 {
    pub fn builder<'a>() -> DeviceQueueInfo2Builder<'a> {
        DeviceQueueInfo2Builder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DeviceQueueInfo2Builder<'a> {
    inner: DeviceQueueInfo2,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for DeviceQueueInfo2Builder<'a> {
    type Target = DeviceQueueInfo2;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DeviceQueueInfo2Builder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DeviceQueueInfo2Builder<'a> {
    #[inline]
    pub fn flags(mut self, flags: DeviceQueueCreateFlags) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn queue_family_index(mut self, queue_family_index: u32) -> Self {
        self.inner.queue_family_index = queue_family_index;
        self
    }
    #[inline]
    pub fn queue_index(mut self, queue_index: u32) -> Self {
        self.inner.queue_index = queue_index;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DeviceQueueInfo2 {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageToColorStateCreateInfoNV.html>"]
pub struct PipelineCoverageToColorStateCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCoverageToColorStateCreateFlagsNV,
    pub coverage_to_color_enable: Bool32,
    pub coverage_to_color_location: u32,
}
impl ::std::default::Default for PipelineCoverageToColorStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineCoverageToColorStateCreateFlagsNV::default(),
            coverage_to_color_enable: Bool32::default(),
            coverage_to_color_location: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineCoverageToColorStateCreateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV;
}
impl PipelineCoverageToColorStateCreateInfoNV {
    pub fn builder<'a>() -> PipelineCoverageToColorStateCreateInfoNVBuilder<'a> {
        PipelineCoverageToColorStateCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineCoverageToColorStateCreateInfoNVBuilder<'a> {
    inner: PipelineCoverageToColorStateCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineCoverageToColorStateCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo for PipelineCoverageToColorStateCreateInfoNV {}
impl<'a> ::std::ops::Deref for PipelineCoverageToColorStateCreateInfoNVBuilder<'a> {
    type Target = PipelineCoverageToColorStateCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineCoverageToColorStateCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineCoverageToColorStateCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageToColorStateCreateFlagsNV) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn coverage_to_color_enable(mut self, coverage_to_color_enable: bool) -> Self {
        self.inner.coverage_to_color_enable = coverage_to_color_enable.into();
        self
    }
    #[inline]
    pub fn coverage_to_color_location(mut self, coverage_to_color_location: u32) -> Self {
        self.inner.coverage_to_color_location = coverage_to_color_location;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineCoverageToColorStateCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSamplerFilterMinmaxProperties.html>"]
pub struct PhysicalDeviceSamplerFilterMinmaxProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub filter_minmax_single_component_formats: Bool32,
    pub filter_minmax_image_component_mapping: Bool32,
}
impl ::std::default::Default for PhysicalDeviceSamplerFilterMinmaxProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            filter_minmax_single_component_formats: Bool32::default(),
            filter_minmax_image_component_mapping: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSamplerFilterMinmaxProperties {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES;
}
impl PhysicalDeviceSamplerFilterMinmaxProperties {
    pub fn builder<'a>() -> PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'a> {
        PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'a> {
    inner: PhysicalDeviceSamplerFilterMinmaxProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSamplerFilterMinmaxProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'a> {
    type Target = PhysicalDeviceSamplerFilterMinmaxProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSamplerFilterMinmaxPropertiesBuilder<'a> {
    #[inline]
    pub fn filter_minmax_single_component_formats(
        mut self,
        filter_minmax_single_component_formats: bool,
    ) -> Self {
        self.inner.filter_minmax_single_component_formats =
            filter_minmax_single_component_formats.into();
        self
    }
    #[inline]
    pub fn filter_minmax_image_component_mapping(
        mut self,
        filter_minmax_image_component_mapping: bool,
    ) -> Self {
        self.inner.filter_minmax_image_component_mapping =
            filter_minmax_image_component_mapping.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSamplerFilterMinmaxProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSampleLocationEXT.html>"]
pub struct SampleLocationEXT {
    pub x: f32,
    pub y: f32,
}
impl SampleLocationEXT {
    pub fn builder<'a>() -> SampleLocationEXTBuilder<'a> {
        SampleLocationEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SampleLocationEXTBuilder<'a> {
    inner: SampleLocationEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SampleLocationEXTBuilder<'a> {
    type Target = SampleLocationEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SampleLocationEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SampleLocationEXTBuilder<'a> {
    #[inline]
    pub fn x(mut self, x: f32) -> Self {
        self.inner.x = x;
        self
    }
    #[inline]
    pub fn y(mut self, y: f32) -> Self {
        self.inner.y = y;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SampleLocationEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSampleLocationsInfoEXT.html>"]
pub struct SampleLocationsInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub sample_locations_per_pixel: SampleCountFlags,
    pub sample_location_grid_size: Extent2D,
    pub sample_locations_count: u32,
    pub p_sample_locations: *const SampleLocationEXT,
}
impl ::std::default::Default for SampleLocationsInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            sample_locations_per_pixel: SampleCountFlags::default(),
            sample_location_grid_size: Extent2D::default(),
            sample_locations_count: u32::default(),
            p_sample_locations: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for SampleLocationsInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLE_LOCATIONS_INFO_EXT;
}
impl SampleLocationsInfoEXT {
    pub fn builder<'a>() -> SampleLocationsInfoEXTBuilder<'a> {
        SampleLocationsInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SampleLocationsInfoEXTBuilder<'a> {
    inner: SampleLocationsInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageMemoryBarrier for SampleLocationsInfoEXTBuilder<'_> {}
unsafe impl ExtendsImageMemoryBarrier for SampleLocationsInfoEXT {}
unsafe impl ExtendsImageMemoryBarrier2 for SampleLocationsInfoEXTBuilder<'_> {}
unsafe impl ExtendsImageMemoryBarrier2 for SampleLocationsInfoEXT {}
impl<'a> ::std::ops::Deref for SampleLocationsInfoEXTBuilder<'a> {
    type Target = SampleLocationsInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SampleLocationsInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SampleLocationsInfoEXTBuilder<'a> {
    #[inline]
    pub fn sample_locations_per_pixel(
        mut self,
        sample_locations_per_pixel: SampleCountFlags,
    ) -> Self {
        self.inner.sample_locations_per_pixel = sample_locations_per_pixel;
        self
    }
    #[inline]
    pub fn sample_location_grid_size(mut self, sample_location_grid_size: Extent2D) -> Self {
        self.inner.sample_location_grid_size = sample_location_grid_size;
        self
    }
    #[inline]
    pub fn sample_locations(mut self, sample_locations: &'a [SampleLocationEXT]) -> Self {
        self.inner.sample_locations_count = sample_locations.len() as _;
        self.inner.p_sample_locations = sample_locations.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SampleLocationsInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkAttachmentSampleLocationsEXT.html>"]
pub struct AttachmentSampleLocationsEXT {
    pub attachment_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}
impl AttachmentSampleLocationsEXT {
    pub fn builder<'a>() -> AttachmentSampleLocationsEXTBuilder<'a> {
        AttachmentSampleLocationsEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct AttachmentSampleLocationsEXTBuilder<'a> {
    inner: AttachmentSampleLocationsEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for AttachmentSampleLocationsEXTBuilder<'a> {
    type Target = AttachmentSampleLocationsEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for AttachmentSampleLocationsEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> AttachmentSampleLocationsEXTBuilder<'a> {
    #[inline]
    pub fn attachment_index(mut self, attachment_index: u32) -> Self {
        self.inner.attachment_index = attachment_index;
        self
    }
    #[inline]
    pub fn sample_locations_info(mut self, sample_locations_info: SampleLocationsInfoEXT) -> Self {
        self.inner.sample_locations_info = sample_locations_info;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> AttachmentSampleLocationsEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone, Default)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSubpassSampleLocationsEXT.html>"]
pub struct SubpassSampleLocationsEXT {
    pub subpass_index: u32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}
impl SubpassSampleLocationsEXT {
    pub fn builder<'a>() -> SubpassSampleLocationsEXTBuilder<'a> {
        SubpassSampleLocationsEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SubpassSampleLocationsEXTBuilder<'a> {
    inner: SubpassSampleLocationsEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for SubpassSampleLocationsEXTBuilder<'a> {
    type Target = SubpassSampleLocationsEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SubpassSampleLocationsEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SubpassSampleLocationsEXTBuilder<'a> {
    #[inline]
    pub fn subpass_index(mut self, subpass_index: u32) -> Self {
        self.inner.subpass_index = subpass_index;
        self
    }
    #[inline]
    pub fn sample_locations_info(mut self, sample_locations_info: SampleLocationsInfoEXT) -> Self {
        self.inner.sample_locations_info = sample_locations_info;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SubpassSampleLocationsEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkRenderPassSampleLocationsBeginInfoEXT.html>"]
pub struct RenderPassSampleLocationsBeginInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub attachment_initial_sample_locations_count: u32,
    pub p_attachment_initial_sample_locations: *const AttachmentSampleLocationsEXT,
    pub post_subpass_sample_locations_count: u32,
    pub p_post_subpass_sample_locations: *const SubpassSampleLocationsEXT,
}
impl ::std::default::Default for RenderPassSampleLocationsBeginInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            attachment_initial_sample_locations_count: u32::default(),
            p_attachment_initial_sample_locations: ::std::ptr::null(),
            post_subpass_sample_locations_count: u32::default(),
            p_post_subpass_sample_locations: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for RenderPassSampleLocationsBeginInfoEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT;
}
impl RenderPassSampleLocationsBeginInfoEXT {
    pub fn builder<'a>() -> RenderPassSampleLocationsBeginInfoEXTBuilder<'a> {
        RenderPassSampleLocationsBeginInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct RenderPassSampleLocationsBeginInfoEXTBuilder<'a> {
    inner: RenderPassSampleLocationsBeginInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsRenderPassBeginInfo for RenderPassSampleLocationsBeginInfoEXTBuilder<'_> {}
unsafe impl ExtendsRenderPassBeginInfo for RenderPassSampleLocationsBeginInfoEXT {}
impl<'a> ::std::ops::Deref for RenderPassSampleLocationsBeginInfoEXTBuilder<'a> {
    type Target = RenderPassSampleLocationsBeginInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for RenderPassSampleLocationsBeginInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> RenderPassSampleLocationsBeginInfoEXTBuilder<'a> {
    #[inline]
    pub fn attachment_initial_sample_locations(
        mut self,
        attachment_initial_sample_locations: &'a [AttachmentSampleLocationsEXT],
    ) -> Self {
        self.inner.attachment_initial_sample_locations_count =
            attachment_initial_sample_locations.len() as _;
        self.inner.p_attachment_initial_sample_locations =
            attachment_initial_sample_locations.as_ptr();
        self
    }
    #[inline]
    pub fn post_subpass_sample_locations(
        mut self,
        post_subpass_sample_locations: &'a [SubpassSampleLocationsEXT],
    ) -> Self {
        self.inner.post_subpass_sample_locations_count = post_subpass_sample_locations.len() as _;
        self.inner.p_post_subpass_sample_locations = post_subpass_sample_locations.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> RenderPassSampleLocationsBeginInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineSampleLocationsStateCreateInfoEXT.html>"]
pub struct PipelineSampleLocationsStateCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub sample_locations_enable: Bool32,
    pub sample_locations_info: SampleLocationsInfoEXT,
}
impl ::std::default::Default for PipelineSampleLocationsStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            sample_locations_enable: Bool32::default(),
            sample_locations_info: SampleLocationsInfoEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineSampleLocationsStateCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT;
}
impl PipelineSampleLocationsStateCreateInfoEXT {
    pub fn builder<'a>() -> PipelineSampleLocationsStateCreateInfoEXTBuilder<'a> {
        PipelineSampleLocationsStateCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineSampleLocationsStateCreateInfoEXTBuilder<'a> {
    inner: PipelineSampleLocationsStateCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineSampleLocationsStateCreateInfoEXTBuilder<'_>
{
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineSampleLocationsStateCreateInfoEXT
{
}
impl<'a> ::std::ops::Deref for PipelineSampleLocationsStateCreateInfoEXTBuilder<'a> {
    type Target = PipelineSampleLocationsStateCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineSampleLocationsStateCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineSampleLocationsStateCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn sample_locations_enable(mut self, sample_locations_enable: bool) -> Self {
        self.inner.sample_locations_enable = sample_locations_enable.into();
        self
    }
    #[inline]
    pub fn sample_locations_info(mut self, sample_locations_info: SampleLocationsInfoEXT) -> Self {
        self.inner.sample_locations_info = sample_locations_info;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineSampleLocationsStateCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceSampleLocationsPropertiesEXT.html>"]
pub struct PhysicalDeviceSampleLocationsPropertiesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub sample_location_sample_counts: SampleCountFlags,
    pub max_sample_location_grid_size: Extent2D,
    pub sample_location_coordinate_range: [f32; 2],
    pub sample_location_sub_pixel_bits: u32,
    pub variable_sample_locations: Bool32,
}
impl ::std::default::Default for PhysicalDeviceSampleLocationsPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            sample_location_sample_counts: SampleCountFlags::default(),
            max_sample_location_grid_size: Extent2D::default(),
            sample_location_coordinate_range: unsafe { ::std::mem::zeroed() },
            sample_location_sub_pixel_bits: u32::default(),
            variable_sample_locations: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceSampleLocationsPropertiesEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT;
}
impl PhysicalDeviceSampleLocationsPropertiesEXT {
    pub fn builder<'a>() -> PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'a> {
        PhysicalDeviceSampleLocationsPropertiesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'a> {
    inner: PhysicalDeviceSampleLocationsPropertiesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceSampleLocationsPropertiesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'a> {
    type Target = PhysicalDeviceSampleLocationsPropertiesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceSampleLocationsPropertiesEXTBuilder<'a> {
    #[inline]
    pub fn sample_location_sample_counts(
        mut self,
        sample_location_sample_counts: SampleCountFlags,
    ) -> Self {
        self.inner.sample_location_sample_counts = sample_location_sample_counts;
        self
    }
    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: Extent2D,
    ) -> Self {
        self.inner.max_sample_location_grid_size = max_sample_location_grid_size;
        self
    }
    #[inline]
    pub fn sample_location_coordinate_range(
        mut self,
        sample_location_coordinate_range: [f32; 2],
    ) -> Self {
        self.inner.sample_location_coordinate_range = sample_location_coordinate_range;
        self
    }
    #[inline]
    pub fn sample_location_sub_pixel_bits(mut self, sample_location_sub_pixel_bits: u32) -> Self {
        self.inner.sample_location_sub_pixel_bits = sample_location_sub_pixel_bits;
        self
    }
    #[inline]
    pub fn variable_sample_locations(mut self, variable_sample_locations: bool) -> Self {
        self.inner.variable_sample_locations = variable_sample_locations.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceSampleLocationsPropertiesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkMultisamplePropertiesEXT.html>"]
pub struct MultisamplePropertiesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_sample_location_grid_size: Extent2D,
}
impl ::std::default::Default for MultisamplePropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_sample_location_grid_size: Extent2D::default(),
        }
    }
}
unsafe impl TaggedStructure for MultisamplePropertiesEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::MULTISAMPLE_PROPERTIES_EXT;
}
impl MultisamplePropertiesEXT {
    pub fn builder<'a>() -> MultisamplePropertiesEXTBuilder<'a> {
        MultisamplePropertiesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct MultisamplePropertiesEXTBuilder<'a> {
    inner: MultisamplePropertiesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for MultisamplePropertiesEXTBuilder<'a> {
    type Target = MultisamplePropertiesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for MultisamplePropertiesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> MultisamplePropertiesEXTBuilder<'a> {
    #[inline]
    pub fn max_sample_location_grid_size(
        mut self,
        max_sample_location_grid_size: Extent2D,
    ) -> Self {
        self.inner.max_sample_location_grid_size = max_sample_location_grid_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> MultisamplePropertiesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkSamplerReductionModeCreateInfo.html>"]
pub struct SamplerReductionModeCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub reduction_mode: SamplerReductionMode,
}
impl ::std::default::Default for SamplerReductionModeCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            reduction_mode: SamplerReductionMode::default(),
        }
    }
}
unsafe impl TaggedStructure for SamplerReductionModeCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::SAMPLER_REDUCTION_MODE_CREATE_INFO;
}
impl SamplerReductionModeCreateInfo {
    pub fn builder<'a>() -> SamplerReductionModeCreateInfoBuilder<'a> {
        SamplerReductionModeCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct SamplerReductionModeCreateInfoBuilder<'a> {
    inner: SamplerReductionModeCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsSamplerCreateInfo for SamplerReductionModeCreateInfoBuilder<'_> {}
unsafe impl ExtendsSamplerCreateInfo for SamplerReductionModeCreateInfo {}
impl<'a> ::std::ops::Deref for SamplerReductionModeCreateInfoBuilder<'a> {
    type Target = SamplerReductionModeCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for SamplerReductionModeCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> SamplerReductionModeCreateInfoBuilder<'a> {
    #[inline]
    pub fn reduction_mode(mut self, reduction_mode: SamplerReductionMode) -> Self {
        self.inner.reduction_mode = reduction_mode;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> SamplerReductionModeCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT.html>"]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub advanced_blend_coherent_operations: Bool32,
}
impl ::std::default::Default for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            advanced_blend_coherent_operations: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT;
}
impl PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
    pub fn builder<'a>() -> PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'a> {
        PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'a> {
    inner: PhysicalDeviceBlendOperationAdvancedFeaturesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2
    for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceBlendOperationAdvancedFeaturesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'a> {
    type Target = PhysicalDeviceBlendOperationAdvancedFeaturesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceBlendOperationAdvancedFeaturesEXTBuilder<'a> {
    #[inline]
    pub fn advanced_blend_coherent_operations(
        mut self,
        advanced_blend_coherent_operations: bool,
    ) -> Self {
        self.inner.advanced_blend_coherent_operations = advanced_blend_coherent_operations.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceBlendOperationAdvancedFeaturesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMultiDrawFeaturesEXT.html>"]
pub struct PhysicalDeviceMultiDrawFeaturesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub multi_draw: Bool32,
}
impl ::std::default::Default for PhysicalDeviceMultiDrawFeaturesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            multi_draw: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMultiDrawFeaturesEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT;
}
impl PhysicalDeviceMultiDrawFeaturesEXT {
    pub fn builder<'a>() -> PhysicalDeviceMultiDrawFeaturesEXTBuilder<'a> {
        PhysicalDeviceMultiDrawFeaturesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMultiDrawFeaturesEXTBuilder<'a> {
    inner: PhysicalDeviceMultiDrawFeaturesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiDrawFeaturesEXTBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMultiDrawFeaturesEXT {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiDrawFeaturesEXTBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMultiDrawFeaturesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMultiDrawFeaturesEXTBuilder<'a> {
    type Target = PhysicalDeviceMultiDrawFeaturesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMultiDrawFeaturesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMultiDrawFeaturesEXTBuilder<'a> {
    #[inline]
    pub fn multi_draw(mut self, multi_draw: bool) -> Self {
        self.inner.multi_draw = multi_draw.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMultiDrawFeaturesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT.html>"]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub advanced_blend_max_color_attachments: u32,
    pub advanced_blend_independent_blend: Bool32,
    pub advanced_blend_non_premultiplied_src_color: Bool32,
    pub advanced_blend_non_premultiplied_dst_color: Bool32,
    pub advanced_blend_correlated_overlap: Bool32,
    pub advanced_blend_all_operations: Bool32,
}
impl ::std::default::Default for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            advanced_blend_max_color_attachments: u32::default(),
            advanced_blend_independent_blend: Bool32::default(),
            advanced_blend_non_premultiplied_src_color: Bool32::default(),
            advanced_blend_non_premultiplied_dst_color: Bool32::default(),
            advanced_blend_correlated_overlap: Bool32::default(),
            advanced_blend_all_operations: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT;
}
impl PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
    pub fn builder<'a>() -> PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'a> {
        PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'a> {
    inner: PhysicalDeviceBlendOperationAdvancedPropertiesEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceBlendOperationAdvancedPropertiesEXT {}
impl<'a> ::std::ops::Deref for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'a> {
    type Target = PhysicalDeviceBlendOperationAdvancedPropertiesEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceBlendOperationAdvancedPropertiesEXTBuilder<'a> {
    #[inline]
    pub fn advanced_blend_max_color_attachments(
        mut self,
        advanced_blend_max_color_attachments: u32,
    ) -> Self {
        self.inner.advanced_blend_max_color_attachments = advanced_blend_max_color_attachments;
        self
    }
    #[inline]
    pub fn advanced_blend_independent_blend(
        mut self,
        advanced_blend_independent_blend: bool,
    ) -> Self {
        self.inner.advanced_blend_independent_blend = advanced_blend_independent_blend.into();
        self
    }
    #[inline]
    pub fn advanced_blend_non_premultiplied_src_color(
        mut self,
        advanced_blend_non_premultiplied_src_color: bool,
    ) -> Self {
        self.inner.advanced_blend_non_premultiplied_src_color =
            advanced_blend_non_premultiplied_src_color.into();
        self
    }
    #[inline]
    pub fn advanced_blend_non_premultiplied_dst_color(
        mut self,
        advanced_blend_non_premultiplied_dst_color: bool,
    ) -> Self {
        self.inner.advanced_blend_non_premultiplied_dst_color =
            advanced_blend_non_premultiplied_dst_color.into();
        self
    }
    #[inline]
    pub fn advanced_blend_correlated_overlap(
        mut self,
        advanced_blend_correlated_overlap: bool,
    ) -> Self {
        self.inner.advanced_blend_correlated_overlap = advanced_blend_correlated_overlap.into();
        self
    }
    #[inline]
    pub fn advanced_blend_all_operations(mut self, advanced_blend_all_operations: bool) -> Self {
        self.inner.advanced_blend_all_operations = advanced_blend_all_operations.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceBlendOperationAdvancedPropertiesEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineColorBlendAdvancedStateCreateInfoEXT.html>"]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub src_premultiplied: Bool32,
    pub dst_premultiplied: Bool32,
    pub blend_overlap: BlendOverlapEXT,
}
impl ::std::default::Default for PipelineColorBlendAdvancedStateCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            src_premultiplied: Bool32::default(),
            dst_premultiplied: Bool32::default(),
            blend_overlap: BlendOverlapEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for PipelineColorBlendAdvancedStateCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT;
}
impl PipelineColorBlendAdvancedStateCreateInfoEXT {
    pub fn builder<'a>() -> PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'a> {
        PipelineColorBlendAdvancedStateCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'a> {
    inner: PipelineColorBlendAdvancedStateCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineColorBlendStateCreateInfo
    for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'_>
{
}
unsafe impl ExtendsPipelineColorBlendStateCreateInfo
    for PipelineColorBlendAdvancedStateCreateInfoEXT
{
}
impl<'a> ::std::ops::Deref for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'a> {
    type Target = PipelineColorBlendAdvancedStateCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineColorBlendAdvancedStateCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn src_premultiplied(mut self, src_premultiplied: bool) -> Self {
        self.inner.src_premultiplied = src_premultiplied.into();
        self
    }
    #[inline]
    pub fn dst_premultiplied(mut self, dst_premultiplied: bool) -> Self {
        self.inner.dst_premultiplied = dst_premultiplied.into();
        self
    }
    #[inline]
    pub fn blend_overlap(mut self, blend_overlap: BlendOverlapEXT) -> Self {
        self.inner.blend_overlap = blend_overlap;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineColorBlendAdvancedStateCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceInlineUniformBlockFeatures.html>"]
pub struct PhysicalDeviceInlineUniformBlockFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub inline_uniform_block: Bool32,
    pub descriptor_binding_inline_uniform_block_update_after_bind: Bool32,
}
impl ::std::default::Default for PhysicalDeviceInlineUniformBlockFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            inline_uniform_block: Bool32::default(),
            descriptor_binding_inline_uniform_block_update_after_bind: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceInlineUniformBlockFeatures {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES;
}
impl PhysicalDeviceInlineUniformBlockFeatures {
    pub fn builder<'a>() -> PhysicalDeviceInlineUniformBlockFeaturesBuilder<'a> {
        PhysicalDeviceInlineUniformBlockFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceInlineUniformBlockFeaturesBuilder<'a> {
    inner: PhysicalDeviceInlineUniformBlockFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInlineUniformBlockFeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceInlineUniformBlockFeatures {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInlineUniformBlockFeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceInlineUniformBlockFeatures {}
impl<'a> ::std::ops::Deref for PhysicalDeviceInlineUniformBlockFeaturesBuilder<'a> {
    type Target = PhysicalDeviceInlineUniformBlockFeatures;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceInlineUniformBlockFeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceInlineUniformBlockFeaturesBuilder<'a> {
    #[inline]
    pub fn inline_uniform_block(mut self, inline_uniform_block: bool) -> Self {
        self.inner.inline_uniform_block = inline_uniform_block.into();
        self
    }
    #[inline]
    pub fn descriptor_binding_inline_uniform_block_update_after_bind(
        mut self,
        descriptor_binding_inline_uniform_block_update_after_bind: bool,
    ) -> Self {
        self.inner
            .descriptor_binding_inline_uniform_block_update_after_bind =
            descriptor_binding_inline_uniform_block_update_after_bind.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceInlineUniformBlockFeatures {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceInlineUniformBlockProperties.html>"]
pub struct PhysicalDeviceInlineUniformBlockProperties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_inline_uniform_block_size: u32,
    pub max_per_stage_descriptor_inline_uniform_blocks: u32,
    pub max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    pub max_descriptor_set_inline_uniform_blocks: u32,
    pub max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
}
impl ::std::default::Default for PhysicalDeviceInlineUniformBlockProperties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_inline_uniform_block_size: u32::default(),
            max_per_stage_descriptor_inline_uniform_blocks: u32::default(),
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32::default(),
            max_descriptor_set_inline_uniform_blocks: u32::default(),
            max_descriptor_set_update_after_bind_inline_uniform_blocks: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceInlineUniformBlockProperties {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES;
}
impl PhysicalDeviceInlineUniformBlockProperties {
    pub fn builder<'a>() -> PhysicalDeviceInlineUniformBlockPropertiesBuilder<'a> {
        PhysicalDeviceInlineUniformBlockPropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceInlineUniformBlockPropertiesBuilder<'a> {
    inner: PhysicalDeviceInlineUniformBlockProperties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2
    for PhysicalDeviceInlineUniformBlockPropertiesBuilder<'_>
{
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceInlineUniformBlockProperties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceInlineUniformBlockPropertiesBuilder<'a> {
    type Target = PhysicalDeviceInlineUniformBlockProperties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceInlineUniformBlockPropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceInlineUniformBlockPropertiesBuilder<'a> {
    #[inline]
    pub fn max_inline_uniform_block_size(mut self, max_inline_uniform_block_size: u32) -> Self {
        self.inner.max_inline_uniform_block_size = max_inline_uniform_block_size;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_inline_uniform_blocks: u32,
    ) -> Self {
        self.inner.max_per_stage_descriptor_inline_uniform_blocks =
            max_per_stage_descriptor_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_per_stage_descriptor_update_after_bind_inline_uniform_blocks(
        mut self,
        max_per_stage_descriptor_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.inner
            .max_per_stage_descriptor_update_after_bind_inline_uniform_blocks =
            max_per_stage_descriptor_update_after_bind_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_descriptor_set_inline_uniform_blocks(
        mut self,
        max_descriptor_set_inline_uniform_blocks: u32,
    ) -> Self {
        self.inner.max_descriptor_set_inline_uniform_blocks =
            max_descriptor_set_inline_uniform_blocks;
        self
    }
    #[inline]
    pub fn max_descriptor_set_update_after_bind_inline_uniform_blocks(
        mut self,
        max_descriptor_set_update_after_bind_inline_uniform_blocks: u32,
    ) -> Self {
        self.inner
            .max_descriptor_set_update_after_bind_inline_uniform_blocks =
            max_descriptor_set_update_after_bind_inline_uniform_blocks;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceInlineUniformBlockProperties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkWriteDescriptorSetInlineUniformBlock.html>"]
pub struct WriteDescriptorSetInlineUniformBlock {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub data_size: u32,
    pub p_data: *const c_void,
}
impl ::std::default::Default for WriteDescriptorSetInlineUniformBlock {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            data_size: u32::default(),
            p_data: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for WriteDescriptorSetInlineUniformBlock {
    const STRUCTURE_TYPE: StructureType = StructureType::WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK;
}
impl WriteDescriptorSetInlineUniformBlock {
    pub fn builder<'a>() -> WriteDescriptorSetInlineUniformBlockBuilder<'a> {
        WriteDescriptorSetInlineUniformBlockBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct WriteDescriptorSetInlineUniformBlockBuilder<'a> {
    inner: WriteDescriptorSetInlineUniformBlock,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsWriteDescriptorSet for WriteDescriptorSetInlineUniformBlockBuilder<'_> {}
unsafe impl ExtendsWriteDescriptorSet for WriteDescriptorSetInlineUniformBlock {}
impl<'a> ::std::ops::Deref for WriteDescriptorSetInlineUniformBlockBuilder<'a> {
    type Target = WriteDescriptorSetInlineUniformBlock;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for WriteDescriptorSetInlineUniformBlockBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> WriteDescriptorSetInlineUniformBlockBuilder<'a> {
    #[inline]
    pub fn data(mut self, data: &'a [u8]) -> Self {
        self.inner.data_size = data.len() as _;
        self.inner.p_data = data.as_ptr().cast();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> WriteDescriptorSetInlineUniformBlock {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorPoolInlineUniformBlockCreateInfo.html>"]
pub struct DescriptorPoolInlineUniformBlockCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub max_inline_uniform_block_bindings: u32,
}
impl ::std::default::Default for DescriptorPoolInlineUniformBlockCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            max_inline_uniform_block_bindings: u32::default(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorPoolInlineUniformBlockCreateInfo {
    const STRUCTURE_TYPE: StructureType =
        StructureType::DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO;
}
impl DescriptorPoolInlineUniformBlockCreateInfo {
    pub fn builder<'a>() -> DescriptorPoolInlineUniformBlockCreateInfoBuilder<'a> {
        DescriptorPoolInlineUniformBlockCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorPoolInlineUniformBlockCreateInfoBuilder<'a> {
    inner: DescriptorPoolInlineUniformBlockCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsDescriptorPoolCreateInfo
    for DescriptorPoolInlineUniformBlockCreateInfoBuilder<'_>
{
}
unsafe impl ExtendsDescriptorPoolCreateInfo for DescriptorPoolInlineUniformBlockCreateInfo {}
impl<'a> ::std::ops::Deref for DescriptorPoolInlineUniformBlockCreateInfoBuilder<'a> {
    type Target = DescriptorPoolInlineUniformBlockCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorPoolInlineUniformBlockCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorPoolInlineUniformBlockCreateInfoBuilder<'a> {
    #[inline]
    pub fn max_inline_uniform_block_bindings(
        mut self,
        max_inline_uniform_block_bindings: u32,
    ) -> Self {
        self.inner.max_inline_uniform_block_bindings = max_inline_uniform_block_bindings;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorPoolInlineUniformBlockCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPipelineCoverageModulationStateCreateInfoNV.html>"]
pub struct PipelineCoverageModulationStateCreateInfoNV {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: PipelineCoverageModulationStateCreateFlagsNV,
    pub coverage_modulation_mode: CoverageModulationModeNV,
    pub coverage_modulation_table_enable: Bool32,
    pub coverage_modulation_table_count: u32,
    pub p_coverage_modulation_table: *const f32,
}
impl ::std::default::Default for PipelineCoverageModulationStateCreateInfoNV {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: PipelineCoverageModulationStateCreateFlagsNV::default(),
            coverage_modulation_mode: CoverageModulationModeNV::default(),
            coverage_modulation_table_enable: Bool32::default(),
            coverage_modulation_table_count: u32::default(),
            p_coverage_modulation_table: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for PipelineCoverageModulationStateCreateInfoNV {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV;
}
impl PipelineCoverageModulationStateCreateInfoNV {
    pub fn builder<'a>() -> PipelineCoverageModulationStateCreateInfoNVBuilder<'a> {
        PipelineCoverageModulationStateCreateInfoNVBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PipelineCoverageModulationStateCreateInfoNVBuilder<'a> {
    inner: PipelineCoverageModulationStateCreateInfoNV,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineCoverageModulationStateCreateInfoNVBuilder<'_>
{
}
unsafe impl ExtendsPipelineMultisampleStateCreateInfo
    for PipelineCoverageModulationStateCreateInfoNV
{
}
impl<'a> ::std::ops::Deref for PipelineCoverageModulationStateCreateInfoNVBuilder<'a> {
    type Target = PipelineCoverageModulationStateCreateInfoNV;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PipelineCoverageModulationStateCreateInfoNVBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PipelineCoverageModulationStateCreateInfoNVBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: PipelineCoverageModulationStateCreateFlagsNV) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn coverage_modulation_mode(
        mut self,
        coverage_modulation_mode: CoverageModulationModeNV,
    ) -> Self {
        self.inner.coverage_modulation_mode = coverage_modulation_mode;
        self
    }
    #[inline]
    pub fn coverage_modulation_table_enable(
        mut self,
        coverage_modulation_table_enable: bool,
    ) -> Self {
        self.inner.coverage_modulation_table_enable = coverage_modulation_table_enable.into();
        self
    }
    #[inline]
    pub fn coverage_modulation_table(mut self, coverage_modulation_table: &'a [f32]) -> Self {
        self.inner.coverage_modulation_table_count = coverage_modulation_table.len() as _;
        self.inner.p_coverage_modulation_table = coverage_modulation_table.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PipelineCoverageModulationStateCreateInfoNV {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkImageFormatListCreateInfo.html>"]
pub struct ImageFormatListCreateInfo {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub view_format_count: u32,
    pub p_view_formats: *const Format,
}
impl ::std::default::Default for ImageFormatListCreateInfo {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            view_format_count: u32::default(),
            p_view_formats: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for ImageFormatListCreateInfo {
    const STRUCTURE_TYPE: StructureType = StructureType::IMAGE_FORMAT_LIST_CREATE_INFO;
}
impl ImageFormatListCreateInfo {
    pub fn builder<'a>() -> ImageFormatListCreateInfoBuilder<'a> {
        ImageFormatListCreateInfoBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ImageFormatListCreateInfoBuilder<'a> {
    inner: ImageFormatListCreateInfo,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsImageCreateInfo for ImageFormatListCreateInfoBuilder<'_> {}
unsafe impl ExtendsImageCreateInfo for ImageFormatListCreateInfo {}
unsafe impl ExtendsSwapchainCreateInfoKHR for ImageFormatListCreateInfoBuilder<'_> {}
unsafe impl ExtendsSwapchainCreateInfoKHR for ImageFormatListCreateInfo {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageFormatListCreateInfoBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceImageFormatInfo2 for ImageFormatListCreateInfo {}
impl<'a> ::std::ops::Deref for ImageFormatListCreateInfoBuilder<'a> {
    type Target = ImageFormatListCreateInfo;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ImageFormatListCreateInfoBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ImageFormatListCreateInfoBuilder<'a> {
    #[inline]
    pub fn view_formats(mut self, view_formats: &'a [Format]) -> Self {
        self.inner.view_format_count = view_formats.len() as _;
        self.inner.p_view_formats = view_formats.as_ptr();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ImageFormatListCreateInfo {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkValidationCacheCreateInfoEXT.html>"]
pub struct ValidationCacheCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub flags: ValidationCacheCreateFlagsEXT,
    pub initial_data_size: usize,
    pub p_initial_data: *const c_void,
}
impl ::std::default::Default for ValidationCacheCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            flags: ValidationCacheCreateFlagsEXT::default(),
            initial_data_size: usize::default(),
            p_initial_data: ::std::ptr::null(),
        }
    }
}
unsafe impl TaggedStructure for ValidationCacheCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType = StructureType::VALIDATION_CACHE_CREATE_INFO_EXT;
}
impl ValidationCacheCreateInfoEXT {
    pub fn builder<'a>() -> ValidationCacheCreateInfoEXTBuilder<'a> {
        ValidationCacheCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ValidationCacheCreateInfoEXTBuilder<'a> {
    inner: ValidationCacheCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
impl<'a> ::std::ops::Deref for ValidationCacheCreateInfoEXTBuilder<'a> {
    type Target = ValidationCacheCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ValidationCacheCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ValidationCacheCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn flags(mut self, flags: ValidationCacheCreateFlagsEXT) -> Self {
        self.inner.flags = flags;
        self
    }
    #[inline]
    pub fn initial_data(mut self, initial_data: &'a [u8]) -> Self {
        self.inner.initial_data_size = initial_data.len();
        self.inner.p_initial_data = initial_data.as_ptr().cast();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ValidationCacheCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkShaderModuleValidationCacheCreateInfoEXT.html>"]
pub struct ShaderModuleValidationCacheCreateInfoEXT {
    pub s_type: StructureType,
    pub p_next: *const c_void,
    pub validation_cache: ValidationCacheEXT,
}
impl ::std::default::Default for ShaderModuleValidationCacheCreateInfoEXT {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null(),
            validation_cache: ValidationCacheEXT::default(),
        }
    }
}
unsafe impl TaggedStructure for ShaderModuleValidationCacheCreateInfoEXT {
    const STRUCTURE_TYPE: StructureType =
        StructureType::SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT;
}
impl ShaderModuleValidationCacheCreateInfoEXT {
    pub fn builder<'a>() -> ShaderModuleValidationCacheCreateInfoEXTBuilder<'a> {
        ShaderModuleValidationCacheCreateInfoEXTBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct ShaderModuleValidationCacheCreateInfoEXTBuilder<'a> {
    inner: ShaderModuleValidationCacheCreateInfoEXT,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsShaderModuleCreateInfo for ShaderModuleValidationCacheCreateInfoEXTBuilder<'_> {}
unsafe impl ExtendsShaderModuleCreateInfo for ShaderModuleValidationCacheCreateInfoEXT {}
unsafe impl ExtendsPipelineShaderStageCreateInfo
    for ShaderModuleValidationCacheCreateInfoEXTBuilder<'_>
{
}
unsafe impl ExtendsPipelineShaderStageCreateInfo for ShaderModuleValidationCacheCreateInfoEXT {}
impl<'a> ::std::ops::Deref for ShaderModuleValidationCacheCreateInfoEXTBuilder<'a> {
    type Target = ShaderModuleValidationCacheCreateInfoEXT;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for ShaderModuleValidationCacheCreateInfoEXTBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> ShaderModuleValidationCacheCreateInfoEXTBuilder<'a> {
    #[inline]
    pub fn validation_cache(mut self, validation_cache: ValidationCacheEXT) -> Self {
        self.inner.validation_cache = validation_cache;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> ShaderModuleValidationCacheCreateInfoEXT {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance3Properties.html>"]
pub struct PhysicalDeviceMaintenance3Properties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_per_set_descriptors: u32,
    pub max_memory_allocation_size: DeviceSize,
}
impl ::std::default::Default for PhysicalDeviceMaintenance3Properties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_per_set_descriptors: u32::default(),
            max_memory_allocation_size: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMaintenance3Properties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES;
}
impl PhysicalDeviceMaintenance3Properties {
    pub fn builder<'a>() -> PhysicalDeviceMaintenance3PropertiesBuilder<'a> {
        PhysicalDeviceMaintenance3PropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMaintenance3PropertiesBuilder<'a> {
    inner: PhysicalDeviceMaintenance3Properties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance3PropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance3Properties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMaintenance3PropertiesBuilder<'a> {
    type Target = PhysicalDeviceMaintenance3Properties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMaintenance3PropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMaintenance3PropertiesBuilder<'a> {
    #[inline]
    pub fn max_per_set_descriptors(mut self, max_per_set_descriptors: u32) -> Self {
        self.inner.max_per_set_descriptors = max_per_set_descriptors;
        self
    }
    #[inline]
    pub fn max_memory_allocation_size(mut self, max_memory_allocation_size: DeviceSize) -> Self {
        self.inner.max_memory_allocation_size = max_memory_allocation_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMaintenance3Properties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance4Features.html>"]
pub struct PhysicalDeviceMaintenance4Features {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub maintenance4: Bool32,
}
impl ::std::default::Default for PhysicalDeviceMaintenance4Features {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            maintenance4: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMaintenance4Features {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES;
}
impl PhysicalDeviceMaintenance4Features {
    pub fn builder<'a>() -> PhysicalDeviceMaintenance4FeaturesBuilder<'a> {
        PhysicalDeviceMaintenance4FeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMaintenance4FeaturesBuilder<'a> {
    inner: PhysicalDeviceMaintenance4Features,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMaintenance4FeaturesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceFeatures2 for PhysicalDeviceMaintenance4Features {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMaintenance4FeaturesBuilder<'_> {}
unsafe impl ExtendsDeviceCreateInfo for PhysicalDeviceMaintenance4Features {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMaintenance4FeaturesBuilder<'a> {
    type Target = PhysicalDeviceMaintenance4Features;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMaintenance4FeaturesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMaintenance4FeaturesBuilder<'a> {
    #[inline]
    pub fn maintenance4(mut self, maintenance4: bool) -> Self {
        self.inner.maintenance4 = maintenance4.into();
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMaintenance4Features {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceMaintenance4Properties.html>"]
pub struct PhysicalDeviceMaintenance4Properties {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub max_buffer_size: DeviceSize,
}
impl ::std::default::Default for PhysicalDeviceMaintenance4Properties {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            max_buffer_size: DeviceSize::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceMaintenance4Properties {
    const STRUCTURE_TYPE: StructureType = StructureType::PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES;
}
impl PhysicalDeviceMaintenance4Properties {
    pub fn builder<'a>() -> PhysicalDeviceMaintenance4PropertiesBuilder<'a> {
        PhysicalDeviceMaintenance4PropertiesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceMaintenance4PropertiesBuilder<'a> {
    inner: PhysicalDeviceMaintenance4Properties,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance4PropertiesBuilder<'_> {}
unsafe impl ExtendsPhysicalDeviceProperties2 for PhysicalDeviceMaintenance4Properties {}
impl<'a> ::std::ops::Deref for PhysicalDeviceMaintenance4PropertiesBuilder<'a> {
    type Target = PhysicalDeviceMaintenance4Properties;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for PhysicalDeviceMaintenance4PropertiesBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> PhysicalDeviceMaintenance4PropertiesBuilder<'a> {
    #[inline]
    pub fn max_buffer_size(mut self, max_buffer_size: DeviceSize) -> Self {
        self.inner.max_buffer_size = max_buffer_size;
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> PhysicalDeviceMaintenance4Properties {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkDescriptorSetLayoutSupport.html>"]
pub struct DescriptorSetLayoutSupport {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub supported: Bool32,
}
impl ::std::default::Default for DescriptorSetLayoutSupport {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            supported: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for DescriptorSetLayoutSupport {
    const STRUCTURE_TYPE: StructureType = StructureType::DESCRIPTOR_SET_LAYOUT_SUPPORT;
}
impl DescriptorSetLayoutSupport {
    pub fn builder<'a>() -> DescriptorSetLayoutSupportBuilder<'a> {
        DescriptorSetLayoutSupportBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct DescriptorSetLayoutSupportBuilder<'a> {
    inner: DescriptorSetLayoutSupport,
    marker: ::std::marker::PhantomData<&'a ()>,
}
pub unsafe trait ExtendsDescriptorSetLayoutSupport {}
impl<'a> ::std::ops::Deref for DescriptorSetLayoutSupportBuilder<'a> {
    type Target = DescriptorSetLayoutSupport;
    fn deref(&self) -> &Self::Target {
        &self.inner
    }
}
impl<'a> ::std::ops::DerefMut for DescriptorSetLayoutSupportBuilder<'a> {
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.inner
    }
}
impl<'a> DescriptorSetLayoutSupportBuilder<'a> {
    #[inline]
    pub fn supported(mut self, supported: bool) -> Self {
        self.inner.supported = supported.into();
        self
    }
    #[doc = r" Prepends the given extension struct between the root and the first pointer. This"]
    #[doc = r" method only exists on structs that can be passed to a function directly. Only"]
    #[doc = r" valid extension structs can be pushed into the chain."]
    #[doc = r" If the chain looks like `A -> B -> C`, and you call `builder.push_next(&mut D)`, then the"]
    #[doc = r" chain will look like `A -> D -> B -> C`."]
    pub fn push_next<T: ExtendsDescriptorSetLayoutSupport>(mut self, next: &'a mut T) -> Self {
        unsafe {
            let next_ptr = <*mut T>::cast(next);
            let last_next = ptr_chain_iter(next).last().unwrap();
            (*last_next).p_next = self.inner.p_next as _;
            self.inner.p_next = next_ptr;
        }
        self
    }
    #[doc = r" Calling build will **discard** all the lifetime information. Only call this if"]
    #[doc = r" necessary! Builders implement `Deref` targeting their corresponding Vulkan struct,"]
    #[doc = r" so references to builders can be passed directly to Vulkan functions."]
    pub fn build(self) -> DescriptorSetLayoutSupport {
        self.inner
    }
}
#[repr(C)]
#[cfg_attr(feature = "debug", derive(Debug))]
#[derive(Copy, Clone)]
#[doc = "<https://www.khronos.org/registry/vulkan/specs/1.3-extensions/man/html/VkPhysicalDeviceShaderDrawParametersFeatures.html>"]
pub struct PhysicalDeviceShaderDrawParametersFeatures {
    pub s_type: StructureType,
    pub p_next: *mut c_void,
    pub shader_draw_parameters: Bool32,
}
impl ::std::default::Default for PhysicalDeviceShaderDrawParametersFeatures {
    #[inline]
    fn default() -> Self {
        Self {
            s_type: Self::STRUCTURE_TYPE,
            p_next: ::std::ptr::null_mut(),
            shader_draw_parameters: Bool32::default(),
        }
    }
}
unsafe impl TaggedStructure for PhysicalDeviceShaderDrawParametersFeatures {
    const STRUCTURE_TYPE: StructureType =
        StructureType::PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES;
}
impl PhysicalDeviceShaderDrawParametersFeatures {
    pub fn builder<'a>() -> PhysicalDeviceShaderDrawParametersFeaturesBuilder<'a> {
        PhysicalDeviceShaderDrawParametersFeaturesBuilder {
            inner: Self::default(),
            marker: ::std::marker::PhantomData,
        }
    }
}
#[repr(transparent)]
pub struct PhysicalDeviceShaderDrawParametersFeaturesBuilder<'a> {
    inner: PhysicalDeviceShaderDrawParametersFeatures,
    marker: ::std::marker::PhantomData<&'a ()>,
}
unsafe impl ExtendsPhysicalDevi