/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/**
 * This file is generated by browser/components/asrouter/bin/import-rollouts.js
 * Run the following from the repository root to regenerate it:
 * ./mach npm run import-rollouts --prefix=browser/components/asrouter
 */

export const NimbusRolloutMessageProvider = {
  getMessages() {
    return [
      {
        // Nimbus slug: fox-doodle-set-to-default-early-day-user-de-fr-it-treatment-a-rollout:treatment-a
        // Version range: 116+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-set-to-default-early-day-user-de-fr-it-treatment-a-rollout/summary#treatment-a
        id: "fox-doodle-set-to-default-early-day-user-de-fr-it:A",
        groups: ["eco"],
        content: {
          id: "fox-doodle-set-to-default-early-day-user-de-fr-it:A",
          screens: [
            {
              id: "SET_DEFAULT",
              content: {
                logo: {
                  height: "140px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                },
                title: {
                  raw: {
                    $l10n: {
                      id: "fox-doodle-trackers-title",
                      text: "Keep pesky trackers off your tail",
                      comment:
                        "This title is displayed together with the picture of a running fox with a long tail. In English, this is a figure of speech meaning 'stop something from following you'. If the localization of this message is challenging, consider using a simplified alternative as a reference for translation: 'Keep unwanted trackers away'.",
                    },
                  },
                  fontSize: "22px",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  raw: {
                    $l10n: {
                      id: "fox-doodle-trackers-subtitle",
                      text: "Say goodbye to annoying ad trackers and settle into a safer, speedy internet experience.",
                      comment: "",
                    },
                  },
                  fontSize: "15px",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "fox-doodle-set-default-driving-primary-button-label",
                        text: "Open my links with Firefox",
                        comment: "",
                      },
                    },
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    raw: {
                      $l10n: {
                        id: "fox-doodle-driving-secondary-button-label",
                        text: "Not now",
                        comment: "",
                      },
                    },
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && !isMajorUpgrade && !activeNotifications && (((currentDate|date) - (profileAgeCreated|date)) / 3600000 >= 6) && !isDefaultBrowser",
      },
      {
        // Nimbus slug: fox-doodle-set-to-default-early-day-user-en-treatment-a-rollout:treatment-a
        // Version range: 116+
        // Recipe: https://experimenter.services.mozilla.com/nimbus/fox-doodle-set-to-default-early-day-user-en-treatment-a-rollout/summary#treatment-a
        id: "fox-doodle-set-to-default-early-day-user:A",
        groups: ["eco"],
        content: {
          id: "fox-doodle-set-to-default-early-day-user:A",
          screens: [
            {
              id: "SET_DEFAULT",
              content: {
                logo: {
                  height: "140px",
                  imageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                  reducedMotionImageURL:
                    "https://firefox-settings-attachments.cdn.mozilla.net/main-workspace/ms-images/05f5265b-d1e4-4fe1-9a46-0ea36f8afced.png",
                },
                title: {
                  raw: "Keep pesky trackers off your tail",
                  fontSize: "22px",
                  fontWeight: 590,
                  paddingBlock: "4px 0",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                subtitle: {
                  raw: "Say goodbye to annoying ad trackers and settle into a safer, speedy internet experience.",
                  fontSize: "15px",
                  lineHeight: "1.4",
                  marginBlock: "8px 16px",
                  letterSpacing: 0,
                  paddingInline: "24px",
                },
                dismiss_button: {
                  action: {
                    navigate: true,
                  },
                },
                primary_button: {
                  label: {
                    raw: "Open my links with Firefox",
                    marginBlock: "4px 0",
                    paddingBlock: "0",
                    paddingInline: "16px",
                  },
                  action: {
                    type: "SET_DEFAULT_BROWSER",
                    navigate: true,
                  },
                },
                secondary_button: {
                  label: {
                    raw: "Not now",
                    marginBlock: "0 -20px",
                  },
                  action: {
                    navigate: true,
                  },
                },
              },
            },
          ],
          backdrop: "transparent",
          template: "multistage",
          transitions: true,
        },
        trigger: {
          id: "defaultBrowserCheck",
        },
        priority: 1,
        template: "spotlight",
        frequency: {
          lifetime: 1,
        },
        targeting:
          "source == 'startup' && !willShowDefaultPrompt && !isMajorUpgrade && !activeNotifications && (((currentDate|date) - (profileAgeCreated|date)) / 3600000 >= 6) && !isDefaultBrowser",
      },
    ];
  },
};
