// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2009 - DIGITEO - Clément DAVID
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- Non-regression test for bug 6541 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/6797
//
// <-- Short Description -->
// Calling importXcosDiagram without loading Scicos libs must not fail.
// The call of importXcosDiagram must not load scicos libs.


// Are scicos libs loaded ?
function result = isScicosLibLoaded()
    result = isdef("BIGSOM_f");
endfunction

// Check that the simulation libraries are not loaded at startup
if isScicosLibLoaded() <> %f then pause,end

result = importXcosDiagram(SCI + "/modules/xcos/tests/nonreg_tests/bug_6797.zcos");
if result <> %t then pause,end

// Check that the simulation libraries are not loaded after the call
if isScicosLibLoaded() <> %f then pause,end

