/*
 *  R : A Computer Language for Statistical Data Analysis
 *  Copyright (C) 2023 The R Core Team.
 *
 *  This header file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1 of the License, or
 *  (at your option) any later version.
 * 
 *  This file is part of R. R is distributed under the terms of the
 *  GNU General Public License, either Version 2, June 1991 or Version 3,
 *  June 2007. See doc/COPYRIGHTS for details of the copyright status of R.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program; if not, a copy is available at
 *  https://www.R-project.org/Licenses/
 */

/* This file is only used on macOS.

   It provdes 'shims' from Fortran-style BLAS calls to the interface
   provided by Apple's Accelerate in macOS >= 13.3.  The list of
   functions is taken from vecLib's libLAPACK.tbd (which does not
   provide LSAME which we supply in libRblas.  This is more than
   included in R, and liable to change.

   Which calls have return values is subject to verification,
   especially for those not included in R.
*/

#include <R_ext/RS.h> // for F77_NAME
// clang -Wall -pedantic will warn on this
#pragma clang diagnostic ignored "-Wdollar-in-identifier-extension"
// For ILP64 this would be x ## $NEWLAPACK ## $ILP64
#define ACC_NAME(x) x ## $NEWLAPACK

// Fortran subroutines
#define Mv(fun)\
void ACC_NAME(fun)(void); \
void F77_NAME(fun)(void) { \
    ACC_NAME(fun)(); \
}

// Fortran functions
// would need changes for ILP64: __LAPACK_int is int or long.
#define Mint(fun) \
int ACC_NAME(fun)(void); \
int F77_NAME(fun)(void) { \
    return ACC_NAME(fun)(); \
}
#define Mdouble(fun) \
double ACC_NAME(fun)(void); \
double F77_NAME(fun)(void) { \
    return ACC_NAME(fun)(); \
}
// would need changes for ILP64: __LAPACK_bool is int or long.
#define Mlgl(fun) \
int ACC_NAME(fun)(void); \
int F77_NAME(fun)(void) { \
    return ACC_NAME(fun)(); \
}

Mv(dbbcsd)
Mv(dbdsdc)
Mv(dbdsqr)
Mv(dbdsvdx)
Mv(dcombssq)
Mv(ddisna)
Mv(dgbbrd)
Mv(dgbcon)
Mv(dgbequ)
Mv(dgbequb)
Mv(dgbrfs)
Mv(dgbsv)
Mv(dgbsvx)
Mv(dgbtf2)
Mv(dgbtrf)
Mv(dgbtrs)
Mv(dgebak)
Mv(dgebal)
Mv(dgebd2)
Mv(dgebrd)
Mv(dgecon)
Mv(dgeequ)
Mv(dgeequb)
Mv(dgees)
Mv(dgeesx)
Mv(dgeev)
Mv(dgeevx)
Mv(dgegs)
Mv(dgegv)
Mv(dgehd2)
Mv(dgehrd)
Mv(dgejsv)
Mv(dgelq)
Mv(dgelq2)
Mv(dgelqf)
Mv(dgelqt)
Mv(dgelqt3)
Mv(dgels)
Mv(dgelsd)
Mv(dgelss)
Mv(dgelsx)
Mv(dgelsy)
Mv(dgemlq)
Mv(dgemlqt)
Mv(dgemqr)
Mv(dgemqrt)
Mv(dgeql2)
Mv(dgeqlf)
Mv(dgeqp3)
Mv(dgeqpf)
Mv(dgeqr)
Mv(dgeqr2)
Mv(dgeqr2p)
Mv(dgeqrf)
Mv(dgeqrfp)
Mv(dgeqrt)
Mv(dgeqrt2)
Mv(dgeqrt3)
Mv(dgerfs)
Mv(dgerq2)
Mv(dgerqf)
Mv(dgesc2)
Mv(dgesdd)
Mv(dgesv)
Mv(dgesvd)
Mv(dgesvdq)
Mv(dgesvdx)
Mv(dgesvj)
Mv(dgesvx)
Mv(dgetc2)
Mv(dgetf2)
Mv(dgetrf)
Mv(dgetrf2)
Mv(dgetri)
Mv(dgetrs)
Mv(dgetsls)
Mv(dgetsqrhrt)
Mv(dggbak)
Mv(dggbal)
Mv(dgges)
Mv(dgges3)
Mv(dggesx)
Mv(dggev)
Mv(dggev3)
Mv(dggevx)
Mv(dggglm)
Mv(dgghd3)
Mv(dgghrd)
Mv(dgglse)
Mv(dggqrf)
Mv(dggrqf)
Mv(dggsvd)
Mv(dggsvd3)
Mv(dggsvp)
Mv(dggsvp3)
Mv(dgsvj0)
Mv(dgsvj1)
Mv(dgtcon)
Mv(dgtrfs)
Mv(dgtsv)
Mv(dgtsvx)
Mv(dgttrf)
Mv(dgttrs)
Mv(dgtts2)
Mv(dhgeqz)
Mv(dhsein)
Mv(dhseqr)
Mv(disnan)
Mv(dlabad)
Mv(dlabrd)
Mv(dlacn2)
Mv(dlacon)
Mv(dlacpy)
Mv(dladiv)
Mv(dladiv1)
Mv(dladiv2)
Mv(dlae2)
Mv(dlaebz)
Mv(dlaed0)
Mv(dlaed1)
Mv(dlaed2)
Mv(dlaed3)
Mv(dlaed4)
Mv(dlaed5)
Mv(dlaed6)
Mv(dlaed7)
Mv(dlaed8)
Mv(dlaed9)
Mv(dlaeda)
Mv(dlaein)
Mv(dlaev2)
Mv(dlaexc)
Mv(dlag2)
Mv(dlag2s)
Mv(dlags2)
Mv(dlagtf)
Mv(dlagtm)
Mv(dlagts)
Mv(dlagv2)
Mv(dlahqr)
Mv(dlahr2)
Mv(dlahrd)
Mv(dlaic1)
Mv(dlaisnan)
Mv(dlaln2)
Mv(dlals0)
Mv(dlalsa)
Mv(dlalsd)
Mv(dlamc1)
Mv(dlamc2)
Mv(dlamc3)
Mv(dlamc4)
Mv(dlamc5)
Mv(dlamch)
Mv(dlamrg)
Mv(dlamswlq)
Mv(dlamtsqr)
Mv(dlaneg)
Mdouble(dlangb)
Mdouble(dlange)
Mdouble(dlangt)
Mdouble(dlanhs)
Mdouble(dlansb)
Mdouble(dlansf)
Mdouble(dlansp)
Mdouble(dlanst)
Mdouble(dlansy)
Mdouble(dlantb)
Mdouble(dlantp)
Mdouble(dlantr)
Mv(dlanv2)
Mv(dlapll)
Mv(dlapmr)
Mv(dlapmt)
Mdouble(dlapy2)
Mdouble(dlapy3)
Mv(dlaqgb)
Mv(dlaqge)
Mv(dlaqp2)
Mv(dlaqps)
Mv(dlaqr0)
Mv(dlaqr1)
Mv(dlaqr2)
Mv(dlaqr3)
Mv(dlaqr4)
Mv(dlaqr5)
Mv(dlaqsb)
Mv(dlaqsp)
Mv(dlaqsy)
Mv(dlaqtr)
Mv(dlar1v)
Mv(dlar2v)
Mv(dlarf)
Mv(dlarfb)
Mv(dlarfb_gett)
Mv(dlarfg)
Mv(dlarfgp)
Mv(dlarfp)
Mv(dlarft)
Mv(dlarfx)
Mv(dlarfy)
Mv(dlargv)
Mv(dlarnv)
Mv(dlarra)
Mv(dlarrb)
Mv(dlarrc)
Mv(dlarrd)
Mv(dlarre)
Mv(dlarrf)
Mv(dlarrj)
Mv(dlarrk)
Mv(dlarrr)
Mv(dlarrv)
Mv(dlarscl2)
Mv(dlartg)
Mv(dlartgp)
Mv(dlartgs)
Mv(dlartv)
Mv(dlaruv)
Mv(dlarz)
Mv(dlarzb)
Mv(dlarzt)
Mv(dlas2)
Mv(dlascl)
Mv(dlascl2)
Mv(dlasd0)
Mv(dlasd1)
Mv(dlasd2)
Mv(dlasd3)
Mv(dlasd4)
Mv(dlasd5)
Mv(dlasd6)
Mv(dlasd7)
Mv(dlasd8)
Mv(dlasda)
Mv(dlasdq)
Mv(dlasdt)
Mv(dlaset)
Mv(dlasq1)
Mv(dlasq2)
Mv(dlasq3)
Mv(dlasq4)
Mv(dlasq5)
Mv(dlasq6)
Mv(dlasr)
Mv(dlasrt)
Mv(dlassq)
Mv(dlasv2)
Mv(dlaswlq)
Mv(dlaswp)
Mv(dlasy2)
Mv(dlasyf)
Mv(dlasyf_aa)
Mv(dlasyf_rk)
Mv(dlasyf_rook)
Mv(dlat2s)
Mv(dlatbs)
Mv(dlatdf)
Mv(dlatps)
Mv(dlatrd)
Mv(dlatrs)
Mv(dlatrz)
Mv(dlatsqr)
Mv(dlatzm)
Mv(dlauu2)
Mv(dlauum)
Mv(dopgtr)
Mv(dopmtr)
Mv(dorbdb)
Mv(dorbdb1)
Mv(dorbdb2)
Mv(dorbdb3)
Mv(dorbdb4)
Mv(dorbdb5)
Mv(dorbdb6)
Mv(dorcsd)
Mv(dorcsd2by1)
Mv(dorg2l)
Mv(dorg2r)
Mv(dorgbr)
Mv(dorghr)
Mv(dorgl2)
Mv(dorglq)
Mv(dorgql)
Mv(dorgqr)
Mv(dorgr2)
Mv(dorgrq)
Mv(dorgtr)
Mv(dorgtsqr)
Mv(dorgtsqr_row)
Mv(dorhr_col)
Mv(dorm22)
Mv(dorm2l)
Mv(dorm2r)
Mv(dormbr)
Mv(dormhr)
Mv(dorml2)
Mv(dormlq)
Mv(dormql)
Mv(dormqr)
Mv(dormr2)
Mv(dormr3)
Mv(dormrq)
Mv(dormrz)
Mv(dormtr)
Mv(dpbcon)
Mv(dpbequ)
Mv(dpbrfs)
Mv(dpbstf)
Mv(dpbsv)
Mv(dpbsvx)
Mv(dpbtf2)
Mv(dpbtrf)
Mv(dpbtrs)
Mv(dpftrf)
Mv(dpftri)
Mv(dpftrs)
Mv(dpocon)
Mv(dpoequ)
Mv(dpoequb)
Mv(dporfs)
Mv(dposv)
Mv(dposvx)
Mv(dpotf2)
Mv(dpotrf)
Mv(dpotrf2)
Mv(dpotri)
Mv(dpotrs)
Mv(dppcon)
Mv(dppequ)
Mv(dpprfs)
Mv(dppsv)
Mv(dppsvx)
Mv(dpptrf)
Mv(dpptri)
Mv(dpptrs)
Mv(dpstf2)
Mv(dpstrf)
Mv(dptcon)
Mv(dpteqr)
Mv(dptrfs)
Mv(dptsv)
Mv(dptsvx)
Mv(dpttrf)
Mv(dpttrs)
Mv(dptts2)
Mv(drscl)
Mv(dsb2st_kernels)
Mv(dsbev)
Mv(dsbev_2stage)
Mv(dsbevd)
Mv(dsbevd_2stage)
Mv(dsbevx)
Mv(dsbevx_2stage)
Mv(dsbgst)
Mv(dsbgv)
Mv(dsbgvd)
Mv(dsbgvx)
Mv(dsbtrd)
Mv(dsfrk)
Mv(dsgesv)
Mv(dspcon)
Mv(dspev)
Mv(dspevd)
Mv(dspevx)
Mv(dspgst)
Mv(dspgv)
Mv(dspgvd)
Mv(dspgvx)
Mv(dsposv)
Mv(dsprfs)
Mv(dspsv)
Mv(dspsvx)
Mv(dsptrd)
Mv(dsptrf)
Mv(dsptri)
Mv(dsptrs)
Mv(dstebz)
Mv(dstedc)
Mv(dstegr)
Mv(dstein)
Mv(dstemr)
Mv(dsteqr)
Mv(dsterf)
Mv(dstev)
Mv(dstevd)
Mv(dstevr)
Mv(dstevx)
Mv(dsycon)
Mv(dsycon_3)
Mv(dsycon_rook)
Mv(dsyconv)
Mv(dsyconvf)
Mv(dsyconvf_rook)
Mv(dsyequb)
Mv(dsyev)
Mv(dsyev_2stage)
Mv(dsyevd)
Mv(dsyevd_2stage)
Mv(dsyevr)
Mv(dsyevr_2stage)
Mv(dsyevx)
Mv(dsyevx_2stage)
Mv(dsygs2)
Mv(dsygst)
Mv(dsygv)
Mv(dsygv_2stage)
Mv(dsygvd)
Mv(dsygvx)
Mv(dsyrfs)
Mv(dsysv)
Mv(dsysv_aa)
Mv(dsysv_aa_2stage)
Mv(dsysv_rk)
Mv(dsysv_rook)
Mv(dsysvx)
Mv(dsyswapr)
Mv(dsytd2)
Mv(dsytf2)
Mv(dsytf2_rk)
Mv(dsytf2_rook)
Mv(dsytrd)
Mv(dsytrd_2stage)
Mv(dsytrd_sb2st)
Mv(dsytrd_sy2sb)
Mv(dsytrf)
Mv(dsytrf_aa)
Mv(dsytrf_aa_2stage)
Mv(dsytrf_rk)
Mv(dsytrf_rook)
Mv(dsytri)
Mv(dsytri2)
Mv(dsytri2x)
Mv(dsytri_3)
Mv(dsytri_3x)
Mv(dsytri_rook)
Mv(dsytrs)
Mv(dsytrs2)
Mv(dsytrs_3)
Mv(dsytrs_aa)
Mv(dsytrs_aa_2stage)
Mv(dsytrs_rook)
Mv(dtbcon)
Mv(dtbrfs)
Mv(dtbtrs)
Mv(dtfsm)
Mv(dtftri)
Mv(dtfttp)
Mv(dtfttr)
Mv(dtgevc)
Mv(dtgex2)
Mv(dtgexc)
Mv(dtgsen)
Mv(dtgsja)
Mv(dtgsna)
Mv(dtgsy2)
Mv(dtgsyl)
Mv(dtpcon)
Mv(dtplqt)
Mv(dtplqt2)
Mv(dtpmlqt)
Mv(dtpmqrt)
Mv(dtpqrt)
Mv(dtpqrt2)
Mv(dtprfb)
Mv(dtprfs)
Mv(dtptri)
Mv(dtptrs)
Mv(dtpttf)
Mv(dtpttr)
Mv(dtrcon)
Mv(dtrevc)
Mv(dtrevc3)
Mv(dtrexc)
Mv(dtrrfs)
Mv(dtrsen)
Mv(dtrsna)
Mv(dtrsyl)
Mv(dtrti2)
Mv(dtrtri)
Mv(dtrtrs)
Mv(dtrttf)
Mv(dtrttp)
Mv(dtzrqf)
Mv(dtzrzf)
Mdouble(dzsum1)

Mint(ilaenv)
Mv(ilaver)
/*
Mv(ieeeck)
Mv(ilaclc)
Mv(ilaclr)
Mv(iladiag)
Mv(iladlc)
Mv(iladlr)
Mv(ilaenv2stage)
Mv(ilaprec)
Mv(ilaslc)
Mv(ilaslr)
Mv(ilatrans)
Mv(ilauplo)
Mv(ilazlc)
Mv(ilazlr)
Mv(iparam2stage)
Mv(iparmq)
Mv(izmax1)
*/
Mv(zbbcsd)
Mv(zbdsqr)
Mv(zcgesv)
Mv(zcposv)
Mv(zdrscl)
Mv(zgbbrd)
Mv(zgbcon)
Mv(zgbequ)
Mv(zgbequb)
Mv(zgbrfs)
Mv(zgbsv)
Mv(zgbsvx)
Mv(zgbtf2)
Mv(zgbtrf)
Mv(zgbtrs)
Mv(zgebak)
Mv(zgebal)
Mv(zgebd2)
Mv(zgebrd)
Mv(zgecon)
Mv(zgeequ)
Mv(zgeequb)
Mv(zgees)
Mv(zgeesx)
Mv(zgeev)
Mv(zgeevx)
Mv(zgegs)
Mv(zgegv)
Mv(zgehd2)
Mv(zgehrd)
Mv(zgejsv)
Mv(zgelq)
Mv(zgelq2)
Mv(zgelqf)
Mv(zgelqt)
Mv(zgelqt3)
Mv(zgels)
Mv(zgelsd)
Mv(zgelss)
Mv(zgelsx)
Mv(zgelsy)
Mv(zgemlq)
Mv(zgemlqt)
Mv(zgemqr)
Mv(zgemqrt)
Mv(zgeql2)
Mv(zgeqlf)
Mv(zgeqp3)
Mv(zgeqpf)
Mv(zgeqr)
Mv(zgeqr2)
Mv(zgeqr2p)
Mv(zgeqrf)
Mv(zgeqrfp)
Mv(zgeqrt)
Mv(zgeqrt2)
Mv(zgeqrt3)
Mv(zgerfs)
Mv(zgerq2)
Mv(zgerqf)
Mv(zgesc2)
Mv(zgesdd)
Mv(zgesv)
Mv(zgesvd)
Mv(zgesvdq)
Mv(zgesvdx)
Mv(zgesvj)
Mv(zgesvx)
Mv(zgetc2)
Mv(zgetf2)
Mv(zgetrf)
Mv(zgetrf2)
Mv(zgetri)
Mv(zgetrs)
Mv(zgetsls)
Mv(zgetsqrhrt)
Mv(zggbak)
Mv(zggbal)
Mv(zgges)
Mv(zgges3)
Mv(zggesx)
Mv(zggev)
Mv(zggev3)
Mv(zggevx)
Mv(zggglm)
Mv(zgghd3)
Mv(zgghrd)
Mv(zgglse)
Mv(zggqrf)
Mv(zggrqf)
Mv(zggsvd)
Mv(zggsvd3)
Mv(zggsvp)
Mv(zggsvp3)
Mv(zgsvj0)
Mv(zgsvj1)
Mv(zgtcon)
Mv(zgtrfs)
Mv(zgtsv)
Mv(zgtsvx)
Mv(zgttrf)
Mv(zgttrs)
Mv(zgtts2)
Mv(zhb2st_kernels)
Mv(zhbev)
Mv(zhbev_2stage)
Mv(zhbevd)
Mv(zhbevd_2stage)
Mv(zhbevx)
Mv(zhbevx_2stage)
Mv(zhbgst)
Mv(zhbgv)
Mv(zhbgvd)
Mv(zhbgvx)
Mv(zhbtrd)
Mv(zhecon)
Mv(zhecon_3)
Mv(zhecon_rook)
Mv(zheequb)
Mv(zheev)
Mv(zheev_2stage)
Mv(zheevd)
Mv(zheevd_2stage)
Mv(zheevr)
Mv(zheevr_2stage)
Mv(zheevx)
Mv(zheevx_2stage)
Mv(zhegs2)
Mv(zhegst)
Mv(zhegv)
Mv(zhegv_2stage)
Mv(zhegvd)
Mv(zhegvx)
Mv(zherfs)
Mv(zhesv)
Mv(zhesv_aa)
Mv(zhesv_aa_2stage)
Mv(zhesv_rk)
Mv(zhesv_rook)
Mv(zhesvx)
Mv(zheswapr)
Mv(zhetd2)
Mv(zhetf2)
Mv(zhetf2_rk)
Mv(zhetf2_rook)
Mv(zhetrd)
Mv(zhetrd_2stage)
Mv(zhetrd_hb2st)
Mv(zhetrd_he2hb)
Mv(zhetrf)
Mv(zhetrf_aa)
Mv(zhetrf_aa_2stage)
Mv(zhetrf_rk)
Mv(zhetrf_rook)
Mv(zhetri)
Mv(zhetri2)
Mv(zhetri2x)
Mv(zhetri_3)
Mv(zhetri_3x)
Mv(zhetri_rook)
Mv(zhetrs)
Mv(zhetrs2)
Mv(zhetrs_3)
Mv(zhetrs_aa)
Mv(zhetrs_aa_2stage)
Mv(zhetrs_rook)
Mv(zhfrk)
Mv(zhgeqz)
Mv(zhpcon)
Mv(zhpev)
Mv(zhpevd)
Mv(zhpevx)
Mv(zhpgst)
Mv(zhpgv)
Mv(zhpgvd)
Mv(zhpgvx)
Mv(zhprfs)
Mv(zhpsv)
Mv(zhpsvx)
Mv(zhptrd)
Mv(zhptrf)
Mv(zhptri)
Mv(zhptrs)
Mv(zhsein)
Mv(zhseqr)
Mv(zlabrd)
Mv(zlacgv)
Mv(zlacn2)
Mv(zlacon)
Mv(zlacp2)
Mv(zlacpy)
Mv(zlacrm)
Mv(zlacrt)
Mv(zladiv)
Mv(zlaed0)
Mv(zlaed7)
Mv(zlaed8)
Mv(zlaein)
Mv(zlaesy)
Mv(zlaev2)
Mv(zlag2c)
Mv(zlags2)
Mv(zlagtm)
Mv(zlahef)
Mv(zlahef_aa)
Mv(zlahef_rk)
Mv(zlahef_rook)
Mv(zlahqr)
Mv(zlahr2)
Mv(zlahrd)
Mv(zlaic1)
Mv(zlals0)
Mv(zlalsa)
Mv(zlalsd)
Mv(zlamswlq)
Mv(zlamtsqr)
Mdouble(zlangb)
Mdouble(zlange)
Mdouble(zlangt)
Mdouble(zlanhb)
Mdouble(zlanhe)
Mdouble(zlanhf)
Mdouble(zlanhp)
Mdouble(zlanhs)
Mdouble(zlanht)
Mdouble(zlansb)
Mdouble(zlansp)
Mdouble(zlansy)
Mdouble(zlantb)
Mdouble(zlantp)
Mdouble(zlantr)
Mv(zlapll)
Mv(zlapmr)
Mv(zlapmt)
Mv(zlaqgb)
Mv(zlaqge)
Mv(zlaqhb)
Mv(zlaqhe)
Mv(zlaqhp)
Mv(zlaqp2)
Mv(zlaqps)
Mv(zlaqr0)
Mv(zlaqr1)
Mv(zlaqr2)
Mv(zlaqr3)
Mv(zlaqr4)
Mv(zlaqr5)
Mv(zlaqsb)
Mv(zlaqsp)
Mv(zlaqsy)
Mv(zlar1v)
Mv(zlar2v)
Mv(zlarcm)
Mv(zlarf)
Mv(zlarfb)
Mv(zlarfb_gett)
Mv(zlarfg)
Mv(zlarfgp)
Mv(zlarfp)
Mv(zlarft)
Mv(zlarfx)
Mv(zlarfy)
Mv(zlargv)
Mv(zlarnv)
Mv(zlarrv)
Mv(zlarscl2)
Mv(zlartg)
Mv(zlartv)
Mv(zlarz)
Mv(zlarzb)
Mv(zlarzt)
Mv(zlascl)
Mv(zlascl2)
Mv(zlaset)
Mv(zlasr)
Mv(zlassq)
Mv(zlaswlq)
Mv(zlaswp)
Mv(zlasyf)
Mv(zlasyf_aa)
Mv(zlasyf_rk)
Mv(zlasyf_rook)
Mv(zlat2c)
Mv(zlatbs)
Mv(zlatdf)
Mv(zlatps)
Mv(zlatrd)
Mv(zlatrs)
Mv(zlatrz)
Mv(zlatsqr)
Mv(zlatzm)
Mv(zlauu2)
Mv(zlauum)
Mv(zpbcon)
Mv(zpbequ)
Mv(zpbrfs)
Mv(zpbstf)
Mv(zpbsv)
Mv(zpbsvx)
Mv(zpbtf2)
Mv(zpbtrf)
Mv(zpbtrs)
Mv(zpftrf)
Mv(zpftri)
Mv(zpftrs)
Mv(zpocon)
Mv(zpoequ)
Mv(zpoequb)
Mv(zporfs)
Mv(zposv)
Mv(zposvx)
Mv(zpotf2)
Mv(zpotrf)
Mv(zpotrf2)
Mv(zpotri)
Mv(zpotrs)
Mv(zppcon)
Mv(zppequ)
Mv(zpprfs)
Mv(zppsv)
Mv(zppsvx)
Mv(zpptrf)
Mv(zpptri)
Mv(zpptrs)
Mv(zpstf2)
Mv(zpstrf)
Mv(zptcon)
Mv(zpteqr)
Mv(zptrfs)
Mv(zptsv)
Mv(zptsvx)
Mv(zpttrf)
Mv(zpttrs)
Mv(zptts2)
Mv(zrot)
Mv(zspcon)
Mv(zspmv)
Mv(zspr)
Mv(zsprfs)
Mv(zspsv)
Mv(zspsvx)
Mv(zsptrf)
Mv(zsptri)
Mv(zsptrs)
Mv(zstedc)
Mv(zstegr)
Mv(zstein)
Mv(zstemr)
Mv(zsteqr)
Mv(zsycon)
Mv(zsycon_3)
Mv(zsycon_rook)
Mv(zsyconv)
Mv(zsyconvf)
Mv(zsyconvf_rook)
Mv(zsyequb)
Mv(zsymv)
Mv(zsyr)
Mv(zsyrfs)
Mv(zsysv)
Mv(zsysv_aa)
Mv(zsysv_aa_2stage)
Mv(zsysv_rk)
Mv(zsysv_rook)
Mv(zsysvx)
Mv(zsyswapr)
Mv(zsytf2)
Mv(zsytf2_rk)
Mv(zsytf2_rook)
Mv(zsytrf)
Mv(zsytrf_aa)
Mv(zsytrf_aa_2stage)
Mv(zsytrf_rk)
Mv(zsytrf_rook)
Mv(zsytri)
Mv(zsytri2)
Mv(zsytri2x)
Mv(zsytri_3)
Mv(zsytri_3x)
Mv(zsytri_rook)
Mv(zsytrs)
Mv(zsytrs2)
Mv(zsytrs_3)
Mv(zsytrs_aa)
Mv(zsytrs_aa_2stage)
Mv(zsytrs_rook)
Mv(ztbcon)
Mv(ztbrfs)
Mv(ztbtrs)
Mv(ztfsm)
Mv(ztftri)
Mv(ztfttp)
Mv(ztfttr)
Mv(ztgevc)
Mv(ztgex2)
Mv(ztgexc)
Mv(ztgsen)
Mv(ztgsja)
Mv(ztgsna)
Mv(ztgsy2)
Mv(ztgsyl)
Mv(ztpcon)
Mv(ztplqt)
Mv(ztplqt2)
Mv(ztpmlqt)
Mv(ztpmqrt)
Mv(ztpqrt)
Mv(ztpqrt2)
Mv(ztprfb)
Mv(ztprfs)
Mv(ztptri)
Mv(ztptrs)
Mv(ztpttf)
Mv(ztpttr)
Mv(ztrcon)
Mv(ztrevc)
Mv(ztrevc3)
Mv(ztrexc)
Mv(ztrrfs)
Mv(ztrsen)
Mv(ztrsna)
Mv(ztrsyl)
Mv(ztrti2)
Mv(ztrtri)
Mv(ztrtrs)
Mv(ztrttf)
Mv(ztrttp)
Mv(ztzrqf)
Mv(ztzrzf)
Mv(zunbdb)
Mv(zunbdb1)
Mv(zunbdb2)
Mv(zunbdb3)
Mv(zunbdb4)
Mv(zunbdb5)
Mv(zunbdb6)
Mv(zuncsd)
Mv(zuncsd2by1)
Mv(zung2l)
Mv(zung2r)
Mv(zungbr)
Mv(zunghr)
Mv(zungl2)
Mv(zunglq)
Mv(zungql)
Mv(zungqr)
Mv(zungr2)
Mv(zungrq)
Mv(zungtr)
Mv(zungtsqr)
Mv(zungtsqr_row)
Mv(zunhr_col)
Mv(zunm22)
Mv(zunm2l)
Mv(zunm2r)
Mv(zunmbr)
Mv(zunmhr)
Mv(zunml2)
Mv(zunmlq)
Mv(zunmql)
Mv(zunmqr)
Mv(zunmr2)
Mv(zunmr3)
Mv(zunmrq)
Mv(zunmrz)
Mv(zunmtr)
Mv(zupgtr)
Mv(zupmtr)

