if (typeof T === 'undefined') require('../setup');

T('dividedToIntegerBy', function () {

  function t(dividend, divisor, expected) {
    T.assertEqual(expected, new Decimal(dividend).divToInt(divisor).valueOf());
  }

  Decimal.config({
    precision: 100,
    rounding: 4,
    toExpNeg: 0,
    toExpPos: 0,
    minE: -9e15,
    maxE: 9e15
  });

  t('0', '1', '0e+0');
  t('1', '3', '0e+0');
  t('5', '2', '2e+0');
  t('5', '3', '1e+0');
  t('36895644873019582.63', '7.718100793996604914489691733070282', '4.780404643292329e+15');
  t('64651655727943229435811115735289253096959446020560124180.868366968824689', '7360719838491229774079511358613.90160374119', '8.783333307954736831172335e+24');
  t('5732393766279203252222389165296003290.63682245014985462079498107494454', '604416262214131.2554110409995038281134160791152213968353', '9.484181886966409051084e+21');
  t('54718351636204349658226278525013052787257592035681265.6551696525453015879627795539', '1733778739362714568517963678482776130.326376987489790108496', '3.1560169930516731e+16');
  t('3624502246404620098804280609381269252487775685790155421714.37', '7349043547918880804458209119523987375.3', '4.93193736405469396185e+20');
  t('687735627911862004719398564058596925.0620935155879', '661665211998060549450363044996.55374284667971784770628959', '1.039401e+6');
  t('66572157335610232175829083999736410997178640962241864841145.38440153149463694336448032', '54270243268146994464714529492351249645.652699808036888630134152758877664710', '1.226678808250038544511e+21');
  t('292732942971276303164400.91406459997909437226470385768809366689', '198192438228187.19331064172815960167534', '1.477013682e+9');
  t('59513888891694622872074991579832352747.76750953213187581', '1034906258845141436777187279.59996358842591625637494529316402', '5.7506550359e+10');
  t('1172999106594898633290312234824434379243.4801860622', '95738279960066655037917155155088.714077938577519507', '1.2252143e+7');
  t('761675922203981329104560243.9835854112143', '42099630209991.5141510026559149', '1.8092223575474e+13');
  t('5809679691291868349384510.869889159148782403055857608', '968063734.6587296392560462419982700451', '6.001340080506112e+15');
  t('6448211701617320255603371664198.5340', '3368801816950100745696.3161966526612111', '1.91409648e+9');
  t('296307971666440825302127543787554134590.8787941480', '70132070748.312321207262275', '4.224999611516123207381673265e+27');
  t('43316267360881134909526915727057444938633273740017.8743', '8449981286489717202695708883073303677909.127', '5.126196839e+9');
  t('819020770378245595322971.46148843954356073808', '2415.98170292066380708174348146592639105118', '3.39001230592159274458e+20');
  t('83927285454555017922297698666610175739865729347545202310339537.3278652647460600458', '910726592947247598215539743673389743548.91620652260659513559851122880', '9.2154205339446339839657e+22');
  t('14061020300091766687182333004064.977713896865594430775781461672', '1603155675.6098707422715529327283189', '8.770838985891179036316e+21');
  t('884417829852997942464829140829902963210303.998238049169987867', '929333994109662294460328961115.627127094639098273434', '9.51668437245e+11');
  t('36341626756628760.847811686627543419', '5675392302633600.96', '6e+0');
  t('1354393047076228971811094773.75142710111809116877400907981', '94010.663', '1.4406802418532342143051e+22');
  t('2323899790063830737512.4', '863478123123107.92481976439554835777064960348', '2.691324e+6');
  t('987618440115997794400749.66886993666234', '22675878469307144.8162244378033455161783123', '4.3553701e+7');
  t('10311755146414307104995151982206075782.656417449', '26423572369798720085998726358.52329618044', '3.90248335e+8');
  t('85825439910365248211723523342206879351067408802952823475398167070694.74877359955732', '9395294670590615962717315621184478652114.656', '9.134938596339949352358380082e+27');
  t('3887675240713332987390.06624570539414391734158464', '89243744783895207.1304749', '4.3562e+4');
  t('54189806660036935939439.080081712985235676947745502890219', '9525065684586.21811741894896243303', '5.689179314e+9');
  t('898745419120337851777961502628920754162493.8824413149687522658714849', '170677067198475739114538472.94204577', '5.265765541162077e+15');
  t('12657400526086334981940854550597105983225457.660202372124944932422', '68233473796487276154104883270147087.72180051463205586927918446190326023184', '1.85501335e+8');
  t('6345632808902376230689521063946963315827012597069.0529159662416267', '73258270548407389105574043380.7057', '8.6620019301565783647e+19');
  t('63844115443924159839.5354397381645502603251748', '52081622.69982819025995364', '1.225847278451e+12');
  t('77617359154359399979637128706216412797126694348836163.2512945227699082', '718837603415233008062911431359648059.3372340819820519509408068646262423172349', '1.07976208792633395e+17');
  t('668732048375068249003372962771883048177204902854.96487726443895268994951328539', '8871569348254537734994873755556956.3636585318947549817', '7.5379227972403e+13');
  t('7324307406251123088063945918653711585851876699.033332143835', '245602869892404795648901.144816419', '2.9821750085655759570877e+22');
  t('633680500600797246057382.84246458752199925433851961230831876420', '912114822400474893.4436760573240757178', '6.94737e+5');
  t('314980768367918935839846907821.91091077739529142726', '3947642548649479218168.675916915139048700595146576', '7.9789586e+7');
  t('766601157334780.36684250893', '2236910563.0047379551661118203782187993331185216256', '3.42705e+5');
  t('451179146035244376593938188389561517876737396268.3722082', '79787399441228066679210.54567781854364900', '5.654766907995114695463082e+24');
  t('188304063671200134806361092560975924383338052875254060764.641132643293192088709181800993803516908', '206116970278546727444881787333344078.52121483611191414235001972', '9.13578651077229552158e+20');
  t('3026382628170838932467292571682.1146045206189752690464743138046368419051', '1702246654223795785.80918175927260070027874366225531172', '1.777875503917e+12');
  t('483178392966349.6198121233391337620537347847685050911', '2747037840.81789827', '1.7589e+5');
  t('4023724691049830855319641297898623523.4200255290132117', '26383494434081.792819331307675', '1.52509164436233477471225e+23');
  t('6877796550342118800424967.1290389332492906987967', '30648658827696068.217878734991427414542918900', '2.24407749e+8');
  t('719011971274811849964719.809683493988763885568', '9.89194861037076', '7.2686585787657318957512e+22');
  t('790578656386098075660101307.104299875185979641661080042756754480274', '787268.019818325211180976689745004412384010257', '1.004205221709039886117e+21');
  t('858494198854556721817549727788176491362841015.84030009705645443659557259', '78790750228395754125645617606916509.017', '1.0895875421e+10');
  t('869646688222700738547643533332444218371582088896608051507.0', '1281647576220391717154866999785857.626735735318666', '6.78538082042263828610696e+23');
  t('66469857783722559995.211087204', '2172489924203217901.75259287934585', '3e+1');
  t('51984084611381601914008899838258105152.42433636049132506114610098605444573042', '9569816310.665266871464705', '5.432088028006026973165219661e+27');
  t('414951.2936961', '278516.75236654920204095', '1e+0');
  t('27889165636159229278421958574241971.7173321250321597407510931', '608780684433367768970.0958260198328624819790316963233', '4.58115152949e+13');
  t('31325348586591798934669006781575695118.72248093700625749849', '790477742343281400653.7740497194731301702067416467193682', '3.9628375232592083e+16');
  t('477297820763430240725102689.193874438652153546852540937610726', '50977.4033214710912988', '9.362929252271229984862e+21');
  t('13536773796609199399681306836634656854430251561095182562440.479700785161646843522660227938435', '6899697641187817329320644306067456122618.255451005721950718445', '1.961937247192005407e+18');
  t('2381373889138322049844907125209701606782407040.2330330510', '59573438790896784513124463685.01873763149827085', '3.997375235458477e+16');
  t('15009874504474088125494995090180881793574446435649285.95399729241871266079155820', '7994023476339887537558053452485.039756512235934240847094702083', '1.87763703082674093196e+21');
  t('149321894113620366433430659314130451.761009381237977752848331', '25875774828915149345499986378863322.0688818323564091828578268222349', '5e+0');
  t('493939976672086336405697.925291445190636467775112366908', '813926251653843673127.91682695105099073346580', '6.06e+2');
  t('963855060561684717831949176179796196.178851705050651576', '5674764504641093.4230471198398883271513279954', '1.69849349655549233494e+20');
  t('78579569768408197574.74415', '177668308997.891532298623383736397428619051', '4.4228242e+8');
  t('61108686571149946806212728223514943268914773.0', '5323064826026393379647255196088.928594643315913887175120559775135677258', '1.1479981658755e+13');
  t('1382828795086651444895299842.0701840449690096552', '48341628323.19524099674532', '2.8605341670362056e+16');
  t('141044777022706624397071865824451960354988292245534902.103835164801884160519466008814448546356', '625516891024850859709023021152499441.3940965259710380354179927630495354', '2.25485161226610464e+17');
  t('3383909955260533298806816503965026713181287831421002006689567.728388493726457139215233375717342848657', '489326232373007421141886950266739.662366358', '6.915447673528812565401505757e+27');
  t('92164023674341088.45012071227433289171688115770593447138', '1675199316534042.27750136403224942402891755971059965', '5.5e+1');
  t('4899344037352161457244324553904105556058425616763379.109691688138005854234064606', '562503659482979470924953274636537.3581621291285722942485', '8.70988829095859129e+18');
  t('512036851746554679379839026143992368083802967.057532394186266483130002476', '25468746832409733351.6898012461168020860537046999219826224', '2.0104516924836389935030372e+25');
  t('21178399750404.078200242066551371801579539042343659263', '806447904.4971825664', '2.6261e+4');
  t('4395521.80197383578918426307715499005', '2.19042050141541184092988028602', '2.006702e+6');
  t('1293749948117192138846929064803097702233184539371626321.3', '9894614327858326850919726257818672366.67012981899426520818538052648708', '1.30752943495193531e+17');
  t('950489904629218491182882.385', '50.055435994820274365748051876345109893948', '1.8988744893313385180963e+22');
  t('6721462722883.9311966354726787087082601741413325501', '25867.234256139566', '2.59844661e+8');
  t('9413983486163527516754421885066.479846304', '6633314177361.5759471', '1.419197588784792426e+18');
  t('7002240892739457.282399', '89015591879.3352', '7.8663e+4');
  t('17753832635768617659957602186770835847249564068657452538085.314', '5414272225835478934993841035541.91854', '3.279080159850849623699144592e+27');
  t('8553729051867653860352315550061555116210505978.8606644', '532148649404416860727903449060162092.468154664085308852337024918613284774', '1.6073946746e+10');
  t('8536876691971494129815868.6897706141137069461978', '46996438914351984548.0', '1.81649e+5');
  t('6738142388415833700.472993767579581588927912315304', '9199801.9', '7.32422552317e+11');
  t('826273980599097834993195211608140757140700093970401848613162.236180591377571758304', '8351332797745115916334876517053914.483416162382', '9.8939175411880868510041549e+25');
  t('487322874591251153754954926588608421417109463092990.1011277861883295118105474283076435', '91582945462431373829924.9', '5.321109428514263331756120898e+27');
  t('8433481464909454370642509052001964899280.2228783627688673301539647974222391298082', '30266532928398398232484872798443265706.1822461140566', '2.78e+2');
  t('65686681801982542.84396075122813', '957582365.894647770624411634929499145', '6.8596377e+7');
  t('7850604940208544890.9247585846806664911793', '1155040930918143.1609220900458103474609331025000', '6.796e+3');
  t('39392511281642750969008458658939595.80913687142', '5191932341769498710256865324795.288', '7.587e+3');
  t('9558675981301105859991877229873598.5154339956398358275171123983825685256', '231734499604794002120530879887.26727981104', '4.1248e+4');
  t('476674914347542301687791458999.66939117704198747838897927533336612', '3857790966727905.18069799747', '1.23561623337992e+14');
  t('31757061510157749074255570260815.3141745252309571619347', '5558718183494207037354935.115718972099325505519', '5.713018e+6');
  t('55815824571357071724508377429858590197270365301036620.6499621562531443269376352974542', '6344982556836106788319067366422.148316894830679515811039239944513903', '8.796844446990780720846e+21');
  t('55247716219685823858100730862446011271407657968442.2388', '2767291514389721456022328296.4650633073505614236873593850598833', '1.9964545091256768937684e+22');
  t('6761209.130763539353969547801764942251023246540', '1.590885201', '4.249966e+6');
  t('2405606665780351532451871199611687931502546956131339306340566.0', '6825669102701242156374198698389735.1059222967206052225797371246792243831433', '3.52435289432407215761911266e+26');
  t('877076167194583592693.876598666861', '6190254976506.51774', '1.41686597e+8');
  t('79069661333784501383656688613214.257990', '142518071705.177741054004263011', '5.54804456640089858664e+20');
  t('950777525591301850271871918739602342179.4975192615224', '16476852885091323001963060603651240434.4840677075888597330272', '5.7e+1');
  t('26551682789560636085042330404191471793442124027063025992124766.6037274321361454227147709963325345384', '774803664250584587578851487141713088.4957299207587035513251688453163648', '3.4268917423412408573383842e+25');
  t('46468371103211225997.1814005593644996981741', '18137114254170450.82878438255568214357155', '2.562e+3');
  t('8701396622178709820158605599474684817.7939194512400429727126808819', '5269807610180215.90684341342722968626667120953', '1.651179182589009367347e+21');
  t('522080413680928259313223.8350838672113571792330389637633', '967093098979306539029.5142749231584391', '5.39e+2');
  t('631057279219476761359550973233448182657555784618785135880254.4433511291602483132340946422059', '3739479405111145117383015003991123678215.9094479375490407161549872537597', '1.68755382997147546666e+20');
  t('9340382392708974624402664792170319874649661502.613864741909659563936687835', '94789964379299654069146.0880932655391611156772128371364143791387', '9.8537671723703469565858e+22');
  t('96144558384720050671049376570.336225113556797167876983377', '128639182834148126420949170.21703913656313462457355167212385179', '7.47e+2');
  t('44590415926988658828909817888389.1677103148', '9586443276004126152513920155.356137636194947762', '4.651e+3');
  t('9215124017686364502116144876460066.07953', '389873392412923003312746.50237370928673677566574783327261160564', '2.3636196255e+10');
  t('11561994696060972430401104454693593439978392.61858304753448649547803907017833175', '7392485698765829306705400315.1', '1.564019893605102e+15');
  t('3649070.164', '4043.453844671869616230574177458607576071808', '9.02e+2');
  t('28753538171328476925.0017010314596831751138657770', '49897.25884', '5.76254865292886e+14');
  t('59819348348776332442992247927722843864528890.75097663327918991715', '573076046726374761677061258.316253554', '1.04382915130525656e+17');
  t('47609439462721678715653967619481244095905572670134015715.65729840144', '885323310774998183628174741626809.26089705926186718635169318481577351', '5.3776331068302177444681e+22');
  t('298236340363707692048708241861991295188088551.4221467040362905598412803266728698', '463565019023489856620642648.3290607854102222131745220674', '6.43353851401361676e+17');
  t('54929430658455389942886768773694574289.0796444733881465290886813482232', '44918151271303370631927846249206.32550877632482876046', '1.222878e+6');
  t('939795570873706469603035770969517140837.0641903247563112818840087', '1543654040561654608534472.791305843048', '6.08812302613974e+14');
  t('3394118249472724410996.60867940867996614427101453', '986008213590938059946.4278174507441549093044701878559133', '3e+0');
  t('3219025755604178377990.9595258558146826339702675765494335625362', '0.0061921662377979164972614769813413', '5.19854543948571621850347e+23');
  t('622531843497701836225.44014041222798344570830', '8748034164866276.4452753664305923975621872503904739881720', '7.1162e+4');
  t('662614977396838089149840859098991636538.2', '9397894691412111466054.4947143904863027853588236090636071521', '7.0506746367603179e+16');
  t('4578829625898584634467190705373383011906064239155.1185477334628882810', '632007407091540422974017864157542424182.34755362226514919952546271946914195931', '7.244898674e+9');
  t('916832081126482424615311749127.615921221158127735810556635102616644566', '8384.837472180636635629849053055370895702252', '1.09344049204097784978620853e+26');
  t('4954.23611284032403311231075118740', '88.498212500550930', '5.5e+1');
  t('79610898256319046500444146615.6864031929205528585105087035692', '80896642883513608017325.0294514915892271454512031885360702636', '9.84106e+5');
  t('61808853465770082537520295307.248478033009783289862114', '955641982486404001.613606147559792147544273131898', '6.4677833957e+10');
  t('8110549327848459643976.8303173991466', '30737279.373498300268975735386980334643263', '2.63866857872963e+14');
  t('5810839929023546534104132044.1', '84893733939290740.4809653570525806400882710060', '6.8448396122e+10');
  t('172691117791905665518300359308210758886006820428.87539418140101206249892865907830466693', '660835601179363510263672967172874227337.06', '2.61322358e+8');
  t('3279456955978403711154968614687388316452522612700723465.149695243983336856328', '577588631529180012819465736405090.8861257433453983', '5.677841939679389639385e+21');
  t('666161807347337989311252336805857030347518.318052095204396913164161131565370664', '872761809105274731.8877136229902994508991839235', '7.63280199015885067221879e+23');
  t('8275938190286405120150409214247983637248944.941738387004126831286000172841', '12096490665151859987460112.926843', '6.84160259316209586e+17');
  t('7695708448947073283007565247678919802765643921.6229', '20676645248620766235122033771379805992.5085467726850799060647673284', '3.72193281e+8');
  t('8794449979449374744464818.38092335698594675809515993704042518861', '87246163726525037961.18644647', '1.008e+5');
  t('34236691816994475206275629492066992140.1738230523709146', '2129216496065696627150.95546985718524552965839741619272227', '1.6079478944605221e+16');
  t('4853912271361439786989095336830718.6076759482394948759', '72348458301853642853158792417807.55445527491', '6.7e+1');
  t('366715548457842547998161006130835982863471526.1874', '592192383096570032979767219778531853.99651', '6.19250701e+8');
  t('252654835644880329287257339.0192092664921880441830937674972', '114583965.7', '2.204975487638235314e+18');
  t('15914954356187834913890394667884070882296058039272228.29247061503', '89211668928209478511971223318021909.25768471588110887949696377740', '1.78395433550233614e+17');
  t('60941262.9', '86784.8541488681791123390630463904486146686497', '7.02e+2');
  t('812940878087050080928021459149088335661916.37', '59149491291803059507480051333312058007.062712657891575524497489888510', '1.3743e+4');
  t('8593971316358957359050500.50716500974128139452230', '25290964518847571007.492624342212869491225663005554920112', '3.39804e+5');
  t('775472515891.0522315643764386165675035428537', '75451710.196830619592652514326721501715662228', '1.0277e+4');
  t('268761594453672559012.57845518051', '53032431321491.356897991306736326010290480785407', '5.067872e+6');
  t('619377812175076884453708563003062095749704505261.1547623731721222869788885', '89106640169384537277237056784847388168.868903457426831166694818279050214563', '6.950972576e+9');
  t('6978479696336.407750472510412676812', '93141102668.5857961', '7.4e+1');
  t('516436650078318840329669774.078824828754', '5017214.837481322761649964308586776', '1.02932935265250407626e+20');
  t('490631762562589558.665786505312776194035633603735834', '649155.033821223610', '7.558005977e+11');
  t('947869242801417639782630473107601572138496682152399.17956931525088166548167556227', '840790471807620355694329990198.9874', '1.127354881607528220077e+21');
  t('2564692393707169.216665682542053468831487490978977829', '323563220479178.32428957186821386', '7e+0');
  t('2067552564632662838907661952976372191277000771111345175.796442275947', '3381292480845674951573463021547.80115165450475391748410248580874894107', '6.11468122425055511343146e+23');
  t('70216186412133337741582965462.52439383368643519565826224295231457', '4847013501.817153511151121174556393162', '1.4486484592173958541e+19');
  t('60223297680959656543180144197075879548136208100.5879200429893598', '6610583797054930889.55336697264241489373263078', '9.110133012426168452797858087e+27');
  t('1100714749763916836353092605748.52655085', '779697712515.67699911984429463192045202', '1.411719865398201107e+18');
  t('79626424799554585294898673037572734444630623847083.669713990919063402455473', '3128504487858810656625667140003.174840434', '2.5451913241157582834e+19');
  t('6499560612.7645915152780064074524537175219032747797', '50307.1949994616624234103', '1.29197e+5');
  t('966011316836321370187257766888009716196999338557221680156.778158238236921197664814398230256191359', '358196212874876634005370496387309158.587736035444731188320341011', '2.696877527216525217891e+21');
  t('140971373374810910985007504309.42888593963', '431202282197312494293.70224', '3.26926315e+8');
  t('675794608397379290709048966424086.68028114190127', '1240347490080565.063897869467564696954714209', '5.44842968443854376e+17');
  t('836232084565440359935123668.528958', '7271445413139990104.53416630912543262333107860536', '1.15002181e+8');
  t('850358657575460995515858566.890400808', '777933377391397802395.254509486818479707392046991771632811505', '1.093099e+6');
  t('761818224703452918328839655440734786723729570416.4198584034818320201087492939538562770', '21346360079648970861757141531.562732730023110894118984', '3.5688436897949142043e+19');
  t('519514128427497.31939346721795747746', '9491421.0538075082665', '5.4735126e+7');
  t('102986940807998690465748208569646362.946274165446616106329669', '5974890620275324316992866746565611.522984821183469702378289711906920', '1.7e+1');
  t('6707587600519349898241892091.77518934590', '594205895259507615.538773903283415731263438', '1.1288322202e+10');
  t('488150589181424309139864207010310632454374146702168720363.1847512517764753412429149', '97003800941413717490725115964913798.62744', '5.032283111011774364885e+21');
  t('6799686285593498192221915896.212905290078445310739698403963', '78132247733377074935645330.296657617326379526947267653278984790', '8.7e+1');
  t('7108556948604887166624271892.627550941216360716459572502', '42805403698.0650970130373336924750741731549185397', '1.66066812469431525e+17');
  t('912137671512451054186447604601690.5574512047932493751657398', '1263902716779730.336', '7.21683448736043839e+17');
  t('704346766625443412065178734792137256.31026366', '72396278074342368559021.9', '9.729046649361e+12');
  t('25627773207438202279.636045104992624487718634', '756649304601923860.46033906136178', '3.3e+1');
  t('1880709.9929396954456209927640755693275', '52.21986114320', '3.6015e+4');
  t('1041659292054230145523905801406135905.767574486006304', '1077256602740300721008754.2018892591164', '9.66955588301e+11');
  t('618444195.362352747', '982633.647761051003411599741028168777054568126', '6.29e+2');
  t('8149897727387665433811.65013493798188347071989440808507136850', '597.9009250302148183861539562679711032074904', '1.3630849838500938565e+19');
  t('77968836131557152730.6066503205214825633736137387446983', '26.623386260991337602910092388126481759', '2.928584492116140631e+18');
  t('58448947986859579208055033.3456389015102041572478', '2153905666033468518224.3437080580833650080075946108', '2.7136e+4');
  t('6993476184005449151432283167418719409242730550.1744014504259312', '504344745739771251341596348502601429.875559823', '1.3866459883e+10');
  t('9156021789624387244321355068223756591822.5416168', '929009690841898347514853467259.26937447940747702070366316654', '9.855679526e+9');
  t('54330185842672278.4555577425007916412274148109731', '1577.7918977414848348786821735039896', '3.443431666777e+13');
  t('95914671847110222364375303076989923584529.321328513604213290549860344185884058', '2312554910790387236242675768763668.633528273398', '4.147563e+7');
  t('9536271622989657941117893870005898725035.3960398586472072666106052', '107536934433621117261934491721512386591.0', '8.8e+1');
  t('718176021859626777576712.9692740745420691564825232525573', '609238197799407984.53913836735676967982363463448876432', '1.178809e+6');
  t('44147152562206392320344564636849995094742739797.0', '22991031307190888201.0855628802911798788502', '1.920190180785779688164390762e+27');
  t('660415483245802503290291333.923018585223', '292424134822327709.238637726447021751', '2.258416473e+9');
  t('20545531617482656229157718922767746778787657.207138153658', '61225931256372223626.90739984159221368036456893', '3.35569115828586678799015e+23');
  t('3077763588319523000185225537563626.44185631365877', '757408543454069.33478', '4.063544852932021776e+18');
  t('74210773509491015321971288853188186456501.62032549124720896856800', '9752831883987.0206', '7.609151310332355723859683074e+27');
  t('481521621431311221533120267738316547022210533280414092045.4966374181245341881928472226', '2388901580093030146538832183486060171435.86476411367808', '2.01566119527016887e+17');
  t('72192973602112762236525695725845138549950913.81954382461791921273690806972190', '96776330870187794023873578780566785636.058678146', '7.45977e+5');
  t('119742591046966404722195948781966721.01695296051172651603', '93983136488596469171.4752185', '1.274085921376921e+15');
  t('444082753643723744248929533277488477679501792598151270869562.76763265462818198600263743750205090', '6228439537840261298334866243936411059.67481135791895089583192454967', '7.1299199574105745428311e+22');
  t('110828482274142230779699188.529887251', '65.1586610488934782951339558171920581322976', '1.700901775605536564540131e+24');
  t('921304159208172291.2529216431120383371594612299467928045', '917514.9982922883265577583593400254752840711', '1.004129808148e+12');
  t('21372434357889783069576532404722246146517354041407290499765647.669218667449701212888', '24768136761466020720232473820284452179.17480045254367', '8.62900369281744600990052e+23');
  t('31633231595423543509401836426.27562360735', '39889291950325418827287.1439022707953', '7.93025e+5');
  t('31313038000190427467108862.953277601714227296394211746230459', '3310916247527933729395.4129976255128526', '9.457e+3');
  t('798828627572603.727971269738387662892849210789563', '756287390377309.8390763877257066774437887466165861796', '1e+0');
  t('9968141807136584404505388614528597002153666330600.32971832610670788226214273532224490', '97522181053577338999726881380804207134.5123753140759376519585414845', '1.02214098366e+11');
  t('409813948864900137311883423.38693292822924359250', '17428515002538920.0', '2.3513991226e+10');
  t('5087528663920644703276124295927173535751.4813142', '52830793960867582981156894718.060279975065', '9.6298546406e+10');
  t('33665958929797992460635570950732102086743.3833606153246096', '5132636402232017.45586123490333075481', '6.559194201864319963457884e+24');
  t('6761486086216997010.410185811259', '292.0', '2.3155774267866428e+16');
  t('27787087572938204426418141471262654835343.60473034315690449', '77635481413450955794455666.6760410840988434', '3.57917373178339e+14');
  t('2510639329969261502036105561.339791319063145213211372777606691685493', '46415415.49834833', '5.4090635686727858383e+19');
  t('90878252791773403803339322705716421483.63796461', '6737299372021.40332539299479421129588297700252', '1.3488825087567252917794333e+25');
  t('3043219466230196057545184137448.20174300', '179929605.27300054493937405646', '1.6913389331415647543365e+22');
  t('91235011323473120445158535647706675461799661544627662400.005721378402', '202734257522659312725891424885778.6194767584722957599226218253027670', '4.50022667300201674564366e+23');
  t('8484774342019449621624889342469393014750556168432472799.614503685556194991919663231407157', '26275635180415559306948656874732365.405171488523027822183897956371676', '3.22914147793600917325e+20');
  t('6242565779763524175877055161662911.88242895611525', '57244009222715052251.63296787522676108', '1.09051861749865e+14');
  t('9047285283920262654132188752851469760735.87672786068296691868390646', '172909606762078054346389651501946337483.36843656846586227537959', '5.2e+1');
  t('68651866334998005083777146996360950316005966076.35', '3199273631047355849734912810241.0626361122212', '2.1458579118949333e+16');
  t('90633833673440118887041300078024994593666353748975238.069036497377133717563318251', '698618159080301184414663689781005767130.332211682464', '1.29733005784956e+14');
  t('30988956441582629111918442206834.60645499990734957844500845606315281', '2217558000.667213998887496318434508958688383847610', '1.3974361181199652819142e+22');
  t('92411429921158629387441350086627665.16980803470607768851', '36656291337236255254028.58254986', '2.521025083279e+12');
  t('119410032331444575139.618912597435460007', '7816086.64930284781397775', '1.5277470387575e+13');
  t('6380616366644073709925285687254469007039153713114039505254.1418958672720', '71824778398422273933520161172698392.21614486127072549439', '8.8835865684818212691548e+22');
  t('11515434813901993618828527975116915272455948577608.0547126112132063424010', '6951623736036943717945331.61', '1.656510083278304172235235e+24');
  t('663553565463598017529814434530178210.43517205528967697167627411158858611780', '53946805542957.4891878403867888656831266035760', '1.2300145648757916607581e+22');
  t('1581657405986931669572670757908528745076166.25350485892', '4606973503493929803773540062612781.045030980261409248581231481', '3.43318103e+8');
  t('330805341115.415670001343300934342503387084729339', '148960643.23947943737425628979', '2.22e+3');
  t('482405705547678428551230144071583528261809512809463678579524.39989145135685423388999379509935', '98210098866885069227678568296796802.8213658332545965782306145369373187348432', '4.911976579939460716205322e+24');
  t('512415092983743942300235267575283292185729.0', '42913557004929820006.3800674340766', '1.1940634353029248173899e+22');
  t('2718709006709830896776883653257.965793050126809653361775289697064924621', '14941557018.9366131234', '1.81956204648832557673e+20');
  t('161319849408178477030430097879303610160.322417615481', '3936704418565912038725111146946774212.0992762597601570950353881413046808837945', '4e+1');
  t('7152365455807252.8114475144932', '21508450545649.800434851925939251', '3.32e+2');
  t('779267811590474773868960921493.5650187412978893643567710537304', '2036059179953184193229622.9950471042714096728277880668', '3.82733e+5');
  t('95267070358418654094356060.8770636288409152', '3428.4475058783244559', '2.7787233199597275914351e+22');
  t('111163702048072914414011690881589.35170454316948290135586650279', '191438999446236684122904138.909020', '5.80674e+5');
  t('9136258406578664576943286771.301299154717494825815', '26503453909182932.0', '3.44719538739e+11');
  t('3756118441930715228117924643520422937125620282010.835088520518383154810869922423000', '149968478128924180613155.136316782701504640295856933586', '2.5046052935882121680034743e+25');
  t('802662856201110019.5591', '641215895128.341535793413376913309286576', '1.251782e+6');
  t('97021890556855823302.697281829410469843325864', '39795963477131274741.655612288760', '2e+0');
  t('5659341372147094581269027793.4894973218792631215', '26.48605745427436161374536', '2.13672472089037969245119456e+26');
  t('642772579197291.2646018074748153069314', '96.1603340960838097', '6.684383797533e+12');
  t('2382436885798095836321091772155940596719817.2515282', '9618331673254347019264376508.2257465817491230496579', '2.47697518315252e+14');
  t('2634566212367964745889737226041.93413351', '70454.7698022148649745', '3.7393723941812420717963864e+25');
  t('78949225333267788753613658890057098294.9633956776049997856126989293', '74158942398944189125148354676.85457667996238842974887364261', '1.064594811e+9');
  t('80943544365286449702780512060783168840523788813127.36811828784445366271', '24164546692345354434314746697.38377176450140784020552977', '3.349681887098137756762e+21');
  t('76230861714240544361532502928340607.2', '879575540099893084959932639171525.27478310735045680646044881569425969023', '8.6e+1');
  t('22543573393132549729259835685359101139970668524531302589.385947082858850468774143474447350', '38534853334332089157818475391453264.72', '5.85017755161602444718e+20');
  t('2302099171318247978761229241856614273640938814838127.316025435470415', '6863809868240966824468333654517.477845841795365695426580878969795', '3.35396698846528786351e+20');
  t('3118733392162576122858669448825954701.5732582828812599341068', '32636435861513474722964.235490115', '9.5559864606427e+13');
  t('79787464002980766.83', '67900978906468.635', '1.175e+3');
  t('84088526972984871391117456567495346740780071311331.5672798087923110948298214293391880124', '8186166353490997806363848112580395620070.3202079646', '1.027202763e+10');
  t('79540039953293855128849508689228623.85282131097088041146552401226318075482', '7756085995721585071504594633.28437099509', '1.0255177e+7');
  t('2861497226975839919662576662161309647.590473116140437413930118502215930525540', '93972481576005234.010', '3.0450374183866285409e+19');
  t('2409441287657038852505645875108993665.867', '520646641534332968.8307946391', '4.627786094147220609e+18');
  t('289454627088798262252340538248.3802600969646187727594802120095865', '7195.9764229951559842797091162997132', '4.0224510208764633470802687e+25');
  t('1288427480779604805742409181012.715356', '87198068426597666.49450539968273104876311749', '1.477587180574e+13');
  t('7450529558798962209403045339750.12317696201063871380682', '94615223634543811568747189170.761803735124782784720306672091', '7.8e+1');
  t('6219346401711891004949077187092224172252284899312121135.1358317628566764381135660434617541423', '3536452048506796341070283035104620356160.58181165231317856207178068705476808815', '1.758640104943003e+15');
  t('82720661721559047695186558320322890551785.8020770293384802834226676', '481038277700139876760017826858.976505337207480194780', '1.71962743e+11');
  t('947820270859795201628025830751730199909329865719805.326312524950590254835', '9891634595298979464924926934927.997300487', '9.5820388604958053761e+19');
  t('2565856001004088462040.104574163550268292745107433180284', '22.08984611745283285041925479914651983', '1.16155449311928290008e+20');
  t('89395163286394733047950062858829661190369055387.916634595679755', '5324944231421784460507849019.132889909341579187', '1.6787999911602044262e+19');
  t('67020091012342182.667446584679610209992', '13165110795.696119314770017127130', '5.090735e+6');
  t('32168609543204150227989635423701256239535092652043.6367502', '25205664291332806421258770230171.4690566997139308531926021489', '1.276245258660594592e+18');
  t('9505453290790869892565597067.38868612564613879357851628785016', '253241585.949939667100150', '3.7535119894052039659e+19');
  t('8828873915187218757419862356968362143.50376096', '18756765814162.33582560951751034', '4.70703425241944364143991e+23');
  t('414114555441261.5312415247329177240739996510', '533130798.9388904086409432503419897717012645547592', '7.76759e+5');
  t('19618680000282311916500403354885184361606.642238794664', '8397012046467794680170976686258596.71', '2.336388e+6');
  t('71213360145365479249598187248.3995', '25674986587158866013809893.18695355206000676949064102778363776593', '2.773e+3');
  t('89931978982582358651624915242201220773585268.25338060326735544043391594482', '604135926699031727314326020012861963989.54356149910340529956', '1.4886e+5');
  t('663191961669969962089847255128.00118617609406688676758487058461', '74344812903947014713360584.943405225215165676594884730006300', '8.92e+3');
  t('3453684526349591493121097637486775230.4165542', '896430781880729196376411093803353621.10554993642898021538381485913', '3e+0');
  t('700904883925451647853111747240303629023037023479.817525768', '988213577749684468373499862389.615289577824174434460', '7.0926457570186471e+17');
  t('34304309480313373.9875291919106797094', '2852691.377889555940287865797', '1.2025243861e+10');
  t('72209105815015395.4974517632374', '4853684.6637480956386877685466', '1.4877172873e+10');
  t('134803423888410099739656804729708675286498528.68032655047189119852582329753796', '86270788461110954469491628365821.302519644554621448692942184662666880006', '1.56256163057e+12');
  t('9665100926318185012179790538122021712.51', '643419546740603465273801385977643189.2883366878842408163169751927709259739', '1.5e+1');
  t('74362350236173641211885717889321879221471541685530672266536.290', '374426606237330464580009496896023430.0', '1.98603274974105429076185e+23');
  t('48930446848745077381509.58122499904688859', '9176987.234127144792', '5.331863889576285e+15');
  t('724163725926717513233532951951953930.00769440745720157858', '574204318905111691405350744529483.74695328821448558184', '1.261e+3');
  t('64427345729731168842579.69353507216784468961793130610', '27886950.4553795099221482243880208144404436809', '2.310304449847181e+15');
  t('14625006587630445.1742266210212', '6493633417368531.742883363127497198728752371516115', '2e+0');
  t('45847346883375687542169754775096250885345986510920803636974822.4349140548040319500217516282224710273', '293842391428818462649351400920841266.6823', '1.56027000258340632545418441e+26');
  t('88171794730830036063587935.9173305168985052689304904019759376', '12346360484139807.2286576081064648152998290', '7.141521166e+9');
  t('58774904753494470330901679050542558512634978538039730556941.3975110861734563843', '48530977814030803461859438584459215128.2467448463158848', '1.211080167778981830451e+21');
  t('10103619775034070815534445192301102141420263090.57906948870005547034', '81251977684446480682256664971575512.87059357907', '1.24349216634e+11');
  t('682570795216008085387498777383328850764866.4275304280843133581735973060', '75700398504466.027948194334852487207', '9.016739788704534672820096766e+27');
  t('323049978347236756602.8736687071337656352021296128', '772285262389.107797', '4.18303953e+8');
  t('1670139212904113008352808556949589110633968120849209.65210', '18056863391168830887289330.7911988536322623700403670922899', '9.2493318286992033397174035e+25');
  t('41132494903721339483096065.0876', '6397828427660218120.209104552234381803145865772', '6.429133e+6');
  t('81602309462563170149276620735045588.695282362', '959432788.78361', '8.5052658629710136944422896e+25');
  t('312145183791151049094273388413398062853.4850', '4673970731553.0674601358464635907429889720798645400763', '6.6783726668188060377370818e+25');
  t('72002030363877564923312584549524073.38529927014235327939192', '115214098943258757.5635337952040245', '6.24941140227443011e+17');
  t('2537576337938613417266707796231193660.3196705577175458950373044706979707860', '7323837365536379313606246.4342373293216213777744435006821', '3.464817979e+11');
  t('89172180969323428161381535638.5475049390748970587383153170115949304', '5037398.358892835744180192166975', '1.7702030813565136415691e+22');
  t('85891691778312059856703662.0707948448590903782630269041201', '6812080080048505801543.8991272170959993208', '1.2608e+4');
  t('3204900.881455322009276880727382769875645792', '22535.0', '1.42e+2');
  t('881401812458415945276.07836418455626124690', '603260.4149646026', '1.461063564911902e+15');
  t('717601961033851598.500', '5962190022.8964479613858421', '1.20358787e+8');
  t('5665.81434153812741', '55.908142147894', '1.01e+2');
  t('555151613262784555706923026886665310223608304507.834927141', '920792528203117496860222732.700202787237775891117250770408', '6.02906296759527720524e+20');
  t('42705180.0566060960740365117503344', '3190.20224129117646987313244', '1.3386e+4');
  t('53586654973677554832036.727614103798730848361452294522577362756', '1723850381634853.49382244176351725', '3.1085444e+7');
  t('8075529207621427035938411625290288940134761326.4843276467765000599161555327752801960629', '167009832742854705129928349.888531038241700194137', '4.8353615323088980672e+19');
  t('12243920347.78019931332457206', '10662.008760937878621429771725', '1.148369e+6');
  t('46640036995527230277528065524416100039949894476399366063170906.06870634', '9874651542271593808246793378280876256.734192', '4.723208388252454663095329e+24');
  t('4006876842465714844188831.5969407920172227004831742365', '50620571340123469707.4512458295341091594261343811112', '7.9155e+4');
  t('377737226023460183796284932215619897.386107004559722515', '6631049403470.465849436547545829720910662394630', '5.6964924107753647569656e+22');
  t('94168901831971474.682921766601', '280027190802.352984098460106745060880', '3.36284e+5');
  t('8125311.3838638875892831184832347446836074799', '2706397.62499523203762104999832486849167', '3e+0');
  t('1229640029170100454145051119275323467913.08755250628433771816821520120996802', '833320318021599178.70735873', '1.475591081337619441891e+21');
  t('7337693315048668346529194627233957003612546756586.35620919922707320525396265709', '9431553067702071781247594.327397', '7.77994171519457198716547e+23');
  t('97184775385346771375916499941.689361878336539', '571501494.0', '1.70051655867319169905e+20');
  t('44224858244830574454824248881390239063.6133313897996145', '74774869906020882299909426.9392871921522884130202053799', '5.9144012287e+11');
  t('509909572685498641599903.3088790695123575709126360', '32956460.533703604907286497437726189968858704154', '1.5472218934555459e+16');
  t('506141615004556063927954912721836947545.0', '73874087425678873716325379036359388.40538007978691386098015', '6.851e+3');
  t('83526906870910217716094867719438531428990694252.6890464145636170454377614', '4615168421685768818138.7945460018', '1.8098344250760970781261434e+25');
  t('8905988891311767590658659200511373424.3967936493859651449815682188452290253048', '233305960057090435.72214224180', '3.8173002049036613856e+19');
  t('190.4039639829880345703909', '9.09195692708342896839903829973071174', '2e+1');
  t('8192358398252559153762.6003760084421357364780201173738', '0.3638925185811148730837', '2.2513126761154914301471e+22');
  t('6995524432510729335957664879027514919179245781821.93828373179206164507322583357399213', '7694679647506406867852.344619229', '9.09137839777091851952716007e+26');
  t('9667707732553.10419349', '966794924081.31798549845948989367780425646', '9e+0');
  t('16809269109290.7', '2937700.1531634090336858', '5.721914e+6');
  t('88246600933914227428679998714.022024360344558515035362983835986', '2232278447500334580999253.32744151863', '3.9532e+4');
  t('232724246935564123335739247303843798574.2', '86908236501.8069242383339661044104431703453870349', '2.677815777917959629762205118e+27');
  t('98345970681326307966292.8718651360031962708', '653171802335228283312.050253775614299894015215874962047822889', '1.5e+2');
  t('51397600091748480127.2088050853', '790.60640695479', '6.5010351092041678e+16');
  t('1798241768560345355621133025824.6984102763295559923584224085607168030', '3410020656672334915.43679411642568775188', '5.27340432686e+11');
  t('666787224655039756153910917958143384064633.78890700527098985467264094400074647', '3971614846428591185037.8071527020551782826483005888589226624965', '1.67888189171877307007e+20');
  t('45330989381349088176036500519957232026899506483903.3693057963751666194165', '19635428226308045377682221845614880482.0', '2.308632582843e+12');
  t('837932897464721.87352992669372598648319113910', '57.5192307354847545533321868737335021062', '1.4567873852801e+13');
  t('7341715434779841853967728937477.927067', '1989085313982.55425058192619566001618556450153985108', '3.691000774662717221e+18');
  t('252521402072303815947752206072867063949.6881953197', '527640044408832839908.0', '4.78586499921984575e+17');
  t('15154437827507975634.79', '4426306937054478942.8831086551423519835', '3e+0');
  t('373588908036.532213022532', '85331.576260935156', '4.378085e+6');
  t('448726769169701581880.4554411167433794366094382', '5048771777.832488929244107374177', '8.8878402295e+10');
  t('67023217149624564.0', '316166826310268.648884140875', '2.11e+2');
  t('61873040465546604543754427696088758690115.26451168879610092947219098363126097', '58155881015946579806737.84774119324', '1.063917171998146919e+18');
  t('21164038018831557445589982613341139225.95934817572123653193', '881074848284120.843058236535', '2.4020703871014117078626e+22');
  t('8535408832459569490517181424509365728977141172353903808407083739.0', '4065093747822348218936491329017064777.653', '2.099683146798754207037050758e+27');
  t('605997568940930614213036397430024135296072660.334', '64940520114726172393873694050702.5431763234711583293426774709121913633', '9.331578617946e+12');
  t('1033949280835117588546664225.495976052157564530541615768808', '104151056711.4', '9.927400772324043e+15');
  t('331281.263520042191716194360794901934975725622', '91877.8928739058075054259406', '3e+0');
  t('740017335.015847113341777580343920231', '2.0384101060100990', '3.63036531e+8');
  t('731705717200752945308243442895300383.5929840908728685572861789469818599144', '365483284760500911492.98814080', '2.002022384362216e+15');
  t('792509704762196705701313629865043733577.9714652359144623801253515417934664964158', '1998668251133300.0', '3.96518884168406564858004e+23');
  t('36170472034683461372712043735465401502730842.8', '24540827927027403747853146287597.8927564183376510547715651519420915007914', '1.473889639837e+12');
  t('141534430887319794686774773268132280030.586045742162904', '51082373606872630877984685.86186490140', '2.770709755512e+12');
  t('4264318965192230091576077097.971897', '89.28717698303952603962', '4.7759590002518002939797376e+25');
  t('1158478377824188531161302177318406854795685070.9550062040598448300018410915666082047', '103814356501289272212596382955.340898589810343804790815516', '1.1159134602060567e+16');
  t('945837294552976506396924887.0972458764014664', '6901049.5968489833042637234541648', '1.3705702028063172674e+20');
  t('82411904611172859259289852777372.080994051', '195511.4658429135', '4.21519547489802412182038977e+26');
  t('12988166325.178390270777355323613951141546773375', '6056741.16488739901468364101952', '2.144e+3');
  t('7790188862262297808696351311081431455169380810981.2939501502961939496906887843663', '9688371966647101054015381213650353.22811234186', '8.04076153256766e+14');
  t('266378599338336385563929960568675732178127.885617596130174737749796442558222867', '300570837142623382332880.809678383580955', '8.86242330994798097e+17');
  t('86674550910063542149424960021255620457265485577362030.98980221655183625573653105', '748054979535232472776520776212.16742388', '1.15866551632227022724247e+23');
  t('9481867473683193803434.37819093657035214116725658042072168', '203655287.120843941491920908666165094', '4.6558415485952e+13');
  t('805324866738363320828474614.480', '56162041772.86042', '1.4339308923193852e+16');
  t('83336980219606474398009952692713912501367.199636061482', '11028967292584166416059836.01660672243509704304971087766', '7.556190712039007e+15');
  t('1219197584212.314', '740428.311346198893835548942436837046', '1.646611e+6');
  t('60286481904069902987819067201196524141276256703545309769273822.8290996', '998434833685899026302538967695719608295.1511229', '6.0380988192801404374872e+22');
  t('51942693184307148401246.54', '210093.29233134999782920826486648079089831170', '2.47236323482357509e+17');
  t('23143496.6170754380877', '33495.1455', '6.9e+2');
  t('3219782254166081070465676620420674480730.6098428791655097397340502823', '22684372849660.8726765476922245', '1.41938341231867745474078657e+26');
  t('1489210346390353090.057706915504976', '5433229.770496111663561525526276159', '2.74093018203e+11');
  t('18886595312176134995881605303205215213314030163608932.135', '90056933448243013080703797857650593.51719467086101579937951953', '2.09718392454818896e+17');
  t('775491933997.85604801861329954', '80.01408326981', '9.691942996e+9');
  t('8314969138262557800135767152359567965100210088.79881810647114453482512806', '64881320851812180590625843229063.34216535482000987', '1.28156594673123e+14');
  t('643599228630699698138.61707155379173789887223474164204024', '901850962627.1260234925', '7.13642558e+8');
  t('107262910245411125074503825531966126300180.7334098229251453350138049173602916', '1674763691207585887054481597538809894213.160870171702394336933245669040455093', '6.4e+1');
  t('10549847583080788210210.0', '79.1140498671952593977604111238', '1.3334986138100984541e+20');
  t('51714789116197039772826251968311155828678142.0235925', '5974295247854190490012266909930.55388296616882857043630825537859054', '8.656215833117e+12');
  t('494464156424723513701626680573687038259.76983269036055', '70631921709.17', '7.000576289863683959820347046e+27');
  t('227427126175204729364406565216174.89594445722876228593249391484698233655', '408026842199709696111900549.3596993089', '5.57382e+5');
  t('51355869550418745948099893914016132848452568924392592845077111920.7527832094925304167849253842987899337', '6692588091904374595313774594134776022.5518694286746263', '7.673544052791906336781872002e+27');
  t('62562658979141095134666293620315609.514760', '39910486009197711398555305163694.859024314073340', '1.567e+3');
  t('5882598360847202450057037300708604929663365612.613267', '746909960921258658708342948678766967471.789516223744690514247094501440062', '7.875913e+6');
  t('1035899914160894694.5932195869435633503679886256384', '467429676.711783998471976711978441449372240473', '2.216162057e+9');
  t('32014756177149871404089537663.7992867927278939011716211454806', '78822116925773698220688.604565846104090577367660805604242639238', '4.06164e+5');
  t('811047709964587452166468548109808480618197091287118.810388659849653906987223807682836270125', '507799380874387879398641129728623823.5923973499133316603645406939943701', '1.597181368295548e+15');
  t('64536966331244179.16796086997039227341629854457', '1242256600268.0', '5.1951e+4');
  t('818098686921433992987866.814826105155714053393988633', '40222455151702942.5528416292814973154300490435546545317394', '2.0339352e+7');
  t('7553910276659070269012425398712783883640354541860301350.386', '5276669978521301013319441166008388021.342100525663226970109985092942668675191', '1.431567694664870431e+18');
  t('389038896164242499541198314451931079986136659431914455.45316690341083511362266562976204', '2016084668783051664723727725.0906017568', '1.92967538609910676229133227e+26');
  t('413798364691378933308195970832279005620430.783537334249902', '814455764481894163.3287631692357373086825102247', '5.0806732880650870189962e+23');
  t('495946883432974042086212520052457189266839439093.069888410216520174041679171922', '567535586959552538209354.703151101338215315485008162648175890', '8.73860414797776333669985e+23');
  t('919887450258077609131348933600446927261389293524.86268780214409854', '50564182510486180008824025560.26102044728169633594307467897978553722', '1.8192471520078626366e+19');
  t('23417242.576401', '654840.494192113794548448', '3.5e+1');
  t('961076684076787384638982528361293567.75542843473435300975640022102693', '77803179946554567675429867233716702.3985463476147399550177187863499189466', '1.2e+1');
  t('5660427029579194203790076069569696490919640382855226.0', '794447177869687614654803.061366421855736501754582104181926574754', '7.124988529454715307227747492e+27');
  t('18930273927713844627800392879508195439086821394463807043985.04914885764232103824', '5643013585711862489310655561529575242.996519321', '3.35463908427323109103e+21');
  t('228317191958555.7225476894890091701225948', '2919428056.8261594655', '7.8206e+4');
  t('3061669462783201488069005144486118745732136.15526392196914643568', '534684714327299321996694660978581073202.71400659963085643530863', '5.726e+3');
  t('92628605127976455588891125728711821.40135243', '11124782648.29543697098256292', '8.326329426505173914272545e+24');
  t('21511442998453.517762739302559255', '902746605318.327889162', '2.3e+1');
  t('2962060175673.62', '32433317513.5168529879758376889375657028', '9.1e+1');
  t('64985922853767749842545544085.2717', '223407.467744925334070488550597674002025924335', '2.9088518620140841279627e+23');
  t('973926374599015178148662.5259866315512108465148365695805882751099', '9.4091182', '1.03508783065241456755072e+23');
  t('22193665339942615554382782614650171731850824767.63804235990814293990430881', '13714781804383342431932474816.61', '1.618229561103871244e+18');
  t('8957788951943961360270476580624778700757.982153820787123027519095955687', '8338556574534.0', '1.074261339102873106583487496e+27');
  t('13124504224292047553135309370212610.412051689087164440390552435', '75867646822799373867407096829.05846377393460162880047071013254', '1.72992e+5');
  t('8802571884604783177143254551802.9749165405841112281414813663', '55506.8889755962971813985632673746', '1.58585214323123921048952801e+26');
  t('228133215837923334347376.8', '8.0942854514290085656', '2.8184478692637096567755e+22');
  t('60755294701803481203259511590584832932.9243814408215937015800820132027313373', '344145858708540370721325173327588609.76204', '1.76e+2');
  t('3737998232577326418208777257575812502506681.176309724811752734111260', '865844200246832560021235181.11617825', '4.317171878626325e+15');
  t('2482869486164457530779219919206588532.015090664378275207193', '484868618070764670571.73500697863855033528206243419771', '5.120705679083756e+15');
  t('7678179515444583767305211117920005874287.0348872752341152383326', '58948138012690721302417849534876584.8507906817743797', '1.30253e+5');
  t('253101141231994716211434301823688578.88419213', '88980764614395768934502383.13323363239965231', '2.844447812e+9');
  t('13437433580887136898079980164773375711629747617906.59782866812193', '915710531535318736826281561973122673.07455864794948945076948', '1.4674324601637e+13');
  t('83871749375325108839030467146052963497.4692700383', '255639976626247979.87938673130755769849453057652', '3.28085421076171109725e+20');
  t('9667852729932020997859594881983126939897294149718545.86', '53276667404701666452116833535295.49004839723063601006527599933777', '1.81465042783040759301e+20');
  t('350906500011846355.8273233292905629308012211261389697163002', '2111.5672435048781815240419703157', '1.66182962484962e+14');
  t('6108320931314187291333165918.3653887896219000336', '544.0012490193824689', '1.1228505343186355691116019e+25');
  t('7018134189630833771719846889372118013253966448096168667628164868.2848130598881217708', '61395642559830451588068252642627915613.81763283750750235', '1.14309972125328218829894409e+26');
  t('6792706962535547029423049967756843316427715327621023843293.99754099', '17917253246980051091656767456311122081.0', '3.79115418468534300789e+20');
  t('922994140497324355475.834956546924452670220', '719880621923.7057', '1.28214889e+9');
  t('1352679126725378326854008716.7965829738976648246087243059940', '1820598.592849207046102243871272362762', '7.42985923442057372255e+20');
  t('76503786436164400549400743007711834321461783586810.848781583682368614456752', '68033827523005350933093.8925146274036045506135661203851', '1.124496286943358711448473601e+27');
  t('45973960760251736315612.8850335657688649999644706240015429118551', '979396122754515038300.504', '4.6e+1');
  t('38965069032425085319587380019668643395599207200105433.924242400708365718491463542768', '9669834888916196306100871331690443991.89540941', '4.029548537285554e+15');
  t('75858080763736.3923195686875407070735', '37595.949812032844887175315464', '2.017719492e+9');
  t('61365224397509015787179994388507306694584460780241.28865690785494660543707', '81301293123658261669746534003.499243431263464593', '7.54787802749622544989e+20');
  t('270363854672727763934343410366562010602905.5338331818769657245861611175566644', '39512591176531504.8444253062759596836252722', '6.842473414735460784465363e+24');
  t('80400563186512577796425698999803.72015603113776727399439321261242220051', '82411715.97645606857017909', '9.75596275770813334555033e+23');
  t('5605174880.4615394225916327092168458661610045726', '111281719.154480383488', '5e+1');
  t('938351294487473024356890313366077778.055', '761831620825.17844684059889286777704256', '1.231704314755401161926259e+24');
  t('4375833205432171.6511', '57719879600764.8001308599082918364616528592967301', '7.5e+1');
  t('6120020249.1146409009261736', '83.65271168020874178151779922934209022', '7.3159854e+7');
  t('981408760407713100873.89778485781406447480283999', '1521946172699.5527156182886049003883501937477', '6.44838022e+8');
  t('38538349280587515007335145.999', '3709516008515909506489965.34400410465003826007135', '1e+1');
  t('8584786247295696635849880972737274.787572868522059149822533', '52236266518476151488948888902.03424688095139505061892391246696480', '1.64345e+5');
  t('3244545167456459130903706130422316843570078186.1799991', '631073597340634538.6142441622182109047512019794124736639', '5.141310270512159105644094899e+27');
  t('614671823727003035129151685158800.803254728851354679804436350922835482651', '25259397281814139.98842204498364783655926245803534781552', '2.4334382046777683e+16');
  t('465095032175032244364463920017883760737017674348.0615578821783815808957174932', '70985271244306592317.30060629', '6.551993449096461883345213181e+27');
  t('15818596909712603700184340663887.31342904433178633694581999257', '489906483756732030218156.941443066315836', '3.2289013e+7');
  t('82637303002.953366803342921531', '600775891.7771684357864', '1.37e+2');
  t('33105794634277840430921189.466083185231373647776236843', '27016.157374896843919656567779131468', '1.225407232230569897537e+21');
  t('1746174517321651.5425445750157907832014633309401907098', '503.368887060226046', '3.468975858876e+12');
  t('561032973847296055911806154067031533181458226.66194627890501798507283854006810645', '49401541468260263270523284.959099', '1.1356588421593103173e+19');
  t('66477202714079751609653743916550503014019582118.757220506915612', '6057213950960906134844006024147782.55730996551298', '1.097488106781e+13');
  t('24881080667363045.331135990427524077789', '43684578354627.4', '5.69e+2');
  t('8397241126576897311689233279315465.0', '301013015400271428556468.299642866777535532281', '2.7896604787e+10');
  t('6891406846562302648530697611742760781101.62358245438762588272', '6804056434035104412507907.096124036643670', '1.012837990597822e+15');
  t('644172231943697609853434007.384520571840507418154494098557', '76809376.688905217210855165179818', '8.386635326474996732e+18');
  t('197048824145495971039233393158.8184', '399477827792536414326077.404681871354', '4.93265e+5');
  t('240624714382.13074885691260207241421406557543', '280284265.786238679146521241', '8.58e+2');
  t('582666844098553.6452820', '5018357.6087833775040937646618421748624218', '1.16107079e+8');
  t('89255722401309302794554089323005507181614902010.0360164', '231436436698118788309411.0', '3.85659767643816348378973e+23');
  t('5905426535715551276673.531597223521224487887107526671', '1.181772144', '4.997094038557361085229e+21');
  t('877284142606703781733785916605.25696944404776326332', '93965143081177.27032851', '9.336272088138158e+15');
  t('641036989529903876393831578699934346785405573.3061721652106126969327', '1532264756298183858529957963388.05423116758312043450314169', '4.18359155553895e+14');
  t('1475751036714199648730114791302586077974.61293470514499506180056202617357', '3919352924891352850.48363174980500125417055753479449812740', '3.76529254954785292521e+20');
  t('576169499544913597462200498273373.53883', '84564.711959125125', '6.813356141074644445772001868e+27');
  t('246743115959012089116630129324832275.174021327273809809', '593820460022.806618664', '4.1551804387059268308482e+23');
  t('28464638018062038796734654380509529112425242649432599258325.879718519724842794883', '3744289828084468731129445277209494961.104416633705223', '7.602146021005053236087e+21');
  t('905716746746118236746727683787565617988324760298.73294999196351744', '88687614376337460418652677.39381356020119326231825989', '1.0212437814628718333835e+22');
  t('92780707147669867441791795884.2', '156984.3045780775234015', '5.91019002804350847823795e+23');
  t('1674313388937290714206797076186815940423.184', '46851850558144683564364589233499411597.445721170123830124291600043079805', '3.5e+1');
  t('249652940819093482750237128996478577370147733399078.4905553504741465517375548620325', '79880760524920405053047706187721379625.932966107325835', '3.125320029235e+12');
  t('62834486063565808589316509620013809246483.6505641618819111952502277779007', '947710974134020649525465452708562.83736468233378', '6.6301317e+7');
  t('96193220127246778885524413.185635330457', '6380508446305644746115133.07412351734010033708155669403863', '1.5e+1');
  t('7580650115744834373189331133115580074.61211244967648672', '675252898757227563291525957118638256.336561025544290749725678047219', '1.1e+1');
  t('70560594149448343111145683612953200504794319.5383', '489010139936740146734403309.1865325747097562148583380003111', '1.44292701494035028e+17');
  t('860838595129418010646370600373108183845660387189823638.575381', '51568893255892013279628825715.3137964813074812', '1.669298177212796282705545e+25');
  t('537876061632907031173.12311', '7130054624956245.954845037201414', '7.5437e+4');
  t('82517781723258535465647176042595855354729468716.4472832952760823011730702065', '66813907098853784951329174453633547.47650', '1.235039010683e+12');
  t('5929488358592320773181960868920987073927.88388798', '78381852979368124522137795.03829502863', '7.5648739257964e+13');
  t('329474717898975874349.7680975234826011699866078', '5466714505023339377.8818320716212482595455181231170899070', '6e+1');
  t('2363937356314299614865551.44358270704619557', '1751299123897.3300202916', '1.349819299317e+12');
  t('512416652245569543.3154632560', '9776695186900.48320409293674323583534', '5.2412e+4');
  t('16034242201902131727081995909786820.01552514763268990218547200626152', '492008550.19555130788786', '3.2589356822212216387853918e+25');
  t('817169387695035335471598718443872510381117711315504.0', '9101340502043511373576061821503048.976238366099726222', '8.9785607681808786e+16');
  t('23411656442010254481460585957096192134.8256228477857107700192', '87218597453850.59945343434318080138448396299555764635', '2.68425050682544048729303e+23');
  t('50186003460954759408598176130706.024', '308474741313972.60501793934227227599', '1.62690803296190478e+17');
  t('370075324733804302055668773879119811957377288.295419956275803962503', '91199554513928468372982827400.55464528364564258008494470784781', '4.057863294466909e+15');
  t('51502495983003442300.619', '296926214208034418.849861', '1.73e+2');
  t('3583528344846306480436129439929808888424.42466', '24342028840043104277506703.77883521906683', '1.47215680681116e+14');
  t('5766326460559780759068072534.58915444563708122429160116243', '377910423.4296010523787859394382202595', '1.5258447777728362723e+19');
  t('180274339760144355990114953568506117729934023255258264716.38662967422373966237767', '27921103221453533490786036075189.336171', '6.456562204233688105355529e+24');
  t('362935691993204202680684283816730463773864450949685945479.29313112422729722', '17765287007829061039732061314035614014.55560793546', '2.0429486550555614748e+19');
  t('5616635952311116330479498514997451466685212721.0', '216925723990378429575242490394987120263.98217824390476587786', '2.5891977e+7');
  t('908867457059680459503.8000922962056', '216739363927427342.99', '4.193e+3');
  t('86572.26545176746337999355140', '99.231132400837556249532965123248969', '8.72e+2');
  t('24894966097035607043093284813225.433538462048', '93110968159.061165432883446992856156705643', '2.67368781457707722081e+20');
  t('2479035965964570524519.6142406174', '6648913817051.135854296249356259674109323937599707', '3.72848262e+8');
  t('3745718869762873333877546287564370424928436334953.657083255564322065476129', '860932496131051739412786235012610254.501753045889833751056030724146', '4.350769527919e+12');
  t('76453779215626803.6', '75340521401661.1712171521533006', '1.014e+3');
  t('47648843504876298933631392474199377619997720783511108.20686193122727474672989555446808', '178711012787755038033028893838667624361.03852302141862617142951171281458813', '2.66625110347654e+14');
  t('660863380874451536224019971035.75674411388', '840389119338967306486352.57091034135117406296679818460406630219', '7.86377e+5');
  t('747008207215667353354825194912374772.3974976636688', '134970124990204800086917459949386474.5009256065771559975848878254', '5e+0');
  t('15528691276348317242573014134083070905939781624669488405.7843550153', '6914696514331753618564652431184457.44853605868855997872776284404', '2.24575167459088877637e+21');
  t('287768310550872638548086585697753456559139335958282317587.23191916903473', '997489457262817650565646280422.0', '2.88492583511137497209733338e+26');
  t('4648066385553972249793152218642202397825903584.9258', '23661329091900485591508861791521.2517555568813324781728162296842476790', '1.96441474927334e+14');
  t('524765164027660689994.15949255815917046572441114', '3066266.72426681731954108816912', '1.71141394802547e+14');
  t('190490932740982153.48172762609584794574238007904', '12109845.09842738202500874498314434', '1.5730253458e+10');
  t('6100554503860766970820861666872611.472055983', '1308567008402862419634141539629.29561052118459376089249257', '4.662e+3');
  t('9576129306900745743833.7892390491254081', '1845747222585301.424260854904699096322141518', '5.188212e+6');
  t('5774071563125913615175508321973071301289458299543842620.57338', '47042321260907973936392257714.44456189', '1.22742063069157038893316274e+26');
  t('3944977961857323296496868253757648787.49134237786', '161835971708047011.807349291091', '2.4376397411658795871e+19');
  t('8301359297555255069323390093063.118588896655951890584115498376125163', '836906658004203459551072.206798816477132034281163728820325', '9.919098e+6');
  t('425077594123576362502584289150268.240163781070536336104180233828412726528', '5484169689661701.28490401', '7.7509927332280973e+16');
  t('295495897255430088060820608010945481278241.40136144869817695904329547089', '79380394688882221954387669405793099899.0', '3.722e+3');
  t('183402619395073781201846941968210908658.624573245303286431188281087772742282905', '21000266277924029458940.886026788274656804', '8.733347328451301e+15');
  t('2853949204886190873376484052090.81779870013388679345878271', '44422311122.0718327278676189', '6.4245851528156246354e+19');
  t('2770730951663082795845216105701650.63966150841', '1270181920.360265247', '2.181365446358433943474513e+24');
  t('4075662200552324547747960218405782969927.522410610189', '3628433916561.324019129124576837808', '1.123256560344039530464604966e+27');
  t('49611192458214171234601518170885756005842106176272867.0', '811905282079787975910861362204906.1590802515', '6.1104655374490782612e+19');
  t('7395876334328287701799216059289864.1018515952466658', '5363333777680047940098.7447523', '1.378969991594e+12');
  t('700688724998592249249818831201658251801341.3950921022294637', '5658396427970257655152065376334.341554836060179606378', '1.23831678094e+11');
  t('799266016233539362803348120261274639480099702103437917131441246827.505673476016425430577781543363', '634961892753780527822427751527985471584.78575616449583782751509400717141776085', '1.258762179832847263983575865e+27');
  t('831437805238854155543255569668615851868717701786645193132.4748090031682316436105677287221295366', '2639947692694379180890824465060584665.8020242987632232245073095483704556850', '3.14944802709433017588e+20');
  t('1524116189273822437974634217738377081.56195679213239831683660128153', '2161255145746626512270.883549', '7.05199565295795e+14');
  t('2138786264689971279545458908232294612423595232476018.32156845794513493', '4650416907207762990140488131400.47045737135703125625129735667091418747', '4.59912800801800977291e+20');
  t('1722961298797463449221516.69698043', '73140624275750030.8645347', '2.355683e+7');
  t('5664040959624684800081311993807539454829817592177057.2235463150383', '6786997722350817359678152409180046969885.0126633838152003809989320406587419206', '8.34542929191e+11');
  t('989220963875496751137020289087943190582563897580.145850849988435047070', '8155059952991074472066292680253624214753.9249470792964565', '1.21301494e+8');
  t('38853137783710316283791187819075078269.946594881991260935654924', '986547548109655355003118952199289163.051227658145928663248', '3.9e+1');
  t('725957759795556950158074990355887715830644852.3692', '8065853418690133424.167043460736655444801572724412416569376', '9.0003837425730204814302503e+25');
  t('32088858102842394073608457839795886568988330440978.0161197349938871569663004', '802989027138275657047783010125743468.533418584189051750228', '3.9961764131699e+13');
  t('28965583599454043041124815060.13686814935381262023573', '999891504871430276978600010.153133904889128835101380177144547', '2.8e+1');
  t('26515257722369694797539993349.31877021826710009422632263935', '51198070.1082927717730898641', '5.17895648532949377362e+20');
  t('133703335477582803080434536613536036.0', '296171390.6000347887663418368', '4.51439064410318834057921287e+26');
  t('823265088050079195729206154986514794.44547638157831072211790540661232523112', '92317675740438405459302612.4359720491338630549753705', '8.917740632e+9');
  t('3380342497400460184193453623777.95892579897390240281297204847745', '1570891186154165257353002912783.526647337536149313027212894692810300940', '2e+0');
  t('6247972405536355678947466357438120426251243903.9305320060436472142127292544220375959', '1533421981053460089676554550560318329452.899974413627', '4.074529e+6');
  t('2716407670765519404881587.16861', '9828142719310.0596358402888719208749454961679897423', '2.7639074323e+11');
  t('426616624010935294584.8916444383149377219598202726980', '524718745.250558453111289080764372451824305', '8.13038657132e+11');
  t('34762025677296.95231615157241284876453116024906485', '6.3050313693279', '5.513378703618e+12');
  t('7883496393743948753637.0', '69093337181057413.4987943658100904865315727583299380', '1.14099e+5');
  t('2443575067989995697.875583731051458565069', '177.0', '1.380550885870054e+16');
  t('86889593677856.9039750374636772613430798', '461810400529.41380175516855390917821473227372387516', '1.88e+2');
  t('6763186575537880733509054405276164444.98019448671532', '811682419061944827259061.0', '8.332306351237e+12');
  t('7346968501763855715188418.611109374612124128409569825492948734685', '97754082528915010.899915186175', '7.5157664e+7');
  t('954706519843885360732477138861615152918.76', '531526746461346600548.766', '1.796158944399071759e+18');
  t('60123231899910551746160055808359423727268.002501558897295570690710978', '5897514273637978770737220310907.010', '1.0194673401e+10');
  t('242584369186891559081106018472673.929658691970879223', '2292878.8900960224265317394685509427451', '1.05799032925255149091154841e+26');
  t('7657436607957.23712799884773079113828232332968444', '6851920519242.6559591019837108861376191510697', '1e+0');
  t('636988182896251041400392471091836236426.02093141289343573541676746349265851330', '88261949223276393393.8588486104256638962141', '7.217019208185183193e+18');
  t('472242785915093044775057366487742701368.71350317318224989070185482591462582546', '599479773980880534572731368903.4519997357844817584', '7.87754327e+8');
  t('842714118404631781120281372089196713491514.0768765924559932542808541', '300440190753001681848635558.937825', '2.80493137849671e+15');
  t('230138933857226101108260938066607.3390595350004713124885001', '20368980005038820671695427865.029264270447', '1.1298e+4');
  t('28032974977972472111431733075161777605007837673267547100.105118489872990033273842547296', '3463769346405392686011843397687040802555.8088954447504416', '8.093199106073372e+15');
  t('542480853839190756315422597296630730854.8883529830802438030634059165038203', '420520333529427.92', '1.290022884948625358347827e+24');
  t('92958977483214424823290447211633263954519124160937696258821804.526224744796', '59067954116139628255893409230305132.3993237', '1.573763284579624037586254009e+27');
  t('886726286787705419656067390034024611.703119880413137004958377314078', '564347800918557955939394837893373.2090763928787672557192349491967876926418', '1.571e+3');
  t('26979186938350014835642270689258925099378479.293530708503798615083', '754506777745829513461.7706380655271011747', '3.5757381820946989518503e+22');
  t('552699468651491710686388924130720.3910122665', '99386979934711111.8548615445701', '5.56108525497574e+15');
  t('44120269215918698818579.38403624566187861579530268459325', '36515322943559921588664.79468605522348664943253957511773012', '1e+0');
  t('11349498953480951846718831274527747384.36484545018827755207645801399632507427', '52205519928.7492928635101332201', '2.17400362432380357513058349e+26');
  t('85005118239428643124161807372561420182076032177.246974350642495653208', '23885994497173400650388933310888.0', '3.558784971230228e+15');
  t('66305973787758204988597760181032038.8575114968058556446750', '7257645309423526653413250493.911783964261785449956429260966', '9.136017e+6');
  t('9369183717300959788345149160871976514.61107909263601396460927307314214612', '980038506515881957475708365698703492.3101805871968126291692843635910934337', '9e+0');
  t('10149354572632995038433.4537528567', '534258.34061270606461041', '1.8997091483856596e+16');
  t('671693770003566113425226170852844663796675522210732685.86', '498500917004712084299330472530.819647727840774517124959527', '1.347427350865268161905358e+24');
  t('401805678036513527257136852046672234017669611204907.99470684480162285917282975790', '966974489640042938212190034759423804626.08250793047834745733677790052947', '4.15528726291e+11');
  t('93083829244269.1772451858164016', '5175723028143.09689348544683', '1.7e+1');
  t('94979187266222991507033401382750865856832498959623683155690.60108706', '269395570664823076489579680956903206.94987277160273418472829942348672561375', '3.52564027061878895693049e+23');
  t('639420974071508796108192604584174187.040640405366823168', '48411666416047971.0675668666593001133661424524519745955676', '1.3207993473646412199e+19');
  t('64410558621083455990660666793546886.61386888888764210', '3811004319064199133.66544519689001814058235', '1.6901203259958418e+16');
  t('436614677312657570241710697053751466703168.83091107760', '78857680289281986616558627.6243797419399919847', '5.536742593885309e+15');
  t('783443689068905357592904766.69295314871493', '432397133625363102.3568190913582983152062', '1.81186143e+9');
  t('2380500732004218579406731922828711255907.0744642', '50321820032530710.4714529850959619954053', '4.7305537249354968549456e+22');
  t('9380743439743963800617491039426820151773926736.284332259240265037', '942458341132411207957.26', '9.953483385241757908315983e+24');
  t('98911449293.910674708529245186903512060', '65584339994.7082', '1e+0');
  t('38264919095682985581229713080575.268847010852024', '474231780804633958153297418.53987', '8.0688e+4');
  t('911640346805840414733884893534538784856223741803214909.623379015', '1278906484019925720444179959750065728.07278', '7.12827996571199496e+17');
  t('93227509302643255791150709513211.07429051412383871105867012632979472', '272464.32909', '3.42164090301334409408251796e+26');
  t('29453687738968750265780182320735921581434056042297.0501371448639257538906688100', '411740116444390700740758056598633855.631285262061594240201482644211', '7.1534656358768e+13');
  t('6405058589882512176040319211.780904925185197', '43255.777847894147547205473', '1.48074058739746701742242e+23');
  t('6392527538099376.6280009290630753358584493673927', '79469509.79749974881912670128419776087279216', '8.0440002e+7');
  t('194876360343334476666226442655.3420610330925113817471077925', '383.4798436', '5.08178887614771303891880597e+26');
  t('5629120163652013964663712375140136941542940988942778284009151.0790530593768', '82876432600944658019194915249810528598.03782758387', '6.7921844449514240428659e+22');
  t('967064289756767694329723138039399781474062678.898160307', '2285960011009927546768875988017379.25173260750120', '4.23045147377e+11');
  t('97644762359043110685414120821548962899798403.3', '88046768978680627477664276383.3', '1.109010171431577e+15');
  t('93823589306198662.662410960196364078796020793010778080032', '7190.729043924165593592860417964083123225800', '1.3047854916112e+13');
  t('124993822002540896039551622435869499798.31384584143778350964543', '918650894466803131175369150.5388', '1.36062374461e+11');
  t('247179597952684644056881699035151419745147787977622.333307123164', '8853637706378684566990129083320011015746.57485817013845666026370110', '2.7918422477e+10');
  t('35366670561265100727992169442792782149933048820648717.862365009', '19586161548003313192953453.5490093480793052891245070', '1.805696867892448882697911414e+27');
  t('2318553167279443271255738463.65640483655793543633756705528313578', '7570906.43975804083154456135990494', '3.06245122130123970512e+20');
  t('42034526992594230405352674285345.92283', '169384559452757841809640750967.172046888', '2.48e+2');
  t('82881473307503531109377985048321384647956.04996568339358933118721298808', '2884065169131350517942975763.064128359836264398384937198874633', '2.8737725553013e+13');
  t('22345945033634108856160307934591254868.8012599520815125267755499', '43277957256069.212094606859', '5.16335484630581987276344e+23');
  t('4953919543758944966711.50824014751491388051', '2791413813450.9616979724', '1.774699086e+9');
  t('82505924801259036707732838324439722235194659868269154088.56378531649230', '5617309801103767035671839807356663852079.57574', '1.4687800339060367e+16');
  t('46861199121420536574478617976028636417069826676089733588147.5464727', '96129937534226155207337006200370404.361234590028223442792328187529576031', '4.87477682014887919486311e+23');
  t('41209618773916217775336133440994974543936682971912.2', '648931827637529144466628112993249.66230566939525419956734353190287896', '6.3503771919990468e+16');
  t('647370515179137634951532189057150169056356.469295768248', '85546849744977418457527492323915187.36380200015', '7.567438e+6');
  t('928576607292091712859378138341.37877', '12676.497851518013092795965656044336', '7.325182539914953583432076e+25');
  t('254888.294022576507950612233', '5.0920008028563', '5.0056e+4');
  t('651070839176054169346.5724279', '63.429092657946244688788718092558681', '1.0264545997639926435e+19');
  t('592520312.747791', '6514.3', '9.0956e+4');
  t('5997700342224962859078806717279682924264667334150407795.0', '99816575074499663527170214172.43294013907586', '6.0087218357757569914037448e+25');
  t('39651101924524.3850', '8749373.6549232712', '4.531878e+6');
  t('9274856833900596452933419588584356221454651796.2452871261522293796551', '300663402588305055742848075354366.3196822925203290195', '3.0847974026957e+13');
  t('78714814236813720890732479245415302022160114.8291970', '389999753713205692513253843.232444588996781361468806110', '2.01832984475929366e+17');
  t('6940968305815375511785.2535238589855678532454435667', '61051.86510652160649369520540215728594', '1.13689701268011483e+17');
  t('731860419012318378399432352134.787371236083803', '14949479666.87478452397916602307938077319', '4.895557807500032599e+19');
  t('80784287281774387394074508131216132508362431708.815939', '2314579171467569751616572566828.362237158270383809870299180295', '3.4902365094105954e+16');
  t('18762358230636626098456730753291785222815692676.18122730', '37729433645333441073620728338386.9138', '4.97287036084551e+14');
  t('565045537.4148860673942946036700922', '96804.4728558713344872578302915665197489073924', '5.836e+3');
  t('8731689827527071716.452542980', '329.4337388484325556483032593', '2.6505147463188004e+16');
  t('8226836207818090134162860453311885877860615442781.033712927971610385824609828082286627', '7278422088684442640153126021234.0', '1.130304907791500599e+18');
  t('17975819012854816436612499618926828518.918725803062807207677', '986297878342186.47804', '1.8225547684508229737974e+22');
  t('6883836670964966860767875159005738948461277819011199374301698098.53332887940707792650452929955035379124', '6047062259907485005834302693734782626560.852842593848652129', '1.138377012686865209066817e+24');
  t('2272595358608820919830758.63922834972891213468852166345', '5174.5868675439809386', '4.39183922655349103325e+20');
  t('67920964277002612658611530553240223932457224697.996109340917875605643', '33102913577979899256921.89063739295314655284624359146819559392', '2.051812270753826502042244e+24');
  t('655442506066280472309.90519', '924893087363.8976617', '7.08668401e+8');
  t('12971389770902249880901599275.75715358347909374147', '695047489166421262508808.0', '1.8662e+4');
  t('538049.1528880985372536672787228267264685282058', '39.99558861', '1.3452e+4');
  t('62884922762097346.31', '36217072242288.1188626329088835522438182857691393063958', '1.736e+3');
  t('36982395199435414348006362712132205654293718330757846665220.112392485889020544', '5983974636708958949032875131238532961950.3780504021215865996762648003143', '6.180239296564738713e+18');
  t('71162384450576076564185797705656879.8269824210256515890429', '10133604731208315653482573531.86972343827207', '7.022415e+6');
  t('969371600339254828265118428848.8526437790752', '76836705083969387512384032150.19929325', '1.2e+1');
  t('59102267349265458280001859275.572350247469018629081171236', '17722571444612800150078037.3806337318355958412671577879677067', '3.334e+3');
  t('635856112894203035902342801.079651859844832', '324490.6216455149878657982098', '1.959551587869416775643e+21');
  t('11496626271749455819590771908494907693082726431.564858850937', '9251420015807026480730296219.70769958426081523828', '1.242687744379377191e+18');
  t('5586266522979560347614298468558995025901991389789951.992917217389218499874627587932783644279', '580753397778733804170034088806469589183.30903077611411774313315275382', '9.618999293582e+12');
  t('9540190410107198530994381942289002665943247486643155838.240291', '24804592101319623660137984057490757015.251040810616308878755565663819444299', '3.84613880008115632e+17');
  t('2386517175768350878010637481464263337.079511947488116813634823392361372557125', '427683156753694195956490415.4245', '5.580105594e+9');
  t('6645014989837633569621.13367841392582403915619031939052', '42.96752022496360507396604681372', '1.54652047757155902274e+20');
  t('5736718330338745782318444593059.828503153803087049110965035661627823497', '94690867663573124539288115.7181749407602672732650406499995', '6.0583e+4');
  t('4577582455661230307023257272719934839494402207767.7563309778548148077215742197816423245365', '83203568465772833478959694594.023188804339444050628740258', '5.5016660223464991143e+19');
  t('56207509645732333529889283846930948361144.5674', '7776759276001405586.75485276', '7.227626270905054882675e+21');
  t('1359567720.06788441106973585', '99102.491052963404895944241759224', '1.3718e+4');
  t('583805860462774216863901838980966556.15448832198901807325512978674', '3994119096474.42425703955113908532139841', '1.46166362685102404578586e+23');
  t('693777001856849522808825.4288056084047387814349038200', '492580904875945789.91078941808189673840525212734', '1.408452e+6');
  t('95179226009086304165204368746052557.0', '36898758585168784104911349884927.354802683423', '2.579e+3');
  t('55631659696227416421238.8917851599665861984659397057623309390581', '11429813874170059.8665', '4.867241e+6');
  t('3804793895340493946116355718900597847050999258518047817035.08183207', '91199883284905744770392357893051.53931256736447977290180669367312107661', '4.1719284699679165898340333e+25');
  t('27597155368962758339704541018436645975752.3910766378386381678748632672363', '61082895292364281.987684550', '4.51798416510432891130307e+23');
  t('1968485462047071312833662.8', '3570.727131472', '5.51284203348123373825e+20');
  t('51361403908246359015248.88597428', '971321.08787760420014240431423443171403680837', '5.2877884099555748e+16');
  t('792577574914755602585060567095267520717259.77513161605865452608', '96387274244185380020295289522612884.0671674', '8.222844e+6');
  t('64001983010779865329216086506172.2243582034351104715013003', '325396290496854.3', '1.96689344285559982e+17');
  t('82641014824889602802987463507539061296137081974385.345992184578384509592', '97813001794214892676238620119685576.099164255170675133907079088055395644605', '8.44887829930369e+14');
  t('51429878275477.373607218215165471642843251860479', '269514.79886734', '1.90823949e+8');
  t('409003577538383416123.446584635', '258394.2', '1.582866711166053e+15');
  t('4017794.35779095182404974497321', '1.949858145694306536849321361887', '2.060557e+6');
  t('693158766643223341675321795349696070641685236.09576768604', '5418760772171659890772560927426239352931.7770106200193159768732895950794', '1.27918e+5');
  t('36597106767812853423107340822080103649288844136.6069722231717475', '282302474803234933159.17864', '1.29637923979664252678164779e+26');
  t('644862.8722413059444331223975795916972219742469', '62.548264929075049', '1.0309e+4');
  t('341506801170536802375565999614038064447.7297855940242974264707', '53682561275.9267247070722275919833219937579957', '6.361596634989196565630781141e+27');
  t('7908985861763007965029602421651545185761364855121.268942417', '16793989045538311416956411140892211412.665454158340901947589986540260798080564', '4.70941468421e+11');
  t('31533738859974693360072770442715853673.655466988635567099598989226105413173132', '3453971840501.94532941', '9.129703517036224974201986e+24');
  t('8888497757908937230115564677144106.14', '8675987227.523277295438878048335951393', '1.024494103646384117292616e+24');
  t('3832408485883255944563126.75', '23470507232088813361.40379333248482363899', '1.63286e+5');
  t('44412568137928885568673909551103.0', '4609303923025.73374408072', '9.635417598754190502e+18');
  t('5980199495060323094622686412.36801000662261930689900697959426', '564130464.64561936605965841544636735526264816052', '1.060073842815246558e+19');
  t('42668844022510160312097768715558145019410562816214802678.286681256123301472767371805315', '5845762170575892760204767094999936.0', '7.299107075768472016233e+21');
  t('153580616596186472068747513.38940142804308393077430419129275642755', '2496443776126.2457333179815663759811866', '6.1519757851105e+13');
  t('50386864955601032867872486555643101.85213563998463737619891005063733838076', '1624371436509170901416990548021.667918309610622619078595', '3.1019e+4');
  t('12152881302772810116039892499942.008', '656950854431037026.69687990251623343210969', '1.8498920004142e+13');
  t('93760332495878064292466041.71', '233540814.5857575', '4.01473004460420527e+17');
  t('910859566602409178144.2', '876677205.717494987924045167903047408551946446', '1.038990817443e+12');
  t('4025.1487051565297843490074303315163578020', '66.16130299', '6e+1');
  t('6375404836829202.7333829751919053178915219731553', '5229479132674344.448094528210294672', '1e+0');
  t('8400233618968760824801844.3581979200830', '4130786943730816203456.058913094982907', '2.033e+3');
  t('796421.11453016934151355', '343986.56558310355987', '2e+0');
  t('6639929678119504878947.25', '96859440.4053734619746358', '6.8552220107098e+13');
  t('557629736662030.50806408951252974', '238395.20', '2.339098004e+9');
  t('792602563830327630617720071679475686474354492993017.9926091441078957', '125147857962710073161102.87606826510', '6.333329045603776992930610624e+27');
  t('4627023788931064878124628746104079817244198024917313366166138422.1570808733600', '815738692378904775832725069924927990957.397915671980498734685278430738', '5.672188694933015991094016e+24');
  t('9439333403176876890363560254484700606.86', '63082293493230549385786879556845.712215613078084576', '1.49635e+5');
  t('2733443019935446615635364481.104981558510317617330', '331510535512988.315380', '8.245418251053e+12');
  t('37902328487171282033743961194864143625182011.1662801', '110983332772099550179781835746.3640329334259423125968073885804169927149', '3.41513698863255e+14');
  t('9496321.22914701121676628', '39.3311222595505274959486106', '2.41445e+5');
  t('835638348474609789515956933.06717723489839192204', '8325443822870684996.48184175349500213896473649078400944468', '1.00371627e+8');
  t('932160263119977217772090188274.21279235201503589269039635889539291883', '2835899214843529946087133.11283853499855064716', '3.287e+5');
  t('450264866.6275081527659', '87.79963962373938236194326027135334508080', '5.128322e+6');
  t('1799024761260895898937518585982847408126649350012958291691728.553452', '7737306728355044167456810268341347.4742460461719014700987149967816', '2.32513046777372569198422497e+26');
  t('365858028137169430349738214047744690765.600147965741196260380082202776', '36297751677518885339399350.6417377299782620546077350609637930626104', '1.0079357845289e+13');
  t('422939609684291907.47807319547111869154773225694', '5.669087579160461785923021751469004817997', '7.4604529173092305e+16');
  t('336225964209286251534670898409176.7999702692719126784263708', '233633.866367', '1.43911483997414615081599198e+27');
  t('8475749899217974687795958718675121219516.181607683214193278712483174162967696', '2392113753076465.2733785800390260335562217279', '3.543205204316653804720413e+24');
  t('648064533277152731636694149741417.0', '478432733699912.0246299253982352469883971883298', '1.354557260882653312e+18');
  t('75575916009381126069705419.640880259918282', '23300005784058057158257.386529481437978642261113085121', '3.243e+3');
  t('774673439062933591391270466801445534270076.7386165104152570', '685455317640794938980.76976768652859796462690616604', '1.130158916454554947282e+21');
  t('732472474211574805287505655.9188080', '422214783125578470083787953.285088274329', '1e+0');
  t('3323950381639456571479885881658157095.140', '458742653.10763637480673', '7.24578444825697644652746652e+27');
  t('77221335.57381020778982003856627720864096553', '629762.10776099206641600699933138667050138', '1.22e+2');
  t('977287057364828231831.005384213880964476071738838783', '441245095952.1728411040920', '2.214839476e+9');
  t('4656164015778698194.7427643', '34163427.003143749419309395853876705', '1.36290894217e+11');
  t('587079066888787270602134813353500.9315836371295975970760048758012403829473', '1033927619199386247.60425201715751690347050', '5.6781447365086e+14');
  t('6504820824.6679', '244533.439467270497421', '2.66e+4');
  t('594242888128145797482002587731347748403304.38672682292524749769', '5436414927778610.7', '1.09307861158964389546037039e+26');
  t('989.656128573591134745696183496715069', '34.73477175628767959355518713810215373319', '2.8e+1');
  t('120369063196541563112456357675209274396896134191.00428225945', '79264329028251723320.1774705279', '1.518577961514556171965172451e+27');
  t('58414822992025969288274937174517262951433342166897791443604.71087680019355101373372382877339765', '54259093314317983827744671065849.739792759423736052896955777029385081393', '1.076590474036014978745015363e+27');
  t('1893572691390077779880.8798', '63917.098849', '2.9625448048941026e+16');
  t('117105915719721336986102833649470173042927.6845904617613922858074108509811', '333773878999877823.520844744800865894910471122800686263922', '3.50854045471198191330232e+23');
  t('26488378327897381716452599.82853', '75692651986696063.3213353397', '3.49946495e+8');
  t('20674501736171706714386659080.33987650601226792768649218', '37224374605608504973059.66319793943848478493689438465572', '5.55402e+5');
  t('488668888954306581773387452820386.50275367736471579901880632943792210263', '424971412.314919369846853566543', '1.149886497758548169126868e+24');
  t('9414299273169503353740070805208412425001376125309.6494529706749228', '649198730792783830398295123038.231006511305116008163545769339', '1.4501413552785319175e+19');
  t('8837663816566420476673692992828192752926654623.3820298251338', '1000505072899959919210115.68884512320089', '8.83320240541158631281e+21');
  t('62640550960750033485.161416496332923818538', '551009212582214658.0850309331075223732119860256757512611', '1.13e+2');
  t('18279447400606728962079824580221915709.20093', '44249934066501551647833671723820325.573014982949332765767790368980', '4.13e+2');
  t('776261796756651767293668987691727663279875601087615054.70838217536832729780', '618413129352061650023022110189682.959376671530710294265584778255638', '1.255247923940384376935e+21');
  t('15730379995642783522033341238016121720018756579287469.53566562634607645106952749389445433683', '68301163568490831992380058.665860', '2.30309107104284118981937299e+26');
  t('889734378202484475581878128819183811697078164443.14565084281602', '68395823891803288251380393538883565945.26547129989242737', '1.3008606777e+10');
  t('364315008770017468358113939742493787326171.7855594', '799780067786791936.647', '4.5551899008708202772452e+23');
  t('18748989359411410187093728553272118179776164624.79288559651828723940141507770090507', '950112582825403040391796097478.6930538719679703915366', '1.973343969791084e+16');
  t('1171084325875.4446225348322', '90.0172338618478200509825', '1.3009556899e+10');
  t('2065250102941880307969219804513555.095062', '1797856218617859507488766535234.4044247712288678619559217322395206786988', '1.148e+3');
  t('548766408492366309880682898409.8530984273908359606505728637337989455659', '367458008.139188513732158501695423998857', '1.493412570517446537187e+21');
  t('444677165645723563306089367825908182929191.08964559115323804585', '2370949907187948235305802.36208925477214748336986668759410', '1.87552324196140612e+17');
  t('46285062301054914436645816994588244411429108375.538183215973994207585288819216075831048', '136463860344306334886102425.40085747458', '3.39174505134729324576e+20');
  t('4885123264349473011404996618821001197721833035124.6', '64344104993632648195924141700927339579.1127718859046238322211340848505609', '7.5921846528e+10');
  t('8527098343430191438975192446424493491958946.0', '27112973650638679113124785110073327.7088253327631045907703479548900582037', '3.14502512e+8');
  t('843048576064275489790467362477723997.6951146198517759929178177', '63589299487542886020184435860209963.6059875060655921', '1.3e+1');
  t('388979443725929873035622799.131196516484091384', '55249117649795546113.294732338780674626272131484691595874994', '7.040464e+6');
  t('116736702672372229726597847132478823564405740562059.50007104141245180', '40948232623253264853612392403.64895458796549183668952040', '2.850836170303501235954e+21');
  t('2492647031287379964435460781.0000322662479887755705529336', '55050637611724888607.0', '4.5279167e+7');
  t('16992122752687446745002805212790371152631729.5813386522994341164157008', '968361709437805282602217.33760138', '1.754728898001599001e+19');
  t('334460218373859061266920082.83592158959030', '130034558556902541912194.7510446423718827904254408178', '2.572e+3');
  t('780518698732439267132572446317593359618462.56173280268', '27854048834290010065155.5046591169557067059585', '2.8021732257881797994e+19');
  t('6372593567849541999494129145.5970', '18.2439383764900306', '3.49299226753668283155161926e+26');
  t('964255508932309410212037662823733721301170254666458.2889563588631864504513496180233497', '684763819810975862069683055938450341008.0093475043424162143679799949291', '1.408157792563e+12');
  t('4945973223760108770860653167100409478716899180270137669545.8204083501846722785429534187', '54143998752657849905388022730004561.249426920186016601478396158204493069833', '9.1348502838780782906863e+22');
  t('95412058468584656926318451839723.08644800648533', '40141416271939471871836929326.10509090738420761083011', '2.376e+3');
  t('131745880157305.8413059469987124356254993429844336801247', '32721632078350.5104514632914633356280387859', '4e+0');
  t('5724677863015063.1981069184019357756477', '544272444398393.1366742806928', '1e+1');
  t('879850028955366298821171490664419601687932576187733.92426359314744420046638752451714051', '4921328677966596268308514832403356554968.63970470980141334', '1.7878302518e+11');
  t('91458700440845030747247649.09484', '380498.9084975880475582880', '2.40365211038246066886e+20');
  t('5105248384156310477483847709.27193077830735334327510', '762124353200103274312.538621396670007835495536810190956950', '6.698707e+6');
  t('70912319558160913584743566839718563110943976.9286007329910', '9121926192939404916619411198828855030.97375536513607418710635520444122127', '7.773831e+6');
  t('48260033607911589895643426429677.399378342869093', '8866717097223287064.85285269790401564636952536203808655561', '5.442829976274e+12');
  t('4241534910579192804542571508724905003322926.70406', '3735337150041905838584017370718997540631.7454018', '1.135e+3');
  t('8208823070773994924478395637634.2047014111937409226484', '974282901837711.772967933758356581452408', '8.425502546837627e+15');
  t('28366693965832816989363948708682028.265866735838052407917380', '581752801.4298', '4.8760734621500263733226331e+25');
  t('31072548776170976987968.042971306125685670133932859398262', '325478.0851041', '9.5467406864682824e+16');
  t('75548981188587472919633956.992631367600938606851842', '2540521549405937737419.0143498', '2.9737e+4');
  t('697859488464358546038375437817655711295586979071525.8503476333610581722438767283', '5731639709806250101606802527771.4121625967025155313', '1.21755644771319495558e+20');
  t('351122538216878516792386564259.049', '54106303632724959138497353.0091585141717', '6.489e+3');
  t('8809597211168905637.098652129530294915846', '8983599481818.979459720310660682972192953163', '9.80631e+5');
  t('1728708563415941940086203.794324', '1071376602720044.852562', '1.613539589e+9');
  t('22806891597004711966077.699013', '479325120881635355753.7770006339554837609918893911085676', '4.7e+1');
  t('638577089423173124033878879944099159959139409.3816935781732076301616575373525629225', '8483818736750661487041699402167.060460488588264', '7.5270006259911e+13');
  t('9004807819814488719168159771153631523999067.830302', '87591023120596495214689153.3867302495777428524082705440214', '1.02805144853902991e+17');
  t('5085912487300437681400422.9694951662826312556', '63911858290.3', '7.9576977158123e+13');
  t('9338356978160104295315532990932090424.1932761', '26156833135415571674.5726839', '3.57014051732288935e+17');
  t('44325675592262736297656618986234547463666335781851325840056.02135667526620128595', '8133263073223001480434454185962150.97214900757', '5.449925225976690217408235e+24');
  t('2624533365963783630845531.55763635971275746967672', '334239053600512.95360082641561987173', '7.852264233e+9');
  t('99212442272871592262065490646614558903179938078409227.085304129731783165851355', '62660147219089824365023379901717.84', '1.583341991297554304794e+21');
  t('316892334348803283300740.963014662126978804764731714335', '49.82523850250185751', '6.360076617252745871987e+21');
  t('30692950229334301031331672911451292920211558.80975236148397198595877', '26066207311649700327.5885959916305', '1.1774996593239240779141e+24');
  t('3777678164868474.819138632271194', '68967.86576074036902416', '5.4774468126e+10');
  t('51065608944378517112134329010831340183.2941187', '366496307677949056630789.1', '1.39334579570311e+14');
  t('45885182901134873.637095168246291402450697794227338', '35256.599914251808371074147623002262229771023', '1.301463641211e+12');
  t('359612826822443561101955855534067069807.8857144965820735', '305070573641160183759072.8979984730616749534', '1.17878569057086e+15');
  t('411829970896188741315395475047815.83068409829074481092942913141131', '76734534776378.3347704319434677008067878567', '5.366944259144253024e+18');
  t('231951931926.3774381970401', '84917559.626574267921654043428852295986', '2.731e+3');
  t('8360204881039968772919143230381.81930437859', '8967686070600437.002746464634054128', '9.32258869815701e+14');
  t('74507019.91881031337041765338828759850849179', '34.3218212574383046476961210', '2.170835e+6');
  t('258149347393794828261579665192468197748.66486445752482955367874', '435089547505456594.84815787', '5.93324635983256518267e+20');
  t('2843079409804570572108013.3', '70.9451783461957', '4.0074314788963037230276e+22');
  t('1377128112032650878841034583088679260997985.42416876080194', '21397435384848978.893113547162', '6.4359493895598485100778808e+25');
  t('218432319644457421305162.401835860986944152509049932', '407214205.1937655338', '5.36406433907482e+14');
  t('907985.6567558033094578292300927378817867', '93850.446607385442111685', '9e+0');
  t('5948611106662732283903895862826.507', '992167115515033581789318610.758370667106258628206501856092130', '5.995e+3');
  t('5308731349023318985589323817683459513.9685216237281288089437997488999877', '46629198534935.894162842457218535816350781199264', '1.13849937717584178742458e+23');
  t('979426870038381078377985421570.027996766908635541576250', '937790990997853111332269.3559926248560', '1.044397e+6');
  t('5202895046879436882836975648603160535.289156272206444', '1322515986198931643341494669903.78544330', '3.934088e+6');
  t('432734050215788.8683282', '62325116564.664654092300350081811661943', '6.943e+3');
  t('31502315244297516163490365506938780417796910.0', '1384815106987231572431.553817608002', '2.2748390803472060435691e+22');
  t('634371348736639116832295001776.65500230', '4412275558423696692053708.03689304780821978396387892', '1.43774e+5');
  t('93386857934649730106088239.304114842548213194199071181', '3618484641170703172128928.424', '2.5e+1');
  t('2918650142879345661011245097537.07', '6311171332659.6451', '4.62457757686855912e+17');
  t('524425924762470946176035890480694342268414828.775323811936309625549', '727347521521977465470337542540286018.635', '7.21011496e+8');
  t('5629534427223902812688429320.6057590567538443', '6795110015243353401.67557455', '8.28468474e+8');
  t('374152685740399489053197877871200862.877211010889052643353', '507242438266770936593853860924986.37868214297472', '7.37e+2');
  t('20569633853349023540430901730460194655391536018.315582825834', '5964675384634528421.8746674638', '3.448575576524753307873079131e+27');
  t('74122414922133904122126378667358459096.36235455752218973737795959', '4875294206278295872.8245110651979384776003117201', '1.520368039054560036e+19');
  t('5040344467746021934407447354622712.557653653723784664260912', '52478595.81171317662788340674747770487', '9.6045719017143013251272835e+25');
  t('168256655361066610448560474611231502419180046848009680959203.7', '6231517121979307187693733815433845482.8419146079106875868892148695199525764823', '2.7000913592551200132228e+22');
  t('989604660969633182585321729130944898270146.5223', '35391258916806180870606672993.0244502', '2.7961838353811e+13');
  t('497762151474232632913608675861135072185.54658079820981848050202132048389', '1858392513545639894748695.15108751606616254891895985232302924', '2.67845542772096e+14');
  t('61908209351270.16475164', '973.19441720006446301081', '6.3613403711e+10');
  t('6471635686464059575788503054149569453179426343.1840496281268409794108671', '8808614265074625092460794.5608585', '7.34693958858378159572e+20');
  t('68482047134678499374073535307346761265849781283137392497.1426771216592749255872243439847190980', '76453360579112893304983135557.601550292802095092097868537948763', '8.95736258235688833414571268e+26');
  t('943569281336244910946766867838666154.5290089569130230851', '4417550502.33344', '2.13595584439347649878052438e+26');
  t('9797177555993974057849706470.1450943513242155902867435762', '5167758209477555255.082641754247006012', '1.895827389e+9');
  t('39.3606089079664786581920', '3.69170', '1e+1');
  t('30577848496139497656061740899501094743941244.8500151877385571', '90787177408984109701540649882.8433289859919', '3.36808009333635e+14');
  t('89370053571336534679011.817884735230368562774518835', '376467.60756575521400', '2.37391084319855681e+17');
  t('1575163396854211836236965797487708259472166210952250022116758.62583877509', '26040484517242182429818575594085333217.3388246107023856153521568481', '6.0489020310326757286152e+22');
  t('696608122938281102539263073547.95314717108', '5679391023780094036.669911487', '1.22655425559e+11');
  t('5436034939939629823888268543299451017440.454250887392220959809738559154352', '2502779784018130815116190.65515950836586422899148740781515', '2.171998900843067e+15');
  t('160306956090198788059693348858808753931552942000535108918676.21897297186109016442739093072891', '927928162504937776458216727283956.323300517000169048257614', '1.72757938133325862905695084e+26');
  t('293797359376817008144668384802447572.3764386107124', '501128527366910.73199791644834685007735642783398844', '5.86271471952559015306e+20');
  t('24831324193025226341.0', '64558925.42312', '3.84630382712e+11');
  t('533485089686200350775137697402200865376695282543269147.23533326145204295', '460565610701955988893247824.9106050912860273813175768466107', '1.158325930746558620816794039e+27');
  t('58821629618378611015847259936060891032758903.6971980453491017', '428400877719881294180.6529908', '1.37305109950872558010184e+23');
  t('20931473116681535831217.0', '414842228106.08168672', '5.0456466816e+10');
  t('629230897716929482.32960452558', '8.0690242408233115348099494', '7.7981039458709916e+16');
  t('7655055639165238511317463726763855304374382237588.050610015689216089892249218479914', '92749486699664993536480.9751', '8.2534749372288312468063535e+25');
  t('31844028771920351958374345661002220574354837502580133079626.7532363953718116700821093000116510928', '136974103400501161232583400814613088101.7945120443675821', '2.32482111445628494888e+20');
  t('41839964248999070703454850042037890.239112587124232561561339543508351067127', '273196418511407991438383689.4431498102789532280', '1.53149753e+8');
  t('9200633792893293261278693120806370309.611089663058207949587461558760498686458', '348451403790040025950163944474.46371619282006921462242273336372713272', '2.6404352e+7');
  t('45451838299322091484332414760072649150758790938341.7676', '800335918595291521630791346.263509434996689116875', '5.6790951453355764021581e+22');
  t('73216481323022991342477901716008097.0525124284772470133466660736098811444468', '173864275.399067094399881265024', '4.21112854581372211457759023e+26');
  t('61835797619342818029306328618170752667444632.53794473092725974985', '8502821305914898321953677.8156065455872895240798723062156098951', '7.272385881651704826e+18');
  t('773387774539406095197372040503475159809686163.5635669715466074720894926625029663', '8054330790871718934724555870937.440717932113229', '9.602135728221e+13');
  t('83602318215136721787.5331349762534991826319306', '0.25516', '3.27646646085345358941e+20');
  t('896023331779796818654049263822.897505196222086420708451', '307.2155960716622434192', '2.916594545450052966656343157e+27');
  t('1836661677021546482706.353181215646635', '5950287956751398.73169169424737311297', '3.08667e+5');
  t('50094830147435801921021467357673.706648', '6398487.5682678664286990264190048622', '7.829167379471359287854063e+24');
  t('86245848859.82299516945749155', '972004588.3290128504990028276356531', '8.8e+1');
  t('93409301879706870795110440786716125538.475952535', '54688335233161988953263.7537315238534047949773', '1.70802971934434e+15');
  t('17450536470.967537888', '54899.8922267571045', '3.17861e+5');
  t('91257959785425622.0298785306198280471348361', '197954540027.5855929991794442334851024397384', '4.61004e+5');
  t('4202536605240358069756648239541895992276639753295.934857', '531278006638819157953.2397208386366398106034102580971908793480', '7.910240124239483639347289198e+27');
  t('18407965143845580576350416597248667206215366170.844708780301969529007119404728708', '92629597251971014171828598932052548.39166289650913864806229648401', '1.98726602403e+11');
  t('96264329543942208255742727502.3545', '34432528228141249488567451.918', '2.795e+3');
  t('754446579994069814.6522571348308', '628724229431161095.83609398509662303272933115383801268113', '1e+0');
  t('170574055055373483852079.5', '57.2143294972512360824', '2.981317032887161957198e+21');
  t('48961691322516926824017033399929409897137214.761039821711860575197515216987090091', '505516504973477773772390953529.164514275675936866296111582', '9.6854782862303e+13');
  t('92187073172881502954948670373537813.47812852532158564268343019402', '42642313665864035462857.4236383474969667618', '2.161868464625e+12');
  t('114324509096175781545191660.5076906930294633074814383842', '44293132129875875.7446847878100495', '2.581088841e+9');
  t('69817005725578817678416821739798701307975.18318091450744390761689273', '1426798825565743784094673.939', '4.8932620685257076e+16');
  t('48943208538423511113953697075456400596606226853311.0', '861168984548243515809623268132650.91745856510741750851964130', '5.6833454776704937e+16');
  t('741387728060971108963531137.0913114958122720632615583366', '2618492562414160562570833.86254242276656726923358307595', '2.83e+2');
  t('7218068503304897168145406982527870918.6303914185092452486930342230876442', '75168674387793596406974416591426.1496078649831668234746598', '9.6024e+4');
  t('271036477517035033975043752870456515584.5993738217652679853953574', '5259877412151.7785335242', '5.1529048355930396839766319e+25');
  t('2228272676082608727491.34203168554193960650', '5324210728657560.20277789418656976201819659642400528', '4.18516e+5');
  t('363830937077844409.4764440905646484992434153538', '957279656569.785987882004', '3.80067e+5');
  t('81051533892191039560015819249521712454183090611.0798349549460795452793', '3931220250450309009331206243668905152.0', '2.0617398346e+10');
  t('1952060075559595864752523843866665624395383613.6272243537047174177377211324946', '984070219762854168973311364766521387.2641157106071', '1.983659332e+9');
  t('490499388437329.21533448493772433971', '1119.1328994110799543709582930', '4.38285201601e+11');
  t('81956558749460069678928850000725724774712599125965354758.54', '76370361609074674458760711950916471.992', '1.073146139715562349967e+21');
  t('5863793442974415.80153236603595931237654864826109791470', '3984146318899987.66919425100257', '1e+0');
  t('85809301.08220025655578', '48968276.0', '1e+0');
  t('35396154886841444190999037918091202805035781232270.515818099015', '9218467546648761517485.27813851458', '3.839700547593639511962885085e+27');
  t('81873496771173427028241388412904762756.91675153501842092997101', '574161444082.2118860476463958415', '1.42596647014581299076400842e+26');
  t('2876299592495519957824718596573.11367933890816118525952626742', '3945333.501453574', '7.29038392175416528401649e+23');
  t('8465011800924324937014295668646.6097338156509015', '8734411241027015785811.30533685609560792834974319673338', '9.69156542e+8');
  t('2715808428862800072950042020375441831566006820665941759518285167542.503732228', '2427333921802245216654971196321179764345.0960557', '1.118844178985629016048576325e+27');
  t('9648464517206942465009407066172161553314248003911206718659.479959349993937016183770868536261811', '7446375787730027060043405327322.4062678285715815821817', '1.295726242168098525728935341e+27');
  t('3051022926532997299164629581742013507245.25609871536501059924061465912869311', '22560867095894060118140354.396077354652863', '1.35235180171256e+14');
  t('86597231946028939866529694.08292297341417', '52556536560235760169928464.4371111293', '1e+0');
  t('64155849083282775727106565564.09683837323626863653486184704735686', '887755006473.17981', '7.2267515942441496e+16');
  t('458238468121892050492777440806399723.51029', '20401446313054.48340548535', '2.2461077567264154508575e+22');
  t('15697792352949219.327716733457', '18643984669.488905958968185211597707771110', '8.41976e+5');
  t('49356713849410104382776046.29609499', '9600.3320897019953', '5.141146513291311593276e+21');
  t('237628674750215981635095192318367418899899327519.3417067', '99870843925964094624234622.3649438352534', '2.379359835252559207898e+21');
  t('533371823115763843951555557624614062487903.507338370987667117', '1124528302131838269150637007598757.3828654998', '4.74307158e+8');
  t('692998394350964907084.1794689035422872582254093', '106.08742097871375644', '6.532333314898980766e+18');
  t('563817454550622204720369034118279206692924648686972046.9250246162380168326834950', '94212526330251570476582155947131.99955724099948672', '5.984527498755554008774e+21');
  t('60113394247283310838484270771514878207983.766785778804191813', '73579044220522.9248281034189038321239166369841042528520', '8.16990691902957231989970303e+26');
  t('2195460317024982007027.520694010929929', '7.906626405205089525032703861357', '2.77673460779640073159e+20');
  t('63420086214693422141119967131969872.883784598507', '351245077587626195806474.41244888248299459326', '1.80557935929e+11');
  t('11430366298089988657644762834809212.056078289510945282811181517544682567', '432162711472718490846619825.082421', '2.6449219e+7');
  t('119511160387298190586363781744507297703146760717.676834782610199244791291020733453846108', '325012118935394438939814.8416046143', '3.67712935686113572600204e+23');
  t('4819163049355593489964336799.90', '712890140928620741222880104.17672760761076902033211671870619', '6e+0');
  t('5429574271548987853127824844129.59540157053276302039437', '3550063252188102650232708.2346262119937035822658588851471', '1.52943e+6');
  t('17459526968945296716557475697545.883680546567004102', '764651567.959111107995775862448235699541204', '2.2833310883734335714304e+22');
  t('486451658916108573050605230610899764528305498016322.72928533465528132043305389892991', '89977301967353766174050060632537.94765', '5.406381923883498768e+18');
  t('9812801303507913382807703084162416821734530282134921.9389935751232203', '5766199104262958232513611700618022806735.3529287', '1.701779825163e+12');
  t('268738770237064607361.26199', '386334685121563.152418284303359154345157759918872503', '6.95611e+5');
  t('8836033937577112251809.81970179529687429478', '3050412231073542478732.44142275907', '2e+0');
  t('424408.092849042', '37661.2', '1.1e+1');
  t('140332624677141933211867464082417944107641117198278.66800176095', '82870716315480526319164852766.84431933315300', '1.693392200725159300691e+21');
  t('164162963944967196002364161509895429188439760997063518.96915565722509113659735125371883836', '26081221503935511559836204140616618.1198911534840439', '6.294297371010629848e+18');
  t('35209175801549132643285834701.90066452379', '20144.22592000666906224996338800214642256446', '1.747854493956026685231981e+24');
  t('4300524770734216335082744915088556789.0', '5690996406204412719187405509.3', '7.55671672e+8');
  t('401961353249848705352564164795538451994065395934.3999784608165760770619779275568', '7302224058177448742737694008979.59300454740986360367730982838296', '5.5046428327505146e+16');
  t('86378272191344155490139082190444263045830.901712616968968672384456975', '71470631877176403770470397534526521.7034218557546741752055279481973222907', '1.208584e+6');
  t('51325968783742120977676085084258157993302721461013640409.17703', '5698175068781056014611238017.1194049', '9.007439779262816774136069756e+27');
  t('7560786.390496127', '5.5345', '1.366119e+6');
  t('138863086.9281', '74389606.521329767', '1e+0');
  t('931310492502983715448716195108143147606116526583237141420.7719854862045544791366693525170', '5055800853185777459170883871225565614.8233515616544829966', '1.84206324486879929034e+20');
  t('40573829115419050101423263510.8064493689271314', '9529051001967140863315330424.8962235735', '4e+0');
  t('2642474773370539644573.846027356885139196339313623032333412763', '6.0', '4.40412462228423274095e+20');
  t('151070187965.3707401832235214', '23.48357234618168833', '6.43301563e+9');
  t('9300538177433446547188.9280117743211754518', '4502329260313.22408330534712358734374683537379365193', '2.065717018e+9');
  t('215042801078074574976683040.0', '8266001448451.63921174', '2.6015335518523e+13');
  t('764803224894813157446505921175345980083.74546549076', '4378198618054804435977069972433487.673592659283417335278057539', '1.74684e+5');
  t('824486952023835299294807662355902426682974.083786', '35907690843579614909051.5023', '2.2961291373913442058e+19');
  t('54903489124748598323529.793968669069834977444568670', '65417.285358163468116434179564', '8.39281068056382655e+17');
  t('80944338663865565814713852408.38', '61769163293759016580625.660811509', '1.310432e+6');
  t('1926230834079012299263182518652.55627834234476512950081618', '923834854177542946228068.409501673406972130568004454914862958911', '2.085038e+6');
  t('19618101600841856694.1727651445711627002129', '17841521302801279927.83288787042208976848180388359388', '1e+0');
  t('584039865361652690686302377225386639.13854279100771071', '8154682570892629793.822030620613363177947698815281', '7.1620183898552703e+16');
  t('459533853470889732705547695280332999264443760814905.106260890', '479639882096629005830784.930033387912876507068482200988', '9.58080990809499279833140285e+26');
  t('10087317799834.03718184933635283321820511195', '92.016867317151849226040080059225677462', '1.09624660064e+11');
  t('131465139134685765648136766.340366550389254321932', '16146700648.442256378', '8.14191964024358e+15');
  t('32541564719436719559490281443785.43108810661285365036228048082658', '688405969942215.02988332810975631041282950252261', '4.7270892671323385e+16');
  t('122460857129116448887315603312538889321.548018642648817', '2268641736150702117171543104584784335.673939746559575908887159', '5.3e+1');
  t('367417332468652914812097284826107934511645.43', '91736033054162029137.6427263493947014171944448714330324', '4.005158281170992158407e+21');
  t('971760611992491925.54338202598020', '986.84442480386397178800071536640447556', '9.8471510561113e+14');
  t('340490588.50764491734941885019470906711786375', '4263241.750886902445', '7.9e+1');
  t('226183388539294343586586303110168459692954908764826547.0', '86745014870815815830297985627.0001805530675510236607842628717', '2.607451147205816873750305e+24');
  t('14057232044306402364619170284589941.23187749922579299559968580264914959', '4840969536436335462195957.592597022426007981189796', '2.903805103e+9');
  t('552189894.0', '7087707.765706071403321702171562408048111681', '7.7e+1');
  t('24276504561422192863854991.92374470004020899881390669869015', '8751757082211452020.0897771876810067', '2.7739e+6');
  t('1512721932254306233889.273637582', '17556541.11552312423127636', '8.6162867862211e+13');
  t('557096761753924832177147529824169573242356689080347232345.79678', '3736514959036238790014270880270700467035.3962774693798803', '1.4909528474030707e+17');
  t('3323405336377158232197294287.82086456781421866728554', '8356533063151.4694342568938725440957210113170722575814', '3.97701452415939e+14');
  t('220640196995143567374001122016.110907295267401095453348683', '37.174992158248244086099029277142338739811', '5.935178037319068276595164618e+27');
  t('50390659887149153421298.0', '1850974969302907.304813168340340692703000933618277725', '2.7223847e+7');
  t('9064774049223140371550605423344.893477', '968198891361906782353832605.0896311034634292118142013277497', '9.362e+3');
  t('87609117962016584220698707830.9803704377612089423639053', '28446132839167858.16528005077336', '3.079825242234e+12');
  t('4113765531.6375234789707476488597819636052834', '5119.0738535118570308085279254669345', '8.03615e+5');
  t('85919371885787677473760061397312.9347654085343258734742087278', '1393586.0', '6.1653440753414340753825068e+25');
  t('580820148874038769205.8737772', '57176552037.92462632955934645851968194010191400757', '1.0158362618e+10');
  t('34416747793390562233441330.652505492669604433038', '2.9006372989233846373120025', '1.1865236583065679470059039e+25');
  t('611675614481655117500968303318910213038853032.170527534518160799027854811815', '5747036287202707371143079617529.34904701751831118809786986512241503204', '1.06433226434242e+14');
  t('2538519921671621.6', '12588548518.0637153942747619217819071653445', '2.01653e+5');
  t('8169713234307006618070378734.4366051506965198817890150721', '8022882.413370', '1.018301504792381787747e+21');
  t('86201439630585044365038308732.69241', '174154.70', '4.94970503986312424327556e+23');
  t('9703307875836954050302915770653.5006178515495594361060870543', '80541.7255288268870679439438092474', '1.20475540002728390319806364e+26');
  t('27414798.42261007811991881558112422474950548', '5.001007587072768974970347651814551', '5.481854e+6');
  t('35695497073543915770986412.8440883', '784117886046309.1561991312', '4.5523125678e+10');
  t('87958233319063300964559411135476924335417736205751272475.0', '5722695385403642769976512049652073.08122872578060932', '1.5370070813730597161003e+22');
  t('28870470584885559979180367060997793251.9458770229981608111026979888901', '723588591052430584652204831251120.12838074602677268884092', '3.9899e+4');
  t('484933748610956934.47700527370', '12981.212', '3.7356584932975e+13');
  t('8126504568986305331935055713958335.5671492266807229266951803', '519782549077776669059.77090737243041411560882', '1.5634431327878e+13');
  t('55751811791259483647823990951483.0', '908126452022542960697896.5916051381392790468202244403', '6.1392124e+7');
  t('1948695236331460833964919579913203571942453373.2777627338870', '9782044122946332936568261842392755201644.8393044734693675219', '1.99211e+5');
  t('62727055281506910370273437210483.8857', '567745.7015834541805298558646610754209483242786', '1.10484421293829070989243895e+26');
  t('5091959395871698003267111313478.3930282513482774', '1853117282823.84571', '2.747780425485207302e+18');
  t('545938243671057478539883158.1701797', '63484705985497792.1901323771809622868025', '8.599523856e+9');
  t('62185571391527882074520530900922983055063438.3', '8132189321579975808060040833041132.5054769062768231989', '7.646842557e+9');
  t('14189533280272285522181426322083264.813727', '4495620394504365095179605.47822357956638761503516116594119924', '3.156301474e+9');
  t('3344.8457665459740400719', '404.52834953043956863339867078569499285', '8e+0');
  t('9001461502259033.96344026870345', '86427682285.2024330259102465418590937015910', '1.0415e+5');
  t('9723935868793796935386841714805114356.6682737', '10657456542385.647512973222742463237992912427340265', '9.12406804580515409844635e+23');
  t('147228461297369670552030722260657371.0', '56606316550133403276386769525380.3', '2.6e+3');
  t('338613476612936820.6080787952655111841989226343115083', '332.2219230446732547', '1.019238807330015e+15');
  t('416684342300044414140161801.40782766874545811239465000', '19945435058137032.227867316737888305805966836804697773', '2.0891213507e+10');
  t('417315060548680214158514722481522252838542626059.36278712651463579339320939901240848', '829914977763197458583245996203652116.8848666032180229404696', '5.02840738786e+11');
  t('6002019663528594333452543368414083591.5214270808120156894', '621508935485425828324.0', '9.657173567168029e+15');
  t('6634005133357052451687820090403.454214503998864567', '4395572927917156531546770565399.1531171242645042057', '1e+0');
  t('561358196950822401.219331193970618850927926', '284094044873.429723', '1.975959e+6');
  t('96655318615507296355355495509191724349087481421.443366160438423650455312664494', '874385663187385109096974951306517.17058901699706997489060938757056530330', '1.10540831906107e+14');
  t('319355089917280495417975890926.0520068968103712371405701029957', '5695608669464798606.8', '5.6070405895e+10');
  t('6589390657819358431145194.3', '4816208376091416.4092260609510653840221', '1.368169759e+9');
  t('5749207204280111971.2399521327579206', '66529.44005149597717850445686559974354830', '8.64159866644e+13');
  t('25764054577770392742769216567530.5291120848448893908087666587441447527269', '55456959929839256.945', '4.64577477928207e+14');
  t('267192937054112929962259218278.498', '15432851717050353.319030872004920819263922925152', '1.731325758537e+13');
  t('83319775729074952878575984405873869997269.2300715131706353767647252433118', '419776246474292174386248279272614367.3064065847293656934464', '1.98486e+5');
  t('574046336479.3351930280634467150899678620165869701', '6.1437964', '9.3435117166e+10');
  t('3540182073920138072.026853859582039465', '253208876988.0692081973320', '1.3981271e+7');
  t('9696575248.21815763101560149840735433053481716997', '55942.44194499822718543729613724768383737224', '1.73331e+5');
  t('55921114169344145191055435.2610620944516952481039', '9348400660268970144532200.507114435077496149942220', '5e+0');
  t('53697301590823117750393292519687928.74', '89874089751736615846952289.255365960779471017146746835466719349', '5.9747255e+8');
  t('78323098848769137295265.7869219344486', '5132901523696.5446022535238996301111552952', '1.5259030099e+10');
  t('102948125446933881360352618908870409248110847326846.2979756693', '878653185315123406289344586830412199992.7979934870485306494633', '1.17165825114e+11');
  t('4008793273264.1170983408822972440861271321647', '976361919213.2316106634997273614874628961', '4e+0');
  t('39546984927010933113107020217275209737865987546262881.468', '201979668131620624713040583190.1768', '1.95796860608960046428552e+23');
  t('7419080256297.6574077483845468492819497936', '6869058.54609711927386335531674712790758057530', '1.080072e+6');
  t('71448125354018967793592240554420279044.57840455284860239840288843', '390651079363301369559854785.959061826619434879', '1.82894990256e+11');
  t('929678221451.38847376', '2349.608615532033240403816841599825313959', '3.95673651e+8');
  t('648400065576167051979400608343532495736976782.56791661659156612969265453', '6745748155220524090476072.09945', '9.6119815127454949757e+19');
  t('29256953782350909705357102906085177781979404563625087.3984329813578161157713732347270', '137130661855963480915204957002415.5182', '2.13350926673724032098e+20');
  t('37773103217068750212158006668857854578024531065313432743998.5108607129067709807869775934', '34530484343089936093734546612069.4836703339688164121854', '1.093905977158056006873414475e+27');
  t('940375544506545701153097768382485552.348369746129330854687', '30997856492924275904214.0', '3.0336792633426e+13');
  t('5336324471503412892246454790435298131.765637937108', '5817186143.6718203755279228968801748571927967895', '9.17337753977237083211474264e+26');
  t('50126263736046640973332.3288784846756566112538814354582229133824', '36609431742269.619', '1.369217203e+9');
  t('1507134497657611561623405861394090.68553354328170', '411101209821411.522390382504107295533735686993', '3.666091127078738578e+18');
  t('55357474445527737454819685783907416458065524230069.691764259118022601576858833805268105595', '5621244695803326955806044602896191021.516717035980774112599044', '9.847903345473e+12');
  t('974583367533285749398509705552380.3128857952218', '64089042.8129609139918343282157132268887862111', '1.52067081166672208966032e+25');
  t('1221280778169778846.1922578706405272685587395438266959', '5.0235', '2.43113522080178928e+17');
  t('322737069.1510', '2365.14198886884160659', '1.36455e+5');
  t('903762742058357468352979073788437717394.2893711503', '323669258716028958819.62509', '2.792241517293037703e+18');
  t('8708722977474890817302295046.3316560', '15351740.74166533', '5.67279185078928304778e+20');
  t('1253081893096805021302658411202795225103.777985055051413714537965120957263', '7008004654558238416648387968378527.0', '1.78807e+5');
  t('893869087741829442344628143655848625177274219955704697909879408.567931339299986894853610537', '66045860445982080245479594994024166209.3284078', '1.3534066809121391903010568e+25');
  t('8045157196926269967176822342266261944431.285036014152642196', '44012203486684537298371034278.883376887762729452659', '1.82793783532e+11');
  t('77046343920956351207888110679283583298479.0610470596656394786408146174425755', '298470931606474634432309.449810602254052307182', '2.58136842694416039e+17');
  t('623500529132658429674646646136332752270911793714.1131931861676', '773553792860593262829196473575.6467364605464340907119', '8.06020906221609302e+17');
  t('13297783934980798196167395943.5044663930215602538350779570681', '63844203906341285954.6639150529335', '2.08284904e+8');
  t('902379170865051968232758716229790.4947026226317058737703674', '13079087155542675027347.417882642382689085044819', '6.8994048295e+10');
  t('327761534382376789582393358484099274419818218907346678492.47724682758', '703890614074045530088421622059.9702661722116', '4.65642711848830006066449093e+26');
  t('7787320.80173823747928201752064367', '86.0740053903220147186986', '9.0472e+4');
  t('25712537197492699240821504825869.9757710573733278074695', '257025.259727429610260664059510936859', '1.00038950353596976918982639e+26');
  t('2055719336331506637100585335116853672706.9842245710219885055487221126', '5195105286874.782596', '3.95703113375814736151318069e+26');
  t('879858160870518396458962028816059568554493.077883892616265', '35676646861167640026083873733299515789.898807336821599632968510259020286302', '2.4662e+4');
  t('1113878505.60294076059743593328371713765962', '3637.63107629701348', '3.06209e+5');
  t('16740018616182376046668.749145532', '8408377480.7', '1.990873822518e+12');
  t('9641879632067985881566327.0237796573555855098220202232961805', '90527.54028', '1.06507694810284597755e+20');
  t('5097191061953955922095657392188.86087552877924', '90651471742300412247426507.82337292166927', '5.6228e+4');
  t('8763741403975499656817131217909530870752109.109990571987170602723324618870753441516', '30495028465595390590584125549314520236.6905848098088837862649336', '2.87382e+5');
  t('4758065138779986462430459839401160855804453083.28884561707', '9216359459863343487318696535793851.04274104385246472828653045362864845934', '5.16262973411e+11');
  t('80945716455293829628805000255504572029356862035773630.9840004557183223077032737738', '19041026008058976122521722290.56334', '4.251121574070333309215334e+24');
  t('922185019562223341922956940658234584269225102945.8638950', '9191156079948274898662304.275523792591358', '1.00333952719407320280756e+23');
  t('146688497828016194730729113679.662095257190217278639558303', '20018943711272755727383284644.24507', '7e+0');
  t('9632455.0', '5.91258874108', '1.629143e+6');
  t('749709927599711673286168724713.637721694323007571652', '68831371497.82470573187401020', '1.0891980085322067643e+19');
  t('703334852897742025459017143133534769379436366529.28693683670471993263060', '43404555974140947273348.88169434203533719911009901', '1.6204171131638036825989489e+25');
  t('266446231005960024131312641770116963442589808.95592697589', '908813209562489394364082.9707572', '2.93180411774856973797e+20');
  t('7365331456946807654134746419826200283228175270946.87441478287000755797033173195980998', '72570173729965791642605682209056791163.095609209261129', '1.01492542712e+11');
  t('1885375657396122344090283190476150429471.29065818802987431905865902497995', '67122860797766366857816021232423265355.80132760264091339569551013509671764', '2.8e+1');
  t('1988895029701763458653106419453898805.1', '40999033655994650376584088995662929.9872018665953', '4.8e+1');
  t('9205310802789903367648277912472047986.41931455321056110337551393595', '6878892446038808663400976440763.36', '1.338196e+6');
  t('7254812952281947165494.39874884828253729493', '278987038678.2602011075217990146458934669', '2.6004121864e+10');
  t('75121545671313909531478916112276629156.02750137976105193542131649494474', '7556481823445448485668050317.73936186381', '9.941338764e+9');
  t('14230274566049623.3174995100578869246434729', '4217337009791.19808', '3.374e+3');
  t('18563145159921228668292804829417744799073736.9369852598006749423827382921969171129', '334308200499652466018.93584328063247000337134', '5.5527041012386192428781e+22');
  t('-1.939705899412577956E+107', '4.16011175E+95', '-4.66262931377e+11');
  t('-2.17572499998013E+90', '-8.5667512E+88', '2.5e+1');
  t('53.0528', '5.81484336338007548323701145501824145289496435180610403', '9e+0');
  t('-9.262020368015430982320E+31', '-961048023.41740322816166130721520234700463741290443', '9.6374168015875956889595e+22');
  t('72052512835997.5407791032688023719', '-7.7902408903663348543130', '-9.249073789887e+12');
  t('5386665.48728950474757', '-55787.95154355082444905369697247039', '-9.6e+1');
  t('8200969461.781648200152056735094101250', '-6173584.6386638', '-1.328e+3');
  t('-6162044682.46579949512756133331211291134216377880642', '70883.101619290546467', '-8.6932e+4');
  t('2.2858509075765580228170996569682255', '7.024E-8', '3.2543435e+7');
});
