/*
 * Decompiled with CFR 0.152.
 */
package com.beust.klaxon;

import com.beust.klaxon.Debug;
import com.beust.klaxon.Token;
import com.beust.klaxon.TokenType;
import java.io.BufferedReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010'\u001a\u00020\u0002H\u0002J\t\u0010(\u001a\u00020\u0006H\u0096\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\nH\u0002J\b\u0010+\u001a\u00020\u0006H\u0002J\u0010\u0010,\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\nH\u0002J\u000e\u0010-\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\nJ\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\t\u0010 \u001a\u00020\u0002H\u0096\u0002J\b\u00102\u001a\u00020\nH\u0002J\u0006\u00103\u001a\u00020\u0002J\u0006\u00104\u001a\u00020\u0002J\b\u00105\u001a\u00020\nH\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0016\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0018\"\u0004\b\u001f\u0010\u001aR\u0012\u0010 \u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/beust/klaxon/Lexer;", "", "Lcom/beust/klaxon/Token;", "passedReader", "Ljava/io/Reader;", "lenient", "", "(Ljava/io/Reader;Z)V", "BOOLEAN_LETTERS", "", "", "getBOOLEAN_LETTERS", "()Ljava/util/Set;", "DOUBLE", "Ljava/util/regex/Pattern;", "EOF", "NULL_LETTERS", "getNULL_LETTERS", "NUMERIC", "kotlin.jvm.PlatformType", "expectName", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getLenient", "()Z", "line", "getLine", "setLine", "next", "Ljava/lang/Character;", "getPassedReader", "()Ljava/io/Reader;", "peeked", "reader", "Ljava/io/BufferedReader;", "actualNextToken", "hasNext", "isBooleanLetter", "c", "isDone", "isSpace", "isValueLetter", "log", "", "s", "", "nextChar", "nextToken", "peek", "peekChar", "klaxon"})
public final class Lexer
implements Iterator<Token>,
KMappedMarker {
    private final Token EOF;
    private int index;
    private int line;
    private final Pattern NUMERIC;
    private final Pattern DOUBLE;
    private final BufferedReader reader;
    private Character next;
    @NotNull
    private final Set<Character> BOOLEAN_LETTERS;
    @NotNull
    private final Set<Character> NULL_LETTERS;
    private Token peeked;
    private boolean expectName;
    @NotNull
    private final Reader passedReader;
    private final boolean lenient;

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int n) {
        this.line = n;
    }

    private final boolean isSpace(char c) {
        if (c == '\n') {
            int n = this.line;
            this.line = n + 1;
        }
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private final char nextChar() {
        Character c;
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot get next char: EOF reached");
        }
        Character c2 = this.next;
        if (c2 == null) {
            Intrinsics.throwNpe();
        }
        char c3 = c2.charValue();
        int n = this.reader.read();
        Lexer lexer = this;
        int it = n;
        lexer.next = c = it == -1 ? null : Character.valueOf((char)it);
        n = this.index;
        this.index = n + 1;
        return c3;
    }

    private final char peekChar() {
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot peek next char: EOF reached");
        }
        Character c = this.next;
        if (c == null) {
            Intrinsics.throwNpe();
        }
        return c.charValue();
    }

    private final boolean isDone() {
        return this.next == null;
    }

    @NotNull
    public final Set<Character> getBOOLEAN_LETTERS() {
        return this.BOOLEAN_LETTERS;
    }

    private final boolean isBooleanLetter(char c) {
        return this.BOOLEAN_LETTERS.contains(Character.valueOf(Character.toLowerCase(c)));
    }

    @NotNull
    public final Set<Character> getNULL_LETTERS() {
        return this.NULL_LETTERS;
    }

    public final boolean isValueLetter(char c) {
        char c2;
        return c == '-' || c == '+' || c == '.' || Character.isDigit(c2 = c) || this.isBooleanLetter(c) || this.NULL_LETTERS.contains(Character.valueOf(c));
    }

    @NotNull
    public final Token peek() {
        if (this.peeked == null) {
            this.peeked = this.actualNextToken();
        }
        Token token = this.peeked;
        if (token == null) {
            Intrinsics.throwNpe();
        }
        return token;
    }

    @Override
    @NotNull
    public Token next() {
        return this.nextToken();
    }

    @Override
    public boolean hasNext() {
        return Intrinsics.areEqual((Object)this.peek(), (Object)this.EOF) ^ true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Token nextToken() {
        Token token;
        if (this.peeked != null) {
            void var2_1;
            Token token2 = this.peeked;
            if (token2 == null) {
                Intrinsics.throwNpe();
            }
            Token r = token2;
            this.peeked = null;
            token = var2_1;
        } else {
            token = this.actualNextToken();
        }
        Token result = token;
        return result;
    }

    private final Token actualNextToken() {
        TokenType tokenType;
        if (this.isDone()) {
            return this.EOF;
        }
        char c = this.nextChar();
        StringBuilder currentValue = new StringBuilder();
        Object jsonValue = null;
        while (!this.isDone() && this.isSpace(c)) {
            c = this.nextChar();
        }
        if ('\"' == c || this.lenient && this.expectName) {
            if (this.lenient) {
                currentValue.append(c);
            }
            tokenType = TokenType.VALUE;
            block19: while (true) {
                if (this.isDone()) {
                    throw (Throwable)new RuntimeException("Unterminated string");
                }
                c = this.lenient ? this.peekChar() : this.nextChar();
                block2 : switch (c) {
                    case '\\': {
                        if (this.isDone()) {
                            throw (Throwable)new RuntimeException("Unterminated string");
                        }
                        c = this.nextChar();
                        switch (c) {
                            case '\\': {
                                currentValue.append("\\");
                                break block2;
                            }
                            case '/': {
                                currentValue.append("/");
                                break block2;
                            }
                            case 'b': {
                                currentValue.append("\b");
                                break block2;
                            }
                            case 'f': {
                                currentValue.append("\f");
                                break block2;
                            }
                            case 'n': {
                                currentValue.append("\n");
                                int n = this.line;
                                this.line = n + 1;
                                break block2;
                            }
                            case 'r': {
                                currentValue.append("\r");
                                break block2;
                            }
                            case 't': {
                                currentValue.append("\t");
                                break block2;
                            }
                            case 'u': {
                                StringBuilder unicodeChar = new StringBuilder(4).append(this.nextChar()).append(this.nextChar()).append(this.nextChar()).append(this.nextChar());
                                int intValue = Integer.parseInt(unicodeChar.toString(), 16);
                                currentValue.append((char)intValue);
                                break block2;
                            }
                        }
                        currentValue.append(c);
                        break;
                    }
                    case '\"': {
                        break block19;
                    }
                    default: {
                        if (this.lenient) {
                            char unicodeChar = c;
                            if (!Character.isJavaIdentifierPart(unicodeChar)) {
                                this.expectName = false;
                                break block19;
                            }
                            currentValue.append(c);
                            c = this.nextChar();
                            break;
                        }
                        currentValue.append(c);
                    }
                }
            }
            jsonValue = currentValue.toString();
        } else if ('{' == c) {
            tokenType = TokenType.LEFT_BRACE;
            this.expectName = true;
        } else if ('}' == c) {
            tokenType = TokenType.RIGHT_BRACE;
            this.expectName = false;
        } else if ('[' == c) {
            tokenType = TokenType.LEFT_BRACKET;
            this.expectName = false;
        } else if (']' == c) {
            tokenType = TokenType.RIGHT_BRACKET;
            this.expectName = false;
        } else if (':' == c) {
            tokenType = TokenType.COLON;
            this.expectName = false;
        } else if (',' == c) {
            tokenType = TokenType.COMMA;
            this.expectName = true;
        } else if (!this.isDone()) {
            String v2;
            while (this.isValueLetter(c)) {
                currentValue.append(c);
                if (!this.isValueLetter(this.peekChar())) break;
                c = this.nextChar();
            }
            if (this.NUMERIC.matcher(v2 = currentValue.toString()).matches()) {
                try {
                    jsonValue = Integer.parseInt(v2);
                }
                catch (NumberFormatException e) {
                    try {
                        jsonValue = Long.parseLong(v2);
                    }
                    catch (NumberFormatException e2) {
                        jsonValue = new BigInteger(v2);
                    }
                }
            } else if (this.DOUBLE.matcher(v2).matches()) {
                jsonValue = Double.parseDouble(v2);
            } else {
                String string2 = v2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"v");
                String string3 = string2;
                String string4 = "true";
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                String string7 = string6;
                if (Intrinsics.areEqual((Object)string4, (Object)string7)) {
                    jsonValue = true;
                } else {
                    string3 = v2;
                    string4 = "false";
                    String string8 = string3.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                    string7 = string8;
                    if (Intrinsics.areEqual((Object)string4, (Object)string7)) {
                        jsonValue = false;
                    } else if (Intrinsics.areEqual((Object)v2, (Object)"null")) {
                        jsonValue = null;
                    } else {
                        throw (Throwable)new RuntimeException("Unexpected character at position " + (this.index - 1) + ": '" + c + "' (ASCII: " + c + ")'");
                    }
                }
            }
            tokenType = TokenType.VALUE;
        } else {
            tokenType = TokenType.EOF;
        }
        return new Token(tokenType, jsonValue);
    }

    private final Object log(String s) {
        String string2;
        if (Debug.Companion.getVerbose()) {
            System.out.println((Object)s);
            string2 = Unit.INSTANCE;
        } else {
            string2 = "";
        }
        return string2;
    }

    @NotNull
    public final Reader getPassedReader() {
        return this.passedReader;
    }

    public final boolean getLenient() {
        return this.lenient;
    }

    public Lexer(@NotNull Reader passedReader, boolean lenient) {
        BufferedReader bufferedReader;
        Intrinsics.checkParameterIsNotNull((Object)passedReader, (String)"passedReader");
        this.passedReader = passedReader;
        this.lenient = lenient;
        this.EOF = new Token(TokenType.EOF, null);
        this.line = 1;
        this.NUMERIC = Pattern.compile("[-]?[0-9]+");
        Pattern pattern = Pattern.compile(this.NUMERIC.toString() + "((\\.[0-9]+)?([eE][-+]?[0-9]+)?)");
        if (pattern == null) {
            Intrinsics.throwNpe();
        }
        this.DOUBLE = pattern;
        Reader reader = this.passedReader;
        Lexer lexer = this;
        int n = 8192;
        lexer.reader = bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        int c = this.reader.read();
        this.next = c == -1 ? null : Character.valueOf((char)c);
        this.BOOLEAN_LETTERS = StringsKt.toSet((CharSequence)"falsetrue");
        this.NULL_LETTERS = StringsKt.toSet((CharSequence)"null");
    }

    public /* synthetic */ Lexer(Reader reader, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(reader, bl);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

