// Code generated by smithy-go-codegen DO NOT EDIT.

package backupgateway

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/backupgateway/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateGatewayToServer struct {
}

func (*validateOpAssociateGatewayToServer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateGatewayToServer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateGatewayToServerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateGatewayToServerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateGateway struct {
}

func (*validateOpCreateGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteGateway struct {
}

func (*validateOpDeleteGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteHypervisor struct {
}

func (*validateOpDeleteHypervisor) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteHypervisor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteHypervisorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteHypervisorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateGatewayFromServer struct {
}

func (*validateOpDisassociateGatewayFromServer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateGatewayFromServer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateGatewayFromServerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateGatewayFromServerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetBandwidthRateLimitSchedule struct {
}

func (*validateOpGetBandwidthRateLimitSchedule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetBandwidthRateLimitSchedule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetBandwidthRateLimitScheduleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetBandwidthRateLimitScheduleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetGateway struct {
}

func (*validateOpGetGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetHypervisor struct {
}

func (*validateOpGetHypervisor) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetHypervisor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetHypervisorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetHypervisorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetHypervisorPropertyMappings struct {
}

func (*validateOpGetHypervisorPropertyMappings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetHypervisorPropertyMappings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetHypervisorPropertyMappingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetHypervisorPropertyMappingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetVirtualMachine struct {
}

func (*validateOpGetVirtualMachine) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetVirtualMachine) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetVirtualMachineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetVirtualMachineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpImportHypervisorConfiguration struct {
}

func (*validateOpImportHypervisorConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpImportHypervisorConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ImportHypervisorConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpImportHypervisorConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutBandwidthRateLimitSchedule struct {
}

func (*validateOpPutBandwidthRateLimitSchedule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutBandwidthRateLimitSchedule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutBandwidthRateLimitScheduleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutBandwidthRateLimitScheduleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutHypervisorPropertyMappings struct {
}

func (*validateOpPutHypervisorPropertyMappings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutHypervisorPropertyMappings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutHypervisorPropertyMappingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutHypervisorPropertyMappingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutMaintenanceStartTime struct {
}

func (*validateOpPutMaintenanceStartTime) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutMaintenanceStartTime) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutMaintenanceStartTimeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutMaintenanceStartTimeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartVirtualMachinesMetadataSync struct {
}

func (*validateOpStartVirtualMachinesMetadataSync) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartVirtualMachinesMetadataSync) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartVirtualMachinesMetadataSyncInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartVirtualMachinesMetadataSyncInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTestHypervisorConfiguration struct {
}

func (*validateOpTestHypervisorConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTestHypervisorConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TestHypervisorConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTestHypervisorConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateGatewayInformation struct {
}

func (*validateOpUpdateGatewayInformation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateGatewayInformation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateGatewayInformationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateGatewayInformationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateGatewaySoftwareNow struct {
}

func (*validateOpUpdateGatewaySoftwareNow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateGatewaySoftwareNow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateGatewaySoftwareNowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateGatewaySoftwareNowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateHypervisor struct {
}

func (*validateOpUpdateHypervisor) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateHypervisor) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateHypervisorInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateHypervisorInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateGatewayToServerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateGatewayToServer{}, middleware.After)
}

func addOpCreateGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateGateway{}, middleware.After)
}

func addOpDeleteGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteGateway{}, middleware.After)
}

func addOpDeleteHypervisorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteHypervisor{}, middleware.After)
}

func addOpDisassociateGatewayFromServerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateGatewayFromServer{}, middleware.After)
}

func addOpGetBandwidthRateLimitScheduleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetBandwidthRateLimitSchedule{}, middleware.After)
}

func addOpGetGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetGateway{}, middleware.After)
}

func addOpGetHypervisorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetHypervisor{}, middleware.After)
}

func addOpGetHypervisorPropertyMappingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetHypervisorPropertyMappings{}, middleware.After)
}

func addOpGetVirtualMachineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetVirtualMachine{}, middleware.After)
}

func addOpImportHypervisorConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpImportHypervisorConfiguration{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutBandwidthRateLimitScheduleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutBandwidthRateLimitSchedule{}, middleware.After)
}

func addOpPutHypervisorPropertyMappingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutHypervisorPropertyMappings{}, middleware.After)
}

func addOpPutMaintenanceStartTimeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutMaintenanceStartTime{}, middleware.After)
}

func addOpStartVirtualMachinesMetadataSyncValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartVirtualMachinesMetadataSync{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpTestHypervisorConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTestHypervisorConfiguration{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateGatewayInformationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateGatewayInformation{}, middleware.After)
}

func addOpUpdateGatewaySoftwareNowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateGatewaySoftwareNow{}, middleware.After)
}

func addOpUpdateHypervisorValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateHypervisor{}, middleware.After)
}

func validateBandwidthRateLimitInterval(v *types.BandwidthRateLimitInterval) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BandwidthRateLimitInterval"}
	if v.StartHourOfDay == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartHourOfDay"))
	}
	if v.EndHourOfDay == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndHourOfDay"))
	}
	if v.StartMinuteOfHour == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StartMinuteOfHour"))
	}
	if v.EndMinuteOfHour == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndMinuteOfHour"))
	}
	if v.DaysOfWeek == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DaysOfWeek"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateBandwidthRateLimitIntervals(v []types.BandwidthRateLimitInterval) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BandwidthRateLimitIntervals"}
	for i := range v {
		if err := validateBandwidthRateLimitInterval(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTags(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tags"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVmwareToAwsTagMapping(v *types.VmwareToAwsTagMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VmwareToAwsTagMapping"}
	if v.VmwareCategory == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VmwareCategory"))
	}
	if v.VmwareTagName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VmwareTagName"))
	}
	if v.AwsTagKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsTagKey"))
	}
	if v.AwsTagValue == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AwsTagValue"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVmwareToAwsTagMappings(v []types.VmwareToAwsTagMapping) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VmwareToAwsTagMappings"}
	for i := range v {
		if err := validateVmwareToAwsTagMapping(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateGatewayToServerInput(v *AssociateGatewayToServerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateGatewayToServerInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if v.ServerArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServerArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateGatewayInput(v *CreateGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateGatewayInput"}
	if v.ActivationKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActivationKey"))
	}
	if v.GatewayDisplayName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayDisplayName"))
	}
	if len(v.GatewayType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayType"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteGatewayInput(v *DeleteGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteGatewayInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteHypervisorInput(v *DeleteHypervisorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteHypervisorInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateGatewayFromServerInput(v *DisassociateGatewayFromServerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateGatewayFromServerInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetBandwidthRateLimitScheduleInput(v *GetBandwidthRateLimitScheduleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetBandwidthRateLimitScheduleInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetGatewayInput(v *GetGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetGatewayInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetHypervisorInput(v *GetHypervisorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetHypervisorInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetHypervisorPropertyMappingsInput(v *GetHypervisorPropertyMappingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetHypervisorPropertyMappingsInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetVirtualMachineInput(v *GetVirtualMachineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetVirtualMachineInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpImportHypervisorConfigurationInput(v *ImportHypervisorConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ImportHypervisorConfigurationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Host == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Host"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutBandwidthRateLimitScheduleInput(v *PutBandwidthRateLimitScheduleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutBandwidthRateLimitScheduleInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if v.BandwidthRateLimitIntervals == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BandwidthRateLimitIntervals"))
	} else if v.BandwidthRateLimitIntervals != nil {
		if err := validateBandwidthRateLimitIntervals(v.BandwidthRateLimitIntervals); err != nil {
			invalidParams.AddNested("BandwidthRateLimitIntervals", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutHypervisorPropertyMappingsInput(v *PutHypervisorPropertyMappingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutHypervisorPropertyMappingsInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if v.VmwareToAwsTagMappings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VmwareToAwsTagMappings"))
	} else if v.VmwareToAwsTagMappings != nil {
		if err := validateVmwareToAwsTagMappings(v.VmwareToAwsTagMappings); err != nil {
			invalidParams.AddNested("VmwareToAwsTagMappings", err.(smithy.InvalidParamsError))
		}
	}
	if v.IamRoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("IamRoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutMaintenanceStartTimeInput(v *PutMaintenanceStartTimeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutMaintenanceStartTimeInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if v.HourOfDay == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HourOfDay"))
	}
	if v.MinuteOfHour == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinuteOfHour"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartVirtualMachinesMetadataSyncInput(v *StartVirtualMachinesMetadataSyncInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartVirtualMachinesMetadataSyncInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTestHypervisorConfigurationInput(v *TestHypervisorConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TestHypervisorConfigurationInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if v.Host == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Host"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateGatewayInformationInput(v *UpdateGatewayInformationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateGatewayInformationInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateGatewaySoftwareNowInput(v *UpdateGatewaySoftwareNowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateGatewaySoftwareNowInput"}
	if v.GatewayArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateHypervisorInput(v *UpdateHypervisorInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateHypervisorInput"}
	if v.HypervisorArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HypervisorArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
