/* do not edit automatically generated by mc from bnflex.  */
/* bnflex.def provides a simple lexical package for pg.

Copyright (C) 2001-2023 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_bnflex_H)
#   define _bnflex_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GNameKey.h"

#   if defined (_bnflex_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef enum {bnflex_identtok, bnflex_literaltok, bnflex_codetok, bnflex_lbecomestok, bnflex_rbecomestok, bnflex_bartok, bnflex_lsparatok, bnflex_rsparatok, bnflex_lcparatok, bnflex_rcparatok, bnflex_lparatok, bnflex_rparatok, bnflex_errortok, bnflex_tfunctok, bnflex_symfunctok, bnflex_squotetok, bnflex_dquotetok, bnflex_moduletok, bnflex_begintok, bnflex_rulestok, bnflex_endtok, bnflex_lesstok, bnflex_gretok, bnflex_tokentok, bnflex_specialtok, bnflex_firsttok, bnflex_followtok, bnflex_BNFtok, bnflex_FNBtok, bnflex_declarationtok, bnflex_epsilontok, bnflex_eoftok} bnflex_TokenType;


/*
   OpenSource - Attempts to open the source file, a.
                The success of the operation is returned.
*/

EXTERN unsigned int bnflex_OpenSource (const char *a_, unsigned int _a_high);

/*
   CloseSource - Closes the current open file.
*/

EXTERN void bnflex_CloseSource (void);

/*
   GetChar - returns the current character on the input stream.
*/

EXTERN char bnflex_GetChar (void);

/*
   PutChar - pushes a character onto the push back stack, it also
             returns the character which has been pushed.
*/

EXTERN char bnflex_PutChar (char ch);

/*
   SymIs - if t is equal to the current token the next token is read
           and true is returned, otherwise false is returned.
*/

EXTERN unsigned int bnflex_SymIs (bnflex_TokenType t);

/*
   IsSym - returns the result of the comparison between the current token
           type and t.
*/

EXTERN unsigned int bnflex_IsSym (bnflex_TokenType t);

/*
   GetCurrentTokenType - returns the type of current token.
*/

EXTERN bnflex_TokenType bnflex_GetCurrentTokenType (void);

/*
   GetCurrentToken - returns the NameKey of the current token.
*/

EXTERN NameKey_Name bnflex_GetCurrentToken (void);

/*
   SkipUntilWhite - skips all characters until white space is seen.
*/

EXTERN void bnflex_SkipUntilWhite (void);

/*
   SkipWhite - skips all white space.
*/

EXTERN void bnflex_SkipWhite (void);

/*
   SkipUntilEoln - skips until a lf is seen. It consumes the lf.
*/

EXTERN void bnflex_SkipUntilEoln (void);

/*
   AdvanceToken - advances to the next token.
*/

EXTERN void bnflex_AdvanceToken (void);

/*
   IsReserved - returns TRUE if the name is a reserved word.
*/

EXTERN unsigned int bnflex_IsReserved (NameKey_Name name);

/*
   PushBackToken - pushes a token back onto input.
*/

EXTERN void bnflex_PushBackToken (NameKey_Name t);

/*
   SetDebugging - sets the debugging flag.
*/

EXTERN void bnflex_SetDebugging (unsigned int flag);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
