/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.zeno;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.ma.zeno.ZenoChain;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeBuilder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.EmptySequence;

public class ZenoSequence
implements GroundedValue {
    private final ZenoChain<Item> chain;

    public ZenoSequence() {
        this.chain = new ZenoChain();
    }

    public static ZenoSequence fromList(List<Item> items) {
        ZenoChain<Item> chain = new ZenoChain<Item>().addAll(items);
        return new ZenoSequence(chain);
    }

    public ZenoSequence(ZenoChain<Item> chain) {
        this.chain = chain;
    }

    @Override
    public SequenceIterator iterate() {
        return new ZenoSequenceIterator(this);
    }

    @Override
    public Item itemAt(int n) {
        try {
            return this.chain.get(n);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public Item head() {
        return this.chain.isEmpty() ? null : this.chain.get(0);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        int size;
        if (start < 0) {
            start = 0;
        }
        if (start >= (size = this.chain.size()) || length <= 0) {
            return EmptySequence.getInstance();
        }
        if ((long)start + (long)length > (long)size) {
            length = size - start;
        }
        if (length == 1) {
            return this.itemAt(start);
        }
        return new ZenoSequence(this.chain.subList(start, start + length));
    }

    @Override
    public int getLength() {
        return this.chain.size();
    }

    @Override
    public UnicodeString getUnicodeStringValue() throws XPathException {
        switch (this.getLength()) {
            case 0: {
                return EmptyUnicodeString.getInstance();
            }
            case 1: {
                return this.head().getUnicodeStringValue();
            }
        }
        UnicodeBuilder builder = new UnicodeBuilder();
        UnicodeString separator = EmptyUnicodeString.getInstance();
        for (Item item : this.chain) {
            builder.append(separator);
            separator = StringConstants.SINGLE_SPACE;
            builder.append(item.getStringValue());
        }
        return builder.toUnicodeString();
    }

    @Override
    public String getStringValue() throws XPathException {
        switch (this.getLength()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.head().getStringValue();
            }
        }
        StringBuilder builder = new StringBuilder();
        String separator = "";
        for (Item item : this.chain) {
            builder.append(separator);
            separator = " ";
            builder.append(item.getStringValue());
        }
        return builder.toString();
    }

    public ZenoSequence append(Item item) {
        return new ZenoSequence(this.chain.add(item));
    }

    public ZenoSequence appendSequence(GroundedValue items) {
        if (this.chain.isEmpty() && items instanceof ZenoSequence) {
            return (ZenoSequence)items;
        }
        switch (items.getLength()) {
            case 0: {
                return this;
            }
            case 1: {
                Item item = items.head();
                return new ZenoSequence(this.chain.add(item));
            }
        }
        if (items instanceof ZenoSequence) {
            return new ZenoSequence(this.chain.concat(((ZenoSequence)items).chain));
        }
        return new ZenoSequence(this.chain.addAll(items.asIterable()));
    }

    public static ZenoSequence join(List<GroundedValue> segments) {
        ZenoChain<Item> list = new ZenoChain<Item>();
        for (GroundedValue val : segments) {
            if (val instanceof ZenoSequence) {
                list = list.concat(((ZenoSequence)val).chain);
                continue;
            }
            for (Item item : val.asIterable()) {
                list = list.add(item);
            }
        }
        return new ZenoSequence(list);
    }

    public static class ZenoSequenceIterator
    implements GroundedIterator,
    LastPositionFinder,
    LookaheadIterator {
        private final ZenoSequence sequence;
        private final Iterator<Item> chainIterator;
        private int position = 0;

        public ZenoSequenceIterator(ZenoSequence sequence) {
            this.sequence = sequence;
            this.chainIterator = sequence.chain.iterator();
        }

        @Override
        public Item next() {
            ++this.position;
            return this.chainIterator.hasNext() ? this.chainIterator.next() : null;
        }

        @Override
        public boolean supportsGetLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.sequence.getLength();
        }

        @Override
        public boolean isActuallyGrounded() {
            return true;
        }

        @Override
        public GroundedValue getResidue() {
            return this.sequence.subsequence(this.position, Integer.MAX_VALUE);
        }

        @Override
        public GroundedValue materialize() {
            return this.sequence;
        }

        @Override
        public boolean supportsHasNext() {
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.chainIterator.hasNext();
        }
    }
}

