// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef MODELTASKS_H
#define MODELTASKS_H

#include "modelserver.h"
#include "modelrunner.h"

GLOBAL_BEGIN_NAMESPACE
class HttpTask : public ModelTask
{
public:
    explicit HttpTask(ModelRunner *r, const QString &req, ModelProxy *m, HttpContext *c);
protected:
    QString reqBody;
    ModelProxy *model = nullptr;
    HttpContext *ctx = nullptr;
};

class EmbTask : public HttpTask
{
public:
    using HttpTask::HttpTask;
    void doTask() override;
};

class ChatCompletionsTask : public ModelTask
{
public:
    explicit ChatCompletionsTask(ModelRunner *r, const QVariantHash &json, ModelProxy *m, HttpContext *c);
    void doTask() override;
    QString formatPrompt();
protected:
    QVariantHash root;
    ModelProxy *model = nullptr;
    HttpContext *ctx = nullptr;
};

class ChatStreamTask : public ChatCompletionsTask
{
public:
    using ChatCompletionsTask::ChatCompletionsTask;
    ~ChatStreamTask();
    void doTask() override;
public:
    QMutex genMtx;
    QString text;
    QWaitCondition con;
    bool stop = false;
};

GLOBAL_END_NAMESPACE

#endif // MODELTASKS_H
