/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     kirigaya <kirigaya@mkacg.com>
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "basemodulewidget.h"
#include "modules/desktopmodemodule.h"
#include "widgets/closebutton.h"
#include "widgets/indexdotswidget.h"
#include "worker.h"
#include "widgetmanager.h"

#include <QPropertyAnimation>
#include <QPushButton>
#include <QSettings>
#include <QWidget>
#include <QKeyEvent>
#include <QWheelEvent>
#include <QHBoxLayout>

#include <DMainWindow>
#include <DIconButton>
#include <DWidget>
#include <DGuiApplicationHelper>
#include <DPalette>
#include <DPlatformWindowHandle>
#include <DSysInfo>
#include <DSuggestButton>
#include <DTitlebar>

DCORE_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

#define DDE_STARTGUIDE_PATH "/usr/bin/dde-startguide"
#define FIRST_ICONCONTENT_WINSIZE 500

class BaseModuleWidget;
class MainWindow : public DMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(DWidget *parent = nullptr);
    ~MainWindow() override;

    void delayInitVideo();

protected:
    void keyPressEvent(QKeyEvent *event) override;
    void resizeEvent(QResizeEvent *event) override;

private slots:
    //上一步按钮响应函数
    void previous();
    //下一步按钮响应函数
    void next();
    void finishedAndClose();

private:
    //主题变化响应函数
    void slotTheme();
    void initUI();
    void initConnect();
    //绑定需要动画的界面
    void bindAnimation();
    //根据index值进行欢迎四个界面的创建,并进行动画绑定
    void updateModule(const int index);
    //动画结束后删除m_last保存的界面
    void animationHandle();


    static bool sortByNumberPrefix(const QFileInfo &a, const QFileInfo &b);

    //记录当前所属于界面
    int m_index;
    //CloseButton *m_closeFrame;
    //下一步按钮
    DSuggestButton *m_nextBtn {nullptr};
    DSuggestButton *m_doneBtn {nullptr};
    //上一步按钮
    DPushButton *m_previousBtn {nullptr};
    //关闭按钮
    DIconButton *m_pCloseBtn {nullptr};

    IndexDotsWidget *m_indexDots {nullptr};
    //第一个页面widget放置动画或者轮播图
    DWidget *m_current;
    DWidget *m_last;
    //上一步和下一步选择的界面的动画
    QPropertyAnimation *m_currentAni;
    QPropertyAnimation *m_currentOpacityAni;
    //当前还没变化的界面的动画
    QPropertyAnimation *m_lastAni;
    QPropertyAnimation *m_lastOpacityAni;

    DWidget *m_fakerWidget;
    QSettings *m_settings;
    DLabel *m_title;
    bool m_isFirst {true};

    QPoint m_previousBtnPoint;
    QEventLoop m_loadVideoLoop;
    bool m_delayInit {false};    // mark currently waiting video initialize
};

#endif // MAINWINDOW_H
