/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery.shared.transport.decorator;

import com.netflix.discovery.shared.transport.decorator.EurekaHttpClientDecorator;
import com.netflix.discovery.shared.transport.decorator.ServerStatusEvaluator;

public final class ServerStatusEvaluators {
    private static final ServerStatusEvaluator LEGACY_EVALUATOR = new ServerStatusEvaluator(){

        @Override
        public boolean accept(int statusCode, EurekaHttpClientDecorator.RequestType requestType) {
            if (statusCode >= 200 && statusCode < 300 || statusCode == 302) {
                return true;
            }
            if (requestType == EurekaHttpClientDecorator.RequestType.Register && statusCode == 404) {
                return true;
            }
            if (requestType == EurekaHttpClientDecorator.RequestType.SendHeartBeat && statusCode == 404) {
                return true;
            }
            if (requestType == EurekaHttpClientDecorator.RequestType.Cancel) {
                return true;
            }
            return requestType == EurekaHttpClientDecorator.RequestType.GetDelta && (statusCode == 403 || statusCode == 404);
        }
    };
    private static final ServerStatusEvaluator HTTP_SUCCESS_EVALUATOR = new ServerStatusEvaluator(){

        @Override
        public boolean accept(int statusCode, EurekaHttpClientDecorator.RequestType requestType) {
            return statusCode >= 200 && statusCode < 300;
        }
    };

    private ServerStatusEvaluators() {
    }

    public static ServerStatusEvaluator legacyEvaluator() {
        return LEGACY_EVALUATOR;
    }

    public static ServerStatusEvaluator httpSuccessEvaluator() {
        return HTTP_SUCCESS_EVALUATOR;
    }
}

