# Generated by Django 2.2.17 on 2021-04-16 08:31

import datetime
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import lti_app.validator


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GradeLinkExam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sourcedid', models.CharField(max_length=256)),
                ('url', models.URLField(max_length=1023)),
            ],
        ),
        migrations.CreateModel(
            name='GradeLinkSheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('sourcedid', models.CharField(max_length=256)),
                ('url', models.URLField(max_length=1023)),
            ],
        ),
        migrations.CreateModel(
            name='LMS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('guid', models.CharField(default=None, help_text="Must be equal to the parameter 'tool_consumer_instance_guid' sent by the LMS in the LTI request. It is commonly the DNS of the LMS.", max_length=2048, verbose_name='GUID')),
                ('name', models.CharField(default=None, max_length=2048)),
                ('url', models.CharField(default=None, max_length=2048, validators=[django.core.validators.URLValidator(['http', 'https'], message='Please enter a valid URL')], verbose_name='URL')),
                ('key', models.CharField(default=None, max_length=128, unique=True, validators=[django.core.validators.MinLengthValidator(3)])),
                ('secret', models.CharField(default=None, max_length=128, validators=[django.core.validators.MinLengthValidator(3)])),
            ],
            options={
                'verbose_name_plural': 'LMS',
            },
        ),
        migrations.CreateModel(
            name='WIMS',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default=None, max_length=2048)),
                ('url', models.CharField(db_index=True, default=None, help_text="URL must point to the WIMS' server cgi.", max_length=2048, unique=True, validators=[django.core.validators.URLValidator(['http', 'https'], message='Please enter a valid URL')], verbose_name='URL')),
                ('class_limit', models.PositiveSmallIntegerField(default=150, help_text='This is the classes default maximum student (between [5, 500]. This parameter is used at class creation and can be later changed individually for each class on the WIMS server by the supervisor.', validators=[lti_app.validator.ModelsValidator.limit_validator], verbose_name='Default student limit')),
                ('expiration', models.DurationField(default=datetime.timedelta(days=365), help_text="This is the classes default duration (format is 'day hours:minutes:seconds', default is 365 days) before expiration. This parameter is used at class creation and can be later changed individually for each class on the WIMS server by the supervisor.", validators=[lti_app.validator.ModelsValidator.expiration_validator], verbose_name='Default duration')),
                ('ident', models.CharField(default=None, help_text="See 'https://wimsapi.readthedocs.io/#configuration' for more informations", max_length=2048)),
                ('passwd', models.CharField(default=None, help_text="See 'https://wimsapi.readthedocs.io/#configuration' for more informations", max_length=2048)),
                ('rclass', models.CharField(default=None, help_text="See 'https://wimsapi.readthedocs.io/#configuration' for more informations", max_length=2048)),
                ('allowed_lms', models.ManyToManyField(blank=True, to='lti_app.LMS')),
            ],
            options={
                'verbose_name_plural': 'WIMS',
            },
        ),
        migrations.CreateModel(
            name='WimsClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lms_guid', models.CharField(default=None, max_length=256)),
                ('qclass', models.CharField(default=None, max_length=256)),
                ('name', models.CharField(default=None, max_length=2048)),
                ('lms', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.LMS')),
                ('wims', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WIMS')),
            ],
            options={
                'verbose_name_plural': 'WimsClasses',
            },
        ),
        migrations.CreateModel(
            name='WimsUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lms_guid', models.CharField(max_length=256, null=True)),
                ('quser', models.CharField(default=None, max_length=256)),
                ('wclass', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsClass')),
            ],
            options={
                'verbose_name_plural': 'WimsUsers',
            },
        ),
        migrations.CreateModel(
            name='WimsSheet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lms_guid', models.CharField(default=None, max_length=256)),
                ('qsheet', models.CharField(default=None, max_length=256, null=True)),
                ('wclass', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsClass')),
            ],
        ),
        migrations.CreateModel(
            name='WimsExam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('lms_guid', models.CharField(default=None, max_length=256)),
                ('qexam', models.CharField(default=None, max_length=256, null=True)),
                ('wclass', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsClass')),
            ],
        ),
        migrations.AddIndex(
            model_name='lms',
            index=models.Index(fields=['key'], name='lti_app_lms_key_544085_idx'),
        ),
        migrations.AddField(
            model_name='gradelinksheet',
            name='activity',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsSheet'),
        ),
        migrations.AddField(
            model_name='gradelinksheet',
            name='lms',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.LMS'),
        ),
        migrations.AddField(
            model_name='gradelinksheet',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsUser'),
        ),
        migrations.AddField(
            model_name='gradelinkexam',
            name='activity',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsExam'),
        ),
        migrations.AddField(
            model_name='gradelinkexam',
            name='lms',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.LMS'),
        ),
        migrations.AddField(
            model_name='gradelinkexam',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='lti_app.WimsUser'),
        ),
        migrations.AlterUniqueTogether(
            name='wimsuser',
            unique_together={('quser', 'wclass')},
        ),
        migrations.AlterUniqueTogether(
            name='wimssheet',
            unique_together={('qsheet', 'wclass')},
        ),
        migrations.AlterUniqueTogether(
            name='wimsexam',
            unique_together={('qexam', 'wclass')},
        ),
        migrations.AlterUniqueTogether(
            name='wimsclass',
            unique_together={('wims', 'qclass'), ('lms', 'lms_guid', 'wims')},
        ),
        migrations.AlterUniqueTogether(
            name='gradelinksheet',
            unique_together={('user', 'activity')},
        ),
        migrations.AlterUniqueTogether(
            name='gradelinkexam',
            unique_together={('user', 'activity')},
        ),
    ]
