% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release.R
\name{release}
\alias{release}
\title{Release package to CRAN.}
\usage{
release(pkg = ".", check = FALSE, args = NULL)
}
\arguments{
\item{pkg}{The package to use, can be a file path to the package or a
package object.  See \code{\link[=as.package]{as.package()}} for more information.}

\item{check}{if \code{TRUE}, run checking, otherwise omit it.  This
is useful if you've just checked your package and you're ready to
release it.}

\item{args}{An optional character vector of additional command
line arguments to be passed to \verb{R CMD build}.}
}
\description{
Run automated and manual tests, then post package to CRAN.
}
\details{
The package release process will:

\itemize{
\item Confirm that the package passes \verb{R CMD check} on relevant platforms
\item Confirm that important files are up-to-date
\item Build the package
\item Submit the package to CRAN, using comments in "cran-comments.md"
}

You can add arbitrary extra questions by defining an (un-exported) function
called \code{release_questions()} that returns a character vector
of additional questions to ask.

You also need to read the CRAN repository policy at
'https://cran.r-project.org/web/packages/policies.html' and make
sure you're in line with the policies. \code{release} tries to automate as
many of polices as possible, but it's impossible to be completely
comprehensive, and they do change in between releases of devtools.
}
\seealso{
\code{\link[usethis:use_release_issue]{usethis::use_release_issue()}} to create a checklist of release
tasks that you can use in addition to or in place of \code{release}.
}
