# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ErrorFieldContract(_serialization.Model):
    """Error Field contract.

    :ivar code: Property level error code.
    :vartype code: str
    :ivar message: Human-readable representation of property-level error.
    :vartype message: str
    :ivar target: Property name.
    :vartype target: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Property level error code.
        :paramtype code: str
        :keyword message: Human-readable representation of property-level error.
        :paramtype message: str
        :keyword target: Property name.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class ErrorResponse(_serialization.Model):
    """Error response indicates Insights service is not able to process the incoming request. The
    reason is provided in the error message.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: Error message indicating why the operation failed.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class Operation(_serialization.Model):
    """CDN REST API operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Cdn.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Cdn.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation


class OperationListResult(_serialization.Model):
    """Result of the request to list CDN operations. It contains a list of operations and a URL link
    to get the next set of results.

    :ivar value: List of CDN operations supported by the CDN resource provider.
    :vartype value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of CDN operations supported by the CDN resource provider.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(_serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[Union[str, "_models.SharedTypeKind"]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
         "shared".
        :paramtype kind: str or
         ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kind = kind
        self.location = location
        self.tags = tags


class Workbook(Resource):
    """An Application Insights workbook definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name. This is GUID value. The display name should be assigned within
     properties field.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :ivar kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar display_name: The user-defined name (display name) of the workbook.
    :vartype display_name: str
    :ivar serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :vartype serialized_data: str
    :ivar time_modified: Date and time in UTC of the last modification that was made to this
     workbook definition.
    :vartype time_modified: str
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar version: Workbook version.
    :vartype version: str
    :ivar tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :vartype tags_properties_tags: list[str]
    :ivar user_id: Unique user id of the specific user that owns this workbook.
    :vartype user_id: str
    :ivar source_id: ResourceId for a source resource.
    :vartype source_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "time_modified": {"readonly": True},
        "user_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "serialized_data": {"key": "properties.serializedData", "type": "str"},
        "time_modified": {"key": "properties.timeModified", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "tags_properties_tags": {"key": "properties.tags", "type": "[str]"},
        "user_id": {"key": "properties.userId", "type": "str"},
        "source_id": {"key": "properties.sourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[Union[str, "_models.SharedTypeKind"]] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        category: Optional[str] = None,
        version: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        source_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
         "shared".
        :paramtype kind: str or
         ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword display_name: The user-defined name (display name) of the workbook.
        :paramtype display_name: str
        :keyword serialized_data: Configuration of this particular workbook. Configuration data is a
         string containing valid JSON.
        :paramtype serialized_data: str
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword version: Workbook version.
        :paramtype version: str
        :keyword tags_properties_tags: A list of 0 or more tags that are associated with this workbook
         definition.
        :paramtype tags_properties_tags: list[str]
        :keyword source_id: ResourceId for a source resource.
        :paramtype source_id: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.display_name = display_name
        self.serialized_data = serialized_data
        self.time_modified = None
        self.category = category
        self.version = version
        self.tags_properties_tags = tags_properties_tags
        self.user_id = None
        self.source_id = source_id


class WorkbookError(_serialization.Model):
    """Error message body that will indicate why the operation failed.

    :ivar code: Service-defined error code. This code serves as a sub-status for the HTTP error
     code specified in the response.
    :vartype code: str
    :ivar message: Human-readable representation of the error.
    :vartype message: str
    :ivar details: The list of invalid fields send in request, in case of validation error.
    :vartype details:
     list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.ErrorFieldContract]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[ErrorFieldContract]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.ErrorFieldContract"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Service-defined error code. This code serves as a sub-status for the HTTP error
         code specified in the response.
        :paramtype code: str
        :keyword message: Human-readable representation of the error.
        :paramtype message: str
        :keyword details: The list of invalid fields send in request, in case of validation error.
        :paramtype details:
         list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.ErrorFieldContract]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class WorkbooksListResult(_serialization.Model):
    """Workbook list result.

    :ivar value: An array of workbooks.
    :vartype value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Workbook]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Workbook]"},
    }

    def __init__(self, *, value: Optional[List["_models.Workbook"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of workbooks.
        :paramtype value: list[~azure.mgmt.applicationinsights.v2018_06_17_preview.models.Workbook]
        """
        super().__init__(**kwargs)
        self.value = value


class WorkbookUpdateParameters(_serialization.Model):
    """The parameters that can be provided when updating workbook properties properties.

    :ivar kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
     "shared".
    :vartype kind: str or ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar display_name: The user-defined name (display name) of the workbook.
    :vartype display_name: str
    :ivar serialized_data: Configuration of this particular workbook. Configuration data is a
     string containing valid JSON.
    :vartype serialized_data: str
    :ivar category: Workbook category, as defined by the user at creation time.
    :vartype category: str
    :ivar tags_properties_tags: A list of 0 or more tags that are associated with this workbook
     definition.
    :vartype tags_properties_tags: list[str]
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "serialized_data": {"key": "properties.serializedData", "type": "str"},
        "category": {"key": "properties.category", "type": "str"},
        "tags_properties_tags": {"key": "properties.tags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.SharedTypeKind"]] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        serialized_data: Optional[str] = None,
        category: Optional[str] = None,
        tags_properties_tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of workbook. Choices are user and shared. Known values are: "user" and
         "shared".
        :paramtype kind: str or
         ~azure.mgmt.applicationinsights.v2018_06_17_preview.models.SharedTypeKind
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword display_name: The user-defined name (display name) of the workbook.
        :paramtype display_name: str
        :keyword serialized_data: Configuration of this particular workbook. Configuration data is a
         string containing valid JSON.
        :paramtype serialized_data: str
        :keyword category: Workbook category, as defined by the user at creation time.
        :paramtype category: str
        :keyword tags_properties_tags: A list of 0 or more tags that are associated with this workbook
         definition.
        :paramtype tags_properties_tags: list[str]
        """
        super().__init__(**kwargs)
        self.kind = kind
        self.tags = tags
        self.display_name = display_name
        self.serialized_data = serialized_data
        self.category = category
        self.tags_properties_tags = tags_properties_tags
