CREATE TABLE test_table (
	id varchar(16) NOT NULL,
	event_name varchar(64) NOT NULL,
	audited_obj_id varchar(16) NOT NULL,
	CONSTRAINT id PRIMARY KEY (id)
);

--
-- Create an index with a long definition (more than BUFSIZE chars, 1024)
--
-- The test doesnot need a verification mechanism, when static memory
-- allocation is used in pgcopydb source code somewhere, then the index
-- definition does not fit and an error is produced, failing the test
-- already.
--

CREATE INDEX idx_test_table_partial ON test_table USING btree (audited_obj_id, id) WHERE ((event_name)::text = ANY (ARRAY[('ds_approve'::character varying)::text, ('ds_revision'::character varying)::text, ('ds_registration'::character varying)::text, ('ds_recovered_to_registration'::character varying)::text, ('ds_revise'::character varying)::text, ('ds_print'::character varying)::text, ('ds_sign'::character varying)::text, ('ds_examination'::character varying)::text, ('ds_examinated'::character varying)::text, ('ds_on_resolution'::character varying)::text, ('ds_execution'::character varying)::text, ('ds_report'::character varying)::text, ('ds_approval'::character varying)::text, ('ds_release_from_control'::character varying)::text, ('ds_archived'::character varying)::text, ('ds_distribution'::character varying)::text, ('ds_registered'::character varying)::text, ('ds_committee'::character varying)::text, ('ds_overdue'::character varying)::text, ('ds_internal_signature'::character varying)::text, ('ds_agent_signature'::character varying)::text, ('ds_registration_cso'::character varying)::text, ('ds_claim_nsi_execution_control'::character varying)::text, ('ds_claim_tech_execution_control'::character varying)::text, ('ds_approve_revision'::character varying)::text, ('ds_expire'::character varying)::text, ('ds_archive_init'::character varying)::text, ('ds_recalled_to_revision'::character varying)::text, ('ds_identity_confirmation'::character varying)::text, ('ds_check_design'::character varying)::text, ('ds_nomenclatured'::character varying)::text, ('ds_return_to_office'::character varying)::text, ('ds_nomenclature_init'::character varying)::text, ('ds_change_ctrl_stage_exec_date'::character varying)::text, ('ds_terminate_execution'::character varying)::text, ('ds_resume_to_execution'::character varying)::text, ('ds_create'::character varying)::text, ('ds_agenda_vote'::character varying)::text, ('ds_agenda_vote_finish'::character varying)::text, ('ds_claim_tech_set_curator'::character varying)::text, ('ds_claim_tech_old_curator'::character varying)::text, ('ds_claim_tech_change_ztp'::character varying)::text, ('ds_revert_archived'::character varying)::text, ('ds_setup_dsdt_ext_examination_date'::character varying)::text, ('ds_change_dsdt_ext_examination_date'::character varying)::text, ('ds_change_approve_stage'::character varying)::text, ('ds_add_ctrl_stage'::character varying)::text, ('ds_edit_ctrl_stage'::character varying)::text, ('ds_simple_int_signature'::character varying)::text, ('ds_simple_int_signature_revision'::character varying)::text, ('ds_simple_agent_signature_send'::character varying)::text, ('ds_simple_agent_signature'::character varying)::text, ('ds_simple_agent_signature_revision'::character varying)::text, ('ds_simple_print'::character varying)::text, ('ds_simple_print_revision'::character varying)::text, ('ds_simple_registration'::character varying)::text, ('ds_simple_registration_revision'::character varying)::text, ('ds_publication'::character varying)::text, ('ds_has_document_approval'::character varying)::text, ('ds_agenda_additional_vote'::character varying)::text, ('ds_approve_with_curator_approve'::character varying)::text, ('ds_approve_with_curator_revision'::character varying)::text, ('ds_pause_auto_approve'::character varying)::text, ('ds_resume_auto_approve'::character varying)::text, ('ds_increase_approve_period'::character varying)::text, ('ds_remove_approve_stage'::character varying)::text, ('ds_remove_approver'::character varying)::text, ('ds_vote_finish'::character varying)::text, ('ds_wait_document'::character varying)::text, ('ds_simple_signature'::character varying)::text, ('ds_simple_signature_revision'::character varying)::text, ('ds_attachment_original'::character varying)::text, ('ds_attach_original'::character varying)::text, ('ds_attachment_protocol'::character varying)::text, ('ds_remove_signer'::character varying)::text, ('ds_organization_of_signing'::character varying)::text, ('ds_send_to_mrmr'::character varying)::text, ('ds_sent_to_bik'::character varying)::text, ('ds_received_from_bik'::character varying)::text, ('ds_identity_confirmation_revision'::character varying)::text, ('ds_remove_inside'::character varying)::text, ('ds_replace_content'::character varying)::text, ('ds_add_question'::character varying)::text, ('ds_remove_question'::character varying)::text, ('ds_edit'::character varying)::text, ('ds_change_addressee'::character varying)::text, ('ds_delegation_delegated'::character varying)::text, ('ds_delegation_accepted'::character varying)::text, ('ds_add_attachment'::character varying)::text, ('ds_remove_attachment'::character varying)::text, ('ds_send_to_upp'::character varying)::text, ('ds_barcode_send_to_upp'::character varying)::text, ('ds_change_from_upp'::character varying)::text, ('ds_usd_deleted'::character varying)::text, ('ds_add_connected_document'::character varying)::text, ('ds_remove_connected_document'::character varying)::text, ('ds_send_to_akesd'::character varying)::text, ('ds_akesd_deleted'::character varying)::text, ('ds_change_from_akesd'::character varying)::text, ('ds_replace_attachment'::character varying)::text, ('ds_clear_attach_original_attr'::character varying)::text, ('ds_add_attachstructure'::character varying)::text, ('ds_remove_attachstructure'::character varying)::text, ('ds_remove_comment'::character varying)::text, ('ds_set_vote_results'::character varying)::text, ('ds_interrupt_approve'::character varying)::text, ('ds_stage_users_changed'::character varying)::text, ('ds_annulment'::character varying)::text, ('ds_revoke_annulment'::character varying)::text, ('Distribution'::character varying)::text]));
