## Luxon

Luxon is a library for dealing with dates and times in JavaScript.

```js
DateTime.now().setZone('America/New_York').minus({weeks:1}).endOf('day').toISO();
```

### Features

 * A nice API for working with datetimes
 * Interval support (from time x to time y)
 * Duration support (14 days, 5 minutes, 33 seconds)
 * [Parsing](parsing.md) and [Formatting](formatting.md) datetimes, intervals, and durations
 * [Internationalization](intl.md) of strings using the Intl API
 * Detailed and unambiguous [math](math.md) operations
 * Built-in handling of [time zones](zones.md)
 * Partial support for multiple [calendar systems](calendars.md)
 
 For more, see the docs on the left, including the  [api docs](api-docs/index.html ':ignore')
 
### Getting started
 
  * [Demo](https://moment.github.io/luxon/demo/global.html ':ignore')
  * Read the [quick tour](tour.md)
  * Browse the topic docs on the left
  * Read the [api docs](api-docs/index.html ':ignore')

Logo by [John Dalziel](https://github.com/crashposition)
