# About the Contributor License Agreement

Everybody who contributes code to MetPy is going to be asked to sign a
Contributor License Agreement (CLA). MetPy's CLA comes from
[Project Harmony](http://www.harmonyagreements.org), which is a
community-centered group focused on contributor agreements for free and open
source software.

The document you are reading now is not a legal analysis of the CLA. If you
want one of those, please talk to your lawyer. This is a description of the
purpose of the CLA.

## Frequently Asked Questions (FAQ)

### Why is a signed CLA required?

The license agreement is a legal document in which you state you are entitled to
contribute the code/documentation to MetPy and are willing to have it used in
distributions and derivative works. This means that should there be any kind of
legal issue in the future as to the origins and ownership of any particular
piece of code, we have the necessary forms on file from the contributor(s)
saying they were permitted to make this contribution.

The CLA also ensures that once you have provided a contribution, you cannot try
to withdraw permission for its use at a later date. People and companies can
therefore use MetPy, confident that they will not be asked to stop using pieces
of the code at a later date.

Lastly, the CLA gives the MetPy project permission to change the license under
which the project, including the various contributions from many developers, is
distributed in the future. The CLA states that this license needs to be one
that has been approved by the Open Source Initiative, including both copyleft
and permissive licenses. This just gives the freedom to adjust licenses in the
future if needed (e.g. some clause of the current license is found to be invalid).

### Am I giving away the copyright to my contributions?

No. This is a pure license agreement, not a copyright assignment. You still
maintain the full copyright for your contributions. You are only providing a
license to MetPy to distribute your code without further restrictions. This is
not the case for all CLA's, but it is the case for the one we are using.

### What about if I do MetPy development as part of my job?

If any of your contributions to MetPy are created as part of your employment by
somebody else, the work might not actually belong to you. It may be owned by
your employer. In that case, your employer, or somebody able to represent the
company as far as licensing goes, needs to sign the corporate version of the
Contributor Licensing Agreement in order for that contribution to be accepted
into MetPy. They will need to include the names of any developers (you and any
others covered by that agreement) who are able to submit contributions on
behalf of the employer. That list can be updated as new people are employed or
others leave.

You should also still sign an individual CLA in that case. Not all the work you
do will necessarily belong to your employer and we still need permission to
license your individual contributions.

If you have signed an individual CLA, but not a corporate one, be very careful
about submitting contributions you have made. We cannot accept anything that you
do not have the rights to license in the first place and that includes code that
belongs to your employer. Similarly, if you are a consultant who may be creating
MetPy patches as part of a job, make sure you and your employer understand who
owns the rights to the code. Only submit things that you are entitled to. The
CLA is a legal declaration by you that you have the right to grant such a
license for your contributions. It is up to you to make sure that is true.

### Can I withdraw permission to use my contributions at a later date?

No. This is one of the reasons we require a CLA. No individual contributor can hold
such a threat over the entire community of users. Once you make a contribution, you
are saying we can use that piece of code forever.

### Can I submit patches without having signed the CLA?

No. We will be asking all new contributors and patch submitters to sign before
they submit anything.

Based on material Copyright Django Software Foundation. [CC-BY](http://creativecommons.org/licenses/by/3.0/us/)
Modified slightly to reflect MetPy.

## UCAR/Unidata Individual Contributor License Agreement

Thank you for your interest in contributing to UCAR/Unidata ("We" or "Us"). This contributor
agreement ("Agreement") documents the rights granted by contributors to Us. To make this
document effective, please sign it and send it to Us by electronic submission on
https://cla-assistant.io. This is a legally binding document, so please read it carefully
before agreeing to it. The Agreement may cover more than one software project managed by Us.

(1) Definitions

"You" means the individual who Submits a Contribution to Us.

"Contribution" means any work of authorship that is Submitted by You to Us in which You own or
assert ownership of the Copyright.

"Copyright" means all rights protecting works of authorship owned or controlled by You,
including copyright, moral and neighboring rights, as appropriate, for the full term of their
existence including any extensions by You.

"Material" means the work of authorship which is made available by Us to third parties. When
this Agreement covers more than one software project, the Material means the work of authorship
to which the Contribution was Submitted. After You Submit the Contribution, it may be included
in the Material.

"Submit" means any form of electronic, verbal, or written communication sent to Us or our
representatives, including but not limited to electronic mailing lists, source code control
systems, and issue tracking systems that are managed by, or on behalf of, Us for the purpose of
discussing and improving the Material, but excluding communication that is conspicuously marked
or otherwise designated in writing by You as "Not a Contribution."

"Submission Date" means the date on which You Submit a Contribution to Us.

"Effective Date" means the date You execute this Agreement or the date You first Submit a
Contribution to Us, whichever is earlier.

(2) Grant of Rights

(2.1) Copyright License

(a) You retain ownership of the Copyright in Your Contribution and have the same rights to use
or license the Contribution which You would have had without entering into the Agreement.

(b) To the maximum extent permitted by the relevant law, You grant to Us a perpetual,
worldwide, non-exclusive, transferable, royalty-free, irrevocable license under the Copyright
covering the Contribution, with the right to sublicense such rights through multiple tiers of
sublicensees, to reproduce, modify, display, perform and distribute the Contribution as part of
the Material; provided that this license is conditioned upon compliance with Section 2.3.

(2.2) Patent License

For patent claims including, without limitation, method, process, and apparatus claims which
You own, control or have the right to grant, now or in the future, You grant to Us a perpetual,
worldwide, non-exclusive, transferable, royalty-free, irrevocable patent license, with the
right to sublicense these rights to multiple tiers of sublicensees, to make, have made, use,
sell, offer for sale, import and otherwise transfer the Contribution and the Contribution in
combination with the Material (and portions of such combination). This license is granted only
to the extent that the exercise of the licensed rights infringes such patent claims; and
provided that this license is conditioned upon compliance with Section 2.3.

(2.3) Outbound License

As a condition on the grant of rights in Sections 2.1 and 2.2, We agree to license the
Contribution only under the terms of the license or licenses which We are using on the
Submission Date for the Material or any licenses which are approved by the Open Source
Initiative on or after the Effective Date, including both permissive and copyleft licenses,
whether or not such licenses are subsequently disapproved (including any right to adopt any
future version of a license if permitted).

(2.4) Moral Rights. If moral rights apply to the Contribution, to the maximum extent permitted by
law, You waive and agree not to assert such moral rights against Us or our successors in
interest, or any of our licensees, either direct or indirect.

(2.5) Our Rights. You acknowledge that We are not obligated to use Your Contribution as part of
the Material and may decide to include any Contribution We consider appropriate.

(2.6) Reservation of Rights. Any rights not expressly licensed under this section are expressly
reserved by You.

(3) Agreement

You confirm that:

(a) You have the legal authority to enter into this Agreement.

(b) You own the Copyright and patent claims covering the Contribution which are required to
grant the rights under Section 2.

(c) The grant of rights under Section 2 does not violate any grant of rights which You have
made to third parties, including Your employer. If You are an employee, You have had Your
employer approve this Agreement or sign the Entity version of this document. If You are less
than eighteen years old, please have Your parents or guardian sign the Agreement.

(4) Disclaimer

EXCEPT FOR THE EXPRESS WARRANTIES IN SECTION 3, THE CONTRIBUTION IS PROVIDED "AS IS". MORE
PARTICULARLY, ALL EXPRESS OR IMPLIED WARRANTIES INCLUDING, WITHOUT LIMITATION, ANY IMPLIED
WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
EXPRESSLY DISCLAIMED BY YOU TO US. TO THE EXTENT THAT ANY SUCH WARRANTIES CANNOT BE DISCLAIMED,
SUCH WARRANTY IS LIMITED IN DURATION TO THE MINIMUM PERIOD PERMITTED BY LAW.

(5) Consequential Damage Waiver

TO THE MAXIMUM EXTENT PERMITTED BY APPLICABLE LAW, IN NO EVENT WILL YOU BE LIABLE FOR ANY LOSS
OF PROFITS, LOSS OF ANTICIPATED SAVINGS, LOSS OF DATA, INDIRECT, SPECIAL, INCIDENTAL,
CONSEQUENTIAL AND EXEMPLARY DAMAGES ARISING OUT OF THIS AGREEMENT REGARDLESS OF THE LEGAL OR
EQUITABLE THEORY (CONTRACT, TORT OR OTHERWISE) UPON WHICH THE CLAIM IS BASED.

(6) Miscellaneous

(6.1) This Agreement will be governed by and construed in accordance with the laws of the state
of Colorado, excluding its conflicts of law provisions. Under certain circumstances, the
governing law in this section might be superseded by the United Nations Convention on Contracts
for the International Sale of Goods ("UN Convention") and the parties intend to avoid the
application of the UN Convention to this Agreement and, thus, exclude the application of the UN
Convention in its entirety to this Agreement.

(6.2) This Agreement sets out the entire agreement between You and Us for Your Contributions to
Us and overrides all other agreements or understandings.

(6.3) If You or We assign the rights or obligations received through this Agreement to a third
party, as a condition of the assignment, that third party must agree in writing to abide by all
the rights and obligations in the Agreement.

(6.4) The failure of either party to require performance by the other party of any provision of
this Agreement in one situation shall not affect the right of a party to require such
performance at any time in the future. A waiver of performance under a provision in one
situation shall not be considered a waiver of the performance of the provision in the future or
a waiver of the provision in its entirety.

(6.5) If any provision of this Agreement is found void and unenforceable, such provision will
be replaced to the extent possible with a provision that comes closest to the meaning of the
original provision and which is enforceable. The terms and conditions set forth in this
Agreement shall apply notwithstanding any failure of essential purpose of this Agreement or any
limited remedy to the maximum extent possible under law.

Harmony (HA-CLA-I-OSI) Version 1.0
