/**
 * Copyright (c) 2013-2016 Jens Deters http://www.jensd.de
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 */
package de.jensd.fx.glyphs.octicons;

import de.jensd.fx.glyphs.GlyphIcons;

/**
 *
 * Icon Enum based on GitHub Octicons v3.3.0
 *
 * @author Jens Deters (mail@jensd.de)
 * @author Naoghuman (https://github.com/Naoghuman)
 */
public enum OctIcon implements GlyphIcons {

    ALERT("\uf02D"),
    ARROW_DOWN("\uf03F"),
    ARROW_LEFT("\uf040"),
    ARROW_RIGHT("\uf03E"),
    ARROW_SMALL_DOWN("\uf0A0"),
    ARROW_SMALL_LEFT("\uf0A1"),
    ARROW_SMALL_RIGHT("\uf071"),
    ARROW_SMALL_UP("\uf09F"),
    ARROW_UP("\uf03D"),
    BEAKER("\uf0DD"),
    BELL("\uf0DE"),
    BOLD("\uf0E2"),
    BOOK("\uf007"),
    BOOKMARK("\uf07B"),
    BRIEFCASE("\uf0D3"),
    BROADCAST("\uf048"),
    BROWSER("\uf0C5"),
    BUG("\uf091"),
    CALENDAR("\uf068"),
    CHECK("\uf03A"),
    CHECKLIST("\uf076"),
    CHEVRON_DOWN("\uf0A3"),
    CHEVRON_LEFT("\uf0A4"),
    CHEVRON_RIGHT("\uf078"),
    CHEVRON_UP("\uf0A2"),
    CIRCLE_SLASH("\uf084"),
    CIRCUIT_BOARD("\uf0D6"),
    CLIPPY("\uf035"),
    CLOCK("\uf046"),
    CLOUD_DOWNLOAD("\uf00B"),
    CLOUD_UPLOAD("\uf00C"),
    CODE("\uf05F"),
    COMMENT("\uf02B"),
    COMMENT_DISCUSSION("\uf04F"),
    CREDIT_CARD("\uf045"),
    DASH("\uf0CA"),
    DASHBOARD("\uf07D"),
    DATABASE("\uf096"),
    DESKTOP_DOWNLOAD("\uf0DC"),
    DEVICE_CAMERA("\uf056"),
    DEVICE_CAMERA_VIDEO("\uf057"),
    DEVICE_DESKTOP("\uf27C"),
    DEVICE_MOBILE("\uf038"),
    DIFF("\uf04D"),
    DIFF_ADDED("\uf06B"),
    DIFF_IGNORED("\uf099"),
    DIFF_MODIFIED("\uf06D"),
    DIFF_REMOVED("\uf06C"),
    DIFF_RENAMED("\uf06E"),
    ELLIPSES("\uf101"),
    ELLIPSIS("\uf09A"),
    EYE("\uf04E"),
    FILE("\uf102"),
    FILE_BINARY("\uf094"),
    FILE_CODE("\uf010"),
    FILE_DIRECTORY("\uf016"),
    FILE_MEDIA("\uf012"),
    FILE_PDF("\uf014"),
    FILE_SUBMODULE("\uf017"),
    FILE_SYMLINK_DIRECTORY("\uf0B1"),
    FILE_SYMLINK_FILE("\uf0B0"),
    FILE_TEXT("\uf011"),
    FILE_ZIP("\uf013"),
    FLAME("\uf0D2"),
    FOLD("\uf0CC"),
    GEAR("\uf02F"),
    GIFT("\uf042"),
    GIST("\uf00E"),
    GIST_SECRET("\uf08C"),
    GIT_BRANCH("\uf020"),
    GIT_COMMIT("\uf01F"),
    GIT_COMPARE("\uf0AC"),
    GIT_MERGE("\uf023"),
    GIT_PULL_REQUEST("\uf009"),
    GLOBE("\uf0B6"),
    GRABBER("\uf103"),
    GRAPH("\uf043"),
    HEART("\u2665"),
    HISTORY("\uf07E"),
    HOME("\uf08D"),
    HORIZONTAL_RULE("\uf070"),
    HUBOT("\uf09D"),
    INBOX("\uf0CF"),
    INFO("\uf059"),
    ISSUE_CLOSED("\uf028"),
    ISSUE_OPENED("\uf026"),
    ISSUE_REOPENED("\uf027"),
    ITALIC("\uf0E4"),
    JERSEY("\uf019"),
    KEY("\uf049"),
    KEYBOARD("\uf00D"),
    LAW("\uf0D8"),
    LIGHT_BULB("\uf000"),
    LINK("\uf05C"),
    LINK_EXTERNAL("\uf07F"),
    LIST_ORDERED("\uf062"),
    LIST_UNORDERED("\uf061"),
    LOCATION("\uf060"),
    LOCK("\uf06A"),
    LOGO_GIST("\uf0AD"),
    LOGO_GITHUB("\uf092"),
    MAIL("\uf03B"),
    MAIL_READ("\uf03C"),
    MAIL_REPLY("\uf051"),
    MARK_GITHUB("\uf00A"),
    MARKDOWN("\uf0C9"),
    MEGAPHONE("\uf077"),
    MENTION("\uf0BE"),
    MILESTONE("\uf075"),
    MIRROR("\uf024"),
    MORTAR_BOARD("\uf0D7"),
    MUTE("\uf080"),
    NO_NEWLINE("\uf09C"),
    OCTOFACE("\uf008"),
    ORGANIZATION("\uf037"),
    PACKAGE("\uf0C4"),
    PAINTCAN("\uf0D1"),
    PENCIL("\uf058"),
    PERSON("\uf018"),
    PIN("\uf041"),
    PLUG("\uf0D4"),
    PLUS("\uf05D"),
    PLUS_SMALL("\uf104"),
    PRIMITIVE_DOT("\uf052"),
    PRIMITIVE_SQUARE("\uf053"),
    PULSE("\uf085"),
    QUESTION("\uf02C"),
    QUOTE("\uf063"),
    RADIO_TOWER("\uf030"),
    REPLY("\uf105"),
    REPO("\uf001"),
    REPO_CLONE("\uf04C"),
    REPO_FORCE_PUSH("\uf04A"),
    REPO_FORKED("\uf002"),
    REPO_PULL("\uf006"),
    REPO_PUSH("\uf005"),
    ROCKET("\uf033"),
    RSS("\uf034"),
    RUBY("\uf047"),
    SEARCH("\uf02E"),
    SERVER("\uf097"),
    SETTINGS("\uf07C"),
    SHIELD("\uf0E1"),
    SIGN_IN("\uf036"),
    SIGN_OUT("\uf032"),
    SMILEY("\uf0E7"),
    SQUIRREL("\uf0B2"),
    STAR("\uf02A"),
    STOP("\uf08F"),
    SYNC("\uf087"),
    TAG("\uf015"),
    TASKLIST("\uf0E5"),
    TELESCOPE("\uf088"),
    TERMINAL("\uf0C8"),
    TEXT_SIZE("\uf0E3"),
    THREE_BARS("\uf05E"),
    THUMBSDOWN("\uf0DB"),
    THUMBSUP("\uf0DA"),
    TOOLS("\uf031"),
    TRASHCAN("\uf0D0"),
    TRIANGLE_DOWN("\uf05B"),
    TRIANGLE_LEFT("\uf044"),
    TRIANGLE_RIGHT("\uf05A"),
    TRIANGLE_UP("\uf0AA"),
    UNFOLD("\uf039"),
    UNMUTE("\uf0BA"),
    UNVERIFIED("\uf0E8"),
    VERIFIED("\uf0E6"),
    VERSIONS("\uf064"),
    WATCH("\uf0E0"),
    X("\uf081"),
    ZAP("\u26A1");

    private final String unicode;

    private OctIcon(String unicode) {
        this.unicode = unicode;
    }

    @Override
    public String unicode() {
        return unicode;
    }

    @Override
    public String fontFamily() {
        return "\'Octicons\'";
    }
}
