/*
 * Copyright (C) 1999 Jonathan R. Hudson
 * Developed by Jonathan R. Hudson <jonathan@daria.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

// Example to show VDKInputChannel, multiple input streams, 
// user defined VDKsignals, interaction with Unix signals etc

#define _GNU_SOURCE

#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>
#include <ctime>
#include <fstream>
#include <sys/socket.h>
#include "Socket.h"
#include "iodemo2.h"


#define MYIOSIGNAL (user_signal+42)

DEFINE_SIGNAL_MAP(MyForm,VDKForm)
    ON_SIGNAL(inp1,INPUT_SIGNAL,DoIO),
    ON_SIGNAL(text, realize_signal,runcmd),
    ON_SIGNAL(entry, activate_signal,sendstuff),
    ON_SIGNAL(timer,timer_tick_signal,Quit),
    ON_SIGNAL(quit,clicked_signal,Quit)
END_SIGNAL_MAP       
DEFINE_SIGNAL_LIST(MyForm,VDKForm);

bool MyForm::sendstuff(VDKObject* obj)
{
    char txt[1024];
    char *t;
    
    strcpy(txt, entry->GetText());
    t = txt+strlen(txt);
    *t++ = '\n';
    *t = 0;
    
    sock->Send(txt, (t - txt));

    entry->SetText("");
    return true;
}


bool MyForm::CanClose(void)
{
    return Stop(0);
}

bool MyForm::Stop (VDKObject *obj)    
{
    return true;
}
       

bool MyForm::DoIO (VDKObject *obj)
{
    VDKInputChannel *ip = static_cast<VDKInputChannel*>(obj);
    int res;
    char buf[1024];
        
    res = sock->Recv (buf, sizeof(buf));
    
    if(res > 0)
    {
        text->TextInsert(buf, res);
    }
    else
    {
        sock->Close();
        ShowInfanticide();
        ip->Destroy();
    }
    return true;
}

void MyForm::ShowInfanticide()
{
    SignalEmit("KillSignal");
}

bool MyForm::runcmd(VDKObject *obj)
{
    MyApp *a = static_cast<MyApp *>(Application());

    sock = new Socket(a->args[0], a->args[1]);
    if(sock->getfd() == -1) 
    {
        perror("socket");
        exit(1);
    }
    if(sock->Connect() == -1)
    {
        perror("connect");
        exit(1);
    }

    inp1 = new VDKInputChannel(this, sock->getfd(), GDK_INPUT_READ);
    text->Clear();
    return true;
}

bool MyForm:: Quit(VDKObject*o)
{
    Application()->Terminate();
    return true;
}

void MyForm::Setup(void)
{
    VDKBox* vbox1 = new VDKBox(this, v_box);
    VDKFrame* frame1 = new VDKFrame(this, "You type here");
    VDKFrame* frame2 = new VDKFrame(this, "Networked friend");

    // Just to show user signals ....
    SignalConnect("KillSignal",&MyForm::Mourn, false);

    VDKBox* hbox1 = new VDKBox(this, h_box);
    vbox1->Add(frame1);
    vbox1->Add(frame2);    

    vbox1->Add(hbox1,c_justify, 0, 0);
    hbox1->Add((quit = new VDKLabelButton(this,"Quit")),
               c_justify, 1, 0);
    entry = new VDKEntry(this, 0);
    entry->Font = new VDKFont(this,
             "-*-lucidatypewriter-medium-r-normal-*-*-120-*-*-*-*-iso8859-1");
    frame1->Add(entry);    
    text = new VDKText(this, 0);
    text->Font = new VDKFont(this,
             "-*-lucidatypewriter-medium-r-normal-*-*-120-*-*-*-*-iso8859-1");
    frame2->Add(text);    
    Add(vbox1);    
    SetSize(500,-1);
    entry->GrabFocus();

}

bool MyForm::Mourn(VDKObject *)
{
  
    if(timer == 0)
    {
        timer = new VDKTimer(this, 30*1000);
    }

    text->TextInsert("\nPress Quit to exit(or wait 30 seconds)\n");
    return true;
}


// This is a static member so we can access class members
// Somewhat contrived example

void MyApp::plumber(int)
{
    cerr << "Broken pipe ... " << endl;
}

void MyApp::Setup()   
{
    if(*(args) == 0 || *(args+1) == 0)
    {
        cerr << "Usage iodemo2 tcp|udp host:port|file";
        exit(0);
    }
    
    MainForm = new MyForm(this,"iodemo2 ...");
    MyApp::me = this;
    
    struct sigaction *sac = new struct sigaction;

    sigemptyset(&(sac->sa_mask));
    sac->sa_flags=0;
    sac->sa_handler = MyApp::plumber;
    sigaction(SIGPIPE, sac, NULL);  

    MainForm->Setup();       
    MainForm->Show();
}

MyApp *MyApp::me;
int main (int argc, char *argv[])   
{
    MyApp app(&argc, argv); 
    app.Run();      
    return 0;  
}

