/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.lang.reflect.Method;
import java.util.Vector;
import net.tinyos.message.Message;

public class DataModel {
    Vector packetClasses = new Vector();
    Vector fields = new Vector();
    Vector links = new Vector();

    public DataModel(Vector vector) {
        this.createPackets(vector);
        this.parseFieldsAndLinks();
    }

    public Vector fields() {
        return this.fields;
    }

    public Vector links() {
        return this.links;
    }

    private void createPackets(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            try {
                System.out.println("Making " + vector.elementAt(i));
                Class<?> clazz = Class.forName((String)vector.elementAt(i));
                this.packetClasses.add(clazz);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Unable to find message type " + vector.elementAt(i) + ": please check your CLASSPATH.");
            }
        }
    }

    private boolean isSubClass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return false;
        }
        for (Class clazz3 = clazz.getSuperclass(); clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (!clazz3.equals(clazz2)) continue;
            return true;
        }
        return false;
    }

    private void parseFieldsAndLinks() {
        Message message = new Message(0);
        Class<?> clazz = message.getClass();
        for (int i = 0; i < this.packetClasses.size(); ++i) {
            Class clazz2 = (Class)this.packetClasses.elementAt(i);
            if (!this.isSubClass(clazz2, clazz)) continue;
            this.loadFieldsAndLinks(clazz2);
        }
    }

    private void loadFieldsAndLinks(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Class<?>[] classArray;
            Method method = methodArray[i];
            String string = method.getName();
            if (string.startsWith("get_") && !string.startsWith("get_link")) {
                string = string.substring(4);
                classArray = method.getParameterTypes();
                if (classArray.length != 0 || method.getReturnType().isArray()) continue;
                this.loadField(string, method, method.getReturnType());
                System.out.println("Loading " + string);
                continue;
            }
            if (!string.startsWith("get_link_") || !string.endsWith("_value")) continue;
            string = string.substring(9);
            string = string.substring(0, string.length() - 6);
            classArray = method.getParameterTypes();
            if (classArray.length != 0) continue;
            this.loadLink(string, method, method.getReturnType());
        }
    }

    private void loadField(String string, Method method, Class clazz) {
        this.fields.add(string);
    }

    private void loadLink(String string, Method method, Class clazz) {
        System.out.println("Loading link <" + string + ">");
        this.links.add(string);
    }
}

