/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_APR_ERROR_H
#define _SC_UTIL_APR_ERROR_H

// sc
#include "String.h"
namespace sc {
  class Error;
}

// apr
#include <apr_errno.h>


namespace apr
{

/** get error text for @a status. */
sc::String strError( apr_status_t status );

/** create an error from @a status and @a msg. */
const sc::Error* createError( apr_status_t status );

} // namespace


/** macro for creating an apr error. */
#define APR_ERR(status)\
{\
  if( status != APR_SUCCESS )\
  {\
  return apr::createError(status);\
  }\
}

#endif // _SC_UTIL_APR_ERROR_H

