/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PAINTLINE_H
#define _PAINTLINE_H

// sc
#include "util/String.h"


class PaintLine
{
public:
  ~PaintLine()
  {
    delete [] _kind;
  }

  enum Kind
  {
    End,
    Character,
    CharacterHL,        ///< highlighted
    Whitespace,
    WhitespaceHL,       ///< highlighted
  };

  const sc::String& getSource() const
  {
    return _src;
  }

  const sc::String& getPaint() const
  {
    return _paint;
  }

  const Kind* getKind() const
  {
    return _kind;
  }

private:
  PaintLine( const sc::String& src, const sc::String& paint, Kind* kind )
    : _src(src), _paint(paint), _kind(kind)
  {
  }

private:
  sc::String  _src;
  sc::String  _paint;
  Kind*       _kind;

  friend class PaintLineFactory;
};

#endif // _PAINTLINE_H
