/* ====================================================================
 * Copyright (c) 2006, 2008-2009  Martin Hauner
 *                                http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "WcViewViewState.h"
#include "Bookmark.h"

// sys
#include <cassert>


WcViewViewState::WcViewViewState( Bookmark* bm )
: _bm(bm), _all(false), _updates(false), _pathPos(0), _type(
  WcViewTypeNone)
{
  addPath( bm->getSource() );
  _filter = TextStatusFilter::getDefaultFilter();
}

void WcViewViewState::setExpanded( const sc::String& name, bool expanded )
{
  WcViewExpandedItems::iterator it = _itemExpanded.find(name);

  if( it != _itemExpanded.end() )
  {
    (*it).second = expanded;
  }
  else
  {
    _itemExpanded.insert( WcViewExpandedItems::value_type(name,expanded) );
  }
}

bool WcViewViewState::isExpanded( const sc::String& name )
{
  WcViewExpandedItems::iterator it = _itemExpanded.find(name);
  if( it != _itemExpanded.end() )
  {
    return (*it).second;
  }
  else
  {
    return false;
  }
}

void WcViewViewState::clearSelected()
{
  _itemSelected.clear();
}

void WcViewViewState::setSelected( const sc::String& name, bool selected )
{
  WcViewSelectedItems::iterator it = _itemSelected.find(name);

  if( it != _itemSelected.end() )
  {
    (*it).second = selected;
  }
  else
  {
    _itemSelected.insert( WcViewSelectedItems::value_type(name,selected) );
  }
}

bool WcViewViewState::isSelected( const sc::String& name )
{
  WcViewExpandedItems::iterator it = _itemSelected.find(name);
  if( it != _itemSelected.end() )
  {
    return (*it).second;
  }
  else
  {
    return false;
  }
}

void WcViewViewState::getPrevPathHistory( PathHistory& history )
{
  for( int i = _pathPos-1; i >= 0; i-- )
  {
    history.push_back( _pathHistory[i] );
  }
}

void WcViewViewState::getNextPathHistory( PathHistory& history )
{
  for( size_t i = _pathPos+1; i < _pathHistory.size(); i++ )
  {
    history.push_back( _pathHistory[i] );
  }
}

void WcViewViewState::prevPath()
{
  prevPath(1);
}

void WcViewViewState::nextPath()
{
  nextPath(1);
}

void WcViewViewState::prevPath( int cnt )
{
  if( _pathPos-cnt >= 0 )
    _pathPos -= cnt;

  if( _pathPos < _pathHistory.size() )
  {
    emit currentChanged( _pathHistory[_pathPos] );
    emit historyChanged();
  }
}

void WcViewViewState::nextPath( int cnt )
{
  if( _pathPos+cnt < _pathHistory.size() )
    _pathPos += cnt;

  if( _pathPos < _pathHistory.size() )
  {
    emit currentChanged( _pathHistory[_pathPos] );
    emit historyChanged();
  }
}

const sc::String& WcViewViewState::getPath()
{
  return _pathHistory[_pathPos];
}

void WcViewViewState::addPath( const sc::String& path )
{
  if( _pathPos+1 < _pathHistory.size() )
  {
    _pathHistory.resize(_pathPos+1);
  }

  _pathHistory.push_back(path);
  _pathPos = (unsigned int)_pathHistory.size() - 1;

  emit historyChanged();
}

bool WcViewViewState::getViewAll()
{
  return _all;
}

bool WcViewViewState::getViewUpdates()
{
  return _updates;
}

WcViewType WcViewViewState::getType()
{
  return _type;
}

void WcViewViewState::setViewHeader( const sc::String& header )
{
  _bm->setViewHeader(header);
}

sc::String WcViewViewState::getViewHeader()
{
  return _bm->getViewHeader();
}

bool WcViewViewState::isFlat() const
{
  return _type == WcViewTypeFlat;
}

bool WcViewViewState::isTree() const
{
  return _type == WcViewTypeTree;
}

void WcViewViewState::setViewAll( bool on )
{
  _all = on;
  emit optionsChanged();
}

void WcViewViewState::setViewUpdates( bool on )
{
  _updates = on;
  emit optionsChanged();
}

void WcViewViewState::setType( WcViewType type )
{
  _type = type;
  //emit optionsChanged();
}

TextStatusFilter WcViewViewState::getTextStatusFilter() const
{
  return _filter;
}

void WcViewViewState::setTextStatusFilter( const TextStatusFilter&
  filter )
{
  _filter = filter;
}
