/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UPDATEDIALOG_H
#define _SC_UPDATEDIALOG_H

// sc
class RevisionWidget;
class ExternProvider;
class ExternButton;
namespace svn
{
  class Revision;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;


class UpdateDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  UpdateDialog( ExternProvider* p, bool recurse, QWidget *parent = 0 );
  virtual ~UpdateDialog();

  void enableWorkingCopyPath( bool enable );

  QString getWorkingCopyPath();
  void setWorkingCopyPath( QString& path );

  svn::Revision* getRevision();
  bool isRecursive();

public slots:
  void selectWcPath();
  void checkOk( const QString& text );

private:
  RevisionWidget* _rw;

  QCheckBox*      _recurse;
  QComboBox*      _wc;
  ExternButton*   _wcEx;

  QPushButton*    _ok;
  QPushButton*    _ca;

  ExternProvider* _p;
};

#endif // _SC_UPDATEDIALOG_H
