use strict;
#use Test::More tests => 34;
use Test::More qw(no_plan);

use English;
use RoPkg::Exceptions;

use warnings;
use strict;

BEGIN {
  use_ok('RoPkg::Simba::Command');
  use_ok('RoPkg::Simba::Commands');
  use_ok('RoPkg::Simba::Exceptions');
  use_ok('RoPkg::Simba::Exclude');
  use_ok('RoPkg::Simba::Excludes');
  use_ok('RoPkg::Simba::Mirror');
  use_ok('RoPkg::Simba::Mirrors');
  use_ok('RoPkg::Simba');

  #plugins
  use_ok('RoPkg::Simba::Plugin::GenHTML');
  use_ok('RoPkg::Simba::Plugin::GenRSS');
  use_ok('RoPkg::Simba::Plugin::GenSitemap');
}

######
#test no config file parameter given
######
eval {
  my $simba = new RoPkg::Simba();
};

if ( Exception::Class->caught('Param::Missing') ) {
  ok(1, 'new RoPkg::Simba() throws Param::Missing - ok');
}
else {
  ok(0, 'new RoPkg::Simba() throws Param::Missing - not ok');
}

######
#test config file missing exception
######
eval {
  my $simba = new RoPkg::Simba(cfgFile => '/tmp/123412___21313_');
};

if ( Exception::Class->caught('File::NotFound') ) {
  ok(1, 'new RoPkg::Simba(cfgFile => "/tmp/123412___21313_") throws File::NotFound - ok');
}
else {
  ok(0, 'new RoPkg::Simba(cfgFile => "/tmp/123412___21313_") throws File::NotFound - not ok');
}

######
# test OutsideClass exception throw
######

foreach(qw(Run dbh MirrorsNo Mirrors CommandsNo Commands ExcludeNo Excludes LoadMirror RunCallbacks)) {
  my $method_name = $_;

  eval {
    RoPkg::Simba->$method_name();
  };

  if (Exception::Class->caught('OutsideClass')) {
    ok(1, 'RoPkg::Simba::' . $method_name . '() throws OutsideClass - ok');
  }
  else {
    ok(1, 'RoPkg::Simba::' . $method_name . '() throws OutsideClass - ok');
  }
}
