/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * ShapeTools/shape program - error.c
 *
 * Author: Axel Mahler (Axel.Mahler@cs.tu-berlin.de) and Wolfgang Obst
 *
 * $Header: error.c[8.0] Tue May 24 15:20:33 1994 axel@cs.tu-berlin.de frozen $
 */
#ifndef lint
static char *AtFSid = "$Header: error.c[8.0] Tue May 24 15:20:33 1994 axel@cs.tu-berlin.de frozen $";
#endif

#include "shape.h"

extern int af_errno;

EXPORT void errexit(err, mess)
     int err;
     char *mess;
{
  if (err != 14) {
    cleanup_links(link_reg);
    af_cleanup();
  }

  switch (err) {
  case 1: /* ???? */
    fprintf(stderr, "shape - multiple defined action for: %s\n", mess);
    exit(1);
  case 2:
    fprintf(stderr, "shape - unknown option: %s\n", mess);
    exit(1);
  case 3:
    if (!strcmp(mess,"love")) {
      fprintf(stderr,"Oh, what was it?");
      sleep(2);
      fprintf(stderr," .");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,". ");
      fprintf(stderr,"I should remember it");
      sleep(2);
      fprintf(stderr," .");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,". ");
      fprintf(stderr,"memory fault. coeur dumped.");
      exit(1);
    }

    if (!strcmp(mess,"future")) {
      fprintf(stderr,"Let me think ");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr," No future ");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr,".");
      sleep(2);
      fprintf(stderr," definitely!!!\n");
      exit(1);
    }

    if (!strcmp(mess,"me")) {
      fprintf(stderr,"shape - don't know how to shape you\n");
      exit(1);
    }

    if (!strcmp(mess,"you")) {
      fprintf(stderr,"shape yourself!\n");
      exit(1);
    }

    if (!strcmp(mess,"god")) {
      fprintf(stderr,"Don't know how to shave God\n");
      exit(1);
    }
    if (!strcmp(mess,"the queen")) {
      fprintf(stderr,"Don't know how to shave the queen\n");
      exit(1);
    }
    fprintf(stderr, "shape - don't know how to shape - %s\n", mess);
    exit(1);
  case 4:
    fprintf(stderr, "shape - unknown special macro in cmd: %s\n", mess);
    exit(1);
  case 5:
    fprintf(stderr, "shape - multiply defined selection rule: %s\n", mess);
    exit(1);
  case 6:
    fprintf(stderr, "shape - unknown standard predicate: %s\n", mess);
    exit(1);
  case 7:
    fprintf(stderr, "shape - error in variant section %s\n", mess);
    exit(1);
  case 8:
    fprintf(stderr, "shape - file not found: %s\n", mess);
    exit(1);
  case 9:
    fprintf(stderr, "shape - invalid gen/rev specification: %s\n", mess);
    exit(1);
  case 10:
    fprintf(stderr, "shape - error in: %s\n",mess);
    if ((af_errno != 0) && (strcmp("malloc",mess)))
      af_perror("AtFS reports");
    exit(1);
  case 11:
    fprintf(stderr, "shape - no description file and no arguments\n");
    exit(1);
  case 12:
    fprintf(stderr, "shape - cannot open file: %s\n", mess);
    exit(1);
  case 13:
    fprintf(stderr, "shape - error during execution; retcode: %s\n", mess);
    exit(1);
  case 14:
    fprintf(stderr, "shape - syntax error: %s\n", mess);
    break;
  case 15:
    fprintf(stderr, "shape - aborted due to syntactical error(s)\n");
    exit(1);
  case 16:
    fprintf(stderr, "shape - invalid state: %s\n", mess);
    exit(1);
  case 17:
    fprintf(stderr, "shape - couldn't find appropriate version of %s.\n", mess);
    exit(1);
  case 18:
    /* not used */
    fprintf(stderr, "shape - aborted!!!\n");
    exit(1);
  case 19:
    fprintf(stderr, "shape - variant name not defined: %s\n", mess);
    exit(1);
  case 20:
    fprintf(stderr, "shape - can't link %s\n", mess);
    exit(1);
  case 21:
    fprintf(stderr, "shape - can't unlink %s\n", mess);
    exit(1);
  case 22:
    fprintf(stderr, "shape - can't link %s to tmpfile\n", mess);
    exit(1);
  case 23:
    fprintf(stderr, "shape - interrupted \n");
    exit(1);
  case 24:
    fprintf(stderr, "shape - can't open include file: %s\n", mess);
    exit(1);
  case 25:
    fprintf(stderr, "shape - infinitely recursive macro caused by line: %s?\n", mess);
    exit(1);
  case 26:
    fprintf(stderr, "shape - invalid macrocitation within heritage field: %s\n",mess);
    exit(1);
  case 27:
    fprintf(stderr, "shape - too many %s\n", mess);
    exit(1);
  case 28:
    fprintf(stderr, "shape - forced stop :-(; couldn't find appropriate version for: %s\n", mess);
    exit(1);
  case 29:
    fprintf(stderr, "shape - attribute too long\n");
    exit(1);
  case 30:
    fprintf(stderr, "shape - incompatible combination of variants (vclass error): %s\n", mess);
    exit(1);
  case 31:
    fprintf(stderr, "shape - syntax error in rule section (delimiter missing)\n");
    exit(1);
  case 32:
    fprintf(stderr, "shape - unknown selection rule name: %s\n", mess);
    exit(1);
  case 33:
    fprintf(stderr, "shape - multiply defined variant name: %s\n", mess);
    exit(1);
  case 34:
    fprintf(stderr, "shape - choose -expandall *or* -expandnothing!\n");
    exit(1);
  case 35:
    fprintf(stderr, "shape - argument %s for -confid is no target name\n",mess);
    exit(1);
  case 36:
    fprintf(stderr, "shape - too many arguments for -force\n");
    exit(1);
  case 37:
    fprintf(stderr, "shape - too many variant definitions\n");
    exit(1);
  case 38:
    fprintf(stderr, "shape - bad delimiter in rule section: %s\n", mess);
    exit(1);
  case 39:
    fprintf(stderr, "shape - multiply defined variant class: %s\n", mess);
    exit(1);
  case 40:
    fprintf (stderr, "shape - inifinte recursion: target `%s' depends on itself.\n", mess);
    exit (1);
  case 99:
    fprintf(stderr, "shape - not yet implemented: %s\n", mess);
    exit(1);
  default:
    fprintf(stderr, "shape - impossible error\n");
    exit(1);
  }
}


EXPORT void warning (no, mess)
     int no;
     char *mess;
{
  switch (no)
    {
    case 1:
      fprintf(stderr,"shape - warning: derived object not saved into derived object cache; no AtFS subdirectory\n");
      return;
    case 2:
      fprintf(stderr,"shape - warning: target `%s' not remade because of errors\n", mess);
      return;
    case 3:
      fprintf(stderr,"shape - warning: defining macros via command line may cause the rebuilding of a different system than described in confid\n");
      return;
    case 4:
      fprintf(stderr,"shape - warning: no AtFS subdirectory\n");
      return;
    case 5:
      fprintf(stderr,"shape - warning: environment variable ATFSBPSIZ = 0?\n");
      return;
    case 7:
      fprintf (stderr, "shape - warning: infinite loop: target `%s' depends on itself.\n", mess);
      return;
    default:
      fprintf (stderr, "%s.\n", mess);
      return;
    }
}
