// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Error;
use PageSetup;
use PrintContext;
use PrintOperationAction;
use PrintOperationPreview;
use PrintOperationResult;
use PrintSettings;
use PrintStatus;
use Unit;
use Widget;
use Window;
use ffi;
use glib;
use glib::StaticType;
use glib::Value;
use glib::object::Downcast;
use glib::object::IsA;
use glib::signal::SignalHandlerId;
use glib::signal::connect;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use libc;
use std;
use std::boxed::Box as Box_;
use std::mem;
use std::mem::transmute;
use std::ptr;

glib_wrapper! {
    pub struct PrintOperation(Object<ffi::GtkPrintOperation, ffi::GtkPrintOperationClass>): PrintOperationPreview;

    match fn {
        get_type => || ffi::gtk_print_operation_get_type(),
    }
}

impl PrintOperation {
    pub fn new() -> PrintOperation {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_print_operation_new())
        }
    }
}

impl Default for PrintOperation {
    fn default() -> Self {
        Self::new()
    }
}

pub trait PrintOperationExt {
    fn cancel(&self);

    fn draw_page_finish(&self);

    fn get_default_page_setup(&self) -> Option<PageSetup>;

    fn get_embed_page_setup(&self) -> bool;

    fn get_error(&self) -> Result<(), Error>;

    fn get_has_selection(&self) -> bool;

    fn get_n_pages_to_print(&self) -> i32;

    fn get_print_settings(&self) -> Option<PrintSettings>;

    fn get_status(&self) -> PrintStatus;

    fn get_status_string(&self) -> Option<String>;

    fn get_support_selection(&self) -> bool;

    fn is_finished(&self) -> bool;

    fn run<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, action: PrintOperationAction, parent: Q) -> Result<PrintOperationResult, Error>;

    fn set_allow_async(&self, allow_async: bool);

    fn set_current_page(&self, current_page: i32);

    fn set_custom_tab_label<'a, P: Into<Option<&'a str>>>(&self, label: P);

    fn set_default_page_setup<'a, P: Into<Option<&'a PageSetup>>>(&self, default_page_setup: P);

    fn set_defer_drawing(&self);

    fn set_embed_page_setup(&self, embed: bool);

    fn set_export_filename<P: AsRef<std::path::Path>>(&self, filename: P);

    fn set_has_selection(&self, has_selection: bool);

    fn set_job_name(&self, job_name: &str);

    fn set_n_pages(&self, n_pages: i32);

    fn set_print_settings<'a, P: Into<Option<&'a PrintSettings>>>(&self, print_settings: P);

    fn set_show_progress(&self, show_progress: bool);

    fn set_support_selection(&self, support_selection: bool);

    fn set_track_print_status(&self, track_status: bool);

    fn set_unit(&self, unit: Unit);

    fn set_use_full_page(&self, full_page: bool);

    fn get_property_allow_async(&self) -> bool;

    fn get_property_current_page(&self) -> i32;

    fn get_property_custom_tab_label(&self) -> Option<String>;

    fn get_property_export_filename(&self) -> Option<String>;

    fn get_property_job_name(&self) -> Option<String>;

    fn get_property_n_pages(&self) -> i32;

    fn get_property_show_progress(&self) -> bool;

    fn get_property_track_print_status(&self) -> bool;

    fn get_property_unit(&self) -> Unit;

    fn get_property_use_full_page(&self) -> bool;

    fn connect_begin_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_create_custom_widget<F: Fn(&Self) -> glib::Object + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_custom_widget_apply<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_done<F: Fn(&Self, PrintOperationResult) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_draw_page<F: Fn(&Self, &PrintContext, i32) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_end_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_paginate<F: Fn(&Self, &PrintContext) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_preview<F: Fn(&Self, &PrintOperationPreview, &PrintContext, &Option<Window>) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_request_page_setup<F: Fn(&Self, &PrintContext, i32, &PageSetup) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_status_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_update_custom_widget<F: Fn(&Self, &Widget, &PageSetup, &PrintSettings) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_allow_async_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_current_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_custom_tab_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_default_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_embed_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_export_filename_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_job_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_n_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_n_pages_to_print_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_print_settings_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_show_progress_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_status_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_support_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_track_print_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_unit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn connect_property_use_full_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<PrintOperation> + IsA<glib::object::Object>> PrintOperationExt for O {
    fn cancel(&self) {
        unsafe {
            ffi::gtk_print_operation_cancel(self.to_glib_none().0);
        }
    }

    fn draw_page_finish(&self) {
        unsafe {
            ffi::gtk_print_operation_draw_page_finish(self.to_glib_none().0);
        }
    }

    fn get_default_page_setup(&self) -> Option<PageSetup> {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_default_page_setup(self.to_glib_none().0))
        }
    }

    fn get_embed_page_setup(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_embed_page_setup(self.to_glib_none().0))
        }
    }

    fn get_error(&self) -> Result<(), Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::gtk_print_operation_get_error(self.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn get_has_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_has_selection(self.to_glib_none().0))
        }
    }

    fn get_n_pages_to_print(&self) -> i32 {
        unsafe {
            ffi::gtk_print_operation_get_n_pages_to_print(self.to_glib_none().0)
        }
    }

    fn get_print_settings(&self) -> Option<PrintSettings> {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_print_settings(self.to_glib_none().0))
        }
    }

    fn get_status(&self) -> PrintStatus {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_status(self.to_glib_none().0))
        }
    }

    fn get_status_string(&self) -> Option<String> {
        unsafe {
            from_glib_none(ffi::gtk_print_operation_get_status_string(self.to_glib_none().0))
        }
    }

    fn get_support_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_get_support_selection(self.to_glib_none().0))
        }
    }

    fn is_finished(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_print_operation_is_finished(self.to_glib_none().0))
        }
    }

    fn run<'a, P: IsA<Window> + 'a, Q: Into<Option<&'a P>>>(&self, action: PrintOperationAction, parent: Q) -> Result<PrintOperationResult, Error> {
        let parent = parent.into();
        let parent = parent.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::gtk_print_operation_run(self.to_glib_none().0, action.to_glib(), parent.0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_allow_async(&self, allow_async: bool) {
        unsafe {
            ffi::gtk_print_operation_set_allow_async(self.to_glib_none().0, allow_async.to_glib());
        }
    }

    fn set_current_page(&self, current_page: i32) {
        unsafe {
            ffi::gtk_print_operation_set_current_page(self.to_glib_none().0, current_page);
        }
    }

    fn set_custom_tab_label<'a, P: Into<Option<&'a str>>>(&self, label: P) {
        let label = label.into();
        let label = label.to_glib_none();
        unsafe {
            ffi::gtk_print_operation_set_custom_tab_label(self.to_glib_none().0, label.0);
        }
    }

    fn set_default_page_setup<'a, P: Into<Option<&'a PageSetup>>>(&self, default_page_setup: P) {
        let default_page_setup = default_page_setup.into();
        let default_page_setup = default_page_setup.to_glib_none();
        unsafe {
            ffi::gtk_print_operation_set_default_page_setup(self.to_glib_none().0, default_page_setup.0);
        }
    }

    fn set_defer_drawing(&self) {
        unsafe {
            ffi::gtk_print_operation_set_defer_drawing(self.to_glib_none().0);
        }
    }

    fn set_embed_page_setup(&self, embed: bool) {
        unsafe {
            ffi::gtk_print_operation_set_embed_page_setup(self.to_glib_none().0, embed.to_glib());
        }
    }

    fn set_export_filename<P: AsRef<std::path::Path>>(&self, filename: P) {
        unsafe {
            ffi::gtk_print_operation_set_export_filename(self.to_glib_none().0, filename.as_ref().to_glib_none().0);
        }
    }

    fn set_has_selection(&self, has_selection: bool) {
        unsafe {
            ffi::gtk_print_operation_set_has_selection(self.to_glib_none().0, has_selection.to_glib());
        }
    }

    fn set_job_name(&self, job_name: &str) {
        unsafe {
            ffi::gtk_print_operation_set_job_name(self.to_glib_none().0, job_name.to_glib_none().0);
        }
    }

    fn set_n_pages(&self, n_pages: i32) {
        unsafe {
            ffi::gtk_print_operation_set_n_pages(self.to_glib_none().0, n_pages);
        }
    }

    fn set_print_settings<'a, P: Into<Option<&'a PrintSettings>>>(&self, print_settings: P) {
        let print_settings = print_settings.into();
        let print_settings = print_settings.to_glib_none();
        unsafe {
            ffi::gtk_print_operation_set_print_settings(self.to_glib_none().0, print_settings.0);
        }
    }

    fn set_show_progress(&self, show_progress: bool) {
        unsafe {
            ffi::gtk_print_operation_set_show_progress(self.to_glib_none().0, show_progress.to_glib());
        }
    }

    fn set_support_selection(&self, support_selection: bool) {
        unsafe {
            ffi::gtk_print_operation_set_support_selection(self.to_glib_none().0, support_selection.to_glib());
        }
    }

    fn set_track_print_status(&self, track_status: bool) {
        unsafe {
            ffi::gtk_print_operation_set_track_print_status(self.to_glib_none().0, track_status.to_glib());
        }
    }

    fn set_unit(&self, unit: Unit) {
        unsafe {
            ffi::gtk_print_operation_set_unit(self.to_glib_none().0, unit.to_glib());
        }
    }

    fn set_use_full_page(&self, full_page: bool) {
        unsafe {
            ffi::gtk_print_operation_set_use_full_page(self.to_glib_none().0, full_page.to_glib());
        }
    }

    fn get_property_allow_async(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "allow-async".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_current_page(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "current-page".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_custom_tab_label(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "custom-tab-label".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn get_property_export_filename(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "export-filename".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn get_property_job_name(&self) -> Option<String> {
        unsafe {
            let mut value = Value::from_type(<String as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "job-name".to_glib_none().0, value.to_glib_none_mut().0);
            value.get()
        }
    }

    fn get_property_n_pages(&self) -> i32 {
        unsafe {
            let mut value = Value::from_type(<i32 as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "n-pages".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_show_progress(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "show-progress".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_track_print_status(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "track-print-status".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_unit(&self) -> Unit {
        unsafe {
            let mut value = Value::from_type(<Unit as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "unit".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn get_property_use_full_page(&self) -> bool {
        unsafe {
            let mut value = Value::from_type(<bool as StaticType>::static_type());
            gobject_ffi::g_object_get_property(self.to_glib_none().0, "use-full-page".to_glib_none().0, value.to_glib_none_mut().0);
            value.get().unwrap()
        }
    }

    fn connect_begin_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintContext) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "begin-print",
                transmute(begin_print_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_create_custom_widget<F: Fn(&Self) -> glib::Object + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) -> glib::Object + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "create-custom-widget",
                transmute(create_custom_widget_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_custom_widget_apply<F: Fn(&Self, &Widget) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Widget) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "custom-widget-apply",
                transmute(custom_widget_apply_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_done<F: Fn(&Self, PrintOperationResult) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, PrintOperationResult) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "done",
                transmute(done_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_draw_page<F: Fn(&Self, &PrintContext, i32) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintContext, i32) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "draw-page",
                transmute(draw_page_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_end_print<F: Fn(&Self, &PrintContext) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintContext) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "end-print",
                transmute(end_print_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_paginate<F: Fn(&Self, &PrintContext) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintContext) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "paginate",
                transmute(paginate_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_preview<F: Fn(&Self, &PrintOperationPreview, &PrintContext, &Option<Window>) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintOperationPreview, &PrintContext, &Option<Window>) -> bool + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "preview",
                transmute(preview_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_request_page_setup<F: Fn(&Self, &PrintContext, i32, &PageSetup) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &PrintContext, i32, &PageSetup) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "request-page-setup",
                transmute(request_page_setup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_status_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "status-changed",
                transmute(status_changed_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_update_custom_widget<F: Fn(&Self, &Widget, &PageSetup, &PrintSettings) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self, &Widget, &PageSetup, &PrintSettings) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "update-custom-widget",
                transmute(update_custom_widget_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_allow_async_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::allow-async",
                transmute(notify_allow_async_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_current_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::current-page",
                transmute(notify_current_page_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_custom_tab_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::custom-tab-label",
                transmute(notify_custom_tab_label_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_default_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::default-page-setup",
                transmute(notify_default_page_setup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_embed_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::embed-page-setup",
                transmute(notify_embed_page_setup_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_export_filename_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::export-filename",
                transmute(notify_export_filename_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::has-selection",
                transmute(notify_has_selection_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_job_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::job-name",
                transmute(notify_job_name_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_n_pages_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::n-pages",
                transmute(notify_n_pages_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_n_pages_to_print_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::n-pages-to-print",
                transmute(notify_n_pages_to_print_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_print_settings_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::print-settings",
                transmute(notify_print_settings_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_show_progress_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::show-progress",
                transmute(notify_show_progress_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::status",
                transmute(notify_status_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_status_string_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::status-string",
                transmute(notify_status_string_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_support_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::support-selection",
                transmute(notify_support_selection_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_track_print_status_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::track-print-status",
                transmute(notify_track_print_status_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_unit_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::unit",
                transmute(notify_unit_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }

    fn connect_property_use_full_page_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe {
            let f: Box_<Box_<Fn(&Self) + 'static>> = Box_::new(Box_::new(f));
            connect(self.to_glib_none().0, "notify::use-full-page",
                transmute(notify_use_full_page_trampoline::<Self> as usize), Box_::into_raw(f) as *mut _)
        }
    }
}

unsafe extern "C" fn begin_print_trampoline<P>(this: *mut ffi::GtkPrintOperation, context: *mut ffi::GtkPrintContext, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintContext) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context))
}

unsafe extern "C" fn create_custom_widget_trampoline<P>(this: *mut ffi::GtkPrintOperation, f: glib_ffi::gpointer) -> *mut gobject_ffi::GObject
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) -> glib::Object + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())/*Not checked*/.to_glib_none().0
}

unsafe extern "C" fn custom_widget_apply_trampoline<P>(this: *mut ffi::GtkPrintOperation, widget: *mut ffi::GtkWidget, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &Widget) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(widget))
}

unsafe extern "C" fn done_trampoline<P>(this: *mut ffi::GtkPrintOperation, result: ffi::GtkPrintOperationResult, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, PrintOperationResult) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), from_glib(result))
}

unsafe extern "C" fn draw_page_trampoline<P>(this: *mut ffi::GtkPrintOperation, context: *mut ffi::GtkPrintContext, page_nr: libc::c_int, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintContext, i32) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), page_nr)
}

unsafe extern "C" fn end_print_trampoline<P>(this: *mut ffi::GtkPrintOperation, context: *mut ffi::GtkPrintContext, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintContext) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context))
}

unsafe extern "C" fn paginate_trampoline<P>(this: *mut ffi::GtkPrintOperation, context: *mut ffi::GtkPrintContext, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintContext) -> bool + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context)).to_glib()
}

unsafe extern "C" fn preview_trampoline<P>(this: *mut ffi::GtkPrintOperation, preview: *mut ffi::GtkPrintOperationPreview, context: *mut ffi::GtkPrintContext, parent: *mut ffi::GtkWindow, f: glib_ffi::gpointer) -> glib_ffi::gboolean
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintOperationPreview, &PrintContext, &Option<Window>) -> bool + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(preview), &from_glib_borrow(context), &from_glib_borrow(parent)).to_glib()
}

unsafe extern "C" fn request_page_setup_trampoline<P>(this: *mut ffi::GtkPrintOperation, context: *mut ffi::GtkPrintContext, page_nr: libc::c_int, setup: *mut ffi::GtkPageSetup, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &PrintContext, i32, &PageSetup) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(context), page_nr, &from_glib_borrow(setup))
}

unsafe extern "C" fn status_changed_trampoline<P>(this: *mut ffi::GtkPrintOperation, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn update_custom_widget_trampoline<P>(this: *mut ffi::GtkPrintOperation, widget: *mut ffi::GtkWidget, setup: *mut ffi::GtkPageSetup, settings: *mut ffi::GtkPrintSettings, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P, &Widget, &PageSetup, &PrintSettings) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked(), &from_glib_borrow(widget), &from_glib_borrow(setup), &from_glib_borrow(settings))
}

unsafe extern "C" fn notify_allow_async_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_current_page_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_custom_tab_label_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_default_page_setup_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_embed_page_setup_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_export_filename_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_has_selection_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_job_name_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_n_pages_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_n_pages_to_print_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_print_settings_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_show_progress_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_status_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_status_string_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_support_selection_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_track_print_status_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_unit_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}

unsafe extern "C" fn notify_use_full_page_trampoline<P>(this: *mut ffi::GtkPrintOperation, _param_spec: glib_ffi::gpointer, f: glib_ffi::gpointer)
where P: IsA<PrintOperation> {
    let f: &&(Fn(&P) + 'static) = transmute(f);
    f(&PrintOperation::from_glib_borrow(this).downcast_unchecked())
}
