% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webmockr-opts.R
\name{webmockr_configure}
\alias{webmockr_configure}
\alias{webmockr_configure_reset}
\alias{webmockr_configuration}
\alias{webmockr_allow_net_connect}
\alias{webmockr_disable_net_connect}
\alias{webmockr_net_connect_allowed}
\title{webmockr configuration}
\usage{
webmockr_configure(allow_net_connect = FALSE, allow_localhost = FALSE,
  allow = NULL, net_http_connect_on_start = FALSE,
  show_stubbing_instructions = FALSE, query_values_notation = FALSE,
  show_body_diff = FALSE)

webmockr_configure_reset()

webmockr_configuration()

webmockr_allow_net_connect()

webmockr_disable_net_connect(allow = NULL)

webmockr_net_connect_allowed(uri = NULL)
}
\arguments{
\item{allow_net_connect}{(logical) Default: \code{FALSE}}

\item{allow_localhost}{(logical) Default: \code{FALSE}}

\item{allow}{(character) one or more URI/URL to allow (and by extension
all others are not allowed)}

\item{net_http_connect_on_start}{(logical) Default: \code{FALSE}. ignored for
now}

\item{show_stubbing_instructions}{(logical) Default: \code{FALSE}. ignored for
now}

\item{query_values_notation}{(logical) Default: \code{FALSE}. ignored for
now}

\item{show_body_diff}{(logical) Default: \code{FALSE}. ignored for
now}

\item{uri}{(character) a URI/URL as a character string - to determine
whether or not it is allowed}
}
\description{
webmockr configuration
}
\examples{
\dontrun{
webmockr_configure()
webmockr_configure(
 allow_localhost = TRUE
)
webmockr_configuration()
webmockr_configure_reset()

webmockr_allow_net_connect()
webmockr_net_connect_allowed()

# disable net connect for any URIs
webmockr_disable_net_connect()
### gives NULL with no URI passed
webmockr_net_connect_allowed()
# disable net connect EXCEPT FOR given URIs
webmockr_disable_net_connect(allow = "google.com")
### is a specific URI allowed?
webmockr_net_connect_allowed("google.com")
}
}
