% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestSignature.R
\docType{data}
\name{RequestSignature}
\alias{RequestSignature}
\title{General purpose request signature builder}
\arguments{
\item{method}{the HTTP method (any, head, options, get, post, put,
patch, trace, or delete). "any" matches any HTTP method. required.}

\item{uri}{(character) request URI. required.}

\item{options}{(list) options. optional. See Details.}
}
\description{
General purpose request signature builder
}
\details{
\strong{Methods}
\describe{
\item{\code{to_s()}}{
Request signature to a string
return: a character string representation of the request signature
}
}
}
\section{options}{

\itemize{
\item body - body as a named list
\item headers - headers as a named list
\item proxies - proxies as a named list
\item auth - authentication details, as a named list
}
}

\examples{
# make request signature
x <- RequestSignature$new(method = "get", uri = "https:/httpbin.org/get")
# method
x$method
# uri
x$uri
# request signature to string
x$to_s()

# headers
w <- RequestSignature$new(
  method = "get",
  uri = "https:/httpbin.org/get",
  options = list(headers = list(`User-Agent` = "foobar", stuff = "things"))
)
w
w$headers
w$to_s()

# headers and body
bb <- RequestSignature$new(
  method = "get",
  uri = "https:/httpbin.org/get",
  options = list(
    headers = list(`User-Agent` = "foobar", stuff = "things"),
    body = list(a = "tables")
  )
)
bb
bb$headers
bb$body
bb$to_s()
}
\keyword{datasets}
