/*
# PostgreSQL Database Modeler (pgModeler)
#
# Copyright 2006-2018 - Raphael Araújo e Silva <raphael@pgmodeler.io>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3.
#
# This program is distributed in the hope that it will be useful),
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# The complete text of GPLv3 is at LICENSE file on source code root directory.
# Also), you can get the complete GNU General Public License at <http://www.gnu.org/licenses/>
*/

#include "parsersattributes.h"

namespace ParsersAttributes {
	const QString
	_FALSE_=QString("false"),
	_FILE_=QString("file"),
	_LC_COLLATE_=QString("lc-collate"),
	_LC_CTYPE_=QString("lc-ctype"),
	_TRUE_=QString("true"),
	ADMIN_OPTION=QString("admin-option"),
	ADMIN_ROLES=QString("admin-roles"),
	ALIAS=QString("alias"),
	ALIGNMENT=QString("alignment"),
	ALIGN_OBJS_TO_GRID=QString("align-objs-to-grid"),
	ALTER_CMDS=QString("alter-cmds"),
	ALLOW_CONNS=QString("allow-conns"),
	ANALYZE_FUNC=QString("analyze"),
	ANCESTOR_TABLE=QString("ancestor-table"),
	APPEND_AT_EOD=QString("append-at-eod"),
	APPENDED_SQL=QString("appended-sql"),
	APPLICATION=QString("application"),
	ARG_COUNT=QString("arg-count"),
	ARG_DEF_COUNT=QString("arg-def-count"),
	ARG_DEFAULTS=QString("arg-defaults"),
	ARG_MODES=QString("arg-modes"),
	ARG_NAMES=QString("arg-names"),
	ARG_TYPES=QString("arg-types"),
	ARGUMENTS=QString("arguments"),
	ASC_ORDER=QString("asc-order"),
	ASSIGNMENT=QString("assignment"),
	ATTRIBUTE=QString("attribute"),
	AUTO_BROWSE_DB=QString("auto-browse-db"),
	AUTOSAVE_INTERVAL=QString("autosave-interval"),
	BACKGROUND_COLOR=QString("background-color"),
	BASE_TYPE=QString("base"),
	BEFORE=QString("before"),
	BEHAVIOR_TYPE=QString("behavior-type"),
	BOLD=QString("bold"),
	BORDER_COLOR=QString("border-color"),
	BOTTOM=QString("bottom"),
	BUFFERING=QString("buffering"),
	BY_VALUE=QString("by-value"),
	BYPASSRLS=QString("bypassrls"),
	CACHE=QString("cache"),
	CANONICAL_FUNC=QString("canonical"),
	CANVAS_CORNER_MOVE=QString("canvas-corner-move"),
	CASCADE=QString("cascade"),
	CASE_SENSITIVE=QString("case-sensitive"),
	CAST_TYPE=QString("cast-type"),
	CATEGORY=QString("category"),
	CHANGE=QString("change"),
	CHANGELOG=QString("changelog"),
	CHECK_EXP=QString("check-exp"),
	CHECK_UPDATE=QString("check-update"),
	CK_CONSTR=QString("ck-constr"),
	CLIENT_ENCODING=QString("client-encoding"),
	CODE_COMPLETION=QString("code-completion"),
	CODE_FONT_SIZE=QString("code-font-size"),
	CODE_FONT=QString("code-font"),
	CODE_TAB_WIDTH=QString("code-tab-width"),
	COL_INDEXES=QString("col-indexes"),
	COLLATABLE=QString("collatable"),
	COLLATION=QString("collation"),
	COLLATIONS=QString("collations"),
	COLOR=QString("color"),
	COLORS=QString("colors"),
	COLS_COMMENT=QString("cols-comment"),
	COL_IS_IDENTITY=QString("col-is-identity"),
	COLUMN_ALIAS=QString("column-alias"),
	COLUMN=QString("column"),
	COLUMNS=QString("columns"),
	COMMAND=QString("command"),
	COMMANDS=QString("commands"),
	COMMENT=QString("comment"),
	COMMUTATOR_OP=QString("commutator-op"),
	COMPARISON_TYPE=QString("comparison-type"),
	COMPLETION_TRIGGER=QString("completion-trigger"),
	COMPOSITE_TYPE=QString("composite"),
	CONCURRENT=QString("concurrent"),
	CONDITION=QString("condition"),
	CONFIG_FILE=QString("config-file"),
	CONFIGURATION=QString("configuration"),
	CONFIRM_VALIDATION=QString("confirm-validation"),
	CONN_LIMIT=QString("connlimit"),
	CONNECT_CENTER_PNTS=QString("center-pnts"),
	CONNECT_FK_TO_PK=QString("fk-to-pk"),
	CONNECT_TABLE_EDGES=QString("table-edges"),
	CONNECT_PRIV=QString("connect"),
	CONNECTION=QString("connection"),
	CONNECTIONS=QString("connections"),
	CONNECTION_TIMEOUT=QString("connection-timeout"),
	CONSTR_INDEXES=QString("constr-indexes"),
	CONSTR_SQL_DISABLED=QString("constr-sql-disabled"),
	CONSTRAINT=QString("constraint"),
	CONSTRAINTS=QString("constraints"),
	CONSTR_DEFS=QString("constr-defs"),
	CONTENTS=QString("contents"),
	COPY_MODE=QString("copy-mode"),
	COPY_OPTIONS=QString("copy-options"),
	COPY_TABLE=QString("copy-table"),
	CREATE_CMDS=QString("create-cmds"),
	CREATE_PRIV=QString("create"),
	CREATE=QString("create"),
	CREATEDB=QString("createdb"),
	CREATEROLE=QString("createrole"),
	CROWS_FOOT=QString("crows-foot"),
	CTE_EXPRESSION=QString("cte-exp"),
	CUR_VERSION=QString("cur-version"),
	CUSTOM_COLOR=QString("custom-color"),
	CUSTOM_FILTER=QString("custom-filter"),
	CUSTOMIDXS=QString("customidxs"),
	CYCLE=QString("cycle"),
	DATA_DIRECTORY=QString("data-directory"),
	DATE=QString("date"),
	DATABASE=QString("database"),
	DB_MODEL=QString("dbmodel"),
	DDL_END_TOKEN=QString("-- ddl-end --"),
	DECL_IN_TABLE=QString("decl-in-table"),
	DECLARATION=QString("declaration"),
	DEFAULT_COLLATION=QString("default-collation"),
	DEFAULT_FOR_OPS=QString("default-for-ops"),
	DEFAULT_OWNER=QString("default-owner"),
	DEFAULT_SCHEMA=QString("default-schema"),
	DEFAULT_TABLESPACE=QString("default-tablespace"),
	DEFAULT_VALUE=QString("default-value"),
	DEFAULT=QString("default"),
	DEFER_TYPE=QString("defer-type"),
	DEFERRABLE=QString("deferrable"),
	DEFINITION=QString("definition"),	
	DEL_ACTION=QString("del-action"),
	DEL_EVENT=QString("del-event"),
	DELETE_PRIV=QString("delete"),
	DELIMITER=QString("delimiter"),
	DEST_TYPE=QString("destiny-type"),
	DST_TYPE=QString("dst-type"),
	DIFF=QString("diff"),
	DIMENSION=QString("dimension"),
	DIRECTORY=QString("directory"),
	DISABLE_SMOOTHNESS=QString("disable-smoothness"),
	DISPLAY_LINE_NUMBERS=QString("display-line-numbers"),
	DOM_CONSTRAINT=QString("domconstraint"),
	DOCK_WIDGETS=QString("dock-widgets"),
	DROP_CMDS=QString("drop-cmds"),
	DROP=QString("drop"),
	DST_COL_PATTERN=QString("dst-col-pattern"),
	DST_COLUMNS=QString("dst-columns"),
	DST_ENCODING=QString("dst-encoding"),
	DST_FK_PATTERN=QString("dst-fk-pattern"),
	DST_LABEL=QString("dst-label"),
	DST_REQUIRED=QString("dst-required"),
	DST_TABLE=QString("dst-table"),
	DYNAMIC_LIBRARY_PATH=QString("dynamic-library-path"),
	DYNAMIC_SHARED_MEMORY=QString("dynamic-shared-memory-type"),
	END_EXP=QString("end-exp"),
	ELEMENT=QString("element"),
	ELEMENTS=QString("elements"),
	ENCODING=QString("encoding"),
	ENCRYPTED=QString("encrypted"),
	ENUM_TYPE=QString("enumeration"),
	ENUMERATIONS=QString("enumerations"),
	EVENT_TYPE=QString("event-type"),
	EVENT=QString("event"),
	EVENTS=QString("events"),
	EX_CONSTR=QString("ex-constr"),
	EXACT_MATCH=QString("exact-match"),
	EXC_BUILTIN_ARRAYS=QString("exc-builtin-arrays"),
	EXCLUDE_ELEMENT=QString("excelement"),
	EXEC_TYPE=QString("exec-type"),
	EXECUTE_PRIV=QString("execute"),
	EXECUTION_COST=QString("execution-cost"),
	EXISTING_VALUE=QString("existing-value"),
	EXPLICIT=QString("explicit"),
	EXPORT=QString("export"),
	EXPORT_TO_FILE=QString("export-to-file"),
	EXPRESSION=QString("expression"),
	EXPRESSIONS=QString("expressions"),
	EXT_OBJ_OIDS=QString("ext-obj-oids"),
	FACTOR=QString("factor"),
	FADEIN_OBJECTS=QString("fadein-objects"),
	FADED_OUT=QString("faded-out"),
	FAMILY=QString("family"),
	FAST_UPDATE=QString("fast-update"),
	FILE_ASSOCIATED=QString("file-associated"),
	FILL_COLOR=QString("fill-color"),
	FILTER_OIDS=QString("filter-oids"),
	FILTER_TABLE_TYPES=QString("filter-tab-types"),
	FILTER=QString("filter"),
	FINAL_FUNC=QString("final"),
	FIRING_TYPE=QString("firing-type"),
	FK_COLUMN=QString("fk-column"),
	FK_CONSTR=QString("fk-constr"),
	FK_DEFS=QString("fk-defs"),
	FONT_SIZE=QString("font-size"),
	FONT=QString("font"),
	FOREGROUND_COLOR=QString("foreground-color"),
	FOREIGN_KEYS=QString("foreign-keys"),
	FROM_EXP=QString("from-exp"),
	FUNCTION_TYPE=QString("function-type"),
	FUNCTION=QString("function"),
	GENERAL=QString("general"),
	GEN_ALTER_CMDS=QString("gen-alter-cmds"),
	GLOBAL=QString("global"),
	GRANT_OP=QString("grant-op"),
	GRID_SIZE=QString("grid-size"),
	GROUP=QString("group"),
	HANDLER_FUNC=QString("handler"),
	HANDLES_TYPE=QString("handles-type"),
	HAS_CHANGES=QString("has-changes"),
	HASHES=QString("hashes"),
	HBA_FILE=QString("hba-file"),
	HIDE_EXT_ATTRIBS=QString("hide-ext-attribs"),
	HIDE_REL_NAME=QString("hide-rel-name"),
	HIDE_TABLE_TAGS=QString("hide-table-tags"),
	HIGHLIGHT_LINES=QString("highlight-lines"),
	HIGHLIGHT_ORDER=QString("highlight-order"),
	HISTORY_MAX_LENGTH=QString("history-max-length"),
	ICON=QString("icon"),
	ID=QString("id"),
	IDENTIFIER=QString("identifier"),
	IDENTITY_TYPE=QString("identity-type"),
	IDENT_FILE=QString("ident-file"),
	IGNORED_CHARS=QString("ignored-chars"),
	IMPLICIT=QString("implicit"),
	IMPORT=QString("import"),
	INCREMENT=QString("increment"),
	INDEX_ELEMENT=QString("idxelement"),
	INDEX_TYPE=QString("index-type"),
	INDEX=QString("index"),
	INDEXES=QString("indexes"),
	INFO=QString("info"),
	INH_COLUMN=QString("inh-column"),
	INH_COLUMNS=QString("inh-columns"),
	INHERIT=QString("inherit"),
	INHERITED=QString("inherited"),
	INITIAL_COND=QString("initial-cond"),
	INITIAL_DATA=QString("initial-data"),
	INITIAL_EXP=QString("initial-exp"),
	INLINE_FUNC=QString("inline"),
	INPUT_FUNC=QString("input"),
	INS_EVENT=QString("ins-event"),
	INSERT_PRIV=QString("insert"),
	INTERNAL_LENGTH=QString("internal-length"),
	INTERVAL_TYPE=QString("interval-type"),
	INVERT_RANGESEL_TRIGGER=QString("invert-rangesel-trigger"),
	IS_TEMPLATE=QString("is-template"),
	IO_CAST=QString("io-cast"),
	ITALIC=QString("italic"),
	JOIN_FUNC=QString("join"),
	LABEL=QString("label"),
	LABELS_POS=QString("labels-pos"),
	LANDSCAPE=QString("landscape"),
	LANGUAGE=QString("language"),
	LAST_POSITION=QString("last-position"),
	LAST_SYS_OID=QString("last-sys-oid"),
	LAST_VALUE=QString("last-value"),
	LAST_ZOOM=QString("last-zoom"),
	LEAKPROOF=QString("leakproof"),
	LEFT_TYPE=QString("left-type"),
	LEFT=QString("left"),
	LENGTH=QString("length"),
	LIBRARY=QString("library"),
	LIKE_TYPE=QString("like-type"),
	LINE=QString("line"),
	LINE_NUMBERS_COLOR=QString("line-numbers-color"),
	LINE_NUMBERS_BG_COLOR=QString("line-numbers-bg-color"),
	LINE_HIGHLIGHT_COLOR=QString("line-highlight-color"),
	LISTEN_ADDRESSES=QString("listen-addresses"),
	LOCALE=QString("locale"),
	LOCKER_ARC=QString("locker-arc"),
	LOCKER_BODY=QString("locker-body"),
	LOGIN=QString("login"),
	LOOKAHEAD_CHAR=QString("lookahead-char"),
	MATERIALIZED=QString("materialized"),
	MAX_CONNECTIONS=QString("max-connections"),
	MAX_VALUE=QString("max-value"),
	MEMBER_ROLES=QString("member-roles"),
	MEMBER=QString("member"),
	MERGES=QString("merges"),
	METADATA=QString("metadata"),
	MIN_OBJECT_OPACITY=QString("min-object-opacity"),
	MIN_VALUE=QString("min-value"),
	MODE=QString("mode"),
	MODEL_AUTHOR=QString("author"),
	NAME_LABEL=QString("name-label"),
	NAME_PATTERNS=QString("name-patterns"),
	NAME=QString("name"),
	NAMES=QString("names"),
	NEGATOR_OP=QString("negator-op"),
	NEW_NAME=QString("new-name"),
	NEW_IDENTITY_TYPE=QString("new-identity-type"),
	NEW_VERSION=QString("new-version"),
	NN_COLUMN=QString("nn-column"),
	NO_INHERIT=QString("no-inherit"),
	NONE=QString("none"),
	NOT_EXT_OBJECT=QString("not-ext-object"),
	NOT_NULL=QString("not-null"),
	NULLS_FIRST=QString("nulls-first"),
	OBJ_SELECTION=QString("obj-selection"),
	OBJECT_ID=QString("object-id"),
	OBJECT_FINDER=QString("objectfinder"),
	OBJECT_TYPE=QString("object-type"),
	OBJECT=QString("object"),
	OBJECTS=QString("objects"),
	OID_FILTER_OP=QString("oid-filter-op"),
	OID=QString("oid"),
	OIDS=QString("oids"),
	OLD_NAME=QString("old-name"),
	OLD_VERSION=QString("old-version"),
	OP_CLASS=QString("opclass"),
	OP_CLASSES=QString("opclasses"),
	OP_FAMILY=QString("opfamily"),
	OP_LIST_SIZE=QString("op-list-size"),
	OPERATOR_FUNC=QString("operfunc"),
	OPERATOR=QString("operator"),
	OPERATORS=QString("operators"),
	OUTPUT_FUNC=QString("output"),
	OWNER_COLUMN=QString("owner-col"),
	OWNER=QString("owner"),
	PAPER_CUSTOM_SIZE=QString("paper-custom-size"),
	PAPER_MARGIN=QString("paper-margin"),
	PAPER_ORIENTATION=QString("paper-orientation"),
	PAPER_TYPE=QString("paper-type"),
	PARAM_IN=QString("in"),
	PARAM_OUT=QString("out"),
	PARAM_VARIADIC=QString("variadic"),
	PARAMETER=QString("parameter"),
	PARAMETERS=QString("parameters"),
	PARENT=QString("parent"),
	PARENTS=QString("parents"),
	PARSABLE=QString("parsable"),
	PARTIAL_MATCH=QString("partial-match"),
	PASSWORD=QString("password"),
	PASSWORD_ENCRYPTION=QString("password-encryption"),
	PATH=QString("path"),
	PATTERNS=QString("patterns"),
	PER_ROW=QString("per-line"),
	PERMISSION=QString("permission"),
	PERMISSIVE=QString("permissive"),
	PGMODELER_VERSION=QString("pgmodeler-ver"),
	PGSQL_BASE_TYPE=QString("basetype"),
	PGSQL_VERSION=QString("pgsql-ver"),
	PLACEHOLDER=QString("placeholder"),
	PLACEHOLDERS=QString("placeholders"),
	PK_COL_PATTERN=QString("pk-col-pattern"),
	PK_COLUMN=QString("pk-column"),
	PK_CONSTR=QString("pk-constr"),
	PK_PATTERN=QString("pk-pattern"),
	POINTS=QString("points"),
	PORT=QString("port"),
	PORTRAIT=QString("portrait"),
	POSITION_INFO=QString("pos-info"),
	POSITION=QString("position"),
	PRECISION=QString("precision"),
	PREDICATE=QString("predicate"),
	PREFERRED=QString("preferred"),
	PREPEND_AT_BOD=QString("prepend-at-bod"),
	PREPENDED_SQL=QString("prepended-sql"),
	PRINT_GRID=QString("print-grid"),
	PRINT_PG_NUM=QString("print-pg-num"),
	PRIVILEGES_GOP=QString("privileges-gop"),
	PRIVILEGES=QString("privileges"),
	PROT_COLUMN=QString("prot-column"),
	PROTECTED=QString("protected"),
	RANGE_ATTRIBS=QString("range-attribs"),
	RANGE_TYPE=QString("range"),
	RECENT_MODELS=QString("recent-models"),
	RECENT=QString("recent"),
	RECT_VISIBLE=QString("rect-visible"),
	RECURSIVE=QString("recursive"),
	RECV_FUNC=QString("receive"),
	REDUCED_FORM=QString("reduced-form"),
	REF_COLUMN=QString("ref-column"),
	REF_ROLES=QString("ref-roles"),
	REF_TABLE=QString("ref-table"),
	REF_TYPE=QString("ref-type"),
	REFER=QString("refer"),
	REFERENCE=QString("reference"),
	REFERENCE_FK=QString("reference-fk"),
	REFERENCES_PRIV=QString("references"),
	REFERENCES=QString("references"),
	REFERRERS=QString("referrers"),
	REGULAR_EXP=QString("regexp"),
	RELATION_TAB_VIEW=QString("reltv"),
	RELATIONSHIP_11=QString("rel11"),
	RELATIONSHIP_1N=QString("rel1n"),
	RELATIONSHIP_DEP=QString("reldep"),
	RELATIONSHIP_FK=QString("relfk"),
	RELATIONSHIP_GEN=QString("relgen"),
	RELATIONSHIP_NN=QString("relnn"),
	RELATIONSHIP=QString("relationship"),
	RENAME=QString("rename"),
	REPLICATION=QString("replication"),
	RESTRICTION_FUNC=QString("restriction"),
	RESTART_SEQ=QString("restart-seq"),
	RETURN_TABLE=QString("return-table"),
	RETURN_TYPE=QString("return-type"),
	RETURNS_SETOF=QString("returns-setof"),
	REVOKE=QString("revoke"),
	RIGHT_TYPE=QString("right-type"),
	RIGHT=QString("right"),
	RLS_ENABLED=QString("rls-enabled"),
	RLS_FORCED=QString("rls-forced"),
	ROLE_TYPE=QString("role-type"),
	ROLE=QString("role"),
	ROLE_CURRENT_USER=QString("CURRENT_USER"),
	ROLE_SESSION_USER=QString("SESSION_USER"),
	ROLE_PUBLIC=QString("PUBLIC"),
	ROLES=QString("roles"),
	ROW_AMOUNT=QString("row-amount"),
	RULES=QString("rules"),
	SAVE_LAST_POSITION=QString("save-last-position"),
	SCHEMA=QString("schema"),
	SEARCH_PATH=QString("search-path"),
	SECURITY_TYPE=QString("security-type"),
	SELECT_EXP=QString("select-exp"),
	SELECT_PRIV=QString("select"),
	SELECT_OBJECTS=QString("select-objects"),
	SEND_FUNC=QString("send"),
	SEQUENCE=QString("sequence"),
	SERVER_ENCODING=QString("server-encoding"),
	SERVER_VERSION=QString("server-version"),
	SERVER_PID=QString("server-pid"),
	SERVER_PROTOCOL=QString("server-protocol"),
	SET_PERMS=QString("set-perms"),
	SHARED_OBJ=QString("shared-obj"),
	SHELL_TYPES=QString("shell-types"),
	SHOW_CANVAS_GRID=QString("show-canvas-grid"),
	SHOW_PAGE_DELIMITERS=QString("show-page-delimiters"),
	SHOW_ATTRIBUTES_GRID=QString("show-attributes-grid"),
	SHOW_SOURCE_PANE=QString("show-source-pane"),
	SHOW_MAIN_MENU=QString("show-main-menu"),
	SIGNATURE=QString("signature"),
	SIMPLE_EXP=QString("simple-exp"),
	SIMPLIFIED_OBJ_CREATION=QString("simplified-obj-creation"),
	SINGLE_PK_COLUMN=QString("single-pk-col"),
	SIZE=QString("size"),
	SNIPPET=QString("snippet"),
	SORT_OP=QString("sort-op"),
	SOURCE_EDITOR_APP=QString("source-editor-app"),
	SOURCE_EDITOR_ARGS=QString("source-editor-args"),
	SOURCE_TYPE=QString("source-type"),
	SRC_TYPE=QString("src-type"),
	SPATIAL_TYPE=QString("spatial-type"),
	SPECIAL_PK_COLS=QString("special-pk-cols"),
	SQL_DISABLED=QString("sql-disabled"),
	SQL_OBJECT=QString("sql-object"),
	SQL_VALIDATION=QString("sql-validation"),
	SQL_TOOL=QString("sqltool"),
	SRC_COL_PATTERN=QString("src-col-pattern"),
	SRC_COLUMNS=QString("src-columns"),
	SRC_ENCODING=QString("src-encoding"),
	SRC_FK_PATTERN=QString("src-fk-pattern"),
	SRC_LABEL=QString("src-label"),
	SRC_REQUIRED=QString("src-required"),
	SRC_TABLE=QString("src-table"),
	SRID=QString("srid"),
	SSL=QString("ssl"),
	SSL_CA_FILE=QString("ssl-ca-file"),
	SSL_CERT_FILE=QString("ssl-cert-file"),
	SSL_CRL_FILE=QString("ssl-crl-file"),
	SSL_KEY_FILE=QString("ssl-key-file"),
	START=QString("start"),
	STATE_TYPE=QString("state-type"),
	STORAGE_PARAMS=QString("stg-params"),
	STORAGE=QString("storage"),
	STRATEGY_NUM=QString("stg-number"),
	STYLE=QString("style"),
	STYLES=QString("styles"),
	SUBTYPE_DIFF_FUNC=QString("subtypediff"),
	SUBTYPE=QString("subtype"),
	SUPERUSER=QString("superuser"),
	SYMBOL=QString("symbol"),
	TABLE_BODY=QString("table-body"),
	TABLE_EXT_BODY=QString("table-ext-body"),
	TABLE_NAME=QString("table-name"),
	TABLE_OBJECT=QString("table-obj"),
	TABLE_SCHEMA_NAME=QString("table-schema-name"),
	TABLE_TITLE=QString("table-title"),
	TABLE_TYPE=QString("table-type"),
	TABLE=QString("table"),
	TABLESPACE=QString("tablespace"),
	TAG=QString("tag"),
	TEMPLATE_DB=QString("template"),
	TEMPORARY_PRIV=QString("temporary"),
	TOP=QString("top"),
	TPMOD_IN_FUNC=QString("tpmodin"),
	TPMOD_OUT_FUNC=QString("tpmodout"),
	TRANSITION_FUNC=QString("transition"),
	TRIGGER_FUNC=QString("trigger-func"),
	TRIGGER_PRIV=QString("trigger"),
	TRIGGERS=QString("triggers"),
	TRUNC_EVENT=QString("trunc-event"),
	TRUNCATE_CMDS=QString("truncate-cmds"),
	TRUNCATE_PRIV=QString("truncate"),
	TRUNCATE=QString("truncate"),
	TRUSTED=QString("trusted"),
	TYPE_ATTRIBUTE=QString("typeattrib"),
	TYPE_OID=QString("type-oid"),
	TYPE=QString("type"),
	TYPES=QString("types"),
	TYPE_CLASS=QString("type-class"),
	UI_LANGUAGE=QString("ui-language"),
	UNDERLINE=QString("underline"),
	UNIQUE=QString("unique"),
	UNLOGGED=QString("unlogged"),
	UNSET_PERMS=QString("unset-perms"),
	UNSET=QString("unset"),
	UPD_ACTION=QString("upd-action"),
	UPD_EVENT=QString("upd-event"),
	UPDATE_PRIV=QString("update"),
	UQ_COLUMN=QString("uq-column"),
	UQ_CONSTR=QString("uq-constr"),
	UQ_PATTERN=QString("uq-pattern"),
	USAGE_PRIV=QString("usage"),
	USE_CURVED_LINES=QString("use-curved-lines"),
	USE_PLACEHOLDERS=QString("use-placeholders"),
	USE_SORTING=QString("use-sorting"),
	USE_UNIQUE_NAMES=QString("use-unique-names"),
	USING_EXP=QString("using-exp"),
	VALIDATOR_FUNC=QString("validator"),
	VALIDATOR=QString("validator"),
	VALIDITY=QString("validity"),
	VALIDATION=QString("validation"),
	VALUE=QString("value"),
	VALUES=QString("values"),
	VARIABLE=QString("variable"),
	VARIATION=QString("variation"),
	VIEW_BODY=QString("view-body"),
	VIEW_EXT_BODY=QString("view-ext-body"),
	VIEW_NAME=QString("view-name"),
	VIEW_SCHEMA_NAME=QString("view-schema-name"),
	VIEW_TITLE=QString("view-title"),
	VISIBLE=QString("visible"),
	WIDGET=QString("widget"),
	WILDCARD=QString("wildcard"),
	WINDOW_FUNC=QString("window-func"),
	WITH_NO_DATA=QString("with-no-data"),
	WITH_TIMEZONE=QString("with-timezone"),
	WITHOUT_OIDS=QString("without-oids"),
	WORD_DELIMITERS=QString("word-delimiters"),
	WORD_SEPARATORS=QString("word-separators"),
	WORKING_DIR=QString("working-dir"),
	X_POS=QString("x"),
	Y_POS=QString("y");
}

