'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\"
.TH DS2415 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2415, DS1904, DS2417
\- 1-Wire Time Chip, 
RTC (real time clock) iButton,
1-Wire Time Chip with Interrupt
.SH SYNOPSIS
Real time clock.
.br
.B 24
[.]XXXXXXXXXXXX[XX][/[
.B date
|
.B flags
|
.B running
|
.B udate
|
.so man3/standard_mini.3so
]]
.PP
Clock with interrupts
.br
.B 27
[.]XXXXXXXXXXXX[XX][/[
.B date
|
.B enable
|
.B interval
|
.B itime
|
.B running
|
.B udate
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 24
DS2415 DS1904
.TP
.I 27
DS2417
.SH SPECIAL PROPERTIES
.SS date
.I read-write, ascii
.br
26 character date representation of the
.I counter
value. Increments once per second while
.I running
.br
Setting
.I date
to a null string will put the current system time.
.br
Accepted date formats are:
.br
  Sat[urday] March 12 12:23:59 2001
.br
  Apr[il] 4 9:34:56 2002
.br
  3/23/04 23:34:57
.br
  current locale setting (your system's format)
.SS enable
.I read-write, yes-no
.br
State of the timer interrupt. 0=off 1=running.
.SS interval
.I read-write, unsigned integer
.br
Interval between timer interrupts. Values: 0-7. See table under
.I DESCRIPTION
for interpretation.
.I itime
will reflect the
.I interval
chosen.
.SS itime
.I read-write, unsigned integer
.br
Interval between timer interrupts. Value in seconds. See table under
.I DESCRIPTION
for interpretation and acceptable values.
.I interval
will reflect the
.I itime
chosen.
.SS flags
.I read-write, unsigned integer
.br
General use data. 4 bits (0-15 accepted values).
.SS running
.I read-write, yes-no
.br
State of the clock. 0=off 1=running.
.SS udate
.I read-write, unsigned integer
.br
Time represented as a number.
.I udate
increments once per second, while
.I running
is on.
.br
Usually set to unix time standard: number of seconds since Jan 1, 1970. The
.I date
field will be the unix representation of
.I udate
and setting either will change the other.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None implemented.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2415 DS1904
The
.B DS2415 (3)
and
.B DS1904 (3)
are simple clocks that can be read on the 1-wire bus. They can also be used the time an event, for remote confirmation.
.P
.SS DS2417
The
.B DS2417
has the same clock function, but also includes a programmable interval interrupt. Values Allowed are:
.br
0 1sec
.br
1 4sec
.br
2 32s = .5m
.br
3 6 = 1m
.br
4 2048s = .5h
.br
5 4096s = 1h
.br
6 65536s = 18h
.br
7 131072s = 36h
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2415.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS1904.pdf
.br
http://pdfserv.maxim-ic.com/en/ds/DS2417.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
