// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#include <V3d_PositionalLight.hxx>

IMPLEMENT_STANDARD_RTTIEXT(V3d_PositionalLight,V3d_PositionLight)

// =======================================================================
// function : V3d_PositionalLight
// purpose  :
// =======================================================================
V3d_PositionalLight::V3d_PositionalLight (const gp_Pnt& thePos,
                                          const Quantity_Color& theColor)
: V3d_PositionLight (Graphic3d_TOLS_POSITIONAL, Handle(V3d_Viewer)())
{
  SetColor (theColor);
  SetPosition (thePos);
}

// =======================================================================
// function : V3d_PositionalLight
// purpose  :
// =======================================================================
V3d_PositionalLight::V3d_PositionalLight (const Handle(V3d_Viewer)& theViewer,
                                          const Standard_Real theX,
                                          const Standard_Real theY,
                                          const Standard_Real theZ,
                                          const Quantity_Color& theColor,
                                          const Standard_Real theConstAttenuation,
                                          const Standard_Real theLinearAttenuation)
: V3d_PositionLight (Graphic3d_TOLS_POSITIONAL, theViewer)
{
  SetColor (theColor);
  SetPosition (theX, theY, theZ);
  SetAttenuation ((float )theConstAttenuation, (float )theLinearAttenuation);
}
