---
title: PostgreSQL JDBC Driver 42.1.2 Released
date: 2017-07-12 18:11:06 +0300
categories:
  - new_release
version: 42.1.2
---
**Notable changes**

### Changed
- Better logic for *returning* keyword detection. Previously, pgjdbc could be defeated by column names that contain *returning*, so pgjdbc failed to "return generated keys" as it considered statement as already having *returning* keyword [PR 824](https://github.com/pgjdbc/pgjdbc/pull/824) [201daf1d](https://github.com/pgjdbc/pgjdbc/commit/201daf1dc916bbc35e2bbec961aebfd1b1e30bfc) 
- Use server-prepared statements for batch inserts when prepareThreshold>0. Note: this enables batch to use server-prepared from the first *executeBatch()* execution (previously it waited for *prepareThreshold* *executeBatch()* calls) [abc3d9d7](https://github.com/pgjdbc/pgjdbc/commit/abc3d9d7f34a001322fbbe53f25d5e77a33a667f)

### Fixed
- Replication API: fix issue in #834 setting statusIntervalUpdate causes high CPU load. [PR 835](https://github.com/pgjdbc/pgjdbc/pull/835) [59236b74](https://github.com/pgjdbc/pgjdbc/commit/59236b74acdd400d9d91d3eb2bb07d70b15392e5)

### Regressions
- NPE in PreparedStatement.executeBatch in case of empty batch. Fixed in 42.1.3

<!--more-->

**Commits by author**

AlexElin (1):

* refactor: make PSQLState as enum [PR 837](https://github.com/pgjdbc/pgjdbc/pull/837) [fb5df7fe](https://github.com/pgjdbc/pgjdbc/commit/fb5df7fee1d3568356e680c6ac5a62336ec7bf6e)

Dave Cramer (8):

* Initial support of partitioned tables via JDBC metadata API [PR 823](https://github.com/pgjdbc/pgjdbc/pull/823) [9c3471f2](https://github.com/pgjdbc/pgjdbc/commit/9c3471f21f6ac9cf1a5e5700115ac7d0d55e0ad9)
* fix javadoc complaints and some small edits to replication comments [PR 832](https://github.com/pgjdbc/pgjdbc/pull/832) [2d0bfceb](https://github.com/pgjdbc/pgjdbc/commit/2d0bfcebb0641ddb73d9297e6211f75537238b15)
* fix issue #834 setting statusIntervalUpdate causes high CPU load \ [PR 835](https://github.com/pgjdbc/pgjdbc/pull/835) [59236b74](https://github.com/pgjdbc/pgjdbc/commit/59236b74acdd400d9d91d3eb2bb07d70b15392e5)
* fix issue #838 make sure we don't get columns that are dropped [PR 840](https://github.com/pgjdbc/pgjdbc/pull/840) [464a2d43](https://github.com/pgjdbc/pgjdbc/commit/464a2d43519004174f1b530a595ee0ad9ffda870)
* add missing connection documentation, fix spelling [PR 846](https://github.com/pgjdbc/pgjdbc/pull/846) [cd400f6f](https://github.com/pgjdbc/pgjdbc/commit/cd400f6f39d3c062fc94fa97b33b4d272a829a24)
* more spelling mistakes for preferQueryMode [PR 850](https://github.com/pgjdbc/pgjdbc/pull/850) [73bc3c1b](https://github.com/pgjdbc/pgjdbc/commit/73bc3c1b7acda676f366631ff7e28f09a3399f37)
* fix formatting of section on failover, still not perfect but better [PR 852](https://github.com/pgjdbc/pgjdbc/pull/852) [9f722014](https://github.com/pgjdbc/pgjdbc/commit/9f72201458d1ce0837e9525d947dcea2828b9475)
* small reformat to clarify read and write connections [PR 854](https://github.com/pgjdbc/pgjdbc/pull/854) [551d71b6](https://github.com/pgjdbc/pgjdbc/commit/551d71b6a513c223d8d8d8d75afbe8b5d42ce783)

Jorge Solorzano (3):

* test: yet another rename to use "lsn" not "location" in Pg10. [PR 822](https://github.com/pgjdbc/pgjdbc/pull/822) [90228621](https://github.com/pgjdbc/pgjdbc/commit/902286212df19b1eda9310c4174756786ad249c7)
* use zulu-9 [PR 828](https://github.com/pgjdbc/pgjdbc/pull/828) [4ac74886](https://github.com/pgjdbc/pgjdbc/commit/4ac74886e54e7689035be00c417a536717a45318)
* fix: remove type name from cast exception of getBoolean and setObject [PR 781](https://github.com/pgjdbc/pgjdbc/pull/781) [394b3a2f](https://github.com/pgjdbc/pgjdbc/commit/394b3a2f4d93e9ca701d8c31b4b66fa25fca8945)

Robert 'Bobby' Zenz (1):

* fix: Add fallback to setObject(int, Object) for Number [PR 812](https://github.com/pgjdbc/pgjdbc/pull/812) [5b9edb7d](https://github.com/pgjdbc/pgjdbc/commit/5b9edb7dfb1b281bffedf7c9f2583f2df354c0ea)

Vladimir Gordiychuk (1):

* bug: floating logical replcation test [PR 829](https://github.com/pgjdbc/pgjdbc/pull/829) [2d3e8972](https://github.com/pgjdbc/pgjdbc/commit/2d3e8972a0b34106a8b7426619cabf852c38ddaa)

Vladimir Sitnikov (7):

* chore: implement a script to stage pgjdbc, pgdjbc-jre7, pgjdbc-jre6 artifacts [15d78839](https://github.com/pgjdbc/pgjdbc/commit/15d7883987d2de4b662aa8cd81c6de5be0257153)
* doc: fix 42.1.0.jre8->jre6 typo [PR 42](https://github.com/pgjdbc/pgjdbc/pull/42) [88942b58](https://github.com/pgjdbc/pgjdbc/commit/88942b58637afbea16102a6a77d922914fd27562)
* fix: use server-prepared statements for batch inserts when prepareThreshold>0 [abc3d9d7](https://github.com/pgjdbc/pgjdbc/commit/abc3d9d7f34a001322fbbe53f25d5e77a33a667f)
* fix: better parsing for returning keyword [PR 824](https://github.com/pgjdbc/pgjdbc/pull/824) [201daf1d](https://github.com/pgjdbc/pgjdbc/commit/201daf1dc916bbc35e2bbec961aebfd1b1e30bfc)
* docs: build index, changelog pages from _posts/... to reduce release overhead [d6fe07d7](https://github.com/pgjdbc/pgjdbc/commit/d6fe07d7bb613d7b8fb06ace64b9b37d3f23bbfe)
* chore: make ./release\_notes.sh create docs/\_posts/$DATE\_YMD-$VERS-release.md file [e00d4571](https://github.com/pgjdbc/pgjdbc/commit/e00d4571bb6ca24c8f93956b59fd1c9a14131394)
* docs: add 42.1.2 release notes [6f127a61](https://github.com/pgjdbc/pgjdbc/commit/6f127a61eed5317133ea80f0a06f9441b170a17a)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[AlexElin](https://github.com/AlexElin)  
[Dave Cramer](davec@postgresintl.com)  
[Jorge Solorzano](https://github.com/jorsol)  
[Robert 'Bobby' Zenz](https://github.com/RobertZenz)  
[Vladimir Gordiychuk](https://github.com/Gordiychuk)  
[Vladimir Sitnikov](https://github.com/vlsi)  
