/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class UnparsedEntity
extends SystemFunction
implements XSLTFunction {
    public static int URI = 0;
    public static int PUBLIC_ID = 1;

    public Expression simplify() throws XPathException {
        UnparsedEntity unparsedEntity = (UnparsedEntity)super.simplify();
        unparsedEntity.addContextDocumentArgument(1, this.getName() + "+");
        return unparsedEntity;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String[] stringArray;
        String string = this.argument[0].evaluateItem(xPathContext).getStringValue();
        Item item = this.argument[1].evaluateItem(xPathContext);
        if (!(item instanceof DocumentInfo)) {
            this.dynamicError("In function " + this.getName() + ", the context node must be in a tree whose root is a document node");
        }
        if ((stringArray = ((DocumentInfo)item).getUnparsedEntity(string)) == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(stringArray[this.operation]);
    }
}

