/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.widget;

public class GridCell {

    private int row = 0;
    private int col = 0;
    
    public GridCell() {
        this(0, 0);
    }
    
    public GridCell(int row, int col) {
        
        this.row = row;
        this.col = col;
    }
    
    public void setRow(int row) {
        this.row = row;
    }
    
    public int getRow() {
        return row;
    }
    
    public void setCol(int col) {
        this.col = col;
    }
    
    public int getCol() {
        return col;
    }

    public int incrRow() {
        row++;
        return row - 1;
    }
    
    public int nextRow() {
        col = 0;
        return incrRow();
    }
    
    public int incrCol(int incr) {
        col += incr;
        return col - incr;
    }

    public int incrCol() {
        return incrCol(1);
    }

    public void resetCol() {
        col = 0;
    }
}
