!{\src2tex{textfont=tt}}
!!****m* etsf_dielectric/etsf_io_dielectric_put
!! NAME
!!  etsf_io_dielectric_put
!!
!! FUNCTION
!!    Write data related to the given group in an opened ETSF file (it must be in
!!    write mode, use etsf_io_low_set_write_mode() to change it).
!!    Only associated pointers of argument @folder will be accessed. If any errors
!!    occurs it returns with @lstat = .false..
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     integer returned by an 'open' NetCDF call. The file can be 
!!     either in define or write mode. This status can be changed
!!     by the call.
!! * folder <type(etsf_dielectric)> = 
!!     an allocated structure with pointers on allocated areas in memory.
!!     These areas will be read or written if the pointer is associated, if
!!     not, the variable will be ignored. It is possible to access to specific
!!     dimensions of a variable using the <short_var_name>__kpoint_access or
!!     <short_var_name>__spin_access of this @folder structure. The 
!!     <short_var_name>__number_of_<something> can also been set if only a subpart
!!     in one dimension should be accessed (this is possible when the specifications
!!     have been declared with a max_number_of_<something>.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_dielectric_put(ncid, folder, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid
  type(etsf_dielectric), intent(in) :: folder
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_dielectric_put'
  integer,allocatable :: varid(:)
  integer,allocatable :: start(:)
  integer,allocatable :: count(:)
  integer :: len
  character(etsf_charlen) :: flag


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_dielectric_put : enter'
!ENDDEBUG

  
  allocate(varid(19))
  ! Begin by putting the file in write mode.
  call etsf_io_low_set_write_mode(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  if (associated(folder%frequencies_dielectric_function)) then
    call etsf_io_low_write_var(ncid, "frequencies_dielectric_function", &
                            & folder%frequencies_dielectric_function, &
                            & lstat, ncvarid = varid(1), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%qpoints_dielectric_function)) then
    call etsf_io_low_write_var(ncid, "qpoints_dielectric_function", &
                            & folder%qpoints_dielectric_function, &
                            & lstat, ncvarid = varid(2), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (associated(folder%qpoints_gamma_limit)) then
    call etsf_io_low_write_var(ncid, "qpoints_gamma_limit", &
                            & folder%qpoints_gamma_limit, &
                            & lstat, ncvarid = varid(3), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%dielectric_function)) then
    call etsf_io_low_write_var(ncid, "dielectric_function", &
                            & folder%dielectric_function, &
                            & lstat, ncvarid = varid(4), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%dielectric_function_head)) then
    call etsf_io_low_write_var(ncid, "dielectric_function_head", &
                            & folder%dielectric_function_head, &
                            & lstat, ncvarid = varid(5), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%dielectric_function_lower_wing)) then
    call etsf_io_low_write_var(ncid, "dielectric_function_lower_wing", &
                            & folder%dielectric_function_lower_wing, &
                            & lstat, ncvarid = varid(6), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%dielectric_function_upper_wing)) then
    call etsf_io_low_write_var(ncid, "dielectric_function_upper_wing", &
                            & folder%dielectric_function_upper_wing, &
                            & lstat, ncvarid = varid(7), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_dielectric_function)) then
    call etsf_io_low_write_var(ncid, "inverse_dielectric_function", &
                            & folder%inverse_dielectric_function, &
                            & lstat, ncvarid = varid(8), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_dielectric_function_head)) then
    call etsf_io_low_write_var(ncid, "inverse_dielectric_function_head", &
                            & folder%inverse_dielectric_function_head, &
                            & lstat, ncvarid = varid(9), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_dielectric_function_lower_wing)) then
    call etsf_io_low_write_var(ncid, "inverse_dielectric_function_lower_wing", &
                            & folder%inverse_dielectric_function_lower_wing, &
                            & lstat, ncvarid = varid(10), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_dielectric_function_upper_wing)) then
    call etsf_io_low_write_var(ncid, "inverse_dielectric_function_upper_wing", &
                            & folder%inverse_dielectric_function_upper_wing, &
                            & lstat, ncvarid = varid(11), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%polarizability)) then
    call etsf_io_low_write_var(ncid, "polarizability", &
                            & folder%polarizability, &
                            & lstat, ncvarid = varid(12), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%polarizability_head)) then
    call etsf_io_low_write_var(ncid, "polarizability_head", &
                            & folder%polarizability_head, &
                            & lstat, ncvarid = varid(13), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%polarizability_lower_wing)) then
    call etsf_io_low_write_var(ncid, "polarizability_lower_wing", &
                            & folder%polarizability_lower_wing, &
                            & lstat, ncvarid = varid(14), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%polarizability_upper_wing)) then
    call etsf_io_low_write_var(ncid, "polarizability_upper_wing", &
                            & folder%polarizability_upper_wing, &
                            & lstat, ncvarid = varid(15), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_polarizability)) then
    call etsf_io_low_write_var(ncid, "inverse_polarizability", &
                            & folder%inverse_polarizability, &
                            & lstat, ncvarid = varid(16), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_polarizability_head)) then
    call etsf_io_low_write_var(ncid, "inverse_polarizability_head", &
                            & folder%inverse_polarizability_head, &
                            & lstat, ncvarid = varid(17), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_polarizability_lower_wing)) then
    call etsf_io_low_write_var(ncid, "inverse_polarizability_lower_wing", &
                            & folder%inverse_polarizability_lower_wing, &
                            & lstat, ncvarid = varid(18), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  if (etsf_io_low_var_associated(folder%inverse_polarizability_upper_wing)) then
    call etsf_io_low_write_var(ncid, "inverse_polarizability_upper_wing", &
                            & folder%inverse_polarizability_upper_wing, &
                            & lstat, ncvarid = varid(19), &
                            & error_data = error_data)
    if (.not. lstat) then
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
  end if
  
  deallocate(varid)

!DEBUG
!write (*,*) 'etsf_io_dielectric_put : exit'
!ENDDEBUG

end subroutine etsf_io_dielectric_put
!!***
