/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.NJTree;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.util.Comparison;
import jalview.util.QuickSort;
import java.util.Vector;

public class AlignmentSorter {
    static boolean sortIdAscending = true;
    static int lastGroupHash = 0;
    static boolean sortGroupAscending = true;
    static AlignmentOrder lastOrder = null;
    static boolean sortOrderAscending = true;
    static NJTree lastTree = null;
    static boolean sortTreeAscending = true;
    private static String lastSortByScore;

    public static void sortByPID(AlignmentI align, SequenceI s, SequenceI[] tosort) {
        int nSeq = align.getHeight();
        float[] scores = new float[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            scores[i] = Comparison.PID(align.getSequenceAt(i).getSequenceAsString(), s.getSequenceAsString());
            seqs[i] = align.getSequenceAt(i);
        }
        QuickSort.sort(scores, 0, scores.length - 1, seqs);
        AlignmentSorter.setReverseOrder(align, (SequenceI[])seqs);
    }

    private static void setReverseOrder(AlignmentI align, SequenceI[] seqs) {
        int nSeq = seqs.length;
        int len = 0;
        len = nSeq % 2 == 0 ? nSeq / 2 : (nSeq + 1) / 2;
        for (int i = 0; i < len; ++i) {
            align.getSequences().setElementAt(seqs[nSeq - i - 1], i);
            align.getSequences().setElementAt(seqs[i], nSeq - i - 1);
        }
    }

    private static void setOrder(AlignmentI align, Vector tmp) {
        AlignmentSorter.setOrder(align, AlignmentSorter.vectorSubsetToArray(tmp, align.getSequences()));
    }

    public static void setOrder(AlignmentI align, SequenceI[] seqs) {
        int i;
        Vector algn = align.getSequences();
        Vector<SequenceI> tmp = new Vector<SequenceI>();
        for (i = 0; i < seqs.length; ++i) {
            if (!algn.contains(seqs[i])) continue;
            tmp.addElement(seqs[i]);
        }
        algn.removeAllElements();
        for (i = 0; i < tmp.size(); ++i) {
            algn.addElement(tmp.elementAt(i));
        }
    }

    public static void sortByID(AlignmentI align) {
        int nSeq = align.getHeight();
        String[] ids = new String[nSeq];
        Object[] seqs = new SequenceI[nSeq];
        for (int i = 0; i < nSeq; ++i) {
            ids[i] = align.getSequenceAt(i).getName();
            seqs[i] = align.getSequenceAt(i);
        }
        QuickSort.sort(ids, seqs);
        if (sortIdAscending) {
            AlignmentSorter.setReverseOrder(align, (SequenceI[])seqs);
        } else {
            AlignmentSorter.setOrder(align, (SequenceI[])seqs);
        }
        sortIdAscending = !sortIdAscending;
    }

    public static void sortByGroup(AlignmentI align) {
        Vector<SequenceGroup> groups = new Vector<SequenceGroup>();
        if (groups.hashCode() != lastGroupHash) {
            sortGroupAscending = true;
            lastGroupHash = groups.hashCode();
        } else {
            sortGroupAscending = !sortGroupAscending;
        }
        for (int i = 0; i < align.getGroups().size(); ++i) {
            SequenceGroup sg = (SequenceGroup)align.getGroups().elementAt(i);
            for (int j = 0; j < groups.size(); ++j) {
                SequenceGroup sg2 = (SequenceGroup)groups.elementAt(j);
                if (sg.getSize() <= sg2.getSize()) continue;
                groups.insertElementAt(sg, j);
                break;
            }
            if (groups.contains(sg)) continue;
            groups.addElement(sg);
        }
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < groups.size(); ++i) {
            SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
            SequenceI[] orderedseqs = sg.getSequencesInOrder(align);
            for (int j = 0; j < orderedseqs.length; ++j) {
                seqs.addElement(orderedseqs[j]);
            }
        }
        if (sortGroupAscending) {
            AlignmentSorter.setOrder(align, seqs);
        } else {
            AlignmentSorter.setReverseOrder(align, AlignmentSorter.vectorSubsetToArray(seqs, align.getSequences()));
        }
    }

    private static SequenceI[] vectorToArray(Vector tmp) {
        SequenceI[] seqs = new SequenceI[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            seqs[i] = (SequenceI)tmp.elementAt(i);
        }
        return seqs;
    }

    private static SequenceI[] vectorSubsetToArray(Vector tmp, Vector mask) {
        int i;
        Vector seqs = new Vector();
        boolean[] tmask = new boolean[mask.size()];
        for (i = 0; i < mask.size(); ++i) {
            tmask[i] = true;
        }
        for (i = 0; i < tmp.size(); ++i) {
            Object sq = tmp.elementAt(i);
            if (!mask.contains(sq) || !tmask[mask.indexOf(sq)]) continue;
            tmask[mask.indexOf(sq)] = false;
            seqs.addElement(sq);
        }
        for (i = 0; i < tmask.length; ++i) {
            if (!tmask[i]) continue;
            seqs.addElement(mask.elementAt(i));
        }
        return AlignmentSorter.vectorToArray(seqs);
    }

    public static void sortBy(AlignmentI align, AlignmentOrder order) {
        Vector tmp = order.getOrder();
        sortOrderAscending = lastOrder == order ? !sortOrderAscending : true;
        if (sortOrderAscending) {
            AlignmentSorter.setOrder(align, tmp);
        } else {
            AlignmentSorter.setReverseOrder(align, AlignmentSorter.vectorSubsetToArray(tmp, align.getSequences()));
        }
    }

    private static Vector getOrderByTree(AlignmentI align, NJTree tree) {
        int nSeq = align.getHeight();
        Vector tmp = new Vector();
        tmp = AlignmentSorter._sortByTree(tree.getTopNode(), tmp, align.getSequences());
        if (tmp.size() != nSeq) {
            if (tmp.size() < nSeq) {
                AlignmentSorter.addStrays(align, tmp);
            }
            if (tmp.size() != nSeq) {
                System.err.println("ERROR: tmp.size()=" + tmp.size() + " != nseq=" + nSeq + " in getOrderByTree");
            }
        }
        return tmp;
    }

    public static void sortByTree(AlignmentI align, NJTree tree) {
        Vector tmp = AlignmentSorter.getOrderByTree(align, tree);
        if (lastTree != tree) {
            sortTreeAscending = true;
            lastTree = tree;
        } else {
            boolean bl = sortTreeAscending = !sortTreeAscending;
        }
        if (sortTreeAscending) {
            AlignmentSorter.setOrder(align, tmp);
        } else {
            AlignmentSorter.setReverseOrder(align, AlignmentSorter.vectorSubsetToArray(tmp, align.getSequences()));
        }
    }

    private static void addStrays(AlignmentI align, Vector seqs) {
        int nSeq = align.getHeight();
        for (int i = 0; i < nSeq; ++i) {
            if (seqs.contains(align.getSequenceAt(i))) continue;
            seqs.addElement(align.getSequenceAt(i));
        }
        if (nSeq != seqs.size()) {
            System.err.println("ERROR: Size still not right even after addStrays");
        }
    }

    private static Vector _sortByTree(SequenceNode node, Vector tmp, Vector seqset) {
        if (node == null) {
            return tmp;
        }
        SequenceNode left = (SequenceNode)node.left();
        SequenceNode right = (SequenceNode)node.right();
        if (left == null && right == null) {
            if (!node.isPlaceholder() && node.element() != null && node.element() instanceof SequenceI && !tmp.contains(node.element())) {
                tmp.addElement((SequenceI)node.element());
            }
            return tmp;
        }
        AlignmentSorter._sortByTree(left, tmp, seqset);
        AlignmentSorter._sortByTree(right, tmp, seqset);
        return tmp;
    }

    public static void recoverOrder(SequenceI[] alignment) {
        float[] ids = new float[alignment.length];
        for (int i = 0; i < alignment.length; ++i) {
            ids[i] = new Float(alignment[i].getName().substring(8)).floatValue();
        }
        QuickSort.sort(ids, (Object[])alignment);
    }

    public static void sortByAnnotationScore(String scoreLabel, AlignmentI alignment) {
        int i;
        Object[] seqs = alignment.getSequencesArray();
        boolean[] hasScore = new boolean[seqs.length];
        int hasScores = 0;
        double[] scores = new double[seqs.length];
        double min = 0.0;
        double max = 0.0;
        for (i = 0; i < seqs.length; ++i) {
            AlignmentAnnotation[] scoreAnn = seqs[i].getAnnotation(scoreLabel);
            if (scoreAnn != null) {
                hasScore[i] = true;
                scores[i] = scoreAnn[0].getScore();
                if (++hasScores == 1) {
                    max = min = scores[i];
                    continue;
                }
                if (max < scores[i]) {
                    max = scores[i];
                }
                if (!(min > scores[i])) continue;
                min = scores[i];
                continue;
            }
            hasScore[i] = false;
        }
        if (hasScores == 0) {
            return;
        }
        if (hasScores < seqs.length) {
            for (i = 0; i < seqs.length; ++i) {
                if (hasScore[i]) continue;
                scores[i] = max + (double)i;
            }
        }
        QuickSort.sort(scores, seqs);
        if (lastSortByScore != scoreLabel) {
            lastSortByScore = scoreLabel;
            AlignmentSorter.setOrder(alignment, (SequenceI[])seqs);
        } else {
            AlignmentSorter.setReverseOrder(alignment, (SequenceI[])seqs);
        }
    }
}

