#ifndef DPKGREPAIRWIDGET_H
#define DPKGREPAIRWIDGET_H

#include "../../src/repairtoolsproxy.h"

#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QTextEdit>

#include <DSpinner>
#include <dcommandlinkbutton.h>

DWIDGET_USE_NAMESPACE

class DPKGRepairWidget : public QWidget
{
    Q_OBJECT

public:
    explicit DPKGRepairWidget(QWidget *parent = nullptr);

    void setToolsProxy(RepairToolsProxy *proxy) { m_toolsProxy = proxy; }

protected:
    void showEvent(QShowEvent *e);
    void changeEvent(QEvent* event) override;

private slots:
    void reset();
    void onRepairClicked();
    void onRepairFinished(const bool success);
    void showDetail();
    void hideDetail();

private:
    RepairToolsProxy *m_toolsProxy;
    QTextEdit *m_output;
    QLabel *m_icon;
    QLabel *m_tips;
    QLabel *m_result;
    DSpinner *m_spinner;
    DCommandLinkButton *m_showDetail;
    DCommandLinkButton *m_hideDetail;
    QPushButton *m_repairButton;
    QPushButton *m_okButton;
    QString m_resultText;
};

#endif // DPKGREPAIRWIDGET_H
