/*
 * Copyright (C) 2019 ~ 2020 Deepin Technology Co., Ltd.
 *
 * Author:     Kevin.Guan <allmemory@vip.qq.com>
 *             caowei <zhtqs8@163.com>
 *
 * Maintainer: Kevin.Guan <allmemory@vip.qq.com>
 *             caowei <zhtqs8@163.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QCoreApplication>
#include <QSharedMemory>
#include <QDebug>
#include "preload/cpreload.h"
#include "preload/monitor_thread.h"
#include <QDBusConnection>
#include <DLog>
#include <QDBusError>
#include <signal.h>

DCORE_USE_NAMESPACE

const QString APPORG = QString("uniontech");
const QString APPNAME = QString("dde-preload");
const QString APPVER = QString("V1.0");
static QSharedPointer<QSharedMemory> sh_memory;
static MonitorThread* sh_monitor=nullptr;

int fork_parent(int argc, char *argv[])
{
    QCoreApplication app(argc, argv);
    return app.exec();
}

int fork_child(int argc, char *argv[])
{
    QCoreApplication app(argc, argv);

    DLogManager::registerConsoleAppender();
    DLogManager::registerFileAppender();

    //程序信息
    app.setOrganizationName(APPORG);
    app.setApplicationName(APPNAME);
    app.setApplicationVersion(APPVER);

    //防止程序多开
    sh_memory.reset(new QSharedMemory(QCoreApplication::applicationName()));
#ifdef QT_DEBUG
    if (sh_memory->attach()) {
        qInfo() << "release last shared memory.";
        sh_memory->detach();
    }
#else
    if (sh_memory->attach()) {
        qDebug() << "Open Another Instance is forbidden";
        return -1;
    }
#endif
    int iexec = 0;
    if (sh_memory->create(1)) {
        //程序开始运行
        sh_monitor = new MonitorThread;
        cPreLoad p;
        QDBusConnection conn = QDBusConnection::sessionBus();

        bool bok = conn.registerService(DDE_PRELOAD_NAME);
        if (!bok) {
            QDBusError err = conn.lastError();
            qWarning() << "dde-preload register service " << DDE_PRELOAD_NAME << "fail. " << err.name() << ", " << err.message();
            return -1;
        }
        bok = conn.registerObject(DDE_PRELOAD_PATH, &p, QDBusConnection::RegisterOption::ExportAllContents);
        if (!bok) {
            QDBusError err = conn.lastError();
            qWarning() << "dde-preload register object " << DDE_PRELOAD_NAME << "fail. " << err.name() << ", " << err.message();
            return -1;
        }
        qInfo() << "dde-preload started!";
        iexec = app.exec();
    } else {
        qCritical() << "cannot create share memory. code: " << sh_memory->error() << ", " << sh_memory->errorString();
    }
    sh_memory->detach();
    sh_memory.reset();
    return iexec;
}

void on_exit()
{
    qInfo() << "terminated.";
}

void on_signal_term(int isignal)
{
    qInfo() << "received terminate signal. " << isignal;
    if (sh_monitor) {
        sh_monitor->quit();
        sh_monitor->deleteLater();
        sh_monitor = nullptr;
    }
    if (sh_memory) {
        sh_memory->detach();
        sh_memory.reset();
    }
    exit(0);
}

int main(int argc, char *argv[])
{
    signal(SIGTERM, on_signal_term);
    signal(SIGKILL, on_signal_term);
    signal(SIGQUIT, on_signal_term);
    signal(SIGINT, on_signal_term);

    return fork_child(argc, argv);
}
