/*
 * Copyright (C) 2011 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *
 * Maintainer: sbw <sbw@sbw.so>
 *             kirigaya <kirigaya@mkacg.com>
 *             Hualet <mr.asianwang@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef KEYLABEL_H
#define KEYLABEL_H

#ifdef WINDOW_MODE

#include <QWidget>

class KeyLabel : public QWidget
{
    Q_OBJECT
public:
    explicit KeyLabel(const QString &text, QWidget *parent = nullptr);

    void setEnter(const bool enter);

protected:
    void paintEvent(QPaintEvent *event) Q_DECL_OVERRIDE;

private:
    bool m_isEnter;
    QString m_text;
};

#else

#include <QLabel>

class KeyLabel : public QLabel
{
    Q_OBJECT
public:
    explicit KeyLabel(QWidget *parent = nullptr);
    explicit KeyLabel(const QString &text, QWidget *parent = nullptr);

    void setEnter(const bool enter);

protected:
    void paintEvent(QPaintEvent *event) Q_DECL_OVERRIDE;

private:
    bool m_isEnter;
};

#endif

#endif // KEYLABEL_H
